/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphCycleFinder;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;

class ClassesNode
extends CodeNode {
    static final String NODE_ID_SUFFIX = ".[package]";
    private final JavaPackage javaPackage;
    static final String UI_CHILD_PACKAGE_ICON_NAME = "code_classes";
    static final String UI_SAME_PACKAGE_ICON_NAME = "code_same_package_classes";
    private final boolean samePackage;

    public ClassesNode(JavaPackage javaPackage, CodeMap map, String name, boolean samePackage, int groupIndex) {
        super(map, groupIndex);
        this.javaPackage = javaPackage;
        this.samePackage = samePackage;
        this.setIdWithIndex(javaPackage.getName() + NODE_ID_SUFFIX);
        long classCount = this.getClasses().filter(jc -> ClassesNode.isNamed(jc)).count();
        this.setText(name + ClassesNode.formatClassCount(classCount));
        this.initializeChildNodes();
    }

    @Override
    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return this.javaPackage.getAnnotations();
    }

    private Stream<JavaClass> getClasses() {
        return this.javaPackage.getClasses().stream().filter(this::belongsToSameGroup);
    }

    @Override
    HasName getCodeElement() {
        return this.javaPackage;
    }

    private void initializeChildNodes() {
        List children = super.getChildrenInternal();
        List classes = this.getClasses().collect(Collectors.toList());
        if (!classes.isEmpty()) {
            ClassNode node;
            GraphNodeSort<JavaClass> nodeSort = new GraphNodeSort<JavaClass>();
            for (JavaClass javaClass : classes) {
                JavaClass edgeStart = ClassesNode.findEnclosingNamedClass(javaClass);
                nodeSort.addNode(edgeStart);
                DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
                Map<JavaClass, Long> dependencies = javaClass.getDirectDependenciesFromSelf().stream().filter(dep -> this.goesOutsideEnclosingOriginClass(edgeStart, (Dependency)dep)).map(filter::knownDependency).filter(CodeNode::classesBelongToTheSamePackage).filter(dep -> this.belongsToSameGroup(dep.getTargetClass())).collect(Collectors.groupingBy(CodeNode::getTargetNodeClass, Collectors.counting()));
                dependencies.entrySet().stream().forEach(e -> nodeSort.addEdge(edgeStart, (JavaClass)e.getKey(), ((Long)e.getValue()).longValue()));
            }
            HashMap<JavaClass, ClassNode> nodes = new HashMap<JavaClass, ClassNode>();
            List<List<JavaClass>> orderedClasses = nodeSort.sortNodes(Comparator.comparing(HasName::getName), SubgroupComparator.comparingByName(HasName::getName));
            for (int subgroupIndex = 0; subgroupIndex < orderedClasses.size(); ++subgroupIndex) {
                for (JavaClass childClass : orderedClasses.get(subgroupIndex)) {
                    node = new ClassNode(childClass, this.getMap(), this.groupIndex);
                    nodes.put(childClass, node);
                    children.add(node);
                    node.setParent(this);
                }
            }
            for (JavaClass javaClass : classes) {
                JavaClass enclosingClass = ClassesNode.findEnclosingNamedClass(javaClass);
                node = (ClassNode)((Object)nodes.get(enclosingClass));
                node.registerInnerClass(javaClass);
            }
        }
    }

    private boolean goesOutsideEnclosingOriginClass(JavaClass edgeStart, Dependency dependency) {
        return ClassesNode.hasValidTopLevelClasses(dependency) && !ClassesNode.getTargetNodeClass(dependency).equals(edgeStart);
    }

    public String toString() {
        return this.getText();
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return this.getClasses().flatMap(c -> c.getDirectDependenciesFromSelf().stream()).filter(dependency -> ClassesNode.hasValidTopLevelClass(dependency.getTargetClass())).filter(dep -> !dep.getTargetClass().getPackage().equals(dep.getOriginClass().getPackage()) || this.groupIndexOf(dep.getTargetClass()) != this.groupIndex);
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return this.getClasses().flatMap(c -> c.getDirectDependenciesToSelf().stream()).filter(dependency -> ClassesNode.hasValidTopLevelClass(dependency.getOriginClass())).filter(dep -> !dep.getTargetClass().getPackage().equals(dep.getOriginClass().getPackage()) || this.groupIndexOf(dep.getOriginClass()) != this.groupIndex);
    }

    @Override
    String getUIIconName() {
        return this.samePackage ? UI_SAME_PACKAGE_ICON_NAME : UI_CHILD_PACKAGE_ICON_NAME;
    }

    @Override
    Set<CodeNode> findCyclicDependencies() {
        GraphCycleFinder<CodeNode> cycleFinder = new GraphCycleFinder<CodeNode>();
        cycleFinder.addNode(this);
        cycleFinder.stopSearchHere();
        cycleFinder.exploreGraph(Collections.singleton(this), this::connectedTargetNodes, this::connectedOriginNodes);
        Set cycles = cycleFinder.findSimpleCycles();
        return cycles.stream().flatMap(edge -> ((CodeNode)((Object)((Object)edge.getKey()))).getOutgoingDependenciesWithKnownTargets().flatMap(dep -> this.classNodes((Map.Entry<CodeNode, CodeNode>)edge, dep.getOriginClass(), dep.getTargetClass()))).collect(Collectors.toSet());
    }

    private Stream<? extends CodeNode> classNodes(Map.Entry<CodeNode, CodeNode> edge, JavaClass originClass, JavaClass targetClass) {
        String targetId = this.idWithGroupIndex(targetClass);
        CodeNode targetNode = (CodeNode)this.getMap().getNodeForID(targetId);
        if (targetNode.isDescendantOf(edge.getValue())) {
            String originId = this.idWithGroupIndex(originClass);
            CodeNode originNode = (CodeNode)this.getMap().getNodeForID(originId);
            return Stream.of(originNode, targetNode);
        }
        return Stream.empty();
    }

    private Stream<CodeNode> connectedOriginNodes(CodeNode node) {
        Stream<JavaClass> originClasses = node.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass);
        return this.nodes(originClasses);
    }

    private Stream<CodeNode> connectedTargetNodes(CodeNode node) {
        Stream<JavaClass> targetClasses = node.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass);
        return this.nodes(targetClasses);
    }

    private Stream<CodeNode> nodes(Stream<JavaClass> classes) {
        return classes.map(this::idWithGroupIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(NodeModel::getParentNode).map(CodeNode.class::cast);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_CHILD_PACKAGE_ICON_NAME, "code/childPackage.svg");
        IconStoreFactory.INSTANCE.createStateIcon(UI_SAME_PACKAGE_ICON_NAME, "code/samePackage.svg");
    }
}

