/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.ManagedAttribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphCycleFinder;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.ClassesNode;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;

class PackageNode
extends CodeNode {
    static final String UI_ROOT_PACKAGE_ICON_NAME = "code_root_package";
    static final String UI_SUBPACKAGE_WITHOUT_CLASSES_ICON_NAME = "code_subpackage_without_classes";
    static final String UI_SUBPACKAGE_WITH_CLASSES_ICON_NAME = "code_subpackage_with_classes";
    private final JavaPackage javaPackage;
    private final long classCount;
    private final boolean hasOwnClasses;

    public PackageNode(JavaPackage javaPackage, CodeMap map, String text, int groupIndex, boolean createAttributes) {
        super(map, groupIndex);
        this.javaPackage = javaPackage;
        this.setIdWithIndex(javaPackage.getName());
        this.classCount = this.getClassesInTree().filter(CodeNode::isNamed).count();
        this.setText(text + PackageNode.formatClassCount(this.classCount));
        this.hasOwnClasses = this.getClasses().anyMatch(x -> true);
        if (createAttributes) {
            TreeSet classpath = new TreeSet();
            this.getClassesInTree().forEach(jc -> PackageNode.classSourceLocationOf(jc).ifPresent(classpath::add));
            NodeAttributeTableModel attributes = new NodeAttributeTableModel(1 + classpath.size());
            classpath.forEach(path -> attributes.silentlyAddRowNoUndo((NodeModel)this, (Attribute)new ManagedAttribute("Classpath", path)));
            attributes.silentlyAddRowNoUndo((NodeModel)this, (Attribute)new ManagedAttribute("Class count", (Object)this.classCount));
            this.addExtension((IExtension)attributes);
        }
        this.initializeChildNodes();
    }

    private Stream<JavaClass> getClassesInTree() {
        return this.getClassesInTree(this.javaPackage);
    }

    private Stream<JavaClass> getClassesInTree(JavaPackage somePackage) {
        return somePackage.getClassesInPackageTree().stream().filter(CodeNode::hasValidTopLevelClass).filter(this::belongsToSameGroup);
    }

    private Stream<JavaClass> getClasses() {
        return this.getClasses(this.javaPackage);
    }

    private Stream<JavaClass> getClasses(JavaPackage somePackage) {
        return somePackage.getClasses().stream().filter(this::belongsToSameGroup);
    }

    private List<JavaPackage> relevantSubpackages(JavaPackage somePackage) {
        return somePackage.getSubpackages().stream().filter(this::containsAnalyzedClassesInPackageTree).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean containsAnalyzedClassesInPackageTree(JavaPackage somePackage) {
        return this.getClassesInTree(somePackage).anyMatch(x -> true);
    }

    long getClassCount() {
        return this.classCount;
    }

    @Override
    HasName getCodeElement() {
        return this.javaPackage;
    }

    private void initializeChildNodes() {
        boolean hasSubpackages;
        List children = super.getChildrenInternal();
        if (this.classCount == 0L) {
            return;
        }
        List<JavaPackage> packages = this.relevantSubpackages(this.javaPackage);
        boolean bl = hasSubpackages = !packages.isEmpty();
        if (!hasSubpackages) {
            return;
        }
        if (this.hasOwnClasses) {
            packages.add(this.javaPackage);
        }
        GraphNodeSort<JavaPackage> childNodes = new GraphNodeSort<JavaPackage>();
        for (JavaPackage childPackage : packages) {
            childNodes.addNode(childPackage);
            DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
            Stream<Dependency> packageDependencies = (childPackage != this.javaPackage ? this.getClassDependenciesFromPackageTree(childPackage) : this.getClassDependenciesFromPackage(childPackage)).filter(dep -> this.belongsToSameGroup(dep.getTargetClass()));
            Map<JavaPackage, Long> dependencies = packageDependencies.map(filter::knownDependency).collect(Collectors.groupingBy(this::getTargetChildNodePackage, Collectors.counting()));
            dependencies.entrySet().stream().filter(e -> ((JavaPackage)e.getKey()).getParent().isPresent()).forEach(e -> childNodes.addEdge(childPackage, (JavaPackage)e.getKey(), ((Long)e.getValue()).longValue()));
        }
        Comparator<Set> comparingByReversedClassCount = Comparator.comparing(childPackages -> -childPackages.stream().mapToLong(x -> (x == this.javaPackage ? this.getClasses() : this.getClassesInTree((JavaPackage)x)).count()).sum());
        List<List<JavaPackage>> orderedPackages = childNodes.sortNodes(Comparator.comparing(JavaPackage::getName), comparingByReversedClassCount.thenComparing(SubgroupComparator.comparingByName(JavaPackage::getName)));
        for (int subgroupIndex = 0; subgroupIndex < orderedPackages.size(); ++subgroupIndex) {
            for (JavaPackage childPackage : orderedPackages.get(subgroupIndex)) {
                CodeNode node = this.createChildPackageNode(childPackage, "");
                children.add(node);
                node.setParent(this);
            }
        }
        for (NodeModel child : children) {
            ((CodeNode)child).setInitialFoldingState();
        }
    }

    private Stream<Dependency> getClassDependenciesFromPackage(JavaPackage somePackage) {
        Set<JavaClass> classesInTree = this.getClasses(somePackage).collect(Collectors.toSet());
        return this.getClassDependenciesFrom(classesInTree);
    }

    private Stream<Dependency> getClassDependenciesFromPackageTree(JavaPackage somePackage) {
        Set<JavaClass> classesInTree = this.getClassesInTree(somePackage).collect(Collectors.toSet());
        return this.getClassDependenciesFrom(classesInTree);
    }

    private Stream<Dependency> getClassDependenciesFrom(Set<JavaClass> classesInTree) {
        return classesInTree.stream().flatMap(javaClass -> javaClass.getDirectDependenciesFromSelf().stream()).filter(dependency -> !classesInTree.contains(dependency.getTargetClass()));
    }

    private Stream<Dependency> getClassDependenciesToPackageTree(JavaPackage somePackage) {
        Set classesInTree = this.getClassesInTree(somePackage).collect(Collectors.toSet());
        return classesInTree.stream().flatMap(javaClass -> javaClass.getDirectDependenciesToSelf().stream()).filter(dependency -> !classesInTree.contains(dependency.getOriginClass()));
    }

    private CodeNode createChildPackageNode(JavaPackage childPackage, String parentName) {
        boolean samePackage;
        String childPackageName = childPackage.getRelativeName();
        List<JavaPackage> subpackages = this.relevantSubpackages(childPackage);
        boolean bl = samePackage = childPackage == this.javaPackage;
        if (samePackage || subpackages.isEmpty() && !childPackage.getClasses().isEmpty()) {
            String childName = samePackage ? (childPackageName.isEmpty() ? "default" : childPackageName) + " - package" : parentName + childPackageName;
            return new ClassesNode(childPackage, this.getMap(), childName, samePackage, this.groupIndex);
        }
        if (subpackages.size() == 1 && !this.getClasses(childPackage).anyMatch(x -> true)) {
            return this.createChildPackageNode(subpackages.iterator().next(), parentName + childPackageName + ".");
        }
        return new PackageNode(childPackage, this.getMap(), parentName + childPackageName, this.groupIndex, false);
    }

    private JavaPackage getTargetChildNodePackage(Dependency dep) {
        JavaClass targetClass = dep.getTargetClass();
        return this.getChildNodePackage(targetClass);
    }

    private JavaPackage getChildNodePackage(JavaClass javaClass) {
        JavaPackage childNodePackage = javaClass.getPackage();
        if (childNodePackage.equals(this.javaPackage)) {
            return childNodePackage;
        }
        Optional parent;
        while ((parent = childNodePackage.getParent()).isPresent() && !((JavaPackage)parent.get()).equals(this.javaPackage)) {
            childNodePackage = (JavaPackage)parent.get();
        }
        return childNodePackage;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return this.javaPackage.getParent().isPresent() ? this.getClassDependenciesFromPackageTree(this.javaPackage).filter(dep -> CodeNode.hasValidTopLevelClass(dep.getTargetClass())) : this.getGroupDependenciesFromPackageTree();
    }

    private Stream<Dependency> getGroupDependenciesFromPackageTree() {
        return this.groupClasses().flatMap(javaClass -> javaClass.getDirectDependenciesFromSelf().stream()).filter(dep -> this.belongsToOtherGroup(dep.getTargetClass()));
    }

    private Stream<JavaClass> groupClasses() {
        return this.getMap().allClasses().filter(this::belongsToSameGroup);
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return this.javaPackage.getParent().isPresent() ? this.getClassDependenciesToPackageTree(this.javaPackage).filter(dep -> CodeNode.hasValidTopLevelClass(dep.getOriginClass())) : this.getGroupDependenciesToPackageTree();
    }

    private Stream<Dependency> getGroupDependenciesToPackageTree() {
        return this.groupClasses().flatMap(javaClass -> javaClass.getDirectDependenciesToSelf().stream()).filter(dep -> this.belongsToOtherGroup(dep.getOriginClass()));
    }

    @Override
    String getUIIconName() {
        return this.hasOwnClasses ? UI_SUBPACKAGE_WITH_CLASSES_ICON_NAME : (this.javaPackage.getParent().isPresent() ? UI_SUBPACKAGE_WITHOUT_CLASSES_ICON_NAME : UI_ROOT_PACKAGE_ICON_NAME);
    }

    @Override
    Set<CodeNode> findCyclicDependencies() {
        GraphCycleFinder<CodeNode> cycleFinder = new GraphCycleFinder<CodeNode>();
        cycleFinder.addNode(this);
        cycleFinder.stopSearchHere();
        cycleFinder.exploreGraph(Collections.singleton(this), this::connectedTargetNodes, this::connectedOriginNodes);
        Set cycles = cycleFinder.findSimpleCycles();
        return cycles.stream().flatMap(edge -> ((CodeNode)((Object)((Object)edge.getKey()))).getOutgoingDependenciesWithKnownTargets().flatMap(dep -> this.classNodes((Map.Entry<CodeNode, CodeNode>)edge, dep.getOriginClass(), dep.getTargetClass()))).collect(Collectors.toSet());
    }

    private Stream<? extends CodeNode> classNodes(Map.Entry<CodeNode, CodeNode> edge, JavaClass originClass, JavaClass targetClass) {
        String targetId = this.idWithGroupIndex(targetClass);
        CodeNode targetNode = (CodeNode)this.getMap().getNodeForID(targetId);
        if (targetNode.isDescendantOf(edge.getValue())) {
            String originId = this.idWithGroupIndex(originClass);
            CodeNode originNode = (CodeNode)this.getMap().getNodeForID(originId);
            return Stream.of(originNode, targetNode);
        }
        return Stream.empty();
    }

    private Stream<CodeNode> connectedOriginNodes(CodeNode node) {
        Stream<JavaClass> originClasses = node.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass);
        return this.nodes(originClasses);
    }

    private Stream<CodeNode> connectedTargetNodes(CodeNode node) {
        Stream<JavaClass> targetClasses = node.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass);
        return this.nodes(targetClasses);
    }

    private Stream<CodeNode> nodes(Stream<JavaClass> classes) {
        return classes.map(this::idWithGroupIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(node -> node.isDescendantOf((NodeModel)this) ? this : node.getParentNode()).map(CodeNode.class::cast);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_ROOT_PACKAGE_ICON_NAME, "code/moduleGroup.svg");
        IconStoreFactory.INSTANCE.createStateIcon(UI_SUBPACKAGE_WITHOUT_CLASSES_ICON_NAME, "code/module.svg");
        IconStoreFactory.INSTANCE.createStateIcon(UI_SUBPACKAGE_WITH_CLASSES_ICON_NAME, "code/sourceRoot.svg");
    }
}

