/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKit;
import com.lightdev.app.shtm.SHTMLWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.XHTMLWriter;

public class HtmlProcessor {
    private static final String SAVE_COMPACT_HTML_PROPERTY = "saveCompactHypertext";
    private final HTMLDocument doc;

    public static void configureUnknownTags(HTMLDocument doc) {
        doc.setPreservesUnknownTags(!ResourceController.getResourceController().getBooleanProperty(SAVE_COMPACT_HTML_PROPERTY));
    }

    private static HTMLDocument createDocument(String input) {
        SHTMLEditorKit kit = new SHTMLEditorKit();
        try {
            SHTMLDocument doc = new SHTMLDocument();
            HtmlProcessor.configureUnknownTags((HTMLDocument)doc);
            kit.read(new StringReader(input), (Document)doc, 0);
            return doc;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public HtmlProcessor(String input) {
        this.doc = HtmlProcessor.createDocument(input);
    }

    public String htmlSubstring(int pos, int length) {
        if (this.doc == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        try {
            if (pos < this.doc.getLength() && length > 0) {
                SHTMLWriter hw = new SHTMLWriter((Writer)writer, this.doc, pos, Math.min(length, this.doc.getLength() - pos));
                hw.write();
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return writer.toString();
    }

    public String cleanHtml() {
        return this.htmlSubstring(0, this.doc.getLength());
    }

    public String cleanXhtml() {
        if (this.doc == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        XHTMLWriter xhw = new XHTMLWriter(writer, this.doc);
        try {
            xhw.write();
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return writer.toString();
    }

    public int getDocumentLength() {
        return this.doc.getLength();
    }

    public boolean isOk() {
        return this.doc != null;
    }

    public String getText() {
        try {
            return this.doc == null ? "" : this.doc.getText(0, this.getDocumentLength());
        }
        catch (BadLocationException e) {
            LogUtils.severe(e);
            return "";
        }
    }
}

