/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.NoSuchElementException;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.DoubleListModel;
import org.freeplane.core.util.collection.ExtendedComboBoxModel;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.AttributeCompareCondition;
import org.freeplane.features.attribute.AttributeContainsCondition;
import org.freeplane.features.attribute.AttributeExistsCondition;
import org.freeplane.features.attribute.AttributeMatchesCondition;
import org.freeplane.features.attribute.AttributeNotExistsCondition;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.ui.FrameController;
import org.freeplane.n3.nanoxml.XMLElement;

class AttributeConditionController
implements IElementaryConditionController {
    private static final String ATTRIBUTE_NAME_OR_VALUE = "attribute_name_or_value";
    static final TranslatedObject ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT = new TranslatedObject("attribute_name_or_value");
    private final ExtendedComboBoxModel values = new ExtendedComboBoxModel();

    @Override
    public boolean canEditValues(Object selectedItem, TranslatedObject simpleCond) {
        return this.canSelectValues(selectedItem, simpleCond);
    }

    @Override
    public boolean canHandle(Object selectedItem) {
        return ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT.equals(selectedItem) || selectedItem.getClass().equals(String.class);
    }

    @Override
    public boolean canSelectValues(Object selectedItem, TranslatedObject simpleCond) {
        return !simpleCond.objectEquals("filter_exist") && !simpleCond.objectEquals("filter_does_not_exist");
    }

    @Override
    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCondition, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        Object attribute = selectedItem;
        if (simpleCondition.objectEquals("filter_exist")) {
            return new AttributeExistsCondition(attribute);
        }
        if (simpleCondition.objectEquals("filter_does_not_exist")) {
            return new AttributeNotExistsCondition(attribute);
        }
        if (simpleCondition.objectEquals("filter_is_equal_to")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 0, true, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals("filter_is_not_equal_to")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 0, false, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(">")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 1, true, false, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals(">=")) {
            return new AttributeCompareCondition(attribute, value, matchCase, -1, false, false, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals("<")) {
            return new AttributeCompareCondition(attribute, value, matchCase, -1, true, false, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals("<=")) {
            return new AttributeCompareCondition(attribute, value, matchCase, 1, false, false, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals("filter_contains")) {
            return new AttributeContainsCondition(attribute, value.toString(), matchCase, matchApproximately, ignoreDiacritics);
        }
        if (simpleCondition.objectEquals("filter_regexp_matches")) {
            return new AttributeMatchesCondition(attribute, value.toString(), matchCase);
        }
        return null;
    }

    @Override
    public ComboBoxModel getConditionsForProperty(Object selectedItem) {
        return new DefaultComboBoxModel<TranslatedObject>(new TranslatedObject[]{TextUtils.createTranslatedString("filter_contains"), TextUtils.createTranslatedString("filter_regexp_matches"), TextUtils.createTranslatedString("filter_exist"), TextUtils.createTranslatedString("filter_does_not_exist"), TextUtils.createTranslatedString("filter_is_equal_to"), TextUtils.createTranslatedString("filter_is_not_equal_to"), TranslatedObject.literal(">"), TranslatedObject.literal(">="), TranslatedObject.literal("<="), TranslatedObject.literal("<")});
    }

    @Override
    public ListModel getFilteredProperties() {
        AttributeRegistry registry = AttributeRegistry.getRegistry(Controller.getCurrentController().getMap());
        DefaultListModel<TranslatedObject> anyAttributeList = new DefaultListModel<TranslatedObject>();
        anyAttributeList.addElement(ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT);
        if (registry != null) {
            return new DoubleListModel(anyAttributeList, registry.getListBoxModel());
        }
        return anyAttributeList;
    }

    @Override
    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return new FixedBasicComboBoxEditor();
        }
        return FrameController.getTextDateTimeEditor();
    }

    @Override
    public ComboBoxModel getValuesForProperty(Object selectedItem, TranslatedObject simpleCond) {
        MapModel map = Controller.getCurrentController().getMap();
        AttributeRegistry registry = AttributeRegistry.getRegistry(map);
        try {
            AttributeRegistryElement element = registry.getElement((Comparable<?>)((Object)selectedItem.toString()));
            SortedComboBoxModel list = element.getValues();
            SortedComboBoxModel linkedList = new SortedComboBoxModel();
            for (int i = 0; i < list.getSize(); ++i) {
                Object value = list.getElementAt(i);
                TextController textController = TextController.getController();
                if (textController.isFormula(value)) continue;
                try {
                    Object transformedValue = textController.getTransformedObject(map.getRootNode(), element, value);
                    linkedList.add(transformedValue);
                    continue;
                }
                catch (TransformationException e) {
                    LogUtils.severe(e);
                }
            }
            this.values.setExtensionList(linkedList);
        }
        catch (NoSuchElementException e) {
            this.values.setExtensionList(null);
        }
        return this.values;
    }

    @Override
    public boolean isCaseDependent(Object selectedItem, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return true;
    }

    @Override
    public ASelectableCondition loadCondition(XMLElement element) {
        if (element.getName().equalsIgnoreCase("attribute_compare_condition")) {
            return AttributeCompareCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_exists_condition")) {
            return AttributeExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_not_exists_condition")) {
            return AttributeNotExistsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_contains_condition")) {
            return AttributeContainsCondition.load(element);
        }
        if (element.getName().equalsIgnoreCase("attribute_matches_condition")) {
            return AttributeMatchesCondition.load(element);
        }
        return null;
    }

    @Override
    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        if (selectedCondition.objectEquals("filter_contains") || selectedCondition.objectEquals("filter_regexp_matches")) {
            return null;
        }
        return new TypedListCellRenderer();
    }

    static Object toAttributeObject(String attribute) {
        Object xmlElementAttribute = attribute != null ? attribute : ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT;
        return xmlElementAttribute;
    }
}

