/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.filter.FilterInfo;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.filter.hidden.NodeVisibilityConfiguration;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class Filter
implements IExtension {
    private final ICondition condition;
    final int options;
    private FilterInfoAccessor accessor;
    private final boolean hidesMatchingNodes;
    private final boolean appliesToVisibleNodesOnly;
    private final Filter baseFilter;
    private static Icon filterIcon;

    public static Filter createTransparentFilter() {
        ResourceController resourceController = ResourceController.getResourceController();
        return new Filter(null, false, resourceController.getBooleanProperty("filter.showAncestors"), resourceController.getBooleanProperty("filter.showDescendants"), false, null);
    }

    public static Filter createFilter(ICondition condition, boolean areAncestorsShown, boolean areDescendantsShown, boolean appliesToVisibleNodesOnly, Filter baseFilter) {
        return new Filter(condition, false, areAncestorsShown, areDescendantsShown, appliesToVisibleNodesOnly, baseFilter);
    }

    public Filter(ICondition condition, boolean hidesMatchingNodes, boolean areAncestorsShown, boolean areDescendantsShown, boolean appliesToVisibleNodesOnly, Filter baseFilter) {
        this.condition = condition;
        this.hidesMatchingNodes = hidesMatchingNodes;
        this.appliesToVisibleNodesOnly = appliesToVisibleNodesOnly;
        this.accessor = new FilterInfoAccessor();
        int options = 2;
        if (areAncestorsShown) {
            options += 4;
        }
        if (areDescendantsShown) {
            options += 8;
        }
        this.options = options;
        this.baseFilter = baseFilter;
    }

    void addFilterResult(NodeModel node, int flag) {
        this.getFilterInfo(node).add(flag);
    }

    protected boolean appliesToVisibleNodesOnly() {
        return this.appliesToVisibleNodesOnly;
    }

    void displayFilterStatus() {
        if (filterIcon == null) {
            filterIcon = ResourceController.getResourceController().getIcon("ShowFilterToolbarAction.icon");
        }
        if (this.getCondition() != null) {
            Controller.getCurrentController().getViewController().addStatusInfo("filter", null, filterIcon);
        } else {
            Controller.getCurrentController().getViewController().removeStatus("filter");
        }
    }

    public void calculateFilterResults(MapModel map) {
        this.accessor = new FilterInfoAccessor();
        NodeModel root = map.getRootNode();
        this.resetFilter(root);
        boolean rootSatisfiesFilter = this.checkNode(root);
        if (this.filterChildren(root, rootSatisfiesFilter, false)) {
            this.addFilterResult(root, 4);
        }
    }

    public void calculateFilterResults(NodeModel root) {
        this.accessor = new FilterInfoAccessor();
        if (this.applyFilter(root, false, false, false)) {
            this.addFilterResult(root, 4);
        }
    }

    private boolean applyFilter(NodeModel node, boolean hasMatchingAncestor, boolean hasHiddenAncestor, boolean hasMatchingDescendant) {
        boolean conditionSatisfied;
        boolean bl = conditionSatisfied = this.condition == null || this.condition.checkNode(node);
        boolean matchesCombinedFilter = this.appliesToVisibleNodesOnly() ? conditionSatisfied && this.baseFilter.isVisible(node) : conditionSatisfied;
        this.resetFilter(node);
        if (hasMatchingAncestor) {
            this.addFilterResult(node, 8);
        }
        if (matchesCombinedFilter) {
            hasMatchingDescendant = true;
            this.addFilterResult(node, 2);
        } else {
            this.addFilterResult(node, 16);
        }
        boolean childrenHaveMatchingAncestor = hasMatchingAncestor || matchesCombinedFilter && !node.isRoot();
        if (this.filterChildren(node, childrenHaveMatchingAncestor, !matchesCombinedFilter || hasHiddenAncestor)) {
            this.addFilterResult(node, 4);
            hasMatchingDescendant = true;
        }
        return hasMatchingDescendant;
    }

    public boolean areAncestorsShown() {
        return 0 != (this.options & 4);
    }

    boolean areMatchingNodesHidden() {
        return this.hidesMatchingNodes;
    }

    public boolean areDescendantsShown() {
        return 0 != (this.options & 8);
    }

    private boolean checkNode(NodeModel node) {
        return this.condition == null || !this.shouldRemainInvisible(node) && this.condition.checkNode(node);
    }

    private boolean shouldRemainInvisible(NodeModel node) {
        return this.condition != null && this.appliesToVisibleNodesOnly() && !node.hasVisibleContent(this.baseFilter);
    }

    private boolean filterChildren(NodeModel node, boolean hasMatchingAncestor, boolean hasHiddenAncestor) {
        boolean hasMatchingDescendant = false;
        for (NodeModel child : this.children(node)) {
            hasMatchingDescendant = this.applyFilter(child, hasMatchingAncestor, hasHiddenAncestor, hasMatchingDescendant);
        }
        return hasMatchingDescendant;
    }

    protected List<NodeModel> children(NodeModel node) {
        return node.getChildren();
    }

    public ICondition getCondition() {
        return this.condition;
    }

    public boolean canUseFilterResultsFrom(Filter oldFilter) {
        return (!oldFilter.appliesToVisibleNodesOnly || this.appliesToVisibleNodesOnly) && Objects.equals(this.condition, oldFilter.getCondition());
    }

    public void useFilterResultsFrom(Filter oldFilter) {
        this.accessor = oldFilter.accessor;
    }

    public boolean isVisible(NodeModel node) {
        return this.isVisible(node, this.options);
    }

    public boolean isFoldable(NodeModel node) {
        return this.hidesMatchingNodes || this.isVisible(node, this.options | 4);
    }

    private boolean isVisible(NodeModel node, int options) {
        if (node.getExtension(NodeVisibility.class) == NodeVisibility.HIDDEN && node.getMap().getRootNode().getExtension(NodeVisibilityConfiguration.class) != NodeVisibilityConfiguration.SHOW_HIDDEN_NODES) {
            return false;
        }
        if (this.condition == null || node.isRoot()) {
            return true;
        }
        FilterInfo filterInfo = this.getFilterInfo(node);
        return filterInfo.isNotChecked() || filterInfo.matches(options) != this.hidesMatchingNodes;
    }

    void resetFilter(NodeModel node) {
        this.getFilterInfo(node).reset();
    }

    public FilterInfo getFilterInfo(NodeModel node) {
        return this.accessor.getFilterInfo(node);
    }

    public void showAsMatched(NodeModel node) {
        FilterInfo filterInfo = this.getFilterInfo(node);
        if (!filterInfo.matches(2)) {
            filterInfo.add(2);
            if (!filterInfo.matches(4)) {
                this.showAncestors(node);
            }
            if (!filterInfo.matches(8)) {
                this.showDescendants(node);
            }
        }
    }

    private void showAncestors(NodeModel node) {
        NodeModel parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        FilterInfo filterInfo = this.getFilterInfo(parent);
        if (!filterInfo.matches(4)) {
            filterInfo.add(4);
            this.showAncestors(parent);
        }
    }

    private void showDescendants(NodeModel node) {
        for (NodeModel child : this.children(node)) {
            FilterInfo filterInfo = this.getFilterInfo(child);
            filterInfo.add(8);
            this.showDescendants(child);
        }
    }

    static class FilterInfoAccessor {
        private final WeakHashMap<NodeModel, FilterInfo> filterInfos = new WeakHashMap();

        FilterInfoAccessor() {
        }

        FilterInfo getFilterInfo(NodeModel node) {
            return this.filterInfos.computeIfAbsent(node, x -> new FilterInfo());
        }
    }
}

