/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Map;
import javajs.img.DCT;
import javajs.img.Huffman;
import javajs.img.ImageEncoder;
import javajs.img.JpegObj;

public class JpgEncoder
extends ImageEncoder {
    private static final int CONTINUE_MAX = 65500;
    private static final int CONTINUE_MAX_BUFFER = 65510;
    private JpegObj jpegObj;
    private Huffman huf;
    private DCT dct;
    protected int defaultQuality = 100;
    private String applicationTag;
    private static byte[] eoi = new byte[]{-1, -39};
    private static byte[] jfif = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
    private static byte[] soi = new byte[]{-1, -40};

    @Override
    protected void setParams(Map<String, Object> params) {
        if (this.quality <= 0) {
            this.quality = params.containsKey("qualityJPG") ? (Integer)params.get("qualityJPG") : this.defaultQuality;
        }
        this.jpegObj = new JpegObj();
        this.jpegObj.comment = (String)params.get("comment");
        this.applicationTag = (String)params.get("jpgAppTag");
    }

    @Override
    protected void generate() throws IOException {
        this.jpegObj.imageWidth = this.width;
        this.jpegObj.imageHeight = this.height;
        this.dct = new DCT(this.quality);
        this.huf = new Huffman(this.width, this.height);
        if (this.jpegObj == null) {
            return;
        }
        this.jpegObj.getYCCArray(this.pixels);
        String longState = this.writeHeaders(this.jpegObj, this.dct);
        this.writeCompressedData(this.jpegObj, this.dct, this.huf);
        this.writeMarker(eoi);
        if (longState != null) {
            byte[] b = longState.getBytes();
            this.out.write(b, 0, b.length);
        }
    }

    private void writeCompressedData(JpegObj jpegObj, DCT dct, Huffman huf) {
        int comp;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[jpegObj.numberOfComponents];
        int minBlockWidth = huf.imageWidth % 8 != 0 ? (int)(Math.floor((double)huf.imageWidth / 8.0) + 1.0) * 8 : huf.imageWidth;
        int minBlockHeight = huf.imageHeight % 8 != 0 ? (int)(Math.floor((double)huf.imageHeight / 8.0) + 1.0) * 8 : huf.imageHeight;
        for (comp = 0; comp < jpegObj.numberOfComponents; ++comp) {
            minBlockWidth = Math.min(minBlockWidth, jpegObj.blockWidth[comp]);
            minBlockHeight = Math.min(minBlockHeight, jpegObj.blockHeight[comp]);
        }
        int xpos = 0;
        for (int r = 0; r < minBlockHeight; ++r) {
            for (int c = 0; c < minBlockWidth; ++c) {
                xpos = c * 8;
                int ypos = r * 8;
                for (comp = 0; comp < jpegObj.numberOfComponents; ++comp) {
                    float[][] inputArray = jpegObj.components[comp];
                    int vsampF = jpegObj.vsampFactor[comp];
                    int hsampF = jpegObj.hsampFactor[comp];
                    int qNumber = jpegObj.qtableNumber[comp];
                    int dcNumber = jpegObj.dctableNumber[comp];
                    int acNumber = jpegObj.actableNumber[comp];
                    for (int i = 0; i < vsampF; ++i) {
                        for (int j = 0; j < hsampF; ++j) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            for (int a = 0; a < 8; ++a) {
                                for (int b = 0; b < 8; ++b) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                }
                            }
                            dctArray2 = DCT.forwardDCT(dctArray1);
                            dctArray3 = DCT.quantizeBlock(dctArray2, dct.divisors[qNumber]);
                            huf.HuffmanBlockEncoder(this.out, dctArray3, lastDCvalue[comp], dcNumber, acNumber);
                            lastDCvalue[comp] = dctArray3[0];
                        }
                    }
                }
            }
        }
        huf.flushBuffer(this.out);
    }

    private String writeHeaders(JpegObj jpegObj, DCT dct) {
        int i;
        this.writeMarker(soi);
        this.writeArray(jfif);
        String comment = null;
        if (jpegObj.comment.length() > 0) {
            this.writeString(jpegObj.comment, (byte)-31);
        }
        this.writeString("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.\n\n", (byte)-2);
        byte[] dqt = new byte[134];
        dqt[0] = -1;
        dqt[1] = -37;
        dqt[2] = 0;
        dqt[3] = -124;
        int offset = 4;
        for (i = 0; i < 2; ++i) {
            dqt[offset++] = (byte)(0 + i);
            int[] tempArray = dct.quantum[i];
            for (int j = 0; j < 64; ++j) {
                dqt[offset++] = (byte)tempArray[Huffman.jpegNaturalOrder[j]];
            }
        }
        this.writeArray(dqt);
        byte[] sof = new byte[19];
        sof[0] = -1;
        sof[1] = -64;
        sof[2] = 0;
        sof[3] = 17;
        sof[4] = (byte)jpegObj.precision;
        sof[5] = (byte)(jpegObj.imageHeight >> 8 & 0xFF);
        sof[6] = (byte)(jpegObj.imageHeight & 0xFF);
        sof[7] = (byte)(jpegObj.imageWidth >> 8 & 0xFF);
        sof[8] = (byte)(jpegObj.imageWidth & 0xFF);
        sof[9] = (byte)jpegObj.numberOfComponents;
        int index = 10;
        for (i = 0; i < sof[9]; ++i) {
            sof[index++] = (byte)jpegObj.compID[i];
            sof[index++] = (byte)((jpegObj.hsampFactor[i] << 4) + jpegObj.vsampFactor[i]);
            sof[index++] = (byte)jpegObj.qtableNumber[i];
        }
        this.writeArray(sof);
        this.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance);
        this.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance);
        this.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance);
        this.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance);
        byte[] sos = new byte[14];
        sos[0] = -1;
        sos[1] = -38;
        sos[2] = 0;
        sos[3] = 12;
        sos[4] = (byte)jpegObj.numberOfComponents;
        index = 5;
        for (i = 0; i < sos[4]; ++i) {
            sos[index++] = (byte)jpegObj.compID[i];
            sos[index++] = (byte)((jpegObj.dctableNumber[i] << 4) + jpegObj.actableNumber[i]);
        }
        sos[index++] = (byte)jpegObj.ss;
        sos[index++] = (byte)jpegObj.se;
        sos[index++] = (byte)((jpegObj.ah << 4) + jpegObj.al);
        this.writeArray(sos);
        return comment;
    }

    private void writeString(String s, byte id) {
        int nBytes;
        int len = s.length();
        String suffix = this.applicationTag;
        for (int i0 = 0; i0 < len; i0 += nBytes) {
            int pt;
            nBytes = len - i0;
            if (nBytes > 65510 && (pt = s.lastIndexOf(10, i0 + (nBytes = 65500))) > i0 + 1) {
                nBytes = pt - i0;
            }
            if (i0 + nBytes == len) {
                suffix = "";
            }
            this.writeTag(nBytes + suffix.length(), id);
            this.writeArray(s.substring(i0, i0 + nBytes).getBytes());
            if (suffix.length() <= 0) continue;
            this.writeArray(suffix.getBytes());
        }
    }

    private void writeTag(int length, byte id) {
        byte[] com = new byte[]{-1, id, (byte)((length += 2) >> 8 & 0xFF), (byte)(length & 0xFF)};
        this.writeArray(com);
    }

    void WriteDHTHeader(int[] bits, int[] val) {
        int j;
        int bytes = 0;
        for (int j2 = 1; j2 < 17; ++j2) {
            bytes += bits[j2];
        }
        byte[] dht = new byte[21 + bytes];
        dht[0] = -1;
        dht[1] = -60;
        int index = 4;
        for (j = 0; j < 17; ++j) {
            dht[index++] = (byte)bits[j];
        }
        for (j = 0; j < bytes; ++j) {
            dht[index++] = (byte)val[j];
        }
        dht[2] = (byte)(index - 2 >> 8 & 0xFF);
        dht[3] = (byte)(index - 2 & 0xFF);
        this.writeArray(dht);
    }

    void writeMarker(byte[] data) {
        this.out.write(data, 0, 2);
    }

    void writeArray(byte[] data) {
        this.out.write(data, 0, data.length);
    }
}

