"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerVizRoute = registerVizRoute;
var _notebooks = require("../../../common/constants/notebooks");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerVizRoute(router) {
  // Fetches available saved visualizations for current user
  router.get({
    path: `${_notebooks.NOTEBOOKS_API_PREFIX}/visualizations`,
    validate: {}
  }, async (context, request, response) => {
    const params = {
      index: '.kibana',
      size: _notebooks.NOTEBOOKS_FETCH_SIZE,
      q: 'type:visualization'
    };
    try {
      const opensearchClientResponse = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      const savedVisualizations = opensearchClientResponse.hits.hits;
      const vizResponse = savedVisualizations.map(vizDocument => ({
        label: vizDocument._source.visualization.title,
        key: vizDocument._id.split(':').pop()
      }));
      return response.ok({
        body: {
          savedVisualizations: vizResponse
        }
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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