/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseCompletionFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class KuromojiCompletionFilterFactory
extends AbstractTokenFilterFactory {
    private final JapaneseCompletionFilter.Mode mode;

    public KuromojiCompletionFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.mode = KuromojiCompletionFilterFactory.getMode(settings);
    }

    public static JapaneseCompletionFilter.Mode getMode(Settings settings) {
        String modeSetting = settings.get("mode", null);
        if (modeSetting != null) {
            if ("index".equalsIgnoreCase(modeSetting)) {
                return JapaneseCompletionFilter.Mode.INDEX;
            }
            if ("query".equalsIgnoreCase(modeSetting)) {
                return JapaneseCompletionFilter.Mode.QUERY;
            }
        }
        return JapaneseCompletionFilter.Mode.INDEX;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseCompletionFilter(tokenStream, this.mode);
    }
}

