import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ActivateTypeInput, ActivateTypeOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ActivateTypeCommand}.
 */
export interface ActivateTypeCommandInput extends ActivateTypeInput {
}
/**
 * @public
 *
 * The output of {@link ActivateTypeCommand}.
 */
export interface ActivateTypeCommandOutput extends ActivateTypeOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Activates a public third-party extension, making it available for use in stack templates. For more information,
 *    see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html">Using public
 *     extensions</a> in the <i>CloudFormation User Guide</i>.</p>
 *          <p>Once you have activated a public third-party extension in your account and Region, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html">SetTypeConfiguration</a> to specify configuration properties for the extension. For more information, see
 *     <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at
 *     the account level</a> in the <i>CloudFormation User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ActivateTypeCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ActivateTypeCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ActivateTypeInput
 *   Type: "RESOURCE" || "MODULE" || "HOOK",
 *   PublicTypeArn: "STRING_VALUE",
 *   PublisherId: "STRING_VALUE",
 *   TypeName: "STRING_VALUE",
 *   TypeNameAlias: "STRING_VALUE",
 *   AutoUpdate: true || false,
 *   LoggingConfig: { // LoggingConfig
 *     LogRoleArn: "STRING_VALUE", // required
 *     LogGroupName: "STRING_VALUE", // required
 *   },
 *   ExecutionRoleArn: "STRING_VALUE",
 *   VersionBump: "MAJOR" || "MINOR",
 *   MajorVersion: Number("long"),
 * };
 * const command = new ActivateTypeCommand(input);
 * const response = await client.send(command);
 * // { // ActivateTypeOutput
 * //   Arn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ActivateTypeCommandInput - {@link ActivateTypeCommandInput}
 * @returns {@link ActivateTypeCommandOutput}
 * @see {@link ActivateTypeCommandInput} for command's `input` shape.
 * @see {@link ActivateTypeCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link TypeNotFoundException} (client fault)
 *  <p>The specified extension doesn't exist in the CloudFormation registry.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class ActivateTypeCommand extends $Command<ActivateTypeCommandInput, ActivateTypeCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: ActivateTypeCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ActivateTypeCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ActivateTypeCommandInput, ActivateTypeCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
