"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDirectory = void 0;
var url_1 = require("../tools/url");
var path_1 = require("../tools/path");
var request_1 = require("../request");
var response_1 = require("../response");
var stat_1 = require("./stat");
function createDirectory(context, dirPath, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var requestOptions, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (options.recursive === true)
                        return [2 /*return*/, createDirectoryRecursively(context, dirPath, options)];
                    requestOptions = (0, request_1.prepareRequestOptions)({
                        url: (0, url_1.joinURL)(context.remoteURL, ensureCollectionPath((0, path_1.encodePath)(dirPath))),
                        method: "MKCOL"
                    }, context, options);
                    return [4 /*yield*/, (0, request_1.request)(requestOptions)];
                case 1:
                    response = _a.sent();
                    (0, response_1.handleResponseCode)(context, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.createDirectory = createDirectory;
/**
 * Ensure the path is a proper "collection" path by ensuring it has a trailing "/".
 * The proper format of collection according to the specification does contain the trailing slash.
 * http://www.webdav.org/specs/rfc4918.html#rfc.section.5.2
 * @param path Path of the collection
 * @return string Path of the collection with appended trailing "/" in case the `path` does not have it.
 */
function ensureCollectionPath(path) {
    if (!path.endsWith("/")) {
        return path + "/";
    }
    return path;
}
function createDirectoryRecursively(context, dirPath, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var paths, creating, _i, paths_1, testPath, testStat, err_1, error;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    paths = (0, path_1.getAllDirectories)((0, path_1.normalisePath)(dirPath));
                    paths.sort(function (a, b) {
                        if (a.length > b.length) {
                            return 1;
                        }
                        else if (b.length > a.length) {
                            return -1;
                        }
                        return 0;
                    });
                    creating = false;
                    _i = 0, paths_1 = paths;
                    _a.label = 1;
                case 1:
                    if (!(_i < paths_1.length)) return [3 /*break*/, 10];
                    testPath = paths_1[_i];
                    if (!creating) return [3 /*break*/, 3];
                    return [4 /*yield*/, createDirectory(context, testPath, __assign(__assign({}, options), { recursive: false }))];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 9];
                case 3:
                    _a.trys.push([3, 5, , 9]);
                    return [4 /*yield*/, (0, stat_1.getStat)(context, testPath)];
                case 4:
                    testStat = (_a.sent());
                    if (testStat.type !== "directory") {
                        throw new Error("Path includes a file: ".concat(dirPath));
                    }
                    return [3 /*break*/, 9];
                case 5:
                    err_1 = _a.sent();
                    error = err_1;
                    if (!(error.status === 404)) return [3 /*break*/, 7];
                    creating = true;
                    return [4 /*yield*/, createDirectory(context, testPath, __assign(__assign({}, options), { recursive: false }))];
                case 6:
                    _a.sent();
                    return [3 /*break*/, 8];
                case 7: throw err_1;
                case 8: return [3 /*break*/, 9];
                case 9:
                    _i++;
                    return [3 /*break*/, 1];
                case 10: return [2 /*return*/];
            }
        });
    });
}
