# KNOW YOUR HTTP media-types WELL
> HTTP uses Internet media types [RFC2046] in the Content-Type (Section 3.1.1.5) and Accept (Section 5.3.2) header fields in order to provide open and extensible data typing and type negotiation. Media types define both a data format and various processing models: how to process that data in accordance with each context in which it is received.HTTP relies upon the Uniform Resource Identifier (URI) standard [RFC3986] to indicate the target resource and relationships between resources.

Continue reading on [RFC7231#3.1.1.1](https://tools.ietf.org/html/rfc7231#section-3.1.1.1).

For a full up-to-date list, continue reading on [Media Types](https://www.iana.org/assignments/media-types/media-types.xml).

## Application

media-type | template | spec
---------: | :------- | :---
`application/1d-interleaved-parityfec` | [application/1d-interleaved-parityfec](https://www.iana.org/assignments/media-types/application/1d-interleaved-parityfec) | [RFC6015](https://tools.ietf.org/html/rfc6015)
`application/3gpdash-qoe-report+xml` | [application/3gpdash-qoe-report+xml](https://www.iana.org/assignments/media-types/application/3gpdash-qoe-report+xml) |
`application/3gpp-ims+xml` | [application/3gpp-ims+xml](https://www.iana.org/assignments/media-types/application/3gpp-ims+xml) |
`application/A2L` | [application/A2L](https://www.iana.org/assignments/media-types/application/A2L) |
`application/activemessage` | [application/activemessage](https://www.iana.org/assignments/media-types/application/activemessage) |
`application/activemessage` | [application/activemessage](https://www.iana.org/assignments/media-types/application/activemessage) |
`application/alto-costmap+json` | [application/alto-costmap+json](https://www.iana.org/assignments/media-types/application/alto-costmap+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-costmapfilter+json` | [application/alto-costmapfilter+json](https://www.iana.org/assignments/media-types/application/alto-costmapfilter+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-directory+json` | [application/alto-directory+json](https://www.iana.org/assignments/media-types/application/alto-directory+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-endpointprop+json` | [application/alto-endpointprop+json](https://www.iana.org/assignments/media-types/application/alto-endpointprop+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-endpointpropparams+json` | [application/alto-endpointpropparams+json](https://www.iana.org/assignments/media-types/application/alto-endpointpropparams+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-endpointcost+json` | [application/alto-endpointcost+json](https://www.iana.org/assignments/media-types/application/alto-endpointcost+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-endpointcostparams+json` | [application/alto-endpointcostparams+json](https://www.iana.org/assignments/media-types/application/alto-endpointcostparams+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-error+json` | [application/alto-error+json](https://www.iana.org/assignments/media-types/application/alto-error+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-networkmapfilter+json` | [application/alto-networkmapfilter+json](https://www.iana.org/assignments/media-types/application/alto-networkmapfilter+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/alto-networkmap+json` | [application/alto-networkmap+json](https://www.iana.org/assignments/media-types/application/alto-networkmap+json) | [RFC7285](https://tools.ietf.org/html/rfc7285)
`application/AML` | [application/AML](https://www.iana.org/assignments/media-types/application/AML) |
`application/andrew-inset` | [application/andrew-inset](https://www.iana.org/assignments/media-types/application/andrew-inset) |
`application/applefile` | [application/applefile](https://www.iana.org/assignments/media-types/application/applefile) |
`application/ATF` | [application/ATF](https://www.iana.org/assignments/media-types/application/ATF) |
`application/ATFX` | [application/ATFX](https://www.iana.org/assignments/media-types/application/ATFX) |
`application/atom+xml` | [application/atom+xml](https://www.iana.org/assignments/media-types/application/atom+xml) | [RFC4287](https://tools.ietf.org/html/rfc4287), [RFC5023](https://tools.ietf.org/html/rfc5023)
`application/atomcat+xml` | [application/atomcat+xml](https://www.iana.org/assignments/media-types/application/atomcat+xml) | [RFC5023](https://tools.ietf.org/html/rfc5023)
`application/atomdeleted+xml` | [application/atomdeleted+xml](https://www.iana.org/assignments/media-types/application/atomdeleted+xml) | [RFC6721](https://tools.ietf.org/html/rfc6721)
`application/atomicmail` | [application/atomicmail](https://www.iana.org/assignments/media-types/application/atomicmail) |
`application/atomsvc+xml` | [application/atomsvc+xml](https://www.iana.org/assignments/media-types/application/atomsvc+xml) | [RFC5023](https://tools.ietf.org/html/rfc5023)
`application/ATXML` | [application/ATXML](https://www.iana.org/assignments/media-types/application/ATXML) |
`application/auth-policy+xml` | [application/auth-policy+xml](https://www.iana.org/assignments/media-types/application/auth-policy+xml) | [RFC4745](https://tools.ietf.org/html/rfc4745)
`application/bacnet-xdd+zip` | [application/bacnet-xdd+zip](https://www.iana.org/assignments/media-types/application/bacnet-xdd+zip) |
`application/batch-SMTP` | [application/batch-SMTP](https://www.iana.org/assignments/media-types/application/batch-SMTP) | [RFC2442](https://tools.ietf.org/html/rfc2442)
`application/beep+xml` | [application/beep+xml](https://www.iana.org/assignments/media-types/application/beep+xml) | [RFC3080](https://tools.ietf.org/html/rfc3080)
`application/calendar+json` | [application/calendar+json](https://www.iana.org/assignments/media-types/application/calendar+json) | [RFC7265](https://tools.ietf.org/html/rfc7265)
`application/calendar+xml` | [application/calendar+xml](https://www.iana.org/assignments/media-types/application/calendar+xml) | [RFC6321](https://tools.ietf.org/html/rfc6321)
`application/call-completion` | [application/call-completion](https://www.iana.org/assignments/media-types/application/call-completion) | [RFC6910](https://tools.ietf.org/html/rfc6910)
`application/CALS-1840` | [application/CALS-1840](https://www.iana.org/assignments/media-types/application/CALS-1840) | [RFC1895](https://tools.ietf.org/html/rfc1895)
`application/cbor` | [application/cbor](https://www.iana.org/assignments/media-types/application/cbor) | [RFC7049](https://tools.ietf.org/html/rfc7049)
`application/ccmp+xml` | [application/ccmp+xml](https://www.iana.org/assignments/media-types/application/ccmp+xml) | [RFC6503](https://tools.ietf.org/html/rfc6503)
`application/ccxml+xml` | [application/ccxml+xml](https://www.iana.org/assignments/media-types/application/ccxml+xml) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/CDFX+XML` | [application/CDFX+XML](https://www.iana.org/assignments/media-types/application/CDFX+XML) |
`application/cdmi-capability` | [application/cdmi-capability](https://www.iana.org/assignments/media-types/application/cdmi-capability) | [RFC6208](https://tools.ietf.org/html/rfc6208)
`application/cdmi-container` | [application/cdmi-container](https://www.iana.org/assignments/media-types/application/cdmi-container) | [RFC6208](https://tools.ietf.org/html/rfc6208)
`application/cdmi-domain` | [application/cdmi-domain](https://www.iana.org/assignments/media-types/application/cdmi-domain) | [RFC6208](https://tools.ietf.org/html/rfc6208)
`application/cdmi-object` | [application/cdmi-object](https://www.iana.org/assignments/media-types/application/cdmi-object) | [RFC6208](https://tools.ietf.org/html/rfc6208)
`application/cdmi-queue` | [application/cdmi-queue](https://www.iana.org/assignments/media-types/application/cdmi-queue) | [RFC6208](https://tools.ietf.org/html/rfc6208)
`application/cdni` | [application/cdni](https://www.iana.org/assignments/media-types/application/cdni) | [RFC7736](https://tools.ietf.org/html/rfc7736)
`application/CEA` | [application/CEA](https://www.iana.org/assignments/media-types/application/CEA) |
`application/cea-2018+xml` | [application/cea-2018+xml](https://www.iana.org/assignments/media-types/application/cea-2018+xml) |
`application/cellml+xml` | [application/cellml+xml](https://www.iana.org/assignments/media-types/application/cellml+xml) | [RFC4708](https://tools.ietf.org/html/rfc4708)
`application/cfw` | [application/cfw](https://www.iana.org/assignments/media-types/application/cfw) | [RFC6230](https://tools.ietf.org/html/rfc6230)
`application/cms` | [application/cms](https://www.iana.org/assignments/media-types/application/cms) | [RFC7193](https://tools.ietf.org/html/rfc7193)
`application/cnrp+xml` | [application/cnrp+xml](https://www.iana.org/assignments/media-types/application/cnrp+xml) | [RFC3367](https://tools.ietf.org/html/rfc3367)
`application/coap-group+json` | [application/coap-group+json](https://www.iana.org/assignments/media-types/application/coap-group+json) | [RFC7390](https://tools.ietf.org/html/rfc7390)
`application/commonground` | [application/commonground](https://www.iana.org/assignments/media-types/application/commonground) |
`application/conference-info+xml` | [application/conference-info+xml](https://www.iana.org/assignments/media-types/application/conference-info+xml) | [RFC4575](https://tools.ietf.org/html/rfc4575)
`application/cpl+xml` | [application/cpl+xml](https://www.iana.org/assignments/media-types/application/cpl+xml) | [RFC3880](https://tools.ietf.org/html/rfc3880)
`application/csrattrs` | [application/csrattrs](https://www.iana.org/assignments/media-types/application/csrattrs) | [RFC7030](https://tools.ietf.org/html/rfc7030)
`application/csta+xml` | [application/csta+xml](https://www.iana.org/assignments/media-types/application/csta+xml) |
`application/CSTAdata+xml` | [application/CSTAdata+xml](https://www.iana.org/assignments/media-types/application/CSTAdata+xml) |
`application/csvm+json` | [application/csvm+json](https://www.iana.org/assignments/media-types/application/csvm+json) |
`application/cybercash` | [application/cybercash](https://www.iana.org/assignments/media-types/application/cybercash) |
`application/dash+xml` | [application/dash+xml](https://www.iana.org/assignments/media-types/application/dash+xml) |
`application/dashdelta` | [application/dashdelta](https://www.iana.org/assignments/media-types/application/dashdelta) |
`application/davmount+xml` | [application/davmount+xml](https://www.iana.org/assignments/media-types/application/davmount+xml) | [RFC4709](https://tools.ietf.org/html/rfc4709)
`application/dca-rft` | [application/dca-rft](https://www.iana.org/assignments/media-types/application/dca-rft) |
`application/DCD` | [application/DCD](https://www.iana.org/assignments/media-types/application/DCD) |
`application/dec-dx` | [application/dec-dx](https://www.iana.org/assignments/media-types/application/dec-dx) |
`application/dialog-info+xml` | [application/dialog-info+xml](https://www.iana.org/assignments/media-types/application/dialog-info+xml) | [RFC4235](https://tools.ietf.org/html/rfc4235)
`application/dicom` | [application/dicom](https://www.iana.org/assignments/media-types/application/dicom) | [RFC3240](https://tools.ietf.org/html/rfc3240)
`application/DII` | [application/DII](https://www.iana.org/assignments/media-types/application/DII) |
`application/DIT` | [application/DIT](https://www.iana.org/assignments/media-types/application/DIT) |
`application/dns` | [application/dns](https://www.iana.org/assignments/media-types/application/dns) | [RFC4027](https://tools.ietf.org/html/rfc4027)
`application/dskpp+xml` | [application/dskpp+xml](https://www.iana.org/assignments/media-types/application/dskpp+xml) | [RFC6063](https://tools.ietf.org/html/rfc6063)
`application/dssc+der` | [application/dssc+der](https://www.iana.org/assignments/media-types/application/dssc+der) | [RFC5698](https://tools.ietf.org/html/rfc5698)
`application/dssc+xml` | [application/dssc+xml](https://www.iana.org/assignments/media-types/application/dssc+xml) | [RFC5698](https://tools.ietf.org/html/rfc5698)
`application/dvcs` | [application/dvcs](https://www.iana.org/assignments/media-types/application/dvcs) | [RFC3029](https://tools.ietf.org/html/rfc3029)
`application/ecmascript` | [application/ecmascript](https://www.iana.org/assignments/media-types/application/ecmascript) | [RFC4329](https://tools.ietf.org/html/rfc4329)
`application/EDI-consent` | [application/EDI-consent](https://www.iana.org/assignments/media-types/application/EDI-consent) | [RFC1767](https://tools.ietf.org/html/rfc1767)
`application/EDIFACT` | [application/EDIFACT](https://www.iana.org/assignments/media-types/application/EDIFACT) | [RFC1767](https://tools.ietf.org/html/rfc1767)
`application/EDI-X12` | [application/EDI-X12](https://www.iana.org/assignments/media-types/application/EDI-X12) | [RFC1767](https://tools.ietf.org/html/rfc1767)
`application/EmergencyCallData.Comment+xml` | [application/EmergencyCallData.Comment+xml](https://www.iana.org/assignments/media-types/application/EmergencyCallData.Comment+xml) | [RFC-ietf-ecrit-additional-data-37](https://tools.ietf.org/html/rfc-ietf-ecrit-additional-data-37)
`application/EmergencyCallData.DeviceInfo+xml` | [application/EmergencyCallData.DeviceInfo+xml](https://www.iana.org/assignments/media-types/application/EmergencyCallData.DeviceInfo+xml) | [RFC-ietf-ecrit-additional-data-37](https://tools.ietf.org/html/rfc-ietf-ecrit-additional-data-37)
`application/EmergencyCallData.ProviderInfo+xml` | [application/EmergencyCallData.ProviderInfo+xml](https://www.iana.org/assignments/media-types/application/EmergencyCallData.ProviderInfo+xml) | [RFC-ietf-ecrit-additional-data-37](https://tools.ietf.org/html/rfc-ietf-ecrit-additional-data-37)
`application/EmergencyCallData.ServiceInfo+xml` | [application/EmergencyCallData.ServiceInfo+xml](https://www.iana.org/assignments/media-types/application/EmergencyCallData.ServiceInfo+xml) | [RFC-ietf-ecrit-additional-data-37](https://tools.ietf.org/html/rfc-ietf-ecrit-additional-data-37)
`application/EmergencyCallData.SubscriberInfo+xml` | [application/EmergencyCallData.SubscriberInfo+xml](https://www.iana.org/assignments/media-types/application/EmergencyCallData.SubscriberInfo+xml) | [RFC-ietf-ecrit-additional-data-37](https://tools.ietf.org/html/rfc-ietf-ecrit-additional-data-37)
`application/emma+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/emotionml+xml` | [application/emotionml+xml](https://www.iana.org/assignments/media-types/application/emotionml+xml) |
`application/encaprtp` | [application/encaprtp](https://www.iana.org/assignments/media-types/application/encaprtp) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`application/epp+xml` | [application/epp+xml](https://www.iana.org/assignments/media-types/application/epp+xml) | [RFC5730](https://tools.ietf.org/html/rfc5730)
`application/epub+zip` | [application/epub+zip](https://www.iana.org/assignments/media-types/application/epub+zip) |
`application/eshop` | [application/eshop](https://www.iana.org/assignments/media-types/application/eshop) |
`application/example` | [application/example](https://www.iana.org/assignments/media-types/application/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`application/exi` | [](https://www.iana.org/assignments/media-types/) |
`application/fastinfoset` | [application/fastinfoset](https://www.iana.org/assignments/media-types/application/fastinfoset) |
`application/fastsoap` | [application/fastsoap](https://www.iana.org/assignments/media-types/application/fastsoap) |
`application/fdt+xml` | [application/fdt+xml](https://www.iana.org/assignments/media-types/application/fdt+xml) | [RFC6726](https://tools.ietf.org/html/rfc6726)
`application/fits` | [application/fits](https://www.iana.org/assignments/media-types/application/fits) | [RFC4047](https://tools.ietf.org/html/rfc4047)
`application/font-sfnt` | [application/font-sfnt](https://www.iana.org/assignments/media-types/application/font-sfnt) |
`application/font-tdpfr` | [application/font-tdpfr](https://www.iana.org/assignments/media-types/application/font-tdpfr) | [RFC3073](https://tools.ietf.org/html/rfc3073)
`application/font-woff` | [application/font-woff](https://www.iana.org/assignments/media-types/application/font-woff) |
`application/framework-attributes+xml` | [application/framework-attributes+xml](https://www.iana.org/assignments/media-types/application/framework-attributes+xml) | [RFC6230](https://tools.ietf.org/html/rfc6230)
`application/gzip` | [application/gzip](https://www.iana.org/assignments/media-types/application/gzip) | [RFC6713](https://tools.ietf.org/html/rfc6713)
`application/H224` | [application/H224](https://www.iana.org/assignments/media-types/application/H224) | [RFC4573](https://tools.ietf.org/html/rfc4573)
`application/held+xml` | [application/held+xml](https://www.iana.org/assignments/media-types/application/held+xml) | [RFC5985](https://tools.ietf.org/html/rfc5985)
`application/http` | [application/http](https://www.iana.org/assignments/media-types/application/http) | [RFC7230](https://tools.ietf.org/html/rfc7230)
`application/hyperstudio` | [application/hyperstudio](https://www.iana.org/assignments/media-types/application/hyperstudio) |
`application/ibe-key-request+xml` | [application/ibe-key-request+xml](https://www.iana.org/assignments/media-types/application/ibe-key-request+xml) | [RFC5408](https://tools.ietf.org/html/rfc5408)
`application/ibe-pkg-reply+xml` | [application/ibe-pkg-reply+xml](https://www.iana.org/assignments/media-types/application/ibe-pkg-reply+xml) | [RFC5408](https://tools.ietf.org/html/rfc5408)
`application/ibe-pp-data` | [application/ibe-pp-data](https://www.iana.org/assignments/media-types/application/ibe-pp-data) | [RFC5408](https://tools.ietf.org/html/rfc5408)
`application/iges` | [application/iges](https://www.iana.org/assignments/media-types/application/iges) |
`application/im-iscomposing+xml` | [application/im-iscomposing+xml](https://www.iana.org/assignments/media-types/application/im-iscomposing+xml) | [RFC3994](https://tools.ietf.org/html/rfc3994)
`application/index` | [application/index](https://www.iana.org/assignments/media-types/application/index) | [RFC2652](https://tools.ietf.org/html/rfc2652)
`application/index.cmd` | [application/index.cmd](https://www.iana.org/assignments/media-types/application/index.cmd) | [RFC2652](https://tools.ietf.org/html/rfc2652)
`application/index.obj` | [application/index-obj](https://www.iana.org/assignments/media-types/application/index-obj) | [RFC2652](https://tools.ietf.org/html/rfc2652)
`application/index.response` | [application/index.response](https://www.iana.org/assignments/media-types/application/index.response) | [RFC2652](https://tools.ietf.org/html/rfc2652)
`application/index.vnd` | [application/index.vnd](https://www.iana.org/assignments/media-types/application/index.vnd) | [RFC2652](https://tools.ietf.org/html/rfc2652)
`application/inkml+xml` | [application/inkml+xml](https://www.iana.org/assignments/media-types/application/inkml+xml) |
`application/iotp` | [application/IOTP](https://www.iana.org/assignments/media-types/application/IOTP) | [RFC2935](https://tools.ietf.org/html/rfc2935)
`application/ipfix` | [application/ipfix](https://www.iana.org/assignments/media-types/application/ipfix) | [RFC5655](https://tools.ietf.org/html/rfc5655)
`application/ipp` | [application/ipp](https://www.iana.org/assignments/media-types/application/ipp) | [RFC2910](https://tools.ietf.org/html/rfc2910)
`application/isup` | [application/ISUP](https://www.iana.org/assignments/media-types/application/ISUP) | [RFC3204](https://tools.ietf.org/html/rfc3204)
`application/its+xml` | [application/its+xml](https://www.iana.org/assignments/media-types/application/its+xml) |
`application/javascript` | [application/javascript](https://www.iana.org/assignments/media-types/application/javascript) | [RFC4329](https://tools.ietf.org/html/rfc4329)
`application/jose` | [application/jose](https://www.iana.org/assignments/media-types/application/jose) | [RFC7515](https://tools.ietf.org/html/rfc7515)
`application/jose+json` | [application/jose+json](https://www.iana.org/assignments/media-types/application/jose+json) | [RFC7515](https://tools.ietf.org/html/rfc7515)
`application/jrd+json` | [application/jrd+json](https://www.iana.org/assignments/media-types/application/jrd+json) | [RFC7033](https://tools.ietf.org/html/rfc7033)
`application/json` | [application/json](https://www.iana.org/assignments/media-types/application/json) | [RFC7158](https://tools.ietf.org/html/rfc7158)
`application/json-patch+json` | [application/json-patch+json](https://www.iana.org/assignments/media-types/application/json-patch+json) | [RFC6902](https://tools.ietf.org/html/rfc6902)
`application/json-seq` | [application/json-seq](https://www.iana.org/assignments/media-types/application/json-seq) | [RFC7464](https://tools.ietf.org/html/rfc7464)
`application/jwk+json` | [application/jwk+json](https://www.iana.org/assignments/media-types/application/jwk+json) | [RFC7517](https://tools.ietf.org/html/rfc7517)
`application/jwk-set+json` | [application/jwk-set+json](https://www.iana.org/assignments/media-types/application/jwk-set+json) | [RFC7517](https://tools.ietf.org/html/rfc7517)
`application/jwt` | [application/jwt](https://www.iana.org/assignments/media-types/application/jwt) | [RFC7519](https://tools.ietf.org/html/rfc7519)
`application/kpml-request+xml` | [application/kpml-request+xml](https://www.iana.org/assignments/media-types/application/kpml-request+xml) | [RFC4730](https://tools.ietf.org/html/rfc4730)
`application/kpml-response+xml` | [application/kpml-response+xml](https://www.iana.org/assignments/media-types/application/kpml-response+xml) | [RFC4730](https://tools.ietf.org/html/rfc4730)
`application/ld+json` | [application/ld+json](https://www.iana.org/assignments/media-types/application/ld+json) |
`application/link-format` | [application/link-format](https://www.iana.org/assignments/media-types/application/link-format) | [RFC6690](https://tools.ietf.org/html/rfc6690)
`application/load-control+xml` | [application/load-control+xml](https://www.iana.org/assignments/media-types/application/load-control+xml) | [RFC7200](https://tools.ietf.org/html/rfc7200)
`application/lost+xml` | [application/lost+xml](https://www.iana.org/assignments/media-types/application/lost+xml) | [RFC5222](https://tools.ietf.org/html/rfc5222)
`application/lostsync+xml` | [application/lostsync+xml](https://www.iana.org/assignments/media-types/application/lostsync+xml) | [RFC6739](https://tools.ietf.org/html/rfc6739)
`application/LXF` | [application/LXF](https://www.iana.org/assignments/media-types/application/LXF) |
`application/mac-binhex40` | [application/mac-binhex40](https://www.iana.org/assignments/media-types/application/mac-binhex40) |
`application/macwriteii` | [application/macwriteii](https://www.iana.org/assignments/media-types/application/macwriteii) |
`application/mads+xml` | [application/mads+xml](https://www.iana.org/assignments/media-types/application/mads+xml) | [RFC6207](https://tools.ietf.org/html/rfc6207)
`application/marc` | [application/marc](https://www.iana.org/assignments/media-types/application/marc) | [RFC2220](https://tools.ietf.org/html/rfc2220)
`application/marcxml+xml` | [application/marcxml+xml](https://www.iana.org/assignments/media-types/application/marcxml+xml) | [RFC6207](https://tools.ietf.org/html/rfc6207)
`application/mathematica` | [application/mathematica](https://www.iana.org/assignments/media-types/application/mathematica) |
`application/mathml-content+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/mathml-presentation+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/mathml+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/mbms-associated-procedure-description+xml` | [application/mbms-associated-procedure-description+xml](https://www.iana.org/assignments/media-types/application/mbms-associated-procedure-description+xml) |
`application/mbms-deregister+xml` | [application/mbms-deregister+xml](https://www.iana.org/assignments/media-types/application/mbms-deregister+xml) |
`application/mbms-envelope+xml` | [application/mbms-envelope+xml](https://www.iana.org/assignments/media-types/application/mbms-envelope+xml) |
`application/mbms-msk-response+xml` | [application/mbms-msk-response+xml](https://www.iana.org/assignments/media-types/application/mbms-msk-response+xml) |
`application/mbms-msk+xml` | [application/mbms-msk+xml](https://www.iana.org/assignments/media-types/application/mbms-msk+xml) |
`application/mbms-protection-description+xml` | [application/mbms-protection-description+xml](https://www.iana.org/assignments/media-types/application/mbms-protection-description+xml) |
`application/mbms-reception-report+xml` | [application/mbms-reception-report+xml](https://www.iana.org/assignments/media-types/application/mbms-reception-report+xml) |
`application/mbms-register-response+xml` | [application/mbms-register-response+xml](https://www.iana.org/assignments/media-types/application/mbms-register-response+xml) |
`application/mbms-register+xml` | [application/mbms-register+xml](https://www.iana.org/assignments/media-types/application/mbms-register+xml) |
`application/mbms-schedule+xml` | [application/mbms-schedule+xml](https://www.iana.org/assignments/media-types/application/mbms-schedule+xml) |
`application/mbms-user-service-description+xml` | [application/mbms-user-service-description+xml](https://www.iana.org/assignments/media-types/application/mbms-user-service-description+xml) |
`application/mbox` | [application/mbox](https://www.iana.org/assignments/media-types/application/mbox) | [RFC4155](https://tools.ietf.org/html/rfc4155)
`application/media_control+xml` | [application/media_control+xml](https://www.iana.org/assignments/media-types/application/media_control+xml) | [RFC5168](https://tools.ietf.org/html/rfc5168)
`application/media-policy-dataset+xml` | [application/media-policy-dataset+xml](https://www.iana.org/assignments/media-types/application/media-policy-dataset+xml) | [RFC6796](https://tools.ietf.org/html/rfc6796)
`application/mediaservercontrol+xml` | [application/mediaservercontrol+xml](https://www.iana.org/assignments/media-types/application/mediaservercontrol+xml) | [RFC5022](https://tools.ietf.org/html/rfc5022)
`application/merge-patch+json` | [application/merge-patch+json](https://www.iana.org/assignments/media-types/application/merge-patch+json) | [RFC7396](https://tools.ietf.org/html/rfc7396)
`application/metalink4+xml` | [application/metalink4+xml](https://www.iana.org/assignments/media-types/application/metalink4+xml) | [RFC5854](https://tools.ietf.org/html/rfc5854)
`application/mets+xml` | [application/mets+xml](https://www.iana.org/assignments/media-types/application/mets+xml) | [RFC6207](https://tools.ietf.org/html/rfc6207)
`application/MF4` | [application/MF4](https://www.iana.org/assignments/media-types/application/MF4) |
`application/mikey` | [application/mikey](https://www.iana.org/assignments/media-types/application/mikey) | [RFC3830](https://tools.ietf.org/html/rfc3830)
`application/mods+xml` | [application/mods+xml](https://www.iana.org/assignments/media-types/application/mods+xml) | [RFC6207](https://tools.ietf.org/html/rfc6207)
`application/moss-keys` | [application/moss-keys](https://www.iana.org/assignments/media-types/application/moss-keys) | [RFC1848](https://tools.ietf.org/html/rfc1848)
`application/moss-signature` | [application/moss-signature](https://www.iana.org/assignments/media-types/application/moss-signature) | [RFC1848](https://tools.ietf.org/html/rfc1848)
`application/mosskey-data` | [application/mosskey-data](https://www.iana.org/assignments/media-types/application/mosskey-data) | [RFC1848](https://tools.ietf.org/html/rfc1848)
`application/mosskey-request` | [application/mosskey-request](https://www.iana.org/assignments/media-types/application/mosskey-request) | [RFC1848](https://tools.ietf.org/html/rfc1848)
`application/mp21` | [application/mp21](https://www.iana.org/assignments/media-types/application/mp21) | [RFC6381](https://tools.ietf.org/html/rfc6381)
`application/mp4` | [application/mp4](https://www.iana.org/assignments/media-types/application/mp4) | [RFC4337](https://tools.ietf.org/html/rfc4337), [RFC6381](https://tools.ietf.org/html/rfc6381)
`application/mpeg4-generic` | [application/mpeg4-generic](https://www.iana.org/assignments/media-types/application/mpeg4-generic) | [RFC3640](https://tools.ietf.org/html/rfc3640)
`application/mpeg4-iod` | [application/mpeg4-iod](https://www.iana.org/assignments/media-types/application/mpeg4-iod) | [RFC4337](https://tools.ietf.org/html/rfc4337)
`application/mpeg4-iod-xmt` | [application/mpeg4-iod-xmt](https://www.iana.org/assignments/media-types/application/mpeg4-iod-xmt) | [RFC4337](https://tools.ietf.org/html/rfc4337)
`application/mrb-consumer+xml` | [application/mrb-consumer+xml](https://www.iana.org/assignments/media-types/application/mrb-consumer+xml) | [RFC6917](https://tools.ietf.org/html/rfc6917)
`application/mrb-publish+xml` | [application/mrb-publish+xml](https://www.iana.org/assignments/media-types/application/mrb-publish+xml) | [RFC6917](https://tools.ietf.org/html/rfc6917)
`application/msc-ivr+xml` | [application/msc-ivr+xml](https://www.iana.org/assignments/media-types/application/msc-ivr+xml) | [RFC6231](https://tools.ietf.org/html/rfc6231)
`application/msc-mixer+xml` | [application/msc-mixer+xml](https://www.iana.org/assignments/media-types/application/msc-mixer+xml) | [RFC6505](https://tools.ietf.org/html/rfc6505)
`application/msword` | [application/msword](https://www.iana.org/assignments/media-types/application/msword) |
`application/mxf` | [application/mxf](https://www.iana.org/assignments/media-types/application/mxf) | [RFC4539](https://tools.ietf.org/html/rfc4539)
`application/nasdata` | [application/nasdata](https://www.iana.org/assignments/media-types/application/nasdata) | [RFC4707](https://tools.ietf.org/html/rfc4707)
`application/news-checkgroups` | [application/news-checkgroups](https://www.iana.org/assignments/media-types/application/news-checkgroups) | [RFC5537](https://tools.ietf.org/html/rfc5537)
`application/news-groupinfo` | [application/news-groupinfo](https://www.iana.org/assignments/media-types/application/news-groupinfo) | [RFC5537](https://tools.ietf.org/html/rfc5537)
`application/news-transmission` | [application/news-transmission](https://www.iana.org/assignments/media-types/application/news-transmission) | [RFC5537](https://tools.ietf.org/html/rfc5537)
`application/nlsml+xml` | [application/nlsml+xml](https://www.iana.org/assignments/media-types/application/nlsml+xml) | [RFC6787](https://tools.ietf.org/html/rfc6787)
`application/nss` | [application/nss](https://www.iana.org/assignments/media-types/application/nss) |
`application/ocsp-request` | [application/ocsp-request](https://www.iana.org/assignments/media-types/application/ocsp-request) | [RFC6960](https://tools.ietf.org/html/rfc6960)
`application/ocsp-response` | [application/ocsp-response](https://www.iana.org/assignments/media-types/application/ocsp-response) | [RFC6960](https://tools.ietf.org/html/rfc6960)
`application/octet-stream` | [application/octet-stream](https://www.iana.org/assignments/media-types/application/octet-stream) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`application/oda` | [application/ODA](https://www.iana.org/assignments/media-types/application/ODA) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`application/ODX` | [application/ODX](https://www.iana.org/assignments/media-types/application/ODX) |
`application/oebps-package+xml` | [application/oebps-package+xml](https://www.iana.org/assignments/media-types/application/oebps-package+xml) | [RFC4839](https://tools.ietf.org/html/rfc4839)
`application/ogg` | [application/ogg](https://www.iana.org/assignments/media-types/application/ogg) | [RFC5334](https://tools.ietf.org/html/rfc5334)
`application/oxps` | [application/oxps](https://www.iana.org/assignments/media-types/application/oxps) |
`application/p2p-overlay+xml` | [application/p2p-overlay+xml](https://www.iana.org/assignments/media-types/application/p2p-overlay+xml) | [RFC6940](https://tools.ietf.org/html/rfc6940)
`application/parityfec` | [](https://www.iana.org/assignments/media-types/) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`application/patch-ops-error+xml` | [application/patch-ops-error+xml](https://www.iana.org/assignments/media-types/application/patch-ops-error+xml) | [RFC5261](https://tools.ietf.org/html/rfc5261)
`application/pdf` | [application/pdf](https://www.iana.org/assignments/media-types/application/pdf) | [RFC3778](https://tools.ietf.org/html/rfc3778)
`application/PDX` | [application/PDX](https://www.iana.org/assignments/media-types/application/PDX) |
`application/pgp-encrypted` | [application/pgp-encrypted](https://www.iana.org/assignments/media-types/application/pgp-encrypted) | [RFC3156](https://tools.ietf.org/html/rfc3156)
`application/pgp-keys` | [](https://www.iana.org/assignments/media-types/) | [RFC3156](https://tools.ietf.org/html/rfc3156)
`application/pgp-signature` | [application/pgp-signature](https://www.iana.org/assignments/media-types/application/pgp-signature) | [RFC3156](https://tools.ietf.org/html/rfc3156)
`application/pidf-diff+xml` | [application/pidf-diff+xml](https://www.iana.org/assignments/media-types/application/pidf-diff+xml) | [RFC5262](https://tools.ietf.org/html/rfc5262)
`application/pidf+xml` | [application/pidf+xml](https://www.iana.org/assignments/media-types/application/pidf+xml) | [RFC3863](https://tools.ietf.org/html/rfc3863)
`application/pkcs10` | [application/pkcs10](https://www.iana.org/assignments/media-types/application/pkcs10) | [RFC5967](https://tools.ietf.org/html/rfc5967)
`application/pkcs7-mime` | [application/pkcs7-mime](https://www.iana.org/assignments/media-types/application/pkcs7-mime) | [RFC5751](https://tools.ietf.org/html/rfc5751), [RFC7114](https://tools.ietf.org/html/rfc7114)
`application/pkcs7-signature` | [application/pkcs7-signature](https://www.iana.org/assignments/media-types/application/pkcs7-signature) | [RFC5751](https://tools.ietf.org/html/rfc5751)
`application/pkcs8` | [application/pkcs8](https://www.iana.org/assignments/media-types/application/pkcs8) | [RFC5958](https://tools.ietf.org/html/rfc5958)
`application/pkcs12` | [application/pkcs12](https://www.iana.org/assignments/media-types/application/pkcs12) |
`application/pkix-attr-cert` | [application/pkix-attr-cert](https://www.iana.org/assignments/media-types/application/pkix-attr-cert) | [RFC5877](https://tools.ietf.org/html/rfc5877)
`application/pkix-cert` | [application/pkix-cert](https://www.iana.org/assignments/media-types/application/pkix-cert) | [RFC2585](https://tools.ietf.org/html/rfc2585)
`application/pkix-crl` | [application/pkix-crl](https://www.iana.org/assignments/media-types/application/pkix-crl) | [RFC2585](https://tools.ietf.org/html/rfc2585)
`application/pkix-pkipath` | [application/pkix-pkipath](https://www.iana.org/assignments/media-types/application/pkix-pkipath) | [RFC6066](https://tools.ietf.org/html/rfc6066)
`application/pkixcmp` | [application/pkixcmp](https://www.iana.org/assignments/media-types/application/pkixcmp) | [RFC2510](https://tools.ietf.org/html/rfc2510)
`application/pls+xml` | [application/pls+xml](https://www.iana.org/assignments/media-types/application/pls+xml) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/poc-settings+xml` | [application/poc-settings+xml](https://www.iana.org/assignments/media-types/application/poc-settings+xml) | [RFC4354](https://tools.ietf.org/html/rfc4354)
`application/postscript` | [application/postscript](https://www.iana.org/assignments/media-types/application/postscript) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`application/ppsp-tracker+json` | [application/ppsp-tracker+json](https://www.iana.org/assignments/media-types/application/ppsp-tracker+json) | [RFC-ietf-ppsp-base-tracker-protocol-11](https://tools.ietf.org/html/rfc-ietf-ppsp-base-tracker-protocol-11)
`application/problem+json` | [application/problem+json](https://www.iana.org/assignments/media-types/application/problem+json) | [RFC-ietf-appsawg-http-problem-03](https://tools.ietf.org/html/rfc-ietf-appsawg-http-problem-03)
`application/problem+xml` | [application/problem+xml](https://www.iana.org/assignments/media-types/application/problem+xml) | [RFC-ietf-appsawg-http-problem-03](https://tools.ietf.org/html/rfc-ietf-appsawg-http-problem-03)
`application/provenance+xml` | [application/provenance+xml](https://www.iana.org/assignments/media-types/application/provenance+xml) |
`application/prs.alvestrand.titrax-sheet` | [application/prs.alvestrand.titrax-sheet](https://www.iana.org/assignments/media-types/application/prs.alvestrand.titrax-sheet) |
`application/prs.cww` | [application/prs.cww](https://www.iana.org/assignments/media-types/application/prs.cww) |
`application/prs.hpub+zip` | [application/prs.hpub+zip](https://www.iana.org/assignments/media-types/application/prs.hpub+zip) |
`application/prs.nprend` | [application/prs.nprend](https://www.iana.org/assignments/media-types/application/prs.nprend) |
`application/prs.plucker` | [application/prs.plucker](https://www.iana.org/assignments/media-types/application/prs.plucker) |
`application/prs.rdf-xml-crypt` | [application/prs.rdf-xml-crypt](https://www.iana.org/assignments/media-types/application/prs.rdf-xml-crypt) |
`application/prs.xsf+xml` | [application/prs.xsf+xml](https://www.iana.org/assignments/media-types/application/prs.xsf+xml) |
`application/pskc+xml` | [application/pskc+xml](https://www.iana.org/assignments/media-types/application/pskc+xml) | [RFC6030](https://tools.ietf.org/html/rfc6030)
`application/rdf+xml` | [application/rdf+xml](https://www.iana.org/assignments/media-types/application/rdf+xml) | [RFC3870](https://tools.ietf.org/html/rfc3870)
`application/qsig` | [application/QSIG](https://www.iana.org/assignments/media-types/application/QSIG) | [RFC3204](https://tools.ietf.org/html/rfc3204)
`application/raptorfec` | [application/raptorfec](https://www.iana.org/assignments/media-types/application/raptorfec) | [RFC6682](https://tools.ietf.org/html/rfc6682)
`application/rdap+json` | [application/rdap+json](https://www.iana.org/assignments/media-types/application/rdap+json) | [RFC7483](https://tools.ietf.org/html/rfc7483)
`application/reginfo+xml` | [application/reginfo+xml](https://www.iana.org/assignments/media-types/application/reginfo+xml) | [RFC3680](https://tools.ietf.org/html/rfc3680)
`application/relax-ng-compact-syntax` | [application/relax-ng-compact-syntax](https://www.iana.org/assignments/media-types/application/relax-ng-compact-syntax) |
`application/remote-printing` | [application/remote-printing](https://www.iana.org/assignments/media-types/application/remote-printing) | [RFC1486](https://tools.ietf.org/html/rfc1486)
`application/reputon+json` | [application/reputon+json](https://www.iana.org/assignments/media-types/application/reputon+json) | [RFC7071](https://tools.ietf.org/html/rfc7071)
`application/resource-lists-diff+xml` | [application/resource-lists-diff+xml](https://www.iana.org/assignments/media-types/application/resource-lists-diff+xml) | [RFC5362](https://tools.ietf.org/html/rfc5362)
`application/resource-lists+xml` | [application/resource-lists+xml](https://www.iana.org/assignments/media-types/application/resource-lists+xml) | [RFC4826](https://tools.ietf.org/html/rfc4826)
`application/rfc+xml` | [application/rfc+xml](https://www.iana.org/assignments/media-types/application/rfc+xml) | [RFC7749](https://tools.ietf.org/html/rfc7749)
`application/riscos` | [application/riscos](https://www.iana.org/assignments/media-types/application/riscos) |
`application/rlmi+xml` | [application/rlmi+xml](https://www.iana.org/assignments/media-types/application/rlmi+xml) | [RFC4662](https://tools.ietf.org/html/rfc4662)
`application/rls-services+xml` | [application/rls-services+xml](https://www.iana.org/assignments/media-types/application/rls-services+xml) | [RFC4826](https://tools.ietf.org/html/rfc4826)
`application/rpki-ghostbusters` | [application/rpki-ghostbusters](https://www.iana.org/assignments/media-types/application/rpki-ghostbusters) | [RFC6493](https://tools.ietf.org/html/rfc6493)
`application/rpki-manifest` | [application/rpki-manifest](https://www.iana.org/assignments/media-types/application/rpki-manifest) | [RFC6481](https://tools.ietf.org/html/rfc6481)
`application/rpki-roa` | [application/rpki-roa](https://www.iana.org/assignments/media-types/application/rpki-roa) | [RFC6481](https://tools.ietf.org/html/rfc6481)
`application/rpki-updown` | [application/rpki-updown](https://www.iana.org/assignments/media-types/application/rpki-updown) | [RFC6492](https://tools.ietf.org/html/rfc6492)
`application/rtf` | [application/rtf](https://www.iana.org/assignments/media-types/application/rtf) |
`application/rtploopback` | [application/rtploopback](https://www.iana.org/assignments/media-types/application/rtploopback) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`application/rtx` | [application/rtx](https://www.iana.org/assignments/media-types/application/rtx) | [RFC4588](https://tools.ietf.org/html/rfc4588)
`application/samlassertion+xml` | [application/samlassertion+xml](https://www.iana.org/assignments/media-types/application/samlassertion+xml) |
`application/samlmetadata+xml` | [application/samlmetadata+xml](https://www.iana.org/assignments/media-types/application/samlmetadata+xml) |
`application/sbml+xml` | [application/sbml+xml](https://www.iana.org/assignments/media-types/application/sbml+xml) | [RFC3823](https://tools.ietf.org/html/rfc3823)
`application/scaip+xml` | [application/scaip+xml](https://www.iana.org/assignments/media-types/application/scaip+xml) |
`application/scim+json` | [application/scim+json](https://www.iana.org/assignments/media-types/application/scim+json) | [RFC7644](https://tools.ietf.org/html/rfc7644)
`application/scvp-cv-request` | [application/scvp-cv-request](https://www.iana.org/assignments/media-types/application/scvp-cv-request) | [RFC5055](https://tools.ietf.org/html/rfc5055)
`application/scvp-cv-response` | [application/scvp-cv-response](https://www.iana.org/assignments/media-types/application/scvp-cv-response) | [RFC5055](https://tools.ietf.org/html/rfc5055)
`application/scvp-vp-request` | [application/scvp-vp-request](https://www.iana.org/assignments/media-types/application/scvp-vp-request) | [RFC5055](https://tools.ietf.org/html/rfc5055)
`application/scvp-vp-response` | [application/scvp-vp-response](https://www.iana.org/assignments/media-types/application/scvp-vp-response) | [RFC5055](https://tools.ietf.org/html/rfc5055)
`application/sdp` | [application/sdp](https://www.iana.org/assignments/media-types/application/sdp) | [RFC4566](https://tools.ietf.org/html/rfc4566)
`application/sep-exi` | [application/sep-exi](https://www.iana.org/assignments/media-types/application/sep-exi) |
`application/sep+xml` | [application/sep+xml](https://www.iana.org/assignments/media-types/application/sep+xml) |
`application/session-info` | [application/session-info](https://www.iana.org/assignments/media-types/application/session-info) |
`application/set-payment` | [application/set-payment](https://www.iana.org/assignments/media-types/application/set-payment) |
`application/set-payment-initiation` | [application/set-payment-initiation](https://www.iana.org/assignments/media-types/application/set-payment-initiation) |
`application/set-registration` | [application/set-registration](https://www.iana.org/assignments/media-types/application/set-registration) |
`application/set-registration-initiation` | [application/set-registration-initiation](https://www.iana.org/assignments/media-types/application/set-registration-initiation) |
`application/sgml` | [application/SGML](https://www.iana.org/assignments/media-types/application/SGML) | [RFC1874](https://tools.ietf.org/html/rfc1874)
`application/sgml-open-catalog` | [application/sgml-open-catalog](https://www.iana.org/assignments/media-types/application/sgml-open-catalog) |
`application/shf+xml` | [application/shf+xml](https://www.iana.org/assignments/media-types/application/shf+xml) | [RFC4194](https://tools.ietf.org/html/rfc4194)
`application/sieve` | [application/sieve](https://www.iana.org/assignments/media-types/application/sieve) | [RFC5228](https://tools.ietf.org/html/rfc5228)
`application/simple-filter+xml` | [application/simple-filter+xml](https://www.iana.org/assignments/media-types/application/simple-filter+xml) | [RFC4661](https://tools.ietf.org/html/rfc4661)
`application/simple-message-summary` | [application/simple-message-summary](https://www.iana.org/assignments/media-types/application/simple-message-summary) | [RFC3842](https://tools.ietf.org/html/rfc3842)
`application/simpleSymbolContainer` | [application/simpleSymbolContainer](https://www.iana.org/assignments/media-types/application/simpleSymbolContainer) |
`application/slate` | [application/slate](https://www.iana.org/assignments/media-types/application/slate) |
`application/smil - OBSOLETED in favor of application/smil+xml` | [application/smil](https://www.iana.org/assignments/media-types/application/smil) | [RFC4536](https://tools.ietf.org/html/rfc4536)
`application/smil+xml` | [application/smil+xml](https://www.iana.org/assignments/media-types/application/smil+xml) | [RFC4536](https://tools.ietf.org/html/rfc4536)
`application/smpte336m` | [application/smpte336m](https://www.iana.org/assignments/media-types/application/smpte336m) | [RFC6597](https://tools.ietf.org/html/rfc6597)
`application/soap+fastinfoset` | [application/soap+fastinfoset](https://www.iana.org/assignments/media-types/application/soap+fastinfoset) |
`application/soap+xml` | [application/soap+xml](https://www.iana.org/assignments/media-types/application/soap+xml) | [RFC3902](https://tools.ietf.org/html/rfc3902)
`application/sparql-query` | [](https://www.iana.org/assignments/media-types/) |
`application/sparql-results+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/spirits-event+xml` | [application/spirits-event+xml](https://www.iana.org/assignments/media-types/application/spirits-event+xml) | [RFC3910](https://tools.ietf.org/html/rfc3910)
`application/sql` | [application/sql](https://www.iana.org/assignments/media-types/application/sql) | [RFC6922](https://tools.ietf.org/html/rfc6922)
`application/srgs` | [application/srgs](https://www.iana.org/assignments/media-types/application/srgs) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/srgs+xml` | [application/srgs+xml](https://www.iana.org/assignments/media-types/application/srgs+xml) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/sru+xml` | [application/sru+xml](https://www.iana.org/assignments/media-types/application/sru+xml) | [RFC6207](https://tools.ietf.org/html/rfc6207)
`application/ssml+xml` | [application/ssml+xml](https://www.iana.org/assignments/media-types/application/ssml+xml) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/tamp-apex-update` | [application/tamp-apex-update](https://www.iana.org/assignments/media-types/application/tamp-apex-update) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-apex-update-confirm` | [application/tamp-apex-update-confirm](https://www.iana.org/assignments/media-types/application/tamp-apex-update-confirm) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-community-update` | [application/tamp-community-update](https://www.iana.org/assignments/media-types/application/tamp-community-update) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-community-update-confirm` | [application/tamp-community-update-confirm](https://www.iana.org/assignments/media-types/application/tamp-community-update-confirm) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-error` | [application/tamp-error](https://www.iana.org/assignments/media-types/application/tamp-error) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-sequence-adjust` | [application/tamp-sequence-adjust](https://www.iana.org/assignments/media-types/application/tamp-sequence-adjust) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-sequence-adjust-confirm` | [application/tamp-sequence-adjust-confirm](https://www.iana.org/assignments/media-types/application/tamp-sequence-adjust-confirm) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-status-query` | [application/tamp-status-query](https://www.iana.org/assignments/media-types/application/tamp-status-query) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-status-response` | [application/tamp-status-response](https://www.iana.org/assignments/media-types/application/tamp-status-response) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-update` | [application/tamp-update](https://www.iana.org/assignments/media-types/application/tamp-update) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tamp-update-confirm` | [application/tamp-update-confirm](https://www.iana.org/assignments/media-types/application/tamp-update-confirm) | [RFC5934](https://tools.ietf.org/html/rfc5934)
`application/tei+xml` | [application/tei+xml](https://www.iana.org/assignments/media-types/application/tei+xml) | [RFC6129](https://tools.ietf.org/html/rfc6129)
`application/thraud+xml` | [application/thraud+xml](https://www.iana.org/assignments/media-types/application/thraud+xml) | [RFC5941](https://tools.ietf.org/html/rfc5941)
`application/timestamp-query` | [application/timestamp-query](https://www.iana.org/assignments/media-types/application/timestamp-query) | [RFC3161](https://tools.ietf.org/html/rfc3161)
`application/timestamp-reply` | [application/timestamp-reply](https://www.iana.org/assignments/media-types/application/timestamp-reply) | [RFC3161](https://tools.ietf.org/html/rfc3161)
`application/timestamped-data` | [application/timestamped-data](https://www.iana.org/assignments/media-types/application/timestamped-data) | [RFC5955](https://tools.ietf.org/html/rfc5955)
`application/ttml+xml` | [application/ttml+xml](https://www.iana.org/assignments/media-types/application/ttml+xml) |
`application/tve-trigger` | [application/tve-trigger](https://www.iana.org/assignments/media-types/application/tve-trigger) |
`application/ulpfec` | [application/ulpfec](https://www.iana.org/assignments/media-types/application/ulpfec) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`application/urc-grpsheet+xml` | [application/urc-grpsheet+xml](https://www.iana.org/assignments/media-types/application/urc-grpsheet+xml) |
`application/urc-ressheet+xml` | [application/urc-ressheet+xml](https://www.iana.org/assignments/media-types/application/urc-ressheet+xml) |
`application/urc-targetdesc+xml` | [application/urc-targetdesc+xml](https://www.iana.org/assignments/media-types/application/urc-targetdesc+xml) |
`application/urc-uisocketdesc+xml` | [application/urc-uisocketdesc+xml](https://www.iana.org/assignments/media-types/application/urc-uisocketdesc+xml) |
`application/vcard+json` | [application/vcard+json](https://www.iana.org/assignments/media-types/application/vcard+json) | [RFC7095](https://tools.ietf.org/html/rfc7095)
`application/vcard+xml` | [application/vcard+xml](https://www.iana.org/assignments/media-types/application/vcard+xml) | [RFC6351](https://tools.ietf.org/html/rfc6351)
`application/vemmi` | [application/vemmi](https://www.iana.org/assignments/media-types/application/vemmi) | [RFC2122](https://tools.ietf.org/html/rfc2122)
`application/vnd.3gpp.access-transfer-events+xml` | [application/vnd.3gpp.access-transfer-events+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.access-transfer-events+xml) |
`application/vnd.3gpp.bsf+xml` | [application/vnd.3gpp.bsf+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.bsf+xml) |
`application/vnd.3gpp.mid-call+xml` | [application/vnd.3gpp.mid-call+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.mid-call+xml) |
`application/vnd.3gpp.pic-bw-large` | [application/vnd.3gpp.pic-bw-large](https://www.iana.org/assignments/media-types/application/vnd.3gpp.pic-bw-large) |
`application/vnd.3gpp.pic-bw-small` | [application/vnd.3gpp.pic-bw-small](https://www.iana.org/assignments/media-types/application/vnd.3gpp.pic-bw-small) |
`application/vnd.3gpp.pic-bw-var` | [application/vnd.3gpp.pic-bw-var](https://www.iana.org/assignments/media-types/application/vnd.3gpp.pic-bw-var) |
`application/vnd.3gpp-prose-pc3ch+xml` | [application/vnd.3gpp-prose-pc3ch+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp-prose-pc3ch+xml) |
`application/vnd.3gpp-prose+xml` | [application/vnd.3gpp-prose+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp-prose+xml) |
`application/vnd.3gpp.sms` | [application/vnd.3gpp.sms](https://www.iana.org/assignments/media-types/application/vnd.3gpp.sms) |
`application/vnd.3gpp.srvcc-ext+xml` | [application/vnd.3gpp.srvcc-ext+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.srvcc-ext+xml) |
`application/vnd.3gpp.SRVCC-info+xml` | [application/vnd.3gpp.SRVCC-info+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.SRVCC-info+xml) |
`application/vnd.3gpp.state-and-event-info+xml` | [application/vnd.3gpp.state-and-event-info+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.state-and-event-info+xml) |
`application/vnd.3gpp.ussd+xml` | [application/vnd.3gpp.ussd+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp.ussd+xml) |
`application/vnd.3gpp2.bcmcsinfo+xml` | [application/vnd.3gpp2.bcmcsinfo+xml](https://www.iana.org/assignments/media-types/application/vnd.3gpp2.bcmcsinfo+xml) |
`application/vnd.3gpp2.sms` | [application/vnd.3gpp2.sms](https://www.iana.org/assignments/media-types/application/vnd.3gpp2.sms) |
`application/vnd.3gpp2.tcap` | [application/vnd.3gpp2.tcap](https://www.iana.org/assignments/media-types/application/vnd.3gpp2.tcap) |
`application/vnd.3M.Post-it-Notes` | [application/vnd.3M.Post-it-Notes](https://www.iana.org/assignments/media-types/application/vnd.3M.Post-it-Notes) |
`application/vnd.accpac.simply.aso` | [application/vnd.accpac.simply.aso](https://www.iana.org/assignments/media-types/application/vnd.accpac.simply.aso) |
`application/vnd.accpac.simply.imp` | [application/vnd.accpac.simply.imp](https://www.iana.org/assignments/media-types/application/vnd.accpac.simply.imp) |
`application/vnd.acucobol` | [application/vnd-acucobol](https://www.iana.org/assignments/media-types/application/vnd-acucobol) |
`application/vnd.acucorp` | [application/vnd.acucorp](https://www.iana.org/assignments/media-types/application/vnd.acucorp) |
`application/vnd.adobe.flash.movie` | [application/vnd.adobe.flash-movie](https://www.iana.org/assignments/media-types/application/vnd.adobe.flash-movie) |
`application/vnd.adobe.formscentral.fcdt` | [application/vnd.adobe.formscentral.fcdt](https://www.iana.org/assignments/media-types/application/vnd.adobe.formscentral.fcdt) |
`application/vnd.adobe.fxp` | [application/vnd.adobe.fxp](https://www.iana.org/assignments/media-types/application/vnd.adobe.fxp) |
`application/vnd.adobe.partial-upload` | [application/vnd.adobe.partial-upload](https://www.iana.org/assignments/media-types/application/vnd.adobe.partial-upload) |
`application/vnd.adobe.xdp+xml` | [application/vnd.adobe.xdp+xml](https://www.iana.org/assignments/media-types/application/vnd.adobe.xdp+xml) |
`application/vnd.adobe.xfdf` | [application/vnd.adobe.xfdf](https://www.iana.org/assignments/media-types/application/vnd.adobe.xfdf) |
`application/vnd.aether.imp` | [application/vnd.aether.imp](https://www.iana.org/assignments/media-types/application/vnd.aether.imp) |
`application/vnd.ah-barcode` | [application/vnd.ah-barcode](https://www.iana.org/assignments/media-types/application/vnd.ah-barcode) |
`application/vnd.ahead.space` | [application/vnd.ahead.space](https://www.iana.org/assignments/media-types/application/vnd.ahead.space) |
`application/vnd.airzip.filesecure.azf` | [application/vnd.airzip.filesecure.azf](https://www.iana.org/assignments/media-types/application/vnd.airzip.filesecure.azf) |
`application/vnd.airzip.filesecure.azs` | [application/vnd.airzip.filesecure.azs](https://www.iana.org/assignments/media-types/application/vnd.airzip.filesecure.azs) |
`application/vnd.americandynamics.acc` | [application/vnd.americandynamics.acc](https://www.iana.org/assignments/media-types/application/vnd.americandynamics.acc) |
`application/vnd.amiga.ami` | [application/vnd.amiga.ami](https://www.iana.org/assignments/media-types/application/vnd.amiga.ami) |
`application/vnd.amundsen.maze+xml` | [application/vnd.amundsen.maze+xml](https://www.iana.org/assignments/media-types/application/vnd.amundsen.maze+xml) |
`application/vnd.anki` | [application/vnd.anki](https://www.iana.org/assignments/media-types/application/vnd.anki) |
`application/vnd.anser-web-certificate-issue-initiation` | [application/vnd.anser-web-certificate-issue-initiation](https://www.iana.org/assignments/media-types/application/vnd.anser-web-certificate-issue-initiation) |
`application/vnd.antix.game-component` | [application/vnd.antix.game-component](https://www.iana.org/assignments/media-types/application/vnd.antix.game-component) |
`application/vnd.apache.thrift.binary` | [application/vnd.apache.thrift.binary](https://www.iana.org/assignments/media-types/application/vnd.apache.thrift.binary) |
`application/vnd.apache.thrift.compact` | [application/vnd.apache.thrift.compact](https://www.iana.org/assignments/media-types/application/vnd.apache.thrift.compact) |
`application/vnd.apache.thrift.json` | [application/vnd.apache.thrift.json](https://www.iana.org/assignments/media-types/application/vnd.apache.thrift.json) |
`application/vnd.api+json` | [application/vnd.api+json](https://www.iana.org/assignments/media-types/application/vnd.api+json) |
`application/vnd.apple.mpegurl` | [application/vnd.apple.mpegurl](https://www.iana.org/assignments/media-types/application/vnd.apple.mpegurl) |
`application/vnd.apple.installer+xml` | [application/vnd.apple.installer+xml](https://www.iana.org/assignments/media-types/application/vnd.apple.installer+xml) |
`application/vnd.arastra.swi - OBSOLETED in favor of application/vnd.aristanetworks.swi` | [application/vnd.arastra.swi](https://www.iana.org/assignments/media-types/application/vnd.arastra.swi) |
`application/vnd.aristanetworks.swi` | [application/vnd.aristanetworks.swi](https://www.iana.org/assignments/media-types/application/vnd.aristanetworks.swi) |
`application/vnd.artsquare` | [application/vnd.artsquare](https://www.iana.org/assignments/media-types/application/vnd.artsquare) |
`application/vnd.astraea-software.iota` | [application/vnd.astraea-software.iota](https://www.iana.org/assignments/media-types/application/vnd.astraea-software.iota) |
`application/vnd.audiograph` | [application/vnd.audiograph](https://www.iana.org/assignments/media-types/application/vnd.audiograph) |
`application/vnd.autopackage` | [application/vnd.autopackage](https://www.iana.org/assignments/media-types/application/vnd.autopackage) |
`application/vnd.avistar+xml` | [application/vnd.avistar+xml](https://www.iana.org/assignments/media-types/application/vnd.avistar+xml) |
`application/vnd.balsamiq.bmml+xml` | [application/vnd.balsamiq.bmml+xml](https://www.iana.org/assignments/media-types/application/vnd.balsamiq.bmml+xml) |
`application/vnd.balsamiq.bmpr` | [application/vnd.balsamiq.bmpr](https://www.iana.org/assignments/media-types/application/vnd.balsamiq.bmpr) |
`application/vnd.bekitzur-stech+json` | [application/vnd.bekitzur-stech+json](https://www.iana.org/assignments/media-types/application/vnd.bekitzur-stech+json) |
`application/vnd.biopax.rdf+xml` | [application/vnd.biopax.rdf+xml](https://www.iana.org/assignments/media-types/application/vnd.biopax.rdf+xml) |
`application/vnd.blueice.multipass` | [application/vnd.blueice.multipass](https://www.iana.org/assignments/media-types/application/vnd.blueice.multipass) |
`application/vnd.bluetooth.ep.oob` | [application/vnd.bluetooth.ep.oob](https://www.iana.org/assignments/media-types/application/vnd.bluetooth.ep.oob) |
`application/vnd.bluetooth.le.oob` | [application/vnd.bluetooth.le.oob](https://www.iana.org/assignments/media-types/application/vnd.bluetooth.le.oob) |
`application/vnd.bmi` | [application/vnd.bmi](https://www.iana.org/assignments/media-types/application/vnd.bmi) |
`application/vnd.businessobjects` | [application/vnd.businessobjects](https://www.iana.org/assignments/media-types/application/vnd.businessobjects) |
`application/vnd.cab-jscript` | [application/vnd.cab-jscript](https://www.iana.org/assignments/media-types/application/vnd.cab-jscript) |
`application/vnd.canon-cpdl` | [application/vnd.canon-cpdl](https://www.iana.org/assignments/media-types/application/vnd.canon-cpdl) |
`application/vnd.canon-lips` | [application/vnd.canon-lips](https://www.iana.org/assignments/media-types/application/vnd.canon-lips) |
`application/vnd.cendio.thinlinc.clientconf` | [application/vnd.cendio.thinlinc.clientconf](https://www.iana.org/assignments/media-types/application/vnd.cendio.thinlinc.clientconf) |
`application/vnd.century-systems.tcp_stream` | [application/vnd.century-systems.tcp_stream](https://www.iana.org/assignments/media-types/application/vnd.century-systems.tcp_stream) |
`application/vnd.chemdraw+xml` | [application/vnd.chemdraw+xml](https://www.iana.org/assignments/media-types/application/vnd.chemdraw+xml) |
`application/vnd.chipnuts.karaoke-mmd` | [application/vnd.chipnuts.karaoke-mmd](https://www.iana.org/assignments/media-types/application/vnd.chipnuts.karaoke-mmd) |
`application/vnd.cinderella` | [application/vnd.cinderella](https://www.iana.org/assignments/media-types/application/vnd.cinderella) |
`application/vnd.cirpack.isdn-ext` | [application/vnd.cirpack.isdn-ext](https://www.iana.org/assignments/media-types/application/vnd.cirpack.isdn-ext) |
`application/vnd.citationstyles.style+xml` | [application/vnd.citationstyles.style+xml](https://www.iana.org/assignments/media-types/application/vnd.citationstyles.style+xml) |
`application/vnd.claymore` | [application/vnd.claymore](https://www.iana.org/assignments/media-types/application/vnd.claymore) |
`application/vnd.cloanto.rp9` | [application/vnd.cloanto.rp9](https://www.iana.org/assignments/media-types/application/vnd.cloanto.rp9) |
`application/vnd.clonk.c4group` | [application/vnd.clonk.c4group](https://www.iana.org/assignments/media-types/application/vnd.clonk.c4group) |
`application/vnd.cluetrust.cartomobile-config` | [application/vnd.cluetrust.cartomobile-config](https://www.iana.org/assignments/media-types/application/vnd.cluetrust.cartomobile-config) |
`application/vnd.cluetrust.cartomobile-config-pkg` | [application/vnd.cluetrust.cartomobile-config-pkg](https://www.iana.org/assignments/media-types/application/vnd.cluetrust.cartomobile-config-pkg) |
`application/vnd.coffeescript` | [application/vnd.coffeescript](https://www.iana.org/assignments/media-types/application/vnd.coffeescript) |
`application/vnd.collection.doc+json` | [application/vnd.collection.doc+json](https://www.iana.org/assignments/media-types/application/vnd.collection.doc+json) |
`application/vnd.collection+json` | [application/vnd.collection+json](https://www.iana.org/assignments/media-types/application/vnd.collection+json) |
`application/vnd.collection.next+json` | [application/vnd.collection.next+json](https://www.iana.org/assignments/media-types/application/vnd.collection.next+json) |
`application/vnd.commerce-battelle` | [application/vnd.commerce-battelle](https://www.iana.org/assignments/media-types/application/vnd.commerce-battelle) |
`application/vnd.commonspace` | [application/vnd.commonspace](https://www.iana.org/assignments/media-types/application/vnd.commonspace) |
`application/vnd.cosmocaller` | [application/vnd.cosmocaller](https://www.iana.org/assignments/media-types/application/vnd.cosmocaller) |
`application/vnd.contact.cmsg` | [application/vnd.contact.cmsg](https://www.iana.org/assignments/media-types/application/vnd.contact.cmsg) |
`application/vnd.crick.clicker` | [application/vnd.crick.clicker](https://www.iana.org/assignments/media-types/application/vnd.crick.clicker) |
`application/vnd.crick.clicker.keyboard` | [application/vnd.crick.clicker.keyboard](https://www.iana.org/assignments/media-types/application/vnd.crick.clicker.keyboard) |
`application/vnd.crick.clicker.palette` | [application/vnd.crick.clicker.palette](https://www.iana.org/assignments/media-types/application/vnd.crick.clicker.palette) |
`application/vnd.crick.clicker.template` | [application/vnd.crick.clicker.template](https://www.iana.org/assignments/media-types/application/vnd.crick.clicker.template) |
`application/vnd.crick.clicker.wordbank` | [application/vnd.crick.clicker.wordbank](https://www.iana.org/assignments/media-types/application/vnd.crick.clicker.wordbank) |
`application/vnd.criticaltools.wbs+xml` | [application/vnd.criticaltools.wbs+xml](https://www.iana.org/assignments/media-types/application/vnd.criticaltools.wbs+xml) |
`application/vnd.ctc-posml` | [application/vnd.ctc-posml](https://www.iana.org/assignments/media-types/application/vnd.ctc-posml) |
`application/vnd.ctct.ws+xml` | [application/vnd.ctct.ws+xml](https://www.iana.org/assignments/media-types/application/vnd.ctct.ws+xml) |
`application/vnd.cups-pdf` | [application/vnd.cups-pdf](https://www.iana.org/assignments/media-types/application/vnd.cups-pdf) |
`application/vnd.cups-postscript` | [application/vnd.cups-postscript](https://www.iana.org/assignments/media-types/application/vnd.cups-postscript) |
`application/vnd.cups-ppd` | [application/vnd.cups-ppd](https://www.iana.org/assignments/media-types/application/vnd.cups-ppd) |
`application/vnd.cups-raster` | [application/vnd.cups-raster](https://www.iana.org/assignments/media-types/application/vnd.cups-raster) |
`application/vnd.cups-raw` | [application/vnd.cups-raw](https://www.iana.org/assignments/media-types/application/vnd.cups-raw) |
`application/vnd.curl` | [application/vnd-curl](https://www.iana.org/assignments/media-types/application/vnd-curl) |
`application/vnd.cyan.dean.root+xml` | [application/vnd.cyan.dean.root+xml](https://www.iana.org/assignments/media-types/application/vnd.cyan.dean.root+xml) |
`application/vnd.cybank` | [application/vnd.cybank](https://www.iana.org/assignments/media-types/application/vnd.cybank) |
`application/vnd.dart` | [application/vnd-dart](https://www.iana.org/assignments/media-types/application/vnd-dart) |
`application/vnd.data-vision.rdz` | [application/vnd.data-vision.rdz](https://www.iana.org/assignments/media-types/application/vnd.data-vision.rdz) |
`application/vnd.debian.binary-package` | [application/vnd.debian.binary-package](https://www.iana.org/assignments/media-types/application/vnd.debian.binary-package) |
`application/vnd.dece.data` | [application/vnd.dece.data](https://www.iana.org/assignments/media-types/application/vnd.dece.data) |
`application/vnd.dece.ttml+xml` | [application/vnd.dece.ttml+xml](https://www.iana.org/assignments/media-types/application/vnd.dece.ttml+xml) |
`application/vnd.dece.unspecified` | [application/vnd.dece.unspecified](https://www.iana.org/assignments/media-types/application/vnd.dece.unspecified) |
`application/vnd.dece.zip` | [application/vnd.dece-zip](https://www.iana.org/assignments/media-types/application/vnd.dece-zip) |
`application/vnd.denovo.fcselayout-link` | [application/vnd.denovo.fcselayout-link](https://www.iana.org/assignments/media-types/application/vnd.denovo.fcselayout-link) |
`application/vnd.desmume.movie` | [application/vnd.desmume-movie](https://www.iana.org/assignments/media-types/application/vnd.desmume-movie) |
`application/vnd.dir-bi.plate-dl-nosuffix` | [application/vnd.dir-bi.plate-dl-nosuffix](https://www.iana.org/assignments/media-types/application/vnd.dir-bi.plate-dl-nosuffix) |
`application/vnd.dm.delegation+xml` | [application/vnd.dm.delegation+xml](https://www.iana.org/assignments/media-types/application/vnd.dm.delegation+xml) |
`application/vnd.dna` | [application/vnd.dna](https://www.iana.org/assignments/media-types/application/vnd.dna) |
`application/vnd.document+json` | [application/vnd.document+json](https://www.iana.org/assignments/media-types/application/vnd.document+json) |
`application/vnd.dolby.mobile.1` | [application/vnd.dolby.mobile.1](https://www.iana.org/assignments/media-types/application/vnd.dolby.mobile.1) |
`application/vnd.dolby.mobile.2` | [application/vnd.dolby.mobile.2](https://www.iana.org/assignments/media-types/application/vnd.dolby.mobile.2) |
`application/vnd.doremir.scorecloud-binary-document` | [application/vnd.doremir.scorecloud-binary-document](https://www.iana.org/assignments/media-types/application/vnd.doremir.scorecloud-binary-document) |
`application/vnd.dpgraph` | [application/vnd.dpgraph](https://www.iana.org/assignments/media-types/application/vnd.dpgraph) |
`application/vnd.dreamfactory` | [application/vnd.dreamfactory](https://www.iana.org/assignments/media-types/application/vnd.dreamfactory) |
`application/vnd.drive+json` | [application/vnd.drive+json](https://www.iana.org/assignments/media-types/application/vnd.drive+json) |
`application/vnd.dtg.local` | [application/vnd.dtg.local](https://www.iana.org/assignments/media-types/application/vnd.dtg.local) |
`application/vnd.dtg.local.flash` | [application/vnd.dtg.local.flash](https://www.iana.org/assignments/media-types/application/vnd.dtg.local.flash) |
`application/vnd.dtg.local.html` | [application/vnd.dtg.local-html](https://www.iana.org/assignments/media-types/application/vnd.dtg.local-html) |
`application/vnd.dvb.ait` | [application/vnd.dvb.ait](https://www.iana.org/assignments/media-types/application/vnd.dvb.ait) |
`application/vnd.dvb.dvbj` | [application/vnd.dvb.dvbj](https://www.iana.org/assignments/media-types/application/vnd.dvb.dvbj) |
`application/vnd.dvb.esgcontainer` | [application/vnd.dvb.esgcontainer](https://www.iana.org/assignments/media-types/application/vnd.dvb.esgcontainer) |
`application/vnd.dvb.ipdcdftnotifaccess` | [application/vnd.dvb.ipdcdftnotifaccess](https://www.iana.org/assignments/media-types/application/vnd.dvb.ipdcdftnotifaccess) |
`application/vnd.dvb.ipdcesgaccess` | [application/vnd.dvb.ipdcesgaccess](https://www.iana.org/assignments/media-types/application/vnd.dvb.ipdcesgaccess) |
`application/vnd.dvb.ipdcesgaccess2` | [application/vnd.dvb.ipdcesgaccess2](https://www.iana.org/assignments/media-types/application/vnd.dvb.ipdcesgaccess2) |
`application/vnd.dvb.ipdcesgpdd` | [application/vnd.dvb.ipdcesgpdd](https://www.iana.org/assignments/media-types/application/vnd.dvb.ipdcesgpdd) |
`application/vnd.dvb.ipdcroaming` | [application/vnd.dvb.ipdcroaming](https://www.iana.org/assignments/media-types/application/vnd.dvb.ipdcroaming) |
`application/vnd.dvb.iptv.alfec-base` | [application/vnd.dvb.iptv.alfec-base](https://www.iana.org/assignments/media-types/application/vnd.dvb.iptv.alfec-base) |
`application/vnd.dvb.iptv.alfec-enhancement` | [application/vnd.dvb.iptv.alfec-enhancement](https://www.iana.org/assignments/media-types/application/vnd.dvb.iptv.alfec-enhancement) |
`application/vnd.dvb.notif-aggregate-root+xml` | [application/vnd.dvb.notif-aggregate-root+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-aggregate-root+xml) |
`application/vnd.dvb.notif-container+xml` | [application/vnd.dvb.notif-container+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-container+xml) |
`application/vnd.dvb.notif-generic+xml` | [application/vnd.dvb.notif-generic+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-generic+xml) |
`application/vnd.dvb.notif-ia-msglist+xml` | [application/vnd.dvb.notif-ia-msglist+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-ia-msglist+xml) |
`application/vnd.dvb.notif-ia-registration-request+xml` | [application/vnd.dvb.notif-ia-registration-request+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-ia-registration-request+xml) |
`application/vnd.dvb.notif-ia-registration-response+xml` | [application/vnd.dvb.notif-ia-registration-response+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-ia-registration-response+xml) |
`application/vnd.dvb.notif-init+xml` | [application/vnd.dvb.notif-init+xml](https://www.iana.org/assignments/media-types/application/vnd.dvb.notif-init+xml) |
`application/vnd.dvb.pfr` | [application/vnd.dvb.pfr](https://www.iana.org/assignments/media-types/application/vnd.dvb.pfr) |
`application/vnd.dvb.service` | [application/vnd.dvb_service](https://www.iana.org/assignments/media-types/application/vnd.dvb_service) |
`application/vnd.dxr` | [application/vnd-dxr](https://www.iana.org/assignments/media-types/application/vnd-dxr) |
`application/vnd.dynageo` | [application/vnd.dynageo](https://www.iana.org/assignments/media-types/application/vnd.dynageo) |
`application/vnd.dzr` | [application/vnd.dzr](https://www.iana.org/assignments/media-types/application/vnd.dzr) |
`application/vnd.easykaraoke.cdgdownload` | [application/vnd.easykaraoke.cdgdownload](https://www.iana.org/assignments/media-types/application/vnd.easykaraoke.cdgdownload) |
`application/vnd.ecdis-update` | [application/vnd.ecdis-update](https://www.iana.org/assignments/media-types/application/vnd.ecdis-update) |
`application/vnd.ecowin.chart` | [application/vnd.ecowin.chart](https://www.iana.org/assignments/media-types/application/vnd.ecowin.chart) |
`application/vnd.ecowin.filerequest` | [application/vnd.ecowin.filerequest](https://www.iana.org/assignments/media-types/application/vnd.ecowin.filerequest) |
`application/vnd.ecowin.fileupdate` | [application/vnd.ecowin.fileupdate](https://www.iana.org/assignments/media-types/application/vnd.ecowin.fileupdate) |
`application/vnd.ecowin.series` | [application/vnd.ecowin.series](https://www.iana.org/assignments/media-types/application/vnd.ecowin.series) |
`application/vnd.ecowin.seriesrequest` | [application/vnd.ecowin.seriesrequest](https://www.iana.org/assignments/media-types/application/vnd.ecowin.seriesrequest) |
`application/vnd.ecowin.seriesupdate` | [application/vnd.ecowin.seriesupdate](https://www.iana.org/assignments/media-types/application/vnd.ecowin.seriesupdate) |
`application/vnd.emclient.accessrequest+xml` | [application/vnd.emclient.accessrequest+xml](https://www.iana.org/assignments/media-types/application/vnd.emclient.accessrequest+xml) |
`application/vnd.enliven` | [application/vnd.enliven](https://www.iana.org/assignments/media-types/application/vnd.enliven) |
`application/vnd.enphase.envoy` | [application/vnd.enphase.envoy](https://www.iana.org/assignments/media-types/application/vnd.enphase.envoy) |
`application/vnd.eprints.data+xml` | [application/vnd.eprints.data+xml](https://www.iana.org/assignments/media-types/application/vnd.eprints.data+xml) |
`application/vnd.epson.esf` | [application/vnd.epson.esf](https://www.iana.org/assignments/media-types/application/vnd.epson.esf) |
`application/vnd.epson.msf` | [application/vnd.epson.msf](https://www.iana.org/assignments/media-types/application/vnd.epson.msf) |
`application/vnd.epson.quickanime` | [application/vnd.epson.quickanime](https://www.iana.org/assignments/media-types/application/vnd.epson.quickanime) |
`application/vnd.epson.salt` | [application/vnd.epson.salt](https://www.iana.org/assignments/media-types/application/vnd.epson.salt) |
`application/vnd.epson.ssf` | [application/vnd.epson.ssf](https://www.iana.org/assignments/media-types/application/vnd.epson.ssf) |
`application/vnd.ericsson.quickcall` | [application/vnd.ericsson.quickcall](https://www.iana.org/assignments/media-types/application/vnd.ericsson.quickcall) |
`application/vnd.eszigno3+xml` | [application/vnd.eszigno3+xml](https://www.iana.org/assignments/media-types/application/vnd.eszigno3+xml) |
`application/vnd.etsi.aoc+xml` | [application/vnd.etsi.aoc+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.aoc+xml) |
`application/vnd.etsi.asic-s+zip` | [application/vnd.etsi.asic-s+zip](https://www.iana.org/assignments/media-types/application/vnd.etsi.asic-s+zip) |
`application/vnd.etsi.asic-e+zip` | [application/vnd.etsi.asic-e+zip](https://www.iana.org/assignments/media-types/application/vnd.etsi.asic-e+zip) |
`application/vnd.etsi.cug+xml` | [application/vnd.etsi.cug+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.cug+xml) |
`application/vnd.etsi.iptvcommand+xml` | [application/vnd.etsi.iptvcommand+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvcommand+xml) |
`application/vnd.etsi.iptvdiscovery+xml` | [application/vnd.etsi.iptvdiscovery+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvdiscovery+xml) |
`application/vnd.etsi.iptvprofile+xml` | [application/vnd.etsi.iptvprofile+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvprofile+xml) |
`application/vnd.etsi.iptvsad-bc+xml` | [application/vnd.etsi.iptvsad-bc+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvsad-bc+xml) |
`application/vnd.etsi.iptvsad-cod+xml` | [application/vnd.etsi.iptvsad-cod+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvsad-cod+xml) |
`application/vnd.etsi.iptvsad-npvr+xml` | [application/vnd.etsi.iptvsad-npvr+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvsad-npvr+xml) |
`application/vnd.etsi.iptvservice+xml` | [application/vnd.etsi.iptvservice+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvservice+xml) |
`application/vnd.etsi.iptvsync+xml` | [application/vnd.etsi.iptvsync+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvsync+xml) |
`application/vnd.etsi.iptvueprofile+xml` | [application/vnd.etsi.iptvueprofile+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.iptvueprofile+xml) |
`application/vnd.etsi.mcid+xml` | [application/vnd.etsi.mcid+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.mcid+xml) |
`application/vnd.etsi.mheg5` | [application/vnd.etsi.mheg5](https://www.iana.org/assignments/media-types/application/vnd.etsi.mheg5) |
`application/vnd.etsi.overload-control-policy-dataset+xml` | [application/vnd.etsi.overload-control-policy-dataset+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.overload-control-policy-dataset+xml) |
`application/vnd.etsi.pstn+xml` | [application/vnd.etsi.pstn+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.pstn+xml) |
`application/vnd.etsi.sci+xml` | [application/vnd.etsi.sci+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.sci+xml) |
`application/vnd.etsi.simservs+xml` | [application/vnd.etsi.simservs+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.simservs+xml) |
`application/vnd.etsi.timestamp-token` | [application/vnd.etsi.timestamp-token](https://www.iana.org/assignments/media-types/application/vnd.etsi.timestamp-token) |
`application/vnd.etsi.tsl+xml` | [application/vnd.etsi.tsl+xml](https://www.iana.org/assignments/media-types/application/vnd.etsi.tsl+xml) |
`application/vnd.etsi.tsl.der` | [application/vnd.etsi.tsl.der](https://www.iana.org/assignments/media-types/application/vnd.etsi.tsl.der) |
`application/vnd.eudora.data` | [application/vnd.eudora.data](https://www.iana.org/assignments/media-types/application/vnd.eudora.data) |
`application/vnd.ezpix-album` | [application/vnd.ezpix-album](https://www.iana.org/assignments/media-types/application/vnd.ezpix-album) |
`application/vnd.ezpix-package` | [application/vnd.ezpix-package](https://www.iana.org/assignments/media-types/application/vnd.ezpix-package) |
`application/vnd.f-secure.mobile` | [application/vnd.f-secure.mobile](https://www.iana.org/assignments/media-types/application/vnd.f-secure.mobile) |
`application/vnd.fastcopy-disk-image` | [application/vnd.fastcopy-disk-image](https://www.iana.org/assignments/media-types/application/vnd.fastcopy-disk-image) |
`application/vnd.fdf` | [application/vnd-fdf](https://www.iana.org/assignments/media-types/application/vnd-fdf) |
`application/vnd.fdsn.mseed` | [application/vnd.fdsn.mseed](https://www.iana.org/assignments/media-types/application/vnd.fdsn.mseed) |
`application/vnd.fdsn.seed` | [application/vnd.fdsn.seed](https://www.iana.org/assignments/media-types/application/vnd.fdsn.seed) |
`application/vnd.ffsns` | [application/vnd.ffsns](https://www.iana.org/assignments/media-types/application/vnd.ffsns) |
`application/vnd.filmit.zfc` | [application/vnd.filmit.zfc](https://www.iana.org/assignments/media-types/application/vnd.filmit.zfc) |
`application/vnd.fints` | [application/vnd.fints](https://www.iana.org/assignments/media-types/application/vnd.fints) |
`application/vnd.firemonkeys.cloudcell` | [application/vnd.firemonkeys.cloudcell](https://www.iana.org/assignments/media-types/application/vnd.firemonkeys.cloudcell) |
`application/vnd.FloGraphIt` | [application/vnd.FloGraphIt](https://www.iana.org/assignments/media-types/application/vnd.FloGraphIt) |
`application/vnd.fluxtime.clip` | [application/vnd.fluxtime.clip](https://www.iana.org/assignments/media-types/application/vnd.fluxtime.clip) |
`application/vnd.font-fontforge-sfd` | [application/vnd.font-fontforge-sfd](https://www.iana.org/assignments/media-types/application/vnd.font-fontforge-sfd) |
`application/vnd.framemaker` | [application/vnd.framemaker](https://www.iana.org/assignments/media-types/application/vnd.framemaker) |
`application/vnd.frogans.fnc` | [application/vnd.frogans.fnc](https://www.iana.org/assignments/media-types/application/vnd.frogans.fnc) |
`application/vnd.frogans.ltf` | [application/vnd.frogans.ltf](https://www.iana.org/assignments/media-types/application/vnd.frogans.ltf) |
`application/vnd.fsc.weblaunch` | [application/vnd.fsc.weblaunch](https://www.iana.org/assignments/media-types/application/vnd.fsc.weblaunch) |
`application/vnd.fujitsu.oasys` | [application/vnd.fujitsu.oasys](https://www.iana.org/assignments/media-types/application/vnd.fujitsu.oasys) |
`application/vnd.fujitsu.oasys2` | [application/vnd.fujitsu.oasys2](https://www.iana.org/assignments/media-types/application/vnd.fujitsu.oasys2) |
`application/vnd.fujitsu.oasys3` | [application/vnd.fujitsu.oasys3](https://www.iana.org/assignments/media-types/application/vnd.fujitsu.oasys3) |
`application/vnd.fujitsu.oasysgp` | [application/vnd.fujitsu.oasysgp](https://www.iana.org/assignments/media-types/application/vnd.fujitsu.oasysgp) |
`application/vnd.fujitsu.oasysprs` | [application/vnd.fujitsu.oasysprs](https://www.iana.org/assignments/media-types/application/vnd.fujitsu.oasysprs) |
`application/vnd.fujixerox.ART4` | [application/vnd.fujixerox.ART4](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.ART4) |
`application/vnd.fujixerox.ART-EX` | [application/vnd.fujixerox.ART-EX](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.ART-EX) |
`application/vnd.fujixerox.ddd` | [application/vnd.fujixerox.ddd](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.ddd) |
`application/vnd.fujixerox.docuworks` | [application/vnd.fujixerox.docuworks](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.docuworks) |
`application/vnd.fujixerox.docuworks.binder` | [application/vnd.fujixerox.docuworks.binder](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.docuworks.binder) |
`application/vnd.fujixerox.docuworks.container` | [application/vnd.fujixerox.docuworks.container](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.docuworks.container) |
`application/vnd.fujixerox.HBPL` | [application/vnd.fujixerox.HBPL](https://www.iana.org/assignments/media-types/application/vnd.fujixerox.HBPL) |
`application/vnd.fut-misnet` | [application/vnd.fut-misnet](https://www.iana.org/assignments/media-types/application/vnd.fut-misnet) |
`application/vnd.fuzzysheet` | [application/vnd.fuzzysheet](https://www.iana.org/assignments/media-types/application/vnd.fuzzysheet) |
`application/vnd.genomatix.tuxedo` | [application/vnd.genomatix.tuxedo](https://www.iana.org/assignments/media-types/application/vnd.genomatix.tuxedo) |
`application/vnd.geo+json` | [application/vnd.geo+json](https://www.iana.org/assignments/media-types/application/vnd.geo+json) |
`application/vnd.geocube+xml - OBSOLETED by request` | [application/vnd.geocube+xml](https://www.iana.org/assignments/media-types/application/vnd.geocube+xml) |
`application/vnd.geogebra.file` | [application/vnd.geogebra.file](https://www.iana.org/assignments/media-types/application/vnd.geogebra.file) |
`application/vnd.geogebra.tool` | [application/vnd.geogebra.tool](https://www.iana.org/assignments/media-types/application/vnd.geogebra.tool) |
`application/vnd.geometry-explorer` | [application/vnd.geometry-explorer](https://www.iana.org/assignments/media-types/application/vnd.geometry-explorer) |
`application/vnd.geonext` | [application/vnd.geonext](https://www.iana.org/assignments/media-types/application/vnd.geonext) |
`application/vnd.geoplan` | [application/vnd.geoplan](https://www.iana.org/assignments/media-types/application/vnd.geoplan) |
`application/vnd.geospace` | [application/vnd.geospace](https://www.iana.org/assignments/media-types/application/vnd.geospace) |
`application/vnd.gerber` | [application/vnd.gerber](https://www.iana.org/assignments/media-types/application/vnd.gerber) |
`application/vnd.globalplatform.card-content-mgt` | [application/vnd.globalplatform.card-content-mgt](https://www.iana.org/assignments/media-types/application/vnd.globalplatform.card-content-mgt) |
`application/vnd.globalplatform.card-content-mgt-response` | [application/vnd.globalplatform.card-content-mgt-response](https://www.iana.org/assignments/media-types/application/vnd.globalplatform.card-content-mgt-response) |
`application/vnd.gmx - DEPRECATED` | [application/vnd.gmx](https://www.iana.org/assignments/media-types/application/vnd.gmx) |
`application/vnd.google-earth.kml+xml` | [application/vnd.google-earth.kml+xml](https://www.iana.org/assignments/media-types/application/vnd.google-earth.kml+xml) |
`application/vnd.google-earth.kmz` | [application/vnd.google-earth.kmz](https://www.iana.org/assignments/media-types/application/vnd.google-earth.kmz) |
`application/vnd.gov.sk.e-form+xml` | [application/vnd.gov.sk.e-form+xml](https://www.iana.org/assignments/media-types/application/vnd.gov.sk.e-form+xml) |
`application/vnd.gov.sk.e-form+zip` | [application/vnd.gov.sk.e-form+zip](https://www.iana.org/assignments/media-types/application/vnd.gov.sk.e-form+zip) |
`application/vnd.gov.sk.xmldatacontainer+xml` | [application/vnd.gov.sk.xmldatacontainer+xml](https://www.iana.org/assignments/media-types/application/vnd.gov.sk.xmldatacontainer+xml) |
`application/vnd.grafeq` | [application/vnd.grafeq](https://www.iana.org/assignments/media-types/application/vnd.grafeq) |
`application/vnd.gridmp` | [application/vnd.gridmp](https://www.iana.org/assignments/media-types/application/vnd.gridmp) |
`application/vnd.groove-account` | [application/vnd.groove-account](https://www.iana.org/assignments/media-types/application/vnd.groove-account) |
`application/vnd.groove-help` | [application/vnd.groove-help](https://www.iana.org/assignments/media-types/application/vnd.groove-help) |
`application/vnd.groove-identity-message` | [application/vnd.groove-identity-message](https://www.iana.org/assignments/media-types/application/vnd.groove-identity-message) |
`application/vnd.groove-injector` | [application/vnd.groove-injector](https://www.iana.org/assignments/media-types/application/vnd.groove-injector) |
`application/vnd.groove-tool-message` | [application/vnd.groove-tool-message](https://www.iana.org/assignments/media-types/application/vnd.groove-tool-message) |
`application/vnd.groove-tool-template` | [application/vnd.groove-tool-template](https://www.iana.org/assignments/media-types/application/vnd.groove-tool-template) |
`application/vnd.groove-vcard` | [application/vnd.groove-vcard](https://www.iana.org/assignments/media-types/application/vnd.groove-vcard) |
`application/vnd.hal+json` | [application/vnd.hal+json](https://www.iana.org/assignments/media-types/application/vnd.hal+json) |
`application/vnd.hal+xml` | [application/vnd.hal+xml](https://www.iana.org/assignments/media-types/application/vnd.hal+xml) |
`application/vnd.HandHeld-Entertainment+xml` | [application/vnd.HandHeld-Entertainment+xml](https://www.iana.org/assignments/media-types/application/vnd.HandHeld-Entertainment+xml) |
`application/vnd.hbci` | [application/vnd.hbci](https://www.iana.org/assignments/media-types/application/vnd.hbci) |
`application/vnd.hcl-bireports` | [application/vnd.hcl-bireports](https://www.iana.org/assignments/media-types/application/vnd.hcl-bireports) |
`application/vnd.hdt` | [application/vnd.hdt](https://www.iana.org/assignments/media-types/application/vnd.hdt) |
`application/vnd.heroku+json` | [application/vnd.heroku+json](https://www.iana.org/assignments/media-types/application/vnd.heroku+json) |
`application/vnd.hhe.lesson-player` | [application/vnd.hhe.lesson-player](https://www.iana.org/assignments/media-types/application/vnd.hhe.lesson-player) |
`application/vnd.hp-HPGL` | [application/vnd.hp-HPGL](https://www.iana.org/assignments/media-types/application/vnd.hp-HPGL) |
`application/vnd.hp-hpid` | [application/vnd.hp-hpid](https://www.iana.org/assignments/media-types/application/vnd.hp-hpid) |
`application/vnd.hp-hps` | [application/vnd.hp-hps](https://www.iana.org/assignments/media-types/application/vnd.hp-hps) |
`application/vnd.hp-jlyt` | [application/vnd.hp-jlyt](https://www.iana.org/assignments/media-types/application/vnd.hp-jlyt) |
`application/vnd.hp-PCL` | [application/vnd.hp-PCL](https://www.iana.org/assignments/media-types/application/vnd.hp-PCL) |
`application/vnd.hp-PCLXL` | [application/vnd.hp-PCLXL](https://www.iana.org/assignments/media-types/application/vnd.hp-PCLXL) |
`application/vnd.httphone` | [application/vnd.httphone](https://www.iana.org/assignments/media-types/application/vnd.httphone) |
`application/vnd.hydrostatix.sof-data` | [application/vnd.hydrostatix.sof-data](https://www.iana.org/assignments/media-types/application/vnd.hydrostatix.sof-data) |
`application/vnd.hyperdrive+json` | [application/vnd.hyperdrive+json](https://www.iana.org/assignments/media-types/application/vnd.hyperdrive+json) |
`application/vnd.hzn-3d-crossword` | [application/vnd.hzn-3d-crossword](https://www.iana.org/assignments/media-types/application/vnd.hzn-3d-crossword) |
`application/vnd.ibm.afplinedata` | [application/vnd.ibm.afplinedata](https://www.iana.org/assignments/media-types/application/vnd.ibm.afplinedata) |
`application/vnd.ibm.electronic-media` | [application/vnd.ibm.electronic-media](https://www.iana.org/assignments/media-types/application/vnd.ibm.electronic-media) |
`application/vnd.ibm.MiniPay` | [application/vnd.ibm.MiniPay](https://www.iana.org/assignments/media-types/application/vnd.ibm.MiniPay) |
`application/vnd.ibm.modcap` | [application/vnd.ibm.modcap](https://www.iana.org/assignments/media-types/application/vnd.ibm.modcap) |
`application/vnd.ibm.rights-management` | [application/vnd.ibm.rights-management](https://www.iana.org/assignments/media-types/application/vnd.ibm.rights-management) |
`application/vnd.ibm.secure-container` | [application/vnd.ibm.secure-container](https://www.iana.org/assignments/media-types/application/vnd.ibm.secure-container) |
`application/vnd.iccprofile` | [application/vnd.iccprofile](https://www.iana.org/assignments/media-types/application/vnd.iccprofile) |
`application/vnd.ieee.1905` | [application/vnd.ieee.1905](https://www.iana.org/assignments/media-types/application/vnd.ieee.1905) |
`application/vnd.igloader` | [application/vnd.igloader](https://www.iana.org/assignments/media-types/application/vnd.igloader) |
`application/vnd.immervision-ivp` | [application/vnd.immervision-ivp](https://www.iana.org/assignments/media-types/application/vnd.immervision-ivp) |
`application/vnd.immervision-ivu` | [application/vnd.immervision-ivu](https://www.iana.org/assignments/media-types/application/vnd.immervision-ivu) |
`application/vnd.ims.imsccv1p1` | [application/vnd.ims.imsccv1p1](https://www.iana.org/assignments/media-types/application/vnd.ims.imsccv1p1) |
`application/vnd.ims.imsccv1p2` | [application/vnd.ims.imsccv1p2](https://www.iana.org/assignments/media-types/application/vnd.ims.imsccv1p2) |
`application/vnd.ims.imsccv1p3` | [application/vnd.ims.imsccv1p3](https://www.iana.org/assignments/media-types/application/vnd.ims.imsccv1p3) |
`application/vnd.ims.lis.v2.result+json` | [application/vnd.ims.lis.v2.result+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lis.v2.result+json) |
`application/vnd.ims.lti.v2.toolconsumerprofile+json` | [application/vnd.ims.lti.v2.toolconsumerprofile+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lti.v2.toolconsumerprofile+json) |
`application/vnd.ims.lti.v2.toolproxy.id+json` | [application/vnd.ims.lti.v2.toolproxy.id+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lti.v2.toolproxy.id+json) |
`application/vnd.ims.lti.v2.toolproxy+json` | [application/vnd.ims.lti.v2.toolproxy+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lti.v2.toolproxy+json) |
`application/vnd.ims.lti.v2.toolsettings+json` | [application/vnd.ims.lti.v2.toolsettings+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lti.v2.toolsettings+json) |
`application/vnd.ims.lti.v2.toolsettings.simple+json` | [application/vnd.ims.lti.v2.toolsettings.simple+json](https://www.iana.org/assignments/media-types/application/vnd.ims.lti.v2.toolsettings.simple+json) |
`application/vnd.informedcontrol.rms+xml` | [application/vnd.informedcontrol.rms+xml](https://www.iana.org/assignments/media-types/application/vnd.informedcontrol.rms+xml) |
`application/vnd.infotech.project` | [application/vnd.infotech.project](https://www.iana.org/assignments/media-types/application/vnd.infotech.project) |
`application/vnd.infotech.project+xml` | [application/vnd.infotech.project+xml](https://www.iana.org/assignments/media-types/application/vnd.infotech.project+xml) |
`application/vnd.informix-visionary - OBSOLETED in favor of application/vnd.visionary` | [application/vnd.informix-visionary](https://www.iana.org/assignments/media-types/application/vnd.informix-visionary) |
`application/vnd.innopath.wamp.notification` | [application/vnd.innopath.wamp.notification](https://www.iana.org/assignments/media-types/application/vnd.innopath.wamp.notification) |
`application/vnd.insors.igm` | [application/vnd.insors.igm](https://www.iana.org/assignments/media-types/application/vnd.insors.igm) |
`application/vnd.intercon.formnet` | [application/vnd.intercon.formnet](https://www.iana.org/assignments/media-types/application/vnd.intercon.formnet) |
`application/vnd.intergeo` | [application/vnd.intergeo](https://www.iana.org/assignments/media-types/application/vnd.intergeo) |
`application/vnd.intertrust.digibox` | [application/vnd.intertrust.digibox](https://www.iana.org/assignments/media-types/application/vnd.intertrust.digibox) |
`application/vnd.intertrust.nncp` | [application/vnd.intertrust.nncp](https://www.iana.org/assignments/media-types/application/vnd.intertrust.nncp) |
`application/vnd.intu.qbo` | [application/vnd.intu.qbo](https://www.iana.org/assignments/media-types/application/vnd.intu.qbo) |
`application/vnd.intu.qfx` | [application/vnd.intu.qfx](https://www.iana.org/assignments/media-types/application/vnd.intu.qfx) |
`application/vnd.iptc.g2.catalogitem+xml` | [application/vnd.iptc.g2.catalogitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.catalogitem+xml) |
`application/vnd.iptc.g2.conceptitem+xml` | [application/vnd.iptc.g2.conceptitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.conceptitem+xml) |
`application/vnd.iptc.g2.knowledgeitem+xml` | [application/vnd.iptc.g2.knowledgeitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.knowledgeitem+xml) |
`application/vnd.iptc.g2.newsitem+xml` | [application/vnd.iptc.g2.newsitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.newsitem+xml) |
`application/vnd.iptc.g2.newsmessage+xml` | [application/vnd.iptc.g2.newsmessage+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.newsmessage+xml) |
`application/vnd.iptc.g2.packageitem+xml` | [application/vnd.iptc.g2.packageitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.packageitem+xml) |
`application/vnd.iptc.g2.planningitem+xml` | [application/vnd.iptc.g2.planningitem+xml](https://www.iana.org/assignments/media-types/application/vnd.iptc.g2.planningitem+xml) |
`application/vnd.ipunplugged.rcprofile` | [application/vnd.ipunplugged.rcprofile](https://www.iana.org/assignments/media-types/application/vnd.ipunplugged.rcprofile) |
`application/vnd.irepository.package+xml` | [application/vnd.irepository.package+xml](https://www.iana.org/assignments/media-types/application/vnd.irepository.package+xml) |
`application/vnd.is-xpr` | [application/vnd.is-xpr](https://www.iana.org/assignments/media-types/application/vnd.is-xpr) |
`application/vnd.isac.fcs` | [application/vnd.isac.fcs](https://www.iana.org/assignments/media-types/application/vnd.isac.fcs) |
`application/vnd.jam` | [application/vnd.jam](https://www.iana.org/assignments/media-types/application/vnd.jam) |
`application/vnd.japannet-directory-service` | [application/vnd.japannet-directory-service](https://www.iana.org/assignments/media-types/application/vnd.japannet-directory-service) |
`application/vnd.japannet-jpnstore-wakeup` | [application/vnd.japannet-jpnstore-wakeup](https://www.iana.org/assignments/media-types/application/vnd.japannet-jpnstore-wakeup) |
`application/vnd.japannet-payment-wakeup` | [application/vnd.japannet-payment-wakeup](https://www.iana.org/assignments/media-types/application/vnd.japannet-payment-wakeup) |
`application/vnd.japannet-registration` | [application/vnd.japannet-registration](https://www.iana.org/assignments/media-types/application/vnd.japannet-registration) |
`application/vnd.japannet-registration-wakeup` | [application/vnd.japannet-registration-wakeup](https://www.iana.org/assignments/media-types/application/vnd.japannet-registration-wakeup) |
`application/vnd.japannet-setstore-wakeup` | [application/vnd.japannet-setstore-wakeup](https://www.iana.org/assignments/media-types/application/vnd.japannet-setstore-wakeup) |
`application/vnd.japannet-verification` | [application/vnd.japannet-verification](https://www.iana.org/assignments/media-types/application/vnd.japannet-verification) |
`application/vnd.japannet-verification-wakeup` | [application/vnd.japannet-verification-wakeup](https://www.iana.org/assignments/media-types/application/vnd.japannet-verification-wakeup) |
`application/vnd.jcp.javame.midlet-rms` | [application/vnd.jcp.javame.midlet-rms](https://www.iana.org/assignments/media-types/application/vnd.jcp.javame.midlet-rms) |
`application/vnd.jisp` | [application/vnd.jisp](https://www.iana.org/assignments/media-types/application/vnd.jisp) |
`application/vnd.joost.joda-archive` | [application/vnd.joost.joda-archive](https://www.iana.org/assignments/media-types/application/vnd.joost.joda-archive) |
`application/vnd.jsk.isdn-ngn` | [application/vnd.jsk.isdn-ngn](https://www.iana.org/assignments/media-types/application/vnd.jsk.isdn-ngn) |
`application/vnd.kahootz` | [application/vnd.kahootz](https://www.iana.org/assignments/media-types/application/vnd.kahootz) |
`application/vnd.kde.karbon` | [application/vnd.kde.karbon](https://www.iana.org/assignments/media-types/application/vnd.kde.karbon) |
`application/vnd.kde.kchart` | [application/vnd.kde.kchart](https://www.iana.org/assignments/media-types/application/vnd.kde.kchart) |
`application/vnd.kde.kformula` | [application/vnd.kde.kformula](https://www.iana.org/assignments/media-types/application/vnd.kde.kformula) |
`application/vnd.kde.kivio` | [application/vnd.kde.kivio](https://www.iana.org/assignments/media-types/application/vnd.kde.kivio) |
`application/vnd.kde.kontour` | [application/vnd.kde.kontour](https://www.iana.org/assignments/media-types/application/vnd.kde.kontour) |
`application/vnd.kde.kpresenter` | [application/vnd.kde.kpresenter](https://www.iana.org/assignments/media-types/application/vnd.kde.kpresenter) |
`application/vnd.kde.kspread` | [application/vnd.kde.kspread](https://www.iana.org/assignments/media-types/application/vnd.kde.kspread) |
`application/vnd.kde.kword` | [application/vnd.kde.kword](https://www.iana.org/assignments/media-types/application/vnd.kde.kword) |
`application/vnd.kenameaapp` | [application/vnd.kenameaapp](https://www.iana.org/assignments/media-types/application/vnd.kenameaapp) |
`application/vnd.kidspiration` | [application/vnd.kidspiration](https://www.iana.org/assignments/media-types/application/vnd.kidspiration) |
`application/vnd.Kinar` | [application/vnd.Kinar](https://www.iana.org/assignments/media-types/application/vnd.Kinar) |
`application/vnd.koan` | [application/vnd.koan](https://www.iana.org/assignments/media-types/application/vnd.koan) |
`application/vnd.kodak-descriptor` | [application/vnd.kodak-descriptor](https://www.iana.org/assignments/media-types/application/vnd.kodak-descriptor) |
`application/vnd.las.las+xml` | [application/vnd.las.las+xml](https://www.iana.org/assignments/media-types/application/vnd.las.las+xml) |
`application/vnd.liberty-request+xml` | [application/vnd.liberty-request+xml](https://www.iana.org/assignments/media-types/application/vnd.liberty-request+xml) |
`application/vnd.llamagraphics.life-balance.desktop` | [application/vnd.llamagraphics.life-balance.desktop](https://www.iana.org/assignments/media-types/application/vnd.llamagraphics.life-balance.desktop) |
`application/vnd.llamagraphics.life-balance.exchange+xml` | [application/vnd.llamagraphics.life-balance.exchange+xml](https://www.iana.org/assignments/media-types/application/vnd.llamagraphics.life-balance.exchange+xml) |
`application/vnd.lotus-1-2-3` | [application/vnd.lotus-1-2-3](https://www.iana.org/assignments/media-types/application/vnd.lotus-1-2-3) |
`application/vnd.lotus-approach` | [application/vnd.lotus-approach](https://www.iana.org/assignments/media-types/application/vnd.lotus-approach) |
`application/vnd.lotus-freelance` | [application/vnd.lotus-freelance](https://www.iana.org/assignments/media-types/application/vnd.lotus-freelance) |
`application/vnd.lotus-notes` | [application/vnd.lotus-notes](https://www.iana.org/assignments/media-types/application/vnd.lotus-notes) |
`application/vnd.lotus-organizer` | [application/vnd.lotus-organizer](https://www.iana.org/assignments/media-types/application/vnd.lotus-organizer) |
`application/vnd.lotus-screencam` | [application/vnd.lotus-screencam](https://www.iana.org/assignments/media-types/application/vnd.lotus-screencam) |
`application/vnd.lotus-wordpro` | [application/vnd.lotus-wordpro](https://www.iana.org/assignments/media-types/application/vnd.lotus-wordpro) |
`application/vnd.macports.portpkg` | [application/vnd.macports.portpkg](https://www.iana.org/assignments/media-types/application/vnd.macports.portpkg) |
`application/vnd.macports.portpkg` | [application/vnd.macports.portpkg](https://www.iana.org/assignments/media-types/application/vnd.macports.portpkg) |
`application/vnd.mapbox-vector-tile` | [application/vnd.mapbox-vector-tile](https://www.iana.org/assignments/media-types/application/vnd.mapbox-vector-tile) |
`application/vnd.marlin.drm.actiontoken+xml` | [application/vnd.marlin.drm.actiontoken+xml](https://www.iana.org/assignments/media-types/application/vnd.marlin.drm.actiontoken+xml) |
`application/vnd.marlin.drm.conftoken+xml` | [application/vnd.marlin.drm.conftoken+xml](https://www.iana.org/assignments/media-types/application/vnd.marlin.drm.conftoken+xml) |
`application/vnd.marlin.drm.license+xml` | [application/vnd.marlin.drm.license+xml](https://www.iana.org/assignments/media-types/application/vnd.marlin.drm.license+xml) |
`application/vnd.marlin.drm.mdcf` | [application/vnd.marlin.drm.mdcf](https://www.iana.org/assignments/media-types/application/vnd.marlin.drm.mdcf) |
`application/vnd.mason+json` | [application/vnd.mason+json](https://www.iana.org/assignments/media-types/application/vnd.mason+json) |
`application/vnd.maxmind.maxmind-db` | [application/vnd.maxmind.maxmind-db](https://www.iana.org/assignments/media-types/application/vnd.maxmind.maxmind-db) |
`application/vnd.mcd` | [application/vnd.mcd](https://www.iana.org/assignments/media-types/application/vnd.mcd) |
`application/vnd.medcalcdata` | [application/vnd.medcalcdata](https://www.iana.org/assignments/media-types/application/vnd.medcalcdata) |
`application/vnd.mediastation.cdkey` | [application/vnd.mediastation.cdkey](https://www.iana.org/assignments/media-types/application/vnd.mediastation.cdkey) |
`application/vnd.meridian-slingshot` | [application/vnd.meridian-slingshot](https://www.iana.org/assignments/media-types/application/vnd.meridian-slingshot) |
`application/vnd.MFER` | [application/vnd.MFER](https://www.iana.org/assignments/media-types/application/vnd.MFER) |
`application/vnd.mfmp` | [application/vnd.mfmp](https://www.iana.org/assignments/media-types/application/vnd.mfmp) |
`application/vnd.micro+json` | [application/vnd.micro+json](https://www.iana.org/assignments/media-types/application/vnd.micro+json) |
`application/vnd.micrografx.flo` | [application/vnd.micrografx.flo](https://www.iana.org/assignments/media-types/application/vnd.micrografx.flo) |
`application/vnd.micrografx.igx` | [application/vnd.micrografx-igx](https://www.iana.org/assignments/media-types/application/vnd.micrografx-igx) |
`application/vnd.microsoft.portable-executable` | [application/vnd.microsoft.portable-executable](https://www.iana.org/assignments/media-types/application/vnd.microsoft.portable-executable) |
`application/vnd.miele+json` | [application/vnd.miele+json](https://www.iana.org/assignments/media-types/application/vnd.miele+json) |
`application/vnd.mif` | [application/vnd-mif](https://www.iana.org/assignments/media-types/application/vnd-mif) |
`application/vnd.minisoft-hp3000-save` | [application/vnd.minisoft-hp3000-save](https://www.iana.org/assignments/media-types/application/vnd.minisoft-hp3000-save) |
`application/vnd.mitsubishi.misty-guard.trustweb` | [application/vnd.mitsubishi.misty-guard.trustweb](https://www.iana.org/assignments/media-types/application/vnd.mitsubishi.misty-guard.trustweb) |
`application/vnd.Mobius.DAF` | [application/vnd.Mobius.DAF](https://www.iana.org/assignments/media-types/application/vnd.Mobius.DAF) |
`application/vnd.Mobius.DIS` | [application/vnd.Mobius.DIS](https://www.iana.org/assignments/media-types/application/vnd.Mobius.DIS) |
`application/vnd.Mobius.MBK` | [application/vnd.Mobius.MBK](https://www.iana.org/assignments/media-types/application/vnd.Mobius.MBK) |
`application/vnd.Mobius.MQY` | [application/vnd.Mobius.MQY](https://www.iana.org/assignments/media-types/application/vnd.Mobius.MQY) |
`application/vnd.Mobius.MSL` | [application/vnd.Mobius.MSL](https://www.iana.org/assignments/media-types/application/vnd.Mobius.MSL) |
`application/vnd.Mobius.PLC` | [application/vnd.Mobius.PLC](https://www.iana.org/assignments/media-types/application/vnd.Mobius.PLC) |
`application/vnd.Mobius.TXF` | [application/vnd.Mobius.TXF](https://www.iana.org/assignments/media-types/application/vnd.Mobius.TXF) |
`application/vnd.mophun.application` | [application/vnd.mophun.application](https://www.iana.org/assignments/media-types/application/vnd.mophun.application) |
`application/vnd.mophun.certificate` | [application/vnd.mophun.certificate](https://www.iana.org/assignments/media-types/application/vnd.mophun.certificate) |
`application/vnd.motorola.flexsuite` | [application/vnd.motorola.flexsuite](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite) |
`application/vnd.motorola.flexsuite.adsi` | [application/vnd.motorola.flexsuite.adsi](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.adsi) |
`application/vnd.motorola.flexsuite.fis` | [application/vnd.motorola.flexsuite.fis](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.fis) |
`application/vnd.motorola.flexsuite.gotap` | [application/vnd.motorola.flexsuite.gotap](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.gotap) |
`application/vnd.motorola.flexsuite.kmr` | [application/vnd.motorola.flexsuite.kmr](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.kmr) |
`application/vnd.motorola.flexsuite.ttc` | [application/vnd.motorola.flexsuite.ttc](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.ttc) |
`application/vnd.motorola.flexsuite.wem` | [application/vnd.motorola.flexsuite.wem](https://www.iana.org/assignments/media-types/application/vnd.motorola.flexsuite.wem) |
`application/vnd.motorola.iprm` | [application/vnd.motorola.iprm](https://www.iana.org/assignments/media-types/application/vnd.motorola.iprm) |
`application/vnd.mozilla.xul+xml` | [application/vnd.mozilla.xul+xml](https://www.iana.org/assignments/media-types/application/vnd.mozilla.xul+xml) |
`application/vnd.ms-artgalry` | [application/vnd.ms-artgalry](https://www.iana.org/assignments/media-types/application/vnd.ms-artgalry) |
`application/vnd.ms-asf` | [application/vnd.ms-asf](https://www.iana.org/assignments/media-types/application/vnd.ms-asf) |
`application/vnd.ms-cab-compressed` | [application/vnd.ms-cab-compressed](https://www.iana.org/assignments/media-types/application/vnd.ms-cab-compressed) |
`application/vnd.ms-3mfdocument` | [application/vnd.ms-3mfdocument](https://www.iana.org/assignments/media-types/application/vnd.ms-3mfdocument) |
`application/vnd.ms-excel` | [application/vnd.ms-excel](https://www.iana.org/assignments/media-types/application/vnd.ms-excel) |
`application/vnd.ms-excel.addin.macroEnabled.12` | [application/vnd.ms-excel.addin.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-excel.addin.macroEnabled.12) |
`application/vnd.ms-excel.sheet.binary.macroEnabled.12` | [application/vnd.ms-excel.sheet.binary.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-excel.sheet.binary.macroEnabled.12) |
`application/vnd.ms-excel.sheet.macroEnabled.12` | [application/vnd.ms-excel.sheet.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-excel.sheet.macroEnabled.12) |
`application/vnd.ms-excel.template.macroEnabled.12` | [application/vnd.ms-excel.template.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-excel.template.macroEnabled.12) |
`application/vnd.ms-fontobject` | [application/vnd.ms-fontobject](https://www.iana.org/assignments/media-types/application/vnd.ms-fontobject) |
`application/vnd.ms-htmlhelp` | [application/vnd.ms-htmlhelp](https://www.iana.org/assignments/media-types/application/vnd.ms-htmlhelp) |
`application/vnd.ms-ims` | [application/vnd.ms-ims](https://www.iana.org/assignments/media-types/application/vnd.ms-ims) |
`application/vnd.ms-lrm` | [application/vnd.ms-lrm](https://www.iana.org/assignments/media-types/application/vnd.ms-lrm) |
`application/vnd.ms-office.activeX+xml` | [application/vnd.ms-office.activeX+xml](https://www.iana.org/assignments/media-types/application/vnd.ms-office.activeX+xml) |
`application/vnd.ms-officetheme` | [application/vnd.ms-officetheme](https://www.iana.org/assignments/media-types/application/vnd.ms-officetheme) |
`application/vnd.ms-playready.initiator+xml` | [application/vnd.ms-playready.initiator+xml](https://www.iana.org/assignments/media-types/application/vnd.ms-playready.initiator+xml) |
`application/vnd.ms-powerpoint` | [application/vnd.ms-powerpoint](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint) |
`application/vnd.ms-powerpoint.addin.macroEnabled.12` | [application/vnd.ms-powerpoint.addin.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint.addin.macroEnabled.12) |
`application/vnd.ms-powerpoint.presentation.macroEnabled.12` | [application/vnd.ms-powerpoint.presentation.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint.presentation.macroEnabled.12) |
`application/vnd.ms-powerpoint.slide.macroEnabled.12` | [application/vnd.ms-powerpoint.slide.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint.slide.macroEnabled.12) |
`application/vnd.ms-powerpoint.slideshow.macroEnabled.12` | [application/vnd.ms-powerpoint.slideshow.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint.slideshow.macroEnabled.12) |
`application/vnd.ms-powerpoint.template.macroEnabled.12` | [application/vnd.ms-powerpoint.template.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-powerpoint.template.macroEnabled.12) |
`application/vnd.ms-PrintDeviceCapabilities+xml` | [application/vnd.ms-PrintDeviceCapabilities+xml](https://www.iana.org/assignments/media-types/application/vnd.ms-PrintDeviceCapabilities+xml) |
`application/vnd.ms-PrintSchemaTicket+xml` | [application/vnd.ms-PrintSchemaTicket+xml](https://www.iana.org/assignments/media-types/application/vnd.ms-PrintSchemaTicket+xml) |
`application/vnd.ms-project` | [application/vnd.ms-project](https://www.iana.org/assignments/media-types/application/vnd.ms-project) |
`application/vnd.ms-tnef` | [application/vnd.ms-tnef](https://www.iana.org/assignments/media-types/application/vnd.ms-tnef) |
`application/vnd.ms-windows.devicepairing` | [application/vnd.ms-windows.devicepairing](https://www.iana.org/assignments/media-types/application/vnd.ms-windows.devicepairing) |
`application/vnd.ms-windows.nwprinting.oob` | [application/vnd.ms-windows.nwprinting.oob](https://www.iana.org/assignments/media-types/application/vnd.ms-windows.nwprinting.oob) |
`application/vnd.ms-windows.printerpairing` | [application/vnd.ms-windows.printerpairing](https://www.iana.org/assignments/media-types/application/vnd.ms-windows.printerpairing) |
`application/vnd.ms-windows.wsd.oob` | [application/vnd.ms-windows.wsd.oob](https://www.iana.org/assignments/media-types/application/vnd.ms-windows.wsd.oob) |
`application/vnd.ms-wmdrm.lic-chlg-req` | [application/vnd.ms-wmdrm.lic-chlg-req](https://www.iana.org/assignments/media-types/application/vnd.ms-wmdrm.lic-chlg-req) |
`application/vnd.ms-wmdrm.lic-resp` | [application/vnd.ms-wmdrm.lic-resp](https://www.iana.org/assignments/media-types/application/vnd.ms-wmdrm.lic-resp) |
`application/vnd.ms-wmdrm.meter-chlg-req` | [application/vnd.ms-wmdrm.meter-chlg-req](https://www.iana.org/assignments/media-types/application/vnd.ms-wmdrm.meter-chlg-req) |
`application/vnd.ms-wmdrm.meter-resp` | [application/vnd.ms-wmdrm.meter-resp](https://www.iana.org/assignments/media-types/application/vnd.ms-wmdrm.meter-resp) |
`application/vnd.ms-word.document.macroEnabled.12` | [application/vnd.ms-word.document.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-word.document.macroEnabled.12) |
`application/vnd.ms-word.template.macroEnabled.12` | [application/vnd.ms-word.template.macroEnabled.12](https://www.iana.org/assignments/media-types/application/vnd.ms-word.template.macroEnabled.12) |
`application/vnd.ms-works` | [application/vnd.ms-works](https://www.iana.org/assignments/media-types/application/vnd.ms-works) |
`application/vnd.ms-wpl` | [application/vnd.ms-wpl](https://www.iana.org/assignments/media-types/application/vnd.ms-wpl) |
`application/vnd.ms-xpsdocument` | [application/vnd.ms-xpsdocument](https://www.iana.org/assignments/media-types/application/vnd.ms-xpsdocument) |
`application/vnd.msa-disk-image` | [application/vnd.msa-disk-image](https://www.iana.org/assignments/media-types/application/vnd.msa-disk-image) |
`application/vnd.mseq` | [application/vnd.mseq](https://www.iana.org/assignments/media-types/application/vnd.mseq) |
`application/vnd.msign` | [application/vnd.msign](https://www.iana.org/assignments/media-types/application/vnd.msign) |
`application/vnd.multiad.creator` | [application/vnd.multiad.creator](https://www.iana.org/assignments/media-types/application/vnd.multiad.creator) |
`application/vnd.multiad.creator.cif` | [application/vnd.multiad.creator.cif](https://www.iana.org/assignments/media-types/application/vnd.multiad.creator.cif) |
`application/vnd.musician` | [application/vnd.musician](https://www.iana.org/assignments/media-types/application/vnd.musician) |
`application/vnd.music-niff` | [application/vnd.music-niff](https://www.iana.org/assignments/media-types/application/vnd.music-niff) |
`application/vnd.muvee.style` | [application/vnd.muvee.style](https://www.iana.org/assignments/media-types/application/vnd.muvee.style) |
`application/vnd.mynfc` | [application/vnd.mynfc](https://www.iana.org/assignments/media-types/application/vnd.mynfc) |
`application/vnd.ncd.control` | [application/vnd.ncd.control](https://www.iana.org/assignments/media-types/application/vnd.ncd.control) |
`application/vnd.ncd.reference` | [application/vnd.ncd.reference](https://www.iana.org/assignments/media-types/application/vnd.ncd.reference) |
`application/vnd.nervana` | [application/vnd.nervana](https://www.iana.org/assignments/media-types/application/vnd.nervana) |
`application/vnd.netfpx` | [application/vnd.netfpx](https://www.iana.org/assignments/media-types/application/vnd.netfpx) |
`application/vnd.neurolanguage.nlu` | [application/vnd.neurolanguage.nlu](https://www.iana.org/assignments/media-types/application/vnd.neurolanguage.nlu) |
`application/vnd.nintendo.snes.rom` | [application/vnd.nintendo.snes.rom](https://www.iana.org/assignments/media-types/application/vnd.nintendo.snes.rom) |
`application/vnd.nintendo.nitro.rom` | [application/vnd.nintendo.nitro.rom](https://www.iana.org/assignments/media-types/application/vnd.nintendo.nitro.rom) |
`application/vnd.nitf` | [application/vnd.nitf](https://www.iana.org/assignments/media-types/application/vnd.nitf) |
`application/vnd.noblenet-directory` | [application/vnd.noblenet-directory](https://www.iana.org/assignments/media-types/application/vnd.noblenet-directory) |
`application/vnd.noblenet-sealer` | [application/vnd.noblenet-sealer](https://www.iana.org/assignments/media-types/application/vnd.noblenet-sealer) |
`application/vnd.noblenet-web` | [application/vnd.noblenet-web](https://www.iana.org/assignments/media-types/application/vnd.noblenet-web) |
`application/vnd.nokia.catalogs` | [application/vnd.nokia.catalogs](https://www.iana.org/assignments/media-types/application/vnd.nokia.catalogs) |
`application/vnd.nokia.conml+wbxml` | [application/vnd.nokia.conml+wbxml](https://www.iana.org/assignments/media-types/application/vnd.nokia.conml+wbxml) |
`application/vnd.nokia.conml+xml` | [application/vnd.nokia.conml+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.conml+xml) |
`application/vnd.nokia.iptv.config+xml` | [application/vnd.nokia.iptv.config+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.iptv.config+xml) |
`application/vnd.nokia.iSDS-radio-presets` | [application/vnd.nokia.iSDS-radio-presets](https://www.iana.org/assignments/media-types/application/vnd.nokia.iSDS-radio-presets) |
`application/vnd.nokia.landmark+wbxml` | [application/vnd.nokia.landmark+wbxml](https://www.iana.org/assignments/media-types/application/vnd.nokia.landmark+wbxml) |
`application/vnd.nokia.landmark+xml` | [application/vnd.nokia.landmark+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.landmark+xml) |
`application/vnd.nokia.landmarkcollection+xml` | [application/vnd.nokia.landmarkcollection+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.landmarkcollection+xml) |
`application/vnd.nokia.ncd` | [application/vnd.nokia.ncd](https://www.iana.org/assignments/media-types/application/vnd.nokia.ncd) |
`application/vnd.nokia.n-gage.ac+xml` | [application/vnd.nokia.n-gage.ac+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.n-gage.ac+xml) |
`application/vnd.nokia.n-gage.data` | [application/vnd.nokia.n-gage.data](https://www.iana.org/assignments/media-types/application/vnd.nokia.n-gage.data) |
`application/vnd.nokia.n-gage.symbian.install - OBSOLETE; no replacement given` | [application/vnd.nokia.n-gage.symbian.install](https://www.iana.org/assignments/media-types/application/vnd.nokia.n-gage.symbian.install) |
`application/vnd.nokia.pcd+wbxml` | [application/vnd.nokia.pcd+wbxml](https://www.iana.org/assignments/media-types/application/vnd.nokia.pcd+wbxml) |
`application/vnd.nokia.pcd+xml` | [application/vnd.nokia.pcd+xml](https://www.iana.org/assignments/media-types/application/vnd.nokia.pcd+xml) |
`application/vnd.nokia.radio-preset` | [application/vnd.nokia.radio-preset](https://www.iana.org/assignments/media-types/application/vnd.nokia.radio-preset) |
`application/vnd.nokia.radio-presets` | [application/vnd.nokia.radio-presets](https://www.iana.org/assignments/media-types/application/vnd.nokia.radio-presets) |
`application/vnd.novadigm.EDM` | [application/vnd.novadigm.EDM](https://www.iana.org/assignments/media-types/application/vnd.novadigm.EDM) |
`application/vnd.novadigm.EDX` | [application/vnd.novadigm.EDX](https://www.iana.org/assignments/media-types/application/vnd.novadigm.EDX) |
`application/vnd.novadigm.EXT` | [application/vnd.novadigm.EXT](https://www.iana.org/assignments/media-types/application/vnd.novadigm.EXT) |
`application/vnd.ntt-local.content-share` | [application/vnd.ntt-local.content-share](https://www.iana.org/assignments/media-types/application/vnd.ntt-local.content-share) |
`application/vnd.ntt-local.file-transfer` | [application/vnd.ntt-local.file-transfer](https://www.iana.org/assignments/media-types/application/vnd.ntt-local.file-transfer) |
`application/vnd.ntt-local.ogw_remote-access` | [application/vnd.ntt-local.ogw_remote-access](https://www.iana.org/assignments/media-types/application/vnd.ntt-local.ogw_remote-access) |
`application/vnd.ntt-local.sip-ta_remote` | [application/vnd.ntt-local.sip-ta_remote](https://www.iana.org/assignments/media-types/application/vnd.ntt-local.sip-ta_remote) |
`application/vnd.ntt-local.sip-ta_tcp_stream` | [application/vnd.ntt-local.sip-ta_tcp_stream](https://www.iana.org/assignments/media-types/application/vnd.ntt-local.sip-ta_tcp_stream) |
`application/vnd.oasis.opendocument.chart` | [application/vnd.oasis.opendocument.chart](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.chart) |
`application/vnd.oasis.opendocument.chart-template` | [application/vnd.oasis.opendocument.chart-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.chart-template) |
`application/vnd.oasis.opendocument.database` | [application/vnd.oasis.opendocument.database](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.database) |
`application/vnd.oasis.opendocument.formula` | [application/vnd.oasis.opendocument.formula](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.formula) |
`application/vnd.oasis.opendocument.formula-template` | [application/vnd.oasis.opendocument.formula-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.formula-template) |
`application/vnd.oasis.opendocument.graphics` | [application/vnd.oasis.opendocument.graphics](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.graphics) |
`application/vnd.oasis.opendocument.graphics-template` | [application/vnd.oasis.opendocument.graphics-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.graphics-template) |
`application/vnd.oasis.opendocument.image` | [application/vnd.oasis.opendocument.image](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.image) |
`application/vnd.oasis.opendocument.image-template` | [application/vnd.oasis.opendocument.image-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.image-template) |
`application/vnd.oasis.opendocument.presentation` | [application/vnd.oasis.opendocument.presentation](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.presentation) |
`application/vnd.oasis.opendocument.presentation-template` | [application/vnd.oasis.opendocument.presentation-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.presentation-template) |
`application/vnd.oasis.opendocument.spreadsheet` | [application/vnd.oasis.opendocument.spreadsheet](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.spreadsheet) |
`application/vnd.oasis.opendocument.spreadsheet-template` | [application/vnd.oasis.opendocument.spreadsheet-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.spreadsheet-template) |
`application/vnd.oasis.opendocument.text` | [application/vnd.oasis.opendocument.text](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.text) |
`application/vnd.oasis.opendocument.text-master` | [application/vnd.oasis.opendocument.text-master](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.text-master) |
`application/vnd.oasis.opendocument.text-template` | [application/vnd.oasis.opendocument.text-template](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.text-template) |
`application/vnd.oasis.opendocument.text-web` | [application/vnd.oasis.opendocument.text-web](https://www.iana.org/assignments/media-types/application/vnd.oasis.opendocument.text-web) |
`application/vnd.obn` | [application/vnd.obn](https://www.iana.org/assignments/media-types/application/vnd.obn) |
`application/vnd.oftn.l10n+json` | [application/vnd.oftn.l10n+json](https://www.iana.org/assignments/media-types/application/vnd.oftn.l10n+json) |
`application/vnd.oipf.contentaccessdownload+xml` | [application/vnd.oipf.contentaccessdownload+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.contentaccessdownload+xml) |
`application/vnd.oipf.contentaccessstreaming+xml` | [application/vnd.oipf.contentaccessstreaming+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.contentaccessstreaming+xml) |
`application/vnd.oipf.cspg-hexbinary` | [application/vnd.oipf.cspg-hexbinary](https://www.iana.org/assignments/media-types/application/vnd.oipf.cspg-hexbinary) |
`application/vnd.oipf.dae.svg+xml` | [application/vnd.oipf.dae.svg+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.dae.svg+xml) |
`application/vnd.oipf.dae.xhtml+xml` | [application/vnd.oipf.dae.xhtml+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.dae.xhtml+xml) |
`application/vnd.oipf.mippvcontrolmessage+xml` | [application/vnd.oipf.mippvcontrolmessage+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.mippvcontrolmessage+xml) |
`application/vnd.oipf.pae.gem` | [application/vnd.oipf.pae.gem](https://www.iana.org/assignments/media-types/application/vnd.oipf.pae.gem) |
`application/vnd.oipf.spdiscovery+xml` | [application/vnd.oipf.spdiscovery+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.spdiscovery+xml) |
`application/vnd.oipf.spdlist+xml` | [application/vnd.oipf.spdlist+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.spdlist+xml) |
`application/vnd.oipf.ueprofile+xml` | [application/vnd.oipf.ueprofile+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.ueprofile+xml) |
`application/vnd.oipf.userprofile+xml` | [application/vnd.oipf.userprofile+xml](https://www.iana.org/assignments/media-types/application/vnd.oipf.userprofile+xml) |
`application/vnd.olpc-sugar` | [application/vnd.olpc-sugar](https://www.iana.org/assignments/media-types/application/vnd.olpc-sugar) |
`application/vnd.oma.bcast.associated-procedure-parameter+xml` | [application/vnd.oma.bcast.associated-procedure-parameter+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.associated-procedure-parameter+xml) |
`application/vnd.oma.bcast.drm-trigger+xml` | [application/vnd.oma.bcast.drm-trigger+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.drm-trigger+xml) |
`application/vnd.oma.bcast.imd+xml` | [application/vnd.oma.bcast.imd+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.imd+xml) |
`application/vnd.oma.bcast.ltkm` | [application/vnd.oma.bcast.ltkm](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.ltkm) |
`application/vnd.oma.bcast.notification+xml` | [application/vnd.oma.bcast.notification+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.notification+xml) |
`application/vnd.oma.bcast.provisioningtrigger` | [application/vnd.oma.bcast.provisioningtrigger](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.provisioningtrigger) |
`application/vnd.oma.bcast.sgboot` | [application/vnd.oma.bcast.sgboot](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.sgboot) |
`application/vnd.oma.bcast.sgdd+xml` | [application/vnd.oma.bcast.sgdd+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.sgdd+xml) |
`application/vnd.oma.bcast.sgdu` | [application/vnd.oma.bcast.sgdu](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.sgdu) |
`application/vnd.oma.bcast.simple-symbol-container` | [application/vnd.oma.bcast.simple-symbol-container](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.simple-symbol-container) |
`application/vnd.oma.bcast.smartcard-trigger+xml` | [application/vnd.oma.bcast.smartcard-trigger+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.smartcard-trigger+xml) |
`application/vnd.oma.bcast.sprov+xml` | [application/vnd.oma.bcast.sprov+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.sprov+xml) |
`application/vnd.oma.bcast.stkm` | [application/vnd.oma.bcast.stkm](https://www.iana.org/assignments/media-types/application/vnd.oma.bcast.stkm) |
`application/vnd.oma.cab-address-book+xml` | [application/vnd.oma.cab-address-book+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.cab-address-book+xml) |
`application/vnd.oma.cab-feature-handler+xml` | [application/vnd.oma.cab-feature-handler+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.cab-feature-handler+xml) |
`application/vnd.oma.cab-pcc+xml` | [application/vnd.oma.cab-pcc+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.cab-pcc+xml) |
`application/vnd.oma.cab-subs-invite+xml` | [application/vnd.oma.cab-subs-invite+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.cab-subs-invite+xml) |
`application/vnd.oma.cab-user-prefs+xml` | [application/vnd.oma.cab-user-prefs+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.cab-user-prefs+xml) |
`application/vnd.oma.dcd` | [application/vnd.oma.dcd](https://www.iana.org/assignments/media-types/application/vnd.oma.dcd) |
`application/vnd.oma.dcdc` | [application/vnd.oma.dcdc](https://www.iana.org/assignments/media-types/application/vnd.oma.dcdc) |
`application/vnd.oma.dd2+xml` | [application/vnd.oma.dd2+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.dd2+xml) |
`application/vnd.oma.drm.risd+xml` | [application/vnd.oma.drm.risd+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.drm.risd+xml) |
`application/vnd.oma.group-usage-list+xml` | [application/vnd.oma.group-usage-list+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.group-usage-list+xml) |
`application/vnd.oma.pal+xml` | [application/vnd.oma.pal+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.pal+xml) |
`application/vnd.oma.poc.detailed-progress-report+xml` | [application/vnd.oma.poc.detailed-progress-report+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.poc.detailed-progress-report+xml) |
`application/vnd.oma.poc.final-report+xml` | [application/vnd.oma.poc.final-report+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.poc.final-report+xml) |
`application/vnd.oma.poc.groups+xml` | [application/vnd.oma.poc.groups+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.poc.groups+xml) |
`application/vnd.oma.poc.invocation-descriptor+xml` | [application/vnd.oma.poc.invocation-descriptor+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.poc.invocation-descriptor+xml) |
`application/vnd.oma.poc.optimized-progress-report+xml` | [application/vnd.oma.poc.optimized-progress-report+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.poc.optimized-progress-report+xml) |
`application/vnd.oma.push` | [application/vnd.oma.push](https://www.iana.org/assignments/media-types/application/vnd.oma.push) |
`application/vnd.oma.scidm.messages+xml` | [application/vnd.oma.scidm.messages+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.scidm.messages+xml) |
`application/vnd.oma.xcap-directory+xml` | [application/vnd.oma.xcap-directory+xml](https://www.iana.org/assignments/media-types/application/vnd.oma.xcap-directory+xml) |
`application/vnd.omads-email+xml` | [application/vnd.omads-email+xml](https://www.iana.org/assignments/media-types/application/vnd.omads-email+xml) |
`application/vnd.omads-file+xml` | [application/vnd.omads-file+xml](https://www.iana.org/assignments/media-types/application/vnd.omads-file+xml) |
`application/vnd.omads-folder+xml` | [application/vnd.omads-folder+xml](https://www.iana.org/assignments/media-types/application/vnd.omads-folder+xml) |
`application/vnd.omaloc-supl-init` | [application/vnd.omaloc-supl-init](https://www.iana.org/assignments/media-types/application/vnd.omaloc-supl-init) |
`application/vnd.oma-scws-config` | [application/vnd.oma-scws-config](https://www.iana.org/assignments/media-types/application/vnd.oma-scws-config) |
`application/vnd.oma-scws-http-request` | [application/vnd.oma-scws-http-request](https://www.iana.org/assignments/media-types/application/vnd.oma-scws-http-request) |
`application/vnd.oma-scws-http-response` | [application/vnd.oma-scws-http-response](https://www.iana.org/assignments/media-types/application/vnd.oma-scws-http-response) |
`application/vnd.openblox.game-binary` | [application/vnd.openblox.game-binary](https://www.iana.org/assignments/media-types/application/vnd.openblox.game-binary) |
`application/vnd.openblox.game+xml` | [application/vnd.openblox.game+xml](https://www.iana.org/assignments/media-types/application/vnd.openblox.game+xml) |
`application/vnd.openeye.oeb` | [application/vnd.openeye.oeb](https://www.iana.org/assignments/media-types/application/vnd.openeye.oeb) |
`application/vnd.openxmlformats-officedocument.custom-properties+xml` | [application/vnd.openxmlformats-officedocument.custom-properties+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.custom-properties+xml) |
`application/vnd.openxmlformats-officedocument.customXmlProperties+xml` | [application/vnd.openxmlformats-officedocument.customXmlProperties+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.customXmlProperties+xml) |
`application/vnd.openxmlformats-officedocument.drawing+xml` | [application/vnd.openxmlformats-officedocument.drawing+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawing+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.chart+xml` | [application/vnd.openxmlformats-officedocument.drawingml.chart+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.chart+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml` | [application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml` | [application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml` | [application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml` | [application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml) |
`application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml` | [application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml) |
`application/vnd.openxmlformats-officedocument.extended-properties+xml` | [application/vnd.openxmlformats-officedocument.extended-properties+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.extended-properties+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml` | [application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.comments+xml` | [application/vnd.openxmlformats-officedocument.presentationml.comments+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.comments+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml` | [application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml` | [application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml` | [application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.presentation` | [application/vnd.openxmlformats-officedocument.presentationml.presentation](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.presentation) |
`application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml` | [application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.presProps+xml` | [application/vnd.openxmlformats-officedocument.presentationml.presProps+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.presProps+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.slide` | [application/vnd.openxmlformats-officedocument.presentationml.slide](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slide) |
`application/vnd.openxmlformats-officedocument.presentationml.slide+xml` | [application/vnd.openxmlformats-officedocument.presentationml.slide+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slide+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml` | [application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml` | [application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.slideshow` | [application/vnd.openxmlformats-officedocument.presentationml.slideshow](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slideshow) |
`application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml` | [application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml` | [application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml` | [application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.tags+xml` | [application/vnd.openxmlformats-officedocument.presentationml.tags+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.tags+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.template` | [application/vnd.openxmlformats-officedocument.presentationml-template](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml-template) |
`application/vnd.openxmlformats-officedocument.presentationml.template.main+xml` | [application/vnd.openxmlformats-officedocument.presentationml.template.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.template.main+xml) |
`application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml` | [application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.sheet` | [application/vnd.openxmlformats-officedocument.spreadsheetml.sheet](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.sheet) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.template` | [application/vnd.openxmlformats-officedocument.spreadsheetml-template](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml-template) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml) |
`application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml` | [application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml) |
`application/vnd.openxmlformats-officedocument.theme+xml` | [application/vnd.openxmlformats-officedocument.theme+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.theme+xml) |
`application/vnd.openxmlformats-officedocument.themeOverride+xml` | [application/vnd.openxmlformats-officedocument.themeOverride+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.themeOverride+xml) |
`application/vnd.openxmlformats-officedocument.vmlDrawing` | [application/vnd.openxmlformats-officedocument.vmlDrawing](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.vmlDrawing) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.document` | [application/vnd.openxmlformats-officedocument.wordprocessingml.document](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.document) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.template` | [application/vnd.openxmlformats-officedocument.wordprocessingml-template](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml-template) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml) |
`application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml` | [application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml) |
`application/vnd.openxmlformats-package.core-properties+xml` | [application/vnd.openxmlformats-package.core-properties+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-package.core-properties+xml) |
`application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml` | [application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml) |
`application/vnd.openxmlformats-package.relationships+xml` | [application/vnd.openxmlformats-package.relationships+xml](https://www.iana.org/assignments/media-types/application/vnd.openxmlformats-package.relationships+xml) |
`application/vnd.oracle.resource+json` | [application/vnd.oracle.resource+json](https://www.iana.org/assignments/media-types/application/vnd.oracle.resource+json) |
`application/vnd.orange.indata` | [application/vnd.orange.indata](https://www.iana.org/assignments/media-types/application/vnd.orange.indata) |
`application/vnd.osa.netdeploy` | [application/vnd.osa.netdeploy](https://www.iana.org/assignments/media-types/application/vnd.osa.netdeploy) |
`application/vnd.osgeo.mapguide.package` | [application/vnd.osgeo.mapguide.package](https://www.iana.org/assignments/media-types/application/vnd.osgeo.mapguide.package) |
`application/vnd.osgi.bundle` | [application/vnd.osgi.bundle](https://www.iana.org/assignments/media-types/application/vnd.osgi.bundle) |
`application/vnd.osgi.dp` | [application/vnd.osgi.dp](https://www.iana.org/assignments/media-types/application/vnd.osgi.dp) |
`application/vnd.osgi.subsystem` | [application/vnd.osgi.subsystem](https://www.iana.org/assignments/media-types/application/vnd.osgi.subsystem) |
`application/vnd.otps.ct-kip+xml` | [application/vnd.otps.ct-kip+xml](https://www.iana.org/assignments/media-types/application/vnd.otps.ct-kip+xml) |
`application/vnd.oxli.countgraph` | [application/vnd.oxli.countgraph](https://www.iana.org/assignments/media-types/application/vnd.oxli.countgraph) |
`application/vnd.pagerduty+json` | [application/vnd.pagerduty+json](https://www.iana.org/assignments/media-types/application/vnd.pagerduty+json) |
`application/vnd.palm` | [application/vnd.palm](https://www.iana.org/assignments/media-types/application/vnd.palm) |
`application/vnd.panoply` | [application/vnd.panoply](https://www.iana.org/assignments/media-types/application/vnd.panoply) |
`application/vnd.paos.xml` | [application/vnd.paos+xml](https://www.iana.org/assignments/media-types/application/vnd.paos+xml) |
`application/vnd.pawaafile` | [application/vnd.pawaafile](https://www.iana.org/assignments/media-types/application/vnd.pawaafile) |
`application/vnd.pcos` | [application/vnd.pcos](https://www.iana.org/assignments/media-types/application/vnd.pcos) |
`application/vnd.pg.format` | [application/vnd.pg.format](https://www.iana.org/assignments/media-types/application/vnd.pg.format) |
`application/vnd.pg.osasli` | [application/vnd.pg.osasli](https://www.iana.org/assignments/media-types/application/vnd.pg.osasli) |
`application/vnd.piaccess.application-licence` | [application/vnd.piaccess.application-licence](https://www.iana.org/assignments/media-types/application/vnd.piaccess.application-licence) |
`application/vnd.picsel` | [application/vnd.picsel](https://www.iana.org/assignments/media-types/application/vnd.picsel) |
`application/vnd.pmi.widget` | [application/vnd.pmi.widget](https://www.iana.org/assignments/media-types/application/vnd.pmi.widget) |
`application/vnd.poc.group-advertisement+xml` | [application/vnd.poc.group-advertisement+xml](https://www.iana.org/assignments/media-types/application/vnd.poc.group-advertisement+xml) |
`application/vnd.pocketlearn` | [application/vnd.pocketlearn](https://www.iana.org/assignments/media-types/application/vnd.pocketlearn) |
`application/vnd.powerbuilder6` | [application/vnd.powerbuilder6](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder6) |
`application/vnd.powerbuilder6-s` | [application/vnd.powerbuilder6-s](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder6-s) |
`application/vnd.powerbuilder7` | [application/vnd.powerbuilder7](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder7) |
`application/vnd.powerbuilder75` | [application/vnd.powerbuilder75](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder75) |
`application/vnd.powerbuilder75-s` | [application/vnd.powerbuilder75-s](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder75-s) |
`application/vnd.powerbuilder7-s` | [application/vnd.powerbuilder7-s](https://www.iana.org/assignments/media-types/application/vnd.powerbuilder7-s) |
`application/vnd.preminet` | [application/vnd.preminet](https://www.iana.org/assignments/media-types/application/vnd.preminet) |
`application/vnd.previewsystems.box` | [application/vnd.previewsystems.box](https://www.iana.org/assignments/media-types/application/vnd.previewsystems.box) |
`application/vnd.proteus.magazine` | [application/vnd.proteus.magazine](https://www.iana.org/assignments/media-types/application/vnd.proteus.magazine) |
`application/vnd.publishare-delta-tree` | [application/vnd.publishare-delta-tree](https://www.iana.org/assignments/media-types/application/vnd.publishare-delta-tree) |
`application/vnd.pvi.ptid1` | [application/vnd.pvi.ptid1](https://www.iana.org/assignments/media-types/application/vnd.pvi.ptid1) |
`application/vnd.pwg-multiplexed` | [application/vnd.pwg-multiplexed](https://www.iana.org/assignments/media-types/application/vnd.pwg-multiplexed) | [RFC3391](https://tools.ietf.org/html/rfc3391)
`application/vnd.pwg-xhtml-print+xml` | [application/vnd.pwg-xhtml-print+xml](https://www.iana.org/assignments/media-types/application/vnd.pwg-xhtml-print+xml) |
`application/vnd.qualcomm.brew-app-res` | [application/vnd.qualcomm.brew-app-res](https://www.iana.org/assignments/media-types/application/vnd.qualcomm.brew-app-res) |
`application/vnd.Quark.QuarkXPress` | [application/vnd.Quark.QuarkXPress](https://www.iana.org/assignments/media-types/application/vnd.Quark.QuarkXPress) |
`application/vnd.quobject-quoxdocument` | [application/vnd.quobject-quoxdocument](https://www.iana.org/assignments/media-types/application/vnd.quobject-quoxdocument) |
`application/vnd.radisys.moml+xml` | [application/vnd.radisys.moml+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.moml+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-audit-conf+xml` | [application/vnd.radisys.msml-audit-conf+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-audit-conf+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-audit-conn+xml` | [application/vnd.radisys.msml-audit-conn+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-audit-conn+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-audit-dialog+xml` | [application/vnd.radisys.msml-audit-dialog+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-audit-dialog+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-audit-stream+xml` | [application/vnd.radisys.msml-audit-stream+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-audit-stream+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-audit+xml` | [application/vnd.radisys.msml-audit+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-audit+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-conf+xml` | [application/vnd.radisys.msml-conf+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-conf+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-base+xml` | [application/vnd.radisys.msml-dialog-base+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-base+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-fax-detect+xml` | [application/vnd.radisys.msml-dialog-fax-detect+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-fax-detect+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-fax-sendrecv+xml` | [application/vnd.radisys.msml-dialog-fax-sendrecv+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-fax-sendrecv+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-group+xml` | [application/vnd.radisys.msml-dialog-group+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-group+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-speech+xml` | [application/vnd.radisys.msml-dialog-speech+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-speech+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog-transform+xml` | [application/vnd.radisys.msml-dialog-transform+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog-transform+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml-dialog+xml` | [application/vnd.radisys.msml-dialog+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml-dialog+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.radisys.msml+xml` | [application/vnd.radisys.msml+xml](https://www.iana.org/assignments/media-types/application/vnd.radisys.msml+xml) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`application/vnd.rainstor.data` | [application/vnd.rainstor.data](https://www.iana.org/assignments/media-types/application/vnd.rainstor.data) |
`application/vnd.rapid` | [application/vnd.rapid](https://www.iana.org/assignments/media-types/application/vnd.rapid) |
`application/vnd.realvnc.bed` | [application/vnd.realvnc.bed](https://www.iana.org/assignments/media-types/application/vnd.realvnc.bed) |
`application/vnd.recordare.musicxml` | [application/vnd.recordare.musicxml](https://www.iana.org/assignments/media-types/application/vnd.recordare.musicxml) |
`application/vnd.recordare.musicxml+xml` | [application/vnd.recordare.musicxml+xml](https://www.iana.org/assignments/media-types/application/vnd.recordare.musicxml+xml) |
`application/vnd.RenLearn.rlprint` | [application/vnd.renlearn.rlprint](https://www.iana.org/assignments/media-types/application/vnd.renlearn.rlprint) |
`application/vnd.rig.cryptonote` | [application/vnd.rig.cryptonote](https://www.iana.org/assignments/media-types/application/vnd.rig.cryptonote) |
`application/vnd.route66.link66+xml` | [application/vnd.route66.link66+xml](https://www.iana.org/assignments/media-types/application/vnd.route66.link66+xml) |
`application/vnd.rs-274x` | [application/vnd.rs-274x](https://www.iana.org/assignments/media-types/application/vnd.rs-274x) |
`application/vnd.ruckus.download` | [application/vnd.ruckus.download](https://www.iana.org/assignments/media-types/application/vnd.ruckus.download) |
`application/vnd.s3sms` | [application/vnd.s3sms](https://www.iana.org/assignments/media-types/application/vnd.s3sms) |
`application/vnd.sailingtracker.track` | [application/vnd.sailingtracker.track](https://www.iana.org/assignments/media-types/application/vnd.sailingtracker.track) |
`application/vnd.sbm.cid` | [application/vnd.sbm.cid](https://www.iana.org/assignments/media-types/application/vnd.sbm.cid) |
`application/vnd.sbm.mid2` | [application/vnd.sbm.mid2](https://www.iana.org/assignments/media-types/application/vnd.sbm.mid2) |
`application/vnd.scribus` | [application/vnd.scribus](https://www.iana.org/assignments/media-types/application/vnd.scribus) |
`application/vnd.sealed.3df` | [application/vnd.sealed.3df](https://www.iana.org/assignments/media-types/application/vnd.sealed.3df) |
`application/vnd.sealed.csf` | [application/vnd.sealed.csf](https://www.iana.org/assignments/media-types/application/vnd.sealed.csf) |
`application/vnd.sealed.doc` | [application/vnd.sealed-doc](https://www.iana.org/assignments/media-types/application/vnd.sealed-doc) |
`application/vnd.sealed.eml` | [application/vnd.sealed-eml](https://www.iana.org/assignments/media-types/application/vnd.sealed-eml) |
`application/vnd.sealed.mht` | [application/vnd.sealed-mht](https://www.iana.org/assignments/media-types/application/vnd.sealed-mht) |
`application/vnd.sealed.net` | [application/vnd.sealed.net](https://www.iana.org/assignments/media-types/application/vnd.sealed.net) |
`application/vnd.sealed.ppt` | [application/vnd.sealed-ppt](https://www.iana.org/assignments/media-types/application/vnd.sealed-ppt) |
`application/vnd.sealed.tiff` | [application/vnd.sealed-tiff](https://www.iana.org/assignments/media-types/application/vnd.sealed-tiff) |
`application/vnd.sealed.xls` | [application/vnd.sealed-xls](https://www.iana.org/assignments/media-types/application/vnd.sealed-xls) |
`application/vnd.sealedmedia.softseal.html` | [application/vnd.sealedmedia.softseal-html](https://www.iana.org/assignments/media-types/application/vnd.sealedmedia.softseal-html) |
`application/vnd.sealedmedia.softseal.pdf` | [application/vnd.sealedmedia.softseal-pdf](https://www.iana.org/assignments/media-types/application/vnd.sealedmedia.softseal-pdf) |
`application/vnd.seemail` | [application/vnd.seemail](https://www.iana.org/assignments/media-types/application/vnd.seemail) |
`application/vnd.sema` | [application/vnd-sema](https://www.iana.org/assignments/media-types/application/vnd-sema) |
`application/vnd.semd` | [application/vnd.semd](https://www.iana.org/assignments/media-types/application/vnd.semd) |
`application/vnd.semf` | [application/vnd.semf](https://www.iana.org/assignments/media-types/application/vnd.semf) |
`application/vnd.shana.informed.formdata` | [application/vnd.shana.informed.formdata](https://www.iana.org/assignments/media-types/application/vnd.shana.informed.formdata) |
`application/vnd.shana.informed.formtemplate` | [application/vnd.shana.informed.formtemplate](https://www.iana.org/assignments/media-types/application/vnd.shana.informed.formtemplate) |
`application/vnd.shana.informed.interchange` | [application/vnd.shana.informed.interchange](https://www.iana.org/assignments/media-types/application/vnd.shana.informed.interchange) |
`application/vnd.shana.informed.package` | [application/vnd.shana.informed.package](https://www.iana.org/assignments/media-types/application/vnd.shana.informed.package) |
`application/vnd.SimTech-MindMapper` | [application/vnd.SimTech-MindMapper](https://www.iana.org/assignments/media-types/application/vnd.SimTech-MindMapper) |
`application/vnd.siren+json` | [application/vnd.siren+json](https://www.iana.org/assignments/media-types/application/vnd.siren+json) |
`application/vnd.smaf` | [application/vnd.smaf](https://www.iana.org/assignments/media-types/application/vnd.smaf) |
`application/vnd.smart.notebook` | [application/vnd.smart.notebook](https://www.iana.org/assignments/media-types/application/vnd.smart.notebook) |
`application/vnd.smart.teacher` | [application/vnd.smart.teacher](https://www.iana.org/assignments/media-types/application/vnd.smart.teacher) |
`application/vnd.software602.filler.form+xml` | [application/vnd.software602.filler.form+xml](https://www.iana.org/assignments/media-types/application/vnd.software602.filler.form+xml) |
`application/vnd.software602.filler.form-xml-zip` | [application/vnd.software602.filler.form-xml-zip](https://www.iana.org/assignments/media-types/application/vnd.software602.filler.form-xml-zip) |
`application/vnd.solent.sdkm+xml` | [application/vnd.solent.sdkm+xml](https://www.iana.org/assignments/media-types/application/vnd.solent.sdkm+xml) |
`application/vnd.spotfire.dxp` | [application/vnd.spotfire.dxp](https://www.iana.org/assignments/media-types/application/vnd.spotfire.dxp) |
`application/vnd.spotfire.sfs` | [application/vnd.spotfire.sfs](https://www.iana.org/assignments/media-types/application/vnd.spotfire.sfs) |
`application/vnd.sss-cod` | [application/vnd.sss-cod](https://www.iana.org/assignments/media-types/application/vnd.sss-cod) |
`application/vnd.sss-dtf` | [application/vnd.sss-dtf](https://www.iana.org/assignments/media-types/application/vnd.sss-dtf) |
`application/vnd.sss-ntf` | [application/vnd.sss-ntf](https://www.iana.org/assignments/media-types/application/vnd.sss-ntf) |
`application/vnd.stepmania.package` | [application/vnd.stepmania.package](https://www.iana.org/assignments/media-types/application/vnd.stepmania.package) |
`application/vnd.stepmania.stepchart` | [application/vnd.stepmania.stepchart](https://www.iana.org/assignments/media-types/application/vnd.stepmania.stepchart) |
`application/vnd.street-stream` | [application/vnd.street-stream](https://www.iana.org/assignments/media-types/application/vnd.street-stream) |
`application/vnd.sun.wadl+xml` | [application/vnd.sun.wadl+xml](https://www.iana.org/assignments/media-types/application/vnd.sun.wadl+xml) |
`application/vnd.sus-calendar` | [application/vnd.sus-calendar](https://www.iana.org/assignments/media-types/application/vnd.sus-calendar) |
`application/vnd.svd` | [application/vnd.svd](https://www.iana.org/assignments/media-types/application/vnd.svd) |
`application/vnd.swiftview-ics` | [application/vnd.swiftview-ics](https://www.iana.org/assignments/media-types/application/vnd.swiftview-ics) |
`application/vnd.syncml.dm.notification` | [application/vnd.syncml.dm.notification](https://www.iana.org/assignments/media-types/application/vnd.syncml.dm.notification) |
`application/vnd.syncml.dmddf+xml` | [application/vnd.syncml.dmddf+xml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dmddf+xml) |
`application/vnd.syncml.dmtnds+wbxml` | [application/vnd.syncml.dmtnds+wbxml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dmtnds+wbxml) |
`application/vnd.syncml.dmtnds+xml` | [application/vnd.syncml.dmtnds+xml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dmtnds+xml) |
`application/vnd.syncml.dmddf+wbxml` | [application/vnd.syncml.dmddf+wbxml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dmddf+wbxml) |
`application/vnd.syncml.dm+wbxml` | [application/vnd.syncml.dm+wbxml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dm+wbxml) |
`application/vnd.syncml.dm+xml` | [application/vnd.syncml.dm+xml](https://www.iana.org/assignments/media-types/application/vnd.syncml.dm+xml) |
`application/vnd.syncml.ds.notification` | [application/vnd.syncml.ds.notification](https://www.iana.org/assignments/media-types/application/vnd.syncml.ds.notification) |
`application/vnd.syncml+xml` | [application/vnd.syncml+xml](https://www.iana.org/assignments/media-types/application/vnd.syncml+xml) |
`application/vnd.tao.intent-module-archive` | [application/vnd.tao.intent-module-archive](https://www.iana.org/assignments/media-types/application/vnd.tao.intent-module-archive) |
`application/vnd.tcpdump.pcap` | [application/vnd.tcpdump.pcap](https://www.iana.org/assignments/media-types/application/vnd.tcpdump.pcap) |
`application/vnd.tml` | [application/vnd.tml](https://www.iana.org/assignments/media-types/application/vnd.tml) |
`application/vnd.tmd.mediaflex.api+xml` | [application/vnd.tmd.mediaflex.api+xml](https://www.iana.org/assignments/media-types/application/vnd.tmd.mediaflex.api+xml) |
`application/vnd.tmobile-livetv` | [application/vnd.tmobile-livetv](https://www.iana.org/assignments/media-types/application/vnd.tmobile-livetv) |
`application/vnd.trid.tpt` | [application/vnd.trid.tpt](https://www.iana.org/assignments/media-types/application/vnd.trid.tpt) |
`application/vnd.triscape.mxs` | [application/vnd.triscape.mxs](https://www.iana.org/assignments/media-types/application/vnd.triscape.mxs) |
`application/vnd.trueapp` | [application/vnd.trueapp](https://www.iana.org/assignments/media-types/application/vnd.trueapp) |
`application/vnd.truedoc` | [application/vnd.truedoc](https://www.iana.org/assignments/media-types/application/vnd.truedoc) |
`application/vnd.ubisoft.webplayer` | [application/vnd.ubisoft.webplayer](https://www.iana.org/assignments/media-types/application/vnd.ubisoft.webplayer) |
`application/vnd.ufdl` | [application/vnd.ufdl](https://www.iana.org/assignments/media-types/application/vnd.ufdl) |
`application/vnd.uiq.theme` | [application/vnd.uiq.theme](https://www.iana.org/assignments/media-types/application/vnd.uiq.theme) |
`application/vnd.umajin` | [application/vnd.umajin](https://www.iana.org/assignments/media-types/application/vnd.umajin) |
`application/vnd.unity` | [application/vnd.unity](https://www.iana.org/assignments/media-types/application/vnd.unity) |
`application/vnd.uoml+xml` | [application/vnd.uoml+xml](https://www.iana.org/assignments/media-types/application/vnd.uoml+xml) |
`application/vnd.uplanet.alert` | [application/vnd.uplanet.alert](https://www.iana.org/assignments/media-types/application/vnd.uplanet.alert) |
`application/vnd.uplanet.alert-wbxml` | [application/vnd.uplanet.alert-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.alert-wbxml) |
`application/vnd.uplanet.bearer-choice` | [application/vnd.uplanet.bearer-choice](https://www.iana.org/assignments/media-types/application/vnd.uplanet.bearer-choice) |
`application/vnd.uplanet.bearer-choice-wbxml` | [application/vnd.uplanet.bearer-choice-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.bearer-choice-wbxml) |
`application/vnd.uplanet.cacheop` | [application/vnd.uplanet.cacheop](https://www.iana.org/assignments/media-types/application/vnd.uplanet.cacheop) |
`application/vnd.uplanet.cacheop-wbxml` | [application/vnd.uplanet.cacheop-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.cacheop-wbxml) |
`application/vnd.uplanet.channel` | [application/vnd.uplanet.channel](https://www.iana.org/assignments/media-types/application/vnd.uplanet.channel) |
`application/vnd.uplanet.channel-wbxml` | [application/vnd.uplanet.channel-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.channel-wbxml) |
`application/vnd.uplanet.list` | [application/vnd.uplanet.list](https://www.iana.org/assignments/media-types/application/vnd.uplanet.list) |
`application/vnd.uplanet.listcmd` | [application/vnd.uplanet.listcmd](https://www.iana.org/assignments/media-types/application/vnd.uplanet.listcmd) |
`application/vnd.uplanet.listcmd-wbxml` | [application/vnd.uplanet.listcmd-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.listcmd-wbxml) |
`application/vnd.uplanet.list-wbxml` | [application/vnd.uplanet.list-wbxml](https://www.iana.org/assignments/media-types/application/vnd.uplanet.list-wbxml) |
`application/vnd.uri-map` | [application/vnd.uri-map](https://www.iana.org/assignments/media-types/application/vnd.uri-map) |
`application/vnd.uplanet.signal` | [application/vnd.uplanet.signal](https://www.iana.org/assignments/media-types/application/vnd.uplanet.signal) |
`application/vnd.valve.source.material` | [application/vnd.valve.source.material](https://www.iana.org/assignments/media-types/application/vnd.valve.source.material) |
`application/vnd.vcx` | [application/vnd.vcx](https://www.iana.org/assignments/media-types/application/vnd.vcx) |
`application/vnd.vd-study` | [application/vnd.vd-study](https://www.iana.org/assignments/media-types/application/vnd.vd-study) |
`application/vnd.vectorworks` | [application/vnd.vectorworks](https://www.iana.org/assignments/media-types/application/vnd.vectorworks) |
`application/vnd.verimatrix.vcas` | [application/vnd.verimatrix.vcas](https://www.iana.org/assignments/media-types/application/vnd.verimatrix.vcas) |
`application/vnd.vidsoft.vidconference` | [application/vnd.vidsoft.vidconference](https://www.iana.org/assignments/media-types/application/vnd.vidsoft.vidconference) |
`application/vnd.visio` | [application/vnd.visio](https://www.iana.org/assignments/media-types/application/vnd.visio) |
`application/vnd.visionary` | [application/vnd.visionary](https://www.iana.org/assignments/media-types/application/vnd.visionary) |
`application/vnd.vividence.scriptfile` | [application/vnd.vividence.scriptfile](https://www.iana.org/assignments/media-types/application/vnd.vividence.scriptfile) |
`application/vnd.vsf` | [application/vnd.vsf](https://www.iana.org/assignments/media-types/application/vnd.vsf) |
`application/vnd.wap.sic` | [application/vnd.wap.sic](https://www.iana.org/assignments/media-types/application/vnd.wap.sic) |
`application/vnd.wap.slc` | [application/vnd.wap-slc](https://www.iana.org/assignments/media-types/application/vnd.wap-slc) |
`application/vnd.wap.wbxml` | [application/vnd.wap-wbxml](https://www.iana.org/assignments/media-types/application/vnd.wap-wbxml) |
`application/vnd.wap.wmlc` | [application/vnd-wap-wmlc](https://www.iana.org/assignments/media-types/application/vnd-wap-wmlc) |
`application/vnd.wap.wmlscriptc` | [application/vnd.wap.wmlscriptc](https://www.iana.org/assignments/media-types/application/vnd.wap.wmlscriptc) |
`application/vnd.webturbo` | [application/vnd.webturbo](https://www.iana.org/assignments/media-types/application/vnd.webturbo) |
`application/vnd.wfa.p2p` | [application/vnd.wfa.p2p](https://www.iana.org/assignments/media-types/application/vnd.wfa.p2p) |
`application/vnd.wfa.wsc` | [application/vnd.wfa.wsc](https://www.iana.org/assignments/media-types/application/vnd.wfa.wsc) |
`application/vnd.windows.devicepairing` | [application/vnd.windows.devicepairing](https://www.iana.org/assignments/media-types/application/vnd.windows.devicepairing) |
`application/vnd.wmc` | [application/vnd.wmc](https://www.iana.org/assignments/media-types/application/vnd.wmc) |
`application/vnd.wmf.bootstrap` | [application/vnd.wmf.bootstrap](https://www.iana.org/assignments/media-types/application/vnd.wmf.bootstrap) |
`application/vnd.wolfram.mathematica` | [application/vnd.wolfram.mathematica](https://www.iana.org/assignments/media-types/application/vnd.wolfram.mathematica) |
`application/vnd.wolfram.mathematica.package` | [application/vnd.wolfram.mathematica.package](https://www.iana.org/assignments/media-types/application/vnd.wolfram.mathematica.package) |
`application/vnd.wolfram.player` | [application/vnd.wolfram.player](https://www.iana.org/assignments/media-types/application/vnd.wolfram.player) |
`application/vnd.wordperfect` | [application/vnd.wordperfect](https://www.iana.org/assignments/media-types/application/vnd.wordperfect) |
`application/vnd.wqd` | [application/vnd.wqd](https://www.iana.org/assignments/media-types/application/vnd.wqd) |
`application/vnd.wrq-hp3000-labelled` | [application/vnd.wrq-hp3000-labelled](https://www.iana.org/assignments/media-types/application/vnd.wrq-hp3000-labelled) |
`application/vnd.wt.stf` | [application/vnd.wt.stf](https://www.iana.org/assignments/media-types/application/vnd.wt.stf) |
`application/vnd.wv.csp+xml` | [application/vnd.wv.csp+xml](https://www.iana.org/assignments/media-types/application/vnd.wv.csp+xml) |
`application/vnd.wv.csp+wbxml` | [application/vnd.wv.csp+wbxml](https://www.iana.org/assignments/media-types/application/vnd.wv.csp+wbxml) |
`application/vnd.wv.ssp+xml` | [application/vnd.wv.ssp+xml](https://www.iana.org/assignments/media-types/application/vnd.wv.ssp+xml) |
`application/vnd.xacml+json` | [application/vnd.xacml+json](https://www.iana.org/assignments/media-types/application/vnd.xacml+json) |
`application/vnd.xara` | [application/vnd.xara](https://www.iana.org/assignments/media-types/application/vnd.xara) |
`application/vnd.xfdl` | [application/vnd.xfdl](https://www.iana.org/assignments/media-types/application/vnd.xfdl) |
`application/vnd.xfdl.webform` | [application/vnd.xfdl.webform](https://www.iana.org/assignments/media-types/application/vnd.xfdl.webform) |
`application/vnd.xmi+xml` | [application/vnd.xmi+xml](https://www.iana.org/assignments/media-types/application/vnd.xmi+xml) |
`application/vnd.xmpie.cpkg` | [application/vnd.xmpie.cpkg](https://www.iana.org/assignments/media-types/application/vnd.xmpie.cpkg) |
`application/vnd.xmpie.dpkg` | [application/vnd.xmpie.dpkg](https://www.iana.org/assignments/media-types/application/vnd.xmpie.dpkg) |
`application/vnd.xmpie.plan` | [application/vnd.xmpie.plan](https://www.iana.org/assignments/media-types/application/vnd.xmpie.plan) |
`application/vnd.xmpie.ppkg` | [application/vnd.xmpie.ppkg](https://www.iana.org/assignments/media-types/application/vnd.xmpie.ppkg) |
`application/vnd.xmpie.xlim` | [application/vnd.xmpie.xlim](https://www.iana.org/assignments/media-types/application/vnd.xmpie.xlim) |
`application/vnd.yamaha.hv-dic` | [application/vnd.yamaha.hv-dic](https://www.iana.org/assignments/media-types/application/vnd.yamaha.hv-dic) |
`application/vnd.yamaha.hv-script` | [application/vnd.yamaha.hv-script](https://www.iana.org/assignments/media-types/application/vnd.yamaha.hv-script) |
`application/vnd.yamaha.hv-voice` | [application/vnd.yamaha.hv-voice](https://www.iana.org/assignments/media-types/application/vnd.yamaha.hv-voice) |
`application/vnd.yamaha.openscoreformat.osfpvg+xml` | [application/vnd.yamaha.openscoreformat.osfpvg+xml](https://www.iana.org/assignments/media-types/application/vnd.yamaha.openscoreformat.osfpvg+xml) |
`application/vnd.yamaha.openscoreformat` | [application/vnd.yamaha.openscoreformat](https://www.iana.org/assignments/media-types/application/vnd.yamaha.openscoreformat) |
`application/vnd.yamaha.remote-setup` | [application/vnd.yamaha.remote-setup](https://www.iana.org/assignments/media-types/application/vnd.yamaha.remote-setup) |
`application/vnd.yamaha.smaf-audio` | [application/vnd.yamaha.smaf-audio](https://www.iana.org/assignments/media-types/application/vnd.yamaha.smaf-audio) |
`application/vnd.yamaha.smaf-phrase` | [application/vnd.yamaha.smaf-phrase](https://www.iana.org/assignments/media-types/application/vnd.yamaha.smaf-phrase) |
`application/vnd.yamaha.through-ngn` | [application/vnd.yamaha.through-ngn](https://www.iana.org/assignments/media-types/application/vnd.yamaha.through-ngn) |
`application/vnd.yamaha.tunnel-udpencap` | [application/vnd.yamaha.tunnel-udpencap](https://www.iana.org/assignments/media-types/application/vnd.yamaha.tunnel-udpencap) |
`application/vnd.yaoweme` | [application/vnd.yaoweme](https://www.iana.org/assignments/media-types/application/vnd.yaoweme) |
`application/vnd.yellowriver-custom-menu` | [application/vnd.yellowriver-custom-menu](https://www.iana.org/assignments/media-types/application/vnd.yellowriver-custom-menu) |
`application/vnd.zul` | [application/vnd.zul](https://www.iana.org/assignments/media-types/application/vnd.zul) |
`application/vnd.zzazz.deck+xml` | [application/vnd.zzazz.deck+xml](https://www.iana.org/assignments/media-types/application/vnd.zzazz.deck+xml) |
`application/voicexml+xml` | [application/voicexml+xml](https://www.iana.org/assignments/media-types/application/voicexml+xml) | [RFC4267](https://tools.ietf.org/html/rfc4267)
`application/vq-rtcpxr` | [application/vq-rtcpxr](https://www.iana.org/assignments/media-types/application/vq-rtcpxr) | [RFC6035](https://tools.ietf.org/html/rfc6035)
`application/watcherinfo+xml` | [application/watcherinfo+xml](https://www.iana.org/assignments/media-types/application/watcherinfo+xml) | [RFC3858](https://tools.ietf.org/html/rfc3858)
`application/whoispp-query` | [application/whoispp-query](https://www.iana.org/assignments/media-types/application/whoispp-query) | [RFC2957](https://tools.ietf.org/html/rfc2957)
`application/whoispp-response` | [application/whoispp-response](https://www.iana.org/assignments/media-types/application/whoispp-response) | [RFC2958](https://tools.ietf.org/html/rfc2958)
`application/widget` | [](https://www.iana.org/assignments/media-types/) |
`application/wita` | [application/wita](https://www.iana.org/assignments/media-types/application/wita) |
`application/wordperfect5.1` | [application/wordperfect5.1](https://www.iana.org/assignments/media-types/application/wordperfect5.1) |
`application/wsdl+xml` | [application/wsdl+xml](https://www.iana.org/assignments/media-types/application/wsdl+xml) |
`application/wspolicy+xml` | [application/wspolicy+xml](https://www.iana.org/assignments/media-types/application/wspolicy+xml) |
`application/x-www-form-urlencoded` | [application/x-www-form-urlencoded](https://www.iana.org/assignments/media-types/application/x-www-form-urlencoded) |
`application/x400-bp` | [application/x400-bp](https://www.iana.org/assignments/media-types/application/x400-bp) | [RFC1494](https://tools.ietf.org/html/rfc1494)
`application/xacml+xml` | [application/xacml+xml](https://www.iana.org/assignments/media-types/application/xacml+xml) | [RFC7061](https://tools.ietf.org/html/rfc7061)
`application/xcap-att+xml` | [application/xcap-att+xml](https://www.iana.org/assignments/media-types/application/xcap-att+xml) | [RFC4825](https://tools.ietf.org/html/rfc4825)
`application/xcap-caps+xml` | [application/xcap-caps+xml](https://www.iana.org/assignments/media-types/application/xcap-caps+xml) | [RFC4825](https://tools.ietf.org/html/rfc4825)
`application/xcap-diff+xml` | [application/xcap-diff+xml](https://www.iana.org/assignments/media-types/application/xcap-diff+xml) | [RFC5874](https://tools.ietf.org/html/rfc5874)
`application/xcap-el+xml` | [application/xcap-el+xml](https://www.iana.org/assignments/media-types/application/xcap-el+xml) | [RFC4825](https://tools.ietf.org/html/rfc4825)
`application/xcap-error+xml` | [application/xcap-error+xml](https://www.iana.org/assignments/media-types/application/xcap-error+xml) | [RFC4825](https://tools.ietf.org/html/rfc4825)
`application/xcap-ns+xml` | [application/xcap-ns+xml](https://www.iana.org/assignments/media-types/application/xcap-ns+xml) | [RFC4825](https://tools.ietf.org/html/rfc4825)
`application/xcon-conference-info-diff+xml` | [application/xcon-conference-info-diff+xml](https://www.iana.org/assignments/media-types/application/xcon-conference-info-diff+xml) | [RFC6502](https://tools.ietf.org/html/rfc6502)
`application/xcon-conference-info+xml` | [application/xcon-conference-info+xml](https://www.iana.org/assignments/media-types/application/xcon-conference-info+xml) | [RFC6502](https://tools.ietf.org/html/rfc6502)
`application/xenc+xml` | [application/xenc+xml](https://www.iana.org/assignments/media-types/application/xenc+xml) |
`application/xhtml+xml` | [application/xhtml+xml](https://www.iana.org/assignments/media-types/application/xhtml+xml) |
`application/xml` | [application/xml](https://www.iana.org/assignments/media-types/application/xml) | [RFC7303](https://tools.ietf.org/html/rfc7303)
`application/xml-dtd` | [application/xml-dtd](https://www.iana.org/assignments/media-types/application/xml-dtd) | [RFC7303](https://tools.ietf.org/html/rfc7303)
`application/xml-external-parsed-entity` | [application/xml-external-parsed-entity](https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity) | [RFC7303](https://tools.ietf.org/html/rfc7303)
`application/xml-patch+xml` | [application/xml-patch+xml](https://www.iana.org/assignments/media-types/application/xml-patch+xml) | [RFC7351](https://tools.ietf.org/html/rfc7351)
`application/xmpp+xml` | [application/xmpp+xml](https://www.iana.org/assignments/media-types/application/xmpp+xml) | [RFC3923](https://tools.ietf.org/html/rfc3923)
`application/xop+xml` | [application/xop+xml](https://www.iana.org/assignments/media-types/application/xop+xml) |
`application/xslt+xml` | [](https://www.iana.org/assignments/media-types/) |
`application/xv+xml` | [application/xv+xml](https://www.iana.org/assignments/media-types/application/xv+xml) | [RFC4374](https://tools.ietf.org/html/rfc4374)
`application/yang` | [application/yang](https://www.iana.org/assignments/media-types/application/yang) | [RFC6020](https://tools.ietf.org/html/rfc6020)
`application/yin+xml` | [application/yin+xml](https://www.iana.org/assignments/media-types/application/yin+xml) | [RFC6020](https://tools.ietf.org/html/rfc6020)
`application/zip` | [application/zip](https://www.iana.org/assignments/media-types/application/zip) |
`application/zlib` | [application/zlib](https://www.iana.org/assignments/media-types/application/zlib) | [RFC6713](https://tools.ietf.org/html/rfc6713)


## Audio

media-type | template | spec
---------: | :------- | :---
`audio/1d-interleaved-parityfec` | [audio/1d-interleaved-parityfec](https://www.iana.org/assignments/media-types/audio/1d-interleaved-parityfec) | [RFC6015](https://tools.ietf.org/html/rfc6015)
`audio/32kadpcm` | [audio/32kadpcm](https://www.iana.org/assignments/media-types/audio/32kadpcm) | [RFC3802](https://tools.ietf.org/html/rfc3802), [RFC2421](https://tools.ietf.org/html/rfc2421)
`audio/3gpp` | [audio/3gpp](https://www.iana.org/assignments/media-types/audio/3gpp) | [RFC3839](https://tools.ietf.org/html/rfc3839), [RFC6381](https://tools.ietf.org/html/rfc6381)
`audio/3gpp2` | [audio/3gpp2](https://www.iana.org/assignments/media-types/audio/3gpp2) | [RFC4393](https://tools.ietf.org/html/rfc4393), [RFC6381](https://tools.ietf.org/html/rfc6381)
`audio/ac3` | [audio/ac3](https://www.iana.org/assignments/media-types/audio/ac3) | [RFC4184](https://tools.ietf.org/html/rfc4184)
`audio/AMR` | [audio/AMR](https://www.iana.org/assignments/media-types/audio/AMR) | [RFC4867](https://tools.ietf.org/html/rfc4867)
`audio/AMR-WB` | [audio/AMR-WB](https://www.iana.org/assignments/media-types/audio/AMR-WB) | [RFC4867](https://tools.ietf.org/html/rfc4867)
`audio/amr-wb+` | [audio/amr-wb+](https://www.iana.org/assignments/media-types/audio/amr-wb+) | [RFC4352](https://tools.ietf.org/html/rfc4352)
`audio/aptx` | [audio/aptx](https://www.iana.org/assignments/media-types/audio/aptx) | [RFC7310](https://tools.ietf.org/html/rfc7310)
`audio/asc` | [audio/asc](https://www.iana.org/assignments/media-types/audio/asc) | [RFC6295](https://tools.ietf.org/html/rfc6295)
`audio/ATRAC-ADVANCED-LOSSLESS` | [audio/ATRAC-ADVANCED-LOSSLESS](https://www.iana.org/assignments/media-types/audio/ATRAC-ADVANCED-LOSSLESS) | [RFC5584](https://tools.ietf.org/html/rfc5584)
`audio/ATRAC-X` | [audio/ATRAC-X](https://www.iana.org/assignments/media-types/audio/ATRAC-X) | [RFC5584](https://tools.ietf.org/html/rfc5584)
`audio/ATRAC3` | [audio/ATRAC3](https://www.iana.org/assignments/media-types/audio/ATRAC3) | [RFC5584](https://tools.ietf.org/html/rfc5584)
`audio/basic` | [audio/basic](https://www.iana.org/assignments/media-types/audio/basic) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`audio/BV16` | [audio/BV16](https://www.iana.org/assignments/media-types/audio/BV16) | [RFC4298](https://tools.ietf.org/html/rfc4298)
`audio/BV32` | [audio/BV32](https://www.iana.org/assignments/media-types/audio/BV32) | [RFC4298](https://tools.ietf.org/html/rfc4298)
`audio/clearmode` | [audio/clearmode](https://www.iana.org/assignments/media-types/audio/clearmode) | [RFC4040](https://tools.ietf.org/html/rfc4040)
`audio/CN` | [audio/CN](https://www.iana.org/assignments/media-types/audio/CN) | [RFC3389](https://tools.ietf.org/html/rfc3389)
`audio/DAT12` | [audio/DAT12](https://www.iana.org/assignments/media-types/audio/DAT12) | [RFC3190](https://tools.ietf.org/html/rfc3190)
`audio/dls` | [audio/dls](https://www.iana.org/assignments/media-types/audio/dls) | [RFC4613](https://tools.ietf.org/html/rfc4613)
`audio/dsr-es201108` | [audio/dsr-es201108](https://www.iana.org/assignments/media-types/audio/dsr-es201108) | [RFC3557](https://tools.ietf.org/html/rfc3557)
`audio/dsr-es202050` | [audio/dsr-es202050](https://www.iana.org/assignments/media-types/audio/dsr-es202050) | [RFC4060](https://tools.ietf.org/html/rfc4060)
`audio/dsr-es202211` | [audio/dsr-es202211](https://www.iana.org/assignments/media-types/audio/dsr-es202211) | [RFC4060](https://tools.ietf.org/html/rfc4060)
`audio/dsr-es202212` | [audio/dsr-es202212](https://www.iana.org/assignments/media-types/audio/dsr-es202212) | [RFC4060](https://tools.ietf.org/html/rfc4060)
`audio/DV` | [audio/DV](https://www.iana.org/assignments/media-types/audio/DV) | [RFC6469](https://tools.ietf.org/html/rfc6469)
`audio/DVI4` | [audio/DVI4](https://www.iana.org/assignments/media-types/audio/DVI4) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/eac3` | [audio/eac3](https://www.iana.org/assignments/media-types/audio/eac3) | [RFC4598](https://tools.ietf.org/html/rfc4598)
`audio/encaprtp` | [audio/encaprtp](https://www.iana.org/assignments/media-types/audio/encaprtp) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`audio/EVRC` | [audio/EVRC](https://www.iana.org/assignments/media-types/audio/EVRC) | [RFC4788](https://tools.ietf.org/html/rfc4788)
`audio/EVRC-QCP` | [audio/EVRC-QCP](https://www.iana.org/assignments/media-types/audio/EVRC-QCP) | [RFC3625](https://tools.ietf.org/html/rfc3625)
`audio/EVRC0` | [audio/EVRC0](https://www.iana.org/assignments/media-types/audio/EVRC0) | [RFC4788](https://tools.ietf.org/html/rfc4788)
`audio/EVRC1` | [audio/EVRC1](https://www.iana.org/assignments/media-types/audio/EVRC1) | [RFC4788](https://tools.ietf.org/html/rfc4788)
`audio/EVRCB` | [audio/EVRCB](https://www.iana.org/assignments/media-types/audio/EVRCB) | [RFC5188](https://tools.ietf.org/html/rfc5188)
`audio/EVRCB0` | [audio/EVRCB0](https://www.iana.org/assignments/media-types/audio/EVRCB0) | [RFC5188](https://tools.ietf.org/html/rfc5188)
`audio/EVRCB1` | [audio/EVRCB1](https://www.iana.org/assignments/media-types/audio/EVRCB1) | [RFC4788](https://tools.ietf.org/html/rfc4788)
`audio/EVRCNW` | [audio/EVRCNW](https://www.iana.org/assignments/media-types/audio/EVRCNW) | [RFC6884](https://tools.ietf.org/html/rfc6884)
`audio/EVRCNW0` | [audio/EVRCNW0](https://www.iana.org/assignments/media-types/audio/EVRCNW0) | [RFC6884](https://tools.ietf.org/html/rfc6884)
`audio/EVRCNW1` | [audio/EVRCNW1](https://www.iana.org/assignments/media-types/audio/EVRCNW1) | [RFC6884](https://tools.ietf.org/html/rfc6884)
`audio/EVRCWB` | [audio/EVRCWB](https://www.iana.org/assignments/media-types/audio/EVRCWB) | [RFC5188](https://tools.ietf.org/html/rfc5188)
`audio/EVRCWB0` | [audio/EVRCWB0](https://www.iana.org/assignments/media-types/audio/EVRCWB0) | [RFC5188](https://tools.ietf.org/html/rfc5188)
`audio/EVRCWB1` | [audio/EVRCWB1](https://www.iana.org/assignments/media-types/audio/EVRCWB1) | [RFC5188](https://tools.ietf.org/html/rfc5188)
`audio/EVS` | [audio/EVS](https://www.iana.org/assignments/media-types/audio/EVS) |
`audio/example` | [audio/example](https://www.iana.org/assignments/media-types/audio/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`audio/fwdred` | [audio/fwdred](https://www.iana.org/assignments/media-types/audio/fwdred) | [RFC6354](https://tools.ietf.org/html/rfc6354)
`audio/G711-0` | [audio/G711-0](https://www.iana.org/assignments/media-types/audio/G711-0) | [RFC7655](https://tools.ietf.org/html/rfc7655)
`audio/G719` | [audio/G719](https://www.iana.org/assignments/media-types/audio/G719) | [RFC Errata ](https://tools.ietf.org/html/rfc errata )
`audio/          3245]"` |  |
`audio/G7221` | [audio/G7221](https://www.iana.org/assignments/media-types/audio/G7221) | [RFC5577](https://tools.ietf.org/html/rfc5577)
`audio/G722` | [audio/G722](https://www.iana.org/assignments/media-types/audio/G722) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G723` | [audio/G723](https://www.iana.org/assignments/media-types/audio/G723) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G726-16` | [audio/G726-16](https://www.iana.org/assignments/media-types/audio/G726-16) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G726-24` | [audio/G726-24](https://www.iana.org/assignments/media-types/audio/G726-24) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G726-32` | [audio/G726-32](https://www.iana.org/assignments/media-types/audio/G726-32) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G726-40` | [audio/G726-40](https://www.iana.org/assignments/media-types/audio/G726-40) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G728` | [audio/G728](https://www.iana.org/assignments/media-types/audio/G728) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G729` | [audio/G729](https://www.iana.org/assignments/media-types/audio/G729) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G7291` | [](https://www.iana.org/assignments/media-types/) | [RFC4749](https://tools.ietf.org/html/rfc4749), [RFC5459](https://tools.ietf.org/html/rfc5459)
`audio/G729D` | [audio/G729D](https://www.iana.org/assignments/media-types/audio/G729D) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/G729E` | [audio/G729E](https://www.iana.org/assignments/media-types/audio/G729E) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/GSM` | [audio/GSM](https://www.iana.org/assignments/media-types/audio/GSM) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/GSM-EFR` | [audio/GSM-EFR](https://www.iana.org/assignments/media-types/audio/GSM-EFR) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/GSM-HR-08` | [audio/GSM-HR-08](https://www.iana.org/assignments/media-types/audio/GSM-HR-08) | [RFC5993](https://tools.ietf.org/html/rfc5993)
`audio/iLBC` | [audio/iLBC](https://www.iana.org/assignments/media-types/audio/iLBC) | [RFC3952](https://tools.ietf.org/html/rfc3952)
`audio/ip-mr_v2.5` | [audio/ip-mr_v2.5](https://www.iana.org/assignments/media-types/audio/ip-mr_v2.5) | [RFC6262](https://tools.ietf.org/html/rfc6262)
`audio/L8` | [audio/L8](https://www.iana.org/assignments/media-types/audio/L8) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/L16` | [audio/L16](https://www.iana.org/assignments/media-types/audio/L16) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/L20` | [audio/L20](https://www.iana.org/assignments/media-types/audio/L20) | [RFC3190](https://tools.ietf.org/html/rfc3190)
`audio/L24` | [audio/L24](https://www.iana.org/assignments/media-types/audio/L24) | [RFC3190](https://tools.ietf.org/html/rfc3190)
`audio/LPC` | [audio/LPC](https://www.iana.org/assignments/media-types/audio/LPC) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/mobile-xmf` | [audio/mobile-xmf](https://www.iana.org/assignments/media-types/audio/mobile-xmf) | [RFC4723](https://tools.ietf.org/html/rfc4723)
`audio/MPA` | [audio/MPA](https://www.iana.org/assignments/media-types/audio/MPA) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`audio/mp4` | [audio/mp4](https://www.iana.org/assignments/media-types/audio/mp4) | [RFC4337](https://tools.ietf.org/html/rfc4337), [RFC6381](https://tools.ietf.org/html/rfc6381)
`audio/MP4A-LATM` | [audio/MP4A-LATM](https://www.iana.org/assignments/media-types/audio/MP4A-LATM) | [RFC6416](https://tools.ietf.org/html/rfc6416)
`audio/mpa-robust` | [audio/mpa-robust](https://www.iana.org/assignments/media-types/audio/mpa-robust) | [RFC5219](https://tools.ietf.org/html/rfc5219)
`audio/mpeg` | [audio/mpeg](https://www.iana.org/assignments/media-types/audio/mpeg) | [RFC3003](https://tools.ietf.org/html/rfc3003)
`audio/mpeg4-generic` | [audio/mpeg4-generic](https://www.iana.org/assignments/media-types/audio/mpeg4-generic) | [RFC3640](https://tools.ietf.org/html/rfc3640), [RFC5691](https://tools.ietf.org/html/rfc5691), [RFC6295](https://tools.ietf.org/html/rfc6295)
`audio/ogg` | [audio/ogg](https://www.iana.org/assignments/media-types/audio/ogg) | [RFC5334](https://tools.ietf.org/html/rfc5334)
`audio/opus` | [audio/opus](https://www.iana.org/assignments/media-types/audio/opus) | [RFC7587](https://tools.ietf.org/html/rfc7587)
`audio/parityfec` | [](https://www.iana.org/assignments/media-types/) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`audio/PCMA` | [audio/PCMA](https://www.iana.org/assignments/media-types/audio/PCMA) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/PCMA-WB` | [audio/PCMA-WB](https://www.iana.org/assignments/media-types/audio/PCMA-WB) | [RFC5391](https://tools.ietf.org/html/rfc5391)
`audio/PCMU` | [audio/PCMU](https://www.iana.org/assignments/media-types/audio/PCMU) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/PCMU-WB` | [audio/PCMU-WB](https://www.iana.org/assignments/media-types/audio/PCMU-WB) | [RFC5391](https://tools.ietf.org/html/rfc5391)
`audio/prs.sid` | [audio/prs.sid](https://www.iana.org/assignments/media-types/audio/prs.sid) |
`audio/QCELP` | [](https://www.iana.org/assignments/media-types/) | [RFC3555](https://tools.ietf.org/html/rfc3555), [RFC3625](https://tools.ietf.org/html/rfc3625)
`audio/raptorfec` | [audio/raptorfec](https://www.iana.org/assignments/media-types/audio/raptorfec) | [RFC6682](https://tools.ietf.org/html/rfc6682)
`audio/RED` | [audio/RED](https://www.iana.org/assignments/media-types/audio/RED) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`audio/rtp-enc-aescm128` | [audio/rtp-enc-aescm128](https://www.iana.org/assignments/media-types/audio/rtp-enc-aescm128) |
`audio/rtploopback` | [audio/rtploopback](https://www.iana.org/assignments/media-types/audio/rtploopback) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`audio/rtp-midi` | [audio/rtp-midi](https://www.iana.org/assignments/media-types/audio/rtp-midi) | [RFC6295](https://tools.ietf.org/html/rfc6295)
`audio/rtx` | [audio/rtx](https://www.iana.org/assignments/media-types/audio/rtx) | [RFC4588](https://tools.ietf.org/html/rfc4588)
`audio/SMV` | [audio/SMV](https://www.iana.org/assignments/media-types/audio/SMV) | [RFC3558](https://tools.ietf.org/html/rfc3558)
`audio/SMV0` | [audio/SMV0](https://www.iana.org/assignments/media-types/audio/SMV0) | [RFC3558](https://tools.ietf.org/html/rfc3558)
`audio/SMV-QCP` | [audio/SMV-QCP](https://www.iana.org/assignments/media-types/audio/SMV-QCP) | [RFC3625](https://tools.ietf.org/html/rfc3625)
`audio/sp-midi` | [audio/sp-midi](https://www.iana.org/assignments/media-types/audio/sp-midi) |
`audio/speex` | [audio/speex](https://www.iana.org/assignments/media-types/audio/speex) | [RFC5574](https://tools.ietf.org/html/rfc5574)
`audio/t140c` | [audio/t140c](https://www.iana.org/assignments/media-types/audio/t140c) | [RFC4351](https://tools.ietf.org/html/rfc4351)
`audio/t38` | [audio/t38](https://www.iana.org/assignments/media-types/audio/t38) | [RFC4612](https://tools.ietf.org/html/rfc4612)
`audio/telephone-event` | [audio/telephone-event](https://www.iana.org/assignments/media-types/audio/telephone-event) | [RFC4733](https://tools.ietf.org/html/rfc4733)
`audio/tone` | [audio/tone](https://www.iana.org/assignments/media-types/audio/tone) | [RFC4733](https://tools.ietf.org/html/rfc4733)
`audio/UEMCLIP` | [audio/UEMCLIP](https://www.iana.org/assignments/media-types/audio/UEMCLIP) | [RFC5686](https://tools.ietf.org/html/rfc5686)
`audio/ulpfec` | [audio/ulpfec](https://www.iana.org/assignments/media-types/audio/ulpfec) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`audio/VDVI` | [audio/VDVI](https://www.iana.org/assignments/media-types/audio/VDVI) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`audio/VMR-WB` | [audio/VMR-WB](https://www.iana.org/assignments/media-types/audio/VMR-WB) | [RFC4348](https://tools.ietf.org/html/rfc4348), [RFC4424](https://tools.ietf.org/html/rfc4424)
`audio/vnd.3gpp.iufp` | [audio/vnd.3gpp.iufp](https://www.iana.org/assignments/media-types/audio/vnd.3gpp.iufp) |
`audio/vnd.4SB` | [audio/vnd.4SB](https://www.iana.org/assignments/media-types/audio/vnd.4SB) |
`audio/vnd.audiokoz` | [audio/vnd.audiokoz](https://www.iana.org/assignments/media-types/audio/vnd.audiokoz) |
`audio/vnd.CELP` | [audio/vnd.CELP](https://www.iana.org/assignments/media-types/audio/vnd.CELP) |
`audio/vnd.cisco.nse` | [audio/vnd.cisco.nse](https://www.iana.org/assignments/media-types/audio/vnd.cisco.nse) |
`audio/vnd.cmles.radio-events` | [audio/vnd.cmles.radio-events](https://www.iana.org/assignments/media-types/audio/vnd.cmles.radio-events) |
`audio/vnd.cns.anp1` | [audio/vnd.cns.anp1](https://www.iana.org/assignments/media-types/audio/vnd.cns.anp1) |
`audio/vnd.cns.inf1` | [audio/vnd.cns.inf1](https://www.iana.org/assignments/media-types/audio/vnd.cns.inf1) |
`audio/vnd.dece.audio` | [audio/vnd.dece.audio](https://www.iana.org/assignments/media-types/audio/vnd.dece.audio) |
`audio/vnd.digital-winds` | [audio/vnd.digital-winds](https://www.iana.org/assignments/media-types/audio/vnd.digital-winds) |
`audio/vnd.dlna.adts` | [audio/vnd.dlna.adts](https://www.iana.org/assignments/media-types/audio/vnd.dlna.adts) |
`audio/vnd.dolby.heaac.1` | [audio/vnd.dolby.heaac.1](https://www.iana.org/assignments/media-types/audio/vnd.dolby.heaac.1) |
`audio/vnd.dolby.heaac.2` | [audio/vnd.dolby.heaac.2](https://www.iana.org/assignments/media-types/audio/vnd.dolby.heaac.2) |
`audio/vnd.dolby.mlp` | [audio/vnd.dolby.mlp](https://www.iana.org/assignments/media-types/audio/vnd.dolby.mlp) |
`audio/vnd.dolby.mps` | [audio/vnd.dolby.mps](https://www.iana.org/assignments/media-types/audio/vnd.dolby.mps) |
`audio/vnd.dolby.pl2` | [audio/vnd.dolby.pl2](https://www.iana.org/assignments/media-types/audio/vnd.dolby.pl2) |
`audio/vnd.dolby.pl2x` | [audio/vnd.dolby.pl2x](https://www.iana.org/assignments/media-types/audio/vnd.dolby.pl2x) |
`audio/vnd.dolby.pl2z` | [audio/vnd.dolby.pl2z](https://www.iana.org/assignments/media-types/audio/vnd.dolby.pl2z) |
`audio/vnd.dolby.pulse.1` | [audio/vnd.dolby.pulse.1](https://www.iana.org/assignments/media-types/audio/vnd.dolby.pulse.1) |
`audio/vnd.dra` | [audio/vnd.dra](https://www.iana.org/assignments/media-types/audio/vnd.dra) |
`audio/vnd.dts` | [audio/vnd.dts](https://www.iana.org/assignments/media-types/audio/vnd.dts) |
`audio/vnd.dts.hd` | [audio/vnd.dts.hd](https://www.iana.org/assignments/media-types/audio/vnd.dts.hd) |
`audio/vnd.dvb.file` | [audio/vnd.dvb.file](https://www.iana.org/assignments/media-types/audio/vnd.dvb.file) |
`audio/vnd.everad.plj` | [audio/vnd.everad.plj](https://www.iana.org/assignments/media-types/audio/vnd.everad.plj) |
`audio/vnd.hns.audio` | [audio/vnd.hns.audio](https://www.iana.org/assignments/media-types/audio/vnd.hns.audio) |
`audio/vnd.lucent.voice` | [audio/vnd.lucent.voice](https://www.iana.org/assignments/media-types/audio/vnd.lucent.voice) |
`audio/vnd.ms-playready.media.pya` | [audio/vnd.ms-playready.media.pya](https://www.iana.org/assignments/media-types/audio/vnd.ms-playready.media.pya) |
`audio/vnd.nokia.mobile-xmf` | [audio/vnd.nokia.mobile-xmf](https://www.iana.org/assignments/media-types/audio/vnd.nokia.mobile-xmf) |
`audio/vnd.nortel.vbk` | [audio/vnd.nortel.vbk](https://www.iana.org/assignments/media-types/audio/vnd.nortel.vbk) |
`audio/vnd.nuera.ecelp4800` | [audio/vnd.nuera.ecelp4800](https://www.iana.org/assignments/media-types/audio/vnd.nuera.ecelp4800) |
`audio/vnd.nuera.ecelp7470` | [audio/vnd.nuera.ecelp7470](https://www.iana.org/assignments/media-types/audio/vnd.nuera.ecelp7470) |
`audio/vnd.nuera.ecelp9600` | [audio/vnd.nuera.ecelp9600](https://www.iana.org/assignments/media-types/audio/vnd.nuera.ecelp9600) |
`audio/vnd.octel.sbc` | [audio/vnd.octel.sbc](https://www.iana.org/assignments/media-types/audio/vnd.octel.sbc) |
`audio/vnd.qcelp - DEPRECATED in favor of audio/qcelp` | [audio/vnd.qcelp](https://www.iana.org/assignments/media-types/audio/vnd.qcelp) | [RFC3625](https://tools.ietf.org/html/rfc3625)
`audio/vnd.rhetorex.32kadpcm` | [audio/vnd.rhetorex.32kadpcm](https://www.iana.org/assignments/media-types/audio/vnd.rhetorex.32kadpcm) |
`audio/vnd.rip` | [audio/vnd.rip](https://www.iana.org/assignments/media-types/audio/vnd.rip) |
`audio/vnd.sealedmedia.softseal.mpeg` | [audio/vnd.sealedmedia.softseal-mpeg](https://www.iana.org/assignments/media-types/audio/vnd.sealedmedia.softseal-mpeg) |
`audio/vnd.vmx.cvsd` | [audio/vnd.vmx.cvsd](https://www.iana.org/assignments/media-types/audio/vnd.vmx.cvsd) |
`audio/vorbis` | [audio/vorbis](https://www.iana.org/assignments/media-types/audio/vorbis) | [RFC5215](https://tools.ietf.org/html/rfc5215)
`audio/vorbis-config` | [audio/vorbis-config](https://www.iana.org/assignments/media-types/audio/vorbis-config) | [RFC5215](https://tools.ietf.org/html/rfc5215)


## Image

media-type | template | spec
---------: | :------- | :---
`image/cgm` | [image/cgm](https://www.iana.org/assignments/media-types/image/cgm) |
`image/example` | [image/example](https://www.iana.org/assignments/media-types/image/example) |
`image/fits` | [image/fits](https://www.iana.org/assignments/media-types/image/fits) |
`image/g3fax` | [image/g3fax](https://www.iana.org/assignments/media-types/image/g3fax) |
`image/gif` | [](https://www.iana.org/assignments/media-types/) |
`image/ief` | [](https://www.iana.org/assignments/media-types/) |
`image/jp2` | [image/jp2](https://www.iana.org/assignments/media-types/image/jp2) |
`image/jpeg` | [](https://www.iana.org/assignments/media-types/) |
`image/jpm` | [image/jpm](https://www.iana.org/assignments/media-types/image/jpm) |
`image/jpx` | [image/jpx](https://www.iana.org/assignments/media-types/image/jpx) |
`image/ktx` | [](https://www.iana.org/assignments/media-types/) |
`image/naplps` | [image/naplps](https://www.iana.org/assignments/media-types/image/naplps) |
`image/png` | [image/png](https://www.iana.org/assignments/media-types/image/png) |
`image/prs.btif` | [image/prs.btif](https://www.iana.org/assignments/media-types/image/prs.btif) |
`image/prs.pti` | [image/prs.pti](https://www.iana.org/assignments/media-types/image/prs.pti) |
`image/pwg-raster` | [image/pwg-raster](https://www.iana.org/assignments/media-types/image/pwg-raster) |
`image/svg+xml` | [](https://www.iana.org/assignments/media-types/) |
`image/t38` | [image/t38](https://www.iana.org/assignments/media-types/image/t38) |
`image/tiff` | [image/tiff](https://www.iana.org/assignments/media-types/image/tiff) |
`image/tiff-fx` | [image/tiff-fx](https://www.iana.org/assignments/media-types/image/tiff-fx) |
`image/vnd.adobe.photoshop` | [image/vnd.adobe.photoshop](https://www.iana.org/assignments/media-types/image/vnd.adobe.photoshop) |
`image/vnd.airzip.accelerator.azv` | [image/vnd.airzip.accelerator.azv](https://www.iana.org/assignments/media-types/image/vnd.airzip.accelerator.azv) |
`image/vnd.cns.inf2` | [image/vnd.cns.inf2](https://www.iana.org/assignments/media-types/image/vnd.cns.inf2) |
`image/vnd.dece.graphic` | [image/vnd.dece.graphic](https://www.iana.org/assignments/media-types/image/vnd.dece.graphic) |
`image/vnd.djvu` | [image/vnd-djvu](https://www.iana.org/assignments/media-types/image/vnd-djvu) |
`image/vnd.dwg` | [image/vnd.dwg](https://www.iana.org/assignments/media-types/image/vnd.dwg) |
`image/vnd.dxf` | [image/vnd.dxf](https://www.iana.org/assignments/media-types/image/vnd.dxf) |
`image/vnd.dvb.subtitle` | [image/vnd.dvb.subtitle](https://www.iana.org/assignments/media-types/image/vnd.dvb.subtitle) |
`image/vnd.fastbidsheet` | [image/vnd.fastbidsheet](https://www.iana.org/assignments/media-types/image/vnd.fastbidsheet) |
`image/vnd.fpx` | [image/vnd.fpx](https://www.iana.org/assignments/media-types/image/vnd.fpx) |
`image/vnd.fst` | [image/vnd.fst](https://www.iana.org/assignments/media-types/image/vnd.fst) |
`image/vnd.fujixerox.edmics-mmr` | [image/vnd.fujixerox.edmics-mmr](https://www.iana.org/assignments/media-types/image/vnd.fujixerox.edmics-mmr) |
`image/vnd.fujixerox.edmics-rlc` | [image/vnd.fujixerox.edmics-rlc](https://www.iana.org/assignments/media-types/image/vnd.fujixerox.edmics-rlc) |
`image/vnd.globalgraphics.pgb` | [image/vnd.globalgraphics.pgb](https://www.iana.org/assignments/media-types/image/vnd.globalgraphics.pgb) |
`image/vnd.microsoft.icon` | [image/vnd.microsoft.icon](https://www.iana.org/assignments/media-types/image/vnd.microsoft.icon) |
`image/vnd.mix` | [image/vnd.mix](https://www.iana.org/assignments/media-types/image/vnd.mix) |
`image/vnd.ms-modi` | [image/vnd.ms-modi](https://www.iana.org/assignments/media-types/image/vnd.ms-modi) |
`image/vnd.mozilla.apng` | [image/vnd.mozilla.apng](https://www.iana.org/assignments/media-types/image/vnd.mozilla.apng) |
`image/vnd.net-fpx` | [image/vnd.net-fpx](https://www.iana.org/assignments/media-types/image/vnd.net-fpx) |
`image/vnd.radiance` | [image/vnd.radiance](https://www.iana.org/assignments/media-types/image/vnd.radiance) |
`image/vnd.sealed.png` | [image/vnd.sealed-png](https://www.iana.org/assignments/media-types/image/vnd.sealed-png) |
`image/vnd.sealedmedia.softseal.gif` | [image/vnd.sealedmedia.softseal-gif](https://www.iana.org/assignments/media-types/image/vnd.sealedmedia.softseal-gif) |
`image/vnd.sealedmedia.softseal.jpg` | [image/vnd.sealedmedia.softseal-jpg](https://www.iana.org/assignments/media-types/image/vnd.sealedmedia.softseal-jpg) |
`image/vnd.svf` | [image/vnd-svf](https://www.iana.org/assignments/media-types/image/vnd-svf) |
`image/vnd.tencent.tap` | [image/vnd.tencent.tap](https://www.iana.org/assignments/media-types/image/vnd.tencent.tap) |
`image/vnd.valve.source.texture` | [image/vnd.valve.source.texture](https://www.iana.org/assignments/media-types/image/vnd.valve.source.texture) |
`image/vnd.wap.wbmp` | [image/vnd-wap-wbmp](https://www.iana.org/assignments/media-types/image/vnd-wap-wbmp) |
`image/vnd.xiff` | [image/vnd.xiff](https://www.iana.org/assignments/media-types/image/vnd.xiff) |
`image/vnd.zbrush.pcx` | [image/vnd.zbrush.pcx](https://www.iana.org/assignments/media-types/image/vnd.zbrush.pcx) |


## Message

media-type | template | spec
---------: | :------- | :---
`message/CPIM` | [message/CPIM](https://www.iana.org/assignments/media-types/message/CPIM) | [RFC3862](https://tools.ietf.org/html/rfc3862)
`message/delivery-status` | [message/delivery-status](https://www.iana.org/assignments/media-types/message/delivery-status) | [RFC1894](https://tools.ietf.org/html/rfc1894)
`message/disposition-notification` | [message/disposition-notification](https://www.iana.org/assignments/media-types/message/disposition-notification) | [RFC3798](https://tools.ietf.org/html/rfc3798)
`message/example` | [message/example](https://www.iana.org/assignments/media-types/message/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`message/external-body` | [](https://www.iana.org/assignments/media-types/) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`message/feedback-report` | [message/feedback-report](https://www.iana.org/assignments/media-types/message/feedback-report) | [RFC5965](https://tools.ietf.org/html/rfc5965)
`message/global` | [message/global](https://www.iana.org/assignments/media-types/message/global) | [RFC6532](https://tools.ietf.org/html/rfc6532)
`message/global-delivery-status` | [message/global-delivery-status](https://www.iana.org/assignments/media-types/message/global-delivery-status) | [RFC6533](https://tools.ietf.org/html/rfc6533)
`message/global-disposition-notification` | [message/global-disposition-notification](https://www.iana.org/assignments/media-types/message/global-disposition-notification) | [RFC6533](https://tools.ietf.org/html/rfc6533)
`message/global-headers` | [message/global-headers](https://www.iana.org/assignments/media-types/message/global-headers) | [RFC6533](https://tools.ietf.org/html/rfc6533)
`message/http` | [message/http](https://www.iana.org/assignments/media-types/message/http) | [RFC7230](https://tools.ietf.org/html/rfc7230)
`message/imdn+xml` | [message/imdn+xml](https://www.iana.org/assignments/media-types/message/imdn+xml) | [RFC5438](https://tools.ietf.org/html/rfc5438)
`message/news - OBSOLETED by RFC5537` | [message/news](https://www.iana.org/assignments/media-types/message/news) | [RFC5537](https://tools.ietf.org/html/rfc5537)
`message/partial` | [](https://www.iana.org/assignments/media-types/) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`message/rfc822` | [](https://www.iana.org/assignments/media-types/) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`message/s-http` | [message/s-http](https://www.iana.org/assignments/media-types/message/s-http) | [RFC2660](https://tools.ietf.org/html/rfc2660)
`message/sip` | [message/sip](https://www.iana.org/assignments/media-types/message/sip) | [RFC3261](https://tools.ietf.org/html/rfc3261)
`message/sipfrag` | [message/sipfrag](https://www.iana.org/assignments/media-types/message/sipfrag) | [RFC3420](https://tools.ietf.org/html/rfc3420)
`message/tracking-status` | [message/tracking-status](https://www.iana.org/assignments/media-types/message/tracking-status) | [RFC3886](https://tools.ietf.org/html/rfc3886)
`message/vnd.si.simp - OBSOLETED by request` | [message/vnd.si.simp](https://www.iana.org/assignments/media-types/message/vnd.si.simp) |
`message/vnd.wfa.wsc` | [message/vnd.wfa.wsc](https://www.iana.org/assignments/media-types/message/vnd.wfa.wsc) |


## Model

media-type | template | spec
---------: | :------- | :---
`model/example` | [model/example](https://www.iana.org/assignments/media-types/model/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`model/iges` | [model/iges](https://www.iana.org/assignments/media-types/model/iges) |
`model/mesh` | [](https://www.iana.org/assignments/media-types/) | [RFC2077](https://tools.ietf.org/html/rfc2077)
`model/vnd.collada+xml` | [model/vnd.collada+xml](https://www.iana.org/assignments/media-types/model/vnd.collada+xml) |
`model/vnd.dwf` | [model/vnd-dwf](https://www.iana.org/assignments/media-types/model/vnd-dwf) |
`model/vnd.flatland.3dml` | [model/vnd.flatland.3dml](https://www.iana.org/assignments/media-types/model/vnd.flatland.3dml) |
`model/vnd.gdl` | [model/vnd.gdl](https://www.iana.org/assignments/media-types/model/vnd.gdl) |
`model/vnd.gs-gdl` | [model/vnd.gs-gdl](https://www.iana.org/assignments/media-types/model/vnd.gs-gdl) |
`model/vnd.gtw` | [model/vnd.gtw](https://www.iana.org/assignments/media-types/model/vnd.gtw) |
`model/vnd.moml+xml` | [model/vnd.moml+xml](https://www.iana.org/assignments/media-types/model/vnd.moml+xml) |
`model/vnd.mts` | [model/vnd.mts](https://www.iana.org/assignments/media-types/model/vnd.mts) |
`model/vnd.opengex` | [model/vnd.opengex](https://www.iana.org/assignments/media-types/model/vnd.opengex) |
`model/vnd.parasolid.transmit.binary` | [model/vnd.parasolid.transmit-binary](https://www.iana.org/assignments/media-types/model/vnd.parasolid.transmit-binary) |
`model/vnd.parasolid.transmit.text` | [model/vnd.parasolid.transmit-text](https://www.iana.org/assignments/media-types/model/vnd.parasolid.transmit-text) |
`model/vnd.rosette.annotated-data-model` | [model/vnd.rosette.annotated-data-model](https://www.iana.org/assignments/media-types/model/vnd.rosette.annotated-data-model) |
`model/vnd.valve.source.compiled-map` | [model/vnd.valve.source.compiled-map](https://www.iana.org/assignments/media-types/model/vnd.valve.source.compiled-map) |
`model/vnd.vtu` | [model/vnd.vtu](https://www.iana.org/assignments/media-types/model/vnd.vtu) |
`model/vrml` | [](https://www.iana.org/assignments/media-types/) | [RFC2077](https://tools.ietf.org/html/rfc2077)
`model/x3d-vrml` | [model/x3d-vrml](https://www.iana.org/assignments/media-types/model/x3d-vrml) |
`model/x3d+fastinfoset` | [model/x3d+fastinfoset](https://www.iana.org/assignments/media-types/model/x3d+fastinfoset) |
`model/x3d+xml` | [model/x3d+xml](https://www.iana.org/assignments/media-types/model/x3d+xml) |


## Multipart

media-type | template | spec
---------: | :------- | :---
`multipart/alternative` | [](https://www.iana.org/assignments/media-types/) | [RFC2046](https://tools.ietf.org/html/rfc2046), [RFC2045](https://tools.ietf.org/html/rfc2045)
`multipart/appledouble` | [multipart/appledouble](https://www.iana.org/assignments/media-types/multipart/appledouble) |
`multipart/byteranges` | [multipart/byteranges](https://www.iana.org/assignments/media-types/multipart/byteranges) | [RFC7233](https://tools.ietf.org/html/rfc7233)
`multipart/digest` | [](https://www.iana.org/assignments/media-types/) | [RFC2046](https://tools.ietf.org/html/rfc2046), [RFC2045](https://tools.ietf.org/html/rfc2045)
`multipart/encrypted` | [multipart/encrypted](https://www.iana.org/assignments/media-types/multipart/encrypted) | [RFC1847](https://tools.ietf.org/html/rfc1847)
`multipart/example` | [multipart/example](https://www.iana.org/assignments/media-types/multipart/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`multipart/form-data` | [multipart/form-data](https://www.iana.org/assignments/media-types/multipart/form-data) | [RFC7578](https://tools.ietf.org/html/rfc7578)
`multipart/header-set` | [multipart/header-set](https://www.iana.org/assignments/media-types/multipart/header-set) |
`multipart/mixed` | [](https://www.iana.org/assignments/media-types/) | [RFC2046](https://tools.ietf.org/html/rfc2046), [RFC2045](https://tools.ietf.org/html/rfc2045)
`multipart/parallel` | [](https://www.iana.org/assignments/media-types/) | [RFC2046](https://tools.ietf.org/html/rfc2046), [RFC2045](https://tools.ietf.org/html/rfc2045)
`multipart/related` | [multipart/related](https://www.iana.org/assignments/media-types/multipart/related) | [RFC2387](https://tools.ietf.org/html/rfc2387)
`multipart/report` | [multipart/report](https://www.iana.org/assignments/media-types/multipart/report) | [RFC6522](https://tools.ietf.org/html/rfc6522)
`multipart/signed` | [multipart/signed](https://www.iana.org/assignments/media-types/multipart/signed) | [RFC1847](https://tools.ietf.org/html/rfc1847)
`multipart/voice-message` | [multipart/voice-message](https://www.iana.org/assignments/media-types/multipart/voice-message) | [RFC2421](https://tools.ietf.org/html/rfc2421), [RFC2423](https://tools.ietf.org/html/rfc2423)
`multipart/x-mixed-replace` | [multipart/x-mixed-replace](https://www.iana.org/assignments/media-types/multipart/x-mixed-replace) |


## Model

media-type | template | spec
---------: | :------- | :---
`text/1d-interleaved-parityfec` | [text/1d-interleaved-parityfec](https://www.iana.org/assignments/media-types/text/1d-interleaved-parityfec) | [RFC6015](https://tools.ietf.org/html/rfc6015)
`text/cache-manifest` | [text/cache-manifest](https://www.iana.org/assignments/media-types/text/cache-manifest) |
`text/calendar` | [text/calendar](https://www.iana.org/assignments/media-types/text/calendar) | [RFC5545](https://tools.ietf.org/html/rfc5545)
`text/css` | [text/css](https://www.iana.org/assignments/media-types/text/css) | [RFC2318](https://tools.ietf.org/html/rfc2318)
`text/csv` | [text/csv](https://www.iana.org/assignments/media-types/text/csv) | [RFC4180](https://tools.ietf.org/html/rfc4180), [RFC7111](https://tools.ietf.org/html/rfc7111)
`text/csv-schema` | [text/csv-schema](https://www.iana.org/assignments/media-types/text/csv-schema) |
`text/directory - DEPRECATED by RFC6350` | [text/directory](https://www.iana.org/assignments/media-types/text/directory) | [RFC2425](https://tools.ietf.org/html/rfc2425), [RFC6350](https://tools.ietf.org/html/rfc6350)
`text/dns` | [text/dns](https://www.iana.org/assignments/media-types/text/dns) | [RFC4027](https://tools.ietf.org/html/rfc4027)
`text/ecmascript - OBSOLETED in favor of application/ecmascript` | [text/ecmascript](https://www.iana.org/assignments/media-types/text/ecmascript) | [RFC4329](https://tools.ietf.org/html/rfc4329)
`text/encaprtp` | [text/encaprtp](https://www.iana.org/assignments/media-types/text/encaprtp) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`text/enriched` | [](https://www.iana.org/assignments/media-types/) | [RFC1896](https://tools.ietf.org/html/rfc1896)
`text/example` | [text/example](https://www.iana.org/assignments/media-types/text/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`text/fwdred` | [text/fwdred](https://www.iana.org/assignments/media-types/text/fwdred) | [RFC6354](https://tools.ietf.org/html/rfc6354)
`text/grammar-ref-list` | [text/grammar-ref-list](https://www.iana.org/assignments/media-types/text/grammar-ref-list) | [RFC6787](https://tools.ietf.org/html/rfc6787)
`text/html` | [text/html](https://www.iana.org/assignments/media-types/text/html) |
`text/javascript - OBSOLETED in favor of application/javascript` | [text/javascript](https://www.iana.org/assignments/media-types/text/javascript) | [RFC4329](https://tools.ietf.org/html/rfc4329)
`text/jcr-cnd` | [text/jcr-cnd](https://www.iana.org/assignments/media-types/text/jcr-cnd) |
`text/markdown` | [text/markdown](https://www.iana.org/assignments/media-types/text/markdown) | [RFC-ietf-appsawg-text-markdown-12](https://tools.ietf.org/html/rfc-ietf-appsawg-text-markdown-12)
`text/mizar` | [text/mizar](https://www.iana.org/assignments/media-types/text/mizar) |
`text/n3` | [text/n3](https://www.iana.org/assignments/media-types/text/n3) |
`text/parameters` | [text/parameters](https://www.iana.org/assignments/media-types/text/parameters) | [RFC-ietf-mmusic-rfc2326bis-40](https://tools.ietf.org/html/rfc-ietf-mmusic-rfc2326bis-40)
`text/parityfec` | [](https://www.iana.org/assignments/media-types/) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`text/plain` | [](https://www.iana.org/assignments/media-types/) | [RFC2046](https://tools.ietf.org/html/rfc2046), [RFC3676](https://tools.ietf.org/html/rfc3676), [RFC5147](https://tools.ietf.org/html/rfc5147)
`text/provenance-notation` | [text/provenance-notation](https://www.iana.org/assignments/media-types/text/provenance-notation) |
`text/prs.fallenstein.rst` | [text/prs.fallenstein.rst](https://www.iana.org/assignments/media-types/text/prs.fallenstein.rst) |
`text/prs.lines.tag` | [text/prs.lines.tag](https://www.iana.org/assignments/media-types/text/prs.lines.tag) |
`text/raptorfec` | [text/raptorfec](https://www.iana.org/assignments/media-types/text/raptorfec) | [RFC6682](https://tools.ietf.org/html/rfc6682)
`text/RED` | [text/RED](https://www.iana.org/assignments/media-types/text/RED) | [RFC4102](https://tools.ietf.org/html/rfc4102)
`text/rfc822-headers` | [text/rfc822-headers](https://www.iana.org/assignments/media-types/text/rfc822-headers) | [RFC6522](https://tools.ietf.org/html/rfc6522)
`text/richtext` | [](https://www.iana.org/assignments/media-types/) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`text/rtf` | [text/rtf](https://www.iana.org/assignments/media-types/text/rtf) |
`text/rtp-enc-aescm128` | [text/rtp-enc-aescm128](https://www.iana.org/assignments/media-types/text/rtp-enc-aescm128) |
`text/rtploopback` | [text/rtploopback](https://www.iana.org/assignments/media-types/text/rtploopback) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`text/rtx` | [text/rtx](https://www.iana.org/assignments/media-types/text/rtx) | [RFC4588](https://tools.ietf.org/html/rfc4588)
`text/sgml` | [text/SGML](https://www.iana.org/assignments/media-types/text/SGML) | [RFC1874](https://tools.ietf.org/html/rfc1874)
`text/t140` | [text/t140](https://www.iana.org/assignments/media-types/text/t140) | [RFC4103](https://tools.ietf.org/html/rfc4103)
`text/tab-separated-values` | [text/tab-separated-values](https://www.iana.org/assignments/media-types/text/tab-separated-values) |
`text/troff` | [text/troff](https://www.iana.org/assignments/media-types/text/troff) | [RFC4263](https://tools.ietf.org/html/rfc4263)
`text/turtle` | [text/turtle](https://www.iana.org/assignments/media-types/text/turtle) |
`text/ulpfec` | [text/ulpfec](https://www.iana.org/assignments/media-types/text/ulpfec) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`text/uri-list` | [text/uri-list](https://www.iana.org/assignments/media-types/text/uri-list) | [RFC2483](https://tools.ietf.org/html/rfc2483)
`text/vcard` | [text/vcard](https://www.iana.org/assignments/media-types/text/vcard) | [RFC6350](https://tools.ietf.org/html/rfc6350)
`text/vnd.a` | [text/vnd-a](https://www.iana.org/assignments/media-types/text/vnd-a) |
`text/vnd.abc` | [text/vnd.abc](https://www.iana.org/assignments/media-types/text/vnd.abc) |
`text/vnd.curl` | [text/vnd-curl](https://www.iana.org/assignments/media-types/text/vnd-curl) |
`text/vnd.debian.copyright` | [text/vnd.debian.copyright](https://www.iana.org/assignments/media-types/text/vnd.debian.copyright) |
`text/vnd.DMClientScript` | [text/vnd.DMClientScript](https://www.iana.org/assignments/media-types/text/vnd.DMClientScript) |
`text/vnd.dvb.subtitle` | [text/vnd.dvb.subtitle](https://www.iana.org/assignments/media-types/text/vnd.dvb.subtitle) |
`text/vnd.esmertec.theme-descriptor` | [text/vnd.esmertec.theme-descriptor](https://www.iana.org/assignments/media-types/text/vnd.esmertec.theme-descriptor) |
`text/vnd.fly` | [text/vnd.fly](https://www.iana.org/assignments/media-types/text/vnd.fly) |
`text/vnd.fmi.flexstor` | [text/vnd.fmi.flexstor](https://www.iana.org/assignments/media-types/text/vnd.fmi.flexstor) |
`text/vnd.graphviz` | [text/vnd.graphviz](https://www.iana.org/assignments/media-types/text/vnd.graphviz) |
`text/vnd.in3d.3dml` | [text/vnd.in3d.3dml](https://www.iana.org/assignments/media-types/text/vnd.in3d.3dml) |
`text/vnd.in3d.spot` | [text/vnd.in3d.spot](https://www.iana.org/assignments/media-types/text/vnd.in3d.spot) |
`text/vnd.IPTC.NewsML` | [text/vnd.IPTC.NewsML](https://www.iana.org/assignments/media-types/text/vnd.IPTC.NewsML) |
`text/vnd.IPTC.NITF` | [text/vnd.IPTC.NITF](https://www.iana.org/assignments/media-types/text/vnd.IPTC.NITF) |
`text/vnd.latex-z` | [text/vnd.latex-z](https://www.iana.org/assignments/media-types/text/vnd.latex-z) |
`text/vnd.motorola.reflex` | [text/vnd.motorola.reflex](https://www.iana.org/assignments/media-types/text/vnd.motorola.reflex) |
`text/vnd.ms-mediapackage` | [text/vnd.ms-mediapackage](https://www.iana.org/assignments/media-types/text/vnd.ms-mediapackage) |
`text/vnd.net2phone.commcenter.command` | [text/vnd.net2phone.commcenter.command](https://www.iana.org/assignments/media-types/text/vnd.net2phone.commcenter.command) |
`text/vnd.radisys.msml-basic-layout` | [text/vnd.radisys.msml-basic-layout](https://www.iana.org/assignments/media-types/text/vnd.radisys.msml-basic-layout) | [RFC5707](https://tools.ietf.org/html/rfc5707)
`text/vnd.si.uricatalogue - OBSOLETED by request` | [text/vnd.si.uricatalogue](https://www.iana.org/assignments/media-types/text/vnd.si.uricatalogue) |
`text/vnd.sun.j2me.app-descriptor` | [text/vnd.sun.j2me.app-descriptor](https://www.iana.org/assignments/media-types/text/vnd.sun.j2me.app-descriptor) |
`text/vnd.trolltech.linguist` | [text/vnd.trolltech.linguist](https://www.iana.org/assignments/media-types/text/vnd.trolltech.linguist) |
`text/vnd.wap.si` | [text/vnd.wap.si](https://www.iana.org/assignments/media-types/text/vnd.wap.si) |
`text/vnd.wap.sl` | [text/vnd.wap.sl](https://www.iana.org/assignments/media-types/text/vnd.wap.sl) |
`text/vnd.wap.wml` | [text/vnd.wap-wml](https://www.iana.org/assignments/media-types/text/vnd.wap-wml) |
`text/vnd.wap.wmlscript` | [text/vnd.wap.wmlscript](https://www.iana.org/assignments/media-types/text/vnd.wap.wmlscript) |
`text/xml` | [text/xml](https://www.iana.org/assignments/media-types/text/xml) | [RFC7303](https://tools.ietf.org/html/rfc7303)
`text/xml-external-parsed-entity` | [text/xml-external-parsed-entity](https://www.iana.org/assignments/media-types/text/xml-external-parsed-entity) | [RFC7303](https://tools.ietf.org/html/rfc7303)


## Video

media-type | template | spec
---------: | :------- | :---
`video/1d-interleaved-parityfec` | [video/1d-interleaved-parityfec](https://www.iana.org/assignments/media-types/video/1d-interleaved-parityfec) | [RFC6015](https://tools.ietf.org/html/rfc6015)
`video/3gpp` | [video/3gpp](https://www.iana.org/assignments/media-types/video/3gpp) | [RFC3839](https://tools.ietf.org/html/rfc3839), [RFC6381](https://tools.ietf.org/html/rfc6381)
`video/3gpp2` | [video/3gpp2](https://www.iana.org/assignments/media-types/video/3gpp2) | [RFC4393](https://tools.ietf.org/html/rfc4393), [RFC6381](https://tools.ietf.org/html/rfc6381)
`video/3gpp-tt` | [video/3gpp-tt](https://www.iana.org/assignments/media-types/video/3gpp-tt) | [RFC4396](https://tools.ietf.org/html/rfc4396)
`video/BMPEG` | [video/BMPEG](https://www.iana.org/assignments/media-types/video/BMPEG) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/BT656` | [video/BT656](https://www.iana.org/assignments/media-types/video/BT656) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/CelB` | [video/CelB](https://www.iana.org/assignments/media-types/video/CelB) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/DV` | [video/DV](https://www.iana.org/assignments/media-types/video/DV) | [RFC6469](https://tools.ietf.org/html/rfc6469)
`video/encaprtp` | [video/encaprtp](https://www.iana.org/assignments/media-types/video/encaprtp) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`video/example` | [video/example](https://www.iana.org/assignments/media-types/video/example) | [RFC4735](https://tools.ietf.org/html/rfc4735)
`video/H261` | [video/H261](https://www.iana.org/assignments/media-types/video/H261) | [RFC4587](https://tools.ietf.org/html/rfc4587)
`video/H263` | [video/H263](https://www.iana.org/assignments/media-types/video/H263) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/H263-1998` | [video/H263-1998](https://www.iana.org/assignments/media-types/video/H263-1998) | [RFC4629](https://tools.ietf.org/html/rfc4629)
`video/H263-2000` | [video/H263-2000](https://www.iana.org/assignments/media-types/video/H263-2000) | [RFC4629](https://tools.ietf.org/html/rfc4629)
`video/H264` | [video/H264](https://www.iana.org/assignments/media-types/video/H264) | [RFC6184](https://tools.ietf.org/html/rfc6184)
`video/H264-RCDO` | [video/H264-RCDO](https://www.iana.org/assignments/media-types/video/H264-RCDO) | [RFC6185](https://tools.ietf.org/html/rfc6185)
`video/H264-SVC` | [video/H264-SVC](https://www.iana.org/assignments/media-types/video/H264-SVC) | [RFC6190](https://tools.ietf.org/html/rfc6190)
`video/H265` | [video/H265](https://www.iana.org/assignments/media-types/video/H265) | [RFC-ietf-payload-rtp-h265-15](https://tools.ietf.org/html/rfc-ietf-payload-rtp-h265-15)
`video/iso.segment` | [video/iso.segment](https://www.iana.org/assignments/media-types/video/iso.segment) |
`video/JPEG` | [video/JPEG](https://www.iana.org/assignments/media-types/video/JPEG) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/jpeg2000` | [video/jpeg2000](https://www.iana.org/assignments/media-types/video/jpeg2000) | [RFC5371](https://tools.ietf.org/html/rfc5371), [RFC5372](https://tools.ietf.org/html/rfc5372)
`video/mj2` | [video/mj2](https://www.iana.org/assignments/media-types/video/mj2) | [RFC3745](https://tools.ietf.org/html/rfc3745)
`video/MP1S` | [video/MP1S](https://www.iana.org/assignments/media-types/video/MP1S) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/MP2P` | [video/MP2P](https://www.iana.org/assignments/media-types/video/MP2P) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/MP2T` | [video/MP2T](https://www.iana.org/assignments/media-types/video/MP2T) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/mp4` | [video/mp4](https://www.iana.org/assignments/media-types/video/mp4) | [RFC4337](https://tools.ietf.org/html/rfc4337), [RFC6381](https://tools.ietf.org/html/rfc6381)
`video/MP4V-ES` | [video/MP4V-ES](https://www.iana.org/assignments/media-types/video/MP4V-ES) | [RFC6416](https://tools.ietf.org/html/rfc6416)
`video/MPV` | [video/MPV](https://www.iana.org/assignments/media-types/video/MPV) | [RFC3555](https://tools.ietf.org/html/rfc3555)
`video/mpeg` | [](https://www.iana.org/assignments/media-types/) | [RFC2045](https://tools.ietf.org/html/rfc2045), [RFC2046](https://tools.ietf.org/html/rfc2046)
`video/mpeg4-generic` | [video/mpeg4-generic](https://www.iana.org/assignments/media-types/video/mpeg4-generic) | [RFC3640](https://tools.ietf.org/html/rfc3640)
`video/nv` | [video/nv](https://www.iana.org/assignments/media-types/video/nv) | [RFC4856](https://tools.ietf.org/html/rfc4856)
`video/ogg` | [video/ogg](https://www.iana.org/assignments/media-types/video/ogg) | [RFC5334](https://tools.ietf.org/html/rfc5334)
`video/parityfec` | [](https://www.iana.org/assignments/media-types/) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`video/pointer` | [video/pointer](https://www.iana.org/assignments/media-types/video/pointer) | [RFC2862](https://tools.ietf.org/html/rfc2862)
`video/quicktime` | [video/quicktime](https://www.iana.org/assignments/media-types/video/quicktime) | [RFC6381](https://tools.ietf.org/html/rfc6381)
`video/raptorfec` | [video/raptorfec](https://www.iana.org/assignments/media-types/video/raptorfec) | [RFC6682](https://tools.ietf.org/html/rfc6682)
`video/raw` | [](https://www.iana.org/assignments/media-types/) | [RFC4175](https://tools.ietf.org/html/rfc4175)
`video/rtp-enc-aescm128` | [video/rtp-enc-aescm128](https://www.iana.org/assignments/media-types/video/rtp-enc-aescm128) |
`video/rtploopback` | [video/rtploopback](https://www.iana.org/assignments/media-types/video/rtploopback) | [RFC6849](https://tools.ietf.org/html/rfc6849)
`video/rtx` | [video/rtx](https://www.iana.org/assignments/media-types/video/rtx) | [RFC4588](https://tools.ietf.org/html/rfc4588)
`video/SMPTE292M` | [video/SMPTE292M](https://www.iana.org/assignments/media-types/video/SMPTE292M) | [RFC3497](https://tools.ietf.org/html/rfc3497)
`video/ulpfec` | [video/ulpfec](https://www.iana.org/assignments/media-types/video/ulpfec) | [RFC5109](https://tools.ietf.org/html/rfc5109)
`video/vc1` | [video/vc1](https://www.iana.org/assignments/media-types/video/vc1) | [RFC4425](https://tools.ietf.org/html/rfc4425)
`video/vnd.CCTV` | [video/vnd.CCTV](https://www.iana.org/assignments/media-types/video/vnd.CCTV) |
`video/vnd.dece.hd` | [video/vnd.dece.hd](https://www.iana.org/assignments/media-types/video/vnd.dece.hd) |
`video/vnd.dece.mobile` | [video/vnd.dece.mobile](https://www.iana.org/assignments/media-types/video/vnd.dece.mobile) |
`video/vnd.dece.mp4` | [video/vnd.dece-mp4](https://www.iana.org/assignments/media-types/video/vnd.dece-mp4) |
`video/vnd.dece.pd` | [video/vnd.dece.pd](https://www.iana.org/assignments/media-types/video/vnd.dece.pd) |
`video/vnd.dece.sd` | [video/vnd.dece.sd](https://www.iana.org/assignments/media-types/video/vnd.dece.sd) |
`video/vnd.dece.video` | [video/vnd.dece.video](https://www.iana.org/assignments/media-types/video/vnd.dece.video) |
`video/vnd.directv.mpeg` | [video/vnd.directv-mpeg](https://www.iana.org/assignments/media-types/video/vnd.directv-mpeg) |
`video/vnd.directv.mpeg-tts` | [video/vnd.directv.mpeg-tts](https://www.iana.org/assignments/media-types/video/vnd.directv.mpeg-tts) |
`video/vnd.dlna.mpeg-tts` | [video/vnd.dlna.mpeg-tts](https://www.iana.org/assignments/media-types/video/vnd.dlna.mpeg-tts) |
`video/vnd.dvb.file` | [video/vnd.dvb.file](https://www.iana.org/assignments/media-types/video/vnd.dvb.file) |
`video/vnd.fvt` | [video/vnd.fvt](https://www.iana.org/assignments/media-types/video/vnd.fvt) |
`video/vnd.hns.video` | [video/vnd.hns.video](https://www.iana.org/assignments/media-types/video/vnd.hns.video) |
`video/vnd.iptvforum.1dparityfec-1010` | [video/vnd.iptvforum.1dparityfec-1010](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.1dparityfec-1010) |
`video/vnd.iptvforum.1dparityfec-2005` | [video/vnd.iptvforum.1dparityfec-2005](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.1dparityfec-2005) |
`video/vnd.iptvforum.2dparityfec-1010` | [video/vnd.iptvforum.2dparityfec-1010](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.2dparityfec-1010) |
`video/vnd.iptvforum.2dparityfec-2005` | [video/vnd.iptvforum.2dparityfec-2005](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.2dparityfec-2005) |
`video/vnd.iptvforum.ttsavc` | [video/vnd.iptvforum.ttsavc](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.ttsavc) |
`video/vnd.iptvforum.ttsmpeg2` | [video/vnd.iptvforum.ttsmpeg2](https://www.iana.org/assignments/media-types/video/vnd.iptvforum.ttsmpeg2) |
`video/vnd.motorola.video` | [video/vnd.motorola.video](https://www.iana.org/assignments/media-types/video/vnd.motorola.video) |
`video/vnd.motorola.videop` | [video/vnd.motorola.videop](https://www.iana.org/assignments/media-types/video/vnd.motorola.videop) |
`video/vnd.mpegurl` | [video/vnd-mpegurl](https://www.iana.org/assignments/media-types/video/vnd-mpegurl) |
`video/vnd.ms-playready.media.pyv` | [video/vnd.ms-playready.media.pyv](https://www.iana.org/assignments/media-types/video/vnd.ms-playready.media.pyv) |
`video/vnd.nokia.interleaved-multimedia` | [video/vnd.nokia.interleaved-multimedia](https://www.iana.org/assignments/media-types/video/vnd.nokia.interleaved-multimedia) |
`video/vnd.nokia.videovoip` | [video/vnd.nokia.videovoip](https://www.iana.org/assignments/media-types/video/vnd.nokia.videovoip) |
`video/vnd.objectvideo` | [video/vnd.objectvideo](https://www.iana.org/assignments/media-types/video/vnd.objectvideo) |
`video/vnd.radgamettools.bink` | [video/vnd.radgamettools.bink](https://www.iana.org/assignments/media-types/video/vnd.radgamettools.bink) |
`video/vnd.radgamettools.smacker` | [video/vnd.radgamettools.smacker](https://www.iana.org/assignments/media-types/video/vnd.radgamettools.smacker) |
`video/vnd.sealed.mpeg1` | [video/vnd.sealed.mpeg1](https://www.iana.org/assignments/media-types/video/vnd.sealed.mpeg1) |
`video/vnd.sealed.mpeg4` | [video/vnd.sealed.mpeg4](https://www.iana.org/assignments/media-types/video/vnd.sealed.mpeg4) |
`video/vnd.sealed.swf` | [video/vnd.sealed-swf](https://www.iana.org/assignments/media-types/video/vnd.sealed-swf) |
`video/vnd.sealedmedia.softseal.mov` | [video/vnd.sealedmedia.softseal-mov](https://www.iana.org/assignments/media-types/video/vnd.sealedmedia.softseal-mov) |
`video/vnd.uvvu.mp4` | [video/vnd.uvvu-mp4](https://www.iana.org/assignments/media-types/video/vnd.uvvu-mp4) |
`video/vnd.vivo` | [video/vnd-vivo](https://www.iana.org/assignments/media-types/video/vnd-vivo) |
`video/VP8` | [video/VP8](https://www.iana.org/assignments/media-types/video/VP8) | [RFC-ietf-payload-vp8-17](https://tools.ietf.org/html/rfc-ietf-payload-vp8-17)


## Sources

* [Media Types](https://www.iana.org/assignments/media-types/media-types.xml)
* [RFC6838 Media Type Specifications and Registration Procedures](https://tools.ietf.org/html/rfc6838).
* Yours truly
