"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceConnectionValidator = void 0;
var _error = require("../lib/error");
var _data_sources = require("../../common/data_sources");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class DataSourceConnectionValidator {
  constructor(callDataCluster, dataSourceAttr) {
    this.callDataCluster = callDataCluster;
    this.dataSourceAttr = dataSourceAttr;
  }
  async validate() {
    try {
      var _this$dataSourceAttr$, _validationResponse5;
      let validationResponse;
      // Amazon OpenSearch Serverless does not support .info() API
      if (((_this$dataSourceAttr$ = this.dataSourceAttr.auth) === null || _this$dataSourceAttr$ === void 0 || (_this$dataSourceAttr$ = _this$dataSourceAttr$.credentials) === null || _this$dataSourceAttr$ === void 0 ? void 0 : _this$dataSourceAttr$.service) === _data_sources.SigV4ServiceName.OpenSearchServerless) {
        var _validationResponse, _validationResponse2;
        validationResponse = await this.callDataCluster.cat.indices();
        if (((_validationResponse = validationResponse) === null || _validationResponse === void 0 ? void 0 : _validationResponse.statusCode) === 200 && (_validationResponse2 = validationResponse) !== null && _validationResponse2 !== void 0 && _validationResponse2.body) {
          return validationResponse;
        }
      } else {
        var _validationResponse3, _validationResponse4;
        validationResponse = await this.callDataCluster.info();
        if (((_validationResponse3 = validationResponse) === null || _validationResponse3 === void 0 ? void 0 : _validationResponse3.statusCode) === 200 && (_validationResponse4 = validationResponse) !== null && _validationResponse4 !== void 0 && (_validationResponse4 = _validationResponse4.body) !== null && _validationResponse4 !== void 0 && _validationResponse4.cluster_name) {
          return validationResponse;
        }
      }
      throw new Error(JSON.stringify((_validationResponse5 = validationResponse) === null || _validationResponse5 === void 0 ? void 0 : _validationResponse5.body));
    } catch (e) {
      throw (0, _error.createDataSourceError)(e);
    }
  }
  async fetchDataSourceVersion() {
    let dataSourceVersion = '';
    try {
      var _this$dataSourceAttr$2;
      // OpenSearch Serverless does not have version concept
      if (((_this$dataSourceAttr$2 = this.dataSourceAttr.auth) === null || _this$dataSourceAttr$2 === void 0 || (_this$dataSourceAttr$2 = _this$dataSourceAttr$2.credentials) === null || _this$dataSourceAttr$2 === void 0 ? void 0 : _this$dataSourceAttr$2.service) === _data_sources.SigV4ServiceName.OpenSearchServerless) {
        return dataSourceVersion;
      }
      await this.callDataCluster.info().then(response => response.body).then(body => {
        dataSourceVersion = body.version.number;
      });
      return dataSourceVersion;
    } catch (e) {
      // return empty dataSoyrce version instead of throwing exception in case info() api call fails
      return dataSourceVersion;
    }
  }
}
exports.DataSourceConnectionValidator = DataSourceConnectionValidator;