/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jffi.CachingNativeMemoryAllocator;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.JFFIInvoker;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.TransientNativeMemoryIO;
import org.jruby.ext.ffi.jffi.VariadicInvoker;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Factory
extends org.jruby.ext.ffi.Factory {
    public Factory() {
        if (!Platform.getPlatform().isSupported()) {
            throw new UnsatisfiedLinkError("JFFI backend not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.getClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.getClass("Invoker") == null) {
                JFFIInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.getClass("VariadicInvoker") == null) {
                VariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            if (ffi2.getClass("Callback") == null) {
                CallbackManager.createCallbackClass(runtime2, ffi2);
            }
            if (ffi2.getClass("Function") == null) {
                Function.createFunctionClass(runtime2, ffi2);
            }
            if (ffi2.getClass("LastError") == null) {
                ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(LastError.class);
                if (org.jruby.platform.Platform.IS_WINDOWS) {
                    ffi2.defineModuleUnder("LastError").defineAnnotatedMethods(WinapiLastError.class);
                }
            }
        }
        runtime2.setFFI(new FFI(ffi2));
    }

    @Override
    public MemoryIO allocateDirectMemory(Ruby runtime2, int size2, boolean clear2) {
        return CachingNativeMemoryAllocator.allocateAligned(runtime2, size2, 8, clear2);
    }

    @Override
    public MemoryIO allocateDirectMemory(Ruby runtime2, int size2, int align, boolean clear2) {
        return CachingNativeMemoryAllocator.allocateAligned(runtime2, size2, align, clear2);
    }

    @Override
    public MemoryIO allocateTransientDirectMemory(Ruby runtime2, int size2, int align, boolean clear2) {
        return TransientNativeMemoryIO.allocateAligned(runtime2, size2, align, clear2);
    }

    @Override
    public MemoryIO wrapDirectMemory(Ruby runtime2, long address2) {
        return NativeMemoryIO.wrap(runtime2, address2);
    }

    @Override
    public Function newFunction(Ruby runtime2, Pointer address2, CallbackInfo cbInfo) {
        CodeMemoryIO mem = new CodeMemoryIO(runtime2, address2);
        RubyClass klass = runtime2.getModule("FFI").getClass("Function");
        return new Function(runtime2, klass, mem, cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, null, false);
    }

    @Override
    public CallbackManager getCallbackManager() {
        return CallbackManager.getInstance();
    }

    private static final Type getType(NativeType type2) {
        Type jffiType = FFIUtil.getFFIType(type2);
        if (jffiType == null) {
            throw new UnsupportedOperationException("Cannot determine native type for " + (Object)((Object)type2));
        }
        return jffiType;
    }

    @Override
    public int sizeOf(NativeType type2) {
        return Factory.getType(type2).size();
    }

    @Override
    public int alignmentOf(NativeType type2) {
        return Factory.getType(type2).alignment();
    }

    public static final class WinapiLastError {
        @JRubyMethod(name={"winapi_error"}, module=true)
        public static final IRubyObject winapi_error(ThreadContext context, IRubyObject recv2) {
            return LastError.error(context, recv2);
        }

        @JRubyMethod(name={"winapi_error="}, module=true)
        public static final IRubyObject winapi_error_set(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
            return LastError.error_set(context, recv2, value2);
        }
    }

    public static final class LastError {
        @JRubyMethod(name={"error"}, module=true)
        public static final IRubyObject error(ThreadContext context, IRubyObject recv2) {
            return context.runtime.newFixnum(com.kenai.jffi.LastError.getInstance().get());
        }

        @JRubyMethod(name={"error="}, module=true)
        public static final IRubyObject error_set(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
            com.kenai.jffi.LastError.getInstance().set((int)value2.convertToInteger().getLongValue());
            return value2;
        }
    }
}

