/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.alerts;

import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 `2\u00020\u0001:\u0001`B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J-\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\n\b\u0002\u00100\u001a\u0004\u0018\u00010.H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0011\u00102\u001a\u00020)H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0019\u00102\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u00107\u001a\u00020)H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0019\u00107\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u00108\u001a\u00020)H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0019\u00108\u001a\u00020)2\u0006\u00104\u001a\u000205H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0016\u00109\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020.0;H\u0002J\u0016\u0010<\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020.0;H\u0002J\u0018\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020.H\u0002J\b\u0010@\u001a\u00020.H\u0002J*\u0010A\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020\fH\u0002J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020.0;2\u0006\u0010H\u001a\u00020IH\u0002J\u0006\u0010J\u001a\u00020\fJ\u0006\u0010K\u001a\u00020\fJ\u000e\u0010K\u001a\u00020\f2\u0006\u00104\u001a\u000205J\u0006\u0010L\u001a\u00020\fJ\u0006\u0010M\u001a\u00020)J\u0006\u0010N\u001a\u00020)J\b\u0010O\u001a\u00020)H\u0002J\b\u0010P\u001a\u00020)H\u0002J\b\u0010Q\u001a\u00020)H\u0002J\b\u0010R\u001a\u00020)H\u0002J\b\u0010S\u001a\u00020)H\u0002J\b\u0010T\u001a\u00020)H\u0002J@\u0010U\u001a\u00020)2\u0006\u0010V\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010W\u001a\u00020.2\u0006\u0010X\u001a\u00020.2\u0006\u0010Y\u001a\u00020\u00132\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010E\u001a\u00020.H\u0002J\u0018\u0010[\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010\\\u001a\u00020.H\u0002J+\u0010]\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010^\u001a\u00020.2\b\b\u0002\u00100\u001a\u00020\fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \r*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u0015\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n \r*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u001c\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010$\u001a\n \r*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006a"}, d2={"Lorg/opensearch/alerting/alerts/AlertIndices;", "Lorg/opensearch/cluster/ClusterStateListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;)V", "alertHistoryEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "alertHistoryIndexInitialized", "alertHistoryMaxAge", "Lorg/opensearch/common/unit/TimeValue;", "alertHistoryMaxDocs", "", "Ljava/lang/Long;", "alertHistoryRetentionPeriod", "alertHistoryRolloverPeriod", "alertIndexInitialized", "findingHistoryEnabled", "findingHistoryIndexInitialized", "findingHistoryMaxAge", "findingHistoryMaxDocs", "findingHistoryRetentionPeriod", "findingHistoryRolloverPeriod", "isClusterManager", "lastRolloverTime", "getLastRolloverTime", "()Lorg/opensearch/common/unit/TimeValue;", "setLastRolloverTime", "(Lorg/opensearch/common/unit/TimeValue;)V", "requestTimeout", "scheduledAlertRollover", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "scheduledFindingRollover", "clusterChanged", "", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "createIndex", "index", "", "schemaMapping", "alias", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateAlertIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dataSources", "Lorg/opensearch/commons/alerting/model/DataSources;", "(Lorg/opensearch/commons/alerting/model/DataSources;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateInitialAlertHistoryIndex", "createOrUpdateInitialFindingHistoryIndex", "deleteAllOldHistoryIndices", "indicesToDelete", "", "deleteOldHistoryIndex", "deleteOldIndices", "tag", "indices", "executorName", "getHistoryIndexToDelete", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "retentionPeriodMillis", "writeIndex", "historyEnabled", "getIndicesToDelete", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "isAlertHistoryEnabled", "isAlertInitialized", "isFindingHistoryEnabled", "offMaster", "onMaster", "rescheduleAlertRollover", "rescheduleFindingRollover", "rolloverAlertHistoryIndex", "rolloverAndDeleteAlertHistoryIndices", "rolloverAndDeleteFindingHistoryIndices", "rolloverFindingHistoryIndex", "rolloverIndex", "initialized", "pattern", "map", "docsCondition", "ageCondition", "setIndexUpdateFlag", "targetIndex", "updateIndexMapping", "mapping", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nAlertIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertIndices.kt\norg/opensearch/alerting/alerts/AlertIndices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,589:1\n1#2:590\n288#3,2:591\n37#4,2:593\n37#4,2:595\n*S KotlinDebug\n*F\n+ 1 AlertIndices.kt\norg/opensearch/alerting/alerts/AlertIndices\n*L\n526#1:591,2\n547#1:593,2\n570#1:595,2\n*E\n"})
public final class AlertIndices
implements ClusterStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean alertHistoryEnabled;
    private volatile Boolean findingHistoryEnabled;
    private volatile Long alertHistoryMaxDocs;
    private volatile Long findingHistoryMaxDocs;
    private volatile TimeValue alertHistoryMaxAge;
    private volatile TimeValue findingHistoryMaxAge;
    private volatile TimeValue alertHistoryRolloverPeriod;
    private volatile TimeValue findingHistoryRolloverPeriod;
    private volatile TimeValue alertHistoryRetentionPeriod;
    private volatile TimeValue findingHistoryRetentionPeriod;
    private volatile TimeValue requestTimeout;
    private volatile boolean isClusterManager;
    @Nullable
    private TimeValue lastRolloverTime;
    private boolean alertHistoryIndexInitialized;
    private boolean findingHistoryIndexInitialized;
    private boolean alertIndexInitialized;
    @Nullable
    private Scheduler.Cancellable scheduledAlertRollover;
    @Nullable
    private Scheduler.Cancellable scheduledFindingRollover;
    @NotNull
    public static final String ALERT_INDEX = ".opendistro-alerting-alerts";
    @NotNull
    public static final String ALERT_HISTORY_WRITE_INDEX = ".opendistro-alerting-alert-history-write";
    @NotNull
    public static final String FINDING_HISTORY_WRITE_INDEX = ".opensearch-alerting-finding-history-write";
    @NotNull
    public static final String ALERT_HISTORY_ALL = ".opendistro-alerting-alert-history*";
    @NotNull
    public static final String FINDING_HISTORY_ALL = ".opensearch-alerting-finding-history*";
    @NotNull
    public static final String ALERT_HISTORY_INDEX_PATTERN = "<.opendistro-alerting-alert-history-{now/d}-1>";
    @NotNull
    public static final String FINDING_HISTORY_INDEX_PATTERN = "<.opensearch-alerting-finding-history-{now/d}-1>";
    @NotNull
    public static final String ALL_ALERT_INDEX_PATTERN = ".opendistro-alerting-alert*";
    @NotNull
    public static final String ALL_FINDING_INDEX_PATTERN = ".opensearch-alerting-finding*";
    private static final Logger logger = LogManager.getLogger(AlertIndices.class);

    public AlertIndices(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ENABLED(), arg_0 -> AlertIndices._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), arg_0 -> AlertIndices._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), arg_0 -> AlertIndices._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), arg_0 -> AlertIndices._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), arg_0 -> AlertIndices._init_$lambda$4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> AlertIndices._init_$lambda$5(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFINDING_HISTORY_ENABLED(), arg_0 -> AlertIndices._init_$lambda$6(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFINDING_HISTORY_MAX_DOCS(), arg_0 -> AlertIndices._init_$lambda$7(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFINDING_HISTORY_INDEX_MAX_AGE(), arg_0 -> AlertIndices._init_$lambda$8(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFINDING_HISTORY_ROLLOVER_PERIOD(), arg_0 -> AlertIndices._init_$lambda$9(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFINDING_HISTORY_RETENTION_PERIOD(), arg_0 -> AlertIndices._init_$lambda$10(this, arg_0));
        this.alertHistoryEnabled = (Boolean)AlertingSettings.Companion.getALERT_HISTORY_ENABLED().get(settings);
        this.findingHistoryEnabled = (Boolean)AlertingSettings.Companion.getFINDING_HISTORY_ENABLED().get(settings);
        this.alertHistoryMaxDocs = (Long)AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS().get(settings);
        this.findingHistoryMaxDocs = (Long)AlertingSettings.Companion.getFINDING_HISTORY_MAX_DOCS().get(settings);
        this.alertHistoryMaxAge = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE().get(settings);
        this.findingHistoryMaxAge = (TimeValue)AlertingSettings.Companion.getFINDING_HISTORY_INDEX_MAX_AGE().get(settings);
        this.alertHistoryRolloverPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.findingHistoryRolloverPeriod = (TimeValue)AlertingSettings.Companion.getFINDING_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.alertHistoryRetentionPeriod = (TimeValue)AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD().get(settings);
        this.findingHistoryRetentionPeriod = (TimeValue)AlertingSettings.Companion.getFINDING_HISTORY_RETENTION_PERIOD().get(settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(settings);
    }

    @Nullable
    public final TimeValue getLastRolloverTime() {
        return this.lastRolloverTime;
    }

    public final void setLastRolloverTime(@Nullable TimeValue timeValue) {
        this.lastRolloverTime = timeValue;
    }

    public final void onMaster() {
        try {
            this.rolloverAlertHistoryIndex();
            this.rolloverFindingHistoryIndex();
            this.scheduledAlertRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.onMaster$lambda$11(this), this.alertHistoryRolloverPeriod, this.executorName());
            this.scheduledFindingRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.onMaster$lambda$12(this), this.findingHistoryRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error creating alert/finding indices. Alerts/Findings can't be recorded until master node is restarted.", (Throwable)e);
        }
    }

    public final void offMaster() {
        block1: {
            Scheduler.Cancellable cancellable = this.scheduledAlertRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            Scheduler.Cancellable cancellable2 = this.scheduledFindingRollover;
            if (cancellable2 == null) break block1;
            cancellable2.cancel();
        }
    }

    private final String executorName() {
        return "management";
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        this.alertIndexInitialized = event.state().routingTable().hasIndex(ALERT_INDEX);
        this.alertHistoryIndexInitialized = event.state().metadata().hasAlias(ALERT_HISTORY_WRITE_INDEX);
        this.findingHistoryIndexInitialized = event.state().metadata().hasAlias(FINDING_HISTORY_WRITE_INDEX);
    }

    private final void rescheduleAlertRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedMaster()) {
            Scheduler.Cancellable cancellable = this.scheduledAlertRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledAlertRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.rescheduleAlertRollover$lambda$13(this), this.alertHistoryRolloverPeriod, this.executorName());
        }
    }

    private final void rescheduleFindingRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedMaster()) {
            Scheduler.Cancellable cancellable = this.scheduledFindingRollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledFindingRollover = this.threadPool.scheduleWithFixedDelay(() -> AlertIndices.rescheduleFindingRollover$lambda$14(this), this.findingHistoryRolloverPeriod, this.executorName());
        }
    }

    public final boolean isAlertInitialized() {
        return this.alertIndexInitialized && this.alertHistoryIndexInitialized;
    }

    public final boolean isAlertInitialized(@NotNull DataSources dataSources) {
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        String alertsIndex = dataSources.getAlertsIndex();
        String alertsHistoryIndex = dataSources.getAlertsHistoryIndex();
        if (Intrinsics.areEqual((Object)alertsIndex, (Object)ALERT_INDEX) && Intrinsics.areEqual((Object)alertsHistoryIndex, (Object)ALERT_HISTORY_WRITE_INDEX)) {
            return this.alertIndexInitialized && this.alertHistoryIndexInitialized;
        }
        return this.clusterService.state().getMetadata().getIndices().containsKey(alertsIndex) && this.clusterService.state().getMetadata().hasAlias(alertsHistoryIndex);
    }

    public final boolean isAlertHistoryEnabled() {
        Boolean bl = this.alertHistoryEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"alertHistoryEnabled");
        return bl;
    }

    public final boolean isFindingHistoryEnabled() {
        Boolean bl = this.findingHistoryEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"findingHistoryEnabled");
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateAlertIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createOrUpdateAlertIndex.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateAlertIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = AlertIndices.createIndex$default(this, ".opendistro-alerting-alerts", AlertIndices.Companion.alertMapping(), null, (Continuation)$continuation, 4, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var2_5.alertIndexInitialized = (Boolean)v0;
                if (this.alertIndexInitialized) {
                    IndexUtils.Companion.alertIndexUpdated();
                }
                ** GOTO lbl42
            }
        }
        if (!IndexUtils.Companion.getAlertIndexUpdated()) {
            $continuation.L$0 = this;
            $continuation.label = 2;
            v1 = AlertIndices.updateIndexMapping$default(this, ".opendistro-alerting-alerts", AlertIndices.Companion.alertMapping(), false, (Continuation)$continuation, 4, null);
            if (v1 == var5_4) {
                return var5_4;
            }
        }
        ** GOTO lbl42
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateAlertIndex(@NotNull DataSources var1_1, @NotNull Continuation<? super Unit> var2_2) {
        block11: {
            if (!(var2_2 instanceof createOrUpdateAlertIndex.2)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AlertIndices this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createOrUpdateAlertIndex(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!Intrinsics.areEqual((Object)dataSources.getAlertsIndex(), (Object)".opendistro-alerting-alerts")) break;
                    $continuation.label = 1;
                    v0 = this.createOrUpdateAlertIndex((Continuation<? super Unit>)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl21
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl21:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            alertsIndex = dataSources.getAlertsIndex();
            if (this.clusterService.state().routingTable().hasIndex(alertsIndex)) break block11;
            var4_7 = this;
            v1 = alertsIndex;
            Intrinsics.checkNotNull((Object)v1);
            $continuation.L$0 = var4_7;
            $continuation.label = 2;
            v2 = AlertIndices.createIndex$default(this, v1, AlertIndices.Companion.alertMapping(), null, (Continuation)$continuation, 4, null);
            if (v2 == var7_5) {
                return var7_5;
            }
            ** GOTO lbl37
            {
                case 2: {
                    var4_7 = (AlertIndices)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl37:
                    // 2 sources

                    var4_7.alertIndexInitialized = (Boolean)v2;
                    break;
                }
            }
        }
        v3 = alertsIndex;
        Intrinsics.checkNotNull((Object)v3);
        $continuation.label = 3;
        v4 = AlertIndices.updateIndexMapping$default(this, v3, AlertIndices.Companion.alertMapping(), false, (Continuation)$continuation, 4, null);
        if (v4 == var7_5) {
            return var7_5;
        }
        ** GOTO lbl50
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl50:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object createOrUpdateInitialAlertHistoryIndex(@NotNull DataSources dataSources, @NotNull Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual((Object)dataSources.getAlertsIndex(), (Object)ALERT_INDEX)) {
            Object object = this.createOrUpdateInitialAlertHistoryIndex($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (!this.clusterService.state().getMetadata().hasAlias(dataSources.getAlertsHistoryIndex())) {
            String string = dataSources.getAlertsHistoryIndexPattern();
            if (string == null) {
                string = ALERT_HISTORY_INDEX_PATTERN;
            }
            Object object = this.createIndex(string, Companion.alertMapping(), dataSources.getAlertsHistoryIndex(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        String string = dataSources.getAlertsHistoryIndex();
        if (string == null) {
            string = ALERT_HISTORY_WRITE_INDEX;
        }
        Object object = this.updateIndexMapping(string, Companion.alertMapping(), true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialAlertHistoryIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createOrUpdateInitialAlertHistoryIndex.2)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialAlertHistoryIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertHistoryIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opendistro-alerting-alert-history-{now/d}-1>", AlertIndices.Companion.alertMapping(), ".opendistro-alerting-alert-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var2_5.alertHistoryIndexInitialized = (Boolean)v0;
                if (this.alertHistoryIndexInitialized) {
                    v1 = this.clusterService.state();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"clusterService.state()");
                    IndexUtils.Companion.setLastUpdatedAlertHistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(v1, ".opendistro-alerting-alert-history-write"));
                }
                ** GOTO lbl43
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v2 = this.updateIndexMapping(".opendistro-alerting-alert-history-write", AlertIndices.Companion.alertMapping(), true, (Continuation<? super Unit>)$continuation);
        if (v2 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl43
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialFindingHistoryIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof createOrUpdateInitialFindingHistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialFindingHistoryIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.findingHistoryIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opensearch-alerting-finding-history-{now/d}-1>", AlertIndices.Companion.findingMapping(), ".opensearch-alerting-finding-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_5 = (AlertIndices)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var2_5.findingHistoryIndexInitialized = (Boolean)v0;
                if (this.findingHistoryIndexInitialized) {
                    v1 = this.clusterService.state();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"clusterService.state()");
                    IndexUtils.Companion.setLastUpdatedFindingHistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(v1, ".opensearch-alerting-finding-history-write"));
                }
                ** GOTO lbl43
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 2;
        v2 = this.updateIndexMapping(".opensearch-alerting-finding-history-write", AlertIndices.Companion.findingMapping(), true, (Continuation<? super Unit>)$continuation);
        if (v2 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl43
        {
            case 2: {
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object createOrUpdateInitialFindingHistoryIndex(@NotNull DataSources dataSources, @NotNull Continuation<? super Unit> $completion) {
        String findingsIndexPattern;
        if (Intrinsics.areEqual((Object)dataSources.getFindingsIndex(), (Object)FINDING_HISTORY_WRITE_INDEX)) {
            Object object = this.createOrUpdateInitialFindingHistoryIndex($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        String findingsIndex = dataSources.getFindingsIndex();
        String string = dataSources.getFindingsIndexPattern();
        if (string == null) {
            string = findingsIndexPattern = FINDING_HISTORY_INDEX_PATTERN;
        }
        if (!this.clusterService.state().metadata().hasAlias(findingsIndex)) {
            Object object = this.createIndex(findingsIndexPattern, Companion.findingMapping(), findingsIndex, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.updateIndexMapping(findingsIndex, Companion.findingMapping(), true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object createIndex(String var1_1, String var2_2, String var3_3, Continuation<? super Boolean> var4_4) {
        if (!(var4_4 instanceof createIndex.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertIndices.access$createIndex(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = schemaMapping;
                $continuation.L$3 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<IndicesExistsResponse>, Unit>(index){
                    final /* synthetic */ String $index;
                    {
                        this.$index = $index;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesExistsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String[] stringArray = new String[]{this.$index};
                        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                alias = (String)$continuation.L$3;
                schemaMapping = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                request = new CreateIndexRequest(index).mapping(schemaMapping).settings(Settings.builder().put("index.hidden", true).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.create(this.$request, it);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var11_7) goto lbl44
lbl43:
                // 1 sources

                return var11_7;
lbl44:
                // 1 sources

                ** GOTO lbl50
            }
            case 2: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl50:
                    // 2 sources

                    createIndexResponse = (CreateIndexResponse)v1;
                    var7_11 = createIndexResponse.isAcknowledged();
                }
                catch (Exception t) {
                    if (!(ExceptionsHelper.unwrapCause((Throwable)t) instanceof ResourceAlreadyExistsException)) {
                        throw AlertingException.Companion.wrap(t);
                    }
                    var7_11 = true;
                }
                return Boxing.boxBoolean((boolean)(var7_11 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createIndex$default(AlertIndices alertIndices, String string, String string2, String string3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return alertIndices.createIndex(string, string2, string3, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateIndexMapping(String var1_1, String var2_2, boolean var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof updateIndexMapping.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AlertIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertIndices.access$updateIndexMapping(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                clusterState = this.clusterService.state();
                targetIndex = index;
                if (alias != false) {
                    Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterState");
                    targetIndex = IndexUtils.Companion.getIndexNameWithAlias(clusterState, index);
                }
                if (Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedAlertHistoryIndex()) || Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedFindingHistoryIndex())) {
                    return Unit.INSTANCE;
                }
                var9_10 = new String[]{targetIndex};
                var8_11 = new PutMappingRequest(var9_10).source((String)mapping, (MediaType)XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)var8_11, (String)"PutMappingRequest(target\u2026pping, XContentType.JSON)");
                putMappingRequest = var8_11;
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.L$2 = targetIndex;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)((Function2)new Function2<IndicesAdminClient, ActionListener<AcknowledgedResponse>, Unit>(putMappingRequest){
                    final /* synthetic */ PutMappingRequest $putMappingRequest;
                    {
                        this.$putMappingRequest = $putMappingRequest;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<AcknowledgedResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.putMapping(this.$putMappingRequest, it);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl37
            }
            case 1: {
                targetIndex = (String)$continuation.L$2;
                index = (String)$continuation.L$1;
                this = (AlertIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                if ((updateResponse = (AcknowledgedResponse)v0).isAcknowledged()) {
                    AlertIndices.logger.info("Index mapping of " + targetIndex + " is updated");
                    this.setIndexUpdateFlag(index, targetIndex);
                } else {
                    AlertIndices.logger.info("Failed to update index mapping of " + targetIndex);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object updateIndexMapping$default(AlertIndices alertIndices, String string, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return alertIndices.updateIndexMapping(string, string2, bl, (Continuation<? super Unit>)continuation);
    }

    private final void setIndexUpdateFlag(String index, String targetIndex) {
        switch (index) {
            case ".opendistro-alerting-alerts": {
                IndexUtils.Companion.alertIndexUpdated();
                break;
            }
            case ".opendistro-alerting-alert-history-write": {
                IndexUtils.Companion.setLastUpdatedAlertHistoryIndex(targetIndex);
                break;
            }
            case ".opensearch-alerting-finding-history-write": {
                IndexUtils.Companion.setLastUpdatedFindingHistoryIndex(targetIndex);
            }
        }
    }

    private final void rolloverAndDeleteAlertHistoryIndices() {
        Boolean bl = this.alertHistoryEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"alertHistoryEnabled");
        if (bl.booleanValue()) {
            this.rolloverAlertHistoryIndex();
        }
        this.deleteOldIndices("History", ALERT_HISTORY_ALL);
    }

    private final void rolloverAndDeleteFindingHistoryIndices() {
        Boolean bl = this.findingHistoryEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"findingHistoryEnabled");
        if (bl.booleanValue()) {
            this.rolloverFindingHistoryIndex();
        }
        this.deleteOldIndices("Finding", FINDING_HISTORY_ALL);
    }

    private final void rolloverIndex(boolean initialized, String index, String pattern, String map, long docsCondition, TimeValue ageCondition, String writeIndex) {
        if (!initialized) {
            return;
        }
        RolloverRequest request = new RolloverRequest(index, null);
        request.getCreateIndexRequest().index(pattern).mapping(map).settings(Settings.builder().put("index.hidden", true).build());
        request.addMaxIndexDocsCondition(docsCondition);
        request.addMaxIndexAgeCondition(ageCondition);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(writeIndex, this){
            final /* synthetic */ String $writeIndex;
            final /* synthetic */ AlertIndices this$0;
            {
                this.$writeIndex = $writeIndex;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull RolloverResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isRolledOver()) {
                    AlertIndices.access$getLogger$cp().info(this.$writeIndex + " not rolled over. Conditions were: " + response2.getConditionStatus());
                } else {
                    this.this$0.setLastRolloverTime(TimeValue.timeValueMillis((long)AlertIndices.access$getThreadPool$p(this.this$0).absoluteTimeInMillis()));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertIndices.access$getLogger$cp().error(this.$writeIndex + " not roll over failed.");
            }
        });
    }

    private final void rolloverAlertHistoryIndex() {
        String string = Companion.alertMapping();
        Long l = this.alertHistoryMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"alertHistoryMaxDocs");
        long l2 = ((Number)l).longValue();
        TimeValue timeValue = this.alertHistoryMaxAge;
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"alertHistoryMaxAge");
        this.rolloverIndex(this.alertHistoryIndexInitialized, ALERT_HISTORY_WRITE_INDEX, ALERT_HISTORY_INDEX_PATTERN, string, l2, timeValue, ALERT_HISTORY_WRITE_INDEX);
    }

    private final void rolloverFindingHistoryIndex() {
        String string = Companion.findingMapping();
        Long l = this.findingHistoryMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"findingHistoryMaxDocs");
        long l2 = ((Number)l).longValue();
        TimeValue timeValue = this.findingHistoryMaxAge;
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"findingHistoryMaxAge");
        this.rolloverIndex(this.findingHistoryIndexInitialized, FINDING_HISTORY_WRITE_INDEX, FINDING_HISTORY_INDEX_PATTERN, string, l2, timeValue, FINDING_HISTORY_WRITE_INDEX);
    }

    private final void deleteOldIndices(String tag, String indices2) {
        logger.error("info deleteOldIndices");
        String[] stringArray = new String[]{indices2};
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(stringArray).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(this, tag){
            final /* synthetic */ AlertIndices this$0;
            final /* synthetic */ String $tag;
            {
                this.this$0 = $receiver;
                this.$tag = $tag;
            }

            public void onResponse(@NotNull ClusterStateResponse clusterStateResponse) {
                Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
                Map map = clusterStateResponse.getState().getMetadata().getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"clusterStateResponse.state.metadata.indices");
                if (!map.isEmpty()) {
                    List indicesToDelete = AlertIndices.access$getIndicesToDelete(this.this$0, clusterStateResponse);
                    AlertIndices.access$getLogger$cp().info("Deleting old " + this.$tag + " indices viz " + indicesToDelete);
                    AlertIndices.access$deleteAllOldHistoryIndices(this.this$0, indicesToDelete);
                } else {
                    AlertIndices.access$getLogger$cp().info("No Old " + this.$tag + " Indices to delete");
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertIndices.access$getLogger$cp().error("Error fetching cluster state");
            }
        });
    }

    private final List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        List indicesToDelete = new ArrayList();
        Map map = clusterStateResponse.getState().getMetadata().getIndices();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"clusterStateResponse.state.metadata.indices");
        for (Map.Entry entry : map.entrySet()) {
            String it;
            IndexMetadata indexMetaData = (IndexMetadata)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)indexMetaData, (String)"indexMetaData");
            long l = this.alertHistoryRetentionPeriod.getMillis();
            Boolean bl = this.alertHistoryEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"alertHistoryEnabled");
            String string = this.getHistoryIndexToDelete(indexMetaData, l, ALERT_HISTORY_WRITE_INDEX, bl);
            if (string != null) {
                it = string;
                boolean bl2 = false;
                indicesToDelete.add(it);
            }
            long l2 = this.findingHistoryRetentionPeriod.getMillis();
            Boolean bl3 = this.findingHistoryEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"findingHistoryEnabled");
            string = this.getHistoryIndexToDelete(indexMetaData, l2, FINDING_HISTORY_WRITE_INDEX, bl3);
            if (string == null) continue;
            it = string;
            boolean bl4 = false;
            indicesToDelete.add(it);
        }
        return indicesToDelete;
    }

    private final String getHistoryIndexToDelete(IndexMetadata indexMetadata, long retentionPeriodMillis, String writeIndex, boolean historyEnabled) {
        long creationTime = indexMetadata.getCreationDate();
        if (Instant.now().toEpochMilli() - creationTime > retentionPeriodMillis) {
            Object v0;
            block7: {
                Iterable $this$firstOrNull$iv = indexMetadata.getAliases().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)writeIndex, (Object)((AliasMetadata)it.getValue()).getAlias())) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            Map.Entry alias = v0;
            if (alias != null) {
                if (historyEnabled) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)writeIndex, (Object)ALERT_HISTORY_WRITE_INDEX)) {
                    this.alertHistoryIndexInitialized = false;
                } else if (Intrinsics.areEqual((Object)writeIndex, (Object)FINDING_HISTORY_WRITE_INDEX)) {
                    this.findingHistoryIndexInitialized = false;
                }
            }
            return indexMetadata.getIndex().getName();
        }
        return null;
    }

    private final void deleteAllOldHistoryIndices(List<String> indicesToDelete) {
        if (!((Collection)indicesToDelete).isEmpty()) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(indicesToDelete, this){
                final /* synthetic */ List<String> $indicesToDelete;
                final /* synthetic */ AlertIndices this$0;
                {
                    this.$indicesToDelete = $indicesToDelete;
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull AcknowledgedResponse deleteIndicesResponse) {
                    Intrinsics.checkNotNullParameter((Object)deleteIndicesResponse, (String)"deleteIndicesResponse");
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        AlertIndices.access$getLogger$cp().error("Could not delete one or more Alerting/Finding history indices: " + this.$indicesToDelete + ". Retrying one by one.");
                        AlertIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertIndices.access$getLogger$cp().error("Delete for Alerting/Finding History Indices " + this.$indicesToDelete + " Failed. Retrying one By one.");
                    AlertIndices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                }
            });
        }
    }

    private final void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (String index : indicesToDelete) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(index){
                final /* synthetic */ String $index;
                {
                    this.$index = $index;
                }

                public void onResponse(@Nullable AcknowledgedResponse acknowledgedResponse2) {
                    if (acknowledgedResponse2 != null && !acknowledgedResponse2.isAcknowledged()) {
                        AlertIndices.access$getLogger$cp().error("Could not delete one or more Alerting/Finding history indices: " + this.$index);
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertIndices.access$getLogger$cp().debug("Exception " + e.getMessage() + " while deleting the index " + this.$index);
                }
            });
        }
    }

    private static final void _init_$lambda$0(AlertIndices this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertHistoryEnabled = it;
    }

    private static final void _init_$lambda$1(AlertIndices this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertHistoryMaxDocs = it;
    }

    private static final void _init_$lambda$2(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertHistoryMaxAge = it;
    }

    private static final void _init_$lambda$3(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertHistoryRolloverPeriod = it;
        this$0.rescheduleAlertRollover();
    }

    private static final void _init_$lambda$4(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertHistoryRetentionPeriod = it;
    }

    private static final void _init_$lambda$5(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void _init_$lambda$6(AlertIndices this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findingHistoryEnabled = it;
    }

    private static final void _init_$lambda$7(AlertIndices this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findingHistoryMaxDocs = it;
    }

    private static final void _init_$lambda$8(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findingHistoryMaxAge = it;
    }

    private static final void _init_$lambda$9(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findingHistoryRolloverPeriod = it;
        this$0.rescheduleFindingRollover();
    }

    private static final void _init_$lambda$10(AlertIndices this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findingHistoryRetentionPeriod = it;
    }

    private static final void onMaster$lambda$11(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteAlertHistoryIndices();
    }

    private static final void onMaster$lambda$12(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteFindingHistoryIndices();
    }

    private static final void rescheduleAlertRollover$lambda$13(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteAlertHistoryIndices();
    }

    private static final void rescheduleFindingRollover$lambda$14(AlertIndices this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.rolloverAndDeleteFindingHistoryIndices();
    }

    @JvmStatic
    @NotNull
    public static final String alertMapping() {
        return Companion.alertMapping();
    }

    @JvmStatic
    @NotNull
    public static final String findingMapping() {
        return Companion.findingMapping();
    }

    public static final /* synthetic */ Object access$createIndex(AlertIndices $this, String index, String schemaMapping, String alias, Continuation $completion) {
        return $this.createIndex(index, schemaMapping, alias, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$updateIndexMapping(AlertIndices $this, String index, String mapping, boolean alias, Continuation $completion) {
        return $this.updateIndexMapping(index, mapping, alias, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ThreadPool access$getThreadPool$p(AlertIndices $this) {
        return $this.threadPool;
    }

    public static final /* synthetic */ List access$getIndicesToDelete(AlertIndices $this, ClusterStateResponse clusterStateResponse) {
        return $this.getIndicesToDelete(clusterStateResponse);
    }

    public static final /* synthetic */ void access$deleteAllOldHistoryIndices(AlertIndices $this, List indicesToDelete) {
        $this.deleteAllOldHistoryIndices(indicesToDelete);
    }

    public static final /* synthetic */ void access$deleteOldHistoryIndex(AlertIndices $this, List indicesToDelete) {
        $this.deleteOldHistoryIndex(indicesToDelete);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/alerts/AlertIndices$Companion;", "", "()V", "ALERT_HISTORY_ALL", "", "ALERT_HISTORY_INDEX_PATTERN", "ALERT_HISTORY_WRITE_INDEX", "ALERT_INDEX", "ALL_ALERT_INDEX_PATTERN", "ALL_FINDING_INDEX_PATTERN", "FINDING_HISTORY_ALL", "FINDING_HISTORY_INDEX_PATTERN", "FINDING_HISTORY_WRITE_INDEX", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "alertMapping", "findingMapping", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String alertMapping() {
            URL uRL = AlertIndices.class.getResource("alert_mapping.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"AlertIndices::class.java\u2026rce(\"alert_mapping.json\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            return new String(byArray, charset);
        }

        @JvmStatic
        @NotNull
        public final String findingMapping() {
            URL uRL = AlertIndices.class.getResource("finding_mapping.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"AlertIndices::class.java\u2026e(\"finding_mapping.json\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            return new String(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

