"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryWorkbenchPluginCheck = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATASOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.queryWorkbenchPluginID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATASOURCE_TYPE = exports.S3_DATASOURCE_TYPE = 'S3_DATASOURCE';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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