"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestor = void 0;
var _wreck = _interopRequireDefault(require("@hapi/wreck"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const requestor = async function (requestType, url, wreckOptions) {
  const promise = _wreck.default.request(requestType, url, wreckOptions);
  const res = await promise;
  const body = await _wreck.default.read(res, wreckOptions);
  return body;
};
exports.requestor = requestor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfd3JlY2siLCJfaW50ZXJvcFJlcXVpcmVEZWZhdWx0IiwicmVxdWlyZSIsIm9iaiIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwicmVxdWVzdG9yIiwicmVxdWVzdFR5cGUiLCJ1cmwiLCJ3cmVja09wdGlvbnMiLCJwcm9taXNlIiwiV3JlY2siLCJyZXF1ZXN0IiwicmVzIiwiYm9keSIsInJlYWQiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsid3JlY2tfcmVxdWVzdHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgV3JlY2sgZnJvbSAnQGhhcGkvd3JlY2snO1xuaW1wb3J0IHsgb3B0aW9uc1R5cGUgfSBmcm9tICcuLi8uLi8uLi8uLi9jb21tb24vdHlwZXMvbm90ZWJvb2tzJztcblxuZXhwb3J0IGNvbnN0IHJlcXVlc3RvciA9IGFzeW5jIGZ1bmN0aW9uIChcbiAgcmVxdWVzdFR5cGU6IHN0cmluZyxcbiAgdXJsOiBzdHJpbmcsXG4gIHdyZWNrT3B0aW9uczogb3B0aW9uc1R5cGVcbikge1xuICBjb25zdCBwcm9taXNlID0gV3JlY2sucmVxdWVzdChyZXF1ZXN0VHlwZSwgdXJsLCB3cmVja09wdGlvbnMpO1xuICBjb25zdCByZXMgPSBhd2FpdCBwcm9taXNlO1xuICBjb25zdCBib2R5ID0gYXdhaXQgV3JlY2sucmVhZChyZXMsIHdyZWNrT3B0aW9ucyk7XG4gIHJldHVybiBib2R5O1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsTUFBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQWdDLFNBQUFELHVCQUFBRSxHQUFBLFdBQUFBLEdBQUEsSUFBQUEsR0FBQSxDQUFBQyxVQUFBLEdBQUFELEdBQUEsS0FBQUUsT0FBQSxFQUFBRixHQUFBO0FBTGhDO0FBQ0E7QUFDQTtBQUNBOztBQUtPLE1BQU1HLFNBQVMsR0FBRyxlQUFBQSxDQUN2QkMsV0FBbUIsRUFDbkJDLEdBQVcsRUFDWEMsWUFBeUIsRUFDekI7RUFDQSxNQUFNQyxPQUFPLEdBQUdDLGNBQUssQ0FBQ0MsT0FBTyxDQUFDTCxXQUFXLEVBQUVDLEdBQUcsRUFBRUMsWUFBWSxDQUFDO0VBQzdELE1BQU1JLEdBQUcsR0FBRyxNQUFNSCxPQUFPO0VBQ3pCLE1BQU1JLElBQUksR0FBRyxNQUFNSCxjQUFLLENBQUNJLElBQUksQ0FBQ0YsR0FBRyxFQUFFSixZQUFZLENBQUM7RUFDaEQsT0FBT0ssSUFBSTtBQUNiLENBQUM7QUFBQ0UsT0FBQSxDQUFBVixTQUFBLEdBQUFBLFNBQUEifQ==