/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;

public class BinaryItem
extends BasicObject {
    public Compact64bitInt length = new Compact64bitInt();
    public List<Byte> content = new ArrayList<Byte>();

    public BinaryItem() {
    }

    public BinaryItem(Collection<Byte> content) {
        this.content.addAll(content);
        this.length.setDecodedValue(this.content.size());
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        this.length.setDecodedValue(this.content.size());
        ArrayList<Byte> result = new ArrayList<Byte>();
        result.addAll(this.length.serializeToByteList());
        result.addAll(this.content);
        return result;
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.length = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.content.clear();
        for (long i = 0L; i < this.length.getDecodedValue(); ++i) {
            this.content.add(byteArray[index.getAndIncrement()]);
        }
        return index.get() - startIndex;
    }
}

