/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLPredictionAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLPredictionAction.class);
    private static final String ML_PREDICTION_ACTION = "ml_prediction_action";
    private MLModelManager modelManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLPredictionAction(MLModelManager modelManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.modelManager = modelManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_PREDICTION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_predict/{%s}/{%s}", "/_plugins/_ml", "algorithm", "model_id")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_predict", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String algorithm = request.param("algorithm");
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        Optional<FunctionName> functionName = this.modelManager.getOptionalModelFunctionName(modelId);
        if (algorithm == null && functionName.isPresent()) {
            algorithm = functionName.get().name();
        }
        if (algorithm != null) {
            MLPredictionTaskRequest mlPredictionTaskRequest = this.getRequest(modelId, algorithm, request);
            return channel -> client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)mlPredictionTaskRequest, (ActionListener)new RestToXContentListener(channel));
        }
        return channel -> {
            ActionListener listener = ActionListener.wrap(mlModel -> {
                String algoName = mlModel.getAlgorithm().name();
                client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)this.getRequest(modelId, algoName, request), (ActionListener)new RestToXContentListener(channel));
            }, e -> {
                log.error("Failed to get ML model", (Throwable)e);
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.NOT_FOUND, e));
                }
                catch (IOException ex) {
                    log.error("Failed to send error response", (Throwable)ex);
                }
            });
            try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
                this.modelManager.getModel(modelId, (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)listener, () -> context.restore()));
            }
        };
    }

    @VisibleForTesting
    MLPredictionTaskRequest getRequest(String modelId, String algorithm, RestRequest request) throws IOException {
        if (FunctionName.REMOTE.name().equals(algorithm) && !this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (FunctionName.isDLModel((FunctionName)FunctionName.from((String)algorithm.toUpperCase())) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)algorithm);
        return new MLPredictionTaskRequest(modelId, mlInput, null);
    }
}

