/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.task;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.opensearch.ml.common.MLTask;

public class MLTaskCache {
    MLTask mlTask;
    Semaphore updateTaskIndexSemaphore;
    Set<String> workerNodes;
    Map<String, String> errors;
    Integer workerNodeSize;

    public MLTaskCache(MLTask mlTask, List<String> workerNodes) {
        this.mlTask = mlTask;
        if (mlTask.isAsync()) {
            this.updateTaskIndexSemaphore = new Semaphore(1);
        }
        this.workerNodes = ConcurrentHashMap.newKeySet();
        if (workerNodes != null) {
            this.workerNodes.addAll(workerNodes);
            this.workerNodeSize = workerNodes.size();
        }
        this.errors = new ConcurrentHashMap<String, String>();
    }

    public MLTaskCache(MLTask mlTask) {
        this(mlTask, null);
    }

    public void addError(String nodeId, String error) {
        this.errors.put(nodeId, error);
    }

    public boolean hasError() {
        return this.errors.size() > 0;
    }

    public int errorNodesCount() {
        return this.errors.size();
    }

    public boolean allNodeFailed() {
        return this.workerNodeSize != null && this.errors.size() == this.workerNodeSize.intValue();
    }

    @Generated
    public static MLTaskCacheBuilder builder() {
        return new MLTaskCacheBuilder();
    }

    @Generated
    public MLTask getMlTask() {
        return this.mlTask;
    }

    @Generated
    public Semaphore getUpdateTaskIndexSemaphore() {
        return this.updateTaskIndexSemaphore;
    }

    @Generated
    public Set<String> getWorkerNodes() {
        return this.workerNodes;
    }

    @Generated
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Generated
    public Integer getWorkerNodeSize() {
        return this.workerNodeSize;
    }

    @Generated
    public static class MLTaskCacheBuilder {
        @Generated
        private MLTask mlTask;
        @Generated
        private List<String> workerNodes;

        @Generated
        MLTaskCacheBuilder() {
        }

        @Generated
        public MLTaskCacheBuilder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        @Generated
        public MLTaskCacheBuilder workerNodes(List<String> workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        @Generated
        public MLTaskCache build() {
            return new MLTaskCache(this.mlTask, this.workerNodes);
        }

        @Generated
        public String toString() {
            return "MLTaskCache.MLTaskCacheBuilder(mlTask=" + this.mlTask + ", workerNodes=" + this.workerNodes + ")";
        }
    }
}

