/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.transformer;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.Activation;
import ai.djl.nn.transformer.BertBlock;
import ai.djl.nn.transformer.BertMaskedLanguageModelBlock;
import ai.djl.nn.transformer.BertNextSentenceBlock;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.util.Arrays;

public class BertPretrainingBlock
extends AbstractBlock {
    private BertBlock bertBlock;
    private BertMaskedLanguageModelBlock mlBlock;
    private BertNextSentenceBlock nsBlock;

    public BertPretrainingBlock(BertBlock.Builder builder) {
        this.bertBlock = this.addChildBlock("Bert", builder.build());
        this.mlBlock = this.addChildBlock("BertMaskedLanguageModelBlock", new BertMaskedLanguageModelBlock(this.bertBlock, Activation::gelu));
        this.nsBlock = this.addChildBlock("BertNextSentenceBlock", new BertNextSentenceBlock());
    }

    @Override
    public void initializeChildBlocks(NDManager manager, DataType dataType, Shape ... inputShapes) {
        this.inputNames = Arrays.asList("tokenIds", "typeIds", "sequenceMasks", "maskedIndices");
        this.bertBlock.initialize(manager, dataType, inputShapes);
        Shape[] bertOutputShapes = this.bertBlock.getOutputShapes(inputShapes);
        Shape embeddedSequence = bertOutputShapes[0];
        Shape pooledOutput = bertOutputShapes[1];
        Shape maskedIndices = inputShapes[2];
        Shape embeddingTableShape = new Shape(this.bertBlock.getTokenDictionarySize(), this.bertBlock.getEmbeddingSize());
        this.mlBlock.initialize(manager, dataType, embeddedSequence, embeddingTableShape, maskedIndices);
        this.nsBlock.initialize(manager, dataType, pooledOutput);
    }

    @Override
    protected NDList forwardInternal(ParameterStore ps, NDList inputs, boolean training, PairList<String, Object> params) {
        NDArray tokenIds = (NDArray)inputs.get(0);
        NDArray typeIds = (NDArray)inputs.get(1);
        NDArray sequenceMasks = (NDArray)inputs.get(2);
        NDArray maskedIndices = (NDArray)inputs.get(3);
        try (NDManager scope = NDManager.subManagerOf(tokenIds);){
            scope.tempAttachAll(inputs);
            NDList bertResult = this.bertBlock.forward(ps, new NDList(tokenIds, typeIds, sequenceMasks), training);
            NDArray embeddedSequence = (NDArray)bertResult.get(0);
            NDArray pooledOutput = (NDArray)bertResult.get(1);
            NDArray nextSentenceProbabilities = this.nsBlock.forward(ps, new NDList(pooledOutput), training).singletonOrThrow();
            NDArray embeddingTable = this.bertBlock.getTokenEmbedding().getValue(ps, embeddedSequence.getDevice(), training);
            NDArray logProbs = this.mlBlock.forward(ps, new NDList(embeddedSequence, maskedIndices, embeddingTable), training).singletonOrThrow();
            NDList nDList = scope.ret(new NDList(nextSentenceProbabilities, logProbs));
            return nDList;
        }
    }

    @Override
    public Shape[] getOutputShapes(Shape[] inputShapes) {
        long batchSize = inputShapes[0].get(0);
        long maskedIndexCount = inputShapes[3].get(1);
        return new Shape[]{new Shape(batchSize, 2L), new Shape(batchSize, maskedIndexCount, this.bertBlock.getTokenDictionarySize())};
    }
}

