/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDList;
import ai.djl.translate.SimplePaddingStackBatchifier;
import ai.djl.translate.StackBatchifier;
import java.util.Arrays;
import java.util.stream.IntStream;

public interface Batchifier {
    public static final Batchifier STACK = new StackBatchifier();

    public static Batchifier fromString(String name) {
        switch (name) {
            case "stack": {
                return STACK;
            }
            case "padding": {
                return new SimplePaddingStackBatchifier();
            }
            case "none": {
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid batchifier name");
    }

    public NDList batchify(NDList[] var1);

    public NDList[] unbatchify(NDList var1);

    default public NDList[] split(NDList list, int numOfSlices, boolean evenSplit) {
        NDList[] unbatched = this.unbatchify(list);
        int batchSize = unbatched.length;
        numOfSlices = Math.min(numOfSlices, batchSize);
        if (evenSplit && batchSize % numOfSlices != 0) {
            throw new IllegalArgumentException("data with shape " + batchSize + " cannot be evenly split into " + numOfSlices + ". Use a batch size that's multiple of " + numOfSlices + " or set even_split=true to allow uneven partitioning of data.");
        }
        NDList[] splitted = new NDList[numOfSlices];
        Arrays.setAll(splitted, i -> new NDList());
        int step = (int)Math.ceil((double)batchSize / (double)numOfSlices);
        for (int i2 = 0; i2 < numOfSlices; ++i2) {
            NDList[] currentUnbatched = (NDList[])IntStream.range(i2 * step, Math.min((i2 + 1) * step, batchSize)).mapToObj(j -> unbatched[j]).toArray(NDList[]::new);
            splitted[i2] = this.batchify(currentUnbatched);
        }
        return splitted;
    }
}

