/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.connector.MLPostProcessFunction;
import org.opensearch.ml.common.connector.MLPreProcessFunction;
import org.opensearch.ml.common.connector.functions.preprocess.DefaultPreProcessFunction;
import org.opensearch.ml.common.connector.functions.preprocess.RemoteInferencePreProcessFunction;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.TextSimilarityInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.engine.utils.ScriptUtils;
import org.opensearch.script.ScriptService;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.regions.Region;

public class ConnectorUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(ConnectorUtils.class);
    private static final Aws4Signer signer = Aws4Signer.create();

    public static RemoteInferenceInputDataSet processInput(MLInput mlInput, Connector connector, Map<String, String> parameters, ScriptService scriptService) {
        if (mlInput == null) {
            throw new IllegalArgumentException("Input is null");
        }
        Optional predictAction = connector.findPredictAction();
        if (predictAction.isEmpty()) {
            throw new IllegalArgumentException("no predict action found");
        }
        RemoteInferenceInputDataSet inputData = ConnectorUtils.processMLInput(mlInput, connector, parameters, scriptService);
        ConnectorUtils.escapeRemoteInferenceInputData(inputData);
        return inputData;
    }

    private static RemoteInferenceInputDataSet processMLInput(MLInput mlInput, Connector connector, Map<String, String> parameters, ScriptService scriptService) {
        String preProcessFunction = ConnectorUtils.getPreprocessFunction(mlInput, connector);
        if (preProcessFunction == null) {
            if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
                return (RemoteInferenceInputDataSet)mlInput.getInputDataset();
            }
            throw new IllegalArgumentException("pre_process_function not defined in connector");
        }
        if (MLPreProcessFunction.contains((String)(preProcessFunction = ConnectorUtils.fillProcessFunctionParameter(parameters, preProcessFunction)))) {
            Function function = MLPreProcessFunction.get((String)preProcessFunction);
            return (RemoteInferenceInputDataSet)function.apply(mlInput);
        }
        if (mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
            if (parameters.containsKey("pre_process_function.process_remote_inference_input") && Boolean.parseBoolean(parameters.get("pre_process_function.process_remote_inference_input"))) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.putAll(connector.getParameters());
                params.putAll(parameters);
                RemoteInferencePreProcessFunction function = new RemoteInferencePreProcessFunction(scriptService, preProcessFunction, params);
                return function.apply(mlInput);
            }
            return (RemoteInferenceInputDataSet)mlInput.getInputDataset();
        }
        MLInput newInput = ConnectorUtils.escapeMLInput(mlInput);
        boolean convertInputToJsonString = parameters.containsKey("pre_process_function.convert_input_to_json_string") && Boolean.parseBoolean(parameters.get("pre_process_function.convert_input_to_json_string"));
        DefaultPreProcessFunction function = DefaultPreProcessFunction.builder().scriptService(scriptService).preProcessFunction(preProcessFunction).convertInputToJsonString(convertInputToJsonString).build();
        return function.apply(newInput);
    }

    private static MLInput escapeMLInput(MLInput mlInput) {
        if (mlInput.getInputDataset() instanceof TextDocsInputDataSet) {
            List docs = ((TextDocsInputDataSet)mlInput.getInputDataset()).getDocs();
            List newDocs = org.opensearch.ml.common.utils.StringUtils.processTextDocs((List)docs);
            TextDocsInputDataSet newInputData = ((TextDocsInputDataSet)mlInput.getInputDataset()).toBuilder().docs(newDocs).build();
            return mlInput.toBuilder().inputDataset((MLInputDataset)newInputData).build();
        }
        if (mlInput.getInputDataset() instanceof TextSimilarityInputDataSet) {
            String query = ((TextSimilarityInputDataSet)mlInput.getInputDataset()).getQueryText();
            String newQuery = org.opensearch.ml.common.utils.StringUtils.processTextDoc((String)query);
            List docs = ((TextSimilarityInputDataSet)mlInput.getInputDataset()).getTextDocs();
            List newDocs = org.opensearch.ml.common.utils.StringUtils.processTextDocs((List)docs);
            TextSimilarityInputDataSet newInputData = ((TextSimilarityInputDataSet)mlInput.getInputDataset()).toBuilder().queryText(newQuery).textDocs(newDocs).build();
            return mlInput.toBuilder().inputDataset((MLInputDataset)newInputData).build();
        }
        return mlInput;
    }

    public static void escapeRemoteInferenceInputData(RemoteInferenceInputDataSet inputData) {
        HashMap newParameters = new HashMap();
        if (inputData.getParameters() != null) {
            inputData.getParameters().forEach((key, value) -> {
                if (value == null) {
                    newParameters.put(key, null);
                } else if (org.opensearch.ml.common.utils.StringUtils.isJson((String)value)) {
                    newParameters.put(key, value);
                } else {
                    newParameters.put(key, StringEscapeUtils.escapeJson((String)value));
                }
            });
            inputData.setParameters(newParameters);
        }
    }

    private static String getPreprocessFunction(MLInput mlInput, Connector connector) {
        Optional predictAction = connector.findPredictAction();
        String preProcessFunction = ((ConnectorAction)predictAction.get()).getPreProcessFunction();
        if (preProcessFunction != null) {
            return preProcessFunction;
        }
        if (mlInput.getInputDataset() instanceof TextDocsInputDataSet) {
            return "connector.pre_process.default.embedding";
        }
        return null;
    }

    public static ModelTensors processOutput(String modelResponse, Connector connector, ScriptService scriptService, Map<String, String> parameters) throws IOException {
        boolean scriptReturnModelTensor;
        if (modelResponse == null) {
            throw new IllegalArgumentException("model response is null");
        }
        ArrayList modelTensors = new ArrayList();
        Optional predictAction = connector.findPredictAction();
        if (predictAction.isEmpty()) {
            throw new IllegalArgumentException("no predict action found");
        }
        ConnectorAction connectorAction = (ConnectorAction)predictAction.get();
        String postProcessFunction = connectorAction.getPostProcessFunction();
        postProcessFunction = ConnectorUtils.fillProcessFunctionParameter(parameters, postProcessFunction);
        String responseFilter = parameters.get("response_filter");
        if (MLPostProcessFunction.contains((String)postProcessFunction)) {
            if (StringUtils.isBlank((CharSequence)responseFilter)) {
                responseFilter = MLPostProcessFunction.getResponseFilter((String)postProcessFunction);
            }
            Object filteredOutput = JsonPath.read((String)modelResponse, (String)responseFilter, (Predicate[])new Predicate[0]);
            List processedResponse = (List)MLPostProcessFunction.get((String)postProcessFunction).apply(filteredOutput);
            return ModelTensors.builder().mlModelTensors(processedResponse).build();
        }
        Optional<String> processedResponse = ScriptUtils.executePostProcessFunction(scriptService, postProcessFunction, modelResponse);
        String response = processedResponse.orElse(modelResponse);
        boolean bl = scriptReturnModelTensor = postProcessFunction != null && processedResponse.isPresent() && org.opensearch.ml.common.utils.StringUtils.isJson((String)response);
        if (responseFilter == null) {
            connector.parseResponse((Object)response, modelTensors, scriptReturnModelTensor);
        } else {
            Object filteredResponse = JsonPath.parse((String)response).read(parameters.get("response_filter"), new Predicate[0]);
            connector.parseResponse(filteredResponse, modelTensors, scriptReturnModelTensor);
        }
        return ModelTensors.builder().mlModelTensors(modelTensors).build();
    }

    private static String fillProcessFunctionParameter(Map<String, String> parameters, String processFunction) {
        if (processFunction != null && processFunction.contains("${parameters.")) {
            HashMap<String, String> tmpParameters = new HashMap<String, String>();
            for (String key : parameters.keySet()) {
                tmpParameters.put(key, org.opensearch.ml.common.utils.StringUtils.gson.toJson((Object)parameters.get(key)));
            }
            StringSubstitutor substitutor = new StringSubstitutor(tmpParameters, "${parameters.", "}");
            processFunction = substitutor.replace(processFunction);
        }
        return processFunction;
    }

    public static SdkHttpFullRequest signRequest(SdkHttpFullRequest request, String accessKey, String secretKey, String sessionToken, String signingName, String region) {
        AwsBasicCredentials credentials = sessionToken == null ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
        Aws4SignerParams params = Aws4SignerParams.builder().awsCredentials((AwsCredentials)credentials).signingName(signingName).signingRegion(Region.of((String)region)).build();
        return signer.sign(request, params);
    }
}

