# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2020_10_01_preview.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2020_10_01_preview.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2020_10_01_preview.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2020_10_01_preview.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.message = message
        self.target = target


class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword message: The error message.
        :paramtype message: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class CloudService(_serialization.Model):
    """Describes the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Cloud service properties.
    :vartype properties: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudServiceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudServiceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Cloud service properties.
        :paramtype properties: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties


class CloudServiceExtensionProfile(_serialization.Model):
    """Describes a cloud service extension profile.

    :ivar extensions: List of extensions for the cloud service.
    :vartype extensions: list[~azure.mgmt.compute.v2020_10_01_preview.models.Extension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[Extension]"},
    }

    def __init__(self, *, extensions: Optional[List["_models.Extension"]] = None, **kwargs: Any) -> None:
        """
        :keyword extensions: List of extensions for the cloud service.
        :paramtype extensions: list[~azure.mgmt.compute.v2020_10_01_preview.models.Extension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions


class CloudServiceExtensionProperties(_serialization.Model):
    """Extension Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the extension. Specifies the version of
     the extension. If this element is not specified or an asterisk (*) is used as the value, the
     latest version of the extension is used. If the value is specified with a major version number
     and an asterisk as the minor version number (X.), the latest minor version of the specified
     major version is selected. If a major version number and a minor version number are specified
     (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
     is performed on the role instance.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade
     typeHandlerVersion to higher minor versions when they become available.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Public settings for the extension. For JSON extensions, this is the JSON
     settings for the extension. For XML Extension (like RDP), this is the XML setting for the
     extension.
    :vartype settings: str
    :ivar protected_settings: Protected settings for the extension which are encrypted before sent
     to the role instance.
    :vartype protected_settings: str
    :ivar protected_settings_from_key_vault:
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultAndSecretReference
    :ivar force_update_tag: Tag to force apply the provided public and protected settings.
     Changing the tag value allows for re-running the extension without changing any of the public
     or protected settings.
     If forceUpdateTag is not changed, updates to public or protected settings would still be
     applied by the handler.
     If neither forceUpdateTag nor any of public or protected settings change, extension would flow
     to the role instance with the same sequence-number, and
     it is up to handler implementation whether to re-run it or not.
    :vartype force_update_tag: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar roles_applied_to: Optional list of roles to apply this extension. If property is not
     specified or '*' is specified, extension is applied to all roles in the cloud service.
    :vartype roles_applied_to: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "settings", "type": "str"},
        "protected_settings": {"key": "protectedSettings", "type": "str"},
        "protected_settings_from_key_vault": {
            "key": "protectedSettingsFromKeyVault",
            "type": "CloudServiceVaultAndSecretReference",
        },
        "force_update_tag": {"key": "forceUpdateTag", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "roles_applied_to": {"key": "rolesAppliedTo", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[str] = None,
        protected_settings: Optional[str] = None,
        protected_settings_from_key_vault: Optional["_models.CloudServiceVaultAndSecretReference"] = None,
        force_update_tag: Optional[str] = None,
        roles_applied_to: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension.
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the extension. Specifies the version of
         the extension. If this element is not specified or an asterisk (*) is used as the value, the
         latest version of the extension is used. If the value is specified with a major version number
         and an asterisk as the minor version number (X.), the latest minor version of the specified
         major version is selected. If a major version number and a minor version number are specified
         (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
         is performed on the role instance.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Explicitly specify whether platform can automatically
         upgrade typeHandlerVersion to higher minor versions when they become available.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Public settings for the extension. For JSON extensions, this is the JSON
         settings for the extension. For XML Extension (like RDP), this is the XML setting for the
         extension.
        :paramtype settings: str
        :keyword protected_settings: Protected settings for the extension which are encrypted before
         sent to the role instance.
        :paramtype protected_settings: str
        :keyword protected_settings_from_key_vault:
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultAndSecretReference
        :keyword force_update_tag: Tag to force apply the provided public and protected settings.
         Changing the tag value allows for re-running the extension without changing any of the public
         or protected settings.
         If forceUpdateTag is not changed, updates to public or protected settings would still be
         applied by the handler.
         If neither forceUpdateTag nor any of public or protected settings change, extension would flow
         to the role instance with the same sequence-number, and
         it is up to handler implementation whether to re-run it or not.
        :paramtype force_update_tag: str
        :keyword roles_applied_to: Optional list of roles to apply this extension. If property is not
         specified or '*' is specified, extension is applied to all roles in the cloud service.
        :paramtype roles_applied_to: list[str]
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.protected_settings_from_key_vault = protected_settings_from_key_vault
        self.force_update_tag = force_update_tag
        self.provisioning_state = None
        self.roles_applied_to = roles_applied_to


class CloudServiceInstanceView(_serialization.Model):
    """InstanceView of CloudService as a whole.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_instance: Instance view statuses.
    :vartype role_instance:
     ~azure.mgmt.compute.v2020_10_01_preview.models.InstanceViewStatusesSummary
    :ivar sdk_version: The version of the SDK that was used to generate the package for the cloud
     service.
    :vartype sdk_version: str
    :ivar statuses:
    :vartype statuses:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "sdk_version": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "role_instance": {"key": "roleInstance", "type": "InstanceViewStatusesSummary"},
        "sdk_version": {"key": "sdkVersion", "type": "str"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, *, role_instance: Optional["_models.InstanceViewStatusesSummary"] = None, **kwargs: Any) -> None:
        """
        :keyword role_instance: Instance view statuses.
        :paramtype role_instance:
         ~azure.mgmt.compute.v2020_10_01_preview.models.InstanceViewStatusesSummary
        """
        super().__init__(**kwargs)
        self.role_instance = role_instance
        self.sdk_version = None
        self.statuses = None


class CloudServiceListResult(_serialization.Model):
    """CloudServiceListResult.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudService]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CloudService"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudService]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceNetworkProfile(_serialization.Model):
    """Network Profile for the cloud service.

    :ivar load_balancer_configurations: The list of load balancer configurations for the cloud
     service.
    :vartype load_balancer_configurations:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerConfiguration]
    :ivar swappable_cloud_service:
    :vartype swappable_cloud_service: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
    """

    _attribute_map = {
        "load_balancer_configurations": {"key": "loadBalancerConfigurations", "type": "[LoadBalancerConfiguration]"},
        "swappable_cloud_service": {"key": "swappableCloudService", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        load_balancer_configurations: Optional[List["_models.LoadBalancerConfiguration"]] = None,
        swappable_cloud_service: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_balancer_configurations: The list of load balancer configurations for the cloud
         service.
        :paramtype load_balancer_configurations:
         list[~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerConfiguration]
        :keyword swappable_cloud_service:
        :paramtype swappable_cloud_service: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
        """
        super().__init__(**kwargs)
        self.load_balancer_configurations = load_balancer_configurations
        self.swappable_cloud_service = swappable_cloud_service


class CloudServiceOsProfile(_serialization.Model):
    """Describes the OS profile for the cloud service.

    :ivar secrets: Specifies set of certificates that should be installed onto the role instances.
    :vartype secrets:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultSecretGroup]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[CloudServiceVaultSecretGroup]"},
    }

    def __init__(
        self, *, secrets: Optional[List["_models.CloudServiceVaultSecretGroup"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Specifies set of certificates that should be installed onto the role
         instances.
        :paramtype secrets:
         list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.secrets = secrets


class CloudServiceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cloud service properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_url: Specifies a URL that refers to the location of the service package in the
     Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
     account.
     This is a write-only property and is not returned in GET calls.
    :vartype package_url: str
    :ivar configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
    :vartype configuration: str
    :ivar configuration_url: Specifies a URL that refers to the location of the service
     configuration in the Blob service. The service package URL  can be Shared Access Signature
     (SAS) URI from any storage account.
     This is a write-only property and is not returned in GET calls.
    :vartype configuration_url: str
    :ivar start_cloud_service: (Optional) Indicates whether to start the cloud service immediately
     after it is created. The default value is ``true``.
     If false, the service model is still deployed, but the code is not run immediately. Instead,
     the service is PoweredOff until you call Start, at which time the service will be started. A
     deployed service still incurs charges, even if it is poweredoff.
    :vartype start_cloud_service: bool
    :ivar upgrade_mode: Update mode for the cloud service. Role instances are allocated to update
     domains when the service is deployed. Updates can be initiated manually in each update domain
     or initiated automatically in all update domains.
     Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
     **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
     to apply the update. If set to Auto, the update is automatically applied to each update domain
     in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
    :vartype upgrade_mode: str or
     ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceUpgradeMode
    :ivar role_profile: Describes the role profile for the cloud service.
    :vartype role_profile: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProfile
    :ivar os_profile: Describes the OS profile for the cloud service.
    :vartype os_profile: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceOsProfile
    :ivar network_profile: Network Profile for the cloud service.
    :vartype network_profile:
     ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceNetworkProfile
    :ivar extension_profile: Describes a cloud service extension profile.
    :vartype extension_profile:
     ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceExtensionProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar unique_id: The unique identifier for the cloud service.
    :vartype unique_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "package_url": {"key": "packageUrl", "type": "str"},
        "configuration": {"key": "configuration", "type": "str"},
        "configuration_url": {"key": "configurationUrl", "type": "str"},
        "start_cloud_service": {"key": "startCloudService", "type": "bool"},
        "upgrade_mode": {"key": "upgradeMode", "type": "str"},
        "role_profile": {"key": "roleProfile", "type": "CloudServiceRoleProfile"},
        "os_profile": {"key": "osProfile", "type": "CloudServiceOsProfile"},
        "network_profile": {"key": "networkProfile", "type": "CloudServiceNetworkProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "CloudServiceExtensionProfile"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_url: Optional[str] = None,
        configuration: Optional[str] = None,
        configuration_url: Optional[str] = None,
        start_cloud_service: Optional[bool] = None,
        upgrade_mode: Optional[Union[str, "_models.CloudServiceUpgradeMode"]] = None,
        role_profile: Optional["_models.CloudServiceRoleProfile"] = None,
        os_profile: Optional["_models.CloudServiceOsProfile"] = None,
        network_profile: Optional["_models.CloudServiceNetworkProfile"] = None,
        extension_profile: Optional["_models.CloudServiceExtensionProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_url: Specifies a URL that refers to the location of the service package in the
         Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
         account.
         This is a write-only property and is not returned in GET calls.
        :paramtype package_url: str
        :keyword configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :paramtype configuration: str
        :keyword configuration_url: Specifies a URL that refers to the location of the service
         configuration in the Blob service. The service package URL  can be Shared Access Signature
         (SAS) URI from any storage account.
         This is a write-only property and is not returned in GET calls.
        :paramtype configuration_url: str
        :keyword start_cloud_service: (Optional) Indicates whether to start the cloud service
         immediately after it is created. The default value is ``true``.
         If false, the service model is still deployed, but the code is not run immediately. Instead,
         the service is PoweredOff until you call Start, at which time the service will be started. A
         deployed service still incurs charges, even if it is poweredoff.
        :paramtype start_cloud_service: bool
        :keyword upgrade_mode: Update mode for the cloud service. Role instances are allocated to
         update domains when the service is deployed. Updates can be initiated manually in each update
         domain or initiated automatically in all update domains.
         Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
         **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
         If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
         to apply the update. If set to Auto, the update is automatically applied to each update domain
         in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
        :paramtype upgrade_mode: str or
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceUpgradeMode
        :keyword role_profile: Describes the role profile for the cloud service.
        :paramtype role_profile: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProfile
        :keyword os_profile: Describes the OS profile for the cloud service.
        :paramtype os_profile: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceOsProfile
        :keyword network_profile: Network Profile for the cloud service.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceNetworkProfile
        :keyword extension_profile: Describes a cloud service extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceExtensionProfile
        """
        super().__init__(**kwargs)
        self.package_url = package_url
        self.configuration = configuration
        self.configuration_url = configuration_url
        self.start_cloud_service = start_cloud_service
        self.upgrade_mode = upgrade_mode
        self.role_profile = role_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile
        self.provisioning_state = None
        self.unique_id = None


class CloudServiceRole(_serialization.Model):
    """Describes a role of the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleSku
    :ivar properties:
    :vartype properties: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
        "properties": {"key": "properties", "type": "CloudServiceRoleProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.CloudServiceRoleSku"] = None,
        properties: Optional["_models.CloudServiceRoleProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleSku
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.sku = sku
        self.properties = properties


class CloudServiceRoleListResult(_serialization.Model):
    """CloudServiceRoleListResult.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRole]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudServiceRole]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CloudServiceRole"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRole]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceRoleProfile(_serialization.Model):
    """Describes the role profile for the cloud service.

    :ivar roles: List of roles for the cloud service.
    :vartype roles:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProfileProperties]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "[CloudServiceRoleProfileProperties]"},
    }

    def __init__(
        self, *, roles: Optional[List["_models.CloudServiceRoleProfileProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword roles: List of roles for the cloud service.
        :paramtype roles:
         list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleProfileProperties]
        """
        super().__init__(**kwargs)
        self.roles = roles


class CloudServiceRoleProfileProperties(_serialization.Model):
    """Describes the role properties.

    :ivar name: Resource name.
    :vartype name: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleSku
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
    }

    def __init__(
        self, *, name: Optional[str] = None, sku: Optional["_models.CloudServiceRoleSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceRoleSku
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku


class CloudServiceRoleProperties(_serialization.Model):
    """CloudServiceRoleProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_id: Specifies the ID which uniquely identifies a cloud service role.
    :vartype unique_id: str
    """

    _validation = {
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_id = None


class CloudServiceRoleSku(_serialization.Model):
    """Describes the cloud service role sku.

    :ivar name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
     service is currently on, you need to delete and recreate the cloud service or move back to the
     old sku.
    :vartype name: str
    :ivar tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
     />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of role instances in the cloud service.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
         service is currently on, you need to delete and recreate the cloud service or move back to the
         old sku.
        :paramtype name: str
        :keyword tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
         />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of role instances in the cloud service.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class CloudServiceUpdate(_serialization.Model):
    """CloudServiceUpdate.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CloudServiceVaultAndSecretReference(_serialization.Model):
    """CloudServiceVaultAndSecretReference.

    :ivar source_vault:
    :vartype source_vault: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
    :ivar secret_url:
    :vartype secret_url: str
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(
        self, *, source_vault: Optional["_models.SubResource"] = None, secret_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_vault:
        :paramtype source_vault: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
        :keyword secret_url:
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class CloudServiceVaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the role instance.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(self, *, certificate_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url


class CloudServiceVaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[CloudServiceVaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.CloudServiceVaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates:
         list[~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceVaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class Extension(_serialization.Model):
    """Describes a cloud service Extension.

    :ivar name: The name of the extension.
    :vartype name: str
    :ivar properties: Extension Properties.
    :vartype properties:
     ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceExtensionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "CloudServiceExtensionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.CloudServiceExtensionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword properties: Extension Properties.
        :paramtype properties:
         ~azure.mgmt.compute.v2020_10_01_preview.models.CloudServiceExtensionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceSku(_serialization.Model):
    """InstanceSku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The tier of the cloud service role instance.
    :vartype tier: str
    """

    _validation = {
        "name": {"readonly": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.tier = None


class InstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary:
    :vartype statuses_summary: list[~azure.mgmt.compute.v2020_10_01_preview.models.StatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[StatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None


class LoadBalancerConfiguration(_serialization.Model):
    """Describes the load balancer configuration.

    :ivar name: Resource Name.
    :vartype name: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerConfigurationProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.LoadBalancerConfigurationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource Name.
        :paramtype name: str
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerConfigurationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class LoadBalancerConfigurationProperties(_serialization.Model):
    """LoadBalancerConfigurationProperties.

    :ivar frontend_ip_configurations: List of IP.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerFrontendIPConfiguration]
    """

    _attribute_map = {
        "frontend_ip_configurations": {
            "key": "frontendIPConfigurations",
            "type": "[LoadBalancerFrontendIPConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        frontend_ip_configurations: Optional[List["_models.LoadBalancerFrontendIPConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword frontend_ip_configurations: List of IP.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerFrontendIPConfiguration]
        """
        super().__init__(**kwargs)
        self.frontend_ip_configurations = frontend_ip_configurations


class LoadBalancerFrontendIPConfiguration(_serialization.Model):
    """LoadBalancerFrontendIPConfiguration.

    :ivar name:
    :vartype name: str
    :ivar properties: Describes a cloud service IP Configuration.
    :vartype properties:
     ~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerFrontendIPConfigurationProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "LoadBalancerFrontendIPConfigurationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.LoadBalancerFrontendIPConfigurationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword properties: Describes a cloud service IP Configuration.
        :paramtype properties:
         ~azure.mgmt.compute.v2020_10_01_preview.models.LoadBalancerFrontendIPConfigurationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class LoadBalancerFrontendIPConfigurationProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Describes a cloud service IP Configuration.

    :ivar public_ip_address:
    :vartype public_ip_address: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
    :ivar subnet:
    :vartype subnet: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
    :ivar private_ip_address: The private IP address referenced by the cloud service.
    :vartype private_ip_address: str
    """

    _attribute_map = {
        "public_ip_address": {"key": "publicIPAddress", "type": "SubResource"},
        "subnet": {"key": "subnet", "type": "SubResource"},
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_ip_address: Optional["_models.SubResource"] = None,
        subnet: Optional["_models.SubResource"] = None,
        private_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_address:
        :paramtype public_ip_address: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
        :keyword subnet:
        :paramtype subnet: ~azure.mgmt.compute.v2020_10_01_preview.models.SubResource
        :keyword private_ip_address: The private IP address referenced by the cloud service.
        :paramtype private_ip_address: str
        """
        super().__init__(**kwargs)
        self.public_ip_address = public_ip_address
        self.subnet = subnet
        self.private_ip_address = private_ip_address


class ResourceInstanceViewStatus(_serialization.Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.v2020_10_01_preview.models.StatusLevelTypes
    """

    _validation = {
        "code": {"readonly": True},
        "display_status": {"readonly": True},
        "message": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, level: Optional[Union[str, "_models.StatusLevelTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.v2020_10_01_preview.models.StatusLevelTypes
        """
        super().__init__(**kwargs)
        self.code = None
        self.display_status = None
        self.message = None
        self.time = None
        self.level = level


class RoleInstance(_serialization.Model):
    """RoleInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.InstanceSku
    :ivar properties:
    :vartype properties: ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "tags": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "InstanceSku"},
        "properties": {"key": "properties", "type": "RoleInstanceProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.InstanceSku"] = None,
        properties: Optional["_models.RoleInstanceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku:
        :paramtype sku: ~azure.mgmt.compute.v2020_10_01_preview.models.InstanceSku
        :keyword properties:
        :paramtype properties: ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None
        self.sku = sku
        self.properties = properties


class RoleInstanceListResult(_serialization.Model):
    """RoleInstanceListResult.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstance]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RoleInstance"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstance]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleInstanceNetworkProfile(_serialization.Model):
    """Describes the network profile for the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the role instance.
    :vartype network_interfaces: list[~azure.mgmt.compute.v2020_10_01_preview.models.SubResource]
    """

    _validation = {
        "network_interfaces": {"readonly": True},
    }

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[SubResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.network_interfaces = None


class RoleInstanceProperties(_serialization.Model):
    """RoleInstanceProperties.

    :ivar network_profile: Describes the network profile for the role instance.
    :vartype network_profile:
     ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceNetworkProfile
    :ivar instance_view: The instance view of the role instance.
    :vartype instance_view: ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceView
    """

    _attribute_map = {
        "network_profile": {"key": "networkProfile", "type": "RoleInstanceNetworkProfile"},
        "instance_view": {"key": "instanceView", "type": "RoleInstanceView"},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.RoleInstanceNetworkProfile"] = None,
        instance_view: Optional["_models.RoleInstanceView"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile: Describes the network profile for the role instance.
        :paramtype network_profile:
         ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceNetworkProfile
        :keyword instance_view: The instance view of the role instance.
        :paramtype instance_view: ~azure.mgmt.compute.v2020_10_01_preview.models.RoleInstanceView
        """
        super().__init__(**kwargs)
        self.network_profile = network_profile
        self.instance_view = instance_view


class RoleInstances(_serialization.Model):
    """Specifies a list of role instances from the cloud service.

    All required parameters must be populated in order to send to server.

    :ivar role_instances: List of cloud service role instance names. Value of '*' will signify all
     role instances of the cloud service. Required.
    :vartype role_instances: list[str]
    """

    _validation = {
        "role_instances": {"required": True},
    }

    _attribute_map = {
        "role_instances": {"key": "roleInstances", "type": "[str]"},
    }

    def __init__(self, *, role_instances: List[str], **kwargs: Any) -> None:
        """
        :keyword role_instances: List of cloud service role instance names. Value of '*' will signify
         all role instances of the cloud service. Required.
        :paramtype role_instances: list[str]
        """
        super().__init__(**kwargs)
        self.role_instances = role_instances


class RoleInstanceView(_serialization.Model):
    """The instance view of the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain.
    :vartype platform_fault_domain: int
    :ivar private_id: Specifies a unique identifier generated internally for the cloud service
     associated with this role instance. :code:`<br />`:code:`<br />` NOTE: If you are using Azure
     Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
    :vartype private_id: str
    :ivar statuses:
    :vartype statuses:
     list[~azure.mgmt.compute.v2020_10_01_preview.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "platform_update_domain": {"readonly": True},
        "platform_fault_domain": {"readonly": True},
        "private_id": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "private_id": {"key": "privateId", "type": "str"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.platform_update_domain = None
        self.platform_fault_domain = None
        self.private_id = None
        self.statuses = None


class StatusCodeCount(_serialization.Model):
    """StatusCodeCount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: Number of instances having this status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None


class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class UpdateDomain(_serialization.Model):
    """Defines an update domain for the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None


class UpdateDomainListResult(_serialization.Model):
    """UpdateDomainListResult.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.UpdateDomain]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpdateDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.UpdateDomain"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.compute.v2020_10_01_preview.models.UpdateDomain]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
