# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BOPAlgo module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_bopalgo.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BOPAlgo
else:
    import _BOPAlgo

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BOPAlgo.delete_SwigPyIterator

    def value(self):
        return _BOPAlgo.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BOPAlgo.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BOPAlgo.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BOPAlgo.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BOPAlgo.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BOPAlgo.SwigPyIterator_copy(self)

    def next(self):
        return _BOPAlgo.SwigPyIterator_next(self)

    def __next__(self):
        return _BOPAlgo.SwigPyIterator___next__(self)

    def previous(self):
        return _BOPAlgo.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BOPAlgo.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BOPAlgo.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BOPAlgo.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BOPAlgo.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BOPAlgo.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BOPAlgo.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BOPAlgo.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BOPAlgo:
_BOPAlgo.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BOPAlgo.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.TopTools
import OCC.Core.IntTools
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.Geom2dHatch
import OCC.Core.IntRes2d
import OCC.Core.HatchGen
import OCC.Core.Geom2dInt
import OCC.Core.IntCurve
import OCC.Core.Extrema
import OCC.Core.Intf
import OCC.Core.GeomAPI
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves
import OCC.Core.BRepClass3d
import OCC.Core.IntCurveSurface
import OCC.Core.IntSurf
import OCC.Core.IntCurvesFace
import OCC.Core.IntPatch
import OCC.Core.IntAna
import OCC.Core.GeomInt
import OCC.Core.IntImp
import OCC.Core.ApproxInt
import OCC.Core.BOPDS
import OCC.Core.BRepTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.BOPTools

from enum import IntEnum
from OCC.Core.Exception import *

BOPAlgo_CheckUnknown = _BOPAlgo.BOPAlgo_CheckUnknown
BOPAlgo_BadType = _BOPAlgo.BOPAlgo_BadType
BOPAlgo_SelfIntersect = _BOPAlgo.BOPAlgo_SelfIntersect
BOPAlgo_TooSmallEdge = _BOPAlgo.BOPAlgo_TooSmallEdge
BOPAlgo_NonRecoverableFace = _BOPAlgo.BOPAlgo_NonRecoverableFace
BOPAlgo_IncompatibilityOfVertex = _BOPAlgo.BOPAlgo_IncompatibilityOfVertex
BOPAlgo_IncompatibilityOfEdge = _BOPAlgo.BOPAlgo_IncompatibilityOfEdge
BOPAlgo_IncompatibilityOfFace = _BOPAlgo.BOPAlgo_IncompatibilityOfFace
BOPAlgo_OperationAborted = _BOPAlgo.BOPAlgo_OperationAborted
BOPAlgo_GeomAbs_C0 = _BOPAlgo.BOPAlgo_GeomAbs_C0
BOPAlgo_InvalidCurveOnSurface = _BOPAlgo.BOPAlgo_InvalidCurveOnSurface
BOPAlgo_NotValid = _BOPAlgo.BOPAlgo_NotValid
BOPAlgo_GlueOff = _BOPAlgo.BOPAlgo_GlueOff
BOPAlgo_GlueShift = _BOPAlgo.BOPAlgo_GlueShift
BOPAlgo_GlueFull = _BOPAlgo.BOPAlgo_GlueFull
BOPAlgo_COMMON = _BOPAlgo.BOPAlgo_COMMON
BOPAlgo_FUSE = _BOPAlgo.BOPAlgo_FUSE
BOPAlgo_CUT = _BOPAlgo.BOPAlgo_CUT
BOPAlgo_CUT21 = _BOPAlgo.BOPAlgo_CUT21
BOPAlgo_SECTION = _BOPAlgo.BOPAlgo_SECTION
BOPAlgo_UNKNOWN = _BOPAlgo.BOPAlgo_UNKNOWN


class BOPAlgo_CheckStatus(IntEnum):
	BOPAlgo_CheckUnknown = 0
	BOPAlgo_BadType = 1
	BOPAlgo_SelfIntersect = 2
	BOPAlgo_TooSmallEdge = 3
	BOPAlgo_NonRecoverableFace = 4
	BOPAlgo_IncompatibilityOfVertex = 5
	BOPAlgo_IncompatibilityOfEdge = 6
	BOPAlgo_IncompatibilityOfFace = 7
	BOPAlgo_OperationAborted = 8
	BOPAlgo_GeomAbs_C0 = 9
	BOPAlgo_InvalidCurveOnSurface = 10
	BOPAlgo_NotValid = 11
BOPAlgo_CheckUnknown = BOPAlgo_CheckStatus.BOPAlgo_CheckUnknown
BOPAlgo_BadType = BOPAlgo_CheckStatus.BOPAlgo_BadType
BOPAlgo_SelfIntersect = BOPAlgo_CheckStatus.BOPAlgo_SelfIntersect
BOPAlgo_TooSmallEdge = BOPAlgo_CheckStatus.BOPAlgo_TooSmallEdge
BOPAlgo_NonRecoverableFace = BOPAlgo_CheckStatus.BOPAlgo_NonRecoverableFace
BOPAlgo_IncompatibilityOfVertex = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfVertex
BOPAlgo_IncompatibilityOfEdge = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfEdge
BOPAlgo_IncompatibilityOfFace = BOPAlgo_CheckStatus.BOPAlgo_IncompatibilityOfFace
BOPAlgo_OperationAborted = BOPAlgo_CheckStatus.BOPAlgo_OperationAborted
BOPAlgo_GeomAbs_C0 = BOPAlgo_CheckStatus.BOPAlgo_GeomAbs_C0
BOPAlgo_InvalidCurveOnSurface = BOPAlgo_CheckStatus.BOPAlgo_InvalidCurveOnSurface
BOPAlgo_NotValid = BOPAlgo_CheckStatus.BOPAlgo_NotValid

class BOPAlgo_GlueEnum(IntEnum):
	BOPAlgo_GlueOff = 0
	BOPAlgo_GlueShift = 1
	BOPAlgo_GlueFull = 2
BOPAlgo_GlueOff = BOPAlgo_GlueEnum.BOPAlgo_GlueOff
BOPAlgo_GlueShift = BOPAlgo_GlueEnum.BOPAlgo_GlueShift
BOPAlgo_GlueFull = BOPAlgo_GlueEnum.BOPAlgo_GlueFull

class BOPAlgo_Operation(IntEnum):
	BOPAlgo_COMMON = 0
	BOPAlgo_FUSE = 1
	BOPAlgo_CUT = 2
	BOPAlgo_CUT21 = 3
	BOPAlgo_SECTION = 4
	BOPAlgo_UNKNOWN = 5
BOPAlgo_COMMON = BOPAlgo_Operation.BOPAlgo_COMMON
BOPAlgo_FUSE = BOPAlgo_Operation.BOPAlgo_FUSE
BOPAlgo_CUT = BOPAlgo_Operation.BOPAlgo_CUT
BOPAlgo_CUT21 = BOPAlgo_Operation.BOPAlgo_CUT21
BOPAlgo_SECTION = BOPAlgo_Operation.BOPAlgo_SECTION
BOPAlgo_UNKNOWN = BOPAlgo_Operation.BOPAlgo_UNKNOWN

class BOPAlgo_ListOfCheckResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_begin(self)

    def end(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_end(self)

    def cbegin(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_cbegin(self)

    def cend(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_cend(self)

    def __init__(self, *args):
        _BOPAlgo.BOPAlgo_ListOfCheckResult_swiginit(self, _BOPAlgo.new_BOPAlgo_ListOfCheckResult(*args))

    def Size(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Size(self)

    def Assign(self, theOther):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Assign(self, theOther)

    def Set(self, theOther):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Clear(self, theAllocator)

    def First(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_First(self)

    def Last(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Last(self)

    def Append(self, *args):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Append(self, *args)

    def Prepend(self, *args):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Prepend(self, *args)

    def RemoveFirst(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_RemoveFirst(self)

    def Remove(self, theIter):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_InsertAfter(self, *args)

    def Reverse(self):
        return _BOPAlgo.BOPAlgo_ListOfCheckResult_Reverse(self)
    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_ListOfCheckResult

    def __len__(self):
        return self.Size()


# Register BOPAlgo_ListOfCheckResult in _BOPAlgo:
_BOPAlgo.BOPAlgo_ListOfCheckResult_swigregister(BOPAlgo_ListOfCheckResult)
class BOPAlgo_CheckResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_CheckResult_swiginit(self, _BOPAlgo.new_BOPAlgo_CheckResult(*args))

    def AddFaultyShape1(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds faulty sub-shapes from object to a list.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_AddFaultyShape1(self, *args)

    def AddFaultyShape2(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds faulty sub-shapes from tool to a list.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_AddFaultyShape2(self, *args)

    def GetCheckStatus(self, *args):
        r"""
        Return
        -------
        BOPAlgo_CheckStatus

        Description
        -----------
        Gets status of faulty.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetCheckStatus(self, *args)

    def GetFaultyShapes1(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns list of faulty shapes for object.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetFaultyShapes1(self, *args)

    def GetFaultyShapes2(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns list of faulty shapes for tool.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetFaultyShapes2(self, *args)

    def GetMaxDistance1(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance for the first shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetMaxDistance1(self, *args)

    def GetMaxDistance2(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the distance for the second shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetMaxDistance2(self, *args)

    def GetMaxParameter1(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parameter for the fircst shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetMaxParameter1(self, *args)

    def GetMaxParameter2(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the parameter for the second shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetMaxParameter2(self, *args)

    def GetShape1(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns ancestor shape (object) for faulties.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetShape1(self, *args)

    def GetShape2(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns ancestor shape (tool) for faulties.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_GetShape2(self, *args)

    def SetCheckStatus(self, *args):
        r"""

        Parameters
        ----------
        TheStatus: BOPAlgo_CheckStatus

        Return
        -------
        None

        Description
        -----------
        Set status of faulty.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetCheckStatus(self, *args)

    def SetMaxDistance1(self, *args):
        r"""

        Parameters
        ----------
        theDist: float

        Return
        -------
        None

        Description
        -----------
        Sets max distance for the first shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetMaxDistance1(self, *args)

    def SetMaxDistance2(self, *args):
        r"""

        Parameters
        ----------
        theDist: float

        Return
        -------
        None

        Description
        -----------
        Sets max distance for the second shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetMaxDistance2(self, *args)

    def SetMaxParameter1(self, *args):
        r"""

        Parameters
        ----------
        thePar: float

        Return
        -------
        None

        Description
        -----------
        Sets the parameter for the first shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetMaxParameter1(self, *args)

    def SetMaxParameter2(self, *args):
        r"""

        Parameters
        ----------
        thePar: float

        Return
        -------
        None

        Description
        -----------
        Sets the parameter for the second shape.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetMaxParameter2(self, *args)

    def SetShape1(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets ancestor shape (object) for faulty sub-shapes.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetShape1(self, *args)

    def SetShape2(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets ancestor shape (tool) for faulty sub-shapes.

        """
        return _BOPAlgo.BOPAlgo_CheckResult_SetShape2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_CheckResult

# Register BOPAlgo_CheckResult in _BOPAlgo:
_BOPAlgo.BOPAlgo_CheckResult_swigregister(BOPAlgo_CheckResult)
class BOPAlgo_Options(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        Constructor with allocator.

        """
        _BOPAlgo.BOPAlgo_Options_swiginit(self, _BOPAlgo.new_BOPAlgo_Options(*args))

    def AddError(self, *args):
        r"""

        Parameters
        ----------
        theAlert: Message_Alert

        Return
        -------
        None

        Description
        -----------
        Adds the alert as error (fail).

        """
        return _BOPAlgo.BOPAlgo_Options_AddError(self, *args)

    def AddWarning(self, *args):
        r"""

        Parameters
        ----------
        theAlert: Message_Alert

        Return
        -------
        None

        Description
        -----------
        Adds the alert as warning.

        """
        return _BOPAlgo.BOPAlgo_Options_AddWarning(self, *args)

    def Allocator(self, *args):
        r"""
        Return
        -------
        opencascade::handle<NCollection_BaseAllocator>

        Description
        -----------
        Returns allocator.

        """
        return _BOPAlgo.BOPAlgo_Options_Allocator(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all warnings and errors, and any data cached by the algorithm. user defined options are not cleared.

        """
        return _BOPAlgo.BOPAlgo_Options_Clear(self, *args)

    def ClearWarnings(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the warnings of the algorithm.

        """
        return _BOPAlgo.BOPAlgo_Options_ClearWarnings(self, *args)

    def DumpErrorsToString(self):
        r"""DumpErrorsToString(BOPAlgo_Options self) -> std::string"""
        return _BOPAlgo.BOPAlgo_Options_DumpErrorsToString(self)

    def DumpWarningsToString(self):
        r"""DumpWarningsToString(BOPAlgo_Options self) -> std::string"""
        return _BOPAlgo.BOPAlgo_Options_DumpWarningsToString(self)

    def FuzzyValue(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the additional tolerance.

        """
        return _BOPAlgo.BOPAlgo_Options_FuzzyValue(self, *args)

    @staticmethod
    def GetParallelMode(*args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Gets the global parallel mode.

        """
        return _BOPAlgo.BOPAlgo_Options_GetParallelMode(*args)

    def GetReport(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Message_Report>

        Description
        -----------
        Returns report collecting all errors and warnings.

        """
        return _BOPAlgo.BOPAlgo_Options_GetReport(self, *args)

    def HasError(self, *args):
        r"""

        Parameters
        ----------
        theType: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns true if algorithm has generated error of specified type.

        """
        return _BOPAlgo.BOPAlgo_Options_HasError(self, *args)

    def HasErrors(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if algorithm has failed.

        """
        return _BOPAlgo.BOPAlgo_Options_HasErrors(self, *args)

    def HasWarning(self, *args):
        r"""

        Parameters
        ----------
        theType: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        Returns true if algorithm has generated warning of specified type.

        """
        return _BOPAlgo.BOPAlgo_Options_HasWarning(self, *args)

    def HasWarnings(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if algorithm has generated some warning alerts.

        """
        return _BOPAlgo.BOPAlgo_Options_HasWarnings(self, *args)

    def RunParallel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag of parallel processing.

        """
        return _BOPAlgo.BOPAlgo_Options_RunParallel(self, *args)

    def SetFuzzyValue(self, *args):
        r"""

        Parameters
        ----------
        theFuzz: float

        Return
        -------
        None

        Description
        -----------
        Sets the additional tolerance.

        """
        return _BOPAlgo.BOPAlgo_Options_SetFuzzyValue(self, *args)

    @staticmethod
    def SetParallelMode(*args):
        r"""

        Parameters
        ----------
        theNewMode: bool

        Return
        -------
        None

        Description
        -----------
        Sets the global parallel mode.

        """
        return _BOPAlgo.BOPAlgo_Options_SetParallelMode(*args)

    def SetRunParallel(self, *args):
        r"""

        Parameters
        ----------
        theFlag: bool

        Return
        -------
        None

        Description
        -----------
        Set the flag of parallel processing if <theflag> is true the parallel processing is switched on if <theflag> is false the parallel processing is switched off.

        """
        return _BOPAlgo.BOPAlgo_Options_SetRunParallel(self, *args)

    def SetUseOBB(self, *args):
        r"""

        Parameters
        ----------
        theUseOBB: bool

        Return
        -------
        None

        Description
        -----------
        Enables/disables the usage of obb.

        """
        return _BOPAlgo.BOPAlgo_Options_SetUseOBB(self, *args)

    def UseOBB(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag defining usage of obb.

        """
        return _BOPAlgo.BOPAlgo_Options_UseOBB(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_Options

# Register BOPAlgo_Options in _BOPAlgo:
_BOPAlgo.BOPAlgo_Options_swigregister(BOPAlgo_Options)
class BOPAlgo_PISteps(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theNbOp: int

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _BOPAlgo.BOPAlgo_PISteps_swiginit(self, _BOPAlgo.new_BOPAlgo_PISteps(*args))

    def ChangeSteps(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns modifiable steps.

        """
        return _BOPAlgo.BOPAlgo_PISteps_ChangeSteps(self, *args)

    def GetStep(self, *args):
        r"""

        Parameters
        ----------
        theOperation: int

        Return
        -------
        float

        Description
        -----------
        Returns the step assigned to the operation.

        """
        return _BOPAlgo.BOPAlgo_PISteps_GetStep(self, *args)

    def SetStep(self, *args):
        r"""

        Parameters
        ----------
        theOperation: int
        theStep: float

        Return
        -------
        None

        Description
        -----------
        Assign the value thestep to theoperation.

        """
        return _BOPAlgo.BOPAlgo_PISteps_SetStep(self, *args)

    def Steps(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the steps.

        """
        return _BOPAlgo.BOPAlgo_PISteps_Steps(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_PISteps

# Register BOPAlgo_PISteps in _BOPAlgo:
_BOPAlgo.BOPAlgo_PISteps_swigregister(BOPAlgo_PISteps)
class BOPAlgo_SectionAttribute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Default constructor.

        Parameters
        ----------
        theAproximation: bool
        thePCurveOnS1: bool
        thePCurveOnS2: bool

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _BOPAlgo.BOPAlgo_SectionAttribute_swiginit(self, _BOPAlgo.new_BOPAlgo_SectionAttribute(*args))

    def Approximation(self, *args):
        r"""

        Parameters
        ----------
        theApprox: bool

        Return
        -------
        None

        Description
        -----------
        Sets the approximation flag.
        Return
        -------
        bool

        Description
        -----------
        Returns the approximation flag.

        """
        return _BOPAlgo.BOPAlgo_SectionAttribute_Approximation(self, *args)

    def PCurveOnS1(self, *args):
        r"""

        Parameters
        ----------
        thePCurveOnS1: bool

        Return
        -------
        None

        Description
        -----------
        Sets the pcurveons1 flag.
        Return
        -------
        bool

        Description
        -----------
        Returns the pcurveons1 flag.

        """
        return _BOPAlgo.BOPAlgo_SectionAttribute_PCurveOnS1(self, *args)

    def PCurveOnS2(self, *args):
        r"""

        Parameters
        ----------
        thePCurveOnS2: bool

        Return
        -------
        None

        Description
        -----------
        Sets the pcurveons2 flag.
        Return
        -------
        bool

        Description
        -----------
        Returns the pcurveons2 flag.

        """
        return _BOPAlgo.BOPAlgo_SectionAttribute_PCurveOnS2(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_SectionAttribute

# Register BOPAlgo_SectionAttribute in _BOPAlgo:
_BOPAlgo.BOPAlgo_SectionAttribute_swigregister(BOPAlgo_SectionAttribute)
class BOPAlgo_Tools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ClassifyFaces(*args):
        r"""

        Parameters
        ----------
        theFaces: TopTools_ListOfShape
        theSolids: TopTools_ListOfShape
        theRunParallel: bool
        theContext: IntTools_Context
        theInParts: TopTools_IndexedDataMapOfShapeListOfShape
        theShapeBoxMap: TopTools_DataMapOfShapeBox (optional, default to TopTools_DataMapOfShapeBox())
        theSolidsIF: TopTools_DataMapOfShapeListOfShape (optional, default to TopTools_DataMapOfShapeListOfShape())
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Classifies the faces <thefaces> relatively solids <thesolids>. the in faces for solids are stored into output data map <theinparts>. //! the map <thesolidsif> contains internal faces of the solids, to avoid their additional classification. //! firstly, it checks the intersection of bounding boxes of the shapes. if the box is not stored in the <theshapeboxmap> map, it builds the box. if the bounding boxes of solid and face are interfering the classification is performed. //! it is assumed that all faces and solids are already intersected and do not have any geometrically coinciding parts without topological sharing of these parts.

        """
        return _BOPAlgo.BOPAlgo_Tools_ClassifyFaces(*args)

    @staticmethod
    def ComputeToleranceOfCB(*args):
        r"""

        Parameters
        ----------
        theCB: BOPDS_CommonBlock
        theDS: BOPDS_PDS
        theContext: IntTools_Context

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_Tools_ComputeToleranceOfCB(*args)

    @staticmethod
    def EdgesToWires(*args):
        r"""

        Parameters
        ----------
        theEdges: TopoDS_Shape
        theWires: TopoDS_Shape
        theShared: bool (optional, default to Standard_False)
        theAngTol: float (optional, default to 1e-8)

        Return
        -------
        int

        Description
        -----------
        Creates planar wires from the given edges. the input edges are expected to be planar. and for the performance sake the method does not check if the edges are really planar. thus, the result wires will also be not planar if the input edges are not planar. the edges may be not shared, but the resulting wires will be sharing the coinciding parts and intersecting parts. the output wires may be non-manifold and contain free and multi-connected vertices. parameters: <theedges> - input edges; <thewires> - output wires; <theshared> - boolean flag which defines whether the input edges are already shared or have to be intersected; <theangtol> - the angular tolerance which will be used for distinguishing the planes in which the edges are located. default value is 1.e-8 which is used for intersection of planes in inttools_faceface. method returns the following error statuses: 0 - in case of success (at least one wire has been built); 1 - in case there are no edges in the given shape; 2 - sharing of the edges has failed.

        """
        return _BOPAlgo.BOPAlgo_Tools_EdgesToWires(*args)

    @staticmethod
    def FillInternals(*args):
        r"""

        Parameters
        ----------
        theSolids: TopTools_ListOfShape
        theParts: TopTools_ListOfShape
        theImages: TopTools_DataMapOfShapeListOfShape
        theContext: IntTools_Context

        Return
        -------
        None

        Description
        -----------
        Classifies the given parts relatively the given solids and fills the solids with the parts classified as internal. //! @param thesolids - the solids to put internals to @param theparts - the parts to classify relatively solids @param theimages - possible images of the parts that has to be classified @param thecontext - cached geometrical tools to speed-up classifications.

        """
        return _BOPAlgo.BOPAlgo_Tools_FillInternals(*args)

    @staticmethod
    def IntersectVertices(*args):
        r"""

        Parameters
        ----------
        theVertices: TopTools_IndexedDataMapOfShapeReal
        theFuzzyValue: float
        theChains: TopTools_ListOfListOfShape

        Return
        -------
        None

        Description
        -----------
        Finds chains of intersecting vertices.

        """
        return _BOPAlgo.BOPAlgo_Tools_IntersectVertices(*args)

    @staticmethod
    def PerformCommonBlocks(*args):
        r"""

        Parameters
        ----------
        theMBlocks: BOPDS_IndexedDataMapOfPaveBlockListOfPaveBlock
        theAllocator: NCollection_BaseAllocator
        theDS: BOPDS_PDS
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Create common blocks from the groups of pave blocks of <themblocks> connection map.

        Parameters
        ----------
        theMBlocks: BOPDS_IndexedDataMapOfPaveBlockListOfInteger
        theAllocator: NCollection_BaseAllocator
        pDS: BOPDS_PDS
        theContext: IntTools_Context (optional, default to opencascade::handle<IntTools_Context>())

        Return
        -------
        None

        Description
        -----------
        Create common blocks on faces using the pb->faces connection map <themblocks>.

        """
        return _BOPAlgo.BOPAlgo_Tools_PerformCommonBlocks(*args)

    @staticmethod
    def TrsfToPoint(*args):
        r"""

        Parameters
        ----------
        theBox1: Bnd_Box
        theBox2: Bnd_Box
        theTrsf: gp_Trsf
        thePoint: gp_Pnt (optional, default to gp_Pnt(0.0,0.0,0.0))
        theCriteria: float (optional, default to 1e+5)

        Return
        -------
        bool

        Description
        -----------
        Computes the transformation needed to move the objects to the given point to increase the quality of computations. returns true if the objects are located far from the given point (relatively given criteria), false otherwise. @param thebox1 the aabb of the first object @param thebox2 the aabb of the second object @param thetrsf the computed transformation @param thepoint the point to compute transformation to @param thecriteria the criteria to check whether thranformation is required.

        """
        return _BOPAlgo.BOPAlgo_Tools_TrsfToPoint(*args)

    @staticmethod
    def WiresToFaces(*args):
        r"""

        Parameters
        ----------
        theWires: TopoDS_Shape
        theFaces: TopoDS_Shape
        theAngTol: float (optional, default to 1e-8)

        Return
        -------
        bool

        Description
        -----------
        Creates planar faces from given planar wires. the method does not check if the wires are really planar. the input wires may be non-manifold but should be shared. the wires located in the same planes and included into other wires will create holes in the faces built from outer wires. the tolerance values of the input shapes may be modified during the operation due to projection of the edges on the planes for creation of 2d curves. parameters: <thewires> - the given wires; <thefaces> - the output faces; <theangtol> - the angular tolerance for distinguishing the planes in which the wires are located. default value is 1.e-8 which is used for intersection of planes in inttools_faceface. method returns true in case of success, i.e. at least one face has been built.

        """
        return _BOPAlgo.BOPAlgo_Tools_WiresToFaces(*args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def MakeBlocks(self):
    	pass

    @methodnotwrapped
    def FillMap(self):
    	pass

    @methodnotwrapped
    def TreatCompound(self):
    	pass


    def __init__(self):
        _BOPAlgo.BOPAlgo_Tools_swiginit(self, _BOPAlgo.new_BOPAlgo_Tools())
    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_Tools

# Register BOPAlgo_Tools in _BOPAlgo:
_BOPAlgo.BOPAlgo_Tools_swigregister(BOPAlgo_Tools)
class BOPAlgo_WireEdgeSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_WireEdgeSet_swiginit(self, _BOPAlgo.new_BOPAlgo_WireEdgeSet(*args))

    def AddShape(self, *args):
        r"""

        Parameters
        ----------
        sS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_AddShape(self, *args)

    def AddStartElement(self, *args):
        r"""

        Parameters
        ----------
        sS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_AddStartElement(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_Clear(self, *args)

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_Face(self, *args)

    def SetFace(self, *args):
        r"""

        Parameters
        ----------
        aF: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_SetFace(self, *args)

    def Shapes(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_Shapes(self, *args)

    def StartElements(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireEdgeSet_StartElements(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_WireEdgeSet

# Register BOPAlgo_WireEdgeSet in _BOPAlgo:
_BOPAlgo.BOPAlgo_WireEdgeSet_swigregister(BOPAlgo_WireEdgeSet)
class BOPAlgo_Algo(BOPAlgo_Options):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        The main method to implement the operation providing the range allows to enable progress indicator user break functionalities.

        """
        return _BOPAlgo.BOPAlgo_Algo_Perform(self, *args)

    __repr__ = _dumps_object


# Register BOPAlgo_Algo in _BOPAlgo:
_BOPAlgo.BOPAlgo_Algo_swigregister(BOPAlgo_Algo)
class BOPAlgo_MakeConnected(BOPAlgo_Options):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_MakeConnected_swiginit(self, _BOPAlgo.new_BOPAlgo_MakeConnected(*args))

    def AddArgument(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the shape to the arguments. @param thes [in] one of the argument shapes.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_AddArgument(self, *args)

    def Arguments(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of arguments of the operation.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_Arguments(self, *args)

    def ClearRepetitions(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the repetitions performed on the periodic shape, keeping the shape periodic.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_ClearRepetitions(self, *args)

    def GetModified(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of shapes modified from the given shape. @param thes [in] the shape for which the modified shapes are necessary.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_GetModified(self, *args)

    def GetOrigins(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of original shapes from which the current shape has been created. @param thes [in] the shape for which the origins are necessary.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_GetOrigins(self, *args)

    def History(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepTools_History>

        Description
        -----------
        Returns the history of operations.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_History(self, *args)

    def MakePeriodic(self, *args):
        r"""

        Parameters
        ----------
        theParams: BOPAlgo_MakePeriodic::PeriodicityParams

        Return
        -------
        None

        Description
        -----------
        Makes the connected shape periodic. repeated calls of this method overwrite the previous calls working with the basis connected shape. @param theparams [in] periodic options.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_MakePeriodic(self, *args)

    def MaterialsOnNegativeSide(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the original shapes which images contain the the given shape with reversed orientation. @param thes [in] the shape for which the materials are necessary.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_MaterialsOnNegativeSide(self, *args)

    def MaterialsOnPositiveSide(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the original shapes which images contain the the given shape with forward orientation. @param thes [in] the shape for which the materials are necessary.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_MaterialsOnPositiveSide(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Performs the operation, i.e. makes the input shapes connected.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_Perform(self, *args)

    def PeriodicShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the resulting periodic & repeated shape.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_PeriodicShape(self, *args)

    def PeriodicityTool(self, *args):
        r"""
        Return
        -------
        BOPAlgo_MakePeriodic

        Description
        -----------
        Returns the periodicity tool.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_PeriodicityTool(self, *args)

    def RepeatShape(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int
        theTimes: int

        Return
        -------
        None

        Description
        -----------
        Performs repetition of the periodic shape in specified direction required number of times. @param thedirectionid [in] the direction's id (0 for x, 1 for y, 2 for z); @param thetimes [in] requested number of repetitions (sign of the value defines  the side of the repetition direction (positive or negative)).

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_RepeatShape(self, *args)

    def SetArguments(self, *args):
        r"""

        Parameters
        ----------
        theArgs: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sets the shape for making them connected. @param theargs [in] the arguments for the operation.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_SetArguments(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the resulting connected shape.

        """
        return _BOPAlgo.BOPAlgo_MakeConnected_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_MakeConnected

# Register BOPAlgo_MakeConnected in _BOPAlgo:
_BOPAlgo.BOPAlgo_MakeConnected_swigregister(BOPAlgo_MakeConnected)
class BOPAlgo_MakePeriodic(BOPAlgo_Options):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_MakePeriodic_swiginit(self, _BOPAlgo.new_BOPAlgo_MakePeriodic(*args))

    def ClearRepetitions(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all performed repetitions. the next repetition will be performed on the base shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_ClearRepetitions(self, *args)

    def GetTwins(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the identical shapes for the given shape located on the opposite periodic side. returns empty list in case the shape has no twin. //! @param thes [in] shape to get the twins for.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_GetTwins(self, *args)

    def History(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepTools_History>

        Description
        -----------
        Returns the history of the algorithm.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_History(self, *args)

    def IsInputTrimmed(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int

        Return
        -------
        bool

        Description
        -----------
        Returns whether the input shape was trimmed in the specified direction. @param thedirectionid [in] the direction's id.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsInputTrimmed(self, *args)

    def IsInputXTrimmed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns whether the input shape was already trimmed for x period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsInputXTrimmed(self, *args)

    def IsInputYTrimmed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns whether the input shape was already trimmed for y period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsInputYTrimmed(self, *args)

    def IsInputZTrimmed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns whether the input shape was already trimmed for z period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsInputZTrimmed(self, *args)

    def IsPeriodic(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int

        Return
        -------
        bool

        Description
        -----------
        Returns the info about periodicity of the shape in specified direction. @param thedirectionid [in] the direction's id.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsPeriodic(self, *args)

    def IsXPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the info about periodicity of the shape in x direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsXPeriodic(self, *args)

    def IsYPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the info about periodicity of the shape in y direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsYPeriodic(self, *args)

    def IsZPeriodic(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the info about periodicity of the shape in z direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_IsZPeriodic(self, *args)

    def MakePeriodic(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int
        theIsPeriodic: bool
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Sets the flag to make the shape periodic in specified direction: - 0 - x direction; - 1 - y direction; - 2 - z direction. //! @param thedirectionid [in] the direction's id; @param theisperiodic [in] flag defining periodicity in given direction; @param theperiod [in] required period in given direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_MakePeriodic(self, *args)

    def MakeXPeriodic(self, *args):
        r"""

        Parameters
        ----------
        theIsPeriodic: bool
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Sets the flag to make the shape periodic in x direction. @param theisperiodic [in] flag defining periodicity in x direction; @param theperiod [in] required period in x direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_MakeXPeriodic(self, *args)

    def MakeYPeriodic(self, *args):
        r"""

        Parameters
        ----------
        theIsPeriodic: bool
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Sets the flag to make the shape periodic in y direction. @param theisperiodic [in] flag defining periodicity in y direction; @param theperiod [in] required period in y direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_MakeYPeriodic(self, *args)

    def MakeZPeriodic(self, *args):
        r"""

        Parameters
        ----------
        theIsPeriodic: bool
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Sets the flag to make the shape periodic in z direction. @param theisperiodic [in] flag defining periodicity in z direction; @param theperiod [in] required period in z direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_MakeZPeriodic(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Makes the shape periodic in necessary directions.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_Perform(self, *args)

    def Period(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int

        Return
        -------
        float

        Description
        -----------
        Returns the period of the shape in specified direction. @param thedirectionid [in] the direction's id.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_Period(self, *args)

    def PeriodFirst(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int

        Return
        -------
        float

        Description
        -----------
        Returns the first periodic parameter in the specified direction. @param thedirectionid [in] the direction's id.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_PeriodFirst(self, *args)

    def PeriodicityParameters(self, *args):
        r"""
        Return
        -------
        BOPAlgo_MakePeriodic::PeriodicityParams

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_PeriodicityParameters(self, *args)

    def RepeatShape(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int
        theTimes: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Performs repetition of the shape in specified direction required number of times. negative value of times means that the repetition should be perform in negative direction. makes the repeated shape a base for following repetitions. //! @param thedirectionid [in] the direction's id; @param thetimes [in] requested number of repetitions.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_RepeatShape(self, *args)

    def RepeatedShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the repeated shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_RepeatedShape(self, *args)

    def SetPeriodicityParameters(self, *args):
        r"""

        Parameters
        ----------
        theParams: PeriodicityParams

        Return
        -------
        None

        Description
        -----------
        Sets the periodicity parameters. @param theparams [in] periodicity parameters.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetPeriodicityParameters(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets the shape to make it periodic. @param theshape [in] the shape to make periodic.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetShape(self, *args)

    def SetTrimmed(self, *args):
        r"""

        Parameters
        ----------
        theDirectionID: int
        theIsTrimmed: bool
        theFirst: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Defines whether the input shape is already trimmed in specified direction to fit the period in this direction. direction is defined by an id: - 0 - x direction; - 1 - y direction; - 2 - z direction. //! if the shape is not trimmed it is required to set the first parameter of the period in that direction. the algorithm will make the shape fit into the period. //! before calling this method, the shape has to be set to be periodic in this direction. //! @param thedirectionid [in] the direction's id; @param theistrimmed [in] the flag defining trimming of the shape in given direction; @param thefirst [in] the first periodic parameter in the given direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetTrimmed(self, *args)

    def SetXTrimmed(self, *args):
        r"""

        Parameters
        ----------
        theIsTrimmed: bool
        theFirst: bool (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Defines whether the input shape is already trimmed in x direction to fit the x period. if the shape is not trimmed it is required to set the first parameter for the x period. the algorithm will make the shape fit into the period. //! before calling this method, the shape has to be set to be periodic in this direction. //! @param theistrimmed [in] flag defining whether the shape is already trimmed  in x direction to fit the x period; @param thefirst [in] the first x periodic parameter.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetXTrimmed(self, *args)

    def SetYTrimmed(self, *args):
        r"""

        Parameters
        ----------
        theIsTrimmed: bool
        theFirst: bool (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Defines whether the input shape is already trimmed in y direction to fit the y period. if the shape is not trimmed it is required to set the first parameter for the y period. the algorithm will make the shape fit into the period. //! before calling this method, the shape has to be set to be periodic in this direction. //! @param theistrimmed [in] flag defining whether the shape is already trimmed  in y direction to fit the y period; @param thefirst [in] the first y periodic parameter.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetYTrimmed(self, *args)

    def SetZTrimmed(self, *args):
        r"""

        Parameters
        ----------
        theIsTrimmed: bool
        theFirst: bool (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Defines whether the input shape is already trimmed in z direction to fit the z period. if the shape is not trimmed it is required to set the first parameter for the z period. the algorithm will make the shape fit into the period. //! before calling this method, the shape has to be set to be periodic in this direction. //! @param theistrimmed [in] flag defining whether the shape is already trimmed  in z direction to fit the z period; @param thefirst [in] the first z periodic parameter.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_SetZTrimmed(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the resulting periodic shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_Shape(self, *args)

    @staticmethod
    def ToDirectionID(*args):
        r"""

        Parameters
        ----------
        theDirectionID: int

        Return
        -------
        int

        Description
        -----------
        Converts the integer to id of periodic direction.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_ToDirectionID(*args)

    def XPeriod(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the xperiod of the shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_XPeriod(self, *args)

    def XPeriodFirst(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the first parameter for the x period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_XPeriodFirst(self, *args)

    def XRepeat(self, *args):
        r"""

        Parameters
        ----------
        theTimes: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Repeats the shape in x direction specified number of times. negative value of times means that the repetition should be perform in negative x direction. makes the repeated shape a base for following repetitions. //! @param thetimes [in] requested number of repetitions.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_XRepeat(self, *args)

    def YPeriod(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the yperiod of the shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_YPeriod(self, *args)

    def YPeriodFirst(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the first parameter for the y period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_YPeriodFirst(self, *args)

    def YRepeat(self, *args):
        r"""

        Parameters
        ----------
        theTimes: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Repeats the shape in y direction specified number of times. negative value of times means that the repetition should be perform in negative y direction. makes the repeated shape a base for following repetitions. //! @param thetimes [in] requested number of repetitions.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_YRepeat(self, *args)

    def ZPeriod(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the zperiod of the shape.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_ZPeriod(self, *args)

    def ZPeriodFirst(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the first parameter for the z period.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_ZPeriodFirst(self, *args)

    def ZRepeat(self, *args):
        r"""

        Parameters
        ----------
        theTimes: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Repeats the shape in z direction specified number of times. negative value of times means that the repetition should be perform in negative z direction. makes the repeated shape a base for following repetitions. //! @param thetimes [in] requested number of repetitions.

        """
        return _BOPAlgo.BOPAlgo_MakePeriodic_ZRepeat(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_MakePeriodic

# Register BOPAlgo_MakePeriodic in _BOPAlgo:
_BOPAlgo.BOPAlgo_MakePeriodic_swigregister(BOPAlgo_MakePeriodic)
class BOPAlgo_ArgumentAnalyzer(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_ArgumentAnalyzer_swiginit(self, _BOPAlgo.new_BOPAlgo_ArgumentAnalyzer(*args))

    def GetArgumentTypeMode(self):
        r"""GetArgumentTypeMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetArgumentTypeMode(self)

    def SetArgumentTypeMode(self, value):
        r"""SetArgumentTypeMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetArgumentTypeMode(self, value)

    def GetContinuityMode(self):
        r"""GetContinuityMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetContinuityMode(self)

    def SetContinuityMode(self, value):
        r"""SetContinuityMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetContinuityMode(self, value)

    def GetCurveOnSurfaceMode(self):
        r"""GetCurveOnSurfaceMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetCurveOnSurfaceMode(self)

    def SetCurveOnSurfaceMode(self, value):
        r"""SetCurveOnSurfaceMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetCurveOnSurfaceMode(self, value)

    def GetCheckResult(self, *args):
        r"""
        Return
        -------
        BOPAlgo_ListOfCheckResult

        Description
        -----------
        Returns a result of test.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetCheckResult(self, *args)

    def GetShape1(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns object shape;.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetShape1(self, *args)

    def GetShape2(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns tool shape.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetShape2(self, *args)

    def HasFaulty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Result of test.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_HasFaulty(self, *args)

    def GetMergeEdgeMode(self):
        r"""GetMergeEdgeMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetMergeEdgeMode(self)

    def SetMergeEdgeMode(self, value):
        r"""SetMergeEdgeMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetMergeEdgeMode(self, value)

    def GetMergeVertexMode(self):
        r"""GetMergeVertexMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetMergeVertexMode(self)

    def SetMergeVertexMode(self, value):
        r"""SetMergeVertexMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetMergeVertexMode(self, value)

    def OperationType(self, *args):
        r"""
        Return
        -------
        BOPAlgo_Operation

        Description
        -----------
        Returns ref.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_OperationType(self, *args)

    def GetRebuildFaceMode(self):
        r"""GetRebuildFaceMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetRebuildFaceMode(self)

    def SetRebuildFaceMode(self, value):
        r"""SetRebuildFaceMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetRebuildFaceMode(self, value)

    def GetSelfInterMode(self):
        r"""GetSelfInterMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetSelfInterMode(self)

    def SetSelfInterMode(self, value):
        r"""SetSelfInterMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetSelfInterMode(self, value)

    def SetShape1(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets object shape.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetShape1(self, *args)

    def SetShape2(self, *args):
        r"""

        Parameters
        ----------
        TheShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets tool shape.

        """
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetShape2(self, *args)

    def GetSmallEdgeMode(self):
        r"""GetSmallEdgeMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetSmallEdgeMode(self)

    def SetSmallEdgeMode(self, value):
        r"""SetSmallEdgeMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetSmallEdgeMode(self, value)

    def GetStopOnFirstFaulty(self):
        r"""GetStopOnFirstFaulty(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetStopOnFirstFaulty(self)

    def SetStopOnFirstFaulty(self, value):
        r"""SetStopOnFirstFaulty(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetStopOnFirstFaulty(self, value)

    def GetTangentMode(self):
        r"""GetTangentMode(BOPAlgo_ArgumentAnalyzer self) -> Standard_Boolean"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_GetTangentMode(self)

    def SetTangentMode(self, value):
        r"""SetTangentMode(BOPAlgo_ArgumentAnalyzer self, Standard_Boolean value)"""
        return _BOPAlgo.BOPAlgo_ArgumentAnalyzer_SetTangentMode(self, value)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_ArgumentAnalyzer

# Register BOPAlgo_ArgumentAnalyzer in _BOPAlgo:
_BOPAlgo.BOPAlgo_ArgumentAnalyzer_swigregister(BOPAlgo_ArgumentAnalyzer)
class BOPAlgo_BuilderArea(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Areas(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the found areas.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_Areas(self, *args)

    def IsAvoidInternalShapes(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the avoidinternalshapes flag.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_IsAvoidInternalShapes(self, *args)

    def Loops(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the found loops.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_Loops(self, *args)

    def SetAvoidInternalShapes(self, *args):
        r"""

        Parameters
        ----------
        theAvoidInternal: bool

        Return
        -------
        None

        Description
        -----------
        Defines the preventing of addition of internal parts into result. the default value is false, i.e. the internal parts are added into result.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_SetAvoidInternalShapes(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        theContext: IntTools_Context

        Return
        -------
        None

        Description
        -----------
        Sets the context for the algorithms.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_SetContext(self, *args)

    def SetShapes(self, *args):
        r"""

        Parameters
        ----------
        theLS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sets the shapes for building areas.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_SetShapes(self, *args)

    def Shapes(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the input shapes.

        """
        return _BOPAlgo.BOPAlgo_BuilderArea_Shapes(self, *args)

    __repr__ = _dumps_object


# Register BOPAlgo_BuilderArea in _BOPAlgo:
_BOPAlgo.BOPAlgo_BuilderArea_swigregister(BOPAlgo_BuilderArea)
class BOPAlgo_BuilderShape(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Generated(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of shapes generated from the shape thes.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_Generated(self, *args)

    def HasDeleted(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if any of the input shapes has been deleted during operation.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_HasDeleted(self, *args)

    def HasGenerated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if any of the input shapes has generated shapes during operation.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_HasGenerated(self, *args)

    def HasHistory(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns flag of history availability.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_HasHistory(self, *args)

    def HasModified(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if any of the input shapes has been modified during operation.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_HasModified(self, *args)

    def History(self, *args):
        r"""
        Return
        -------
        opencascade::handle<BRepTools_History>

        Description
        -----------
        History tool.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_History(self, *args)

    def IsDeleted(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if the shape thes has been deleted. in this case the shape will have no modified elements, but can have generated elements.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_IsDeleted(self, *args)

    def Modified(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of shapes modified from the shape thes.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_Modified(self, *args)

    def SetToFillHistory(self, *args):
        r"""

        Parameters
        ----------
        theHistFlag: bool

        Return
        -------
        None

        Description
        -----------
        Allows disabling the history collection.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_SetToFillHistory(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the result of algorithm.

        """
        return _BOPAlgo.BOPAlgo_BuilderShape_Shape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_BuilderShape

# Register BOPAlgo_BuilderShape in _BOPAlgo:
_BOPAlgo.BOPAlgo_BuilderShape_swigregister(BOPAlgo_BuilderShape)
class BOPAlgo_ParallelAlgo(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetProgressRange(self, *args):
        r"""

        Parameters
        ----------
        theRange: Message_ProgressRange

        Return
        -------
        None

        Description
        -----------
        Sets the range for a single run.

        """
        return _BOPAlgo.BOPAlgo_ParallelAlgo_SetProgressRange(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Perform(self):
    	pass

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_ParallelAlgo

# Register BOPAlgo_ParallelAlgo in _BOPAlgo:
_BOPAlgo.BOPAlgo_ParallelAlgo_swigregister(BOPAlgo_ParallelAlgo)
class BOPAlgo_PaveFiller(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_PaveFiller_swiginit(self, _BOPAlgo.new_BOPAlgo_PaveFiller(*args))

    def AddArgument(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the argument for operation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_AddArgument(self, *args)

    def Arguments(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of arguments.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_Arguments(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IntTools_Context>

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_Context(self, *args)

    def DS(self, *args):
        r"""
        Return
        -------
        BOPDS_DS

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_DS(self, *args)

    def Glue(self, *args):
        r"""
        Return
        -------
        BOPAlgo_GlueEnum

        Description
        -----------
        Returns the glue option of the algorithm.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_Glue(self, *args)

    def IsAvoidBuildPCurve(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag to avoid building of p-curves of edges on faces.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_IsAvoidBuildPCurve(self, *args)

    def NonDestructive(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag that defines the mode of treatment. in non-destructive mode the argument shapes are not modified. instead a copy of a sub-shape is created in the result if it is needed to be updated.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_NonDestructive(self, *args)

    def PDS(self, *args):
        r"""
        Return
        -------
        BOPDS_PDS

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_PDS(self, *args)

    def SetArguments(self, *args):
        r"""

        Parameters
        ----------
        theLS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sets the arguments for operation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_SetArguments(self, *args)

    def SetAvoidBuildPCurve(self, *args):
        r"""

        Parameters
        ----------
        theValue: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag to avoid building of p-curves of edges on faces.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_SetAvoidBuildPCurve(self, *args)

    def SetGlue(self, *args):
        r"""

        Parameters
        ----------
        theGlue: BOPAlgo_GlueEnum

        Return
        -------
        None

        Description
        -----------
        Sets the glue option for the algorithm.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_SetGlue(self, *args)

    def SetNonDestructive(self, *args):
        r"""

        Parameters
        ----------
        theFlag: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag that defines the mode of treatment. in non-destructive mode the argument shapes are not modified. instead a copy of a sub-shape is created in the result if it is needed to be updated.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_SetNonDestructive(self, *args)

    def SetSectionAttribute(self, *args):
        r"""

        Parameters
        ----------
        theSecAttr: BOPAlgo_SectionAttribute

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_PaveFiller_SetSectionAttribute(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Iterator(self):
    	pass

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_PaveFiller

# Register BOPAlgo_PaveFiller in _BOPAlgo:
_BOPAlgo.BOPAlgo_PaveFiller_swigregister(BOPAlgo_PaveFiller)
class BOPAlgo_ShellSplitter(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _BOPAlgo.BOPAlgo_ShellSplitter_swiginit(self, _BOPAlgo.new_BOPAlgo_ShellSplitter(*args))

    def AddStartElement(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds a face <thes> to process.

        """
        return _BOPAlgo.BOPAlgo_ShellSplitter_AddStartElement(self, *args)

    def Shells(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the loops.

        """
        return _BOPAlgo.BOPAlgo_ShellSplitter_Shells(self, *args)

    @staticmethod
    def SplitBlock(*args):
        r"""

        Parameters
        ----------
        theCB: BOPTools_ConnexityBlock

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_ShellSplitter_SplitBlock(*args)

    def StartElements(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Return the faces to process.

        """
        return _BOPAlgo.BOPAlgo_ShellSplitter_StartElements(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_ShellSplitter

# Register BOPAlgo_ShellSplitter in _BOPAlgo:
_BOPAlgo.BOPAlgo_ShellSplitter_swigregister(BOPAlgo_ShellSplitter)
class BOPAlgo_WireSplitter(BOPAlgo_Algo):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_WireSplitter_swiginit(self, _BOPAlgo.new_BOPAlgo_WireSplitter(*args))

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IntTools_Context>

        Description
        -----------
        Returns the context.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_Context(self, *args)

    @staticmethod
    def MakeWire(*args):
        r"""

        Parameters
        ----------
        theLE: TopTools_ListOfShape
        theW: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_MakeWire(*args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        theContext: IntTools_Context

        Return
        -------
        None

        Description
        -----------
        Sets the context for the algorithm.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_SetContext(self, *args)

    def SetWES(self, *args):
        r"""

        Parameters
        ----------
        theWES: BOPAlgo_WireEdgeSet

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_SetWES(self, *args)

    @staticmethod
    def SplitBlock(*args):
        r"""

        Parameters
        ----------
        theF: TopoDS_Face
        theCB: BOPTools_ConnexityBlock
        theContext: IntTools_Context

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_SplitBlock(*args)

    def WES(self, *args):
        r"""
        Return
        -------
        BOPAlgo_WireEdgeSet

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_WireSplitter_WES(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_WireSplitter

# Register BOPAlgo_WireSplitter in _BOPAlgo:
_BOPAlgo.BOPAlgo_WireSplitter_swigregister(BOPAlgo_WireSplitter)
class BOPAlgo_Builder(BOPAlgo_BuilderShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_Builder_swiginit(self, _BOPAlgo.new_BOPAlgo_Builder(*args))

    def AddArgument(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the argument to the operation.

        """
        return _BOPAlgo.BOPAlgo_Builder_AddArgument(self, *args)

    def Arguments(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of arguments.

        """
        return _BOPAlgo.BOPAlgo_Builder_Arguments(self, *args)

    def BuildBOP(self, *args):
        r"""

        Parameters
        ----------
        theObjects: TopTools_ListOfShape
        theObjState: TopAbs_State
        theTools: TopTools_ListOfShape
        theToolsState: TopAbs_State
        theRange: Message_ProgressRange
        theReport: Message_Report (optional, default to NULL)

        Return
        -------
        None

        Description
        -----------
        Builds the result shape according to the given states for the objects and tools. these states can be unambiguously converted into the boolean operation type. thus, it performs the boolean operation on the given groups of shapes. //! the result is built basing on the result of builder operation (gf or any other). the only condition for the builder is that the splits of faces should be created and classified relatively solids. //! the method uses classification approach for choosing the faces which will participate in building the result shape: - all faces from each group having the given state for the opposite group will be taken into result. //! such approach shows better results (in comparison with bopalgo_buildersolid approach) when working with open solids. however, the result may not be always correct on such data (at least, not as expected) as the correct classification of the faces relatively open solids is not always possible and may vary depending on the chosen classification point on the face. //! history is not created for the solids in this method. //! to avoid pollution of the report of builder algorithm, there is a possibility to pass the different report to collect the alerts of the method only. but, if the new report is not given, the builder report will be used. so, even if builder passed without any errors, but some error has been stored into its report in this method, for the following calls the builder report must be cleared. //! the method may set the following errors: - bopalgo_alertbuilderfailed - building operation has not been performed yet or failed; - bopalgo_alertbopnotset - invalid bop type is given (common/fuse/cut/cut21 are supported); - bopalgo_alerttoofewarguments - arguments are not given; - bopalgo_alertunknownshape - the shape is unknown for the operation. //! parameters: @param theobjects - the group of objects for bop; @param theobjstate - state for objects faces to pass into result; @param thetools - the group of tools for bop; @param thetoolsstate - state for tools faces to pass into result; @param thereport - the alternative report to avoid pollution of the main one.

        Parameters
        ----------
        theObjects: TopTools_ListOfShape
        theTools: TopTools_ListOfShape
        theOperation: BOPAlgo_Operation
        theRange: Message_ProgressRange
        theReport: Message_Report (optional, default to NULL)

        Return
        -------
        None

        Description
        -----------
        Builds the result of boolean operation of given type basing on the result of builder operation (gf or any other). //! the method converts the given type of operation into the states for the objects and tools required for their face to pass into result and performs the call to the same method, but with states instead of operation type. //! the conversion looks as follows: - common is built from the faces of objects located in any of the tools and vice versa. - fuse is built from the faces out of all given shapes; - cut is built from the faces of the objects out of the tools and faces of the tools located in solids of the objects. //! @param theobjects - the group of objects for bop; @param thetools - the group of tools for bop; @param theoperation - the bop type; @param therange - the parameter to progressindicator @param thereport - the alternative report to avoid pollution of the global one.

        """
        return _BOPAlgo.BOPAlgo_Builder_BuildBOP(self, *args)

    def CheckInverted(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag defining whether the check for input solids on inverted status should be performed or not.

        """
        return _BOPAlgo.BOPAlgo_Builder_CheckInverted(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IntTools_Context>

        Description
        -----------
        Returns the context, tool for cashing heavy algorithms.

        """
        return _BOPAlgo.BOPAlgo_Builder_Context(self, *args)

    def Glue(self, *args):
        r"""
        Return
        -------
        BOPAlgo_GlueEnum

        Description
        -----------
        Returns the glue option of the algorithm.

        """
        return _BOPAlgo.BOPAlgo_Builder_Glue(self, *args)

    def Images(self, *args):
        r"""
        Return
        -------
        TopTools_DataMapOfShapeListOfShape

        Description
        -----------
        Returns the map of images.

        """
        return _BOPAlgo.BOPAlgo_Builder_Images(self, *args)

    def NonDestructive(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag that defines the mode of treatment. in non-destructive mode the argument shapes are not modified. instead a copy of a sub-shape is created in the result if it is needed to be updated.

        """
        return _BOPAlgo.BOPAlgo_Builder_NonDestructive(self, *args)

    def Origins(self, *args):
        r"""
        Return
        -------
        TopTools_DataMapOfShapeListOfShape

        Description
        -----------
        Returns the map of origins.

        """
        return _BOPAlgo.BOPAlgo_Builder_Origins(self, *args)

    def PDS(self, *args):
        r"""
        Return
        -------
        BOPDS_PDS

        Description
        -----------
        Returns the data structure, holder of intersection information.

        """
        return _BOPAlgo.BOPAlgo_Builder_PDS(self, *args)

    def PPaveFiller(self, *args):
        r"""
        Return
        -------
        BOPAlgo_PPaveFiller

        Description
        -----------
        Returns the pavefiller, algorithm for sub-shapes intersection.

        """
        return _BOPAlgo.BOPAlgo_Builder_PPaveFiller(self, *args)

    def PerformWithFiller(self, *args):
        r"""

        Parameters
        ----------
        theFiller: BOPAlgo_PaveFiller
        theRange: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        None

        Description
        -----------
        Performs the operation with the prepared filler. the intersection will not be performed in this case.

        """
        return _BOPAlgo.BOPAlgo_Builder_PerformWithFiller(self, *args)

    def SetArguments(self, *args):
        r"""

        Parameters
        ----------
        theLS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Sets the list of arguments for the operation.

        """
        return _BOPAlgo.BOPAlgo_Builder_SetArguments(self, *args)

    def SetCheckInverted(self, *args):
        r"""

        Parameters
        ----------
        theCheck: bool

        Return
        -------
        None

        Description
        -----------
        Enables/disables the check of the input solids for inverted status.

        """
        return _BOPAlgo.BOPAlgo_Builder_SetCheckInverted(self, *args)

    def SetGlue(self, *args):
        r"""

        Parameters
        ----------
        theGlue: BOPAlgo_GlueEnum

        Return
        -------
        None

        Description
        -----------
        Sets the glue option for the algorithm.

        """
        return _BOPAlgo.BOPAlgo_Builder_SetGlue(self, *args)

    def SetNonDestructive(self, *args):
        r"""

        Parameters
        ----------
        theFlag: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag that defines the mode of treatment. in non-destructive mode the argument shapes are not modified. instead a copy of a sub-shape is created in the result if it is needed to be updated. this flag is taken into account if internal pavefiller is used only. in the case of calling performwithfiller the corresponding flag of that pavefiller is in force.

        """
        return _BOPAlgo.BOPAlgo_Builder_SetNonDestructive(self, *args)

    def ShapesSD(self, *args):
        r"""
        Return
        -------
        TopTools_DataMapOfShapeShape

        Description
        -----------
        Returns the map of same domain (sd) shapes - coinciding shapes from different arguments.

        """
        return _BOPAlgo.BOPAlgo_Builder_ShapesSD(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_Builder

# Register BOPAlgo_Builder in _BOPAlgo:
_BOPAlgo.BOPAlgo_Builder_swigregister(BOPAlgo_Builder)
class BOPAlgo_BuilderFace(BOPAlgo_BuilderArea):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_BuilderFace_swiginit(self, _BOPAlgo.new_BOPAlgo_BuilderFace(*args))

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns the face generatix.

        """
        return _BOPAlgo.BOPAlgo_BuilderFace_Face(self, *args)

    def Orientation(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_BuilderFace_Orientation(self, *args)

    def SetFace(self, *args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Sets the face generatix.

        """
        return _BOPAlgo.BOPAlgo_BuilderFace_SetFace(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_BuilderFace

# Register BOPAlgo_BuilderFace in _BOPAlgo:
_BOPAlgo.BOPAlgo_BuilderFace_swigregister(BOPAlgo_BuilderFace)
class BOPAlgo_BuilderSolid(BOPAlgo_BuilderArea):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        Constructor with allocator.

        """
        _BOPAlgo.BOPAlgo_BuilderSolid_swiginit(self, _BOPAlgo.new_BOPAlgo_BuilderSolid(*args))

    def GetBoxesMap(self, *args):
        r"""
        Return
        -------
        TopTools_DataMapOfShapeBox

        Description
        -----------
        For classification purposes the algorithm builds the bounding boxes for all created solids. this method returns the data map of solid - box pairs.

        """
        return _BOPAlgo.BOPAlgo_BuilderSolid_GetBoxesMap(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_BuilderSolid

# Register BOPAlgo_BuilderSolid in _BOPAlgo:
_BOPAlgo.BOPAlgo_BuilderSolid_swigregister(BOPAlgo_BuilderSolid)
class BOPAlgo_CheckerSI(BOPAlgo_PaveFiller):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_CheckerSI_swiginit(self, _BOPAlgo.new_BOPAlgo_CheckerSI(*args))

    def SetLevelOfCheck(self, *args):
        r"""

        Parameters
        ----------
        theLevel: int

        Return
        -------
        None

        Description
        -----------
        Sets the level of checking shape on self-interference. it defines which interferences will be checked: 0 - only v/v; 1 - v/v and v/e; 2 - v/v, v/e and e/e; 3 - v/v, v/e, e/e and v/f; 4 - v/v, v/e, e/e, v/f and e/f; 5 - v/v, v/e, e/e, v/f, e/f and f/f; 6 - v/v, v/e, e/e, v/f, e/f, f/f and v/s; 7 - v/v, v/e, e/e, v/f, e/f, f/f, v/s and e/s; 8 - v/v, v/e, e/e, v/f, e/f, f/f, v/s, e/s and f/s; 9 - v/v, v/e, e/e, v/f, e/f, f/f, v/s, e/s, f/s and s/s - all interferences (default value).

        """
        return _BOPAlgo.BOPAlgo_CheckerSI_SetLevelOfCheck(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_CheckerSI

# Register BOPAlgo_CheckerSI in _BOPAlgo:
_BOPAlgo.BOPAlgo_CheckerSI_swigregister(BOPAlgo_CheckerSI)
class BOPAlgo_RemoveFeatures(BOPAlgo_BuilderShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_RemoveFeatures_swiginit(self, _BOPAlgo.new_BOPAlgo_RemoveFeatures(*args))

    def AddFaceToRemove(self, *args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds the face to remove from the input shape. @param theface [in] the shape to extract the faces for removal.

        """
        return _BOPAlgo.BOPAlgo_RemoveFeatures_AddFaceToRemove(self, *args)

    def AddFacesToRemove(self, *args):
        r"""

        Parameters
        ----------
        theFaces: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Adds the faces to remove from the input shape. @param thefaces [in] the list of shapes to extract the faces for removal.

        """
        return _BOPAlgo.BOPAlgo_RemoveFeatures_AddFacesToRemove(self, *args)

    def FacesToRemove(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of faces which have been requested for removal from the input shape.

        """
        return _BOPAlgo.BOPAlgo_RemoveFeatures_FacesToRemove(self, *args)

    def InputShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the input shape.

        """
        return _BOPAlgo.BOPAlgo_RemoveFeatures_InputShape(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets the shape for processing. @param theshape [in] the shape to remove the faces from.  it should either be the solid, compsolid or compound of solids.

        """
        return _BOPAlgo.BOPAlgo_RemoveFeatures_SetShape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_RemoveFeatures

# Register BOPAlgo_RemoveFeatures in _BOPAlgo:
_BOPAlgo.BOPAlgo_RemoveFeatures_swigregister(BOPAlgo_RemoveFeatures)
class BOPAlgo_CellsBuilder(BOPAlgo_Builder):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_CellsBuilder_swiginit(self, _BOPAlgo.new_BOPAlgo_CellsBuilder(*args))

    def AddAllToResult(self, *args):
        r"""

        Parameters
        ----------
        theMaterial: int (optional, default to 0)
        theUpdate: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Add all split parts to result. <thematerial> defines the removal of internal boundaries; <theupdate> parameter defines whether to remove boundaries now or not.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_AddAllToResult(self, *args)

    def AddToResult(self, *args):
        r"""

        Parameters
        ----------
        theLSToTake: TopTools_ListOfShape
        theLSToAvoid: TopTools_ListOfShape
        theMaterial: int (optional, default to 0)
        theUpdate: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Adding the parts to result. the parts are defined by two lists of shapes: <thelstotake> defines the arguments which parts should be taken into result; <thelstoavoid> defines the arguments which parts should not be taken into result; to be taken into result the part must be in for all shapes from the list <thelstotake> and must be out of all shapes from the list <thelstoavoid>. to remove internal boundaries between any cells in the result <thematerial> variable should be used. the boundaries between cells with the same material will be removed. default value is 0. thus, to remove any boundary the value of this variable should not be equal to 0. <theupdate> parameter defines whether to remove boundaries now or not.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_AddToResult(self, *args)

    def GetAllParts(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Get all split parts.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_GetAllParts(self, *args)

    def MakeContainers(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Makes the containers of proper type from the parts added to result.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_MakeContainers(self, *args)

    def RemoveAllFromResult(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Remove all parts from result.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_RemoveAllFromResult(self, *args)

    def RemoveFromResult(self, *args):
        r"""

        Parameters
        ----------
        theLSToTake: TopTools_ListOfShape
        theLSToAvoid: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Removing the parts from result. the parts are defined by two lists of shapes: <thelstotake> defines the arguments which parts should be removed from result; <thelstoavoid> defines the arguments which parts should not be removed from result. to be removed from the result the part must be in for all shapes from the list <thelstotake> and must be out of all shapes from the list <thelstoavoid>.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_RemoveFromResult(self, *args)

    def RemoveInternalBoundaries(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Removes internal boundaries between cells with the same material. if the result contains the cells with same material but of different dimension the removal of internal boundaries between these cells will not be performed. in case of some errors during the removal the method will set the appropriate warning status - use getreport() to access them.

        """
        return _BOPAlgo.BOPAlgo_CellsBuilder_RemoveInternalBoundaries(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_CellsBuilder

# Register BOPAlgo_CellsBuilder in _BOPAlgo:
_BOPAlgo.BOPAlgo_CellsBuilder_swigregister(BOPAlgo_CellsBuilder)
class BOPAlgo_MakerVolume(BOPAlgo_Builder):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _BOPAlgo.BOPAlgo_MakerVolume_swiginit(self, _BOPAlgo.new_BOPAlgo_MakerVolume(*args))

    def Box(self, *args):
        r"""
        Return
        -------
        TopoDS_Solid

        Description
        -----------
        Returns the solid box <mysbox>.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_Box(self, *args)

    def Faces(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the processed faces <myfaces>.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_Faces(self, *args)

    def IsAvoidInternalShapes(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the avoidinternalshapes flag.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_IsAvoidInternalShapes(self, *args)

    def IsIntersect(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the flag <myintersect>.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_IsIntersect(self, *args)

    def SetAvoidInternalShapes(self, *args):
        r"""

        Parameters
        ----------
        theAvoidInternal: bool

        Return
        -------
        None

        Description
        -----------
        Defines the preventing of addition of internal for solid parts into the result. by default the internal parts are added into result.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_SetAvoidInternalShapes(self, *args)

    def SetIntersect(self, *args):
        r"""

        Parameters
        ----------
        bIntersect: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag myintersect: if <bintersect> is true the shapes from <myarguments> will be intersected. if <bintersect> is false no intersection will be done.

        """
        return _BOPAlgo.BOPAlgo_MakerVolume_SetIntersect(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_MakerVolume

# Register BOPAlgo_MakerVolume in _BOPAlgo:
_BOPAlgo.BOPAlgo_MakerVolume_swigregister(BOPAlgo_MakerVolume)
class BOPAlgo_Section(BOPAlgo_Builder):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        Constructor with allocator.

        """
        _BOPAlgo.BOPAlgo_Section_swiginit(self, _BOPAlgo.new_BOPAlgo_Section(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_Section

# Register BOPAlgo_Section in _BOPAlgo:
_BOPAlgo.BOPAlgo_Section_swigregister(BOPAlgo_Section)
class BOPAlgo_ToolsProvider(BOPAlgo_Builder):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_ToolsProvider_swiginit(self, _BOPAlgo.new_BOPAlgo_ToolsProvider(*args))

    def AddTool(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds tool argument of the operation.

        """
        return _BOPAlgo.BOPAlgo_ToolsProvider_AddTool(self, *args)

    def SetTools(self, *args):
        r"""

        Parameters
        ----------
        theShapes: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Adds the tool arguments of the operation.

        """
        return _BOPAlgo.BOPAlgo_ToolsProvider_SetTools(self, *args)

    def Tools(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the tool arguments of the operation.

        """
        return _BOPAlgo.BOPAlgo_ToolsProvider_Tools(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_ToolsProvider

# Register BOPAlgo_ToolsProvider in _BOPAlgo:
_BOPAlgo.BOPAlgo_ToolsProvider_swigregister(BOPAlgo_ToolsProvider)
class BOPAlgo_BOP(BOPAlgo_ToolsProvider):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_BOP_swiginit(self, _BOPAlgo.new_BOPAlgo_BOP(*args))

    def Operation(self, *args):
        r"""
        Return
        -------
        BOPAlgo_Operation

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_BOP_Operation(self, *args)

    def SetOperation(self, *args):
        r"""

        Parameters
        ----------
        theOperation: BOPAlgo_Operation

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BOPAlgo.BOPAlgo_BOP_SetOperation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_BOP

# Register BOPAlgo_BOP in _BOPAlgo:
_BOPAlgo.BOPAlgo_BOP_swigregister(BOPAlgo_BOP)
class BOPAlgo_Splitter(BOPAlgo_ToolsProvider):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theAllocator: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BOPAlgo.BOPAlgo_Splitter_swiginit(self, _BOPAlgo.new_BOPAlgo_Splitter(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BOPAlgo.delete_BOPAlgo_Splitter

# Register BOPAlgo_Splitter in _BOPAlgo:
_BOPAlgo.BOPAlgo_Splitter_swigregister(BOPAlgo_Splitter)



@deprecated
def BOPAlgo_Options_GetParallelMode(*args):
	return BOPAlgo_Options.GetParallelMode(*args)

@deprecated
def BOPAlgo_Options_SetParallelMode(*args):
	return BOPAlgo_Options.SetParallelMode(*args)

@deprecated
def BOPAlgo_Tools_ClassifyFaces(*args):
	return BOPAlgo_Tools.ClassifyFaces(*args)

@deprecated
def BOPAlgo_Tools_ComputeToleranceOfCB(*args):
	return BOPAlgo_Tools.ComputeToleranceOfCB(*args)

@deprecated
def BOPAlgo_Tools_EdgesToWires(*args):
	return BOPAlgo_Tools.EdgesToWires(*args)

@deprecated
def BOPAlgo_Tools_FillInternals(*args):
	return BOPAlgo_Tools.FillInternals(*args)

@deprecated
def BOPAlgo_Tools_IntersectVertices(*args):
	return BOPAlgo_Tools.IntersectVertices(*args)

@deprecated
def BOPAlgo_Tools_PerformCommonBlocks(*args):
	return BOPAlgo_Tools.PerformCommonBlocks(*args)

@deprecated
def BOPAlgo_Tools_PerformCommonBlocks(*args):
	return BOPAlgo_Tools.PerformCommonBlocks(*args)

@deprecated
def BOPAlgo_Tools_TrsfToPoint(*args):
	return BOPAlgo_Tools.TrsfToPoint(*args)

@deprecated
def BOPAlgo_Tools_WiresToFaces(*args):
	return BOPAlgo_Tools.WiresToFaces(*args)

@deprecated
def BOPAlgo_MakePeriodic_ToDirectionID(*args):
	return BOPAlgo_MakePeriodic.ToDirectionID(*args)

@deprecated
def BOPAlgo_ShellSplitter_SplitBlock(*args):
	return BOPAlgo_ShellSplitter.SplitBlock(*args)

@deprecated
def BOPAlgo_WireSplitter_MakeWire(*args):
	return BOPAlgo_WireSplitter.MakeWire(*args)

@deprecated
def BOPAlgo_WireSplitter_SplitBlock(*args):
	return BOPAlgo_WireSplitter.SplitBlock(*args)



