# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepAlgo module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_brepalgo.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepAlgo
else:
    import _BRepAlgo

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepAlgo.delete_SwigPyIterator

    def value(self):
        return _BRepAlgo.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepAlgo.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepAlgo.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepAlgo.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepAlgo.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepAlgo.SwigPyIterator_copy(self)

    def next(self):
        return _BRepAlgo.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepAlgo.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepAlgo.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepAlgo.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepAlgo.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepAlgo.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepAlgo.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepAlgo.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepAlgo.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepAlgo.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepAlgo:
_BRepAlgo.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepAlgo.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.GeomAbs
import OCC.Core.TopTools
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_BRepAlgo_AsDes_Create():
    return _BRepAlgo.Handle_BRepAlgo_AsDes_Create()

def Handle_BRepAlgo_AsDes_DownCast(t):
    return _BRepAlgo.Handle_BRepAlgo_AsDes_DownCast(t)

def Handle_BRepAlgo_AsDes_IsNull(t):
    return _BRepAlgo.Handle_BRepAlgo_AsDes_IsNull(t)
class brepalgo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ConcatenateWire(*args):
        r"""

        Parameters
        ----------
        Wire: TopoDS_Wire
        Option: GeomAbs_Shape
        AngularTolerance: float (optional, default to 1.0e-4)

        Return
        -------
        TopoDS_Wire

        Description
        -----------
        This method makes a wire whose edges are c1 from a wire whose edges could be g1. it removes a vertex between g1 edges. option can be g1 or c1.

        """
        return _BRepAlgo.brepalgo_ConcatenateWire(*args)

    @staticmethod
    def ConcatenateWireC0(*args):
        r"""

        Parameters
        ----------
        Wire: TopoDS_Wire

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        This method makes an edge from a wire. junction points between edges of wire may be sharp, resulting curve of the resulting edge may be c0.

        """
        return _BRepAlgo.brepalgo_ConcatenateWireC0(*args)

    @staticmethod
    def ConvertFace(*args):
        r"""

        Parameters
        ----------
        theFace: TopoDS_Face
        theAngleTolerance: float

        Return
        -------
        TopoDS_Face

        Description
        -----------
        Method of face conversion. the api corresponds to the method convertwire. this is a shortcut for calling convertwire() for each wire in theface.

        """
        return _BRepAlgo.brepalgo_ConvertFace(*args)

    @staticmethod
    def ConvertWire(*args):
        r"""

        Parameters
        ----------
        theWire: TopoDS_Wire
        theAngleTolerance: float
        theFace: TopoDS_Face

        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Method of wire conversion, calls brepalgo_approx internally. @param thewire input wire object. @param theangletolerance angle (in radians) defining the continuity of the wire: if two vectors differ by less than this angle, the result will be smooth (zero angle of tangent lines between curve elements). return the new topods_wire object consisting of edges each representing an arc of circle or a linear segment. the accuracy of conversion is defined as the maximal tolerance of edges in thewire.

        """
        return _BRepAlgo.brepalgo_ConvertWire(*args)

    @staticmethod
    def IsTopologicallyValid(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Checks if the shape is 'correct'. if not, returns false, else returns true. this method differs from the previous one in the fact that no geometric controls (intersection of wires, pcurve validity) are performed.

        """
        return _BRepAlgo.brepalgo_IsTopologicallyValid(*args)

    @staticmethod
    def IsValid(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Checks if the shape is 'correct'. if not, returns <standard_false>, else returns <standard_true>.

        Parameters
        ----------
        theArgs: TopTools_ListOfShape
        theResult: TopoDS_Shape
        closedSolid: bool (optional, default to Standard_False)
        GeomCtrl: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        Checks if the generated and modified faces from the shapes <arguments> in the shape <result> are 'correct'. the args may be empty, then all faces will be checked. if <closed> is true, only closed shape are valid. if <geomctrl> is false the geometry of new vertices and edges are not verified and the auto-intersection of new wires are not searched.

        """
        return _BRepAlgo.brepalgo_IsValid(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepAlgo.brepalgo_swiginit(self, _BRepAlgo.new_brepalgo())
    __swig_destroy__ = _BRepAlgo.delete_brepalgo

# Register brepalgo in _BRepAlgo:
_BRepAlgo.brepalgo_swigregister(brepalgo)
class BRepAlgo_AsDes(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty asdes.

        """
        _BRepAlgo.BRepAlgo_AsDes_swiginit(self, _BRepAlgo.new_BRepAlgo_AsDes(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        SS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Stores <ss> as a futur subshape of <s>.

        Parameters
        ----------
        S: TopoDS_Shape
        SS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Stores <ss> as futurs subshapes of <s>.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Add(self, *args)

    def Ascendant(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the shape containing <s>.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Ascendant(self, *args)

    def ChangeDescendant(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns futur subhapes of <s>.

        """
        return _BRepAlgo.BRepAlgo_AsDes_ChangeDescendant(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Clear(self, *args)

    def Descendant(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns futur subhapes of <s>.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Descendant(self, *args)

    def HasAscendant(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_AsDes_HasAscendant(self, *args)

    def HasCommonDescendant(self, *args):
        r"""

        Parameters
        ----------
        S1: TopoDS_Shape
        S2: TopoDS_Shape
        LC: TopTools_ListOfShape

        Return
        -------
        bool

        Description
        -----------
        Returns true if (s1> and <s2> has common descendants. stores in <lc> the commons descendants.

        """
        return _BRepAlgo.BRepAlgo_AsDes_HasCommonDescendant(self, *args)

    def HasDescendant(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_AsDes_HasDescendant(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Remove thes from me.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Remove(self, *args)

    def Replace(self, *args):
        r"""

        Parameters
        ----------
        theOldS: TopoDS_Shape
        theNewS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Replace theolds by thenews. theolds disappear from this.

        """
        return _BRepAlgo.BRepAlgo_AsDes_Replace(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepAlgo_AsDes_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgo.delete_BRepAlgo_AsDes

# Register BRepAlgo_AsDes in _BRepAlgo:
_BRepAlgo.BRepAlgo_AsDes_swigregister(BRepAlgo_AsDes)
class BRepAlgo_FaceRestrictor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepAlgo.BRepAlgo_FaceRestrictor_swiginit(self, _BRepAlgo.new_BRepAlgo_FaceRestrictor(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Add the wire <w> to the set of wires. //! warning: the wires must be closed. //! the edges of <w> can be modified if they have not pcurves on the surface <s> of <f>. in this case if <proj> is false the first pcurve of the edge is positionned on <s>. if <proj> is true ,the pcurve on <s> is the projection of the curve 3d on <f>.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Add(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Removes all the wires.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Clear(self, *args)

    def Current(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Current(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        Proj: bool (optional, default to Standard_False)
        ControlOrientation: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The surface of <f> will be the surface of each new faces built. <proj> is used to update pcurves on edges if necessary. see add().

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_IsDone(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Next(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Evaluate all the faces limited by the set of wires.

        """
        return _BRepAlgo.BRepAlgo_FaceRestrictor_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgo.delete_BRepAlgo_FaceRestrictor

# Register BRepAlgo_FaceRestrictor in _BRepAlgo:
_BRepAlgo.BRepAlgo_FaceRestrictor_swigregister(BRepAlgo_FaceRestrictor)
class BRepAlgo_Image(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepAlgo.BRepAlgo_Image_swiginit(self, _BRepAlgo.new_BRepAlgo_Image(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        OldS: TopoDS_Shape
        NewS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Add <news> to the image of <olds>.

        Parameters
        ----------
        OldS: TopoDS_Shape
        NewS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Add <news> to the image of <olds>.

        """
        return _BRepAlgo.BRepAlgo_Image_Add(self, *args)

    def Bind(self, *args):
        r"""

        Parameters
        ----------
        OldS: TopoDS_Shape
        NewS: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Links <news> as image of <olds>.

        Parameters
        ----------
        OldS: TopoDS_Shape
        NewS: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Links <news> as image of <olds>.

        """
        return _BRepAlgo.BRepAlgo_Image_Bind(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Image_Clear(self, *args)

    def Compact(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Keeps only the link between roots and lastimage.

        """
        return _BRepAlgo.BRepAlgo_Image_Compact(self, *args)

    def Filter(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        ShapeType: TopAbs_ShapeEnum

        Return
        -------
        None

        Description
        -----------
        Deletes in the images the shape of type <shapetype> which are not in <s>. warning: compact() must be call before.

        """
        return _BRepAlgo.BRepAlgo_Image_Filter(self, *args)

    def HasImage(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Image_HasImage(self, *args)

    def Image(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the image of <s>. returns <s> in the list if hasimage(s) is false.

        """
        return _BRepAlgo.BRepAlgo_Image_Image(self, *args)

    def ImageFrom(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the generator of <s>.

        """
        return _BRepAlgo.BRepAlgo_Image_ImageFrom(self, *args)

    def IsImage(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Image_IsImage(self, *args)

    def LastImage(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        L: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Stores in <l> the images of images of...images of <s>. <l> contains only <s> if hasimage(s) is false.

        """
        return _BRepAlgo.BRepAlgo_Image_LastImage(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Remove <s> to set of images.

        """
        return _BRepAlgo.BRepAlgo_Image_Remove(self, *args)

    def RemoveRoot(self, *args):
        r"""

        Parameters
        ----------
        Root: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Removes the root <theroot> from the list of roots and up and down maps.

        """
        return _BRepAlgo.BRepAlgo_Image_RemoveRoot(self, *args)

    def ReplaceRoot(self, *args):
        r"""

        Parameters
        ----------
        OldRoot: TopoDS_Shape
        NewRoot: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Replaces the <oldroot> with the <newroot>, so all images of the <oldroot> become the images of the <newroot>. the <oldroot> is removed.

        """
        return _BRepAlgo.BRepAlgo_Image_ReplaceRoot(self, *args)

    def Root(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the upper generator of <s>.

        """
        return _BRepAlgo.BRepAlgo_Image_Root(self, *args)

    def Roots(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Image_Roots(self, *args)

    def SetRoot(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Image_SetRoot(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgo.delete_BRepAlgo_Image

# Register BRepAlgo_Image in _BRepAlgo:
_BRepAlgo.BRepAlgo_Image_swigregister(BRepAlgo_Image)
class BRepAlgo_Loop(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepAlgo.BRepAlgo_Loop_swiginit(self, _BRepAlgo.new_BRepAlgo_Loop(*args))

    def AddConstEdge(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Add <e> as const edge, e can be in the result.

        """
        return _BRepAlgo.BRepAlgo_Loop_AddConstEdge(self, *args)

    def AddConstEdges(self, *args):
        r"""

        Parameters
        ----------
        LE: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Add <le> as a set of const edges.

        """
        return _BRepAlgo.BRepAlgo_Loop_AddConstEdges(self, *args)

    def AddEdge(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        LV: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Add e with <lv>. <e> will be copied and trim by vertices in <lv>.

        """
        return _BRepAlgo.BRepAlgo_Loop_AddEdge(self, *args)

    def CutEdge(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        VonE: TopTools_ListOfShape
        NE: TopTools_ListOfShape

        Return
        -------
        None

        Description
        -----------
        Cut the edge <e> in several edges <ne> on the vertices<vone>.

        """
        return _BRepAlgo.BRepAlgo_Loop_CutEdge(self, *args)

    def GetTolConf(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Get maximal tolerance used for comparing distaces between vertices. .

        """
        return _BRepAlgo.BRepAlgo_Loop_GetTolConf(self, *args)

    def GetVerticesForSubstitute(self, *args):
        r"""

        Parameters
        ----------
        VerVerMap: TopTools_DataMapOfShapeShape

        Return
        -------
        None

        Description
        -----------
        Returns the datamap of vertices with their substitutes.

        """
        return _BRepAlgo.BRepAlgo_Loop_GetVerticesForSubstitute(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Init with <f> the set of edges must have pcurves on <f>.

        """
        return _BRepAlgo.BRepAlgo_Loop_Init(self, *args)

    def NewEdges(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of new edges built from an edge <e> it can be an empty list.

        """
        return _BRepAlgo.BRepAlgo_Loop_NewEdges(self, *args)

    def NewFaces(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of faces. warning: the method <wirestofaces> as to be called before. can be an empty list.

        """
        return _BRepAlgo.BRepAlgo_Loop_NewFaces(self, *args)

    def NewWires(self, *args):
        r"""
        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of wires performed. can be an empty list.

        """
        return _BRepAlgo.BRepAlgo_Loop_NewWires(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Make loops.

        """
        return _BRepAlgo.BRepAlgo_Loop_Perform(self, *args)

    def SetImageVV(self, *args):
        r"""

        Parameters
        ----------
        theImageVV: BRepAlgo_Image

        Return
        -------
        None

        Description
        -----------
        Sets the image vertex - vertex.

        """
        return _BRepAlgo.BRepAlgo_Loop_SetImageVV(self, *args)

    def SetTolConf(self, *args):
        r"""

        Parameters
        ----------
        theTolConf: float

        Return
        -------
        None

        Description
        -----------
        Set maximal tolerance used for comparing distaces between vertices. .

        """
        return _BRepAlgo.BRepAlgo_Loop_SetTolConf(self, *args)

    def UpdateVEmap(self, *args):
        r"""

        Parameters
        ----------
        theVEmap: TopTools_IndexedDataMapOfShapeListOfShape

        Return
        -------
        None

        Description
        -----------
        Update ve map according to image vertex - vertex.

        """
        return _BRepAlgo.BRepAlgo_Loop_UpdateVEmap(self, *args)

    def VerticesForSubstitute(self, *args):
        r"""

        Parameters
        ----------
        VerVerMap: TopTools_DataMapOfShapeShape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_Loop_VerticesForSubstitute(self, *args)

    def WiresToFaces(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Build faces from the wires result.

        """
        return _BRepAlgo.BRepAlgo_Loop_WiresToFaces(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgo.delete_BRepAlgo_Loop

# Register BRepAlgo_Loop in _BRepAlgo:
_BRepAlgo.BRepAlgo_Loop_swigregister(BRepAlgo_Loop)
class BRepAlgo_NormalProjection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepAlgo.BRepAlgo_NormalProjection_swiginit(self, _BRepAlgo.new_BRepAlgo_NormalProjection(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        ToProj: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Add an edge or a wire to the list of shape to project.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Add(self, *args)

    def Ancestor(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        For a resulting edge, returns the corresponding initial edge.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Ancestor(self, *args)

    def Build(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Builds the result as a compound.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Build(self, *args)

    def BuildWire(self, *args):
        r"""

        Parameters
        ----------
        Liste: TopTools_ListOfShape

        Return
        -------
        bool

        Description
        -----------
        Build the result as a list of wire if possible in -- a first returns a wire only if there is only a wire.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_BuildWire(self, *args)

    def Compute3d(self, *args):
        r"""

        Parameters
        ----------
        With3d: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        If with3d = standard_false the 3dcurve is not computed the initial 3dcurve is kept to build the resulting edges.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Compute3d(self, *args)

    def Couple(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        For a projected edge, returns the corresponding initial face.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Couple(self, *args)

    def Generated(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopTools_ListOfShape

        Description
        -----------
        Returns the list of shapes generated from the shape <s>.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Generated(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Init(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_IsDone(self, *args)

    def IsElementary(self, *args):
        r"""

        Parameters
        ----------
        C: Adaptor3d_Curve

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_IsElementary(self, *args)

    def Projection(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the result.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_Projection(self, *args)

    def SetDefaultParams(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Set the parameters used for computation in their default values.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_SetDefaultParams(self, *args)

    def SetLimit(self, *args):
        r"""

        Parameters
        ----------
        FaceBoundaries: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Manage limitation of projected edges.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_SetLimit(self, *args)

    def SetMaxDistance(self, *args):
        r"""

        Parameters
        ----------
        MaxDist: float

        Return
        -------
        None

        Description
        -----------
        Sets the maximum distance between target shape and shape to project. if this condition is not satisfied then corresponding part of solution is discarded. if maxdist < 0 then this method does not affect the algorithm.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_SetMaxDistance(self, *args)

    def SetParams(self, *args):
        r"""

        Parameters
        ----------
        Tol3D: float
        Tol2D: float
        InternalContinuity: GeomAbs_Shape
        MaxDegree: int
        MaxSeg: int

        Return
        -------
        None

        Description
        -----------
        Set the parameters used for computation tol3d is the required tolerance between the 3d projected curve and its 2d representation internalcontinuity is the order of constraints used for approximation. maxdeg and maxseg are the maximum degree and the maximum number of segment for bspline resulting of an approximation.

        """
        return _BRepAlgo.BRepAlgo_NormalProjection_SetParams(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgo.delete_BRepAlgo_NormalProjection

# Register BRepAlgo_NormalProjection in _BRepAlgo:
_BRepAlgo.BRepAlgo_NormalProjection_swigregister(BRepAlgo_NormalProjection)



@deprecated
def brepalgo_ConcatenateWire(*args):
	return brepalgo.ConcatenateWire(*args)

@deprecated
def brepalgo_ConcatenateWireC0(*args):
	return brepalgo.ConcatenateWireC0(*args)

@deprecated
def brepalgo_ConvertFace(*args):
	return brepalgo.ConvertFace(*args)

@deprecated
def brepalgo_ConvertWire(*args):
	return brepalgo.ConvertWire(*args)

@deprecated
def brepalgo_IsTopologicallyValid(*args):
	return brepalgo.IsTopologicallyValid(*args)

@deprecated
def brepalgo_IsValid(*args):
	return brepalgo.IsValid(*args)

@deprecated
def brepalgo_IsValid(*args):
	return brepalgo.IsValid(*args)



