/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.SymmetryInterface;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKitPopup;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Font;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public class ModelKit {
    static Constraint locked = new Constraint(null, 6, null);
    static Constraint none = new Constraint(null, 0, null);
    static final int STATE_MOLECULAR = 0;
    static final int STATE_XTALVIEW = 1;
    static final int STATE_XTALEDIT = 2;
    static final int STATE_BITS_XTAL = 3;
    static final int STATE_BITS_SYM_VIEW = 28;
    static final int STATE_SYM_NONE = 0;
    static final int STATE_SYM_SHOW = 8;
    static final int STATE_BITS_SYM_EDIT = 224;
    static final int STATE_SYM_APPLYLOCAL = 32;
    static final int STATE_SYM_RETAINLOCAL = 64;
    static final int STATE_SYM_APPLYFULL = 128;
    static final int STATE_BITS_UNITCELL = 1792;
    static final int STATE_UNITCELL_PACKED = 0;
    static final int STATE_UNITCELL_EXTEND = 256;
    static final String OPTIONS_MODE = "optionsMenu";
    static final String XTAL_MODE = "xtalMenu";
    static final String BOND_MODE = "bondMenu";
    static final String ATOM_MODE = "atomMenu";
    private static final P3 Pt000 = new P3();
    private static int GET = 0;
    static int GET_CREATE = 1;
    private static int GET_DELETE = 2;
    protected Viewer vwr;
    private ModelKitPopup menu;
    int state = 0;
    private String atomHoverLabel = "C";
    private String bondHoverLabel = GT.$("increase order");
    private String[] allOperators;
    private int currentModelIndex = -1;
    protected ModelSet lastModelSet;
    private String lastElementType = "C";
    private final BS bsHighlight = new BS();
    private int bondIndex = -1;
    private int bondAtomIndex1 = -1;
    private int bondAtomIndex2 = -1;
    private BS bsRotateBranch;
    private int branchAtomIndex;
    private int[] screenXY = new int[2];
    private boolean isPickAtomAssignCharge;
    private boolean isRotateBond;
    private boolean showSymopInfo = true;
    private boolean hasUnitCell;
    private boolean alertedNoEdit;
    private boolean wasRotating;
    private boolean addHydrogens = true;
    private boolean clickToSetElement = true;
    private boolean autoBond = false;
    private P3 centerPoint;
    String pickAtomAssignType = "C";
    char pickBondAssignType = (char)112;
    P3 viewOffset;
    private float centerDistance;
    private Object symop;
    private int centerAtomIndex = -1;
    private int secondAtomIndex = -1;
    private String drawData;
    private String drawScript;
    private int iatom0;
    private String lastCenter = "0 0 0";
    private String lastOffset = "0 0 0";
    private Atom a0;
    private Atom a3;
    Constraint constraint;
    private Constraint[] atomConstraints;
    private Atom[] minBasisAtoms;
    private SymmetryInterface[] modelSyms;
    private BS minBasis;
    private BS minBasisFixed;
    private BS minBasisModelAtoms;
    private int minBasisModel;
    private BS minSelectionSaved;
    private BS minTempFixed;
    private BS minTempModelAtoms;
    private boolean setElementKeys;
    private final BS bsElementKeyModels = new BS();
    private final BS bsElementKeyModelsOFF = new BS();
    private boolean haveElementKeys;
    private Lst<DrawAtomSet> drawAtomSets;

    static String getText(String key) {
        switch ("invSter delAtom dragBon dragAto dragMin dragMol dragMMo incChar decChar rotBond bondTo0 bondTo1 bondTo2 bondTo3 incBond decBond".indexOf(key.substring(0, 7))) {
            case 0: {
                return GT.$("invert ring stereochemistry");
            }
            case 8: {
                return GT.$("delete atom");
            }
            case 16: {
                return GT.$("drag to bond");
            }
            case 24: {
                return GT.$("drag atom");
            }
            case 32: {
                return GT.$("drag atom (and minimize)");
            }
            case 40: {
                return GT.$("drag molecule (ALT to rotate)");
            }
            case 48: {
                return GT.$("drag and minimize molecule (docking)");
            }
            case 56: {
                return GT.$("increase charge");
            }
            case 64: {
                return GT.$("decrease charge");
            }
            case 72: {
                return GT.$("rotate bond");
            }
            case 80: {
                return GT.$("delete bond");
            }
            case 88: {
                return GT.$("single");
            }
            case 96: {
                return GT.$("double");
            }
            case 104: {
                return GT.$("triple");
            }
            case 112: {
                return GT.$("increase order");
            }
            case 120: {
                return GT.$("decrease order");
            }
        }
        return key;
    }

    static M4 getTransform(SymmetryInterface sym, Atom a, Atom b) {
        P3 fa = P3.newP(a);
        sym.toFractional(fa, false);
        P3 fb = P3.newP(b);
        sym.toFractional(fb, false);
        return sym.getTransform(fa, fb, true);
    }

    protected static String getElementKey(int modelIndex) {
        return "_!_elkey_" + (modelIndex < 0 ? "" : modelIndex + "_");
    }

    private static boolean isTrue(Object value) {
        return Boolean.valueOf(value.toString()) == Boolean.TRUE;
    }

    private static String keyToElement(int key) {
        int ch1 = key & 0xFF;
        int ch2 = key >> 8 & 0xFF;
        String element = "" + (char)ch1 + (ch2 == 0 ? "" : ("" + (char)ch2).toLowerCase());
        int n = Elements.elementNumberFromSymbol(element, true);
        return n == 0 ? null : element;
    }

    private static void notImplemented(String action) {
        System.err.println("ModelKit.notImplemented(" + action + ")");
    }

    private static P3 pointFromTriad(String pos) {
        float[] a = PT.parseFloatArray(PT.replaceAllCharacters(pos, "{,}", " "));
        return a.length == 3 && !Float.isNaN(a[2]) ? P3.new3(a[0], a[1], a[2]) : null;
    }

    public void actionRotateBond(int deltaX, int deltaY, int x, int y, boolean forceFull) {
        Atom atomFix;
        Atom atomMove;
        if (this.bondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        ModelSet ms = this.vwr.ms;
        Bond b = ms.bo[this.bondIndex];
        if (forceFull) {
            bsBranch = null;
            this.branchAtomIndex = -1;
        }
        if (bsBranch == null) {
            atomMove = this.branchAtomIndex == b.atom1.i ? b.atom1 : b.atom2;
            atomFix = atomMove == b.atom1 ? b.atom2 : b.atom1;
            this.vwr.undoMoveActionClear(atomFix.i, 2, true);
            if (this.branchAtomIndex >= 0) {
                bsBranch = this.vwr.getBranchBitSet(atomMove.i, atomFix.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atomFix.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atomFix.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = ms.getMoleculeBitSetForAtom(atomFix.i);
                forceFull = true;
            }
            this.bsRotateBranch = bsBranch;
            this.bondAtomIndex1 = atomFix.i;
            this.bondAtomIndex2 = atomMove.i;
        } else {
            atomFix = ms.at[this.bondAtomIndex1];
            atomMove = ms.at[this.bondAtomIndex2];
        }
        if (forceFull) {
            this.bsRotateBranch = null;
        }
        V3 v1 = V3.new3(atomMove.sX - atomFix.sX, atomMove.sY - atomFix.sY, 0.0f);
        v1.scale(1.0f / v1.length());
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float f = v1.z > 0.0f ? 1 : -1;
        float degrees = f * (float)((int)v2.length() / 2 + 1);
        if (!forceFull && this.a0 != null) {
            float ang0 = Measure.computeTorsion(this.a0, b.atom1, b.atom2, this.a3, true);
            float ang1 = Math.round(ang0 + degrees);
            degrees = ang1 - ang0;
        }
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.vwr.slm.getMotionFixedAtoms());
        this.vwr.rotateAboutPointsInternal(null, atomFix, atomMove, 0.0f, degrees, false, bs, null, null, null, null, true);
    }

    public void addLockedAtoms(SymmetryInterface sg, BS bsLocked) {
        if (this.vwr.am.cmi < 0 || bsLocked.cardinality() == 0) {
            return;
        }
        BS bsm = this.vwr.getThisModelAtoms();
        int i0 = bsLocked.nextSetBit(0);
        if (sg == null && (sg = this.getSym(i0)) == null) {
            return;
        }
        int i = bsm.nextSetBit(0);
        while (i >= 0) {
            if (this.setConstraint((SymmetryInterface)sg, (int)i, (int)ModelKit.GET_CREATE).type == 6) {
                bsLocked.set(i);
            }
            i = bsm.nextSetBit(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkMovedAtoms(BS bsFixed, BS bsAtoms, P3[] apos0) {
        int i0 = bsAtoms.nextSetBit(0);
        int n = bsAtoms.cardinality();
        P3[] apos = new P3[n];
        try {
            Atom[] atoms = this.vwr.ms.at;
            int ip = 0;
            int i = i0;
            while (i >= 0) {
                apos[ip++] = P3.newP(atoms[i]);
                atoms[i].setT(apos0[i]);
                i = bsAtoms.nextSetBit(i + 1);
            }
            int maxSite = 0;
            i = i0;
            while (i >= 0) {
                int s = this.vwr.ms.at[i].getAtomSite();
                if (s > maxSite) {
                    maxSite = s;
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
            int[] sites = new int[maxSite];
            P3 p1 = new P3();
            BS bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
            BS bsMoved = new BS();
            int ip2 = 0;
            int i2 = i0;
            while (i2 >= 0) {
                p1.setT(apos[ip2]);
                int s = this.vwr.ms.at[i2].getAtomSite() - 1;
                if (sites[s] == 0) {
                    sites[s] = i2 + 1;
                    if ((bsMoved = this.moveConstrained(i2, bsFixed, bsModelAtoms, p1, true, false, bsMoved)) == null) {
                        n = 0;
                        break;
                    }
                }
                i2 = bsAtoms.nextSetBit(i2 + 1);
                ++ip2;
            }
            int n2 = n != 0 && this.checkAtomPositions(apos0, apos, bsAtoms) ? n : 0;
            return n2;
        }
        finally {
            if (n == 0) {
                this.vwr.ms.restoreAtomPositions(apos0);
                bsAtoms.clearAll();
            } else {
                this.updateDrawAtomSets("atomsMoved", bsAtoms);
            }
        }
    }

    public boolean checkOption(char type, String key) {
        String check = null;
        switch (type) {
            case 'M': {
                check = ";view;edit;molecular;";
                break;
            }
            case 'S': {
                check = ";none;applylocal;retainlocal;applyfull;";
                break;
            }
            case 'U': {
                check = ";packed;extend;";
                break;
            }
            case 'B': {
                check = ";key;elementkey;autobond;hidden;showsymopinfo;clicktosetelement;addhydrogen;addhydrogens;";
            }
        }
        return check != null && PT.isOneOf(key.toLowerCase(), check);
    }

    public void clearAtomConstraints() {
        this.modelSyms = null;
        this.minBasisAtoms = null;
        if (this.atomConstraints != null) {
            int i = this.atomConstraints.length;
            while (--i >= 0) {
                this.atomConstraints[i] = null;
            }
        }
    }

    public void clickAssignAtom(int atomIndex, String element, P3 ptNew) {
        int n = this.addAtomType(element, new P3[]{ptNew == null ? null : ptNew}, BSUtil.newAndSetBit(atomIndex), "", null, "click");
        if (n > 0) {
            this.vwr.setPickingMode("dragAtom", 0);
        }
    }

    public int cmdAssignAddAtoms(String type, P3[] pts, BS bsAtoms, String packing, String cmd) {
        if (type.startsWith("_")) {
            type = type.substring(1);
        }
        return Math.abs(this.addAtomType(type, pts, bsAtoms, packing, null, cmd));
    }

    public void cmdAssignAtom(BS bs, P3 pt, String type, String cmd) {
        if (pt != null && bs != null && bs.cardinality() > 1) {
            bs = BSUtil.newAndSetBit(bs.nextSetBit(0));
        }
        if (type.startsWith("_")) {
            type = type.substring(1);
        }
        this.assignAtomNoAddedSymmetry(pt, -1, bs, type, pt != null, cmd, 0);
    }

    public void cmdAssignBond(int bondIndex, char type, String cmd) {
        this.assignBondAndType(bondIndex, this.getBondOrder(type, this.vwr.ms.bo[bondIndex]), type, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdAssignConnect(int index, int index2, char type, String cmd) {
        Atom b;
        Atom a;
        Atom[] atoms = this.vwr.ms.at;
        if (index < 0 || index2 < 0 || index >= atoms.length || index2 >= atoms.length || (a = atoms[index]) == null || (b = atoms[index2]) == null) {
            return;
        }
        int state = this.getMKState();
        try {
            Bond bond = null;
            if (type != '1') {
                BS bs = new BS();
                bs.set(index);
                bs.set(index2);
                bs = this.vwr.getBondsForSelectedAtoms(bs);
                bond = this.vwr.ms.bo[bs.nextSetBit(0)];
            }
            int bondOrder = this.getBondOrder(type, bond);
            BS bs1 = this.vwr.ms.getSymmetryEquivAtoms(BSUtil.newAndSetBit(index), null, null);
            BS bs2 = this.vwr.ms.getSymmetryEquivAtoms(BSUtil.newAndSetBit(index2), null, null);
            this.connectAtoms(a.distance(b), bondOrder, bs1, bs2);
            if (this.vwr.getOperativeSymmetry() == null && (bond = a.getBond(b)) != null) {
                bs1.or(bs2);
                this.assignBond(bond.index, 1, bs1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setMKState(state);
        }
    }

    public int cmdAssignDeleteAtoms(BS bs) {
        this.clearAtomConstraints();
        bs.and(this.vwr.getThisModelAtoms());
        bs = this.vwr.ms.getSymmetryEquivAtoms(bs, null, null);
        if (!bs.isEmpty()) {
            this.vwr.deleteAtoms(bs, false);
        }
        return bs.cardinality();
    }

    public int cmdAssignMoveAtoms(BS bsSelected, int iatom, P3 p, P3[] pts, boolean allowProjection, boolean isMolecule) {
        int n;
        SymmetryInterface sym = this.getSym(iatom);
        if (sym != null) {
            if (this.addHydrogens) {
                this.vwr.ms.addConnectedHAtoms(this.vwr.ms.at[iatom], bsSelected);
            }
            n = this.assignMoveAtoms(sym, bsSelected, null, null, iatom, p, pts, allowProjection, isMolecule);
        } else {
            n = this.vwr.moveAtomWithHydrogens(iatom, this.addHydrogens ? 1 : 0, 0, 0, p, null);
        }
        if (n == 0) {
            this.vwr.showString("could not move atoms!", false);
        }
        return n;
    }

    public String cmdAssignSpaceGroup(BS bs, String name, Object paramsOrUC, boolean isPacked, String cmd) {
        SymmetryInterface sym0 = this.vwr.getCurrentUnitCell();
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        if (sym0 != null && sym != sym0) {
            sym.getUnitCell(sym0.getV0abc(null, null), false, "modelkit");
        }
        SB sb = new SB();
        String ret = this.assignSpaceGroup(sym, null, bs, paramsOrUC, PT.split(name, ">"), 0, null, null, sb);
        if (ret.endsWith("!")) {
            return ret;
        }
        if (isPacked) {
            String transform = ret;
            BS bsModelAtoms = this.vwr.getThisModelAtoms();
            int n = this.cmdAssignSpaceGroupPacked(bsModelAtoms, transform, cmd);
            sb.append("\n").append(GT.i(GT.$("{0} atoms added"), n));
        }
        return sb.toString();
    }

    public int cmdAssignSpaceGroupPacked(BS bsAtoms, String transform, String cmd) {
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        if (sym == null) {
            return 0;
        }
        M4[] opsCtr = (M4[])sym.getSpaceGroupInfoObj("opsCtr", transform, false, false);
        int n0 = bsAtoms.cardinality();
        this.addAtoms(null, null, bsAtoms, "packed", opsCtr, cmd);
        bsAtoms = this.vwr.getThisModelAtoms();
        this.vwr.ms.setSpaceGroup(this.vwr.am.cmi, sym, new BS());
        return bsAtoms.cardinality() - n0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdMinimize(JmolScriptEvaluator eval, BS bsBasis, int steps, float crit, float rangeFixed, int flags) throws Exception {
        boolean wasAppend = this.vwr.getBoolean(603979792);
        try {
            this.vwr.setBooleanProperty("appendNew", true);
            this.minimizeXtal(eval, bsBasis, steps, crit, rangeFixed, flags);
        }
        finally {
            this.vwr.setBooleanProperty("appendNew", wasAppend);
        }
    }

    public int cmdRotateAtoms(BS bsAtoms, P3[] points, float endDegrees) {
        return this.rotateAtoms(bsAtoms, points, endDegrees);
    }

    public void dispose() {
        this.menu.jpiDispose();
        this.menu.modelkit = null;
        this.menu = null;
        this.vwr = null;
    }

    public String getActiveMenu() {
        return this.menu.activeMenu;
    }

    public String getDefaultModel() {
        return this.addHydrogens ? "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" : "1\n\nC 0 0 0\n";
    }

    public Object getProperty(String name) {
        if ((name = name.toLowerCase().intern()) == "exists") {
            return Boolean.TRUE;
        }
        if (name == "constraint") {
            return this.constraint;
        }
        if (name == "ismolecular") {
            return this.getMKState() == 0;
        }
        if (name == "key" || name == "elementkeys" || name == "elementkeys") {
            return this.isElementKeyOn(this.vwr.am.cmi);
        }
        if (name == "minimizing") {
            return this.minBasis != null;
        }
        if (name == "alloperators") {
            return this.allOperators;
        }
        if (name == "data") {
            return this.getinfo();
        }
        return this.setProperty(name, null);
    }

    public int getRotateBondIndex() {
        return this.getMKState() == 0 && this.isRotateBond ? this.bondIndex : -1;
    }

    public SymmetryInterface getSym(int iatom) {
        short modelIndex = this.vwr.ms.at[iatom].mi;
        if (this.modelSyms == null || modelIndex >= this.modelSyms.length) {
            this.modelSyms = new SymmetryInterface[this.vwr.ms.mc];
            int imodel = this.modelSyms.length;
            while (--imodel >= 0) {
                SymmetryInterface sym = this.vwr.ms.getUnitCell(imodel);
                if (sym != null && sym.getSymmetryOperations() == null) continue;
                this.modelSyms[imodel] = sym;
            }
        }
        return iatom < 0 ? null : this.modelSyms[modelIndex];
    }

    public boolean handleAssignNew(MouseState pressed, MouseState dragged, MeasurementPending mp, int dragAtomIndex, int key) {
        int y;
        String atomType;
        boolean inRange = pressed.inRange(10, dragged.x, dragged.y);
        if (mp != null && this.handleAtomDragging(mp.countPlusIndices)) {
            return true;
        }
        String string = atomType = key < 0 ? this.pickAtomAssignType : ModelKit.keyToElement(key);
        if (atomType == null) {
            return false;
        }
        int x = inRange ? pressed.x : dragged.x;
        int n = y = inRange ? pressed.y : dragged.y;
        if (this.vwr.antialiased) {
            x <<= 1;
            y <<= 1;
        }
        return this.handleAtomOrBondPicked(x, y, mp, dragAtomIndex, atomType, inRange);
    }

    public boolean hasConstraint(int iatom, boolean ignoreGeneral, boolean addNew) {
        Constraint c = this.setConstraint(this.getSym(iatom), iatom, addNew ? GET_CREATE : GET);
        return c != null && (!ignoreGeneral || c.type != 7);
    }

    public void initializeForModel() {
        this.resetBondFields();
        this.allOperators = null;
        this.currentModelIndex = -999;
        this.iatom0 = 0;
        this.secondAtomIndex = -1;
        this.centerAtomIndex = -1;
        this.centerPoint = null;
        this.symop = null;
        this.setDefaultState(0);
        if (this.setElementKeys) {
            this.updateModelElementKey(this.vwr.am.cmi, true);
        }
    }

    public boolean isHidden() {
        return this.menu.hidden;
    }

    public boolean isPickAtomAssignCharge() {
        return this.isPickAtomAssignCharge;
    }

    public void minimizeEnd(BS bsBasis2, boolean isEnd) {
        this.minimizeXtalEnd(bsBasis2, isEnd);
        this.vwr.refresh(1, "modelkit minimize");
    }

    public int moveMinConstrained(int iatom, P3 p, BS bsAtoms) {
        BS bsMoved = this.moveConstrained(iatom, null, bsAtoms, p, true, true, null);
        return bsMoved == null ? 0 : bsMoved.cardinality();
    }

    public MeasurementPending setBondMeasure(int bi, MeasurementPending mp) {
        if (this.branchAtomIndex < 0) {
            return null;
        }
        Bond b = this.vwr.ms.bo[bi];
        Atom a1 = b.atom1;
        Atom a2 = b.atom2;
        this.a3 = null;
        this.a0 = null;
        if (a1.getCovalentBondCount() == 1 || a2.getCovalentBondCount() == 1) {
            return null;
        }
        this.a0 = ModelKit.getNearestBondedAtom(a1, a2);
        mp.addPoint(this.a0.i, null, true);
        mp.addPoint(a1.i, null, true);
        mp.addPoint(a2.i, null, true);
        this.a3 = ModelKit.getNearestBondedAtom(a2, a1);
        mp.addPoint(this.a3.i, null, true);
        mp.mad = 50;
        mp.inFront = true;
        return mp;
    }

    public void setMenu(ModelKitPopup menu) {
        this.menu = menu;
        this.vwr = menu.vwr;
        menu.modelkit = this;
        this.initializeForModel();
    }

    public synchronized Object setProperty(String key, Object value) {
        try {
            if (this.vwr == null) {
                return null;
            }
            if ((key = key.toLowerCase().intern()) == "hoverlabel") {
                return this.getHoverLabel((Integer)value);
            }
            if (key == "initializemodel") {
                this.initializeForModel();
                return null;
            }
            if (key == "atomset") {
                this.addAtomSet((String)value);
                return null;
            }
            if (key == "setelementkeys") {
                this.setElementKeys(ModelKit.isTrue(value));
                return null;
            }
            if (key == "frameresized") {
                this.clearElementKey(-1);
                this.updateModelElementKeys(null, true);
                return null;
            }
            if (key == "atomsMoved") {
                if (this.drawAtomSets != null) {
                    this.updateDrawAtomSets(key, ((BS[])value)[0]);
                }
                return null;
            }
            if (key == "updatemodelkeys") {
                if (this.haveElementKeys) {
                    this.updateModelElementKeys(((BS[])value)[1], true);
                }
                if (this.drawAtomSets != null) {
                    this.updateDrawAtomSets("atomsDeleted", ((BS[])value)[0]);
                }
                return null;
            }
            if (key == "updatekeysfromstate") {
                this.updateElementKeyFromStateScript();
                return null;
            }
            if (key == "updateatomkeys" || key == "elementkey" || key == "elementkeys") {
                if (value == null || value instanceof BS) {
                    BS bsAtoms = (BS)value;
                    this.updateElementKey(bsAtoms);
                    return null;
                }
                int mi = this.vwr.am.cmi;
                boolean isOn = ModelKit.isTrue(value);
                this.bsElementKeyModelsOFF.setBitTo(mi, !isOn);
                this.setElementKey(mi, isOn);
                return isOn ? "true" : "false";
            }
            if (key == "branchatomclicked") {
                if (this.isRotateBond && !this.vwr.acm.isHoverable()) {
                    this.setBranchAtom((Integer)value, true);
                }
                return null;
            }
            if (key == "branchatomdragged") {
                if (this.isRotateBond) {
                    this.setBranchAtom((Integer)value, true);
                }
                return null;
            }
            if (key == "hidemenu") {
                this.menu.hidePopup();
                return null;
            }
            if (key == "constraint") {
                this.constraint = null;
                this.clearAtomConstraints();
                Object[] o = (Object[])value;
                if (o != null) {
                    P3 v1 = (P3)o[0];
                    P3 v2 = (P3)o[1];
                    P4 plane = (P4)o[2];
                    if (v1 != null && v2 != null) {
                        this.constraint = new Constraint(null, 4, new Object[]{v1, v2});
                    } else if (plane != null) {
                        this.constraint = new Constraint(null, 5, new Object[]{plane});
                    } else if (v1 != null) {
                        this.constraint = new Constraint(null, 6, null);
                    }
                }
                return null;
            }
            if (key == "reset") {
                return null;
            }
            if (key == "atompickingmode") {
                if (PT.isOneOf((String)value, ";identify;off;")) {
                    this.exitBondRotation(null);
                    this.vwr.setBooleanProperty("bondPicking", false);
                    this.vwr.acm.exitMeasurementMode("modelkit");
                }
                if ("dragatom".equals(value)) {
                    this.setHoverLabel(ATOM_MODE, ModelKit.getText("dragAtom"));
                }
                return null;
            }
            if (key == "bondpickingmode") {
                if (value.equals("deletebond")) {
                    this.exitBondRotation(ModelKit.getText("bondTo0"));
                } else if (value.equals("identifybond")) {
                    this.exitBondRotation("");
                }
                return null;
            }
            if (key == "rotateBond") {
                int i = (Integer)value;
                if (i != this.bondAtomIndex2) {
                    this.bondAtomIndex1 = i;
                }
                this.bsRotateBranch = null;
                return null;
            }
            if (key == "bondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, false);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "rotatebondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, true);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "highlight") {
                this.bsHighlight.clearAll();
                if (value != null) {
                    this.bsHighlight.or((BS)value);
                }
                return null;
            }
            if (key == "mode") {
                boolean isEdit = "edit".equals(value);
                this.setMKState("view".equals(value) ? 1 : (isEdit ? 2 : 0));
                if (isEdit) {
                    this.addHydrogens = false;
                }
                return null;
            }
            if (key == "symmetry") {
                this.setDefaultState(2);
                key = ((String)value).toLowerCase().intern();
                this.setSymEdit(key == "applylocal" ? 32 : (key == "retainlocal" ? 64 : (key == "applyfull" ? 128 : 0)));
                this.showXtalSymmetry();
                return null;
            }
            if (key == "unitcell") {
                boolean isPacked = "packed".equals(value);
                this.setUnitCell(isPacked ? 0 : 256);
                this.viewOffset = isPacked ? Pt000 : null;
                return null;
            }
            if (key == "center") {
                this.setDefaultState(1);
                this.centerPoint = (P3)value;
                this.lastCenter = this.centerPoint.x + " " + this.centerPoint.y + " " + this.centerPoint.z;
                this.centerAtomIndex = this.centerPoint instanceof Atom ? ((Atom)this.centerPoint).i : -1;
                this.secondAtomIndex = -1;
                this.clickProcessAtom(this.centerAtomIndex);
                return null;
            }
            if (key == "assignBond") {
                this.cmdAssignBond((Integer)value, this.pickBondAssignType, "click");
                return null;
            }
            if (key == "addhydrogen" || key == "addhydrogens") {
                if (value != null) {
                    this.addHydrogens = ModelKit.isTrue(value);
                }
                return this.addHydrogens;
            }
            if (key == "autobond") {
                if (value != null) {
                    this.autoBond = ModelKit.isTrue(value);
                }
                return this.autoBond;
            }
            if (key == "clicktosetelement") {
                if (value != null) {
                    this.clickToSetElement = ModelKit.isTrue(value);
                }
                return this.clickToSetElement;
            }
            if (key == "hidden") {
                if (value != null) {
                    this.menu.hidden = ModelKit.isTrue(value);
                    if (this.menu.hidden) {
                        this.menu.hidePopup();
                    }
                    this.vwr.setBooleanProperty("modelkitMode", true);
                }
                return this.menu.hidden;
            }
            if (key == "showsymopinfo") {
                if (value != null) {
                    this.showSymopInfo = ModelKit.isTrue(value);
                }
                return this.showSymopInfo;
            }
            if (key == "symop") {
                this.setDefaultState(1);
                if (value != null) {
                    if (key == "hoverlabel") {
                        return this.getHoverLabel((Integer)value);
                    }
                    this.symop = value;
                    this.showSymop(this.symop);
                }
                return this.symop;
            }
            if (key == "atomtype") {
                this.wasRotating = this.isRotateBond;
                this.isRotateBond = false;
                if (value != null) {
                    this.pickAtomAssignType = (String)value;
                    boolean bl = this.isPickAtomAssignCharge = this.pickAtomAssignType.equalsIgnoreCase("pl") || this.pickAtomAssignType.equalsIgnoreCase("mi");
                    if (this.isPickAtomAssignCharge) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText(this.pickAtomAssignType.equalsIgnoreCase("mi") ? "decCharge" : "incCharge"));
                    } else if ("X".equals(this.pickAtomAssignType)) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText("delAtom"));
                    } else if (this.pickAtomAssignType.equals("Xx")) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText("dragBond"));
                    } else {
                        this.setHoverLabel(ATOM_MODE, "Click or click+drag to bond or for a new " + this.pickAtomAssignType);
                        this.lastElementType = this.pickAtomAssignType;
                    }
                }
                return this.pickAtomAssignType;
            }
            if (key == "bondtype") {
                if (value != null) {
                    String s = ((String)value).substring(0, 1).toLowerCase();
                    if (" 0123456pm".indexOf(s) > 0) {
                        this.pickBondAssignType = s.charAt(0);
                        this.setHoverLabel(BOND_MODE, ModelKit.getText(this.pickBondAssignType == 'm' ? "decBond" : (this.pickBondAssignType == 'p' ? "incBond" : "bondTo" + s)));
                    }
                    this.isRotateBond = false;
                }
                return "" + this.pickBondAssignType;
            }
            if (key == "offset") {
                if (value == "none") {
                    this.viewOffset = null;
                } else if (value != null) {
                    P3 p3 = this.viewOffset = value instanceof P3 ? (P3)value : ModelKit.pointFromTriad(value.toString());
                    if (this.viewOffset != null) {
                        this.setSymViewState(8);
                    }
                }
                this.showXtalSymmetry();
                return this.viewOffset;
            }
            if (key == "screenxy") {
                if (value != null) {
                    this.screenXY = (int[])value;
                    this.vwr.acm.exitMeasurementMode("modelkit");
                }
                return this.screenXY;
            }
            if (key == "invariant") {
                int iatom = value instanceof BS ? ((BS)value).nextSetBit(0) : -1;
                Atom atom = this.vwr.ms.getAtom(iatom);
                return atom == null ? null : this.vwr.getSymmetryInfo(iatom, null, -1, null, atom, atom, 1275068418, null, 0.0f, 0, 0, null);
            }
            if (key == "distance") {
                float d;
                this.setDefaultState(2);
                float f = value == null ? Float.NaN : (d = value instanceof Float ? ((Number)value).floatValue() : PT.parseFloat((String)value));
                if (!Float.isNaN(d)) {
                    ModelKit.notImplemented("setProperty: distance");
                    this.centerDistance = d;
                }
                return Float.valueOf(this.centerDistance);
            }
            if (key == "addconstraint") {
                ModelKit.notImplemented("setProperty: addConstraint");
                return null;
            }
            if (key == "removeconstraint") {
                ModelKit.notImplemented("setProperty: removeConstraint");
                return null;
            }
            if (key == "removeallconstraints") {
                ModelKit.notImplemented("setProperty: removeAllConstraints");
                return null;
            }
            if (key == "vibration") {
                WyckoffModulation.setVibrationMode(this, value);
                return null;
            }
            System.err.println("ModelKit.setProperty? " + key + " " + value);
        }
        catch (Exception e) {
            return "?";
        }
        return null;
    }

    public void showMenu(int x, int y) {
        this.menu.jpiShow(x, y);
    }

    public void updateMenu() {
        this.menu.jpiUpdateComputedMenus();
    }

    public boolean wasRotating() {
        boolean b = this.wasRotating;
        this.wasRotating = false;
        return b;
    }

    protected boolean checkNewModel() {
        boolean isNew = false;
        if (this.vwr.ms != this.lastModelSet) {
            this.lastModelSet = this.vwr.ms;
            isNew = true;
        }
        this.currentModelIndex = Math.max(this.vwr.am.cmi, 0);
        this.iatom0 = this.vwr.ms.am[this.currentModelIndex].firstAtomIndex;
        return isNew;
    }

    protected void clickProcessXtal(String id, String action) {
        if (this.processSymop(id, false)) {
            return;
        }
        if ((action = action.intern()).startsWith("mkmode_")) {
            if (!this.alertedNoEdit && action == "mkmode_edit") {
                this.alertedNoEdit = true;
                this.vwr.alert("ModelKit xtal edit has not been implemented");
                return;
            }
            this.clickProcessMode(action);
        } else if (action.startsWith("mksel_")) {
            this.clickProcessSel(action);
        } else if (action.startsWith("mkselop_")) {
            while (action != null) {
                action = this.clickProcessSelOp(action);
            }
        } else if (action.startsWith("mksymmetry_")) {
            this.clickProcessSym(action);
        } else if (action.startsWith("mkunitcell_")) {
            this.clickProcessUC(action);
        } else {
            ModelKit.notImplemented("XTAL click " + action);
        }
        this.menu.updateAllXtalMenuOptions();
    }

    protected void exitBondRotation(String text) {
        this.wasRotating = this.isRotateBond;
        this.isRotateBond = false;
        if (text != null) {
            this.bondHoverLabel = text;
        }
        this.vwr.highlight(null);
    }

    protected String[] getAllOperators() {
        if (this.allOperators != null) {
            return this.allOperators;
        }
        String data = this.runScriptBuffered("show symop");
        this.allOperators = PT.split(data.trim().replace('\t', ' '), "\n");
        return this.allOperators;
    }

    protected Atom getBasisAtom(int iatom) {
        Atom b;
        if (this.minBasisAtoms == null) {
            this.minBasisAtoms = new Atom[this.vwr.ms.ac + 10];
        }
        if (this.minBasisAtoms.length < iatom + 10) {
            Atom[] a = new Atom[this.vwr.ms.ac + 10];
            System.arraycopy(this.minBasisAtoms, 0, a, 0, this.minBasisAtoms.length);
            this.minBasisAtoms = a;
        }
        return (b = this.minBasisAtoms[iatom]) == null ? this.vwr.ms.getBasisAtom(iatom, false) : b;
    }

    protected String getCenterText() {
        return this.centerAtomIndex < 0 && this.centerPoint == null ? null : (this.centerAtomIndex >= 0 ? this.vwr.getAtomInfo(this.centerAtomIndex) : this.centerPoint.toString());
    }

    protected String getElementFromUser() {
        String element = this.promptUser(GT.$("Element?"), "");
        return element == null || Elements.elementNumberFromSymbol(element, true) == 0 ? null : element;
    }

    protected int getMKState() {
        return this.state & 3;
    }

    protected int getSymEditState() {
        return this.state & 0xE0;
    }

    protected String getSymopText() {
        return this.symop == null || this.allOperators == null ? null : (this.symop instanceof Integer ? this.allOperators[(Integer)this.symop - 1] : this.symop.toString());
    }

    protected int getSymViewState() {
        return this.state & 0x1C;
    }

    protected int getUnitCellState() {
        return this.state & 0x700;
    }

    protected boolean isXtalState() {
        return (this.state & 3) != 0;
    }

    protected void processMKPropertyItem(String name, boolean TF) {
        int pt = (name = name.substring(2)).indexOf("_");
        if (pt > 0) {
            this.setProperty(name.substring(0, pt), name.substring(pt + 1));
        } else {
            this.setProperty(name, TF);
        }
    }

    protected boolean processSymop(String id, boolean isFocus) {
        int pt = id.indexOf(".mkop_");
        if (pt >= 0) {
            Object op = this.symop;
            this.symop = Integer.valueOf(id.substring(pt + 6));
            this.showSymop(this.symop);
            if (isFocus) {
                this.symop = op;
            }
            return true;
        }
        return false;
    }

    protected void resetAtomPickType() {
        this.setProperty("atomtype", this.lastElementType);
    }

    protected Constraint setConstraint(SymmetryInterface sym, int ia, int mode) {
        Constraint ac;
        if (ia < 0) {
            return null;
        }
        Atom a = this.getBasisAtom(ia);
        int iatom = a.i;
        Constraint constraint = ac = this.atomConstraints != null && iatom < this.atomConstraints.length ? this.atomConstraints[iatom] : null;
        if (ac != null || mode != GET_CREATE) {
            if (ac != null && mode == GET_DELETE) {
                this.atomConstraints[iatom] = null;
            }
            return ac;
        }
        if (sym == null) {
            return this.addConstraint(iatom, new Constraint(a, 0, null));
        }
        int[] ops = sym.getInvariantSymops(a, null);
        if (Logger.debugging) {
            System.out.println("MK.getConstraint atomIndex=" + iatom + " symops=" + Arrays.toString(ops));
        }
        if (ops.length == 0) {
            return this.addConstraint(iatom, new Constraint(a, 7, null));
        }
        P4 plane1 = null;
        Object[] line1 = null;
        int i = ops.length;
        while (--i >= 0) {
            Object[] line2 = null;
            Object c = sym.getSymmetryInfoAtom(this.vwr.ms, iatom, null, ops[i], null, a, null, "invariant", 1275068418, 0.0f, -1, 0, null);
            if (c instanceof String) continue;
            if (c instanceof P4) {
                P4 plane = (P4)c;
                if (plane1 == null) {
                    plane1 = plane;
                    continue;
                }
                Lst<Object> line = Measure.getIntersectionPP(plane1, plane);
                if (line == null || line.size() == 0) {
                    return locked;
                }
                line2 = new Object[]{line.get(0), line.get(1)};
            } else {
                if (c instanceof P3) {
                    return locked;
                }
                line2 = (Object[])c;
            }
            if (line2 == null) continue;
            if (line1 == null) {
                line1 = line2;
            } else {
                T3 v1 = (T3)line1[1];
                if ((double)Math.abs(v1.dot((T3)line2[1])) < 0.999) {
                    return locked;
                }
            }
            if (plane1 == null || !((double)Math.abs(plane1.dot((T3)line2[1])) > 0.001)) continue;
            return locked;
        }
        if (line1 != null) {
            line1[0] = P3.newP(a);
        }
        return this.addConstraint(iatom, line1 != null ? new Constraint(a, 4, line1) : (plane1 != null ? new Constraint(a, 5, new Object[]{plane1}) : new Constraint(a, 7, null)));
    }

    protected boolean setHasUnitCell() {
        this.hasUnitCell = this.vwr.getOperativeSymmetry() != null;
        return this.hasUnitCell;
    }

    protected void setHoverLabel(String mode, String text) {
        if (text == null) {
            return;
        }
        if (mode == BOND_MODE) {
            this.bondHoverLabel = text;
        } else if (mode == ATOM_MODE) {
            this.atomHoverLabel = text;
        } else if (mode == XTAL_MODE) {
            this.atomHoverLabel = text;
        }
    }

    protected void setMKState(int bits) {
        this.state = this.state & 0xFFFFFFFC | (this.hasUnitCell ? bits : 0);
    }

    private int addAtomType(String type, P3[] pts, BS bsAtoms, String packing, M4[] opsCtr, String cmd) {
        String wyckoff;
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        int ipt = type.indexOf(":");
        String string = wyckoff = ipt > 0 && ipt == type.length() - 2 ? type.substring(ipt + 1) : null;
        if (wyckoff != null) {
            type = type.substring(0, ipt);
            if (sym != null) {
                Object o = sym.getWyckoffPosition(this.vwr, null, wyckoff);
                if (!(o instanceof P3)) {
                    return 0;
                }
                pts = new P3[]{(P3)o};
            }
        }
        return this.addAtoms(type, pts, bsAtoms, packing, opsCtr, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAtoms(String type, P3[] pts, BS bsAtoms, String packing, M4[] opsCtr, String cmd) {
        try {
            int atomIndex;
            this.vwr.pushHoldRepaintWhy("modelkit");
            SymmetryInterface sym = this.vwr.getOperativeSymmetry();
            if (type != null) {
                String wyckoff;
                int ipt = type.indexOf(":");
                String string = wyckoff = ipt > 0 && ipt == type.length() - 2 ? type.substring(ipt + 1) : null;
                if (wyckoff != null) {
                    type = type.substring(0, ipt);
                    if (sym != null) {
                        Object o = sym.getWyckoffPosition(this.vwr, null, wyckoff);
                        if (!(o instanceof P3)) {
                            int n = 0;
                            return n;
                        }
                        pts = new P3[]{(P3)o};
                    }
                }
            }
            boolean isPoint = bsAtoms == null;
            int n = atomIndex = isPoint ? -1 : bsAtoms.nextSetBit(0);
            if (!isPoint && atomIndex < 0 || sym == null && type == null) {
                int o = 0;
                return o;
            }
            int n2 = 0;
            if (sym == null) {
                if (isPoint) {
                    for (int i = 0; i < pts.length; ++i) {
                        this.assignAtomNoAddedSymmetry(pts[i], -1, null, type, true, cmd, -1);
                    }
                    n2 = -pts.length;
                } else {
                    this.assignAtomNoAddedSymmetry(pts[0], atomIndex, null, type, true, cmd, -1);
                    n2 = -1;
                }
            } else {
                n2 = this.addAtomsWithSymmetry(sym, bsAtoms, type, atomIndex, isPoint, pts, packing, opsCtr);
            }
            int n3 = n2;
            return n3;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            this.vwr.popHoldRepaint("modelkit");
        }
    }

    private int addAtomsWithSymmetry(SymmetryInterface sym, BS bsAtoms, String type, int atomIndex, boolean isPoint, P3[] pts, String packing, M4[] opsCtr) {
        BS bsM = this.vwr.getThisModelAtoms();
        int n = bsM.cardinality();
        if (n == 0) {
            packing = "zapped;" + packing;
        }
        String stype = "" + type;
        Lst<P3> points = new Lst<P3>();
        int site = 0;
        P3 pf = null;
        if (pts != null && pts.length == 1 && pts[0] != null) {
            pf = P3.newP(pts[0]);
            sym.toFractional(pf, false);
            isPoint = true;
        }
        int i = bsM.nextSetBit(0);
        while (i >= 0) {
            P3 p = P3.newP(this.vwr.ms.at[i]);
            sym.toFractional(p, false);
            if (pf != null && pf.distanceSquared(p) < 1.96E-6f) {
                site = this.vwr.ms.at[i].getAtomSite();
                if (type == null || pts == null) {
                    type = this.vwr.ms.at[i].getElementSymbolIso(true);
                }
            }
            points.addLast(p);
            i = bsM.nextSetBit(i + 1);
        }
        int nInitial = points.size();
        packing = "fromfractional;tocartesian;" + packing;
        if (isPoint) {
            BS bsEquiv = bsAtoms == null ? null : this.vwr.ms.getSymmetryEquivAtoms(bsAtoms, null, null);
            for (int i2 = 0; i2 < pts.length; ++i2) {
                this.assignAtoms(P3.newP(pts[i2]), atomIndex, bsEquiv, stype, true, null, false, site, sym, points, packing, null);
            }
        } else {
            BS sites = new BS();
            int i3 = bsAtoms.nextSetBit(0);
            while (i3 >= 0) {
                Atom a = this.vwr.ms.at[i3];
                site = a.getAtomSite();
                if (!sites.get(site)) {
                    int j;
                    sites.set(site);
                    stype = type == null ? a.getElementSymbolIso(true) : stype;
                    this.assignAtoms(P3.newP(a), -1, null, stype, false, null, false, site, sym, points, packing, opsCtr);
                    if (opsCtr == null) {
                        j = points.size();
                        while (--j >= nInitial) {
                            points.removeItemAt(j);
                        }
                    } else {
                        j = points.size();
                        while (--j >= nInitial) {
                            P3 p = (P3)points.get(j);
                            sym.toFractional(p, false);
                        }
                        nInitial = points.size();
                    }
                }
                i3 = bsAtoms.nextSetBit(i3 + 1);
            }
        }
        return this.vwr.getThisModelAtoms().cardinality() - n;
    }

    private Constraint addConstraint(int iatom, Constraint c) {
        if (c == null) {
            if (this.atomConstraints != null && this.atomConstraints.length > iatom) {
                this.atomConstraints[iatom] = null;
            }
            return null;
        }
        if (this.atomConstraints == null) {
            this.atomConstraints = new Constraint[this.vwr.ms.ac + 10];
        }
        if (this.atomConstraints.length < iatom + 10) {
            Constraint[] a = new Constraint[this.vwr.ms.ac + 10];
            System.arraycopy(this.atomConstraints, 0, a, 0, this.atomConstraints.length);
            this.atomConstraints = a;
        }
        this.atomConstraints[iatom] = c;
        return this.atomConstraints[iatom];
    }

    private void addInfo(Map<String, Object> info, String key, Object value) {
        if (value != null) {
            info.put(key, value);
        }
    }

    private void addOccupiedAtomsToBitset(BS bsSelected) {
        BS bs = new BS();
        int iatom = bsSelected.nextSetBit(0);
        while (iatom >= 0) {
            Atom a = this.vwr.ms.at[iatom];
            if (this.vwr.ms.getOccupancyFloat(a.i) == 100.0f) {
                bsSelected.set(a.i);
            } else {
                bs.clearAll();
                this.vwr.ms.getAtomsWithin(1.0E-4f, a, bs, a.mi);
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    if (this.vwr.ms.getOccupancyFloat(i) == 100.0f) {
                        bs.clear(i);
                        bsSelected.clear(i);
                    }
                    i = bs.nextSetBit(i + 1);
                }
                bsSelected.or(bs);
            }
            iatom = bsSelected.nextSetBit(iatom + 1);
        }
    }

    private void appRunScript(String script) {
        this.vwr.runScript(script);
    }

    private void assignAtomNoAddedSymmetry(P3 pt, int atomIndex, BS bs, String type, boolean newPoint, String cmd, int site) {
        this.assignAtoms(pt, atomIndex, bs, type, newPoint, cmd, false, site, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAtoms(P3 pt, int atomIndex, BS bs, String type, boolean newPoint, String cmd, boolean isClick, int site, SymmetryInterface sym, Lst<P3> points, String packing, M4[] opsCtr) {
        BS bsEquiv;
        float bd;
        if (sym == null) {
            sym = this.vwr.getOperativeSymmetry();
        }
        boolean haveAtomByIndex = atomIndex >= 0;
        boolean isMultipleAtoms = bs != null && bs.cardinality() > 1;
        int nIgnored = 0;
        int np = 0;
        if (!haveAtomByIndex) {
            atomIndex = bs == null ? -1 : bs.nextSetBit(0);
        }
        Atom atom = atomIndex < 0 ? null : this.vwr.ms.at[atomIndex];
        float f = bd = pt != null && atom != null ? pt.distance(atom) : -1.0f;
        if (points != null) {
            nIgnored = points.size();
            np = nIgnored++;
            sym.toFractional(pt, false);
            points.addLast(pt);
            if (!newPoint || haveAtomByIndex) {
                // empty if block
            }
            sym.getEquivPointList(points, nIgnored, packing + (newPoint && atomIndex < 0 ? "newpt" : ""), opsCtr);
        }
        BS bS = atom == null ? null : (sym != null ? this.vwr.ms.getSymmetryEquivAtoms(bs, sym, null) : (bsEquiv = bs == null || bs.cardinality() == 0 ? BSUtil.newAndSetBit(atomIndex) : bs));
        BS bs0 = bsEquiv == null ? null : (sym == null ? BSUtil.newAndSetBit(atomIndex) : BSUtil.copy(bsEquiv));
        int mi = atom == null ? this.vwr.am.cmi : atom.mi;
        int ac = this.vwr.ms.ac;
        int state = this.getMKState();
        boolean isDelete = type.equals("X");
        try {
            P3[] pts;
            if (isDelete) {
                if (isClick) {
                    this.setProperty("rotatebondindex", -1);
                }
                this.setConstraint(null, atomIndex, GET_DELETE);
            }
            if (pt == null && points == null) {
                if (atom == null) {
                    return;
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, 1, cmd, 1, bsEquiv);
                int i = bsEquiv.nextSetBit(0);
                while (i >= 0) {
                    this.assignAtom(i, type, this.autoBond, sym == null, isClick);
                    i = bsEquiv.nextSetBit(i + 1);
                }
                if (!PT.isOneOf(type, ";Mi;Pl;X;")) {
                    this.vwr.ms.setAtomNamesAndNumbers(atomIndex, -ac, null, true);
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, -1, "OK", 1, bsEquiv);
                this.vwr.refresh(3, "assignAtom");
                this.updateElementKey(null);
                return;
            }
            this.setMKState(0);
            if (points == null) {
                pts = new P3[]{pt};
            } else {
                pts = new P3[Math.max(0, points.size() - np)];
                int i = pts.length;
                while (--i >= 0) {
                    pts[i] = (P3)points.get(np + i);
                }
            }
            Lst<Atom> vConnections = new Lst<Atom>();
            boolean isConnected = false;
            if (site == 0) {
                if (atom != null) {
                    if (!isMultipleAtoms) {
                        vConnections.addLast(atom);
                        isConnected = true;
                    } else if (sym != null) {
                        P3 p = P3.newP(atom);
                        sym.toFractional(p, false);
                        bs.or(bsEquiv);
                        Lst<P3> list = sym.getEquivPoints(null, p, packing);
                        int n = list.size();
                        for (int j = 0; j < n; ++j) {
                            int i = bs.nextSetBit(0);
                            while (i >= 0) {
                                if ((double)this.vwr.ms.at[i].distanceSquared((T3)list.get(j)) < 0.001) {
                                    vConnections.addLast(this.vwr.ms.at[i]);
                                    bs.clear(i);
                                }
                                i = bs.nextSetBit(i + 1);
                            }
                        }
                    }
                    boolean bl = isConnected = vConnections.size() == pts.length;
                    if (isConnected) {
                        float d = Float.MAX_VALUE;
                        int i = pts.length;
                        while (--i >= 0) {
                            float d1 = ((Atom)vConnections.get(i)).distance(pts[i]);
                            if (d == Float.MAX_VALUE) {
                                d1 = d;
                                continue;
                            }
                            if (!((double)Math.abs(d1 - d) > 0.001)) continue;
                            isConnected = false;
                            break;
                        }
                    }
                    if (!isConnected) {
                        vConnections.clear();
                    }
                    this.vwr.sm.setStatusStructureModified(atomIndex, mi, 3, cmd, 1, null);
                }
                if (pt != null || points != null) {
                    BS bsM = this.vwr.getThisModelAtoms();
                    int i = bsM.nextSetBit(0);
                    while (i >= 0) {
                        int as = this.vwr.ms.at[i].getAtomSite();
                        if (as > site) {
                            site = as;
                        }
                        i = bsM.nextSetBit(i + 1);
                    }
                    ++site;
                }
            }
            int pickingMode = this.vwr.acm.getAtomPickingMode();
            boolean wasHidden = this.menu.hidden;
            boolean isMK = this.vwr.getBoolean(603983903);
            if (!isMK && sym == null) {
                this.vwr.setBooleanProperty("modelkitmode", true);
                this.menu.hidden = true;
                this.menu.allowPopup = false;
            }
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            if (site > 0) {
                htParams.put("fixedSite", site);
            }
            htParams.put("element", type);
            bs = this.vwr.addHydrogensInline(bs, vConnections, pts, htParams);
            if (bd > 0.0f && !isConnected && vConnections.isEmpty()) {
                this.connectAtoms(bd, 1, bs0, bs);
            }
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", false);
                this.menu.hidden = wasHidden;
                this.menu.allowPopup = true;
                this.vwr.acm.setPickingMode(pickingMode);
                this.menu.hidePopup();
            }
            int atomIndexNew = bs.nextSetBit(0);
            if (points == null) {
                this.assignAtom(atomIndexNew, type, false, atomIndex >= 0 && sym == null, true);
                if (atomIndex >= 0) {
                    boolean doAutobond = sym == null && !"H".equals(type);
                    this.assignAtom(atomIndex, ".", false, doAutobond, isClick);
                }
                this.vwr.ms.setAtomNamesAndNumbers(atomIndexNew, -ac, null, true);
                this.vwr.sm.setStatusStructureModified(atomIndexNew, mi, -3, "OK", 1, bs);
                return;
            }
            if (atomIndexNew >= 0) {
                int i = atomIndexNew;
                while (i >= 0) {
                    this.assignAtom(i, type, false, false, true);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], -1, false);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], site, true);
                    i = bs.nextSetBit(i + 1);
                }
                this.vwr.ms.updateBasisFromSite(mi);
            }
            int firstAtom = this.vwr.ms.am[mi].firstAtomIndex;
            this.vwr.ms.setAtomNamesAndNumbers(firstAtom, -ac, null, true);
            this.vwr.sm.setStatusStructureModified(-1, mi, -3, "OK", 1, bs);
            this.updateModelElementKey(mi, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.setMKState(state);
        }
    }

    private int assignAtom(int atomIndex, String type, boolean autoBond, boolean addHsAndBond, boolean isClick) {
        boolean wasH;
        Atom atom;
        if (isClick) {
            if (this.vwr.isModelkitPickingRotateBond()) {
                this.bondAtomIndex1 = atomIndex;
                return -1;
            }
            if (this.clickProcessAtom(atomIndex) || !this.clickToSetElement && this.vwr.ms.getAtom(atomIndex).getElementNumber() != 1) {
                return -1;
            }
        }
        if ((atom = this.vwr.ms.at[atomIndex]) == null) {
            return -1;
        }
        this.vwr.ms.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        BS bs = new BS();
        boolean bl = wasH = atom.getElementNumber() == 1;
        int atomicNumber = "PPlMiX".indexOf(type) > 0 ? -1 : (type.equals("Xx") ? 0 : (PT.isUpperCase(type.charAt(0)) ? Elements.elementNumberFromSymbol(type, true) : -1));
        boolean isDelete = false;
        if (atomicNumber >= 0) {
            boolean doTaint = atomicNumber > 1 || !addHsAndBond;
            this.vwr.ms.setElement(atom, atomicNumber, doTaint);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.vwr.ms.setAtomName(atomIndex, type + atom.getAtomNumber(), doTaint);
            if (this.vwr.getBoolean(603983903)) {
                this.vwr.ms.am[atom.mi].isModelKit = true;
            }
            if (!this.vwr.ms.am[atom.mi].isModelKit || atomicNumber > 1) {
                this.vwr.ms.taintAtom(atomIndex, 0);
            }
        } else if (type.toLowerCase().equals("pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.toLowerCase().equals("mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".") || !this.addHydrogens) {
            return -1;
        }
        if (!addHsAndBond && !isDelete) {
            return atomicNumber;
        }
        if (!wasH) {
            this.vwr.ms.removeUnnecessaryBonds(atom, isDelete);
        }
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            dx = atomicNumber == 1 ? 1.0f : 1.5f;
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.vwr.ms.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.vwr.ms.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (isDelete) {
            this.vwr.deleteAtoms(bsA, false);
        }
        if (atomicNumber != 1 && autoBond) {
            this.vwr.ms.validateBspf(false);
            bs = this.vwr.ms.getAtomsWithinRadius(1.0f, bsA, false, null, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.vwr.ms.getAtomBitsMDa(1612709900, null, new BS()));
            this.vwr.ms.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f, null);
        }
        if (this.addHydrogens) {
            this.vwr.addHydrogens(bsA, 1);
        }
        return atomicNumber;
    }

    private boolean assignBond(int bondIndex, int bondOrder, BS bsAtoms) {
        Bond bond = this.vwr.ms.bo[bondIndex];
        this.vwr.ms.clearDB(bond.atom1.i);
        if (bondOrder < 0) {
            return false;
        }
        try {
            boolean isH;
            boolean a1H = bond.atom1.getElementNumber() == 1;
            boolean bl = isH = a1H || bond.atom2.getElementNumber() == 1;
            if (isH && bondOrder > 1) {
                this.vwr.deleteAtoms(BSUtil.newAndSetBit(a1H ? bond.atom1.i : bond.atom2.i), false);
                return true;
            }
            if (bondOrder == 0) {
                this.vwr.deleteBonds(BSUtil.newAndSetBit(bond.index));
            } else {
                bond.setOrder(bondOrder | 0x20000);
                if (!isH) {
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom1, false);
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom2, false);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Exception in seBondOrder: " + e.toString());
        }
        if (bondOrder != 0 && this.addHydrogens) {
            this.vwr.addHydrogens(bsAtoms, 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignBondAndType(int bondIndex, int bondOrder, char type, String cmd) {
        int modelIndex = -1;
        int state = this.getMKState();
        try {
            this.setMKState(0);
            Atom a1 = this.vwr.ms.bo[bondIndex].atom1;
            modelIndex = a1.mi;
            int ac = this.vwr.ms.ac;
            BS bsAtoms = BSUtil.newAndSetBit(a1.i);
            bsAtoms.set(this.vwr.ms.bo[bondIndex].atom2.i);
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, 6, cmd, 1, bsAtoms);
            this.assignBond(bondIndex, bondOrder, bsAtoms);
            this.vwr.ms.setAtomNamesAndNumbers(a1.i, -ac, null, true);
            this.vwr.refresh(3, "setBondOrder");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -6, "" + type, 1, bsAtoms);
        }
        catch (Exception ex) {
            Logger.error("assignBond failed");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -6, "ERROR " + ex, 1, null);
        }
        finally {
            this.setMKState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int assignMoveAtom(int iatom, P3 pt, BS bsFixed, BS bsModelAtoms, BS bsMoved) {
        if (Float.isNaN(pt.x) || iatom < 0) {
            return 0;
        }
        BS bs = BSUtil.newAndSetBit(iatom);
        if (bsModelAtoms == null) {
            bsModelAtoms = this.vwr.getThisModelAtoms();
        }
        bs.and(bsModelAtoms);
        if (bs.isEmpty()) {
            return 0;
        }
        int state = this.getMKState();
        this.setMKState(0);
        int n = 0;
        try {
            SymmetryInterface sym = this.getSym(iatom);
            BS bseq = new BS();
            this.vwr.ms.getSymmetryEquivAtomsForAtom(iatom, null, bsModelAtoms, bseq);
            if (this.setConstraint((SymmetryInterface)sym, (int)bseq.nextSetBit((int)0), (int)ModelKit.GET_CREATE).type == 6) {
                int n2 = 0;
                return n2;
            }
            if (bsFixed != null && !bsFixed.isEmpty()) {
                bseq.andNot(bsFixed);
            }
            if ((n = bseq.cardinality()) == 0) {
                int n3 = 0;
                return n3;
            }
            Atom a = this.vwr.ms.at[iatom];
            int[] v0 = sym.getInvariantSymops(a, null);
            int[] v1 = sym.getInvariantSymops(pt, v0);
            if (v1 == null != (v0 == null) || !Arrays.equals(v0, v1)) {
                int n4 = 0;
                return n4;
            }
            P3[] points = new P3[n];
            int ia0 = bseq.nextSetBit(0);
            if (!this.fillPointsForMove(sym, bseq, ia0, a, pt, points)) {
                int n5 = 0;
                return n5;
            }
            bsMoved.or(bseq);
            short mi = this.vwr.ms.at[ia0].mi;
            this.vwr.sm.setStatusStructureModified(ia0, mi, 3, "dragatom", n, bseq);
            int k = 0;
            int ia = bseq.nextSetBit(0);
            while (ia >= 0) {
                P3 p = points[k++];
                this.vwr.ms.setAtomCoord(ia, p.x, p.y, p.z);
                ia = bseq.nextSetBit(ia + 1);
            }
            this.vwr.sm.setStatusStructureModified(ia0, mi, -3, "dragatom", n, bseq);
            int n6 = n;
            return n6;
        }
        catch (Exception e) {
            System.err.println("Modelkit err" + e);
            int n7 = 0;
            return n7;
        }
        finally {
            this.setMKState(state);
            if (n > 0) {
                this.updateDrawAtomSets("atomsMoved", bsMoved);
            }
        }
    }

    private int assignMoveAtoms(SymmetryInterface sym, BS bsSelected, BS bsFixed, BS bsModelAtoms, int iatom, P3 p, P3[] pts, boolean allowProjection, boolean isMolecule) {
        int i;
        int npts;
        if (sym == null) {
            sym = this.getSym(iatom);
        }
        if ((npts = bsSelected.cardinality()) == 0) {
            return 0;
        }
        int n = 0;
        int i0 = bsSelected.nextSetBit(0);
        if (bsFixed == null) {
            bsFixed = this.vwr.getMotionFixedAtoms(sym, null);
        }
        if (bsModelAtoms == null) {
            bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
        }
        if (pts != null) {
            if (npts != pts.length) {
                return 0;
            }
            BS bs = new BS();
            int ip = 0;
            int i2 = bsSelected.nextSetBit(0);
            while (i2 >= 0) {
                bs.clearAll();
                bs.set(i2);
                n += this.assignMoveAtoms(sym, bs, bsFixed, bsModelAtoms, i2, pts[ip++], null, true, isMolecule);
                i2 = bsSelected.nextSetBit(i2 + 1);
            }
            return n;
        }
        int nAtoms = bsSelected.cardinality();
        if (bsSelected.intersects(bsFixed)) {
            p.x = Float.NaN;
            return 0;
        }
        this.addOccupiedAtomsToBitset(bsSelected);
        nAtoms = bsSelected.cardinality();
        if (nAtoms == 1 && !isMolecule) {
            BS bsMoved = this.moveConstrained(iatom, bsFixed, bsModelAtoms, p, true, allowProjection, null);
            return bsMoved == null ? 0 : bsMoved.cardinality();
        }
        P3 p1 = P3.newP(p);
        p.x = Float.NaN;
        if (this.moveConstrained(iatom, bsFixed, bsModelAtoms, p1, false, true, null) == null) {
            return 0;
        }
        V3 vrel = V3.newV(p1);
        vrel.sub(this.vwr.ms.at[iatom]);
        P3[] apos0 = this.vwr.ms.saveAtomPositions();
        BS bsAll = BSUtil.copy(bsSelected);
        if (isMolecule) {
            BS bsTest = BSUtil.copy(bsModelAtoms);
            bsTest.andNot(bsSelected);
            BS bsSites = new BS();
            i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                bsSites.set(this.vwr.ms.at[i].getAtomSite());
                i = bsSelected.nextSetBit(i + 1);
            }
            i = bsTest.nextSetBit(0);
            while (i >= 0) {
                BS bs;
                if (bsSites.get(this.vwr.ms.at[i].getAtomSite()) && (n = (bs = this.vwr.ms.getMoleculeBitSetForAtom(i)).cardinality()) > nAtoms) {
                    nAtoms = n;
                    bsTest.andNot(bs);
                    bsAll = bs;
                }
                i = bsTest.nextSetBit(i + 1);
            }
            if (!bsAll.equals(bsSelected)) {
                this.vwr.select(bsAll, false, 0, true);
            }
        }
        P3[] apos = new P3[bsAll.cardinality()];
        int maxSite = 0;
        i = bsAll.nextSetBit(0);
        while (i >= 0) {
            int s = this.vwr.ms.at[i].getAtomSite();
            if (s > maxSite) {
                maxSite = s;
            }
            i = bsAll.nextSetBit(i + 1);
        }
        int[] sites = new int[maxSite];
        pts = new P3[maxSite];
        BS bsMoved = new BS();
        int ip = 0;
        int i3 = bsAll.nextSetBit(0);
        while (i3 >= 0) {
            p1.setT(this.vwr.ms.at[i3]);
            p1.add(vrel);
            apos[ip] = P3.newP(p1);
            int s = this.vwr.ms.at[i3].getAtomSite() - 1;
            if (sites[s] == 0) {
                if (this.moveConstrained(i3, bsFixed, bsModelAtoms, p1, false, true, bsMoved) == null) {
                    return 0;
                }
                p1.sub(this.vwr.ms.at[i3]);
                p1.sub(vrel);
                pts[s] = P3.newP(p1);
                sites[s] = i3 + 1;
            }
            i3 = bsAll.nextSetBit(i3 + 1);
            ++ip;
        }
        bsMoved.clearAll();
        int i4 = sites.length;
        while (--i4 >= 0) {
            int ia = sites[i4] - 1;
            if (ia < 0) continue;
            p1.setT(this.vwr.ms.at[ia]);
            p1.add(vrel);
            if (this.moveConstrained(ia, bsFixed, bsModelAtoms, p1, true, true, bsMoved) != null) continue;
            bsMoved = null;
            break;
        }
        int n2 = n = bsMoved == null ? 0 : bsMoved.cardinality();
        if (n == 0) {
            this.vwr.ms.restoreAtomPositions(apos0);
            return 0;
        }
        return this.checkAtomPositions(apos0, apos, bsAll) ? n : 0;
    }

    private String assignSpaceGroup(SymmetryInterface sym00, String ita00, BS bs, Object paramsOrUC, String[] tokens, int index, M4 trm, ClegNode prevNode, SB sb) {
        String calcNext;
        boolean haveUCParams;
        if (index >= tokens.length) {
            return "invalid CLEG expression!";
        }
        boolean bl = haveUCParams = paramsOrUC != null;
        if (tokens.length > 1 && haveUCParams) {
            return "invalid syntax - can't mix transformations and UNITCELL option!";
        }
        String token = tokens[index].trim();
        boolean isSubgroupCalc = token.length() == 0 || token.equals("sub") || token.equals("super");
        String string = calcNext = isSubgroupCalc ? token : null;
        if (isSubgroupCalc) {
            token = tokens[++index].trim();
        }
        boolean isFinal = index == tokens.length - 1;
        int pt = token.lastIndexOf(":");
        boolean haveUnitCell = sym00 != null;
        boolean isUnknown = false;
        boolean haveTransform = token.length() == 0 || token.indexOf(44) > 0;
        boolean haveJmolSetting = !haveTransform && pt > 0 && pt < token.length() - 1;
        boolean isTransformOnly = haveTransform && pt < 0;
        String transform = haveTransform ? token.substring(pt + 1) : null;
        M4 trTemp = new M4();
        boolean restarted = false;
        SymmetryInterface sym = this.vwr.getSymTemp();
        System.out.println("MK " + token + " " + prevNode);
        if (prevNode == null) {
            if (!ClegNode.checkSyntax(tokens, sym)) {
                return "invalid CLEG expression!";
            }
            if (!(haveUnitCell || haveUCParams || !haveTransform && (pt = token.indexOf(46)) <= 0)) {
                String ita = token.substring(0, pt);
                String err = this.assignSpaceGroup(null, null, null, null, new String[]{ita}, 0, null, null, sb);
                if (err.endsWith("!")) {
                    return err;
                }
                sym00 = this.vwr.getOperativeSymmetry();
                if (sym00 == null) {
                    return "modelkit spacegroup initialization error!";
                }
                haveUnitCell = true;
                restarted = true;
            }
            String ita0 = haveUnitCell ? sym00.getIntTableNumber() : null;
            String trm0 = null;
            if (haveUnitCell) {
                if (ita0 == null || ita0.equals("0")) {
                    ita0 = sym00.getClegId();
                } else {
                    trm0 = (String)sym00.getSpaceGroupInfoObj("itaTransform", null, false, false);
                }
            }
            trm = new M4();
            trm.setIdentity();
            prevNode = new ClegNode(-1, ita0, trm0);
            if (!prevNode.update(this.vwr, null, trm, trTemp, sym)) {
                return prevNode.errString;
            }
        }
        if (isSubgroupCalc) {
            prevNode.calcNext = calcNext;
        }
        if (transform != null) {
            switch (transform) {
                case "r": 
                case "!h": {
                    transform = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
                    break;
                }
                case "h": 
                case "!r": {
                    transform = "!2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
                    break;
                }
                default: {
                    if (!haveJmolSetting) break;
                    pt = 0;
                    haveTransform = false;
                    transform = null;
                }
            }
            if (pt > 0) {
                token = token.substring(0, pt);
            }
        }
        if (isTransformOnly) {
            if (isFinal) {
                isUnknown = true;
                return "CLEG pathway is incomplete!";
            }
            if (transform == null || transform.length() == 0) {
                transform = "a,b,c";
            }
            sym.convertTransform(transform, trTemp);
            if (trm == null) {
                trm = trTemp;
            } else {
                trm.mul(trTemp);
            }
            if (token.length() != 0) {
                prevNode.addTransform(trTemp);
                System.out.println("ModelKit.assignSpaceGroup index=" + index + " trm=" + trm);
            }
            return this.assignSpaceGroup(sym00, ita00, bs, null, tokens, ++index, trm, prevNode, sb);
        }
        ClegNode node = new ClegNode(index, token, transform);
        if (!node.update(this.vwr, prevNode, trm, trTemp, sym)) {
            return node.errString;
        }
        node.updateTokens(tokens, index);
        if (!isFinal) {
            return this.assignSpaceGroup(sym00, ita00, bs, null, tokens, ++index, trm, node, sb);
        }
        float[] params = null;
        T3[] oabc = null;
        T3 origin = null;
        float[] fArray = params = !haveUCParams || !AU.isAD(paramsOrUC) ? null : (float[])paramsOrUC;
        if (!haveUnitCell) {
            float[] fArray2;
            if (params == null) {
                float[] fArray3 = new float[6];
                fArray3[0] = 10.0f;
                fArray3[1] = 10.0f;
                fArray3[2] = 10.0f;
                fArray3[3] = 90.0f;
                fArray3[4] = 90.0f;
                fArray2 = fArray3;
                fArray3[5] = 90.0f;
            } else {
                fArray2 = params;
            }
            sym.setUnitCellFromParams(fArray2, false, Float.NaN);
            paramsOrUC = null;
            haveUCParams = false;
        }
        if (haveUCParams) {
            if (AU.isAD(paramsOrUC)) {
                params = (float[])paramsOrUC;
            } else {
                oabc = (T3[])paramsOrUC;
                origin = oabc[0];
            }
        } else if (haveUnitCell) {
            sym = sym00;
            if (trm == null) {
                trm = new M4();
                trm.setIdentity();
            }
            oabc = sym.getV0abc(new Object[]{trm}, null);
            origin = oabc[0];
        }
        if (oabc != null) {
            params = sym.getUnitCell(oabc, false, "assign").getUnitCellParams();
            if (origin == null) {
                origin = oabc[0];
            }
        }
        boolean isP1 = token.equalsIgnoreCase("P1") || token.equals("ITA/1.1");
        this.clearAtomConstraints();
        try {
            Map sgInfo;
            boolean noAtoms;
            BS bsCell;
            if (bs != null && bs.isEmpty()) {
                return "no atoms specified!";
            }
            BS bsAtoms = this.vwr.getThisModelAtoms();
            BS bS = bsCell = isP1 ? bsAtoms : SV.getBitSet(this.vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
            if (bs == null) {
                bs = bsAtoms;
            }
            if (bs != null) {
                bsAtoms.and(bs);
                if (!isP1) {
                    bsAtoms.and(bsCell);
                }
            }
            int mi = (noAtoms = bsAtoms.isEmpty()) && this.vwr.am.cmi < 0 ? 0 : (noAtoms ? this.vwr.am.cmi : this.vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex());
            this.vwr.ms.getModelAuxiliaryInfo(mi).remove("spaceGroupInfo");
            if (haveUnitCell) {
                sym.replaceTransformMatrix(trm);
            }
            if (params == null) {
                params = sym.getUnitCellMultiplied().getUnitCellParams();
            }
            Map map = noAtoms && isUnknown ? null : (sgInfo = (Map)this.vwr.findSpaceGroup(sym, isUnknown ? bsAtoms : null, isUnknown ? null : node.name, params, origin, oabc, 2 | (haveUnitCell ? 0 : 4)));
            if (sgInfo == null) {
                return "Space group " + node.name + " is unknown or not compatible!";
            }
            if (oabc == null || !haveUnitCell) {
                oabc = (P3[])sgInfo.get("unitcell");
            }
            token = (String)sgInfo.get("name");
            String jmolId = (String)sgInfo.get("jmolId");
            BS basis = (BS)sgInfo.get("basis");
            SpaceGroup sg = (SpaceGroup)sgInfo.remove("sg");
            sym.getUnitCell(oabc, false, null);
            sym.setSpaceGroupTo(sg == null ? jmolId : sg);
            sym.setSpaceGroupName(token);
            if (basis == null) {
                basis = sym.removeDuplicates(this.vwr.ms, bsAtoms, true);
            }
            this.vwr.ms.setSpaceGroup(mi, sym, basis);
            if (!haveUnitCell || restarted) {
                this.appRunScript("unitcell on; center unitcell;axes unitcell; axes 0.1; axes on;set perspectivedepth false;moveto 0 axis c1;draw delete;show spacegroup");
            }
            transform = sym.staticGetTransformABC(trm, false);
            String msg = transform + "\n" + PT.join(tokens, '>', 0) + "\n basis=" + basis;
            System.out.println("ModelKit trm=" + msg);
            sb.append(msg).append("\n");
            return transform;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage() + "!";
        }
    }

    protected static M4 addSGTransform(SymmetryInterface sym, String tr, M4 trm0, M4 temp) {
        if (trm0 == null) {
            trm0 = new M4();
            trm0.setIdentity();
        }
        if (tr != null) {
            sym.convertTransform(tr, temp);
            trm0.mul(temp);
        }
        return trm0;
    }

    private boolean checkAtomPositions(P3[] apos0, P3[] apos, BS bs) {
        boolean ok = true;
        int ip = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if ((double)this.vwr.ms.at[i].distanceSquared(apos[ip]) > 1.0E-8) {
                ok = false;
                break;
            }
            i = bs.nextSetBit(i + 1);
            ++ip;
        }
        if (ok) {
            return true;
        }
        this.vwr.ms.restoreAtomPositions(apos0);
        return false;
    }

    private void clearElementKey(int modelIndex) {
        if (!this.haveElementKeys) {
            return;
        }
        String key = ModelKit.getElementKey(modelIndex) + "*";
        Object[][] val = new Object[][]{{"thisID", key}, {"delete", null}};
        this.vwr.shm.setShapeProperties(22, val);
        this.vwr.shm.setShapeProperties(31, val);
        if (modelIndex < 0) {
            this.bsElementKeyModels.clearAll();
            this.haveElementKeys = false;
        } else {
            this.bsElementKeyModels.clear(modelIndex);
            this.haveElementKeys = !this.bsElementKeyModels.isEmpty();
        }
    }

    private boolean clickProcessAtom(int atomIndex) {
        switch (this.getMKState()) {
            case 0: {
                return this.vwr.isModelkitPickingRotateBond();
            }
            case 1: {
                this.centerAtomIndex = atomIndex;
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                this.showXtalSymmetry();
                return true;
            }
            case 2: {
                if (atomIndex == this.centerAtomIndex) {
                    return true;
                }
                ModelKit.notImplemented("edit click");
                return false;
            }
        }
        ModelKit.notImplemented("atom click unknown XTAL state");
        return false;
    }

    private void clickProcessMode(String action) {
        this.processMKPropertyItem(action, false);
    }

    private void clickProcessSel(String action) {
        if (action == "mksel_atom") {
            this.centerPoint = null;
            this.centerAtomIndex = -1;
            this.secondAtomIndex = -1;
        } else if (action == "mksel_position") {
            String pos = this.promptUser("Enter three fractional coordinates", this.lastCenter);
            if (pos == null) {
                return;
            }
            this.lastCenter = pos;
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                this.clickProcessSel(action);
                return;
            }
            this.centerAtomIndex = -2147483647;
            this.centerPoint = p;
            this.showXtalSymmetry();
        }
    }

    private String clickProcessSelOp(String action) {
        this.secondAtomIndex = -1;
        if (action == "mkselop_addoffset") {
            String pos = this.promptUser("Enter i j k for an offset for viewing the operator - leave blank to clear", this.lastOffset);
            if (pos == null) {
                return null;
            }
            this.lastOffset = pos;
            if (pos.length() == 0 || pos == "none") {
                this.setProperty("offset", "none");
                return null;
            }
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                return action;
            }
            this.setProperty("offset", p);
        } else if (action == "mkselop_atom2") {
            ModelKit.notImplemented(action);
        }
        return null;
    }

    private void clickProcessSym(String action) {
        if (action == "mksymmetry_none") {
            this.setSymEdit(0);
        } else {
            this.processMKPropertyItem(action, false);
        }
    }

    private void clickProcessUC(String action) {
        this.processMKPropertyItem(action, false);
        this.showXtalSymmetry();
    }

    private void connectAtoms(float bd, int bondOrder, BS bs1, BS bs2) {
        this.vwr.makeConnections(bd - 0.01f, bd + 0.01f, bondOrder, 1073742026, bs1, bs2, new BS(), false, false, 0.0f);
    }

    private boolean fillPointsForMove(SymmetryInterface sg, BS bseq, int i0, P3 a, P3 pt, P3[] points) {
        float d = a.distance(pt);
        P3 fa = P3.newP(a);
        P3 fb = P3.newP(pt);
        sg.toFractional(fa, false);
        sg.toFractional(fb, false);
        int k = 0;
        int i = i0;
        while (i >= 0) {
            P3 p = P3.newP(this.vwr.ms.at[i]);
            P3 p0 = P3.newP(p);
            sg.toFractional(p, false);
            M4 m = sg.getTransform(fa, p, false);
            if (m == null) {
                return false;
            }
            P3 p2 = P3.newP(fb);
            m.rotTrans(p2);
            sg.toCartesian(p2, false);
            if ((double)Math.abs(d - p0.distance(p2)) > 0.001) {
                return false;
            }
            points[k++] = p2;
            i = bseq.nextSetBit(i + 1);
        }
        fa.setT(points[0]);
        sg.toFractional(fa, false);
        k = points.length;
        while (--k >= 0) {
            fb.setT(points[k]);
            sg.toFractional(fb, false);
            M4 m = sg.getTransform(fa, fb, false);
            if (m == null) {
                return false;
            }
            int i2 = points.length;
            while (--i2 > k) {
                if (!((double)points[i2].distance(points[k]) < 0.1)) continue;
                return false;
            }
        }
        return true;
    }

    private String getBondLabel(Atom[] atoms) {
        return atoms[Math.min(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName() + "-" + atoms[Math.max(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName();
    }

    private int getBondOrder(char type, Bond bond) {
        if (type == '-') {
            type = this.pickBondAssignType;
        }
        int bondOrder = type - 48;
        switch (type) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                break;
            }
            case 'm': 
            case 'p': {
                bondOrder = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (type == 'p' ? 1 : -1);
                if (bondOrder > 3) {
                    bondOrder = 1;
                    break;
                }
                if (bondOrder >= 0) break;
                bondOrder = 3;
                break;
            }
            default: {
                return -1;
            }
        }
        return bondOrder;
    }

    private String getHoverLabel(int atomIndex) {
        int state = this.getMKState();
        String msg = null;
        block0 : switch (state) {
            case 1: {
                if (this.symop == null) {
                    this.symop = 1;
                }
                msg = "view symop " + this.symop + " for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 2: {
                msg = "start editing for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 0: {
                Atom[] atoms = this.vwr.ms.at;
                if (this.isRotateBond) {
                    this.setBranchAtom(atomIndex, false);
                    String string = msg = this.branchAtomIndex >= 0 ? "rotate branch " + atoms[atomIndex].getAtomName() : "rotate bond for " + this.getBondLabel(atoms);
                }
                if (this.bondIndex < 0) {
                    if (this.atomHoverLabel.length() <= 2) {
                        msg = this.atomHoverLabel = "Click to change to " + this.atomHoverLabel + " or drag to add " + this.atomHoverLabel;
                        break;
                    }
                    msg = atoms[atomIndex].getAtomName() + ": " + this.atomHoverLabel;
                    this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    break;
                }
                if (msg != null) break;
                switch (this.isRotateBond ? this.bsHighlight.cardinality() : (atomIndex >= 0 ? 1 : -1)) {
                    case 0: {
                        this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    }
                    case 1: 
                    case 2: {
                        Atom a = this.vwr.ms.at[atomIndex];
                        if (!this.isRotateBond) {
                            this.menu.setActiveMenu(ATOM_MODE);
                            if (this.vwr.acm.getAtomPickingMode() == 1) {
                                return null;
                            }
                        }
                        if (this.atomHoverLabel.indexOf("charge") >= 0) {
                            int ch = a.getFormalCharge();
                            msg = this.atomHoverLabel + " to " + ((ch += this.atomHoverLabel.indexOf("increase") >= 0 ? 1 : -1) > 0 ? "+" : "") + ch;
                        } else {
                            msg = this.atomHoverLabel;
                        }
                        msg = atoms[atomIndex].getAtomName() + ": " + msg;
                        break block0;
                    }
                    case -1: {
                        msg = (this.bondHoverLabel.length() == 0 ? "" : this.bondHoverLabel + " for ") + this.getBondLabel(atoms);
                    }
                }
            }
        }
        return msg;
    }

    private Object getinfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.addInfo(info, "addHydrogens", this.addHydrogens);
        this.addInfo(info, "autobond", this.autoBond);
        this.addInfo(info, "clickToSetElement", this.clickToSetElement);
        this.addInfo(info, "hidden", this.menu.hidden);
        this.addInfo(info, "showSymopInfo", this.showSymopInfo);
        this.addInfo(info, "centerPoint", this.centerPoint);
        this.addInfo(info, "centerAtomIndex", this.centerAtomIndex);
        this.addInfo(info, "secondAtomIndex", this.secondAtomIndex);
        this.addInfo(info, "symop", this.symop);
        this.addInfo(info, "offset", this.viewOffset);
        this.addInfo(info, "drawData", this.drawData);
        this.addInfo(info, "drawScript", this.drawScript);
        this.addInfo(info, "isMolecular", this.getMKState() == 0);
        return info;
    }

    private static Atom getNearestBondedAtom(Atom a1, Atom butNotThis) {
        Bond[] b = a1.bonds;
        Atom ret = null;
        int zmin = Integer.MAX_VALUE;
        int i = a1.getBondCount();
        while (--i >= 0) {
            Atom a2;
            if (b[i] == null || !b[i].isCovalent() || (a2 = b[i].getOtherAtom(a1)) == butNotThis || a2.sZ >= zmin) continue;
            zmin = a2.sZ;
            ret = a2;
        }
        return ret;
    }

    private boolean handleAtomDragging(int[] countPlusIndices) {
        switch (this.getMKState()) {
            case 0: {
                return false;
            }
            case 2: {
                if (countPlusIndices[0] > 2) {
                    return true;
                }
                ModelKit.notImplemented("drag atom for XTAL edit");
                break;
            }
            case 1: {
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                switch (countPlusIndices[0]) {
                    case 1: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = -1;
                        break;
                    }
                    case 2: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = countPlusIndices[2];
                    }
                }
                this.showXtalSymmetry();
                return true;
            }
        }
        return true;
    }

    private boolean handleAtomOrBondPicked(int x, int y, MeasurementPending mp, int dragAtomIndex, String atomType, boolean inRange) {
        boolean isCharge = this.isPickAtomAssignCharge;
        if (mp != null && mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            Atom a = (Atom)mp.getAtom(1);
            Atom b = (Atom)mp.getAtom(2);
            Bond bond = a.getBond(b);
            if (bond == null) {
                this.cmdAssignConnect(a.i, b.i, '1', "click");
            } else {
                this.cmdAssignBond(bond.index, 'p', "click");
            }
        } else {
            if (atomType.equals("Xx")) {
                atomType = this.lastElementType;
            }
            if (inRange) {
                this.vwr.undoMoveActionClear(dragAtomIndex, 4, true);
            } else {
                this.vwr.undoMoveActionClear(-1, 4146, true);
            }
            Atom a = this.vwr.ms.at[dragAtomIndex];
            boolean wasH = a != null && a.getElementNumber() == 1;
            this.clickAssignAtom(dragAtomIndex, atomType, null);
            if (isCharge) {
                this.appRunScript("{atomindex=" + dragAtomIndex + "}.label='%C'");
            } else {
                this.vwr.undoMoveActionClear(-1, 4146, true);
                if (a == null || inRange) {
                    return false;
                }
                if (wasH) {
                    this.clickAssignAtom(dragAtomIndex, "X", null);
                } else {
                    P3 ptNew = P3.new3(x, y, a.sZ);
                    this.vwr.tm.unTransformPoint(ptNew, ptNew);
                    this.clickAssignAtom(dragAtomIndex, atomType, ptNew);
                }
            }
        }
        return true;
    }

    private void minimizeXtal(JmolScriptEvaluator eval, BS bsBasis, int steps, float crit, float rangeFixed, int flags) throws Exception {
        this.minBasisModel = this.vwr.am.cmi;
        this.minSelectionSaved = this.vwr.bsA();
        this.vwr.am.setFrame(this.minBasisModel);
        this.minBasis = bsBasis;
        this.minBasisFixed = this.vwr.getMotionFixedAtoms(null, null);
        this.minBasisModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.minBasisModel);
        String cif = this.vwr.getModelExtract(bsBasis, false, false, "cif");
        int tempModelIndex = this.vwr.ms.mc;
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        htParams.put("eval", eval);
        htParams.put("lattice", P3.new3(444.0f, 666.0f, 1.0f));
        htParams.put("fileData", cif);
        htParams.put("loadScript", new SB());
        if (this.vwr.loadModelFromFile(null, "<temp>", null, null, true, htParams, null, null, 0, " ") != null) {
            return;
        }
        BS bsBasis2 = BSUtil.copy(this.vwr.ms.am[tempModelIndex].bsAsymmetricUnit);
        this.minTempModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(tempModelIndex);
        this.vwr.am.setFrame(tempModelIndex);
        this.minTempFixed = BSUtil.copy(this.minTempModelAtoms);
        this.minTempFixed.andNot(bsBasis2);
        this.vwr.getMotionFixedAtoms(null, this.minTempFixed);
        this.vwr.minimize(eval, steps, crit, BSUtil.copy(bsBasis2), this.minTempFixed, this.minTempModelAtoms, rangeFixed, flags & 0xFFFFFEFF);
    }

    private void minimizeXtalEnd(BS bsBasis2, boolean isEnd) {
        if (this.minBasis == null) {
            return;
        }
        if (bsBasis2 != null) {
            P3[] pts = new P3[bsBasis2.cardinality()];
            int p = 0;
            int j = this.minBasis.nextSetBit(0);
            int i = bsBasis2.nextSetBit(0);
            while (i >= 0) {
                pts[p++] = P3.newP(this.vwr.ms.at[i].getXYZ());
                i = bsBasis2.nextSetBit(i + 1);
                j = this.minBasis.nextSetBit(j + 1);
            }
            BS bs = BSUtil.copy(this.minBasis);
            bs.andNot(this.minBasisFixed);
            this.assignMoveAtoms(null, bs, this.minBasisFixed, this.minBasisModelAtoms, this.minBasis.nextSetBit(0), null, pts, true, false);
        }
        if (isEnd) {
            this.minSelectionSaved = null;
            this.minBasis = null;
            this.minBasisFixed = null;
            this.minTempFixed = null;
            this.minTempModelAtoms = null;
            this.minBasisModelAtoms = null;
            this.minBasisAtoms = null;
            this.modelSyms = null;
            this.vwr.deleteModels(this.vwr.ms.mc - 1, null);
            this.vwr.setSelectionSet(this.minSelectionSaved);
            this.vwr.setCurrentModelIndex(this.minBasisModel);
        }
    }

    private BS moveConstrained(int iatom, BS bsFixed, BS bsModelAtoms, P3 ptNew, boolean doAssign, boolean allowProjection, BS bsMoved) {
        SymmetryInterface sym = this.getSym(iatom);
        if (sym == null) {
            return null;
        }
        if (bsMoved == null) {
            bsMoved = BSUtil.newAndSetBit(iatom);
        }
        Atom a = this.vwr.ms.at[iatom];
        Constraint c = this.constraint;
        M4 minv = null;
        if (c == null) {
            c = this.setConstraint(sym, iatom, GET_CREATE);
            if (c.type == 6) {
                iatom = -1;
            } else {
                Atom b = this.getBasisAtom(iatom);
                if (a != b) {
                    M4 m = ModelKit.getTransform(sym, a, b);
                    if (m == null) {
                        System.err.println("ModelKit - null matrix for " + iatom + " " + a + " to " + b);
                        iatom = -1;
                    } else {
                        if (!doAssign) {
                            minv = M4.newM4(m);
                            minv.invert();
                        }
                        iatom = b.i;
                        P3 p = P3.newP(ptNew);
                        sym.toFractional(p, false);
                        m.rotTrans(p);
                        sym.toCartesian(p, false);
                        ptNew.setT(p);
                    }
                }
                if (iatom >= 0) {
                    c.constrain(b, ptNew, allowProjection);
                }
            }
        } else {
            c.constrain(a, ptNew, allowProjection);
        }
        if (iatom >= 0 && !Float.isNaN(ptNew.x)) {
            if (!doAssign) {
                if (minv != null) {
                    P3 p = P3.newP(ptNew);
                    sym.toFractional(p, false);
                    minv.rotTrans(p);
                    sym.toCartesian(p, false);
                    ptNew.setP(p);
                }
                return bsMoved;
            }
            if (this.assignMoveAtom(iatom, ptNew, bsFixed, bsModelAtoms, bsMoved) == 0) {
                bsMoved = null;
            }
        }
        ptNew.x = Float.NaN;
        return bsMoved;
    }

    private String promptUser(String msg, String def) {
        return this.vwr.prompt(msg, def, null, false);
    }

    private void resetBondFields() {
        this.bsRotateBranch = null;
        this.bondAtomIndex2 = -1;
        this.bondAtomIndex1 = -1;
        this.branchAtomIndex = -1;
    }

    private int rotateAtoms(BS bsAtoms, P3[] points, float endDegrees) {
        P3 center = points[0];
        P3 p = new P3();
        int i0 = bsAtoms.nextSetBit(0);
        SymmetryInterface sg = this.getSym(i0);
        BS bsAU = new BS();
        BS bsToMove = new BS();
        int i = i0;
        while (i >= 0) {
            int bai = this.getBasisAtom((int)i).i;
            if (!bsAU.get(bai)) {
                if (this.setConstraint((SymmetryInterface)sg, (int)bai, (int)ModelKit.GET_CREATE).type == 6) {
                    return 0;
                }
                bsAU.set(bai);
                bsToMove.set(i);
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        int nAtoms = bsAtoms.cardinality();
        P3[] apos0 = this.vwr.ms.saveAtomPositions();
        M3 m = Quat.newVA(V3.newVsub(points[1], points[0]), endDegrees).getMatrix();
        V3 vt = new V3();
        P3[] apos = new P3[nAtoms];
        int ip = 0;
        int i2 = i0;
        while (i2 >= 0) {
            Atom a = this.vwr.ms.at[i2];
            int n = ip++;
            P3 p3 = P3.newP(a);
            apos[n] = p3;
            p = p3;
            vt.sub2(p, center);
            m.rotate(vt);
            p.add2(center, vt);
            this.setConstraint(sg, i2, GET_CREATE).constrain(a, p, false);
            if (Float.isNaN(p.x)) {
                return 0;
            }
            i2 = bsAtoms.nextSetBit(i2 + 1);
        }
        nAtoms = 0;
        BS bsFixed = this.vwr.getMotionFixedAtoms(sg, null);
        BS bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
        BS bsMoved = new BS();
        int ip2 = 0;
        int i3 = i0;
        while (i3 >= 0) {
            nAtoms += this.assignMoveAtom(i3, apos[ip2], bsFixed, bsModelAtoms, bsMoved);
            i3 = bsToMove.nextSetBit(i3 + 1);
            ++ip2;
        }
        BS bs = BSUtil.copy(bsAtoms);
        bs.andNot(bsToMove);
        return this.checkAtomPositions(apos0, apos, bs) ? nAtoms : 0;
    }

    private String runScriptBuffered(String script) {
        SB sb = new SB();
        try {
            ((ScriptEval)this.vwr.eval).runBufferedSafely(script, sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private void setBondIndex(int index, boolean isRotate) {
        boolean haveBond;
        if (!isRotate && this.vwr.isModelkitPickingRotateBond()) {
            this.setProperty("rotatebondindex", index);
            return;
        }
        boolean bl = haveBond = this.bondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        if (index < 0) {
            this.resetBondFields();
            return;
        }
        this.bsRotateBranch = null;
        this.branchAtomIndex = -1;
        this.bondIndex = index;
        this.isRotateBond = isRotate;
        this.bondAtomIndex1 = this.vwr.ms.bo[index].getAtomIndex1();
        this.bondAtomIndex2 = this.vwr.ms.bo[index].getAtomIndex2();
        this.menu.setActiveMenu(BOND_MODE);
    }

    private void setBranchAtom(int atomIndex, boolean isClick) {
        boolean isBondedAtom;
        boolean bl = isBondedAtom = atomIndex == this.bondAtomIndex1 || atomIndex == this.bondAtomIndex2;
        if (isBondedAtom) {
            this.branchAtomIndex = atomIndex;
            this.bsRotateBranch = null;
        } else {
            this.bsRotateBranch = null;
            this.branchAtomIndex = -1;
        }
    }

    private void setDefaultState(int mode) {
        if (!this.hasUnitCell) {
            mode = 0;
        }
        if (!this.hasUnitCell || this.isXtalState() != this.hasUnitCell) {
            this.setMKState(mode);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.getSymViewState() != 0) break;
                    this.setSymViewState(8);
                    break;
                }
            }
        }
    }

    private boolean isElementKeyOn(int modelIndex) {
        Object[] data = new Object[]{ModelKit.getElementKey(modelIndex) + "*", null};
        this.vwr.shm.getShapePropertyData(31, "checkID", data);
        return data[1] != null;
    }

    private void updateElementKeyFromStateScript() {
        int i = this.vwr.ms.mc;
        while (--i >= 0) {
            if (!this.isElementKeyOn(i)) continue;
            this.bsElementKeyModels.set(i);
        }
    }

    private void setElementKey(int modelIndex, boolean isOn) {
        if (isOn && modelIndex >= 0 && this.bsElementKeyModels.get(modelIndex)) {
            return;
        }
        this.clearElementKey(modelIndex);
        if (!isOn || modelIndex < 0) {
            return;
        }
        new EKey(this.vwr, modelIndex).draw(this.vwr);
        this.bsElementKeyModels.set(modelIndex);
        this.haveElementKeys = true;
    }

    private void setSymEdit(int bits) {
        this.state = this.state & 0xFFFFFF1F | bits;
    }

    private void setSymViewState(int bits) {
        this.state = this.state & 0xFFFFFFE3 | bits;
    }

    private void setUnitCell(int bits) {
        this.state = this.state & 0xFFFFF8FF | bits;
    }

    private void showSymop(Object symop) {
        this.secondAtomIndex = -1;
        this.symop = symop;
        this.showXtalSymmetry();
    }

    private void showXtalSymmetry() {
        String script = null;
        switch (this.getSymViewState()) {
            case 0: {
                script = "draw * delete";
                break;
            }
            default: {
                P3 offset = null;
                if (this.secondAtomIndex >= 0) {
                    script = "draw ID sym symop " + (this.centerAtomIndex < 0 ? this.centerPoint : " {atomindex=" + this.centerAtomIndex + "}") + " {atomindex=" + this.secondAtomIndex + "}";
                } else {
                    offset = this.viewOffset;
                    if (this.symop == null) {
                        this.symop = 1;
                    }
                    int iatom = this.centerAtomIndex >= 0 ? this.centerAtomIndex : (this.centerPoint != null ? -1 : this.iatom0);
                    script = "draw ID sym symop " + (this.symop == null ? "1" : (this.symop instanceof String ? "'" + this.symop + "'" : PT.toJSON(null, this.symop))) + (iatom < 0 ? this.centerPoint : " {atomindex=" + iatom + "}") + (offset == null ? "" : " offset " + offset);
                }
                this.drawData = this.runScriptBuffered(script);
                this.drawScript = script;
                this.drawData = this.showSymopInfo ? this.drawData.substring(0, this.drawData.indexOf("\n") + 1) : "";
                this.appRunScript(";refresh;set echo top right;echo " + this.drawData.replace('\t', ' '));
            }
        }
    }

    private void updateElementKey(BS bsAtoms) {
        if (bsAtoms == null) {
            this.updateModelElementKey(this.vwr.am.cmi, true);
            return;
        }
        if (bsAtoms.cardinality() == 1) {
            this.updateModelElementKey(this.vwr.ms.at[bsAtoms.nextSetBit((int)0)].mi, true);
            return;
        }
        int i = this.vwr.ms.mc;
        while (--i >= 0) {
            if (!this.vwr.ms.am[i].bsAtoms.intersects(bsAtoms)) continue;
            this.updateModelElementKey(i, true);
        }
    }

    private void updateModelElementKeys(BS bsModels, boolean forceNew) {
        if (bsModels == null) {
            bsModels = BSUtil.newBitSet2(0, this.vwr.ms.mc);
        }
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            this.updateModelElementKey(i, forceNew);
            i = bsModels.nextSetBit(i + 1);
        }
    }

    private void updateModelElementKey(int modelIndex, boolean forceNew) {
        if (this.doUpdateElementKey(modelIndex)) {
            if (forceNew) {
                this.clearElementKey(modelIndex);
            }
            this.setElementKey(modelIndex, true);
        }
    }

    private boolean doUpdateElementKey(int modelIndex) {
        return modelIndex >= 0 && !this.vwr.ms.isJmolDataFrameForModel(modelIndex) && !this.bsElementKeyModelsOFF.get(modelIndex) && (this.setElementKeys || this.isElementKeyOn(modelIndex));
    }

    private void setElementKeys(boolean isOn) {
        this.setElementKeys = isOn;
        if (isOn) {
            this.clearElementKeysOFF();
        }
        this.clearElementKey(-1);
        if (isOn) {
            this.updateModelElementKeys(null, false);
        }
    }

    private void clearElementKeysOFF() {
        this.bsElementKeyModelsOFF.clearAll();
    }

    public boolean transformAtomsToUnitCell(SymmetryInterface sym, T3[] oabc, String ucname) {
        boolean isReset;
        BS bsAtoms = this.vwr.getThisModelAtoms();
        int n = bsAtoms.cardinality();
        boolean bl = isReset = sym == null || n == 0;
        if (!isReset) {
            Atom[] a = this.vwr.ms.at;
            P3[] fxyz = this.getFractionalCoordinates(sym, bsAtoms);
            this.vwr.ms.setModelCagePts(-1, oabc, ucname);
            sym = this.vwr.getCurrentUnitCell();
            int j = bsAtoms.nextSetBit(0);
            int k = 0;
            while (j >= 0) {
                a[j].setT(fxyz[k]);
                this.vwr.toCartesianUC(sym, a[j], false);
                j = bsAtoms.nextSetBit(j + 1);
                ++k;
            }
            this.vwr.ms.setTaintedAtoms(bsAtoms, 2);
        }
        return isReset;
    }

    private P3[] getFractionalCoordinates(SymmetryInterface sym, BS bsAtoms) {
        int n = bsAtoms.cardinality();
        Atom[] a = this.vwr.ms.at;
        P3[] fxyz = new P3[n];
        int j = bsAtoms.nextSetBit(0);
        int k = 0;
        while (j >= 0) {
            fxyz[k] = P3.newP(a[j]);
            this.vwr.toFractionalUC(sym, fxyz[k], false);
            j = bsAtoms.nextSetBit(j + 1);
            ++k;
        }
        return fxyz;
    }

    public synchronized void updateDrawAtomSets(String mode, BS atoms) {
        if (this.drawAtomSets == null) {
            return;
        }
        String cmd = "";
        int i = this.drawAtomSets.size();
        while (--i >= 0) {
            DrawAtomSet a = (DrawAtomSet)this.drawAtomSets.get(i);
            if (mode == "deleteModelAtoms" ? atoms.get(a.bsAtoms.nextSetBit(0)) : atoms.intersects(a.bsAtoms)) {
                switch (mode) {
                    case "deleteModelAtoms": 
                    case "atomsDeleted": {
                        System.out.println("remove deleteatoms " + atoms + " " + a.bsAtoms + a.id);
                        this.drawAtomSets.removeItemAt(i);
                        break;
                    }
                    case "atomsMoved": {
                        try {
                            if (!this.checkDrawID(a.id)) {
                                this.drawAtomSets.removeItemAt(i);
                                break;
                            }
                            cmd = cmd + a.cmd + "#quiet" + "\n";
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.drawAtomSets.size() == 0) {
                    this.drawAtomSets = null;
                }
            }
            if (cmd.length() <= 0) continue;
            this.vwr.evalStringGUI(cmd);
        }
    }

    private boolean checkDrawID(String id) {
        Object[] o = new Object[]{id + "*", null};
        boolean exists = this.vwr.shm.getShapePropertyData(22, "checkID", o);
        return exists && o[1] != null;
    }

    public void drawSymop(int a1, int a2) {
        String s = "({" + a1 + "}) ({" + a2 + "}) ";
        String cmd = "draw ID 'sym' symop " + s;
        this.vwr.evalStringGUI(cmd);
    }

    public void addAtomSet(String data) {
        String[] tokens = PT.split(data, "|");
        String id = tokens[0];
        this.clearAtomSets(id);
        int a1 = PT.parseInt(tokens[1]);
        int a2 = PT.parseInt(tokens[2]);
        String cmd = tokens[3];
        BS bs = BSUtil.newAndSetBit(a1);
        bs.set(a2);
        if (this.drawAtomSets == null) {
            this.drawAtomSets = new Lst();
        }
        this.drawAtomSets.addLast(new DrawAtomSet(bs, id, cmd));
    }

    private void clearAtomSets(String id) {
        if (this.drawAtomSets == null) {
            return;
        }
        int i = this.drawAtomSets.size();
        while (--i >= 0) {
            DrawAtomSet a = (DrawAtomSet)this.drawAtomSets.get(i);
            if (!a.id.equals(id)) continue;
            this.drawAtomSets.remove(i);
            return;
        }
    }

    public void drawUnitCell(String id, T3 ucLattice, String swidth) {
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        if (sym == null) {
            return;
        }
        SymmetryInterface uc = this.vwr.getSymTemp().getUnitCell(sym.getUnitCellVectors(), false, "draw");
        uc.setOffsetPt(ucLattice);
        P3[] cellRange = new P3[]{new P3(), new P3()};
        String s = "";
        if (id == null) {
            id = "uclat";
        }
        Object[][] val = new Object[][]{{"thisID", id + "*"}, {"delete", null}};
        this.vwr.shm.setShapeProperties(22, val);
        SimpleUnitCell.getCellRange(ucLattice, cellRange);
        int p = 1;
        int x = (int)cellRange[0].x;
        while ((float)x < cellRange[1].x) {
            int y = (int)cellRange[0].y;
            while ((float)y < cellRange[1].y) {
                int z = (int)cellRange[0].z;
                while ((float)z < cellRange[1].z) {
                    s = s + "\ndraw ID " + PT.esc(id + "_" + p) + " " + swidth + " unitcell \"a,b,c;" + x + "," + y + "," + z + "\"";
                    ++z;
                    ++p;
                }
                ++y;
            }
            ++x;
        }
        s = s + this.getDrawAxes(id, swidth);
        this.appRunScript(s);
    }

    public void drawAxes(String id, String swidth) {
        String s = this.getDrawAxes(id, swidth);
        if (s.length() > 0) {
            this.appRunScript(s);
        }
    }

    private String getDrawAxes(String id, String swidth) {
        if (this.vwr.g.axesMode != 0x24000020 || this.vwr.shm.getShapePropertyIndex(34, "axesTypeXY", 0) == Boolean.TRUE) {
            return "";
        }
        if (id == null) {
            id = "uca";
        }
        if (swidth.indexOf(".") > 0) {
            swidth = swidth + "05";
        }
        P3 origin = (P3)this.vwr.shm.getShapePropertyIndex(34, "originPoint", 0);
        P3[] axisPoints = (P3[])this.vwr.shm.getShapePropertyIndex(34, "axisPoints", 0);
        String s = "";
        String[] colors = new String[]{"red", "green", "blue"};
        int i = 0;
        int a = 6;
        while (i < 3) {
            s = s + "\ndraw ID " + PT.esc(id + "_axis_" + JC.axisLabels[a]) + " " + swidth + " line " + origin + " " + axisPoints[i] + " color " + colors[i];
            ++i;
            ++a;
        }
        return s;
    }

    private class DrawAtomSet {
        BS bsAtoms;
        String cmd;
        String id;

        DrawAtomSet(BS bs, String id, String cmd) {
            this.bsAtoms = bs;
            this.cmd = cmd;
            this.id = id;
        }
    }

    private static class WyckoffModulation
    extends Vibration {
        private static final int wyckoffFactor = 10;
        private Vibration oldVib;
        private Atom atom = null;
        private float t;
        private Atom baseAtom = null;
        private P3 pt0 = new P3();
        private P3 ptf = new P3();
        private SymmetryInterface sym;
        private Constraint c;

        static void setVibrationMode(ModelKit mk, Object value) {
            Atom[] atoms = mk.vwr.ms.at;
            BS bsAtoms = mk.vwr.getThisModelAtoms();
            if ("off".equals(value)) {
                int i = bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    Vibration v = atoms[i].getVibrationVector();
                    if (v == null || v.modDim == -3) {
                        mk.vwr.ms.setVibrationVector(i, ((WyckoffModulation)v).oldVib);
                    }
                    i = bsAtoms.nextSetBit(i + 1);
                }
            } else if ("wyckoff".equals(value)) {
                int i = bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    Vibration v = atoms[i].getVibrationVector();
                    if (v == null || v.modDim == -3) {
                        SymmetryInterface sym = mk.getSym(i);
                        WyckoffModulation wv = null;
                        if (sym != null) {
                            Constraint c = mk.setConstraint(sym, i, GET_CREATE);
                            if (c.type != 6) {
                                wv = new WyckoffModulation(sym, c, atoms[i], mk.getBasisAtom(i));
                            }
                        }
                        mk.vwr.ms.setVibrationVector(i, wv);
                    }
                    i = bsAtoms.nextSetBit(i + 1);
                }
            }
            mk.vwr.setVibrationPeriod(Float.NaN);
        }

        private WyckoffModulation(SymmetryInterface sym, Constraint c, Atom atom, Atom baseAtom) {
            this.setType(-3);
            this.sym = sym;
            this.c = c;
            this.atom = atom;
            this.baseAtom = baseAtom;
            this.x = 1.0f;
        }

        @Override
        public T3 setCalcPoint(T3 pt, T3 t456, float scale, float modulationScale) {
            Vibration v = this.baseAtom.getVibrationVector();
            if (v == null || v.modDim != -3) {
                return pt;
            }
            WyckoffModulation wv = (WyckoffModulation)v;
            if (this.sym == null) {
                return pt;
            }
            M4 m = null;
            if (wv.atom != this.atom && (m = ModelKit.getTransform(this.sym, wv.atom, this.atom)) == null) {
                return pt;
            }
            if (wv.t != t456.x && (int)(t456.x * 10.0f) % 2 == 0) {
                if (this.c.type != 6) {
                    wv.setPos(this.sym, this.c, scale);
                }
                wv.t = t456.x;
            }
            if (m == null) {
                pt.setT(wv.ptf);
            } else {
                m.rotTrans2(wv.ptf, pt);
            }
            this.sym.toCartesian(pt, false);
            return pt;
        }

        private void setPos(SymmetryInterface sym, Constraint c, float scale) {
            this.x = (float)(Math.random() - 0.5) / 10.0f * scale;
            this.y = (float)(Math.random() - 0.5) / 10.0f * scale;
            this.z = (float)(Math.random() - 0.5) / 10.0f * scale;
            this.pt0.setT(this.atom);
            this.ptf.setT(this.pt0);
            this.ptf.add(this);
            c.constrain(this.pt0, this.ptf, true);
            sym.toFractional(this.ptf, false);
        }
    }

    private static class EKey {
        BS bsElements = new BS();
        int nAtoms;
        String[][] elementStrings = new String[120][10];
        int[][] colors = new int[120][10];
        int[] isotopeCounts = new int[120];
        private int modelIndex;

        EKey(Viewer vwr, int modelIndex) {
            BS bsAtoms = vwr.getModelUndeletedAtomsBitSet(modelIndex);
            this.nAtoms = bsAtoms == null ? 0 : bsAtoms.cardinality();
            this.modelIndex = modelIndex;
            if (this.nAtoms == 0) {
                return;
            }
            Atom[] a = vwr.ms.at;
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                int j;
                String elem = a[i].getElementSymbol();
                int elemno = a[i].getElementNumber();
                int color = a[i].atomPropertyInt(1765808134);
                int niso = this.isotopeCounts[elemno];
                for (j = 0; j < niso; ++j) {
                    if (!this.elementStrings[elemno][j].equals(elem)) continue;
                    if (this.colors[elemno][j] == color) break;
                    this.nAtoms = 0;
                    return;
                }
                if (j >= niso) {
                    this.bsElements.set(elemno);
                    int n = elemno;
                    this.isotopeCounts[n] = this.isotopeCounts[n] + 1;
                    this.elementStrings[elemno][j] = elem;
                    this.colors[elemno][j] = color;
                }
                i = bsAtoms.nextSetBit(i + 1);
            }
        }

        void draw(Viewer vwr) {
            if (this.nAtoms == 0) {
                return;
            }
            String key = ModelKit.getElementKey(this.modelIndex);
            int h = vwr.getScreenHeight();
            Font font = vwr.getFont3D("SansSerif", "Bold", h * 20 / 400);
            int y = 90;
            int elemno = this.bsElements.nextSetBit(0);
            while (elemno >= 0) {
                int n = this.isotopeCounts[elemno];
                if (n != 0) {
                    String[] elem = this.elementStrings[elemno];
                    for (int j = 0; j < n; ++j) {
                        String label = elem[j];
                        int color = this.colors[elemno][j];
                        vwr.shm.setShapeProperties(22, {"init", "elementKey"}, {"thisID", key + "d_" + label}, {"diameter", Float.valueOf(2.0f)}, {"modelIndex", this.modelIndex}, {"points", 0}, {"coord", P3.new3(90.0f, y, -3.4028235E38f)}, {"set", null}, {"color", color}, {"thisID", null});
                        vwr.shm.setShapeProperties(31, {"thisID", null}, {"target", key + "e_" + label}, {"model", this.modelIndex}, {"xypos", P3.new3(91.0f, y - 2, -3.4028235E38f)}, {"text", label}, {"font", font}, {"color", -74566}, {"thisID", null});
                        y -= 5;
                    }
                }
                elemno = this.bsElements.nextSetBit(elemno + 1);
            }
            BS bs = vwr.getVisibleFramesBitSet();
            vwr.shm.getShape(22).setModelVisibilityFlags(bs);
            vwr.shm.getShape(31).setModelVisibilityFlags(bs);
        }
    }

    private static class Constraint {
        static final int TYPE_NONE = 0;
        static final int TYPE_VECTOR = 4;
        static final int TYPE_PLANE = 5;
        static final int TYPE_LOCKED = 6;
        static final int TYPE_GENERAL = 7;
        int type;
        private P3 pt;
        private P3 offset;
        private P4 plane;
        private V3 unitVector;

        Constraint(P3 pt, int type, Object[] params) throws IllegalArgumentException {
            this.pt = pt;
            this.type = type;
            switch (type) {
                case 0: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    this.offset = (P3)params[0];
                    this.unitVector = V3.newV((T3)params[1]);
                    this.unitVector.normalize();
                    break;
                }
                case 5: {
                    this.plane = (P4)params[0];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        void constrain(P3 ptOld, P3 ptNew, boolean allowProjection) {
            V3 v = new V3();
            P3 p = P3.newP(ptOld);
            float d = 0.0f;
            switch (this.type) {
                case 0: {
                    return;
                }
                case 7: {
                    return;
                }
                case 6: {
                    ptNew.x = Float.NaN;
                    return;
                }
                case 4: {
                    if (this.pt == null && (d = Measure.projectOntoAxis(p, this.offset, this.unitVector, v)) * d >= 1.96E-6f) {
                        ptNew.x = Float.NaN;
                        break;
                    }
                    d = Measure.projectOntoAxis(ptNew, this.offset, this.unitVector, v);
                    break;
                }
                case 5: {
                    if (this.pt == null && (double)Math.abs(Measure.getPlaneProjection(p, this.plane, v, v)) > 0.01) {
                        ptNew.x = Float.NaN;
                        break;
                    }
                    d = Measure.getPlaneProjection(ptNew, this.plane, v, v);
                    ptNew.setT(v);
                }
            }
            if (!allowProjection && (double)Math.abs(d) > 1.0E-10) {
                ptNew.x = Float.NaN;
            }
        }
    }

    private static class ClegNode {
        String name;
        private String setting;
        String myTrm;
        String myIta;
        boolean isITA;
        boolean isHM;
        String hallSymbol;
        String errString;
        private M4 trLink;
        private int index;
        protected String calcNext;
        protected String calculated;

        ClegNode(int index, String name, String setting) {
            int pt;
            if (name == null) {
                return;
            }
            this.index = index;
            this.setting = setting == null ? "a,b,c" : setting;
            this.isITA = name.startsWith("ITA/");
            if (this.isITA) {
                name = name.substring(4);
            }
            this.isHM = false;
            this.hallSymbol = null;
            if (name.charAt(0) == '[') {
                pt = name.indexOf(93);
                if (pt < 0) {
                    this.errString = "invalid Hall symbol: " + name + "!";
                    return;
                }
                this.hallSymbol = name.substring(1, pt);
                name = "Hall:" + this.hallSymbol;
            } else if (name.startsWith("HM:")) {
                this.isHM = true;
            } else if (name.length() <= 3) {
                this.isITA = true;
                int i = name.length();
                while (--i >= 0) {
                    if (PT.isDigit(name.charAt(i))) continue;
                    this.isITA = false;
                    break;
                }
                if (this.isITA) {
                    name = name + ".1";
                }
            }
            if (!this.isITA && this.hallSymbol == null && !this.isHM) {
                int n = pt = PT.isDigit(name.charAt(0)) ? name.indexOf(" ") : -1;
                if (pt > 0) {
                    name = name.substring(0, pt);
                }
                if (name.indexOf(46) > 0 && !Float.isNaN(PT.parseFloat(name))) {
                    this.isITA = true;
                    if (!name.endsWith(".1") && setting != null) {
                        this.errString = "Space group ITA/" + name + " n.m syntax cannot be used with a setting!";
                        return;
                    }
                }
            }
            this.name = name;
        }

        void addTransform(M4 trm) {
            if (this.trLink == null) {
                this.trLink = new M4();
                this.trLink.setIdentity();
            }
            this.trLink.mul(trm);
        }

        boolean update(Viewer vwr, ClegNode prevNode, M4 trm, M4 trTemp, SymmetryInterface sym) {
            boolean haveReferenceCell;
            if (this.errString != null) {
                return false;
            }
            if (this.name == null) {
                return true;
            }
            if (this.isITA) {
                String string = this.myTrm = this.name.endsWith(".1") ? "a,b,c" : (String)sym.getITASettingValue(vwr, this.name, "trm");
                if (this.myTrm == null) {
                    this.errString = "Unknown ITA setting: " + this.name + "!";
                    return false;
                }
                String[] tokens = PT.split(this.name, ".");
                this.myIta = tokens[0];
                this.name = "ITA/" + this.myIta + ":" + (this.myTrm == null || this.myTrm.equals("a,b,c") ? this.setting : this.myTrm);
            } else if (this.hallSymbol != null) {
                if (sym.getSpaceGroupInfoObj("nameToXYZList", "Hall:" + this.hallSymbol, false, false) == null) {
                    this.errString = "Invalid Hall notation: " + this.hallSymbol;
                    return false;
                }
                int pt = this.hallSymbol.indexOf("(");
                if (pt > 0) {
                    String[] vabc = PT.split(this.hallSymbol.substring(pt + 1, this.hallSymbol.length() - 1), " ");
                    this.hallSymbol = this.hallSymbol.substring(0, pt).trim();
                    P3 v = P3.new3(-PT.parseFloat(vabc[0]) / 12.0f, -PT.parseFloat(vabc[1]) / 12.0f, -PT.parseFloat(vabc[2]) / 12.0f);
                    this.setting = "a,b,c;" + sym.staticToRationalXYZ(v, ",");
                }
                this.name = "[" + this.hallSymbol + "]" + (this.setting.equals("a,b,c") ? "" : ":" + this.setting);
            } else {
                this.myTrm = (String)sym.getSpaceGroupInfoObj("itaTransform", this.name, false, false);
                this.myIta = (String)sym.getSpaceGroupInfoObj("itaNumber", this.name, false, false);
            }
            M4 trm0 = null;
            boolean haveCalc = false;
            boolean bl = haveReferenceCell = prevNode != null && this.trLink == null && (this.hallSymbol != null || this.myIta != null && (this.myIta.equals(prevNode.myIta) || prevNode.calcNext != null));
            if (haveReferenceCell) {
                trm0 = M4.newM4(trm);
                if (prevNode != null && prevNode.myTrm != null) {
                    ModelKit.addSGTransform(sym, "!" + prevNode.setting, trm, trTemp);
                    ModelKit.addSGTransform(sym, "!" + prevNode.myTrm, trm, trTemp);
                }
                String trCalc = null;
                if (prevNode.calcNext != null) {
                    boolean isSetting;
                    boolean isSub = true;
                    boolean isImplicit = false;
                    switch (prevNode.calcNext) {
                        case "super": {
                            isSub = false;
                            break;
                        }
                        case "sub": {
                            break;
                        }
                        case "": 
                        case "set": {
                            prevNode.calcNext = "set";
                            isImplicit = true;
                        }
                    }
                    int ita1 = PT.parseInt(prevNode.myIta);
                    int ita2 = PT.parseInt(this.myIta);
                    boolean bl2 = isSetting = isImplicit && ita1 == ita2;
                    if (!isSetting) {
                        trCalc = (String)sym.getSubgroupJSON(vwr, isSub ? ita1 : ita2, isSub ? ita2 : ita1, 0, 1);
                        boolean bl3 = haveCalc = trCalc != null;
                        if (haveCalc && !isSub) {
                            trCalc = "!" + trCalc;
                        }
                        String calc = prevNode.myIta + ">" + trCalc + ">" + this.myIta;
                        if (!haveCalc) {
                            throw new RuntimeException(calc);
                        }
                        System.out.println("sub := " + calc);
                        ModelKit.addSGTransform(sym, trCalc, trm, trTemp);
                    }
                }
                ModelKit.addSGTransform(sym, this.myTrm, trm, trTemp);
                ModelKit.addSGTransform(sym, this.setting, trm, trTemp);
                System.out.println("ClegNode " + this + "\n" + trm);
                if (haveCalc) {
                    trm0.invert();
                    M4 trm1 = M4.newM4(trm);
                    trm1.mul(trm0);
                    this.calculated = (String)sym.convertTransform(null, trm1);
                }
            }
            return true;
        }

        public String toString() {
            return "[ClegNode #" + this.index + " " + this.name + "   " + this.myIta + ":" + this.setting + " " + this.myTrm + "]";
        }

        protected static boolean checkSyntax(String[] tokens, SymmetryInterface sym) {
            block8: for (int i = 0; i < tokens.length; ++i) {
                String transform;
                String s = tokens[i].trim();
                if (s.length() == 0) continue;
                int pt = s.indexOf(":");
                if (pt > 0) {
                    transform = s.substring(pt + 1);
                    s = s.substring(0, pt);
                } else if (s.indexOf(",") >= 0) {
                    transform = s;
                    s = null;
                } else {
                    transform = "";
                }
                if (s != null) {
                    float itno = PT.parseFloatStrict(s);
                    if (itno < 1.0f || itno >= 231.0f) {
                        return false;
                    }
                    if (Float.isNaN(itno)) {
                        transform = s;
                    }
                }
                switch (transform) {
                    case "": 
                    case "sub": 
                    case "r": {
                        continue block8;
                    }
                    default: {
                        if (transform.indexOf(",") < 0 || ((M4)sym.convertTransform(transform, null)).determinant3() != 0.0f) continue block8;
                        return false;
                    }
                }
            }
            return true;
        }

        public void updateTokens(String[] tokens, int i) {
            if (this.myIta != null && this.myTrm != null) {
                tokens[i] = this.myIta + (this.myTrm.equals("a,b,c") ? "" : ":" + this.myTrm);
            }
            if (this.calculated != null) {
                tokens[i - 1] = this.calculated;
            }
        }
    }
}

