
#ifndef KCONTACTS_EXPORT_H
#define KCONTACTS_EXPORT_H

#ifdef KCONTACTS_STATIC_DEFINE
#  define KCONTACTS_EXPORT
#  define KCONTACTS_NO_EXPORT
#else
#  ifndef KCONTACTS_EXPORT
#    ifdef KF5Contacts_EXPORTS
        /* We are building this library */
#      define KCONTACTS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCONTACTS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCONTACTS_NO_EXPORT
#    define KCONTACTS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCONTACTS_DECL_DEPRECATED
#  define KCONTACTS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCONTACTS_DECL_DEPRECATED_EXPORT
#  define KCONTACTS_DECL_DEPRECATED_EXPORT KCONTACTS_EXPORT KCONTACTS_DECL_DEPRECATED
#endif

#ifndef KCONTACTS_DECL_DEPRECATED_NO_EXPORT
#  define KCONTACTS_DECL_DEPRECATED_NO_EXPORT KCONTACTS_NO_EXPORT KCONTACTS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCONTACTS_NO_DEPRECATED
#    define KCONTACTS_NO_DEPRECATED
#  endif
#endif

#define KCONTACTS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCONTACTS_NO_DEPRECATED) && !defined(KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCONTACTS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCONTACTS_NO_DEPRECATED_WARNINGS) && !defined(KCONTACTS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCONTACTS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCONTACTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCONTACTS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCONTACTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCONTACTS_NO_DEPRECATED)
#  undef KCONTACTS_DEPRECATED
#  define KCONTACTS_DEPRECATED_EXPORT KCONTACTS_EXPORT
#  define KCONTACTS_DEPRECATED_NO_EXPORT KCONTACTS_NO_EXPORT
#elif defined(KCONTACTS_NO_DEPRECATED_WARNINGS)
#  define KCONTACTS_DEPRECATED
#  define KCONTACTS_DEPRECATED_EXPORT KCONTACTS_EXPORT
#  define KCONTACTS_DEPRECATED_NO_EXPORT KCONTACTS_NO_EXPORT
#else
#  define KCONTACTS_DEPRECATED KCONTACTS_DECL_DEPRECATED
#  define KCONTACTS_DEPRECATED_EXPORT KCONTACTS_DECL_DEPRECATED_EXPORT
#  define KCONTACTS_DEPRECATED_NO_EXPORT KCONTACTS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCONTACTS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCONTACTS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCONTACTS_NO_DEPRECATED
#  define KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57300
#endif
#ifdef KCONTACTS_NO_DEPRECATED_WARNINGS
#  define KCONTACTS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCONTACTS_DEPRECATED_WARNINGS_SINCE
#  ifdef KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCONTACTS_DEPRECATED_WARNINGS_SINCE KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCONTACTS_DEPRECATED_WARNINGS_SINCE 0x57300
#  endif
#endif

#ifndef KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCONTACTS_DEPRECATED
#  define KCONTACTS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCONTACTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCONTACTS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KCONTACTS_DEPRECATED_WARNINGS_SINCE >= 0x55800
#  define KCONTACTS_DEPRECATED_VERSION_5_88(text) KCONTACTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCONTACTS_DEPRECATED_VERSION_5_88(text)
#endif

#if KCONTACTS_DEPRECATED_WARNINGS_SINCE >= 0x55900
#  define KCONTACTS_DEPRECATED_VERSION_5_89(text) KCONTACTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCONTACTS_DEPRECATED_VERSION_5_89(text)
#endif

#if KCONTACTS_DEPRECATED_WARNINGS_SINCE >= 0x55c00
#  define KCONTACTS_DEPRECATED_VERSION_5_92(text) KCONTACTS_DECL_DEPRECATED_TEXT(text)
#else
#  define KCONTACTS_DEPRECATED_VERSION_5_92(text)
#endif
#define KCONTACTS_DEPRECATED_VERSION_5(minor, text)      KCONTACTS_DEPRECATED_VERSION_5_##minor(text)
#define KCONTACTS_DEPRECATED_VERSION(major, minor, text) KCONTACTS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KCONTACTS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCONTACTS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KCONTACTS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KCONTACTS_DEPRECATED_VERSION(major, minor, text)
#  define KCONTACTS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KCONTACTS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KCONTACTS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KCONTACTS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KCONTACTS_EXPORT_H */
