/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.statestore.StateModel;
import org.opensearch.sql.spark.flint.FlintIndexState;

public class FlintIndexStateModel
extends StateModel {
    public static final String FLINT_INDEX_DOC_TYPE = "flintindexstate";
    public static final String LATEST_ID = "latestId";
    public static final String DOC_ID_PREFIX = "flint";
    private final FlintIndexState indexState;
    private final String applicationId;
    private final String jobId;
    private final String latestId;
    private final String datasourceName;
    private final long lastUpdateTime;
    private final String error;
    private final long seqNo;
    private final long primaryTerm;

    public FlintIndexStateModel(FlintIndexState indexState, String applicationId, String jobId, String latestId, String datasourceName, long lastUpdateTime, String error, long seqNo, long primaryTerm) {
        this.indexState = indexState;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.latestId = latestId;
        this.datasourceName = datasourceName;
        this.lastUpdateTime = lastUpdateTime;
        this.error = error;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public static FlintIndexStateModel copy(FlintIndexStateModel copy, long seqNo, long primaryTerm) {
        return new FlintIndexStateModel(copy.indexState, copy.applicationId, copy.jobId, copy.latestId, copy.datasourceName, copy.lastUpdateTime, copy.error, seqNo, primaryTerm);
    }

    public static FlintIndexStateModel copyWithState(FlintIndexStateModel copy, FlintIndexState state, long seqNo, long primaryTerm) {
        return new FlintIndexStateModel(state, copy.applicationId, copy.jobId, copy.latestId, copy.datasourceName, copy.lastUpdateTime, copy.error, seqNo, primaryTerm);
    }

    public static FlintIndexStateModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        FlintIndexStateModelBuilder builder = FlintIndexStateModel.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "state": {
                    builder.indexState(FlintIndexState.fromString(parser.text()));
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    break;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    break;
                }
                case "latestId": {
                    builder.latestId(parser.text());
                    break;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    break;
                }
                case "lastUpdateTime": {
                    builder.lastUpdateTime(parser.longValue());
                    break;
                }
                case "error": {
                    builder.error(parser.text());
                }
            }
        }
        builder.seqNo(seqNo);
        builder.primaryTerm(primaryTerm);
        return builder.build();
    }

    @Override
    public String getId() {
        return this.latestId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("version", "1.0").field("type", FLINT_INDEX_DOC_TYPE).field("state", this.indexState.getState()).field("applicationId", this.applicationId).field("jobId", this.jobId).field(LATEST_ID, this.latestId).field("dataSourceName", this.datasourceName).field("lastUpdateTime", this.lastUpdateTime).field("error", this.error).endObject();
        return builder;
    }

    @Generated
    public static FlintIndexStateModelBuilder builder() {
        return new FlintIndexStateModelBuilder();
    }

    @Generated
    public FlintIndexState getIndexState() {
        return this.indexState;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getLatestId() {
        return this.latestId;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Override
    @Generated
    public long getSeqNo() {
        return this.seqNo;
    }

    @Override
    @Generated
    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlintIndexStateModel)) {
            return false;
        }
        FlintIndexStateModel other = (FlintIndexStateModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        FlintIndexState this$indexState = this.getIndexState();
        FlintIndexState other$indexState = other.getIndexState();
        if (this$indexState == null ? other$indexState != null : !((Object)((Object)this$indexState)).equals((Object)other$indexState)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$latestId = this.getLatestId();
        String other$latestId = other.getLatestId();
        if (this$latestId == null ? other$latestId != null : !this$latestId.equals(other$latestId)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlintIndexStateModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        FlintIndexState $indexState = this.getIndexState();
        result = result * 59 + ($indexState == null ? 43 : ((Object)((Object)$indexState)).hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $latestId = this.getLatestId();
        result = result * 59 + ($latestId == null ? 43 : $latestId.hashCode());
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public static class FlintIndexStateModelBuilder {
        @Generated
        private FlintIndexState indexState;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private String latestId;
        @Generated
        private String datasourceName;
        @Generated
        private long lastUpdateTime;
        @Generated
        private String error;
        @Generated
        private long seqNo;
        @Generated
        private long primaryTerm;

        @Generated
        FlintIndexStateModelBuilder() {
        }

        @Generated
        public FlintIndexStateModelBuilder indexState(FlintIndexState indexState) {
            this.indexState = indexState;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder latestId(String latestId) {
            this.latestId = latestId;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder lastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        @Generated
        public FlintIndexStateModelBuilder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        @Generated
        public FlintIndexStateModel build() {
            return new FlintIndexStateModel(this.indexState, this.applicationId, this.jobId, this.latestId, this.datasourceName, this.lastUpdateTime, this.error, this.seqNo, this.primaryTerm);
        }

        @Generated
        public String toString() {
            return "FlintIndexStateModel.FlintIndexStateModelBuilder(indexState=" + this.indexState + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", latestId=" + this.latestId + ", datasourceName=" + this.datasourceName + ", lastUpdateTime=" + this.lastUpdateTime + ", error=" + this.error + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ")";
        }
    }
}

