# This file is a system-wide default configuration file for mk-configure.
#
# Example is below:
#
# CC           ?= /usr/bin/cc
# CXX          ?= /usr/bin/CC
# YACC         ?= /usr/sfw/bin/bison -y
# LEX          ?= /usr/sfw/bin/flex
# INSTALL      ?= /usr/ucb/install
# STRIP        ?= /usr/ccs/bin/strip
# LD           ?= /usr/ccs/bin/ld
# AR           ?= /usr/ccs/bin/ar
# AS           ?= /usr/ccs/bin/as
# LORDER       ?= /usr/ccs/bin/lorder
# RANLIB       ?= /usr/ccs/bin/ranlib
# LUA_LMODDIR  ?= /usr/share/lua/5.1
# LUA_CMODDIR  ?= /usr/lib/lua/5.1
# ...

#.SHELL: name=sh path=/bin/sh

MKC_VERSION   ?=	0.38.3

BUILTINSDIR   ?=	/usr/share/mk-configure/builtins

.ifdef MK_C_PROJECT
# for mk-configure testing only
CHECK_COMMON_SH_DIR  =	${MK_C_PROJECT}/scripts
EXPORT_VARNAMES     +=	CHECK_COMMON_SH_DIR
_BUILTINSDIR         =	${MK_C_PROJECT}/builtins
.endif
FEATURESDIR    ?=	/usr/share/mk-configure/features
MKFILESDIR      =	/usr/share/mk-configure/mk
MKC_LIBEXECDIR ?=	/usr/lib/mk-configure
MKC_SYSCONFDIR ?=	/etc

MKDEP         ?=	/usr/bin/bmkdep
MKDEP_TYPE    ?=	nbmkdep
MAKEDEPEND    ?=	makedepend

NM        ?=	/usr/bin/nm
ID        ?=	/usr/bin/id
LORDER    ?=	lorder

MKDIR     ?=	mkdir

INSTALL       ?=	/usr/bin/install
INSTALL_FLAGS ?=	-c

SHELL     ?=	sh

SIZE      ?=	size

TSORT     ?= 	tsort -q

TAR       ?=	tar
GZIP      ?=	gzip
BZIP2     ?=	bzip2
ZIP       ?=	zip

OBJCOPY   ?=    objcopy

OBJDUMP   ?=    objdump

STRIP     ?=	strip
STRIPFLAG ?=	-s

RM        ?=	rm

YACC      ?=	yacc
YFLAGS    ?=

LEX       ?=	lex
LFLAGS    ?=
LPREFIX ?=	yy
LEXLIB ?=	-ll

AR         ?=	ar
ARFLAGS    ?=	rl
RANLIB     ?=	ranlib

AS        ?=	as
AFLAGS    ?=

CC        ?=	cc
CFLAGS    ?=

CXX        ?=	c++

CPP        ?=	cpp
CPPFLAGS   ?=	

CLEANFILES_CMD ?=	${RM} -f
CLEANDIRS_CMD ?=	${RM} -rf

UNINSTALL  ?=	${RM} -f
