/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import com.amazonaws.services.emrserverless.model.JobRunState;
import org.json.JSONObject;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.execution.statement.StatementState;

public abstract class AsyncQueryHandler {
    public JSONObject getQueryResponse(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        JSONObject result = this.getResponseFromResultIndex(asyncQueryJobMetadata);
        if (result.has("data")) {
            JSONObject items = result.getJSONObject("data");
            String status = items.optString("status", JobRunState.FAILED.toString());
            result.put("status", (Object)status);
            String error = items.optString("error", "");
            result.put("error", (Object)error);
            return result;
        }
        JSONObject statement = this.getResponseFromExecutor(asyncQueryJobMetadata);
        if (this.isSuccessState(statement)) {
            statement.put("status", (Object)StatementState.RUNNING.getState());
        }
        return statement;
    }

    private boolean isSuccessState(JSONObject statement) {
        return StatementState.SUCCESS.getState().equalsIgnoreCase(statement.optString("status"));
    }

    protected abstract JSONObject getResponseFromResultIndex(AsyncQueryJobMetadata var1);

    protected abstract JSONObject getResponseFromExecutor(AsyncQueryJobMetadata var1);

    public abstract String cancelJob(AsyncQueryJobMetadata var1);

    public abstract DispatchQueryResponse submit(DispatchQueryRequest var1, DispatchQueryContext var2);
}

