/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.opensearch.nio.FlushOperation;
import org.opensearch.nio.FlushReadyWrite;
import org.opensearch.nio.NioChannelHandler;
import org.opensearch.nio.SocketChannelContext;
import org.opensearch.nio.WriteOperation;

public abstract class BytesWriteHandler
implements NioChannelHandler {
    private static final List<FlushOperation> EMPTY_LIST = Collections.emptyList();

    @Override
    public WriteOperation createWriteOperation(SocketChannelContext context, Object message, BiConsumer<Void, Exception> listener) {
        assert (message instanceof ByteBuffer[]) : "This channel only supports messages that are of type: " + ByteBuffer[].class + ". Found type: " + message.getClass() + ".";
        return new FlushReadyWrite(context, (ByteBuffer[])message, listener);
    }

    @Override
    public void channelActive() {
    }

    @Override
    public List<FlushOperation> writeToBytes(WriteOperation writeOperation) {
        assert (writeOperation instanceof FlushReadyWrite) : "Write operation must be flush ready";
        return Collections.singletonList((FlushReadyWrite)writeOperation);
    }

    @Override
    public List<FlushOperation> pollFlushOperations() {
        return EMPTY_LIST;
    }

    @Override
    public boolean closeNow() {
        return false;
    }

    @Override
    public void close() {
    }
}

