/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.knn.common.KNNVectorUtil;

public enum SpaceType {
    L2("l2"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public VectorSimilarityFunction getVectorSimilarityFunction() {
            return VectorSimilarityFunction.EUCLIDEAN;
        }
    }
    ,
    COSINESIMIL("cosinesimil"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }

        @Override
        public VectorSimilarityFunction getVectorSimilarityFunction() {
            return VectorSimilarityFunction.COSINE;
        }

        @Override
        public void validateVector(byte[] vector) {
            if (KNNVectorUtil.isZeroVector(vector)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "zero vector is not supported when space type is [%s]", this.getValue()));
            }
        }

        @Override
        public void validateVector(float[] vector) {
            if (KNNVectorUtil.isZeroVector(vector)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "zero vector is not supported when space type is [%s]", this.getValue()));
            }
        }
    }
    ,
    L1("l1"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    LINF("linf"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    }
    ,
    INNER_PRODUCT("innerproduct"){

        @Override
        public float scoreTranslation(float rawScore) {
            if (rawScore >= 0.0f) {
                return 1.0f / (1.0f + rawScore);
            }
            return -rawScore + 1.0f;
        }

        @Override
        public VectorSimilarityFunction getVectorSimilarityFunction() {
            return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
        }
    }
    ,
    HAMMING_BIT("hammingbit"){

        @Override
        public float scoreTranslation(float rawScore) {
            return 1.0f / (1.0f + rawScore);
        }
    };

    public static SpaceType DEFAULT;
    private final String value;

    private SpaceType(String value) {
        this.value = value;
    }

    public abstract float scoreTranslation(float var1);

    public VectorSimilarityFunction getVectorSimilarityFunction() {
        throw new UnsupportedOperationException(String.format("Space [%s] does not have a vector similarity function", this.getValue()));
    }

    public void validateVector(byte[] vector) {
    }

    public void validateVector(float[] vector) {
    }

    public String getValue() {
        return this.value;
    }

    public static Set<String> getValues() {
        HashSet<String> values = new HashSet<String>();
        for (SpaceType spaceType : SpaceType.values()) {
            values.add(spaceType.getValue());
        }
        return values;
    }

    public static SpaceType getSpace(String spaceTypeName) {
        for (SpaceType currentSpaceType : SpaceType.values()) {
            if (!currentSpaceType.getValue().equalsIgnoreCase(spaceTypeName)) continue;
            return currentSpaceType;
        }
        throw new IllegalArgumentException("Unable to find space: " + spaceTypeName);
    }

    static {
        DEFAULT = L2;
    }
}

