// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32s2-ulp.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32s2ulp

// 32-bit RISC-V MCU
//
//	Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-S2-ULP"
	CPU          = "RV32IMC"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// SENS Peripheral
	IRQ_TOUCH_DONE_INT = 0

	// SENS Peripheral
	IRQ_TOUCH_INACTIVE_INT = 1

	// SENS Peripheral
	IRQ_TOUCH_ACTIVE_INT = 2

	// SENS Peripheral
	IRQ_SARADC1_DONE_INT = 3

	// SENS Peripheral
	IRQ_SARADC2_DONE_INT = 4

	// SENS Peripheral
	IRQ_TSENS_DONE_INT = 5

	// Real-Time Clock Control
	IRQ_RISCV_START_INT = 6

	// Real-Time Clock Control
	IRQ_SW_INT = 7

	// Real-Time Clock Control
	IRQ_SWD_INT = 8

	// Highest interrupt number on this device.
	IRQ_max = 8
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_TOUCH_DONE_INT:
		callHandlers(IRQ_TOUCH_DONE_INT)
	case IRQ_TOUCH_INACTIVE_INT:
		callHandlers(IRQ_TOUCH_INACTIVE_INT)
	case IRQ_TOUCH_ACTIVE_INT:
		callHandlers(IRQ_TOUCH_ACTIVE_INT)
	case IRQ_SARADC1_DONE_INT:
		callHandlers(IRQ_SARADC1_DONE_INT)
	case IRQ_SARADC2_DONE_INT:
		callHandlers(IRQ_SARADC2_DONE_INT)
	case IRQ_TSENS_DONE_INT:
		callHandlers(IRQ_TSENS_DONE_INT)
	case IRQ_RISCV_START_INT:
		callHandlers(IRQ_RISCV_START_INT)
	case IRQ_SW_INT:
		callHandlers(IRQ_SW_INT)
	case IRQ_SWD_INT:
		callHandlers(IRQ_SWD_INT)
	}
}

// Peripherals.
var (
	// Low-power Input/Output
	RTC_IO = (*RTCIO_Type)(unsafe.Pointer(uintptr(0xa400)))

	// Real-Time Clock Control
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x8000)))

	// Low-power I2C (Inter-Integrated Circuit) Controller
	RTC_I2C = (*RTC_I2C_Type)(unsafe.Pointer(uintptr(0xec00)))

	// SENS Peripheral
	SENS = (*SENS_Type)(unsafe.Pointer(uintptr(0xc800)))
)

// Low-power Input/Output
type RTCIO_Type struct {
	RTC_GPIO_OUT         volatile.Register32 // 0x0
	RTC_GPIO_OUT_W1TS    volatile.Register32 // 0x4
	RTC_GPIO_OUT_W1TC    volatile.Register32 // 0x8
	RTC_GPIO_ENABLE      volatile.Register32 // 0xC
	RTC_GPIO_ENABLE_W1TS volatile.Register32 // 0x10
	RTC_GPIO_ENABLE_W1TC volatile.Register32 // 0x14
	RTC_GPIO_STATUS      volatile.Register32 // 0x18
	RTC_GPIO_STATUS_W1TS volatile.Register32 // 0x1C
	RTC_GPIO_STATUS_W1TC volatile.Register32 // 0x20
	RTC_GPIO_IN          volatile.Register32 // 0x24
	RTC_GPIO_PIN0        volatile.Register32 // 0x28
	RTC_GPIO_PIN1        volatile.Register32 // 0x2C
	RTC_GPIO_PIN2        volatile.Register32 // 0x30
	RTC_GPIO_PIN3        volatile.Register32 // 0x34
	RTC_GPIO_PIN4        volatile.Register32 // 0x38
	RTC_GPIO_PIN5        volatile.Register32 // 0x3C
	RTC_GPIO_PIN6        volatile.Register32 // 0x40
	RTC_GPIO_PIN7        volatile.Register32 // 0x44
	RTC_GPIO_PIN8        volatile.Register32 // 0x48
	RTC_GPIO_PIN9        volatile.Register32 // 0x4C
	RTC_GPIO_PIN10       volatile.Register32 // 0x50
	RTC_GPIO_PIN11       volatile.Register32 // 0x54
	RTC_GPIO_PIN12       volatile.Register32 // 0x58
	RTC_GPIO_PIN13       volatile.Register32 // 0x5C
	RTC_GPIO_PIN14       volatile.Register32 // 0x60
	RTC_GPIO_PIN15       volatile.Register32 // 0x64
	RTC_GPIO_PIN16       volatile.Register32 // 0x68
	RTC_GPIO_PIN17       volatile.Register32 // 0x6C
	RTC_GPIO_PIN18       volatile.Register32 // 0x70
	RTC_GPIO_PIN19       volatile.Register32 // 0x74
	RTC_GPIO_PIN20       volatile.Register32 // 0x78
	RTC_GPIO_PIN21       volatile.Register32 // 0x7C
	RTC_DEBUG_SEL        volatile.Register32 // 0x80
	TOUCH_PAD0           volatile.Register32 // 0x84
	TOUCH_PAD1           volatile.Register32 // 0x88
	TOUCH_PAD2           volatile.Register32 // 0x8C
	TOUCH_PAD3           volatile.Register32 // 0x90
	TOUCH_PAD4           volatile.Register32 // 0x94
	TOUCH_PAD5           volatile.Register32 // 0x98
	TOUCH_PAD6           volatile.Register32 // 0x9C
	TOUCH_PAD7           volatile.Register32 // 0xA0
	TOUCH_PAD8           volatile.Register32 // 0xA4
	TOUCH_PAD9           volatile.Register32 // 0xA8
	TOUCH_PAD10          volatile.Register32 // 0xAC
	TOUCH_PAD11          volatile.Register32 // 0xB0
	TOUCH_PAD12          volatile.Register32 // 0xB4
	TOUCH_PAD13          volatile.Register32 // 0xB8
	TOUCH_PAD14          volatile.Register32 // 0xBC
	XTAL_32P_PAD         volatile.Register32 // 0xC0
	XTAL_32N_PAD         volatile.Register32 // 0xC4
	PAD_DAC1             volatile.Register32 // 0xC8
	PAD_DAC2             volatile.Register32 // 0xCC
	RTC_PAD19            volatile.Register32 // 0xD0
	RTC_PAD20            volatile.Register32 // 0xD4
	RTC_PAD21            volatile.Register32 // 0xD8
	EXT_WAKEUP0          volatile.Register32 // 0xDC
	XTL_EXT_CTR          volatile.Register32 // 0xE0
	SAR_I2C_IO           volatile.Register32 // 0xE4
	RTC_IO_TOUCH_CTRL    volatile.Register32 // 0xE8
	_                    [272]byte
	RTC_IO_DATE          volatile.Register32 // 0x1FC
}

// RTCIO.RTC_GPIO_OUT: RTC GPIO output register
func (o *RTCIO_Type) SetRTC_GPIO_OUT_GPIO_OUT_DATA(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_OUT.Reg, volatile.LoadUint32(&o.RTC_GPIO_OUT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_OUT_GPIO_OUT_DATA() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_OUT.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_OUT_W1TS: RTC GPIO output bit set register
func (o *RTCIO_Type) SetRTC_GPIO_OUT_W1TS_GPIO_OUT_DATA_W1TS(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_OUT_W1TS.Reg, volatile.LoadUint32(&o.RTC_GPIO_OUT_W1TS.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_OUT_W1TS_GPIO_OUT_DATA_W1TS() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_OUT_W1TS.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_OUT_W1TC: RTC GPIO output bit clear register
func (o *RTCIO_Type) SetRTC_GPIO_OUT_W1TC_GPIO_OUT_DATA_W1TC(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_OUT_W1TC.Reg, volatile.LoadUint32(&o.RTC_GPIO_OUT_W1TC.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_OUT_W1TC_GPIO_OUT_DATA_W1TC() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_OUT_W1TC.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_ENABLE: RTC GPIO output enable register
func (o *RTCIO_Type) SetRTC_GPIO_ENABLE_REG_RTCIO_REG_GPIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_ENABLE.Reg, volatile.LoadUint32(&o.RTC_GPIO_ENABLE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_ENABLE_REG_RTCIO_REG_GPIO_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_ENABLE.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_ENABLE_W1TS: RTC GPIO output enable bit set register
func (o *RTCIO_Type) SetRTC_GPIO_ENABLE_W1TS_REG_RTCIO_REG_GPIO_ENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_ENABLE_W1TS.Reg, volatile.LoadUint32(&o.RTC_GPIO_ENABLE_W1TS.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_ENABLE_W1TS_REG_RTCIO_REG_GPIO_ENABLE_W1TS() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_ENABLE_W1TS.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_ENABLE_W1TC: RTC GPIO output enable bit clear register
func (o *RTCIO_Type) SetRTC_GPIO_ENABLE_W1TC_REG_RTCIO_REG_GPIO_ENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_ENABLE_W1TC.Reg, volatile.LoadUint32(&o.RTC_GPIO_ENABLE_W1TC.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_ENABLE_W1TC_REG_RTCIO_REG_GPIO_ENABLE_W1TC() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_ENABLE_W1TC.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_STATUS: RTC GPIO interrupt status register
func (o *RTCIO_Type) SetRTC_GPIO_STATUS_GPIO_STATUS_INT(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_STATUS.Reg, volatile.LoadUint32(&o.RTC_GPIO_STATUS.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_STATUS_GPIO_STATUS_INT() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_STATUS.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_STATUS_W1TS: RTC GPIO interrupt status bit set register
func (o *RTCIO_Type) SetRTC_GPIO_STATUS_W1TS_GPIO_STATUS_INT_W1TS(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_STATUS_W1TS.Reg, volatile.LoadUint32(&o.RTC_GPIO_STATUS_W1TS.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_STATUS_W1TS_GPIO_STATUS_INT_W1TS() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_STATUS_W1TS.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_STATUS_W1TC: RTC GPIO interrupt status bit clear register
func (o *RTCIO_Type) SetRTC_GPIO_STATUS_W1TC_GPIO_STATUS_INT_W1TC(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_STATUS_W1TC.Reg, volatile.LoadUint32(&o.RTC_GPIO_STATUS_W1TC.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_STATUS_W1TC_GPIO_STATUS_INT_W1TC() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_STATUS_W1TC.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_IN: RTC GPIO input register
func (o *RTCIO_Type) SetRTC_GPIO_IN_GPIO_IN_NEXT(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_IN.Reg, volatile.LoadUint32(&o.RTC_GPIO_IN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_IN_GPIO_IN_NEXT() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_IN.Reg) & 0xfffffc00) >> 10
}

// RTCIO.RTC_GPIO_PIN0: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN0_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN0.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN0_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN0_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN0.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN0_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN0_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN0.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN0_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN0.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN1: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN1_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN1.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN1_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN1_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN1.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN1_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN1_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN1.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN1_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN1.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN2: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN2_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN2.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN2_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN2_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN2.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN2_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN2_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN2.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN2_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN2.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN3: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN3_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN3.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN3_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN3_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN3.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN3_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN3_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN3.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN3_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN3.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN4: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN4_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN4.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN4_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN4_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN4.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN4_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN4_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN4.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN4_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN4.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN5: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN5_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN5.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN5_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN5_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN5.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN5_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN5_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN5.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN5_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN5.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN6: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN6_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN6.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN6_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN6_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN6.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN6_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN6_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN6.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN6_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN6.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN7: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN7_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN7.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN7_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN7_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN7.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN7_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN7_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN7.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN7_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN7.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN8: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN8_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN8.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN8_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN8_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN8.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN8_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN8_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN8.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN8_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN8.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN9: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN9_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN9.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN9_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN9_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN9.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN9_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN9_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN9.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN9_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN9.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN10: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN10_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN10.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN10_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN10_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN10.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN10_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN10_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN10.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN10_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN10.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN11: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN11_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN11.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN11_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN11_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN11.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN11_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN11_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN11.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN11_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN11.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN12: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN12_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN12.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN12_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN12_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN12.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN12_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN12_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN12.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN12_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN12.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN13: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN13_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN13.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN13_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN13_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN13.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN13_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN13_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN13.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN13_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN13.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN14: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN14_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN14.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN14_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN14_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN14.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN14_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN14_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN14.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN14_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN14.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN15: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN15_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN15.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN15_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN15_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN15.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN15_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN15_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN15.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN15_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN15.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN16: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN16_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN16.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN16_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN16_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN16.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN16_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN16_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN16.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN16_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN16.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN17: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN17_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN17.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN17_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN17_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN17.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN17_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN17_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN17.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN17_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN17.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN18: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN18_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN18.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN18_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN18_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN18.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN18_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN18_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN18.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN18_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN18.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN19: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN19_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN19.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN19_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN19_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN19.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN19_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN19_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN19.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN19_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN19.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN20: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN20_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN20.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN20_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN20_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN20.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN20_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN20_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN20.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN20_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN20.Reg) & 0x400) >> 10
}

// RTCIO.RTC_GPIO_PIN21: RTC configuration for pin %s
func (o *RTCIO_Type) SetRTC_GPIO_PIN21_GPIO_PIN_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN21.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg)&^(0x4)|value<<2)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN21_GPIO_PIN_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg) & 0x4) >> 2
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN21_GPIO_PIN_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN21.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg)&^(0x380)|value<<7)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN21_GPIO_PIN_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg) & 0x380) >> 7
}
func (o *RTCIO_Type) SetRTC_GPIO_PIN21_GPIO_PIN_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RTC_GPIO_PIN21.Reg, volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg)&^(0x400)|value<<10)
}
func (o *RTCIO_Type) GetRTC_GPIO_PIN21_GPIO_PIN_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RTC_GPIO_PIN21.Reg) & 0x400) >> 10
}

// RTCIO.RTC_DEBUG_SEL: RTC debug select register
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_SEL0(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0x1f)|value)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_SEL0() uint32 {
	return volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0x1f
}
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_SEL1(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0x3e0)|value<<5)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_SEL1() uint32 {
	return (volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0x3e0) >> 5
}
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_SEL2(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0x7c00)|value<<10)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_SEL2() uint32 {
	return (volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0x7c00) >> 10
}
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_SEL3(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0xf8000)|value<<15)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_SEL3() uint32 {
	return (volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0xf8000) >> 15
}
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_SEL4(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0x1f00000)|value<<20)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_SEL4() uint32 {
	return (volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0x1f00000) >> 20
}
func (o *RTCIO_Type) SetRTC_DEBUG_SEL_RTC_DEBUG_12M_NO_GATING(value uint32) {
	volatile.StoreUint32(&o.RTC_DEBUG_SEL.Reg, volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTCIO_Type) GetRTC_DEBUG_SEL_RTC_DEBUG_12M_NO_GATING() uint32 {
	return (volatile.LoadUint32(&o.RTC_DEBUG_SEL.Reg) & 0x2000000) >> 25
}

// RTCIO.TOUCH_PAD0: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD0_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD0_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD0_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD0_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD0_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD0_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD0_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD0_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD0_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD0_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD0_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD0.Reg, volatile.LoadUint32(&o.TOUCH_PAD0.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD0_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD0.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD1: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD1_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD1_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD1_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD1_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD1_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD1_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD1_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD1_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD1_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD1_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD1_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD1.Reg, volatile.LoadUint32(&o.TOUCH_PAD1.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD1_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD1.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD2: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD2_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD2_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD2_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD2_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD2_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD2_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD2_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD2_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD2_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD2_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD2_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD2.Reg, volatile.LoadUint32(&o.TOUCH_PAD2.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD2_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD2.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD3: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD3_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD3_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD3_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD3_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD3_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD3_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD3_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD3_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD3_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD3_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD3_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD3.Reg, volatile.LoadUint32(&o.TOUCH_PAD3.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD3_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD3.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD4: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD4_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD4_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD4_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD4_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD4_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD4_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD4_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD4_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD4_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD4_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD4_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD4.Reg, volatile.LoadUint32(&o.TOUCH_PAD4.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD4_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD4.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD5: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD5_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD5_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD5_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD5_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD5_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD5_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD5_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD5_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD5_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD5_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD5_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD5.Reg, volatile.LoadUint32(&o.TOUCH_PAD5.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD5_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD5.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD6: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD6_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD6_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD6_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD6_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD6_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD6_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD6_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD6_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD6_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD6_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD6_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD6.Reg, volatile.LoadUint32(&o.TOUCH_PAD6.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD6_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD6.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD7: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD7_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD7_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD7_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD7_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD7_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD7_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD7_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD7_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD7_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD7_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD7_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD7.Reg, volatile.LoadUint32(&o.TOUCH_PAD7.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD7_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD7.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD8: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD8_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD8_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD8_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD8_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD8_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD8_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD8_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD8_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD8_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD8_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD8_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD8_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD8_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD8.Reg, volatile.LoadUint32(&o.TOUCH_PAD8.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD8_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD8.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD9: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD9_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD9_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD9_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD9_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD9_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD9_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD9_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD9_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD9_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD9_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD9_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD9_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD9_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD9.Reg, volatile.LoadUint32(&o.TOUCH_PAD9.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD9_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD9.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD10: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD10_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD10_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD10_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD10_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD10_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD10_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD10_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD10_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD10_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD10_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD10_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD10_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD10_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD10.Reg, volatile.LoadUint32(&o.TOUCH_PAD10.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD10_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD10.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD11: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD11_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD11_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD11_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD11_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD11_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD11_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD11_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD11_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD11_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD11_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD11_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD11_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD11_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD11.Reg, volatile.LoadUint32(&o.TOUCH_PAD11.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD11_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD11.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD12: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD12_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD12_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD12_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD12_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD12_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD12_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD12_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD12_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD12_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD12_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD12_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD12_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD12_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD12.Reg, volatile.LoadUint32(&o.TOUCH_PAD12.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD12_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD12.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD13: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD13_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD13_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD13_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD13_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD13_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD13_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD13_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD13_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD13_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD13_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD13_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD13_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD13_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD13.Reg, volatile.LoadUint32(&o.TOUCH_PAD13.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD13_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD13.Reg) & 0x60000000) >> 29
}

// RTCIO.TOUCH_PAD14: Touch pad %s configuration register
func (o *RTCIO_Type) SetTOUCH_PAD14_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetTOUCH_PAD14_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetTOUCH_PAD14_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetTOUCH_PAD14_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetTOUCH_PAD14_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetTOUCH_PAD14_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetTOUCH_PAD14_XPD(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x100000)|value<<20)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_XPD() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x100000) >> 20
}
func (o *RTCIO_Type) SetTOUCH_PAD14_TIE_OPT(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x200000)|value<<21)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_TIE_OPT() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x200000) >> 21
}
func (o *RTCIO_Type) SetTOUCH_PAD14_START(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x400000)|value<<22)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_START() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x400000) >> 22
}
func (o *RTCIO_Type) SetTOUCH_PAD14_DAC(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x3800000)|value<<23)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_DAC() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x3800000) >> 23
}
func (o *RTCIO_Type) SetTOUCH_PAD14_RUE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_RUE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetTOUCH_PAD14_RDE(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_RDE() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetTOUCH_PAD14_DRV(value uint32) {
	volatile.StoreUint32(&o.TOUCH_PAD14.Reg, volatile.LoadUint32(&o.TOUCH_PAD14.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetTOUCH_PAD14_DRV() uint32 {
	return (volatile.LoadUint32(&o.TOUCH_PAD14.Reg) & 0x60000000) >> 29
}

// RTCIO.XTAL_32P_PAD: 32KHz crystal P-pad configuration register
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_RUE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_RUE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_RDE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_RDE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetXTAL_32P_PAD_X32P_DRV(value uint32) {
	volatile.StoreUint32(&o.XTAL_32P_PAD.Reg, volatile.LoadUint32(&o.XTAL_32P_PAD.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetXTAL_32P_PAD_X32P_DRV() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32P_PAD.Reg) & 0x60000000) >> 29
}

// RTCIO.XTAL_32N_PAD: 32KHz crystal N-pad configuration register
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_RUE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_RUE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_RDE(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_RDE() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetXTAL_32N_PAD_X32N_DRV(value uint32) {
	volatile.StoreUint32(&o.XTAL_32N_PAD.Reg, volatile.LoadUint32(&o.XTAL_32N_PAD.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetXTAL_32N_PAD_X32N_DRV() uint32 {
	return (volatile.LoadUint32(&o.XTAL_32N_PAD.Reg) & 0x60000000) >> 29
}

// RTCIO.PAD_DAC1: DAC1 configuration register
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_DAC(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x7f8)|value<<3)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_DAC() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x7f8) >> 3
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_XPD_DAC(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x800)|value<<11)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_XPD_DAC() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x800) >> 11
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_DAC_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x1000)|value<<12)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_DAC_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x1000) >> 12
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_RUE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_RUE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_RDE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_RDE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetPAD_DAC1_PDAC1_DRV(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC1.Reg, volatile.LoadUint32(&o.PAD_DAC1.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetPAD_DAC1_PDAC1_DRV() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC1.Reg) & 0x60000000) >> 29
}

// RTCIO.PAD_DAC2: DAC2 configuration register
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_DAC(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x7f8)|value<<3)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_DAC() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x7f8) >> 3
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_XPD_DAC(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x800)|value<<11)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_XPD_DAC() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x800) >> 11
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_DAC_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x1000)|value<<12)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_DAC_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x1000) >> 12
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_RUE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_RUE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_RDE(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_RDE() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetPAD_DAC2_PDAC2_DRV(value uint32) {
	volatile.StoreUint32(&o.PAD_DAC2.Reg, volatile.LoadUint32(&o.PAD_DAC2.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetPAD_DAC2_PDAC2_DRV() uint32 {
	return (volatile.LoadUint32(&o.PAD_DAC2.Reg) & 0x60000000) >> 29
}

// RTCIO.RTC_PAD19: Touch pad 19 configuration register
func (o *RTCIO_Type) SetRTC_PAD19_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetRTC_PAD19_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetRTC_PAD19_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetRTC_PAD19_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetRTC_PAD19_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetRTC_PAD19_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetRTC_PAD19_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetRTC_PAD19_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetRTC_PAD19_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetRTC_PAD19_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetRTC_PAD19_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetRTC_PAD19_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetRTC_PAD19_RUE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetRTC_PAD19_RUE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetRTC_PAD19_RDE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetRTC_PAD19_RDE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetRTC_PAD19_DRV(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD19.Reg, volatile.LoadUint32(&o.RTC_PAD19.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetRTC_PAD19_DRV() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD19.Reg) & 0x60000000) >> 29
}

// RTCIO.RTC_PAD20: Touch pad 20 configuration register
func (o *RTCIO_Type) SetRTC_PAD20_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetRTC_PAD20_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetRTC_PAD20_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetRTC_PAD20_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetRTC_PAD20_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetRTC_PAD20_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetRTC_PAD20_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetRTC_PAD20_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetRTC_PAD20_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetRTC_PAD20_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetRTC_PAD20_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetRTC_PAD20_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetRTC_PAD20_RUE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetRTC_PAD20_RUE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetRTC_PAD20_RDE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetRTC_PAD20_RDE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetRTC_PAD20_DRV(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD20.Reg, volatile.LoadUint32(&o.RTC_PAD20.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetRTC_PAD20_DRV() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD20.Reg) & 0x60000000) >> 29
}

// RTCIO.RTC_PAD21: Touch pad 21 configuration register
func (o *RTCIO_Type) SetRTC_PAD21_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x2000)|value<<13)
}
func (o *RTCIO_Type) GetRTC_PAD21_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x2000) >> 13
}
func (o *RTCIO_Type) SetRTC_PAD21_SLP_OE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x4000)|value<<14)
}
func (o *RTCIO_Type) GetRTC_PAD21_SLP_OE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x4000) >> 14
}
func (o *RTCIO_Type) SetRTC_PAD21_SLP_IE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x8000)|value<<15)
}
func (o *RTCIO_Type) GetRTC_PAD21_SLP_IE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x8000) >> 15
}
func (o *RTCIO_Type) SetRTC_PAD21_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x10000)|value<<16)
}
func (o *RTCIO_Type) GetRTC_PAD21_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x10000) >> 16
}
func (o *RTCIO_Type) SetRTC_PAD21_FUN_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x60000)|value<<17)
}
func (o *RTCIO_Type) GetRTC_PAD21_FUN_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x60000) >> 17
}
func (o *RTCIO_Type) SetRTC_PAD21_MUX_SEL(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x80000)|value<<19)
}
func (o *RTCIO_Type) GetRTC_PAD21_MUX_SEL() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x80000) >> 19
}
func (o *RTCIO_Type) SetRTC_PAD21_RUE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x8000000)|value<<27)
}
func (o *RTCIO_Type) GetRTC_PAD21_RUE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x8000000) >> 27
}
func (o *RTCIO_Type) SetRTC_PAD21_RDE(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x10000000)|value<<28)
}
func (o *RTCIO_Type) GetRTC_PAD21_RDE() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x10000000) >> 28
}
func (o *RTCIO_Type) SetRTC_PAD21_DRV(value uint32) {
	volatile.StoreUint32(&o.RTC_PAD21.Reg, volatile.LoadUint32(&o.RTC_PAD21.Reg)&^(0x60000000)|value<<29)
}
func (o *RTCIO_Type) GetRTC_PAD21_DRV() uint32 {
	return (volatile.LoadUint32(&o.RTC_PAD21.Reg) & 0x60000000) >> 29
}

// RTCIO.EXT_WAKEUP0: External wake up configuration register
func (o *RTCIO_Type) SetEXT_WAKEUP0_SEL(value uint32) {
	volatile.StoreUint32(&o.EXT_WAKEUP0.Reg, volatile.LoadUint32(&o.EXT_WAKEUP0.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTCIO_Type) GetEXT_WAKEUP0_SEL() uint32 {
	return (volatile.LoadUint32(&o.EXT_WAKEUP0.Reg) & 0xf8000000) >> 27
}

// RTCIO.XTL_EXT_CTR: Crystal power down enable GPIO source
func (o *RTCIO_Type) SetXTL_EXT_CTR_SEL(value uint32) {
	volatile.StoreUint32(&o.XTL_EXT_CTR.Reg, volatile.LoadUint32(&o.XTL_EXT_CTR.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTCIO_Type) GetXTL_EXT_CTR_SEL() uint32 {
	return (volatile.LoadUint32(&o.XTL_EXT_CTR.Reg) & 0xf8000000) >> 27
}

// RTCIO.SAR_I2C_IO: RTC I2C pad selection
func (o *RTCIO_Type) SetSAR_I2C_IO_SAR_DEBUG_BIT_SEL(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_IO.Reg, volatile.LoadUint32(&o.SAR_I2C_IO.Reg)&^(0xf800000)|value<<23)
}
func (o *RTCIO_Type) GetSAR_I2C_IO_SAR_DEBUG_BIT_SEL() uint32 {
	return (volatile.LoadUint32(&o.SAR_I2C_IO.Reg) & 0xf800000) >> 23
}
func (o *RTCIO_Type) SetSAR_I2C_IO_SAR_I2C_SCL_SEL(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_IO.Reg, volatile.LoadUint32(&o.SAR_I2C_IO.Reg)&^(0x30000000)|value<<28)
}
func (o *RTCIO_Type) GetSAR_I2C_IO_SAR_I2C_SCL_SEL() uint32 {
	return (volatile.LoadUint32(&o.SAR_I2C_IO.Reg) & 0x30000000) >> 28
}
func (o *RTCIO_Type) SetSAR_I2C_IO_SAR_I2C_SDA_SEL(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_IO.Reg, volatile.LoadUint32(&o.SAR_I2C_IO.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTCIO_Type) GetSAR_I2C_IO_SAR_I2C_SDA_SEL() uint32 {
	return (volatile.LoadUint32(&o.SAR_I2C_IO.Reg) & 0xc0000000) >> 30
}

// RTCIO.RTC_IO_TOUCH_CTRL: Touch control register
func (o *RTCIO_Type) SetRTC_IO_TOUCH_CTRL_IO_TOUCH_BUFSEL(value uint32) {
	volatile.StoreUint32(&o.RTC_IO_TOUCH_CTRL.Reg, volatile.LoadUint32(&o.RTC_IO_TOUCH_CTRL.Reg)&^(0xf)|value)
}
func (o *RTCIO_Type) GetRTC_IO_TOUCH_CTRL_IO_TOUCH_BUFSEL() uint32 {
	return volatile.LoadUint32(&o.RTC_IO_TOUCH_CTRL.Reg) & 0xf
}
func (o *RTCIO_Type) SetRTC_IO_TOUCH_CTRL_IO_TOUCH_BUFMODE(value uint32) {
	volatile.StoreUint32(&o.RTC_IO_TOUCH_CTRL.Reg, volatile.LoadUint32(&o.RTC_IO_TOUCH_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTCIO_Type) GetRTC_IO_TOUCH_CTRL_IO_TOUCH_BUFMODE() uint32 {
	return (volatile.LoadUint32(&o.RTC_IO_TOUCH_CTRL.Reg) & 0x10) >> 4
}

// RTCIO.RTC_IO_DATE: Version control register
func (o *RTCIO_Type) SetRTC_IO_DATE_IO_DATE(value uint32) {
	volatile.StoreUint32(&o.RTC_IO_DATE.Reg, volatile.LoadUint32(&o.RTC_IO_DATE.Reg)&^(0xfffffff)|value)
}
func (o *RTCIO_Type) GetRTC_IO_DATE_IO_DATE() uint32 {
	return volatile.LoadUint32(&o.RTC_IO_DATE.Reg) & 0xfffffff
}

// Real-Time Clock Control
type RTC_CNTL_Type struct {
	_              [248]byte
	ULP_CP_TIMER   volatile.Register32 // 0xF8
	ULP_CP_CTRL    volatile.Register32 // 0xFC
	COCPU_CTRL     volatile.Register32 // 0x100
	_              [44]byte
	ULP_CP_TIMER_1 volatile.Register32 // 0x130
}

// RTC_CNTL.ULP_CP_TIMER: Configure coprocessor timer
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_ULP_CP_PC_INIT(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER.Reg)&^(0x7ff)|value)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_ULP_CP_PC_INIT() uint32 {
	return volatile.LoadUint32(&o.ULP_CP_TIMER.Reg) & 0x7ff
}
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_ENA(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_ENA() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_TIMER.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_TIMER.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_ULP_CP_SLP_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_ULP_CP_SLP_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_TIMER.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.ULP_CP_CTRL: ULP-FSM configuration register
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_MEM_ADDR_INIT(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x7ff)|value)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_MEM_ADDR_INIT() uint32 {
	return volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x7ff
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_MEM_ADDR_SIZE(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x3ff800)|value<<11)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_MEM_ADDR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x3ff800) >> 11
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_MEM_OFFSET_CLR(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_MEM_OFFSET_CLR() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_CLK_FO() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x10000000) >> 28
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_RESET(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_RESET() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x20000000) >> 29
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_FORCE_START_TOP(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_FORCE_START_TOP() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x40000000) >> 30
}
func (o *RTC_CNTL_Type) SetULP_CP_CTRL_ULP_CP_START_TOP(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_CTRL.Reg, volatile.LoadUint32(&o.ULP_CP_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_CNTL_Type) GetULP_CP_CTRL_ULP_CP_START_TOP() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_CTRL.Reg) & 0x80000000) >> 31
}

// RTC_CNTL.COCPU_CTRL: ULP-RISCV configuration register
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_CLK_FO() uint32 {
	return volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x1
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_START_2_RESET_DIS(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x7e)|value<<1)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_START_2_RESET_DIS() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x7e) >> 1
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_START_2_INTR_EN(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x1f80)|value<<7)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_START_2_INTR_EN() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x1f80) >> 7
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_SHUT(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_SHUT() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x2000) >> 13
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_SHUT_2_CLK_DIS(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x3fc000)|value<<14)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_SHUT_2_CLK_DIS() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x3fc000) >> 14
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_SHUT_RESET_EN(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_SHUT_RESET_EN() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x400000) >> 22
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_SEL(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_SEL() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x800000) >> 23
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_DONE_FORCE(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_DONE_FORCE() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_DONE(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_DONE() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_CNTL_Type) SetCOCPU_CTRL_COCPU_SW_INT_TRIGGER(value uint32) {
	volatile.StoreUint32(&o.COCPU_CTRL.Reg, volatile.LoadUint32(&o.COCPU_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_CNTL_Type) GetCOCPU_CTRL_COCPU_SW_INT_TRIGGER() uint32 {
	return (volatile.LoadUint32(&o.COCPU_CTRL.Reg) & 0x4000000) >> 26
}

// RTC_CNTL.ULP_CP_TIMER_1: Configure sleep cycle of the timer
func (o *RTC_CNTL_Type) SetULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE(value uint32) {
	volatile.StoreUint32(&o.ULP_CP_TIMER_1.Reg, volatile.LoadUint32(&o.ULP_CP_TIMER_1.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_CNTL_Type) GetULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.ULP_CP_TIMER_1.Reg) & 0xffffff00) >> 8
}

// Low-power I2C (Inter-Integrated Circuit) Controller
type RTC_I2C_Type struct {
	SCL_LOW          volatile.Register32 // 0x0
	CTRL             volatile.Register32 // 0x4
	STATUS           volatile.Register32 // 0x8
	TO               volatile.Register32 // 0xC
	SLAVE_ADDR       volatile.Register32 // 0x10
	SCL_HIGH         volatile.Register32 // 0x14
	SDA_DUTY         volatile.Register32 // 0x18
	SCL_START_PERIOD volatile.Register32 // 0x1C
	SCL_STOP_PERIOD  volatile.Register32 // 0x20
	INT_CLR          volatile.Register32 // 0x24
	INT_RAW          volatile.Register32 // 0x28
	INT_ST           volatile.Register32 // 0x2C
	INT_ENA          volatile.Register32 // 0x30
	DATA             volatile.Register32 // 0x34
	CMD0             volatile.Register32 // 0x38
	CMD1             volatile.Register32 // 0x3C
	CMD2             volatile.Register32 // 0x40
	CMD3             volatile.Register32 // 0x44
	CMD4             volatile.Register32 // 0x48
	CMD5             volatile.Register32 // 0x4C
	CMD6             volatile.Register32 // 0x50
	CMD7             volatile.Register32 // 0x54
	CMD8             volatile.Register32 // 0x58
	CMD9             volatile.Register32 // 0x5C
	CMD10            volatile.Register32 // 0x60
	CMD11            volatile.Register32 // 0x64
	CMD12            volatile.Register32 // 0x68
	CMD13            volatile.Register32 // 0x6C
	CMD14            volatile.Register32 // 0x70
	CMD15            volatile.Register32 // 0x74
	_                [132]byte
	DATE             volatile.Register32 // 0xFC
}

// RTC_I2C.SCL_LOW: Configure the low level width of SCL
func (o *RTC_I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW.Reg, volatile.LoadUint32(&o.SCL_LOW.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW.Reg) & 0xfffff
}

// RTC_I2C.CTRL: Transmission setting
func (o *RTC_I2C_Type) SetCTRL_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetCTRL_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetCTRL_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetCTRL_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetCTRL_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetCTRL_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetCTRL_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetCTRL_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetCTRL_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetCTRL_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetCTRL_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetCTRL_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetCTRL_CLK_GATE_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *RTC_I2C_Type) GetCTRL_CLK_GATE_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000000) >> 29
}
func (o *RTC_I2C_Type) SetCTRL_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_I2C_Type) GetCTRL_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40000000) >> 30
}
func (o *RTC_I2C_Type) SetCTRL_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCTRL_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80000000) >> 31
}

// RTC_I2C.STATUS: RTC I2C status
func (o *RTC_I2C_Type) SetSTATUS_ACK_REC(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetSTATUS_ACK_REC() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetSTATUS_SLAVE_RW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetSTATUS_SLAVE_RW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetSTATUS_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetSTATUS_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetSTATUS_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetSTATUS_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetSTATUS_SLAVE_ADDRESSED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetSTATUS_SLAVE_ADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetSTATUS_BYTE_TRANS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetSTATUS_BYTE_TRANS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetSTATUS_OP_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_I2C_Type) GetSTATUS_OP_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xc0) >> 6
}
func (o *RTC_I2C_Type) SetSTATUS_SHIFT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xff0000)|value<<16)
}
func (o *RTC_I2C_Type) GetSTATUS_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xff0000) >> 16
}
func (o *RTC_I2C_Type) SetSTATUS_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x7000000)|value<<24)
}
func (o *RTC_I2C_Type) GetSTATUS_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x7000000) >> 24
}
func (o *RTC_I2C_Type) SetSTATUS_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x70000000)|value<<28)
}
func (o *RTC_I2C_Type) GetSTATUS_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x70000000) >> 28
}

// RTC_I2C.TO: Configure RTC I2C timeout
func (o *RTC_I2C_Type) SetTO_TIME_OUT(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetTO_TIME_OUT() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0xfffff
}

// RTC_I2C.SLAVE_ADDR: Configure slave address
func (o *RTC_I2C_Type) SetSLAVE_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x7fff)|value)
}
func (o *RTC_I2C_Type) GetSLAVE_ADDR() uint32 {
	return volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x7fff
}
func (o *RTC_I2C_Type) SetSLAVE_ADDR_ADDR_10BIT_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetSLAVE_ADDR_ADDR_10BIT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x80000000) >> 31
}

// RTC_I2C.SCL_HIGH: Configure the high level width of SCL
func (o *RTC_I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH.Reg, volatile.LoadUint32(&o.SCL_HIGH.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH.Reg) & 0xfffff
}

// RTC_I2C.SDA_DUTY: Configure the SDA hold time after a negative SCL edge
func (o *RTC_I2C_Type) SetSDA_DUTY_NUM(value uint32) {
	volatile.StoreUint32(&o.SDA_DUTY.Reg, volatile.LoadUint32(&o.SDA_DUTY.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetSDA_DUTY_NUM() uint32 {
	return volatile.LoadUint32(&o.SDA_DUTY.Reg) & 0xfffff
}

// RTC_I2C.SCL_START_PERIOD: Configure the delay between the SDA and SCL negative edge for a start condition
func (o *RTC_I2C_Type) SetSCL_START_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_START_PERIOD.Reg, volatile.LoadUint32(&o.SCL_START_PERIOD.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetSCL_START_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_START_PERIOD.Reg) & 0xfffff
}

// RTC_I2C.SCL_STOP_PERIOD: Configure the delay between SDA and SCL positive edge for a stop condition
func (o *RTC_I2C_Type) SetSCL_STOP_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_PERIOD.Reg, volatile.LoadUint32(&o.SCL_STOP_PERIOD.Reg)&^(0xfffff)|value)
}
func (o *RTC_I2C_Type) GetSCL_STOP_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_PERIOD.Reg) & 0xfffff
}

// RTC_I2C.INT_CLR: Clear RTC I2C interrupt
func (o *RTC_I2C_Type) SetINT_CLR_SLAVE_TRAN_COMP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetINT_CLR_SLAVE_TRAN_COMP_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetINT_CLR_MASTER_TRAN_COMP_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetINT_CLR_MASTER_TRAN_COMP_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetINT_CLR_ACK_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetINT_CLR_ACK_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetINT_CLR_RX_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_I2C_Type) GetINT_CLR_RX_DATA_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *RTC_I2C_Type) SetINT_CLR_TX_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_I2C_Type) GetINT_CLR_TX_DATA_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *RTC_I2C_Type) SetINT_CLR_DETECT_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_I2C_Type) GetINT_CLR_DETECT_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}

// RTC_I2C.INT_RAW: RTC I2C raw interrupt
func (o *RTC_I2C_Type) SetINT_RAW_SLAVE_TRAN_COMP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetINT_RAW_SLAVE_TRAN_COMP_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetINT_RAW_MASTER_TRAN_COMP_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetINT_RAW_MASTER_TRAN_COMP_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetINT_RAW_ACK_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetINT_RAW_ACK_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetINT_RAW_RX_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *RTC_I2C_Type) GetINT_RAW_RX_DATA_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *RTC_I2C_Type) SetINT_RAW_TX_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *RTC_I2C_Type) GetINT_RAW_TX_DATA_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *RTC_I2C_Type) SetINT_RAW_DETECT_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *RTC_I2C_Type) GetINT_RAW_DETECT_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}

// RTC_I2C.INT_ST: RTC I2C interrupt status
func (o *RTC_I2C_Type) SetINT_ST_SLAVE_TRAN_COMP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetINT_ST_SLAVE_TRAN_COMP_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetINT_ST_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetINT_ST_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetINT_ST_MASTER_TRAN_COMP_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetINT_ST_MASTER_TRAN_COMP_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetINT_ST_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetINT_ST_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetINT_ST_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetINT_ST_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetINT_ST_ACK_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetINT_ST_ACK_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetINT_ST_RX_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *RTC_I2C_Type) GetINT_ST_RX_DATA_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *RTC_I2C_Type) SetINT_ST_TX_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *RTC_I2C_Type) GetINT_ST_TX_DATA_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *RTC_I2C_Type) SetINT_ST_DETECT_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *RTC_I2C_Type) GetINT_ST_DETECT_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}

// RTC_I2C.INT_ENA: Enable RTC I2C interrupt
func (o *RTC_I2C_Type) SetINT_ENA_SLAVE_TRAN_COMP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *RTC_I2C_Type) GetINT_ENA_SLAVE_TRAN_COMP_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *RTC_I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *RTC_I2C_Type) SetINT_ENA_MASTER_TRAN_COMP_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *RTC_I2C_Type) GetINT_ENA_MASTER_TRAN_COMP_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *RTC_I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *RTC_I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *RTC_I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *RTC_I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *RTC_I2C_Type) SetINT_ENA_ACK_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *RTC_I2C_Type) GetINT_ENA_ACK_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *RTC_I2C_Type) SetINT_ENA_RX_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *RTC_I2C_Type) GetINT_ENA_RX_DATA_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *RTC_I2C_Type) SetINT_ENA_TX_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *RTC_I2C_Type) GetINT_ENA_TX_DATA_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *RTC_I2C_Type) SetINT_ENA_DETECT_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *RTC_I2C_Type) GetINT_ENA_DETECT_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}

// RTC_I2C.DATA: RTC I2C read data
func (o *RTC_I2C_Type) SetDATA_RDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *RTC_I2C_Type) GetDATA_RDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}
func (o *RTC_I2C_Type) SetDATA_SLAVE_TX_DATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_I2C_Type) GetDATA_SLAVE_TX_DATA() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0xff00) >> 8
}
func (o *RTC_I2C_Type) SetDATA_DONE(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetDATA_DONE() uint32 {
	return (volatile.LoadUint32(&o.DATA.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD0: RTC I2C Command 0
func (o *RTC_I2C_Type) SetCMD0_COMMAND0(value uint32) {
	volatile.StoreUint32(&o.CMD0.Reg, volatile.LoadUint32(&o.CMD0.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD0_COMMAND0() uint32 {
	return volatile.LoadUint32(&o.CMD0.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD0_COMMAND0_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD0.Reg, volatile.LoadUint32(&o.CMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD0_COMMAND0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD0.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD1: RTC I2C Command 1
func (o *RTC_I2C_Type) SetCMD1_COMMAND1(value uint32) {
	volatile.StoreUint32(&o.CMD1.Reg, volatile.LoadUint32(&o.CMD1.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD1_COMMAND1() uint32 {
	return volatile.LoadUint32(&o.CMD1.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD1_COMMAND1_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD1.Reg, volatile.LoadUint32(&o.CMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD1_COMMAND1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD1.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD2: RTC I2C Command 2
func (o *RTC_I2C_Type) SetCMD2_COMMAND2(value uint32) {
	volatile.StoreUint32(&o.CMD2.Reg, volatile.LoadUint32(&o.CMD2.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD2_COMMAND2() uint32 {
	return volatile.LoadUint32(&o.CMD2.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD2_COMMAND2_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD2.Reg, volatile.LoadUint32(&o.CMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD2_COMMAND2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD2.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD3: RTC I2C Command 3
func (o *RTC_I2C_Type) SetCMD3_COMMAND3(value uint32) {
	volatile.StoreUint32(&o.CMD3.Reg, volatile.LoadUint32(&o.CMD3.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD3_COMMAND3() uint32 {
	return volatile.LoadUint32(&o.CMD3.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD3_COMMAND3_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD3.Reg, volatile.LoadUint32(&o.CMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD3_COMMAND3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD3.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD4: RTC I2C Command 4
func (o *RTC_I2C_Type) SetCMD4_COMMAND4(value uint32) {
	volatile.StoreUint32(&o.CMD4.Reg, volatile.LoadUint32(&o.CMD4.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD4_COMMAND4() uint32 {
	return volatile.LoadUint32(&o.CMD4.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD4_COMMAND4_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD4.Reg, volatile.LoadUint32(&o.CMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD4_COMMAND4_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD4.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD5: RTC I2C Command 5
func (o *RTC_I2C_Type) SetCMD5_COMMAND5(value uint32) {
	volatile.StoreUint32(&o.CMD5.Reg, volatile.LoadUint32(&o.CMD5.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD5_COMMAND5() uint32 {
	return volatile.LoadUint32(&o.CMD5.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD5_COMMAND5_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD5.Reg, volatile.LoadUint32(&o.CMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD5_COMMAND5_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD5.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD6: RTC I2C Command 6
func (o *RTC_I2C_Type) SetCMD6_COMMAND6(value uint32) {
	volatile.StoreUint32(&o.CMD6.Reg, volatile.LoadUint32(&o.CMD6.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD6_COMMAND6() uint32 {
	return volatile.LoadUint32(&o.CMD6.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD6_COMMAND6_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD6.Reg, volatile.LoadUint32(&o.CMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD6_COMMAND6_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD6.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD7: RTC I2C Command 7
func (o *RTC_I2C_Type) SetCMD7_COMMAND7(value uint32) {
	volatile.StoreUint32(&o.CMD7.Reg, volatile.LoadUint32(&o.CMD7.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD7_COMMAND7() uint32 {
	return volatile.LoadUint32(&o.CMD7.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD7_COMMAND7_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD7.Reg, volatile.LoadUint32(&o.CMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD7_COMMAND7_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD7.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD8: RTC I2C Command 8
func (o *RTC_I2C_Type) SetCMD8_COMMAND8(value uint32) {
	volatile.StoreUint32(&o.CMD8.Reg, volatile.LoadUint32(&o.CMD8.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD8_COMMAND8() uint32 {
	return volatile.LoadUint32(&o.CMD8.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD8_COMMAND8_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD8.Reg, volatile.LoadUint32(&o.CMD8.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD8_COMMAND8_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD8.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD9: RTC I2C Command 9
func (o *RTC_I2C_Type) SetCMD9_COMMAND9(value uint32) {
	volatile.StoreUint32(&o.CMD9.Reg, volatile.LoadUint32(&o.CMD9.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD9_COMMAND9() uint32 {
	return volatile.LoadUint32(&o.CMD9.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD9_COMMAND9_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD9.Reg, volatile.LoadUint32(&o.CMD9.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD9_COMMAND9_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD9.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD10: RTC I2C Command 10
func (o *RTC_I2C_Type) SetCMD10_COMMAND10(value uint32) {
	volatile.StoreUint32(&o.CMD10.Reg, volatile.LoadUint32(&o.CMD10.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD10_COMMAND10() uint32 {
	return volatile.LoadUint32(&o.CMD10.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD10_COMMAND10_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD10.Reg, volatile.LoadUint32(&o.CMD10.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD10_COMMAND10_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD10.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD11: RTC I2C Command 11
func (o *RTC_I2C_Type) SetCMD11_COMMAND11(value uint32) {
	volatile.StoreUint32(&o.CMD11.Reg, volatile.LoadUint32(&o.CMD11.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD11_COMMAND11() uint32 {
	return volatile.LoadUint32(&o.CMD11.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD11_COMMAND11_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD11.Reg, volatile.LoadUint32(&o.CMD11.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD11_COMMAND11_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD11.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD12: RTC I2C Command 12
func (o *RTC_I2C_Type) SetCMD12_COMMAND12(value uint32) {
	volatile.StoreUint32(&o.CMD12.Reg, volatile.LoadUint32(&o.CMD12.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD12_COMMAND12() uint32 {
	return volatile.LoadUint32(&o.CMD12.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD12_COMMAND12_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD12.Reg, volatile.LoadUint32(&o.CMD12.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD12_COMMAND12_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD12.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD13: RTC I2C Command 13
func (o *RTC_I2C_Type) SetCMD13_COMMAND13(value uint32) {
	volatile.StoreUint32(&o.CMD13.Reg, volatile.LoadUint32(&o.CMD13.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD13_COMMAND13() uint32 {
	return volatile.LoadUint32(&o.CMD13.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD13_COMMAND13_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD13.Reg, volatile.LoadUint32(&o.CMD13.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD13_COMMAND13_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD13.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD14: RTC I2C Command 14
func (o *RTC_I2C_Type) SetCMD14_COMMAND14(value uint32) {
	volatile.StoreUint32(&o.CMD14.Reg, volatile.LoadUint32(&o.CMD14.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD14_COMMAND14() uint32 {
	return volatile.LoadUint32(&o.CMD14.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD14_COMMAND14_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD14.Reg, volatile.LoadUint32(&o.CMD14.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD14_COMMAND14_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD14.Reg) & 0x80000000) >> 31
}

// RTC_I2C.CMD15: RTC I2C Command 15
func (o *RTC_I2C_Type) SetCMD15_COMMAND15(value uint32) {
	volatile.StoreUint32(&o.CMD15.Reg, volatile.LoadUint32(&o.CMD15.Reg)&^(0x3fff)|value)
}
func (o *RTC_I2C_Type) GetCMD15_COMMAND15() uint32 {
	return volatile.LoadUint32(&o.CMD15.Reg) & 0x3fff
}
func (o *RTC_I2C_Type) SetCMD15_COMMAND15_DONE(value uint32) {
	volatile.StoreUint32(&o.CMD15.Reg, volatile.LoadUint32(&o.CMD15.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_I2C_Type) GetCMD15_COMMAND15_DONE() uint32 {
	return (volatile.LoadUint32(&o.CMD15.Reg) & 0x80000000) >> 31
}

// RTC_I2C.DATE: Version control register
func (o *RTC_I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *RTC_I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// SENS Peripheral
type SENS_Type struct {
	_                 [64]byte
	SAR_SLAVE_ADDR1   volatile.Register32 // 0x40
	SAR_SLAVE_ADDR2   volatile.Register32 // 0x44
	SAR_SLAVE_ADDR3   volatile.Register32 // 0x48
	SAR_SLAVE_ADDR4   volatile.Register32 // 0x4C
	_                 [8]byte
	SAR_I2C_CTRL      volatile.Register32 // 0x58
	_                 [204]byte
	SAR_COCPU_INT_RAW volatile.Register32 // 0x128
	SAR_COCPU_INT_ENA volatile.Register32 // 0x12C
	SAR_COCPU_INT_ST  volatile.Register32 // 0x130
	SAR_COCPU_INT_CLR volatile.Register32 // 0x134
}

// SENS.SAR_SLAVE_ADDR1: Configure slave addresses 0-1 of RTC I2C
func (o *SENS_Type) SetSAR_SLAVE_ADDR1_I2C_SLAVE_ADDR1(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR1.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg)&^(0x7ff)|value)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR1_I2C_SLAVE_ADDR1() uint32 {
	return volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg) & 0x7ff
}
func (o *SENS_Type) SetSAR_SLAVE_ADDR1_I2C_SLAVE_ADDR0(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR1.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg)&^(0x3ff800)|value<<11)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR1_I2C_SLAVE_ADDR0() uint32 {
	return (volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg) & 0x3ff800) >> 11
}
func (o *SENS_Type) SetSAR_SLAVE_ADDR1_MEAS_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR1.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg)&^(0x3fc00000)|value<<22)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR1_MEAS_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SAR_SLAVE_ADDR1.Reg) & 0x3fc00000) >> 22
}

// SENS.SAR_SLAVE_ADDR2: Configure slave addresses 2-3 of RTC I2C
func (o *SENS_Type) SetSAR_SLAVE_ADDR2_I2C_SLAVE_ADDR3(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR2.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR2.Reg)&^(0x7ff)|value)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR2_I2C_SLAVE_ADDR3() uint32 {
	return volatile.LoadUint32(&o.SAR_SLAVE_ADDR2.Reg) & 0x7ff
}
func (o *SENS_Type) SetSAR_SLAVE_ADDR2_I2C_SLAVE_ADDR2(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR2.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR2.Reg)&^(0x3ff800)|value<<11)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR2_I2C_SLAVE_ADDR2() uint32 {
	return (volatile.LoadUint32(&o.SAR_SLAVE_ADDR2.Reg) & 0x3ff800) >> 11
}

// SENS.SAR_SLAVE_ADDR3: Configure slave addresses 4-5 of RTC I2C
func (o *SENS_Type) SetSAR_SLAVE_ADDR3_I2C_SLAVE_ADDR5(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR3.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR3.Reg)&^(0x7ff)|value)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR3_I2C_SLAVE_ADDR5() uint32 {
	return volatile.LoadUint32(&o.SAR_SLAVE_ADDR3.Reg) & 0x7ff
}
func (o *SENS_Type) SetSAR_SLAVE_ADDR3_I2C_SLAVE_ADDR4(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR3.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR3.Reg)&^(0x3ff800)|value<<11)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR3_I2C_SLAVE_ADDR4() uint32 {
	return (volatile.LoadUint32(&o.SAR_SLAVE_ADDR3.Reg) & 0x3ff800) >> 11
}

// SENS.SAR_SLAVE_ADDR4: Configure slave addresses 6-7 of RTC I2C
func (o *SENS_Type) SetSAR_SLAVE_ADDR4_I2C_SLAVE_ADDR7(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR4.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR4.Reg)&^(0x7ff)|value)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR4_I2C_SLAVE_ADDR7() uint32 {
	return volatile.LoadUint32(&o.SAR_SLAVE_ADDR4.Reg) & 0x7ff
}
func (o *SENS_Type) SetSAR_SLAVE_ADDR4_I2C_SLAVE_ADDR6(value uint32) {
	volatile.StoreUint32(&o.SAR_SLAVE_ADDR4.Reg, volatile.LoadUint32(&o.SAR_SLAVE_ADDR4.Reg)&^(0x3ff800)|value<<11)
}
func (o *SENS_Type) GetSAR_SLAVE_ADDR4_I2C_SLAVE_ADDR6() uint32 {
	return (volatile.LoadUint32(&o.SAR_SLAVE_ADDR4.Reg) & 0x3ff800) >> 11
}

// SENS.SAR_I2C_CTRL: Configure RTC I2C transmission
func (o *SENS_Type) SetSAR_I2C_CTRL(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_CTRL.Reg, volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg)&^(0xfffffff)|value)
}
func (o *SENS_Type) GetSAR_I2C_CTRL() uint32 {
	return volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg) & 0xfffffff
}
func (o *SENS_Type) SetSAR_I2C_CTRL_SAR_I2C_START(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_CTRL.Reg, volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *SENS_Type) GetSAR_I2C_CTRL_SAR_I2C_START() uint32 {
	return (volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg) & 0x10000000) >> 28
}
func (o *SENS_Type) SetSAR_I2C_CTRL_SAR_I2C_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.SAR_I2C_CTRL.Reg, volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *SENS_Type) GetSAR_I2C_CTRL_SAR_I2C_START_FORCE() uint32 {
	return (volatile.LoadUint32(&o.SAR_I2C_CTRL.Reg) & 0x20000000) >> 29
}

// SENS.SAR_COCPU_INT_RAW: Interrupt raw bit of ULP-RISCV
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_TOUCH_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x1)|value)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_TOUCH_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x1
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_TOUCH_INACTIVE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_TOUCH_INACTIVE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x2) >> 1
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_TOUCH_ACTIVE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_TOUCH_ACTIVE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x4) >> 2
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_SARADC1_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_SARADC1_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x8) >> 3
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_SARADC2_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_SARADC2_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x10) >> 4
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_TSENS_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_TSENS_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x20) >> 5
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x40) >> 6
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_SW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_SW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x80) >> 7
}
func (o *SENS_Type) SetSAR_COCPU_INT_RAW_COCPU_SWD_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_RAW.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *SENS_Type) GetSAR_COCPU_INT_RAW_COCPU_SWD_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_RAW.Reg) & 0x100) >> 8
}

// SENS.SAR_COCPU_INT_ENA: Interrupt enable bit of ULP-RISCV
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_TOUCH_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x1)|value)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_TOUCH_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x1
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_TOUCH_INACTIVE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_TOUCH_INACTIVE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x2) >> 1
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_TOUCH_ACTIVE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_TOUCH_ACTIVE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x4) >> 2
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_SARADC1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_SARADC1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x8) >> 3
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_SARADC2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_SARADC2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x10) >> 4
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_TSENS_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_TSENS_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x20) >> 5
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x40) >> 6
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_SW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_SW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x80) >> 7
}
func (o *SENS_Type) SetSAR_COCPU_INT_ENA_COCPU_SWD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ENA.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ENA_COCPU_SWD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ENA.Reg) & 0x100) >> 8
}

// SENS.SAR_COCPU_INT_ST: Interrupt status bit of ULP-RISCV
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_TOUCH_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x1)|value)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_TOUCH_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x1
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_TOUCH_INACTIVE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_TOUCH_INACTIVE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x2) >> 1
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_TOUCH_ACTIVE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_TOUCH_ACTIVE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x4) >> 2
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_SARADC1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_SARADC1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x8) >> 3
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_SARADC2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_SARADC2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x10) >> 4
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_TSENS_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_TSENS_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x20) >> 5
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x40) >> 6
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_SW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_SW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x80) >> 7
}
func (o *SENS_Type) SetSAR_COCPU_INT_ST_COCPU_SWD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_ST.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *SENS_Type) GetSAR_COCPU_INT_ST_COCPU_SWD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_ST.Reg) & 0x100) >> 8
}

// SENS.SAR_COCPU_INT_CLR: Interrupt clear bit of ULP-RISCV
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_TOUCH_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x1)|value)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_TOUCH_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x1
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_TOUCH_INACTIVE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_TOUCH_INACTIVE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x2) >> 1
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_TOUCH_ACTIVE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_TOUCH_ACTIVE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x4) >> 2
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_SARADC1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_SARADC1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x8) >> 3
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_SARADC2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_SARADC2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x10) >> 4
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_TSENS_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_TSENS_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x20) >> 5
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x40) >> 6
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_SW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_SW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x80) >> 7
}
func (o *SENS_Type) SetSAR_COCPU_INT_CLR_COCPU_SWD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.SAR_COCPU_INT_CLR.Reg, volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *SENS_Type) GetSAR_COCPU_INT_CLR_COCPU_SWD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.SAR_COCPU_INT_CLR.Reg) & 0x100) >> 8
}

// Constants for RTC_IO: Low-power Input/Output
const (
	// RTC_GPIO_OUT: RTC GPIO output register
	// Position of GPIO_OUT_DATA field.
	RTCIO_RTC_GPIO_OUT_GPIO_OUT_DATA_Pos = 0xa
	// Bit mask of GPIO_OUT_DATA field.
	RTCIO_RTC_GPIO_OUT_GPIO_OUT_DATA_Msk = 0xfffffc00

	// RTC_GPIO_OUT_W1TS: RTC GPIO output bit set register
	// Position of GPIO_OUT_DATA_W1TS field.
	RTCIO_RTC_GPIO_OUT_W1TS_GPIO_OUT_DATA_W1TS_Pos = 0xa
	// Bit mask of GPIO_OUT_DATA_W1TS field.
	RTCIO_RTC_GPIO_OUT_W1TS_GPIO_OUT_DATA_W1TS_Msk = 0xfffffc00

	// RTC_GPIO_OUT_W1TC: RTC GPIO output bit clear register
	// Position of GPIO_OUT_DATA_W1TC field.
	RTCIO_RTC_GPIO_OUT_W1TC_GPIO_OUT_DATA_W1TC_Pos = 0xa
	// Bit mask of GPIO_OUT_DATA_W1TC field.
	RTCIO_RTC_GPIO_OUT_W1TC_GPIO_OUT_DATA_W1TC_Msk = 0xfffffc00

	// RTC_GPIO_ENABLE: RTC GPIO output enable register
	// Position of REG_RTCIO_REG_GPIO_ENABLE field.
	RTCIO_RTC_GPIO_ENABLE_REG_RTCIO_REG_GPIO_ENABLE_Pos = 0xa
	// Bit mask of REG_RTCIO_REG_GPIO_ENABLE field.
	RTCIO_RTC_GPIO_ENABLE_REG_RTCIO_REG_GPIO_ENABLE_Msk = 0xfffffc00

	// RTC_GPIO_ENABLE_W1TS: RTC GPIO output enable bit set register
	// Position of REG_RTCIO_REG_GPIO_ENABLE_W1TS field.
	RTCIO_RTC_GPIO_ENABLE_W1TS_REG_RTCIO_REG_GPIO_ENABLE_W1TS_Pos = 0xa
	// Bit mask of REG_RTCIO_REG_GPIO_ENABLE_W1TS field.
	RTCIO_RTC_GPIO_ENABLE_W1TS_REG_RTCIO_REG_GPIO_ENABLE_W1TS_Msk = 0xfffffc00

	// RTC_GPIO_ENABLE_W1TC: RTC GPIO output enable bit clear register
	// Position of REG_RTCIO_REG_GPIO_ENABLE_W1TC field.
	RTCIO_RTC_GPIO_ENABLE_W1TC_REG_RTCIO_REG_GPIO_ENABLE_W1TC_Pos = 0xa
	// Bit mask of REG_RTCIO_REG_GPIO_ENABLE_W1TC field.
	RTCIO_RTC_GPIO_ENABLE_W1TC_REG_RTCIO_REG_GPIO_ENABLE_W1TC_Msk = 0xfffffc00

	// RTC_GPIO_STATUS: RTC GPIO interrupt status register
	// Position of GPIO_STATUS_INT field.
	RTCIO_RTC_GPIO_STATUS_GPIO_STATUS_INT_Pos = 0xa
	// Bit mask of GPIO_STATUS_INT field.
	RTCIO_RTC_GPIO_STATUS_GPIO_STATUS_INT_Msk = 0xfffffc00

	// RTC_GPIO_STATUS_W1TS: RTC GPIO interrupt status bit set register
	// Position of GPIO_STATUS_INT_W1TS field.
	RTCIO_RTC_GPIO_STATUS_W1TS_GPIO_STATUS_INT_W1TS_Pos = 0xa
	// Bit mask of GPIO_STATUS_INT_W1TS field.
	RTCIO_RTC_GPIO_STATUS_W1TS_GPIO_STATUS_INT_W1TS_Msk = 0xfffffc00

	// RTC_GPIO_STATUS_W1TC: RTC GPIO interrupt status bit clear register
	// Position of GPIO_STATUS_INT_W1TC field.
	RTCIO_RTC_GPIO_STATUS_W1TC_GPIO_STATUS_INT_W1TC_Pos = 0xa
	// Bit mask of GPIO_STATUS_INT_W1TC field.
	RTCIO_RTC_GPIO_STATUS_W1TC_GPIO_STATUS_INT_W1TC_Msk = 0xfffffc00

	// RTC_GPIO_IN: RTC GPIO input register
	// Position of GPIO_IN_NEXT field.
	RTCIO_RTC_GPIO_IN_GPIO_IN_NEXT_Pos = 0xa
	// Bit mask of GPIO_IN_NEXT field.
	RTCIO_RTC_GPIO_IN_GPIO_IN_NEXT_Msk = 0xfffffc00

	// RTC_GPIO_PIN0: RTC configuration for pin %s
	// Position of GPIO_PIN_PAD_DRIVER field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_PAD_DRIVER_Pos = 0x2
	// Bit mask of GPIO_PIN_PAD_DRIVER field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_PAD_DRIVER_Msk = 0x4
	// Bit GPIO_PIN_PAD_DRIVER.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_PAD_DRIVER = 0x4
	// Position of GPIO_PIN_INT_TYPE field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_INT_TYPE_Pos = 0x7
	// Bit mask of GPIO_PIN_INT_TYPE field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_INT_TYPE_Msk = 0x380
	// Position of GPIO_PIN_WAKEUP_ENABLE field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_WAKEUP_ENABLE_Pos = 0xa
	// Bit mask of GPIO_PIN_WAKEUP_ENABLE field.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_WAKEUP_ENABLE_Msk = 0x400
	// Bit GPIO_PIN_WAKEUP_ENABLE.
	RTCIO_RTC_GPIO_PIN_GPIO_PIN_WAKEUP_ENABLE = 0x400

	// RTC_DEBUG_SEL: RTC debug select register
	// Position of RTC_DEBUG_SEL0 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL0_Pos = 0x0
	// Bit mask of RTC_DEBUG_SEL0 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL0_Msk = 0x1f
	// Position of RTC_DEBUG_SEL1 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL1_Pos = 0x5
	// Bit mask of RTC_DEBUG_SEL1 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL1_Msk = 0x3e0
	// Position of RTC_DEBUG_SEL2 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL2_Pos = 0xa
	// Bit mask of RTC_DEBUG_SEL2 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL2_Msk = 0x7c00
	// Position of RTC_DEBUG_SEL3 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL3_Pos = 0xf
	// Bit mask of RTC_DEBUG_SEL3 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL3_Msk = 0xf8000
	// Position of RTC_DEBUG_SEL4 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL4_Pos = 0x14
	// Bit mask of RTC_DEBUG_SEL4 field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_SEL4_Msk = 0x1f00000
	// Position of RTC_DEBUG_12M_NO_GATING field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_12M_NO_GATING_Pos = 0x19
	// Bit mask of RTC_DEBUG_12M_NO_GATING field.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_12M_NO_GATING_Msk = 0x2000000
	// Bit RTC_DEBUG_12M_NO_GATING.
	RTCIO_RTC_DEBUG_SEL_RTC_DEBUG_12M_NO_GATING = 0x2000000

	// TOUCH_PAD0: Touch pad %s configuration register
	// Position of FUN_IE field.
	RTCIO_TOUCH_PAD_FUN_IE_Pos = 0xd
	// Bit mask of FUN_IE field.
	RTCIO_TOUCH_PAD_FUN_IE_Msk = 0x2000
	// Bit FUN_IE.
	RTCIO_TOUCH_PAD_FUN_IE = 0x2000
	// Position of SLP_OE field.
	RTCIO_TOUCH_PAD_SLP_OE_Pos = 0xe
	// Bit mask of SLP_OE field.
	RTCIO_TOUCH_PAD_SLP_OE_Msk = 0x4000
	// Bit SLP_OE.
	RTCIO_TOUCH_PAD_SLP_OE = 0x4000
	// Position of SLP_IE field.
	RTCIO_TOUCH_PAD_SLP_IE_Pos = 0xf
	// Bit mask of SLP_IE field.
	RTCIO_TOUCH_PAD_SLP_IE_Msk = 0x8000
	// Bit SLP_IE.
	RTCIO_TOUCH_PAD_SLP_IE = 0x8000
	// Position of SLP_SEL field.
	RTCIO_TOUCH_PAD_SLP_SEL_Pos = 0x10
	// Bit mask of SLP_SEL field.
	RTCIO_TOUCH_PAD_SLP_SEL_Msk = 0x10000
	// Bit SLP_SEL.
	RTCIO_TOUCH_PAD_SLP_SEL = 0x10000
	// Position of FUN_SEL field.
	RTCIO_TOUCH_PAD_FUN_SEL_Pos = 0x11
	// Bit mask of FUN_SEL field.
	RTCIO_TOUCH_PAD_FUN_SEL_Msk = 0x60000
	// Position of MUX_SEL field.
	RTCIO_TOUCH_PAD_MUX_SEL_Pos = 0x13
	// Bit mask of MUX_SEL field.
	RTCIO_TOUCH_PAD_MUX_SEL_Msk = 0x80000
	// Bit MUX_SEL.
	RTCIO_TOUCH_PAD_MUX_SEL = 0x80000
	// Position of XPD field.
	RTCIO_TOUCH_PAD_XPD_Pos = 0x14
	// Bit mask of XPD field.
	RTCIO_TOUCH_PAD_XPD_Msk = 0x100000
	// Bit XPD.
	RTCIO_TOUCH_PAD_XPD = 0x100000
	// Position of TIE_OPT field.
	RTCIO_TOUCH_PAD_TIE_OPT_Pos = 0x15
	// Bit mask of TIE_OPT field.
	RTCIO_TOUCH_PAD_TIE_OPT_Msk = 0x200000
	// Bit TIE_OPT.
	RTCIO_TOUCH_PAD_TIE_OPT = 0x200000
	// Position of START field.
	RTCIO_TOUCH_PAD_START_Pos = 0x16
	// Bit mask of START field.
	RTCIO_TOUCH_PAD_START_Msk = 0x400000
	// Bit START.
	RTCIO_TOUCH_PAD_START = 0x400000
	// Position of DAC field.
	RTCIO_TOUCH_PAD_DAC_Pos = 0x17
	// Bit mask of DAC field.
	RTCIO_TOUCH_PAD_DAC_Msk = 0x3800000
	// Position of RUE field.
	RTCIO_TOUCH_PAD_RUE_Pos = 0x1b
	// Bit mask of RUE field.
	RTCIO_TOUCH_PAD_RUE_Msk = 0x8000000
	// Bit RUE.
	RTCIO_TOUCH_PAD_RUE = 0x8000000
	// Position of RDE field.
	RTCIO_TOUCH_PAD_RDE_Pos = 0x1c
	// Bit mask of RDE field.
	RTCIO_TOUCH_PAD_RDE_Msk = 0x10000000
	// Bit RDE.
	RTCIO_TOUCH_PAD_RDE = 0x10000000
	// Position of DRV field.
	RTCIO_TOUCH_PAD_DRV_Pos = 0x1d
	// Bit mask of DRV field.
	RTCIO_TOUCH_PAD_DRV_Msk = 0x60000000

	// XTAL_32P_PAD: 32KHz crystal P-pad configuration register
	// Position of X32P_FUN_IE field.
	RTCIO_XTAL_32P_PAD_X32P_FUN_IE_Pos = 0xd
	// Bit mask of X32P_FUN_IE field.
	RTCIO_XTAL_32P_PAD_X32P_FUN_IE_Msk = 0x2000
	// Bit X32P_FUN_IE.
	RTCIO_XTAL_32P_PAD_X32P_FUN_IE = 0x2000
	// Position of X32P_SLP_OE field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_OE_Pos = 0xe
	// Bit mask of X32P_SLP_OE field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_OE_Msk = 0x4000
	// Bit X32P_SLP_OE.
	RTCIO_XTAL_32P_PAD_X32P_SLP_OE = 0x4000
	// Position of X32P_SLP_IE field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_IE_Pos = 0xf
	// Bit mask of X32P_SLP_IE field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_IE_Msk = 0x8000
	// Bit X32P_SLP_IE.
	RTCIO_XTAL_32P_PAD_X32P_SLP_IE = 0x8000
	// Position of X32P_SLP_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_SEL_Pos = 0x10
	// Bit mask of X32P_SLP_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_SLP_SEL_Msk = 0x10000
	// Bit X32P_SLP_SEL.
	RTCIO_XTAL_32P_PAD_X32P_SLP_SEL = 0x10000
	// Position of X32P_FUN_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_FUN_SEL_Pos = 0x11
	// Bit mask of X32P_FUN_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_FUN_SEL_Msk = 0x60000
	// Position of X32P_MUX_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_MUX_SEL_Pos = 0x13
	// Bit mask of X32P_MUX_SEL field.
	RTCIO_XTAL_32P_PAD_X32P_MUX_SEL_Msk = 0x80000
	// Bit X32P_MUX_SEL.
	RTCIO_XTAL_32P_PAD_X32P_MUX_SEL = 0x80000
	// Position of X32P_RUE field.
	RTCIO_XTAL_32P_PAD_X32P_RUE_Pos = 0x1b
	// Bit mask of X32P_RUE field.
	RTCIO_XTAL_32P_PAD_X32P_RUE_Msk = 0x8000000
	// Bit X32P_RUE.
	RTCIO_XTAL_32P_PAD_X32P_RUE = 0x8000000
	// Position of X32P_RDE field.
	RTCIO_XTAL_32P_PAD_X32P_RDE_Pos = 0x1c
	// Bit mask of X32P_RDE field.
	RTCIO_XTAL_32P_PAD_X32P_RDE_Msk = 0x10000000
	// Bit X32P_RDE.
	RTCIO_XTAL_32P_PAD_X32P_RDE = 0x10000000
	// Position of X32P_DRV field.
	RTCIO_XTAL_32P_PAD_X32P_DRV_Pos = 0x1d
	// Bit mask of X32P_DRV field.
	RTCIO_XTAL_32P_PAD_X32P_DRV_Msk = 0x60000000

	// XTAL_32N_PAD: 32KHz crystal N-pad configuration register
	// Position of X32N_FUN_IE field.
	RTCIO_XTAL_32N_PAD_X32N_FUN_IE_Pos = 0xd
	// Bit mask of X32N_FUN_IE field.
	RTCIO_XTAL_32N_PAD_X32N_FUN_IE_Msk = 0x2000
	// Bit X32N_FUN_IE.
	RTCIO_XTAL_32N_PAD_X32N_FUN_IE = 0x2000
	// Position of X32N_SLP_OE field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_OE_Pos = 0xe
	// Bit mask of X32N_SLP_OE field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_OE_Msk = 0x4000
	// Bit X32N_SLP_OE.
	RTCIO_XTAL_32N_PAD_X32N_SLP_OE = 0x4000
	// Position of X32N_SLP_IE field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_IE_Pos = 0xf
	// Bit mask of X32N_SLP_IE field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_IE_Msk = 0x8000
	// Bit X32N_SLP_IE.
	RTCIO_XTAL_32N_PAD_X32N_SLP_IE = 0x8000
	// Position of X32N_SLP_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_SEL_Pos = 0x10
	// Bit mask of X32N_SLP_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_SLP_SEL_Msk = 0x10000
	// Bit X32N_SLP_SEL.
	RTCIO_XTAL_32N_PAD_X32N_SLP_SEL = 0x10000
	// Position of X32N_FUN_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_FUN_SEL_Pos = 0x11
	// Bit mask of X32N_FUN_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_FUN_SEL_Msk = 0x60000
	// Position of X32N_MUX_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_MUX_SEL_Pos = 0x13
	// Bit mask of X32N_MUX_SEL field.
	RTCIO_XTAL_32N_PAD_X32N_MUX_SEL_Msk = 0x80000
	// Bit X32N_MUX_SEL.
	RTCIO_XTAL_32N_PAD_X32N_MUX_SEL = 0x80000
	// Position of X32N_RUE field.
	RTCIO_XTAL_32N_PAD_X32N_RUE_Pos = 0x1b
	// Bit mask of X32N_RUE field.
	RTCIO_XTAL_32N_PAD_X32N_RUE_Msk = 0x8000000
	// Bit X32N_RUE.
	RTCIO_XTAL_32N_PAD_X32N_RUE = 0x8000000
	// Position of X32N_RDE field.
	RTCIO_XTAL_32N_PAD_X32N_RDE_Pos = 0x1c
	// Bit mask of X32N_RDE field.
	RTCIO_XTAL_32N_PAD_X32N_RDE_Msk = 0x10000000
	// Bit X32N_RDE.
	RTCIO_XTAL_32N_PAD_X32N_RDE = 0x10000000
	// Position of X32N_DRV field.
	RTCIO_XTAL_32N_PAD_X32N_DRV_Pos = 0x1d
	// Bit mask of X32N_DRV field.
	RTCIO_XTAL_32N_PAD_X32N_DRV_Msk = 0x60000000

	// PAD_DAC1: DAC1 configuration register
	// Position of PDAC1_DAC field.
	RTCIO_PAD_DAC1_PDAC1_DAC_Pos = 0x3
	// Bit mask of PDAC1_DAC field.
	RTCIO_PAD_DAC1_PDAC1_DAC_Msk = 0x7f8
	// Position of PDAC1_XPD_DAC field.
	RTCIO_PAD_DAC1_PDAC1_XPD_DAC_Pos = 0xb
	// Bit mask of PDAC1_XPD_DAC field.
	RTCIO_PAD_DAC1_PDAC1_XPD_DAC_Msk = 0x800
	// Bit PDAC1_XPD_DAC.
	RTCIO_PAD_DAC1_PDAC1_XPD_DAC = 0x800
	// Position of PDAC1_DAC_XPD_FORCE field.
	RTCIO_PAD_DAC1_PDAC1_DAC_XPD_FORCE_Pos = 0xc
	// Bit mask of PDAC1_DAC_XPD_FORCE field.
	RTCIO_PAD_DAC1_PDAC1_DAC_XPD_FORCE_Msk = 0x1000
	// Bit PDAC1_DAC_XPD_FORCE.
	RTCIO_PAD_DAC1_PDAC1_DAC_XPD_FORCE = 0x1000
	// Position of PDAC1_FUN_IE field.
	RTCIO_PAD_DAC1_PDAC1_FUN_IE_Pos = 0xd
	// Bit mask of PDAC1_FUN_IE field.
	RTCIO_PAD_DAC1_PDAC1_FUN_IE_Msk = 0x2000
	// Bit PDAC1_FUN_IE.
	RTCIO_PAD_DAC1_PDAC1_FUN_IE = 0x2000
	// Position of PDAC1_SLP_OE field.
	RTCIO_PAD_DAC1_PDAC1_SLP_OE_Pos = 0xe
	// Bit mask of PDAC1_SLP_OE field.
	RTCIO_PAD_DAC1_PDAC1_SLP_OE_Msk = 0x4000
	// Bit PDAC1_SLP_OE.
	RTCIO_PAD_DAC1_PDAC1_SLP_OE = 0x4000
	// Position of PDAC1_SLP_IE field.
	RTCIO_PAD_DAC1_PDAC1_SLP_IE_Pos = 0xf
	// Bit mask of PDAC1_SLP_IE field.
	RTCIO_PAD_DAC1_PDAC1_SLP_IE_Msk = 0x8000
	// Bit PDAC1_SLP_IE.
	RTCIO_PAD_DAC1_PDAC1_SLP_IE = 0x8000
	// Position of PDAC1_SLP_SEL field.
	RTCIO_PAD_DAC1_PDAC1_SLP_SEL_Pos = 0x10
	// Bit mask of PDAC1_SLP_SEL field.
	RTCIO_PAD_DAC1_PDAC1_SLP_SEL_Msk = 0x10000
	// Bit PDAC1_SLP_SEL.
	RTCIO_PAD_DAC1_PDAC1_SLP_SEL = 0x10000
	// Position of PDAC1_FUN_SEL field.
	RTCIO_PAD_DAC1_PDAC1_FUN_SEL_Pos = 0x11
	// Bit mask of PDAC1_FUN_SEL field.
	RTCIO_PAD_DAC1_PDAC1_FUN_SEL_Msk = 0x60000
	// Position of PDAC1_MUX_SEL field.
	RTCIO_PAD_DAC1_PDAC1_MUX_SEL_Pos = 0x13
	// Bit mask of PDAC1_MUX_SEL field.
	RTCIO_PAD_DAC1_PDAC1_MUX_SEL_Msk = 0x80000
	// Bit PDAC1_MUX_SEL.
	RTCIO_PAD_DAC1_PDAC1_MUX_SEL = 0x80000
	// Position of PDAC1_RUE field.
	RTCIO_PAD_DAC1_PDAC1_RUE_Pos = 0x1b
	// Bit mask of PDAC1_RUE field.
	RTCIO_PAD_DAC1_PDAC1_RUE_Msk = 0x8000000
	// Bit PDAC1_RUE.
	RTCIO_PAD_DAC1_PDAC1_RUE = 0x8000000
	// Position of PDAC1_RDE field.
	RTCIO_PAD_DAC1_PDAC1_RDE_Pos = 0x1c
	// Bit mask of PDAC1_RDE field.
	RTCIO_PAD_DAC1_PDAC1_RDE_Msk = 0x10000000
	// Bit PDAC1_RDE.
	RTCIO_PAD_DAC1_PDAC1_RDE = 0x10000000
	// Position of PDAC1_DRV field.
	RTCIO_PAD_DAC1_PDAC1_DRV_Pos = 0x1d
	// Bit mask of PDAC1_DRV field.
	RTCIO_PAD_DAC1_PDAC1_DRV_Msk = 0x60000000

	// PAD_DAC2: DAC2 configuration register
	// Position of PDAC2_DAC field.
	RTCIO_PAD_DAC2_PDAC2_DAC_Pos = 0x3
	// Bit mask of PDAC2_DAC field.
	RTCIO_PAD_DAC2_PDAC2_DAC_Msk = 0x7f8
	// Position of PDAC2_XPD_DAC field.
	RTCIO_PAD_DAC2_PDAC2_XPD_DAC_Pos = 0xb
	// Bit mask of PDAC2_XPD_DAC field.
	RTCIO_PAD_DAC2_PDAC2_XPD_DAC_Msk = 0x800
	// Bit PDAC2_XPD_DAC.
	RTCIO_PAD_DAC2_PDAC2_XPD_DAC = 0x800
	// Position of PDAC2_DAC_XPD_FORCE field.
	RTCIO_PAD_DAC2_PDAC2_DAC_XPD_FORCE_Pos = 0xc
	// Bit mask of PDAC2_DAC_XPD_FORCE field.
	RTCIO_PAD_DAC2_PDAC2_DAC_XPD_FORCE_Msk = 0x1000
	// Bit PDAC2_DAC_XPD_FORCE.
	RTCIO_PAD_DAC2_PDAC2_DAC_XPD_FORCE = 0x1000
	// Position of PDAC2_FUN_IE field.
	RTCIO_PAD_DAC2_PDAC2_FUN_IE_Pos = 0xd
	// Bit mask of PDAC2_FUN_IE field.
	RTCIO_PAD_DAC2_PDAC2_FUN_IE_Msk = 0x2000
	// Bit PDAC2_FUN_IE.
	RTCIO_PAD_DAC2_PDAC2_FUN_IE = 0x2000
	// Position of PDAC2_SLP_OE field.
	RTCIO_PAD_DAC2_PDAC2_SLP_OE_Pos = 0xe
	// Bit mask of PDAC2_SLP_OE field.
	RTCIO_PAD_DAC2_PDAC2_SLP_OE_Msk = 0x4000
	// Bit PDAC2_SLP_OE.
	RTCIO_PAD_DAC2_PDAC2_SLP_OE = 0x4000
	// Position of PDAC2_SLP_IE field.
	RTCIO_PAD_DAC2_PDAC2_SLP_IE_Pos = 0xf
	// Bit mask of PDAC2_SLP_IE field.
	RTCIO_PAD_DAC2_PDAC2_SLP_IE_Msk = 0x8000
	// Bit PDAC2_SLP_IE.
	RTCIO_PAD_DAC2_PDAC2_SLP_IE = 0x8000
	// Position of PDAC2_SLP_SEL field.
	RTCIO_PAD_DAC2_PDAC2_SLP_SEL_Pos = 0x10
	// Bit mask of PDAC2_SLP_SEL field.
	RTCIO_PAD_DAC2_PDAC2_SLP_SEL_Msk = 0x10000
	// Bit PDAC2_SLP_SEL.
	RTCIO_PAD_DAC2_PDAC2_SLP_SEL = 0x10000
	// Position of PDAC2_FUN_SEL field.
	RTCIO_PAD_DAC2_PDAC2_FUN_SEL_Pos = 0x11
	// Bit mask of PDAC2_FUN_SEL field.
	RTCIO_PAD_DAC2_PDAC2_FUN_SEL_Msk = 0x60000
	// Position of PDAC2_MUX_SEL field.
	RTCIO_PAD_DAC2_PDAC2_MUX_SEL_Pos = 0x13
	// Bit mask of PDAC2_MUX_SEL field.
	RTCIO_PAD_DAC2_PDAC2_MUX_SEL_Msk = 0x80000
	// Bit PDAC2_MUX_SEL.
	RTCIO_PAD_DAC2_PDAC2_MUX_SEL = 0x80000
	// Position of PDAC2_RUE field.
	RTCIO_PAD_DAC2_PDAC2_RUE_Pos = 0x1b
	// Bit mask of PDAC2_RUE field.
	RTCIO_PAD_DAC2_PDAC2_RUE_Msk = 0x8000000
	// Bit PDAC2_RUE.
	RTCIO_PAD_DAC2_PDAC2_RUE = 0x8000000
	// Position of PDAC2_RDE field.
	RTCIO_PAD_DAC2_PDAC2_RDE_Pos = 0x1c
	// Bit mask of PDAC2_RDE field.
	RTCIO_PAD_DAC2_PDAC2_RDE_Msk = 0x10000000
	// Bit PDAC2_RDE.
	RTCIO_PAD_DAC2_PDAC2_RDE = 0x10000000
	// Position of PDAC2_DRV field.
	RTCIO_PAD_DAC2_PDAC2_DRV_Pos = 0x1d
	// Bit mask of PDAC2_DRV field.
	RTCIO_PAD_DAC2_PDAC2_DRV_Msk = 0x60000000

	// RTC_PAD19: Touch pad 19 configuration register
	// Position of FUN_IE field.
	RTCIO_RTC_PAD19_FUN_IE_Pos = 0xd
	// Bit mask of FUN_IE field.
	RTCIO_RTC_PAD19_FUN_IE_Msk = 0x2000
	// Bit FUN_IE.
	RTCIO_RTC_PAD19_FUN_IE = 0x2000
	// Position of SLP_OE field.
	RTCIO_RTC_PAD19_SLP_OE_Pos = 0xe
	// Bit mask of SLP_OE field.
	RTCIO_RTC_PAD19_SLP_OE_Msk = 0x4000
	// Bit SLP_OE.
	RTCIO_RTC_PAD19_SLP_OE = 0x4000
	// Position of SLP_IE field.
	RTCIO_RTC_PAD19_SLP_IE_Pos = 0xf
	// Bit mask of SLP_IE field.
	RTCIO_RTC_PAD19_SLP_IE_Msk = 0x8000
	// Bit SLP_IE.
	RTCIO_RTC_PAD19_SLP_IE = 0x8000
	// Position of SLP_SEL field.
	RTCIO_RTC_PAD19_SLP_SEL_Pos = 0x10
	// Bit mask of SLP_SEL field.
	RTCIO_RTC_PAD19_SLP_SEL_Msk = 0x10000
	// Bit SLP_SEL.
	RTCIO_RTC_PAD19_SLP_SEL = 0x10000
	// Position of FUN_SEL field.
	RTCIO_RTC_PAD19_FUN_SEL_Pos = 0x11
	// Bit mask of FUN_SEL field.
	RTCIO_RTC_PAD19_FUN_SEL_Msk = 0x60000
	// Position of MUX_SEL field.
	RTCIO_RTC_PAD19_MUX_SEL_Pos = 0x13
	// Bit mask of MUX_SEL field.
	RTCIO_RTC_PAD19_MUX_SEL_Msk = 0x80000
	// Bit MUX_SEL.
	RTCIO_RTC_PAD19_MUX_SEL = 0x80000
	// Position of RUE field.
	RTCIO_RTC_PAD19_RUE_Pos = 0x1b
	// Bit mask of RUE field.
	RTCIO_RTC_PAD19_RUE_Msk = 0x8000000
	// Bit RUE.
	RTCIO_RTC_PAD19_RUE = 0x8000000
	// Position of RDE field.
	RTCIO_RTC_PAD19_RDE_Pos = 0x1c
	// Bit mask of RDE field.
	RTCIO_RTC_PAD19_RDE_Msk = 0x10000000
	// Bit RDE.
	RTCIO_RTC_PAD19_RDE = 0x10000000
	// Position of DRV field.
	RTCIO_RTC_PAD19_DRV_Pos = 0x1d
	// Bit mask of DRV field.
	RTCIO_RTC_PAD19_DRV_Msk = 0x60000000

	// RTC_PAD20: Touch pad 20 configuration register
	// Position of FUN_IE field.
	RTCIO_RTC_PAD20_FUN_IE_Pos = 0xd
	// Bit mask of FUN_IE field.
	RTCIO_RTC_PAD20_FUN_IE_Msk = 0x2000
	// Bit FUN_IE.
	RTCIO_RTC_PAD20_FUN_IE = 0x2000
	// Position of SLP_OE field.
	RTCIO_RTC_PAD20_SLP_OE_Pos = 0xe
	// Bit mask of SLP_OE field.
	RTCIO_RTC_PAD20_SLP_OE_Msk = 0x4000
	// Bit SLP_OE.
	RTCIO_RTC_PAD20_SLP_OE = 0x4000
	// Position of SLP_IE field.
	RTCIO_RTC_PAD20_SLP_IE_Pos = 0xf
	// Bit mask of SLP_IE field.
	RTCIO_RTC_PAD20_SLP_IE_Msk = 0x8000
	// Bit SLP_IE.
	RTCIO_RTC_PAD20_SLP_IE = 0x8000
	// Position of SLP_SEL field.
	RTCIO_RTC_PAD20_SLP_SEL_Pos = 0x10
	// Bit mask of SLP_SEL field.
	RTCIO_RTC_PAD20_SLP_SEL_Msk = 0x10000
	// Bit SLP_SEL.
	RTCIO_RTC_PAD20_SLP_SEL = 0x10000
	// Position of FUN_SEL field.
	RTCIO_RTC_PAD20_FUN_SEL_Pos = 0x11
	// Bit mask of FUN_SEL field.
	RTCIO_RTC_PAD20_FUN_SEL_Msk = 0x60000
	// Position of MUX_SEL field.
	RTCIO_RTC_PAD20_MUX_SEL_Pos = 0x13
	// Bit mask of MUX_SEL field.
	RTCIO_RTC_PAD20_MUX_SEL_Msk = 0x80000
	// Bit MUX_SEL.
	RTCIO_RTC_PAD20_MUX_SEL = 0x80000
	// Position of RUE field.
	RTCIO_RTC_PAD20_RUE_Pos = 0x1b
	// Bit mask of RUE field.
	RTCIO_RTC_PAD20_RUE_Msk = 0x8000000
	// Bit RUE.
	RTCIO_RTC_PAD20_RUE = 0x8000000
	// Position of RDE field.
	RTCIO_RTC_PAD20_RDE_Pos = 0x1c
	// Bit mask of RDE field.
	RTCIO_RTC_PAD20_RDE_Msk = 0x10000000
	// Bit RDE.
	RTCIO_RTC_PAD20_RDE = 0x10000000
	// Position of DRV field.
	RTCIO_RTC_PAD20_DRV_Pos = 0x1d
	// Bit mask of DRV field.
	RTCIO_RTC_PAD20_DRV_Msk = 0x60000000

	// RTC_PAD21: Touch pad 21 configuration register
	// Position of FUN_IE field.
	RTCIO_RTC_PAD21_FUN_IE_Pos = 0xd
	// Bit mask of FUN_IE field.
	RTCIO_RTC_PAD21_FUN_IE_Msk = 0x2000
	// Bit FUN_IE.
	RTCIO_RTC_PAD21_FUN_IE = 0x2000
	// Position of SLP_OE field.
	RTCIO_RTC_PAD21_SLP_OE_Pos = 0xe
	// Bit mask of SLP_OE field.
	RTCIO_RTC_PAD21_SLP_OE_Msk = 0x4000
	// Bit SLP_OE.
	RTCIO_RTC_PAD21_SLP_OE = 0x4000
	// Position of SLP_IE field.
	RTCIO_RTC_PAD21_SLP_IE_Pos = 0xf
	// Bit mask of SLP_IE field.
	RTCIO_RTC_PAD21_SLP_IE_Msk = 0x8000
	// Bit SLP_IE.
	RTCIO_RTC_PAD21_SLP_IE = 0x8000
	// Position of SLP_SEL field.
	RTCIO_RTC_PAD21_SLP_SEL_Pos = 0x10
	// Bit mask of SLP_SEL field.
	RTCIO_RTC_PAD21_SLP_SEL_Msk = 0x10000
	// Bit SLP_SEL.
	RTCIO_RTC_PAD21_SLP_SEL = 0x10000
	// Position of FUN_SEL field.
	RTCIO_RTC_PAD21_FUN_SEL_Pos = 0x11
	// Bit mask of FUN_SEL field.
	RTCIO_RTC_PAD21_FUN_SEL_Msk = 0x60000
	// Position of MUX_SEL field.
	RTCIO_RTC_PAD21_MUX_SEL_Pos = 0x13
	// Bit mask of MUX_SEL field.
	RTCIO_RTC_PAD21_MUX_SEL_Msk = 0x80000
	// Bit MUX_SEL.
	RTCIO_RTC_PAD21_MUX_SEL = 0x80000
	// Position of RUE field.
	RTCIO_RTC_PAD21_RUE_Pos = 0x1b
	// Bit mask of RUE field.
	RTCIO_RTC_PAD21_RUE_Msk = 0x8000000
	// Bit RUE.
	RTCIO_RTC_PAD21_RUE = 0x8000000
	// Position of RDE field.
	RTCIO_RTC_PAD21_RDE_Pos = 0x1c
	// Bit mask of RDE field.
	RTCIO_RTC_PAD21_RDE_Msk = 0x10000000
	// Bit RDE.
	RTCIO_RTC_PAD21_RDE = 0x10000000
	// Position of DRV field.
	RTCIO_RTC_PAD21_DRV_Pos = 0x1d
	// Bit mask of DRV field.
	RTCIO_RTC_PAD21_DRV_Msk = 0x60000000

	// EXT_WAKEUP0: External wake up configuration register
	// Position of SEL field.
	RTCIO_EXT_WAKEUP0_SEL_Pos = 0x1b
	// Bit mask of SEL field.
	RTCIO_EXT_WAKEUP0_SEL_Msk = 0xf8000000

	// XTL_EXT_CTR: Crystal power down enable GPIO source
	// Position of SEL field.
	RTCIO_XTL_EXT_CTR_SEL_Pos = 0x1b
	// Bit mask of SEL field.
	RTCIO_XTL_EXT_CTR_SEL_Msk = 0xf8000000

	// SAR_I2C_IO: RTC I2C pad selection
	// Position of SAR_DEBUG_BIT_SEL field.
	RTCIO_SAR_I2C_IO_SAR_DEBUG_BIT_SEL_Pos = 0x17
	// Bit mask of SAR_DEBUG_BIT_SEL field.
	RTCIO_SAR_I2C_IO_SAR_DEBUG_BIT_SEL_Msk = 0xf800000
	// Position of SAR_I2C_SCL_SEL field.
	RTCIO_SAR_I2C_IO_SAR_I2C_SCL_SEL_Pos = 0x1c
	// Bit mask of SAR_I2C_SCL_SEL field.
	RTCIO_SAR_I2C_IO_SAR_I2C_SCL_SEL_Msk = 0x30000000
	// Position of SAR_I2C_SDA_SEL field.
	RTCIO_SAR_I2C_IO_SAR_I2C_SDA_SEL_Pos = 0x1e
	// Bit mask of SAR_I2C_SDA_SEL field.
	RTCIO_SAR_I2C_IO_SAR_I2C_SDA_SEL_Msk = 0xc0000000

	// RTC_IO_TOUCH_CTRL: Touch control register
	// Position of IO_TOUCH_BUFSEL field.
	RTCIO_RTC_IO_TOUCH_CTRL_IO_TOUCH_BUFSEL_Pos = 0x0
	// Bit mask of IO_TOUCH_BUFSEL field.
	RTCIO_RTC_IO_TOUCH_CTRL_IO_TOUCH_BUFSEL_Msk = 0xf
	// Position of IO_TOUCH_BUFMODE field.
	RTCIO_RTC_IO_TOUCH_CTRL_IO_TOUCH_BUFMODE_Pos = 0x4
	// Bit mask of IO_TOUCH_BUFMODE field.
	RTCIO_RTC_IO_TOUCH_CTRL_IO_TOUCH_BUFMODE_Msk = 0x10
	// Bit IO_TOUCH_BUFMODE.
	RTCIO_RTC_IO_TOUCH_CTRL_IO_TOUCH_BUFMODE = 0x10

	// RTC_IO_DATE: Version control register
	// Position of IO_DATE field.
	RTCIO_RTC_IO_DATE_IO_DATE_Pos = 0x0
	// Bit mask of IO_DATE field.
	RTCIO_RTC_IO_DATE_IO_DATE_Msk = 0xfffffff
)

// Constants for RTC_CNTL: Real-Time Clock Control
const (
	// ULP_CP_TIMER: Configure coprocessor timer
	// Position of ULP_CP_PC_INIT field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_PC_INIT_Pos = 0x0
	// Bit mask of ULP_CP_PC_INIT field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_PC_INIT_Msk = 0x7ff
	// Position of ULP_CP_GPIO_WAKEUP_ENA field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_ENA_Pos = 0x1d
	// Bit mask of ULP_CP_GPIO_WAKEUP_ENA field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_ENA_Msk = 0x20000000
	// Bit ULP_CP_GPIO_WAKEUP_ENA.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_ENA = 0x20000000
	// Position of ULP_CP_GPIO_WAKEUP_CLR field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_CLR_Pos = 0x1e
	// Bit mask of ULP_CP_GPIO_WAKEUP_CLR field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_CLR_Msk = 0x40000000
	// Bit ULP_CP_GPIO_WAKEUP_CLR.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_GPIO_WAKEUP_CLR = 0x40000000
	// Position of ULP_CP_SLP_TIMER_EN field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_SLP_TIMER_EN_Pos = 0x1f
	// Bit mask of ULP_CP_SLP_TIMER_EN field.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_SLP_TIMER_EN_Msk = 0x80000000
	// Bit ULP_CP_SLP_TIMER_EN.
	RTC_CNTL_ULP_CP_TIMER_ULP_CP_SLP_TIMER_EN = 0x80000000

	// ULP_CP_CTRL: ULP-FSM configuration register
	// Position of ULP_CP_MEM_ADDR_INIT field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_ADDR_INIT_Pos = 0x0
	// Bit mask of ULP_CP_MEM_ADDR_INIT field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_ADDR_INIT_Msk = 0x7ff
	// Position of ULP_CP_MEM_ADDR_SIZE field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_ADDR_SIZE_Pos = 0xb
	// Bit mask of ULP_CP_MEM_ADDR_SIZE field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_ADDR_SIZE_Msk = 0x3ff800
	// Position of ULP_CP_MEM_OFFSET_CLR field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_OFFSET_CLR_Pos = 0x16
	// Bit mask of ULP_CP_MEM_OFFSET_CLR field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_OFFSET_CLR_Msk = 0x400000
	// Bit ULP_CP_MEM_OFFSET_CLR.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_MEM_OFFSET_CLR = 0x400000
	// Position of ULP_CP_CLK_FO field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_CLK_FO_Pos = 0x1c
	// Bit mask of ULP_CP_CLK_FO field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_CLK_FO_Msk = 0x10000000
	// Bit ULP_CP_CLK_FO.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_CLK_FO = 0x10000000
	// Position of ULP_CP_RESET field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_RESET_Pos = 0x1d
	// Bit mask of ULP_CP_RESET field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_RESET_Msk = 0x20000000
	// Bit ULP_CP_RESET.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_RESET = 0x20000000
	// Position of ULP_CP_FORCE_START_TOP field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_FORCE_START_TOP_Pos = 0x1e
	// Bit mask of ULP_CP_FORCE_START_TOP field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_FORCE_START_TOP_Msk = 0x40000000
	// Bit ULP_CP_FORCE_START_TOP.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_FORCE_START_TOP = 0x40000000
	// Position of ULP_CP_START_TOP field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_START_TOP_Pos = 0x1f
	// Bit mask of ULP_CP_START_TOP field.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_START_TOP_Msk = 0x80000000
	// Bit ULP_CP_START_TOP.
	RTC_CNTL_ULP_CP_CTRL_ULP_CP_START_TOP = 0x80000000

	// COCPU_CTRL: ULP-RISCV configuration register
	// Position of COCPU_CLK_FO field.
	RTC_CNTL_COCPU_CTRL_COCPU_CLK_FO_Pos = 0x0
	// Bit mask of COCPU_CLK_FO field.
	RTC_CNTL_COCPU_CTRL_COCPU_CLK_FO_Msk = 0x1
	// Bit COCPU_CLK_FO.
	RTC_CNTL_COCPU_CTRL_COCPU_CLK_FO = 0x1
	// Position of COCPU_START_2_RESET_DIS field.
	RTC_CNTL_COCPU_CTRL_COCPU_START_2_RESET_DIS_Pos = 0x1
	// Bit mask of COCPU_START_2_RESET_DIS field.
	RTC_CNTL_COCPU_CTRL_COCPU_START_2_RESET_DIS_Msk = 0x7e
	// Position of COCPU_START_2_INTR_EN field.
	RTC_CNTL_COCPU_CTRL_COCPU_START_2_INTR_EN_Pos = 0x7
	// Bit mask of COCPU_START_2_INTR_EN field.
	RTC_CNTL_COCPU_CTRL_COCPU_START_2_INTR_EN_Msk = 0x1f80
	// Position of COCPU_SHUT field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_Pos = 0xd
	// Bit mask of COCPU_SHUT field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_Msk = 0x2000
	// Bit COCPU_SHUT.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT = 0x2000
	// Position of COCPU_SHUT_2_CLK_DIS field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_2_CLK_DIS_Pos = 0xe
	// Bit mask of COCPU_SHUT_2_CLK_DIS field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_2_CLK_DIS_Msk = 0x3fc000
	// Position of COCPU_SHUT_RESET_EN field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_RESET_EN_Pos = 0x16
	// Bit mask of COCPU_SHUT_RESET_EN field.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_RESET_EN_Msk = 0x400000
	// Bit COCPU_SHUT_RESET_EN.
	RTC_CNTL_COCPU_CTRL_COCPU_SHUT_RESET_EN = 0x400000
	// Position of COCPU_SEL field.
	RTC_CNTL_COCPU_CTRL_COCPU_SEL_Pos = 0x17
	// Bit mask of COCPU_SEL field.
	RTC_CNTL_COCPU_CTRL_COCPU_SEL_Msk = 0x800000
	// Bit COCPU_SEL.
	RTC_CNTL_COCPU_CTRL_COCPU_SEL = 0x800000
	// Position of COCPU_DONE_FORCE field.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE_FORCE_Pos = 0x18
	// Bit mask of COCPU_DONE_FORCE field.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE_FORCE_Msk = 0x1000000
	// Bit COCPU_DONE_FORCE.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE_FORCE = 0x1000000
	// Position of COCPU_DONE field.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE_Pos = 0x19
	// Bit mask of COCPU_DONE field.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE_Msk = 0x2000000
	// Bit COCPU_DONE.
	RTC_CNTL_COCPU_CTRL_COCPU_DONE = 0x2000000
	// Position of COCPU_SW_INT_TRIGGER field.
	RTC_CNTL_COCPU_CTRL_COCPU_SW_INT_TRIGGER_Pos = 0x1a
	// Bit mask of COCPU_SW_INT_TRIGGER field.
	RTC_CNTL_COCPU_CTRL_COCPU_SW_INT_TRIGGER_Msk = 0x4000000
	// Bit COCPU_SW_INT_TRIGGER.
	RTC_CNTL_COCPU_CTRL_COCPU_SW_INT_TRIGGER = 0x4000000

	// ULP_CP_TIMER_1: Configure sleep cycle of the timer
	// Position of ULP_CP_TIMER_SLP_CYCLE field.
	RTC_CNTL_ULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE_Pos = 0x8
	// Bit mask of ULP_CP_TIMER_SLP_CYCLE field.
	RTC_CNTL_ULP_CP_TIMER_1_ULP_CP_TIMER_SLP_CYCLE_Msk = 0xffffff00
)

// Constants for RTC_I2C: Low-power I2C (Inter-Integrated Circuit) Controller
const (
	// SCL_LOW: Configure the low level width of SCL
	// Position of PERIOD field.
	RTC_I2C_SCL_LOW_PERIOD_Pos = 0x0
	// Bit mask of PERIOD field.
	RTC_I2C_SCL_LOW_PERIOD_Msk = 0xfffff

	// CTRL: Transmission setting
	// Position of SDA_FORCE_OUT field.
	RTC_I2C_CTRL_SDA_FORCE_OUT_Pos = 0x0
	// Bit mask of SDA_FORCE_OUT field.
	RTC_I2C_CTRL_SDA_FORCE_OUT_Msk = 0x1
	// Bit SDA_FORCE_OUT.
	RTC_I2C_CTRL_SDA_FORCE_OUT = 0x1
	// Position of SCL_FORCE_OUT field.
	RTC_I2C_CTRL_SCL_FORCE_OUT_Pos = 0x1
	// Bit mask of SCL_FORCE_OUT field.
	RTC_I2C_CTRL_SCL_FORCE_OUT_Msk = 0x2
	// Bit SCL_FORCE_OUT.
	RTC_I2C_CTRL_SCL_FORCE_OUT = 0x2
	// Position of MS_MODE field.
	RTC_I2C_CTRL_MS_MODE_Pos = 0x2
	// Bit mask of MS_MODE field.
	RTC_I2C_CTRL_MS_MODE_Msk = 0x4
	// Bit MS_MODE.
	RTC_I2C_CTRL_MS_MODE = 0x4
	// Position of TRANS_START field.
	RTC_I2C_CTRL_TRANS_START_Pos = 0x3
	// Bit mask of TRANS_START field.
	RTC_I2C_CTRL_TRANS_START_Msk = 0x8
	// Bit TRANS_START.
	RTC_I2C_CTRL_TRANS_START = 0x8
	// Position of TX_LSB_FIRST field.
	RTC_I2C_CTRL_TX_LSB_FIRST_Pos = 0x4
	// Bit mask of TX_LSB_FIRST field.
	RTC_I2C_CTRL_TX_LSB_FIRST_Msk = 0x10
	// Bit TX_LSB_FIRST.
	RTC_I2C_CTRL_TX_LSB_FIRST = 0x10
	// Position of RX_LSB_FIRST field.
	RTC_I2C_CTRL_RX_LSB_FIRST_Pos = 0x5
	// Bit mask of RX_LSB_FIRST field.
	RTC_I2C_CTRL_RX_LSB_FIRST_Msk = 0x20
	// Bit RX_LSB_FIRST.
	RTC_I2C_CTRL_RX_LSB_FIRST = 0x20
	// Position of CLK_GATE_EN field.
	RTC_I2C_CTRL_CLK_GATE_EN_Pos = 0x1d
	// Bit mask of CLK_GATE_EN field.
	RTC_I2C_CTRL_CLK_GATE_EN_Msk = 0x20000000
	// Bit CLK_GATE_EN.
	RTC_I2C_CTRL_CLK_GATE_EN = 0x20000000
	// Position of RESET field.
	RTC_I2C_CTRL_RESET_Pos = 0x1e
	// Bit mask of RESET field.
	RTC_I2C_CTRL_RESET_Msk = 0x40000000
	// Bit RESET.
	RTC_I2C_CTRL_RESET = 0x40000000
	// Position of CLK_EN field.
	RTC_I2C_CTRL_CLK_EN_Pos = 0x1f
	// Bit mask of CLK_EN field.
	RTC_I2C_CTRL_CLK_EN_Msk = 0x80000000
	// Bit CLK_EN.
	RTC_I2C_CTRL_CLK_EN = 0x80000000

	// STATUS: RTC I2C status
	// Position of ACK_REC field.
	RTC_I2C_STATUS_ACK_REC_Pos = 0x0
	// Bit mask of ACK_REC field.
	RTC_I2C_STATUS_ACK_REC_Msk = 0x1
	// Bit ACK_REC.
	RTC_I2C_STATUS_ACK_REC = 0x1
	// Position of SLAVE_RW field.
	RTC_I2C_STATUS_SLAVE_RW_Pos = 0x1
	// Bit mask of SLAVE_RW field.
	RTC_I2C_STATUS_SLAVE_RW_Msk = 0x2
	// Bit SLAVE_RW.
	RTC_I2C_STATUS_SLAVE_RW = 0x2
	// Position of ARB_LOST field.
	RTC_I2C_STATUS_ARB_LOST_Pos = 0x2
	// Bit mask of ARB_LOST field.
	RTC_I2C_STATUS_ARB_LOST_Msk = 0x4
	// Bit ARB_LOST.
	RTC_I2C_STATUS_ARB_LOST = 0x4
	// Position of BUS_BUSY field.
	RTC_I2C_STATUS_BUS_BUSY_Pos = 0x3
	// Bit mask of BUS_BUSY field.
	RTC_I2C_STATUS_BUS_BUSY_Msk = 0x8
	// Bit BUS_BUSY.
	RTC_I2C_STATUS_BUS_BUSY = 0x8
	// Position of SLAVE_ADDRESSED field.
	RTC_I2C_STATUS_SLAVE_ADDRESSED_Pos = 0x4
	// Bit mask of SLAVE_ADDRESSED field.
	RTC_I2C_STATUS_SLAVE_ADDRESSED_Msk = 0x10
	// Bit SLAVE_ADDRESSED.
	RTC_I2C_STATUS_SLAVE_ADDRESSED = 0x10
	// Position of BYTE_TRANS field.
	RTC_I2C_STATUS_BYTE_TRANS_Pos = 0x5
	// Bit mask of BYTE_TRANS field.
	RTC_I2C_STATUS_BYTE_TRANS_Msk = 0x20
	// Bit BYTE_TRANS.
	RTC_I2C_STATUS_BYTE_TRANS = 0x20
	// Position of OP_CNT field.
	RTC_I2C_STATUS_OP_CNT_Pos = 0x6
	// Bit mask of OP_CNT field.
	RTC_I2C_STATUS_OP_CNT_Msk = 0xc0
	// Position of SHIFT field.
	RTC_I2C_STATUS_SHIFT_Pos = 0x10
	// Bit mask of SHIFT field.
	RTC_I2C_STATUS_SHIFT_Msk = 0xff0000
	// Position of SCL_MAIN_STATE_LAST field.
	RTC_I2C_STATUS_SCL_MAIN_STATE_LAST_Pos = 0x18
	// Bit mask of SCL_MAIN_STATE_LAST field.
	RTC_I2C_STATUS_SCL_MAIN_STATE_LAST_Msk = 0x7000000
	// Position of SCL_STATE_LAST field.
	RTC_I2C_STATUS_SCL_STATE_LAST_Pos = 0x1c
	// Bit mask of SCL_STATE_LAST field.
	RTC_I2C_STATUS_SCL_STATE_LAST_Msk = 0x70000000

	// TO: Configure RTC I2C timeout
	// Position of TIME_OUT field.
	RTC_I2C_TO_TIME_OUT_Pos = 0x0
	// Bit mask of TIME_OUT field.
	RTC_I2C_TO_TIME_OUT_Msk = 0xfffff

	// SLAVE_ADDR: Configure slave address
	// Position of SLAVE_ADDR field.
	RTC_I2C_SLAVE_ADDR_SLAVE_ADDR_Pos = 0x0
	// Bit mask of SLAVE_ADDR field.
	RTC_I2C_SLAVE_ADDR_SLAVE_ADDR_Msk = 0x7fff
	// Position of ADDR_10BIT_EN field.
	RTC_I2C_SLAVE_ADDR_ADDR_10BIT_EN_Pos = 0x1f
	// Bit mask of ADDR_10BIT_EN field.
	RTC_I2C_SLAVE_ADDR_ADDR_10BIT_EN_Msk = 0x80000000
	// Bit ADDR_10BIT_EN.
	RTC_I2C_SLAVE_ADDR_ADDR_10BIT_EN = 0x80000000

	// SCL_HIGH: Configure the high level width of SCL
	// Position of PERIOD field.
	RTC_I2C_SCL_HIGH_PERIOD_Pos = 0x0
	// Bit mask of PERIOD field.
	RTC_I2C_SCL_HIGH_PERIOD_Msk = 0xfffff

	// SDA_DUTY: Configure the SDA hold time after a negative SCL edge
	// Position of NUM field.
	RTC_I2C_SDA_DUTY_NUM_Pos = 0x0
	// Bit mask of NUM field.
	RTC_I2C_SDA_DUTY_NUM_Msk = 0xfffff

	// SCL_START_PERIOD: Configure the delay between the SDA and SCL negative edge for a start condition
	// Position of SCL_START_PERIOD field.
	RTC_I2C_SCL_START_PERIOD_SCL_START_PERIOD_Pos = 0x0
	// Bit mask of SCL_START_PERIOD field.
	RTC_I2C_SCL_START_PERIOD_SCL_START_PERIOD_Msk = 0xfffff

	// SCL_STOP_PERIOD: Configure the delay between SDA and SCL positive edge for a stop condition
	// Position of SCL_STOP_PERIOD field.
	RTC_I2C_SCL_STOP_PERIOD_SCL_STOP_PERIOD_Pos = 0x0
	// Bit mask of SCL_STOP_PERIOD field.
	RTC_I2C_SCL_STOP_PERIOD_SCL_STOP_PERIOD_Msk = 0xfffff

	// INT_CLR: Clear RTC I2C interrupt
	// Position of SLAVE_TRAN_COMP_INT_CLR field.
	RTC_I2C_INT_CLR_SLAVE_TRAN_COMP_INT_CLR_Pos = 0x0
	// Bit mask of SLAVE_TRAN_COMP_INT_CLR field.
	RTC_I2C_INT_CLR_SLAVE_TRAN_COMP_INT_CLR_Msk = 0x1
	// Bit SLAVE_TRAN_COMP_INT_CLR.
	RTC_I2C_INT_CLR_SLAVE_TRAN_COMP_INT_CLR = 0x1
	// Position of ARBITRATION_LOST_INT_CLR field.
	RTC_I2C_INT_CLR_ARBITRATION_LOST_INT_CLR_Pos = 0x1
	// Bit mask of ARBITRATION_LOST_INT_CLR field.
	RTC_I2C_INT_CLR_ARBITRATION_LOST_INT_CLR_Msk = 0x2
	// Bit ARBITRATION_LOST_INT_CLR.
	RTC_I2C_INT_CLR_ARBITRATION_LOST_INT_CLR = 0x2
	// Position of MASTER_TRAN_COMP_INT_CLR field.
	RTC_I2C_INT_CLR_MASTER_TRAN_COMP_INT_CLR_Pos = 0x2
	// Bit mask of MASTER_TRAN_COMP_INT_CLR field.
	RTC_I2C_INT_CLR_MASTER_TRAN_COMP_INT_CLR_Msk = 0x4
	// Bit MASTER_TRAN_COMP_INT_CLR.
	RTC_I2C_INT_CLR_MASTER_TRAN_COMP_INT_CLR = 0x4
	// Position of TRANS_COMPLETE_INT_CLR field.
	RTC_I2C_INT_CLR_TRANS_COMPLETE_INT_CLR_Pos = 0x3
	// Bit mask of TRANS_COMPLETE_INT_CLR field.
	RTC_I2C_INT_CLR_TRANS_COMPLETE_INT_CLR_Msk = 0x8
	// Bit TRANS_COMPLETE_INT_CLR.
	RTC_I2C_INT_CLR_TRANS_COMPLETE_INT_CLR = 0x8
	// Position of TIME_OUT_INT_CLR field.
	RTC_I2C_INT_CLR_TIME_OUT_INT_CLR_Pos = 0x4
	// Bit mask of TIME_OUT_INT_CLR field.
	RTC_I2C_INT_CLR_TIME_OUT_INT_CLR_Msk = 0x10
	// Bit TIME_OUT_INT_CLR.
	RTC_I2C_INT_CLR_TIME_OUT_INT_CLR = 0x10
	// Position of ACK_ERR_INT_CLR field.
	RTC_I2C_INT_CLR_ACK_ERR_INT_CLR_Pos = 0x5
	// Bit mask of ACK_ERR_INT_CLR field.
	RTC_I2C_INT_CLR_ACK_ERR_INT_CLR_Msk = 0x20
	// Bit ACK_ERR_INT_CLR.
	RTC_I2C_INT_CLR_ACK_ERR_INT_CLR = 0x20
	// Position of RX_DATA_INT_CLR field.
	RTC_I2C_INT_CLR_RX_DATA_INT_CLR_Pos = 0x6
	// Bit mask of RX_DATA_INT_CLR field.
	RTC_I2C_INT_CLR_RX_DATA_INT_CLR_Msk = 0x40
	// Bit RX_DATA_INT_CLR.
	RTC_I2C_INT_CLR_RX_DATA_INT_CLR = 0x40
	// Position of TX_DATA_INT_CLR field.
	RTC_I2C_INT_CLR_TX_DATA_INT_CLR_Pos = 0x7
	// Bit mask of TX_DATA_INT_CLR field.
	RTC_I2C_INT_CLR_TX_DATA_INT_CLR_Msk = 0x80
	// Bit TX_DATA_INT_CLR.
	RTC_I2C_INT_CLR_TX_DATA_INT_CLR = 0x80
	// Position of DETECT_START_INT_CLR field.
	RTC_I2C_INT_CLR_DETECT_START_INT_CLR_Pos = 0x8
	// Bit mask of DETECT_START_INT_CLR field.
	RTC_I2C_INT_CLR_DETECT_START_INT_CLR_Msk = 0x100
	// Bit DETECT_START_INT_CLR.
	RTC_I2C_INT_CLR_DETECT_START_INT_CLR = 0x100

	// INT_RAW: RTC I2C raw interrupt
	// Position of SLAVE_TRAN_COMP_INT_RAW field.
	RTC_I2C_INT_RAW_SLAVE_TRAN_COMP_INT_RAW_Pos = 0x0
	// Bit mask of SLAVE_TRAN_COMP_INT_RAW field.
	RTC_I2C_INT_RAW_SLAVE_TRAN_COMP_INT_RAW_Msk = 0x1
	// Bit SLAVE_TRAN_COMP_INT_RAW.
	RTC_I2C_INT_RAW_SLAVE_TRAN_COMP_INT_RAW = 0x1
	// Position of ARBITRATION_LOST_INT_RAW field.
	RTC_I2C_INT_RAW_ARBITRATION_LOST_INT_RAW_Pos = 0x1
	// Bit mask of ARBITRATION_LOST_INT_RAW field.
	RTC_I2C_INT_RAW_ARBITRATION_LOST_INT_RAW_Msk = 0x2
	// Bit ARBITRATION_LOST_INT_RAW.
	RTC_I2C_INT_RAW_ARBITRATION_LOST_INT_RAW = 0x2
	// Position of MASTER_TRAN_COMP_INT_RAW field.
	RTC_I2C_INT_RAW_MASTER_TRAN_COMP_INT_RAW_Pos = 0x2
	// Bit mask of MASTER_TRAN_COMP_INT_RAW field.
	RTC_I2C_INT_RAW_MASTER_TRAN_COMP_INT_RAW_Msk = 0x4
	// Bit MASTER_TRAN_COMP_INT_RAW.
	RTC_I2C_INT_RAW_MASTER_TRAN_COMP_INT_RAW = 0x4
	// Position of TRANS_COMPLETE_INT_RAW field.
	RTC_I2C_INT_RAW_TRANS_COMPLETE_INT_RAW_Pos = 0x3
	// Bit mask of TRANS_COMPLETE_INT_RAW field.
	RTC_I2C_INT_RAW_TRANS_COMPLETE_INT_RAW_Msk = 0x8
	// Bit TRANS_COMPLETE_INT_RAW.
	RTC_I2C_INT_RAW_TRANS_COMPLETE_INT_RAW = 0x8
	// Position of TIME_OUT_INT_RAW field.
	RTC_I2C_INT_RAW_TIME_OUT_INT_RAW_Pos = 0x4
	// Bit mask of TIME_OUT_INT_RAW field.
	RTC_I2C_INT_RAW_TIME_OUT_INT_RAW_Msk = 0x10
	// Bit TIME_OUT_INT_RAW.
	RTC_I2C_INT_RAW_TIME_OUT_INT_RAW = 0x10
	// Position of ACK_ERR_INT_RAW field.
	RTC_I2C_INT_RAW_ACK_ERR_INT_RAW_Pos = 0x5
	// Bit mask of ACK_ERR_INT_RAW field.
	RTC_I2C_INT_RAW_ACK_ERR_INT_RAW_Msk = 0x20
	// Bit ACK_ERR_INT_RAW.
	RTC_I2C_INT_RAW_ACK_ERR_INT_RAW = 0x20
	// Position of RX_DATA_INT_RAW field.
	RTC_I2C_INT_RAW_RX_DATA_INT_RAW_Pos = 0x6
	// Bit mask of RX_DATA_INT_RAW field.
	RTC_I2C_INT_RAW_RX_DATA_INT_RAW_Msk = 0x40
	// Bit RX_DATA_INT_RAW.
	RTC_I2C_INT_RAW_RX_DATA_INT_RAW = 0x40
	// Position of TX_DATA_INT_RAW field.
	RTC_I2C_INT_RAW_TX_DATA_INT_RAW_Pos = 0x7
	// Bit mask of TX_DATA_INT_RAW field.
	RTC_I2C_INT_RAW_TX_DATA_INT_RAW_Msk = 0x80
	// Bit TX_DATA_INT_RAW.
	RTC_I2C_INT_RAW_TX_DATA_INT_RAW = 0x80
	// Position of DETECT_START_INT_RAW field.
	RTC_I2C_INT_RAW_DETECT_START_INT_RAW_Pos = 0x8
	// Bit mask of DETECT_START_INT_RAW field.
	RTC_I2C_INT_RAW_DETECT_START_INT_RAW_Msk = 0x100
	// Bit DETECT_START_INT_RAW.
	RTC_I2C_INT_RAW_DETECT_START_INT_RAW = 0x100

	// INT_ST: RTC I2C interrupt status
	// Position of SLAVE_TRAN_COMP_INT_ST field.
	RTC_I2C_INT_ST_SLAVE_TRAN_COMP_INT_ST_Pos = 0x0
	// Bit mask of SLAVE_TRAN_COMP_INT_ST field.
	RTC_I2C_INT_ST_SLAVE_TRAN_COMP_INT_ST_Msk = 0x1
	// Bit SLAVE_TRAN_COMP_INT_ST.
	RTC_I2C_INT_ST_SLAVE_TRAN_COMP_INT_ST = 0x1
	// Position of ARBITRATION_LOST_INT_ST field.
	RTC_I2C_INT_ST_ARBITRATION_LOST_INT_ST_Pos = 0x1
	// Bit mask of ARBITRATION_LOST_INT_ST field.
	RTC_I2C_INT_ST_ARBITRATION_LOST_INT_ST_Msk = 0x2
	// Bit ARBITRATION_LOST_INT_ST.
	RTC_I2C_INT_ST_ARBITRATION_LOST_INT_ST = 0x2
	// Position of MASTER_TRAN_COMP_INT_ST field.
	RTC_I2C_INT_ST_MASTER_TRAN_COMP_INT_ST_Pos = 0x2
	// Bit mask of MASTER_TRAN_COMP_INT_ST field.
	RTC_I2C_INT_ST_MASTER_TRAN_COMP_INT_ST_Msk = 0x4
	// Bit MASTER_TRAN_COMP_INT_ST.
	RTC_I2C_INT_ST_MASTER_TRAN_COMP_INT_ST = 0x4
	// Position of TRANS_COMPLETE_INT_ST field.
	RTC_I2C_INT_ST_TRANS_COMPLETE_INT_ST_Pos = 0x3
	// Bit mask of TRANS_COMPLETE_INT_ST field.
	RTC_I2C_INT_ST_TRANS_COMPLETE_INT_ST_Msk = 0x8
	// Bit TRANS_COMPLETE_INT_ST.
	RTC_I2C_INT_ST_TRANS_COMPLETE_INT_ST = 0x8
	// Position of TIME_OUT_INT_ST field.
	RTC_I2C_INT_ST_TIME_OUT_INT_ST_Pos = 0x4
	// Bit mask of TIME_OUT_INT_ST field.
	RTC_I2C_INT_ST_TIME_OUT_INT_ST_Msk = 0x10
	// Bit TIME_OUT_INT_ST.
	RTC_I2C_INT_ST_TIME_OUT_INT_ST = 0x10
	// Position of ACK_ERR_INT_ST field.
	RTC_I2C_INT_ST_ACK_ERR_INT_ST_Pos = 0x5
	// Bit mask of ACK_ERR_INT_ST field.
	RTC_I2C_INT_ST_ACK_ERR_INT_ST_Msk = 0x20
	// Bit ACK_ERR_INT_ST.
	RTC_I2C_INT_ST_ACK_ERR_INT_ST = 0x20
	// Position of RX_DATA_INT_ST field.
	RTC_I2C_INT_ST_RX_DATA_INT_ST_Pos = 0x6
	// Bit mask of RX_DATA_INT_ST field.
	RTC_I2C_INT_ST_RX_DATA_INT_ST_Msk = 0x40
	// Bit RX_DATA_INT_ST.
	RTC_I2C_INT_ST_RX_DATA_INT_ST = 0x40
	// Position of TX_DATA_INT_ST field.
	RTC_I2C_INT_ST_TX_DATA_INT_ST_Pos = 0x7
	// Bit mask of TX_DATA_INT_ST field.
	RTC_I2C_INT_ST_TX_DATA_INT_ST_Msk = 0x80
	// Bit TX_DATA_INT_ST.
	RTC_I2C_INT_ST_TX_DATA_INT_ST = 0x80
	// Position of DETECT_START_INT_ST field.
	RTC_I2C_INT_ST_DETECT_START_INT_ST_Pos = 0x8
	// Bit mask of DETECT_START_INT_ST field.
	RTC_I2C_INT_ST_DETECT_START_INT_ST_Msk = 0x100
	// Bit DETECT_START_INT_ST.
	RTC_I2C_INT_ST_DETECT_START_INT_ST = 0x100

	// INT_ENA: Enable RTC I2C interrupt
	// Position of SLAVE_TRAN_COMP_INT_ENA field.
	RTC_I2C_INT_ENA_SLAVE_TRAN_COMP_INT_ENA_Pos = 0x0
	// Bit mask of SLAVE_TRAN_COMP_INT_ENA field.
	RTC_I2C_INT_ENA_SLAVE_TRAN_COMP_INT_ENA_Msk = 0x1
	// Bit SLAVE_TRAN_COMP_INT_ENA.
	RTC_I2C_INT_ENA_SLAVE_TRAN_COMP_INT_ENA = 0x1
	// Position of ARBITRATION_LOST_INT_ENA field.
	RTC_I2C_INT_ENA_ARBITRATION_LOST_INT_ENA_Pos = 0x1
	// Bit mask of ARBITRATION_LOST_INT_ENA field.
	RTC_I2C_INT_ENA_ARBITRATION_LOST_INT_ENA_Msk = 0x2
	// Bit ARBITRATION_LOST_INT_ENA.
	RTC_I2C_INT_ENA_ARBITRATION_LOST_INT_ENA = 0x2
	// Position of MASTER_TRAN_COMP_INT_ENA field.
	RTC_I2C_INT_ENA_MASTER_TRAN_COMP_INT_ENA_Pos = 0x2
	// Bit mask of MASTER_TRAN_COMP_INT_ENA field.
	RTC_I2C_INT_ENA_MASTER_TRAN_COMP_INT_ENA_Msk = 0x4
	// Bit MASTER_TRAN_COMP_INT_ENA.
	RTC_I2C_INT_ENA_MASTER_TRAN_COMP_INT_ENA = 0x4
	// Position of TRANS_COMPLETE_INT_ENA field.
	RTC_I2C_INT_ENA_TRANS_COMPLETE_INT_ENA_Pos = 0x3
	// Bit mask of TRANS_COMPLETE_INT_ENA field.
	RTC_I2C_INT_ENA_TRANS_COMPLETE_INT_ENA_Msk = 0x8
	// Bit TRANS_COMPLETE_INT_ENA.
	RTC_I2C_INT_ENA_TRANS_COMPLETE_INT_ENA = 0x8
	// Position of TIME_OUT_INT_ENA field.
	RTC_I2C_INT_ENA_TIME_OUT_INT_ENA_Pos = 0x4
	// Bit mask of TIME_OUT_INT_ENA field.
	RTC_I2C_INT_ENA_TIME_OUT_INT_ENA_Msk = 0x10
	// Bit TIME_OUT_INT_ENA.
	RTC_I2C_INT_ENA_TIME_OUT_INT_ENA = 0x10
	// Position of ACK_ERR_INT_ENA field.
	RTC_I2C_INT_ENA_ACK_ERR_INT_ENA_Pos = 0x5
	// Bit mask of ACK_ERR_INT_ENA field.
	RTC_I2C_INT_ENA_ACK_ERR_INT_ENA_Msk = 0x20
	// Bit ACK_ERR_INT_ENA.
	RTC_I2C_INT_ENA_ACK_ERR_INT_ENA = 0x20
	// Position of RX_DATA_INT_ENA field.
	RTC_I2C_INT_ENA_RX_DATA_INT_ENA_Pos = 0x6
	// Bit mask of RX_DATA_INT_ENA field.
	RTC_I2C_INT_ENA_RX_DATA_INT_ENA_Msk = 0x40
	// Bit RX_DATA_INT_ENA.
	RTC_I2C_INT_ENA_RX_DATA_INT_ENA = 0x40
	// Position of TX_DATA_INT_ENA field.
	RTC_I2C_INT_ENA_TX_DATA_INT_ENA_Pos = 0x7
	// Bit mask of TX_DATA_INT_ENA field.
	RTC_I2C_INT_ENA_TX_DATA_INT_ENA_Msk = 0x80
	// Bit TX_DATA_INT_ENA.
	RTC_I2C_INT_ENA_TX_DATA_INT_ENA = 0x80
	// Position of DETECT_START_INT_ENA field.
	RTC_I2C_INT_ENA_DETECT_START_INT_ENA_Pos = 0x8
	// Bit mask of DETECT_START_INT_ENA field.
	RTC_I2C_INT_ENA_DETECT_START_INT_ENA_Msk = 0x100
	// Bit DETECT_START_INT_ENA.
	RTC_I2C_INT_ENA_DETECT_START_INT_ENA = 0x100

	// DATA: RTC I2C read data
	// Position of RDATA field.
	RTC_I2C_DATA_RDATA_Pos = 0x0
	// Bit mask of RDATA field.
	RTC_I2C_DATA_RDATA_Msk = 0xff
	// Position of SLAVE_TX_DATA field.
	RTC_I2C_DATA_SLAVE_TX_DATA_Pos = 0x8
	// Bit mask of SLAVE_TX_DATA field.
	RTC_I2C_DATA_SLAVE_TX_DATA_Msk = 0xff00
	// Position of DONE field.
	RTC_I2C_DATA_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	RTC_I2C_DATA_DONE_Msk = 0x80000000
	// Bit DONE.
	RTC_I2C_DATA_DONE = 0x80000000

	// CMD0: RTC I2C Command 0
	// Position of COMMAND0 field.
	RTC_I2C_CMD0_COMMAND0_Pos = 0x0
	// Bit mask of COMMAND0 field.
	RTC_I2C_CMD0_COMMAND0_Msk = 0x3fff
	// Position of COMMAND0_DONE field.
	RTC_I2C_CMD0_COMMAND0_DONE_Pos = 0x1f
	// Bit mask of COMMAND0_DONE field.
	RTC_I2C_CMD0_COMMAND0_DONE_Msk = 0x80000000
	// Bit COMMAND0_DONE.
	RTC_I2C_CMD0_COMMAND0_DONE = 0x80000000

	// CMD1: RTC I2C Command 1
	// Position of COMMAND1 field.
	RTC_I2C_CMD1_COMMAND1_Pos = 0x0
	// Bit mask of COMMAND1 field.
	RTC_I2C_CMD1_COMMAND1_Msk = 0x3fff
	// Position of COMMAND1_DONE field.
	RTC_I2C_CMD1_COMMAND1_DONE_Pos = 0x1f
	// Bit mask of COMMAND1_DONE field.
	RTC_I2C_CMD1_COMMAND1_DONE_Msk = 0x80000000
	// Bit COMMAND1_DONE.
	RTC_I2C_CMD1_COMMAND1_DONE = 0x80000000

	// CMD2: RTC I2C Command 2
	// Position of COMMAND2 field.
	RTC_I2C_CMD2_COMMAND2_Pos = 0x0
	// Bit mask of COMMAND2 field.
	RTC_I2C_CMD2_COMMAND2_Msk = 0x3fff
	// Position of COMMAND2_DONE field.
	RTC_I2C_CMD2_COMMAND2_DONE_Pos = 0x1f
	// Bit mask of COMMAND2_DONE field.
	RTC_I2C_CMD2_COMMAND2_DONE_Msk = 0x80000000
	// Bit COMMAND2_DONE.
	RTC_I2C_CMD2_COMMAND2_DONE = 0x80000000

	// CMD3: RTC I2C Command 3
	// Position of COMMAND3 field.
	RTC_I2C_CMD3_COMMAND3_Pos = 0x0
	// Bit mask of COMMAND3 field.
	RTC_I2C_CMD3_COMMAND3_Msk = 0x3fff
	// Position of COMMAND3_DONE field.
	RTC_I2C_CMD3_COMMAND3_DONE_Pos = 0x1f
	// Bit mask of COMMAND3_DONE field.
	RTC_I2C_CMD3_COMMAND3_DONE_Msk = 0x80000000
	// Bit COMMAND3_DONE.
	RTC_I2C_CMD3_COMMAND3_DONE = 0x80000000

	// CMD4: RTC I2C Command 4
	// Position of COMMAND4 field.
	RTC_I2C_CMD4_COMMAND4_Pos = 0x0
	// Bit mask of COMMAND4 field.
	RTC_I2C_CMD4_COMMAND4_Msk = 0x3fff
	// Position of COMMAND4_DONE field.
	RTC_I2C_CMD4_COMMAND4_DONE_Pos = 0x1f
	// Bit mask of COMMAND4_DONE field.
	RTC_I2C_CMD4_COMMAND4_DONE_Msk = 0x80000000
	// Bit COMMAND4_DONE.
	RTC_I2C_CMD4_COMMAND4_DONE = 0x80000000

	// CMD5: RTC I2C Command 5
	// Position of COMMAND5 field.
	RTC_I2C_CMD5_COMMAND5_Pos = 0x0
	// Bit mask of COMMAND5 field.
	RTC_I2C_CMD5_COMMAND5_Msk = 0x3fff
	// Position of COMMAND5_DONE field.
	RTC_I2C_CMD5_COMMAND5_DONE_Pos = 0x1f
	// Bit mask of COMMAND5_DONE field.
	RTC_I2C_CMD5_COMMAND5_DONE_Msk = 0x80000000
	// Bit COMMAND5_DONE.
	RTC_I2C_CMD5_COMMAND5_DONE = 0x80000000

	// CMD6: RTC I2C Command 6
	// Position of COMMAND6 field.
	RTC_I2C_CMD6_COMMAND6_Pos = 0x0
	// Bit mask of COMMAND6 field.
	RTC_I2C_CMD6_COMMAND6_Msk = 0x3fff
	// Position of COMMAND6_DONE field.
	RTC_I2C_CMD6_COMMAND6_DONE_Pos = 0x1f
	// Bit mask of COMMAND6_DONE field.
	RTC_I2C_CMD6_COMMAND6_DONE_Msk = 0x80000000
	// Bit COMMAND6_DONE.
	RTC_I2C_CMD6_COMMAND6_DONE = 0x80000000

	// CMD7: RTC I2C Command 7
	// Position of COMMAND7 field.
	RTC_I2C_CMD7_COMMAND7_Pos = 0x0
	// Bit mask of COMMAND7 field.
	RTC_I2C_CMD7_COMMAND7_Msk = 0x3fff
	// Position of COMMAND7_DONE field.
	RTC_I2C_CMD7_COMMAND7_DONE_Pos = 0x1f
	// Bit mask of COMMAND7_DONE field.
	RTC_I2C_CMD7_COMMAND7_DONE_Msk = 0x80000000
	// Bit COMMAND7_DONE.
	RTC_I2C_CMD7_COMMAND7_DONE = 0x80000000

	// CMD8: RTC I2C Command 8
	// Position of COMMAND8 field.
	RTC_I2C_CMD8_COMMAND8_Pos = 0x0
	// Bit mask of COMMAND8 field.
	RTC_I2C_CMD8_COMMAND8_Msk = 0x3fff
	// Position of COMMAND8_DONE field.
	RTC_I2C_CMD8_COMMAND8_DONE_Pos = 0x1f
	// Bit mask of COMMAND8_DONE field.
	RTC_I2C_CMD8_COMMAND8_DONE_Msk = 0x80000000
	// Bit COMMAND8_DONE.
	RTC_I2C_CMD8_COMMAND8_DONE = 0x80000000

	// CMD9: RTC I2C Command 9
	// Position of COMMAND9 field.
	RTC_I2C_CMD9_COMMAND9_Pos = 0x0
	// Bit mask of COMMAND9 field.
	RTC_I2C_CMD9_COMMAND9_Msk = 0x3fff
	// Position of COMMAND9_DONE field.
	RTC_I2C_CMD9_COMMAND9_DONE_Pos = 0x1f
	// Bit mask of COMMAND9_DONE field.
	RTC_I2C_CMD9_COMMAND9_DONE_Msk = 0x80000000
	// Bit COMMAND9_DONE.
	RTC_I2C_CMD9_COMMAND9_DONE = 0x80000000

	// CMD10: RTC I2C Command 10
	// Position of COMMAND10 field.
	RTC_I2C_CMD10_COMMAND10_Pos = 0x0
	// Bit mask of COMMAND10 field.
	RTC_I2C_CMD10_COMMAND10_Msk = 0x3fff
	// Position of COMMAND10_DONE field.
	RTC_I2C_CMD10_COMMAND10_DONE_Pos = 0x1f
	// Bit mask of COMMAND10_DONE field.
	RTC_I2C_CMD10_COMMAND10_DONE_Msk = 0x80000000
	// Bit COMMAND10_DONE.
	RTC_I2C_CMD10_COMMAND10_DONE = 0x80000000

	// CMD11: RTC I2C Command 11
	// Position of COMMAND11 field.
	RTC_I2C_CMD11_COMMAND11_Pos = 0x0
	// Bit mask of COMMAND11 field.
	RTC_I2C_CMD11_COMMAND11_Msk = 0x3fff
	// Position of COMMAND11_DONE field.
	RTC_I2C_CMD11_COMMAND11_DONE_Pos = 0x1f
	// Bit mask of COMMAND11_DONE field.
	RTC_I2C_CMD11_COMMAND11_DONE_Msk = 0x80000000
	// Bit COMMAND11_DONE.
	RTC_I2C_CMD11_COMMAND11_DONE = 0x80000000

	// CMD12: RTC I2C Command 12
	// Position of COMMAND12 field.
	RTC_I2C_CMD12_COMMAND12_Pos = 0x0
	// Bit mask of COMMAND12 field.
	RTC_I2C_CMD12_COMMAND12_Msk = 0x3fff
	// Position of COMMAND12_DONE field.
	RTC_I2C_CMD12_COMMAND12_DONE_Pos = 0x1f
	// Bit mask of COMMAND12_DONE field.
	RTC_I2C_CMD12_COMMAND12_DONE_Msk = 0x80000000
	// Bit COMMAND12_DONE.
	RTC_I2C_CMD12_COMMAND12_DONE = 0x80000000

	// CMD13: RTC I2C Command 13
	// Position of COMMAND13 field.
	RTC_I2C_CMD13_COMMAND13_Pos = 0x0
	// Bit mask of COMMAND13 field.
	RTC_I2C_CMD13_COMMAND13_Msk = 0x3fff
	// Position of COMMAND13_DONE field.
	RTC_I2C_CMD13_COMMAND13_DONE_Pos = 0x1f
	// Bit mask of COMMAND13_DONE field.
	RTC_I2C_CMD13_COMMAND13_DONE_Msk = 0x80000000
	// Bit COMMAND13_DONE.
	RTC_I2C_CMD13_COMMAND13_DONE = 0x80000000

	// CMD14: RTC I2C Command 14
	// Position of COMMAND14 field.
	RTC_I2C_CMD14_COMMAND14_Pos = 0x0
	// Bit mask of COMMAND14 field.
	RTC_I2C_CMD14_COMMAND14_Msk = 0x3fff
	// Position of COMMAND14_DONE field.
	RTC_I2C_CMD14_COMMAND14_DONE_Pos = 0x1f
	// Bit mask of COMMAND14_DONE field.
	RTC_I2C_CMD14_COMMAND14_DONE_Msk = 0x80000000
	// Bit COMMAND14_DONE.
	RTC_I2C_CMD14_COMMAND14_DONE = 0x80000000

	// CMD15: RTC I2C Command 15
	// Position of COMMAND15 field.
	RTC_I2C_CMD15_COMMAND15_Pos = 0x0
	// Bit mask of COMMAND15 field.
	RTC_I2C_CMD15_COMMAND15_Msk = 0x3fff
	// Position of COMMAND15_DONE field.
	RTC_I2C_CMD15_COMMAND15_DONE_Pos = 0x1f
	// Bit mask of COMMAND15_DONE field.
	RTC_I2C_CMD15_COMMAND15_DONE_Msk = 0x80000000
	// Bit COMMAND15_DONE.
	RTC_I2C_CMD15_COMMAND15_DONE = 0x80000000

	// DATE: Version control register
	// Position of DATE field.
	RTC_I2C_DATE_DATE_Pos = 0x0
	// Bit mask of DATE field.
	RTC_I2C_DATE_DATE_Msk = 0xfffffff
)

// Constants for SENS: SENS Peripheral
const (
	// SAR_SLAVE_ADDR1: Configure slave addresses 0-1 of RTC I2C
	// Position of I2C_SLAVE_ADDR1 field.
	SENS_SAR_SLAVE_ADDR1_I2C_SLAVE_ADDR1_Pos = 0x0
	// Bit mask of I2C_SLAVE_ADDR1 field.
	SENS_SAR_SLAVE_ADDR1_I2C_SLAVE_ADDR1_Msk = 0x7ff
	// Position of I2C_SLAVE_ADDR0 field.
	SENS_SAR_SLAVE_ADDR1_I2C_SLAVE_ADDR0_Pos = 0xb
	// Bit mask of I2C_SLAVE_ADDR0 field.
	SENS_SAR_SLAVE_ADDR1_I2C_SLAVE_ADDR0_Msk = 0x3ff800
	// Position of MEAS_STATUS field.
	SENS_SAR_SLAVE_ADDR1_MEAS_STATUS_Pos = 0x16
	// Bit mask of MEAS_STATUS field.
	SENS_SAR_SLAVE_ADDR1_MEAS_STATUS_Msk = 0x3fc00000

	// SAR_SLAVE_ADDR2: Configure slave addresses 2-3 of RTC I2C
	// Position of I2C_SLAVE_ADDR3 field.
	SENS_SAR_SLAVE_ADDR2_I2C_SLAVE_ADDR3_Pos = 0x0
	// Bit mask of I2C_SLAVE_ADDR3 field.
	SENS_SAR_SLAVE_ADDR2_I2C_SLAVE_ADDR3_Msk = 0x7ff
	// Position of I2C_SLAVE_ADDR2 field.
	SENS_SAR_SLAVE_ADDR2_I2C_SLAVE_ADDR2_Pos = 0xb
	// Bit mask of I2C_SLAVE_ADDR2 field.
	SENS_SAR_SLAVE_ADDR2_I2C_SLAVE_ADDR2_Msk = 0x3ff800

	// SAR_SLAVE_ADDR3: Configure slave addresses 4-5 of RTC I2C
	// Position of I2C_SLAVE_ADDR5 field.
	SENS_SAR_SLAVE_ADDR3_I2C_SLAVE_ADDR5_Pos = 0x0
	// Bit mask of I2C_SLAVE_ADDR5 field.
	SENS_SAR_SLAVE_ADDR3_I2C_SLAVE_ADDR5_Msk = 0x7ff
	// Position of I2C_SLAVE_ADDR4 field.
	SENS_SAR_SLAVE_ADDR3_I2C_SLAVE_ADDR4_Pos = 0xb
	// Bit mask of I2C_SLAVE_ADDR4 field.
	SENS_SAR_SLAVE_ADDR3_I2C_SLAVE_ADDR4_Msk = 0x3ff800

	// SAR_SLAVE_ADDR4: Configure slave addresses 6-7 of RTC I2C
	// Position of I2C_SLAVE_ADDR7 field.
	SENS_SAR_SLAVE_ADDR4_I2C_SLAVE_ADDR7_Pos = 0x0
	// Bit mask of I2C_SLAVE_ADDR7 field.
	SENS_SAR_SLAVE_ADDR4_I2C_SLAVE_ADDR7_Msk = 0x7ff
	// Position of I2C_SLAVE_ADDR6 field.
	SENS_SAR_SLAVE_ADDR4_I2C_SLAVE_ADDR6_Pos = 0xb
	// Bit mask of I2C_SLAVE_ADDR6 field.
	SENS_SAR_SLAVE_ADDR4_I2C_SLAVE_ADDR6_Msk = 0x3ff800

	// SAR_I2C_CTRL: Configure RTC I2C transmission
	// Position of SAR_I2C_CTRL field.
	SENS_SAR_I2C_CTRL_SAR_I2C_CTRL_Pos = 0x0
	// Bit mask of SAR_I2C_CTRL field.
	SENS_SAR_I2C_CTRL_SAR_I2C_CTRL_Msk = 0xfffffff
	// Position of SAR_I2C_START field.
	SENS_SAR_I2C_CTRL_SAR_I2C_START_Pos = 0x1c
	// Bit mask of SAR_I2C_START field.
	SENS_SAR_I2C_CTRL_SAR_I2C_START_Msk = 0x10000000
	// Bit SAR_I2C_START.
	SENS_SAR_I2C_CTRL_SAR_I2C_START = 0x10000000
	// Position of SAR_I2C_START_FORCE field.
	SENS_SAR_I2C_CTRL_SAR_I2C_START_FORCE_Pos = 0x1d
	// Bit mask of SAR_I2C_START_FORCE field.
	SENS_SAR_I2C_CTRL_SAR_I2C_START_FORCE_Msk = 0x20000000
	// Bit SAR_I2C_START_FORCE.
	SENS_SAR_I2C_CTRL_SAR_I2C_START_FORCE = 0x20000000

	// SAR_COCPU_INT_RAW: Interrupt raw bit of ULP-RISCV
	// Position of COCPU_TOUCH_DONE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_DONE_INT_RAW_Pos = 0x0
	// Bit mask of COCPU_TOUCH_DONE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_DONE_INT_RAW_Msk = 0x1
	// Bit COCPU_TOUCH_DONE_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_DONE_INT_RAW = 0x1
	// Position of COCPU_TOUCH_INACTIVE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_INACTIVE_INT_RAW_Pos = 0x1
	// Bit mask of COCPU_TOUCH_INACTIVE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_INACTIVE_INT_RAW_Msk = 0x2
	// Bit COCPU_TOUCH_INACTIVE_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_INACTIVE_INT_RAW = 0x2
	// Position of COCPU_TOUCH_ACTIVE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_ACTIVE_INT_RAW_Pos = 0x2
	// Bit mask of COCPU_TOUCH_ACTIVE_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_ACTIVE_INT_RAW_Msk = 0x4
	// Bit COCPU_TOUCH_ACTIVE_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_TOUCH_ACTIVE_INT_RAW = 0x4
	// Position of COCPU_SARADC1_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC1_INT_RAW_Pos = 0x3
	// Bit mask of COCPU_SARADC1_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC1_INT_RAW_Msk = 0x8
	// Bit COCPU_SARADC1_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC1_INT_RAW = 0x8
	// Position of COCPU_SARADC2_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC2_INT_RAW_Pos = 0x4
	// Bit mask of COCPU_SARADC2_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC2_INT_RAW_Msk = 0x10
	// Bit COCPU_SARADC2_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_SARADC2_INT_RAW = 0x10
	// Position of COCPU_TSENS_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TSENS_INT_RAW_Pos = 0x5
	// Bit mask of COCPU_TSENS_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_TSENS_INT_RAW_Msk = 0x20
	// Bit COCPU_TSENS_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_TSENS_INT_RAW = 0x20
	// Position of COCPU_START_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_START_INT_RAW_Pos = 0x6
	// Bit mask of COCPU_START_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_START_INT_RAW_Msk = 0x40
	// Bit COCPU_START_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_START_INT_RAW = 0x40
	// Position of COCPU_SW_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SW_INT_RAW_Pos = 0x7
	// Bit mask of COCPU_SW_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SW_INT_RAW_Msk = 0x80
	// Bit COCPU_SW_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_SW_INT_RAW = 0x80
	// Position of COCPU_SWD_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SWD_INT_RAW_Pos = 0x8
	// Bit mask of COCPU_SWD_INT_RAW field.
	SENS_SAR_COCPU_INT_RAW_COCPU_SWD_INT_RAW_Msk = 0x100
	// Bit COCPU_SWD_INT_RAW.
	SENS_SAR_COCPU_INT_RAW_COCPU_SWD_INT_RAW = 0x100

	// SAR_COCPU_INT_ENA: Interrupt enable bit of ULP-RISCV
	// Position of COCPU_TOUCH_DONE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_DONE_INT_ENA_Pos = 0x0
	// Bit mask of COCPU_TOUCH_DONE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_DONE_INT_ENA_Msk = 0x1
	// Bit COCPU_TOUCH_DONE_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_DONE_INT_ENA = 0x1
	// Position of COCPU_TOUCH_INACTIVE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_INACTIVE_INT_ENA_Pos = 0x1
	// Bit mask of COCPU_TOUCH_INACTIVE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_INACTIVE_INT_ENA_Msk = 0x2
	// Bit COCPU_TOUCH_INACTIVE_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_INACTIVE_INT_ENA = 0x2
	// Position of COCPU_TOUCH_ACTIVE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_ACTIVE_INT_ENA_Pos = 0x2
	// Bit mask of COCPU_TOUCH_ACTIVE_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_ACTIVE_INT_ENA_Msk = 0x4
	// Bit COCPU_TOUCH_ACTIVE_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_TOUCH_ACTIVE_INT_ENA = 0x4
	// Position of COCPU_SARADC1_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC1_INT_ENA_Pos = 0x3
	// Bit mask of COCPU_SARADC1_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC1_INT_ENA_Msk = 0x8
	// Bit COCPU_SARADC1_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC1_INT_ENA = 0x8
	// Position of COCPU_SARADC2_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC2_INT_ENA_Pos = 0x4
	// Bit mask of COCPU_SARADC2_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC2_INT_ENA_Msk = 0x10
	// Bit COCPU_SARADC2_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_SARADC2_INT_ENA = 0x10
	// Position of COCPU_TSENS_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TSENS_INT_ENA_Pos = 0x5
	// Bit mask of COCPU_TSENS_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_TSENS_INT_ENA_Msk = 0x20
	// Bit COCPU_TSENS_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_TSENS_INT_ENA = 0x20
	// Position of COCPU_START_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_START_INT_ENA_Pos = 0x6
	// Bit mask of COCPU_START_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_START_INT_ENA_Msk = 0x40
	// Bit COCPU_START_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_START_INT_ENA = 0x40
	// Position of COCPU_SW_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SW_INT_ENA_Pos = 0x7
	// Bit mask of COCPU_SW_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SW_INT_ENA_Msk = 0x80
	// Bit COCPU_SW_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_SW_INT_ENA = 0x80
	// Position of COCPU_SWD_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SWD_INT_ENA_Pos = 0x8
	// Bit mask of COCPU_SWD_INT_ENA field.
	SENS_SAR_COCPU_INT_ENA_COCPU_SWD_INT_ENA_Msk = 0x100
	// Bit COCPU_SWD_INT_ENA.
	SENS_SAR_COCPU_INT_ENA_COCPU_SWD_INT_ENA = 0x100

	// SAR_COCPU_INT_ST: Interrupt status bit of ULP-RISCV
	// Position of COCPU_TOUCH_DONE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_DONE_INT_ST_Pos = 0x0
	// Bit mask of COCPU_TOUCH_DONE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_DONE_INT_ST_Msk = 0x1
	// Bit COCPU_TOUCH_DONE_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_DONE_INT_ST = 0x1
	// Position of COCPU_TOUCH_INACTIVE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_INACTIVE_INT_ST_Pos = 0x1
	// Bit mask of COCPU_TOUCH_INACTIVE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_INACTIVE_INT_ST_Msk = 0x2
	// Bit COCPU_TOUCH_INACTIVE_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_INACTIVE_INT_ST = 0x2
	// Position of COCPU_TOUCH_ACTIVE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_ACTIVE_INT_ST_Pos = 0x2
	// Bit mask of COCPU_TOUCH_ACTIVE_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_ACTIVE_INT_ST_Msk = 0x4
	// Bit COCPU_TOUCH_ACTIVE_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_TOUCH_ACTIVE_INT_ST = 0x4
	// Position of COCPU_SARADC1_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC1_INT_ST_Pos = 0x3
	// Bit mask of COCPU_SARADC1_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC1_INT_ST_Msk = 0x8
	// Bit COCPU_SARADC1_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC1_INT_ST = 0x8
	// Position of COCPU_SARADC2_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC2_INT_ST_Pos = 0x4
	// Bit mask of COCPU_SARADC2_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC2_INT_ST_Msk = 0x10
	// Bit COCPU_SARADC2_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_SARADC2_INT_ST = 0x10
	// Position of COCPU_TSENS_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TSENS_INT_ST_Pos = 0x5
	// Bit mask of COCPU_TSENS_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_TSENS_INT_ST_Msk = 0x20
	// Bit COCPU_TSENS_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_TSENS_INT_ST = 0x20
	// Position of COCPU_START_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_START_INT_ST_Pos = 0x6
	// Bit mask of COCPU_START_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_START_INT_ST_Msk = 0x40
	// Bit COCPU_START_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_START_INT_ST = 0x40
	// Position of COCPU_SW_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SW_INT_ST_Pos = 0x7
	// Bit mask of COCPU_SW_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SW_INT_ST_Msk = 0x80
	// Bit COCPU_SW_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_SW_INT_ST = 0x80
	// Position of COCPU_SWD_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SWD_INT_ST_Pos = 0x8
	// Bit mask of COCPU_SWD_INT_ST field.
	SENS_SAR_COCPU_INT_ST_COCPU_SWD_INT_ST_Msk = 0x100
	// Bit COCPU_SWD_INT_ST.
	SENS_SAR_COCPU_INT_ST_COCPU_SWD_INT_ST = 0x100

	// SAR_COCPU_INT_CLR: Interrupt clear bit of ULP-RISCV
	// Position of COCPU_TOUCH_DONE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_DONE_INT_CLR_Pos = 0x0
	// Bit mask of COCPU_TOUCH_DONE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_DONE_INT_CLR_Msk = 0x1
	// Bit COCPU_TOUCH_DONE_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_DONE_INT_CLR = 0x1
	// Position of COCPU_TOUCH_INACTIVE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_INACTIVE_INT_CLR_Pos = 0x1
	// Bit mask of COCPU_TOUCH_INACTIVE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_INACTIVE_INT_CLR_Msk = 0x2
	// Bit COCPU_TOUCH_INACTIVE_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_INACTIVE_INT_CLR = 0x2
	// Position of COCPU_TOUCH_ACTIVE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_ACTIVE_INT_CLR_Pos = 0x2
	// Bit mask of COCPU_TOUCH_ACTIVE_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_ACTIVE_INT_CLR_Msk = 0x4
	// Bit COCPU_TOUCH_ACTIVE_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_TOUCH_ACTIVE_INT_CLR = 0x4
	// Position of COCPU_SARADC1_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC1_INT_CLR_Pos = 0x3
	// Bit mask of COCPU_SARADC1_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC1_INT_CLR_Msk = 0x8
	// Bit COCPU_SARADC1_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC1_INT_CLR = 0x8
	// Position of COCPU_SARADC2_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC2_INT_CLR_Pos = 0x4
	// Bit mask of COCPU_SARADC2_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC2_INT_CLR_Msk = 0x10
	// Bit COCPU_SARADC2_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_SARADC2_INT_CLR = 0x10
	// Position of COCPU_TSENS_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TSENS_INT_CLR_Pos = 0x5
	// Bit mask of COCPU_TSENS_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_TSENS_INT_CLR_Msk = 0x20
	// Bit COCPU_TSENS_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_TSENS_INT_CLR = 0x20
	// Position of COCPU_START_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_START_INT_CLR_Pos = 0x6
	// Bit mask of COCPU_START_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_START_INT_CLR_Msk = 0x40
	// Bit COCPU_START_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_START_INT_CLR = 0x40
	// Position of COCPU_SW_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SW_INT_CLR_Pos = 0x7
	// Bit mask of COCPU_SW_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SW_INT_CLR_Msk = 0x80
	// Bit COCPU_SW_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_SW_INT_CLR = 0x80
	// Position of COCPU_SWD_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SWD_INT_CLR_Pos = 0x8
	// Bit mask of COCPU_SWD_INT_CLR field.
	SENS_SAR_COCPU_INT_CLR_COCPU_SWD_INT_CLR_Msk = 0x100
	// Bit COCPU_SWD_INT_CLR.
	SENS_SAR_COCPU_INT_CLR_COCPU_SWD_INT_CLR = 0x100
)
