"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    rollupService,
    transformService
  } = services;
  router.get({
    path: _constants.NODE_API.ROLLUPS,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string()
      })
    }
  }, rollupService.getRollups);
  router.put({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, rollupService.putRollup);
  router.get({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, rollupService.getRollup);
  router.delete({
    path: `${_constants.NODE_API.ROLLUPS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, rollupService.deleteRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, rollupService.startRollup);
  router.post({
    path: `${_constants.NODE_API.ROLLUPS}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, rollupService.stopRollup);
  router.post({
    path: _constants.NODE_API._MAPPINGS,
    validate: {
      body: _configSchema.schema.any()
    }
  }, rollupService.getMappings);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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