"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;
var _constants = require("../utils/constants");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AliasServices {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);
    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const client = this.osDriver.asScoped(request);
        const [aliases, apiAccessible, errMsg] = await getAliases(client, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    this.osDriver = osDriver;
  }
}
exports.default = AliasServices;
async function getAliases({
  callAsCurrentUser: callWithRequest
}, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }
    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9kZWZpbmVQcm9wZXJ0eSIsIm9iaiIsImtleSIsInZhbHVlIiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImFyZyIsIl90b1ByaW1pdGl2ZSIsIlN0cmluZyIsImlucHV0IiwiaGludCIsInByaW0iLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsInVuZGVmaW5lZCIsInJlcyIsImNhbGwiLCJUeXBlRXJyb3IiLCJOdW1iZXIiLCJBbGlhc1NlcnZpY2VzIiwiY29uc3RydWN0b3IiLCJvc0RyaXZlciIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJzZWFyY2giLCJxdWVyeSIsImNsaWVudCIsImFzU2NvcGVkIiwiYWxpYXNlcyIsImFwaUFjY2Vzc2libGUiLCJlcnJNc2ciLCJnZXRBbGlhc2VzIiwiY3VzdG9tIiwic3RhdHVzQ29kZSIsImJvZHkiLCJvayIsImVycm9yIiwidG90YWxBbGlhc2VzIiwibGVuZ3RoIiwiZXJyIiwiY29uc29sZSIsIm1lc3NhZ2UiLCJleHBvcnRzIiwiZGVmYXVsdCIsImNhbGxBc0N1cnJlbnRVc2VyIiwiY2FsbFdpdGhSZXF1ZXN0Iiwic2VhcmNoUGF0dGVybiIsImFjY2Vzc2libGUiLCJhbGlhc2VzUmVzcG9uc2UiLCJmb3JtYXQiLCJuYW1lIiwiY2F0Y2giLCJlIiwic3RhcnRzV2l0aCIsIlNFQ1VSSVRZX0VYQ0VQVElPTl9QUkVGSVgiLCJhbGlhcyJdLCJzb3VyY2VzIjpbIkFsaWFzU2VydmljZXMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXG4gIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlLFxuICBJTGVnYWN5Q3VzdG9tQ2x1c3RlckNsaWVudCxcbiAgSUxlZ2FjeVNjb3BlZENsdXN0ZXJDbGllbnQsXG59IGZyb20gXCJvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyXCI7XG5pbXBvcnQgeyBTZXJ2ZXJSZXNwb25zZSB9IGZyb20gXCIuLi9tb2RlbHMvdHlwZXNcIjtcbmltcG9ydCB7IEFsaWFzLCBHZXRBbGlhc2VzUmVzcG9uc2UgfSBmcm9tIFwiLi4vbW9kZWxzL2ludGVyZmFjZXNcIjtcbmltcG9ydCB7IFNFQ1VSSVRZX0VYQ0VQVElPTl9QUkVGSVggfSBmcm9tIFwiLi4vdXRpbHMvY29uc3RhbnRzXCI7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEFsaWFzU2VydmljZXMge1xuICBvc0RyaXZlcjogSUxlZ2FjeUN1c3RvbUNsdXN0ZXJDbGllbnQ7XG5cbiAgY29uc3RydWN0b3Iob3NEcml2ZXI6IElMZWdhY3lDdXN0b21DbHVzdGVyQ2xpZW50KSB7XG4gICAgdGhpcy5vc0RyaXZlciA9IG9zRHJpdmVyO1xuICB9XG5cbiAgZ2V0QWxpYXNlcyA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPEdldEFsaWFzZXNSZXNwb25zZT4+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgc2VhcmNoIH0gPSByZXF1ZXN0LnF1ZXJ5IGFzIHtcbiAgICAgICAgc2VhcmNoPzogc3RyaW5nO1xuICAgICAgfTtcblxuICAgICAgY29uc3QgY2xpZW50ID0gdGhpcy5vc0RyaXZlci5hc1Njb3BlZChyZXF1ZXN0KTtcbiAgICAgIGNvbnN0IFthbGlhc2VzLCBhcGlBY2Nlc3NpYmxlLCBlcnJNc2ddID0gYXdhaXQgZ2V0QWxpYXNlcyhjbGllbnQsIHNlYXJjaCk7XG5cbiAgICAgIGlmICghYXBpQWNjZXNzaWJsZSlcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICAgIGVycm9yOiBlcnJNc2csXG4gICAgICAgICAgfSxcbiAgICAgICAgfSk7XG5cbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogdHJ1ZSxcbiAgICAgICAgICByZXNwb25zZToge1xuICAgICAgICAgICAgYWxpYXNlczogYWxpYXNlcyxcbiAgICAgICAgICAgIHRvdGFsQWxpYXNlczogYWxpYXNlcy5sZW5ndGgsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5lcnJvcihcIkluZGV4IE1hbmFnZW1lbnQgLSBBbGlhc2VzU2VydmljZSAtIGdldEFsaWFzZXM6XCIsIGVycik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgIGVycm9yOiBlcnIubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldEFsaWFzZXMoXG4gIHsgY2FsbEFzQ3VycmVudFVzZXI6IGNhbGxXaXRoUmVxdWVzdCB9OiBJTGVnYWN5U2NvcGVkQ2x1c3RlckNsaWVudCxcbiAgc2VhcmNoPzogc3RyaW5nXG4pOiBQcm9taXNlPFtBbGlhc1tdLCBib29sZWFuLCBzdHJpbmddPiB7XG4gIGNvbnN0IHNlYXJjaFBhdHRlcm4gPSBzZWFyY2ggPyBgKiR7c2VhcmNofSpgIDogXCIqXCI7XG5cbiAgbGV0IGFjY2Vzc2libGUgPSB0cnVlO1xuICBsZXQgZXJyTXNnID0gXCJcIjtcbiAgY29uc3QgYWxpYXNlc1Jlc3BvbnNlID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiY2F0LmFsaWFzZXNcIiwge1xuICAgIGZvcm1hdDogXCJqc29uXCIsXG4gICAgbmFtZTogc2VhcmNoUGF0dGVybixcbiAgfSkuY2F0Y2goKGUpID0+IHtcbiAgICBpZiAoZS5zdGF0dXNDb2RlID09PSA0MDMgJiYgZS5tZXNzYWdlLnN0YXJ0c1dpdGgoU0VDVVJJVFlfRVhDRVBUSU9OX1BSRUZJWCkpIHtcbiAgICAgIGFjY2Vzc2libGUgPSBmYWxzZTtcbiAgICAgIGVyck1zZyA9IGUubWVzc2FnZTtcbiAgICAgIHJldHVybiB7IGFsaWFzOiBbXSB9O1xuICAgIH1cbiAgICB0aHJvdyBlO1xuICB9KTtcblxuICByZXR1cm4gW2FsaWFzZXNSZXNwb25zZSwgYWNjZXNzaWJsZSwgZXJyTXNnXTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQWVBLElBQUFBLFVBQUEsR0FBQUMsT0FBQTtBQUErRCxTQUFBQyxnQkFBQUMsR0FBQSxFQUFBQyxHQUFBLEVBQUFDLEtBQUEsSUFBQUQsR0FBQSxHQUFBRSxjQUFBLENBQUFGLEdBQUEsT0FBQUEsR0FBQSxJQUFBRCxHQUFBLElBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxHQUFBLEVBQUFDLEdBQUEsSUFBQUMsS0FBQSxFQUFBQSxLQUFBLEVBQUFJLFVBQUEsUUFBQUMsWUFBQSxRQUFBQyxRQUFBLG9CQUFBUixHQUFBLENBQUFDLEdBQUEsSUFBQUMsS0FBQSxXQUFBRixHQUFBO0FBQUEsU0FBQUcsZUFBQU0sR0FBQSxRQUFBUixHQUFBLEdBQUFTLFlBQUEsQ0FBQUQsR0FBQSwyQkFBQVIsR0FBQSxnQkFBQUEsR0FBQSxHQUFBVSxNQUFBLENBQUFWLEdBQUE7QUFBQSxTQUFBUyxhQUFBRSxLQUFBLEVBQUFDLElBQUEsZUFBQUQsS0FBQSxpQkFBQUEsS0FBQSxrQkFBQUEsS0FBQSxNQUFBRSxJQUFBLEdBQUFGLEtBQUEsQ0FBQUcsTUFBQSxDQUFBQyxXQUFBLE9BQUFGLElBQUEsS0FBQUcsU0FBQSxRQUFBQyxHQUFBLEdBQUFKLElBQUEsQ0FBQUssSUFBQSxDQUFBUCxLQUFBLEVBQUFDLElBQUEsMkJBQUFLLEdBQUEsc0JBQUFBLEdBQUEsWUFBQUUsU0FBQSw0REFBQVAsSUFBQSxnQkFBQUYsTUFBQSxHQUFBVSxNQUFBLEVBQUFULEtBQUEsS0FmL0Q7QUFDQTtBQUNBO0FBQ0E7QUFjZSxNQUFNVSxhQUFhLENBQUM7RUFHakNDLFdBQVdBLENBQUNDLFFBQW9DLEVBQUU7SUFBQXpCLGVBQUE7SUFBQUEsZUFBQSxxQkFJckMsT0FDWDBCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDa0M7TUFDL0UsSUFBSTtRQUNGLE1BQU07VUFBRUM7UUFBTyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csS0FFMUI7UUFFRCxNQUFNQyxNQUFNLEdBQUcsSUFBSSxDQUFDTixRQUFRLENBQUNPLFFBQVEsQ0FBQ0wsT0FBTyxDQUFDO1FBQzlDLE1BQU0sQ0FBQ00sT0FBTyxFQUFFQyxhQUFhLEVBQUVDLE1BQU0sQ0FBQyxHQUFHLE1BQU1DLFVBQVUsQ0FBQ0wsTUFBTSxFQUFFRixNQUFNLENBQUM7UUFFekUsSUFBSSxDQUFDSyxhQUFhLEVBQ2hCLE9BQU9OLFFBQVEsQ0FBQ1MsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmQyxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLEtBQUs7WUFDVEMsS0FBSyxFQUFFTjtVQUNUO1FBQ0YsQ0FBQyxDQUFDO1FBRUosT0FBT1AsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsSUFBSTtZQUNSWixRQUFRLEVBQUU7Y0FDUkssT0FBTyxFQUFFQSxPQUFPO2NBQ2hCUyxZQUFZLEVBQUVULE9BQU8sQ0FBQ1U7WUFDeEI7VUFDRjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPQyxHQUFHLEVBQUU7UUFDWkMsT0FBTyxDQUFDSixLQUFLLENBQUMsaURBQWlELEVBQUVHLEdBQUcsQ0FBQztRQUNyRSxPQUFPaEIsUUFBUSxDQUFDUyxNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZDLElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsS0FBSztZQUNUQyxLQUFLLEVBQUVHLEdBQUcsQ0FBQ0U7VUFDYjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQTdDQyxJQUFJLENBQUNyQixRQUFRLEdBQUdBLFFBQVE7RUFDMUI7QUE2Q0Y7QUFBQ3NCLE9BQUEsQ0FBQUMsT0FBQSxHQUFBekIsYUFBQTtBQUVNLGVBQWVhLFVBQVVBLENBQzlCO0VBQUVhLGlCQUFpQixFQUFFQztBQUE0QyxDQUFDLEVBQ2xFckIsTUFBZSxFQUNzQjtFQUNyQyxNQUFNc0IsYUFBYSxHQUFHdEIsTUFBTSxHQUFJLElBQUdBLE1BQU8sR0FBRSxHQUFHLEdBQUc7RUFFbEQsSUFBSXVCLFVBQVUsR0FBRyxJQUFJO0VBQ3JCLElBQUlqQixNQUFNLEdBQUcsRUFBRTtFQUNmLE1BQU1rQixlQUFlLEdBQUcsTUFBTUgsZUFBZSxDQUFDLGFBQWEsRUFBRTtJQUMzREksTUFBTSxFQUFFLE1BQU07SUFDZEMsSUFBSSxFQUFFSjtFQUNSLENBQUMsQ0FBQyxDQUFDSyxLQUFLLENBQUVDLENBQUMsSUFBSztJQUNkLElBQUlBLENBQUMsQ0FBQ25CLFVBQVUsS0FBSyxHQUFHLElBQUltQixDQUFDLENBQUNYLE9BQU8sQ0FBQ1ksVUFBVSxDQUFDQyxvQ0FBeUIsQ0FBQyxFQUFFO01BQzNFUCxVQUFVLEdBQUcsS0FBSztNQUNsQmpCLE1BQU0sR0FBR3NCLENBQUMsQ0FBQ1gsT0FBTztNQUNsQixPQUFPO1FBQUVjLEtBQUssRUFBRTtNQUFHLENBQUM7SUFDdEI7SUFDQSxNQUFNSCxDQUFDO0VBQ1QsQ0FBQyxDQUFDO0VBRUYsT0FBTyxDQUFDSixlQUFlLEVBQUVELFVBQVUsRUFBRWpCLE1BQU0sQ0FBQztBQUM5QyJ9