/*
 * Copyright (C) 2023 Richard Hughes <richard@hughsie.com>
 *
 * SPDX-License-Identifier: LGPL-2.1+
 */

#pragma once

#include <glib.h>

#if !defined(__PASSIM_H_INSIDE__) && !defined(PASSIM_COMPILATION)
#error "Only <passim.h> can be included directly."
#endif

/* clang-format off */
/**
 * PASSIM_MAJOR_VERSION:
 *
 * The compile-time major version
 */
#define PASSIM_MAJOR_VERSION 0

/**
 * PASSIM_MINOR_VERSION:
 *
 * The compile-time minor version
 */
#define PASSIM_MINOR_VERSION 1

/**
 * PASSIM_MICRO_VERSION:
 *
 * The compile-time micro version
 */
#define PASSIM_MICRO_VERSION 7
/* clang-format on */

/**
 * PASSIM_CHECK_VERSION:
 * @major: Major version number
 * @minor: Minor version number
 * @micro: Micro version number
 *
 * Check whether a passim version equal to or greater than
 * major.minor.micro.
 *
 * These compile time macros allow the user to enable parts of client code
 * depending on the version of libpassim installed.
 */
#define PASSIM_CHECK_VERSION(major, minor, micro)                                                   \
	(PASSIM_MAJOR_VERSION > major ||                                                            \
	 (PASSIM_MAJOR_VERSION == major && PASSIM_MINOR_VERSION > minor) ||                          \
	 (PASSIM_MAJOR_VERSION == major && PASSIM_MINOR_VERSION == minor &&                          \
	  PASSIM_MICRO_VERSION >= micro))

const gchar *
passim_version_string(void);
