from _typeshed import Incomplete

from .resource import Collection, Model

class Image(Model):
    @property
    def labels(self): ...
    @property
    def short_id(self): ...
    @property
    def tags(self): ...
    def history(self): ...
    def remove(self, force: bool = False, noprune: bool = False): ...
    def save(self, chunk_size=2097152, named: bool = False): ...
    def tag(self, repository, tag: str | None = None, **kwargs): ...

class RegistryData(Model):
    image_name: Incomplete
    def __init__(self, image_name, *args, **kwargs) -> None: ...
    @property
    def id(self): ...
    @property
    def short_id(self): ...
    def pull(self, platform: Incomplete | None = None): ...
    def has_platform(self, platform): ...
    attrs: Incomplete
    def reload(self) -> None: ...

class ImageCollection(Collection):
    model: type[Image]
    def build(self, **kwargs): ...
    def get(self, name): ...
    def get_registry_data(self, name, auth_config: Incomplete | None = None): ...
    def list(self, name: Incomplete | None = None, all: bool = False, filters: Incomplete | None = None): ...
    def load(self, data): ...
    def pull(self, repository, tag: str | None = None, all_tags: bool = False, **kwargs): ...
    def push(self, repository, tag: str | None = None, **kwargs): ...
    def remove(self, *args, **kwargs) -> None: ...
    def search(self, *args, **kwargs): ...
    def prune(self, filters: Incomplete | None = None): ...
    def prune_builds(self, *args, **kwargs): ...

def normalize_platform(platform, engine_info): ...
