complete -c sq -n "__fish_use_subcommand" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_use_subcommand" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_use_subcommand" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_use_subcommand" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_use_subcommand" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_use_subcommand" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_use_subcommand" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_use_subcommand" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_use_subcommand" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_use_subcommand" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_use_subcommand" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_use_subcommand" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_use_subcommand" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_use_subcommand" -f -a "encrypt" -d 'Encrypt a message'
complete -c sq -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypt a message'
complete -c sq -n "__fish_use_subcommand" -f -a "sign" -d 'Sign messages or data files'
complete -c sq -n "__fish_use_subcommand" -f -a "verify" -d 'Verify signed messages or detached signatures'
complete -c sq -n "__fish_use_subcommand" -f -a "inspect" -d 'Inspect data, like file(1)'
complete -c sq -n "__fish_use_subcommand" -f -a "cert" -d 'Manage certificates'
complete -c sq -n "__fish_use_subcommand" -f -a "key" -d 'Manage keys'
complete -c sq -n "__fish_use_subcommand" -f -a "pki" -d 'Authenticate certs using the Web of Trust'
complete -c sq -n "__fish_use_subcommand" -f -a "autocrypt" -d 'Communicate certificates using Autocrypt'
complete -c sq -n "__fish_use_subcommand" -f -a "network" -d 'Retrieve and publish certificates over the network'
complete -c sq -n "__fish_use_subcommand" -f -a "toolbox" -d 'Tools for developers, maintainers, and forensic specialists'
complete -c sq -n "__fish_use_subcommand" -f -a "version" -d 'Detailed version and output version information'
complete -c sq -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-email -d 'Encrypt to all certificates that can be authenticated for the specified email address' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-userid -d 'Encrypt to all certificates that can be authenticated for the specified User ID' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-cert -d 'Encrypt to the named certificates' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-file -d 'Encrypt to all certificates in CERT_RING_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l set-metadata-time -d 'Set time for encrypted file as metadata' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l signer-file -d 'Sign the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l signer-key -d 'Sign the message using the specified key on the key store' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l encrypt-for -d 'Select what kind of keys are considered for encryption.' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l compression -d 'Select compression scheme to use' -r -f -a "{none	'',zip	'',zlib	'',bzip2	''}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l set-metadata-filename -d 'Set the filename of the encrypted file as metadata'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s s -l symmetric -d 'Prompt to add a password to encrypt with'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l use-expired-subkey -d 'Fall back to expired encryption subkeys'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s n -l signatures -d 'Set the threshold of valid signatures to N' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l signer-file -d 'Verify signatures using the certificates in CERT_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l recipient-file -d 'Decrypt the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l session-key -d 'Decrypt an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Print the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from sign" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l merge -d 'Merge signatures from the input and SIGNED-MESSAGE' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l signer-file -d 'Sign the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l signer-key -d 'Sign the message using the specified key on the key store' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from sign" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from sign" -l detached -d 'Create a detached signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -l cleartext-signature -d 'Create a cleartext signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s a -l append -d 'Append a signature to existing signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s n -l notarize -d 'Sign a message and all existing signatures'
complete -c sq -n "__fish_seen_subcommand_from sign" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from sign" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from sign" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from sign" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from sign" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from verify" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l detached -d 'Verify a detached signature' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -s n -l signatures -d 'Set the threshold of valid signatures to N' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l signer-file -d 'Verify signatures using the certificate in CERT_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l signer-cert -d 'Verify signatures using the specified certificate' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from verify" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from verify" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from verify" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from verify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l cert -d 'Read the specified certificate from the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from inspect" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l certifications -d 'Print third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "export" -d 'Export certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "lint" -d 'Check certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l cert -d 'Return certificates that have the specified fingerprint or key ID' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l key -d 'Return certificates where the primary key or a subkey has the specified fingerprint or key ID' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l userid -d 'Return certificates that have a User ID that matches exactly, including case' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l grep -d 'Return certificates that have a User ID that contains the string, case insensitively' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l email -d 'Return certificates that have a User ID with the specified email address, case insensitively' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l domain -d 'Return certificates that have a User ID with an email address from the specified domain' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l all -d 'Export all certificates'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s q -l quiet -d 'Quiet; does not output any diagnostics'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s F -l fix -d 'Attempts to fix certificates, when possible'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s e -l export-secret-keys -d 'When fixing a certificate, the fixed certificate is exported without any secret key material.  Using this switch causes any secret key material to also be exported'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s k -l list-keys -d 'If set, outputs a list of fingerprints, one per line, of certificates that have issues.  This output is intended for use by scripts'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from lint" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "export" -d 'Export certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "lint" -d 'Check certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List keys managed by the key store'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a new key'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import keys into the key store'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "password" -d 'Change password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "expire" -d 'Change expiration times'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "userid" -d 'Manage User IDs'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "subkey" -d 'Manage Subkeys'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "attest-certifications" -d 'Attest to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "adopt" -d 'Bind keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s u -l userid -d 'Add a user ID to the key' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s c -l cipher-suite -d 'Select the cryptographic algorithms for the key' -r -f -a "{rsa3k	'',rsa4k	'',cv25519	''}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l expiry -d 'Define EXPIRY for the key as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-encrypt -d 'Add an encryption-capable subkey [default: universal]' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l rev-cert -d 'Write the revocation certificate to FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l allow-non-canonical-userids -d 'Don\'t reject user IDs that are not in canonical form'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l no-userids -d 'Create a key without any user IDs'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l with-password -d 'Protect the key with a password'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-sign -d 'Add a signing-capable subkey (default)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-sign -d 'Add no signing-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-authenticate -d 'Add an authentication-capable subkey (default)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-authenticate -d 'Add no authentication-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-encrypt -d 'Add no encryption-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l old-password-file -d 'File containing password to decrypt key' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l new-password-file -d 'File containing password to encrypt key' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l clear -d 'Emit a key with unencrypted secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l subkey -d 'Change expiration of this subkey, not the entire key' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from expire" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Sign the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "strip" -d 'Strip a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l allow-non-canonical-userids -d 'Don\'t reject user IDs that are not in canonical form'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate containing the User ID to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Sign the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s u -l userid -d 'User IDs to strip' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "strip" -d 'Strip a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s c -l cipher-suite -d 'Select the cryptographic algorithms for the subkey' -r -f -a "{rsa3k	'',rsa4k	'',cv25519	''}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l expiry -d 'Define EXPIRY for the subkey as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-encrypt -d 'Add an encryption capability to subkey [default: universal]' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-sign -d 'Add signing capability to subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-authenticate -d 'Add authentication capability to subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l with-password -d 'Protect the subkey with a password'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate containing the subkey to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Sign the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l none -d 'Remove all prior attestations'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l all -d 'Attest to all certifications [default]'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s k -l key -d 'Add the key or subkey KEY to the TARGET-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l expire -d 'Make adopted subkeys expire at the given time' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l allow-broken-crypto -d 'Allow adopting keys from certificates using broken cryptography'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List keys managed by the key store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a new key'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import keys into the key store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "password" -d 'Change password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "expire" -d 'Change expiration times'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "userid" -d 'Manage User IDs'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "subkey" -d 'Manage Subkeys'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "attest-certifications" -d 'Attest to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "adopt" -d 'Bind keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "add" -d 'Add a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "strip" -d 'Strip a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "add" -d 'Add a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "certify" -d 'Certify a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "link" -d 'Manage authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l show-paths -d 'Show why a binding is authenticated'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l show-paths -d 'Show why a binding is authenticated'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l show-paths -d 'Show why a binding is authenticated'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s d -l depth -d 'Set the trust depth' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s a -l amount -d 'Set the amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s r -l regex -d 'Add a regular expression to constrain what a trusted introducer can certify' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l expiry -d 'Define EXPIRY for the certification as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s l -l local -d 'Make the certification a local certification'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l non-revocable -d 'Mark the certification as being non-revocable'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l email -d 'Treat the given user ID as an email address.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l add-userid -d 'Add the given user ID if it doesn\'t exist.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l allow-not-alive-certifier -d 'Don\'t fail if the certificate making the certification is not alive.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l allow-revoked-certifier -d 'Don\'t fail if the certificate making the certification is revoked.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "retract" -d 'Retract links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s d -l depth -d 'Set the trust depth' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l ca -d 'Mark the certificate as a certification authority for a domain' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s a -l amount -d 'Set the amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s r -l regex -d 'Add a regular expression to constrain what a trusted introducer can certify' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l expiry -d 'Define EXPIRY for the acceptance as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l userid -d 'A User ID to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l email -d 'An email address to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l petname -d 'A User ID to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l temporary -d 'Temporarily accepts the binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l all -d 'Link all valid self-signed User ID to the certificate.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l notation -d 'Add a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l userid -d 'A User ID to unlink from the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l email -d 'An email address to unlink from the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l ca -d 'Only lists bindings linked as CAs.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "retract" -d 'Retract links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l show-paths -d 'Show why a binding is authenticated'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "certify" -d 'Certify a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "link" -d 'Manage authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "retract" -d 'Retract links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "list" -d 'List links'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Read Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "encode-sender" -d 'Encode a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l recipient-file -d 'Decrypt the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l session-key -d 'Decrypt an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l email -d 'Set the address [default: primary userid]' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l prefer-encrypt -d 'Set the prefer-encrypt attribute' -r -f -a "{nopreference	'',mutual	''}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Import Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Read Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "encode-sender" -d 'Encode a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "keyserver" -d 'Retrieve and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "wkd" -d 'Retrieve and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "dane" -d 'Retrieve and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s s -l server -d 'Set the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Write to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l all -d 'Fetch updates for all known certificates'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s s -l server -d 'Set the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "publish" -d 'Publish certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Write to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s s -l server -d 'Set the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l all -d 'Fetch updates for all known certificates'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s s -l server -d 'Set the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l require-all -d 'Require that all publish operations succeed and return an error otherwise.  By default we only require that one publish operation succeeds.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "publish" -d 'Publish certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "direct-url" -d 'Print the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Print the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s d -l direct-method -d 'Use the direct method [default: advanced method]'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s s -l skip -d 'Skip certificates that do not have User IDs for given domain.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Write to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l all -d 'Fetch updates for all known certificates'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "direct-url" -d 'Print the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Print the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l ttl -d 'Set the TTL (maximum cache duration) of the resource records' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l size-limit -d 'Try to shrink the certificates to this size' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l generic -d 'Emit generic resource records [default: OPENPGPKEY records]'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s s -l skip -d 'Skip expired certificates and those that do not have User IDs for given domain.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Write to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l all -d 'Fetch updates for all known certificates'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieve certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "keyserver" -d 'Retrieve and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "wkd" -d 'Retrieve and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "dane" -d 'Retrieve and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "fetch" -d 'Retrieve certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "publish" -d 'Publish certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "generate" -d 'Generate a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "fetch" -d 'Retrieve certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "direct-url" -d 'Print the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "url" -d 'Print the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "generate" -d 'Generate DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "fetch" -d 'Retrieve certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "keyring" -d 'Manage collections of keys or certs'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "extract-cert" -d 'Convert a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "armor" -d 'Convert binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "dearmor" -d 'Convert ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Split a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "merge" -d 'Merge keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "filter" -d 'Join keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l all-userids -d 'List all user ids'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s p -l prefix -d 'Write to files with PREFIX [defaults: `FILE-` if FILE is set, or `output-` if read from stdin]' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l userid -d 'Match on USERID' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l name -d 'Match on NAME' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l email -d 'Match on email ADDRESS' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l domain -d 'Match on email domain FQDN' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l handle -d 'Match on (sub)key fingerprints and key ids' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s P -l prune-certs -d 'Remove certificate components not matching the filter'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l to-cert -d 'Convert any keys in the input to certificates.  Converting a key to a certificate removes secret key material from the key thereby turning it into a certificate.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Split a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "merge" -d 'Merge keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "filter" -d 'Join keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from extract-cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "dump" -d 'List packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Unwrap an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Split a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "join" -d 'Join packets split across files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l session-key -d 'Decrypt an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l recipient-file -d 'Decrypt the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l mpis -d 'Print cryptographic artifacts'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s x -l hex -d 'Print a hexdump'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l recipient-file -d 'Decrypt the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l private-key-store -d 'Provide parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l session-key -d 'Decrypt an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Print the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s p -l prefix -d 'Write to files with PREFIX [defaults: `FILE-` if FILE is set, or `output-` if read from stdin]' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l label -d 'Select the kind of armor header' -r -f -a "{auto	'',message	'',cert	'',key	'',sig	'',file	''}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s B -l binary -d 'Emit binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "dump" -d 'List packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Unwrap an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Split a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "join" -d 'Join packets split across files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l label -d 'Select the kind of armor header' -r -f -a "{auto	'',message	'',cert	'',key	'',sig	'',file	''}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s o -l output -d 'Write to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "keyring" -d 'Manage collections of keys or certs'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "extract-cert" -d 'Convert a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "armor" -d 'Convert binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "dearmor" -d 'Convert ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "list" -d 'List keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "split" -d 'Split a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "merge" -d 'Merge keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "filter" -d 'Join keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "dump" -d 'List packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "decrypt" -d 'Unwrap an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "split" -d 'Split a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "join" -d 'Join packets split across files'
complete -c sq -n "__fish_seen_subcommand_from version" -l key-store -d 'Override the key store server and its data' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l cert-store -d 'Specify the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l pep-cert-store -d 'Specify the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l keyring -d 'Specify the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l output-format -d 'Produce output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from version" -l output-version -d 'Produce output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l known-notation -d 'Add NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l time -d 'Set the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l trust-root -d 'Consider the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l default-output-version -d 'List the default output version'
complete -c sq -n "__fish_seen_subcommand_from version" -l output-versions -d 'List all the supported output versions'
complete -c sq -n "__fish_seen_subcommand_from version" -s f -l force -d 'Overwrite existing files'
complete -c sq -n "__fish_seen_subcommand_from version" -l no-key-store -d 'Disable the use of the key store.'
complete -c sq -n "__fish_seen_subcommand_from version" -l no-cert-store -d 'Disable the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from version" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from version" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "encrypt" -d 'Encrypt a message'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Decrypt a message'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "sign" -d 'Sign messages or data files'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify signed messages or detached signatures'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "inspect" -d 'Inspect data, like file(1)'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "cert" -d 'Manage certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "key" -d 'Manage keys'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "pki" -d 'Authenticate certs using the Web of Trust'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "autocrypt" -d 'Communicate certificates using Autocrypt'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "network" -d 'Retrieve and publish certificates over the network'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "toolbox" -d 'Tools for developers, maintainers, and forensic specialists'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Detailed version and output version information'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint" -f -a "import" -d 'Import certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint" -f -a "export" -d 'Export certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from lint" -f -a "lint" -d 'Check certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "list" -d 'List keys managed by the key store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "generate" -d 'Generate a new key'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "import" -d 'Import keys into the key store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "password" -d 'Change password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "expire" -d 'Change expiration times'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "userid" -d 'Manage User IDs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "subkey" -d 'Manage Subkeys'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "attest-certifications" -d 'Attest to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from expire; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "adopt" -d 'Bind keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "add" -d 'Add a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "strip" -d 'Strip a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "add" -d 'Add a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "certify" -d 'Certify a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "link" -d 'Manage authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "retract" -d 'Retract links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "list" -d 'List links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "import" -d 'Import Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "decode" -d 'Read Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "encode-sender" -d 'Encode a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "fetch" -d 'Retrieve certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "keyserver" -d 'Retrieve and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "wkd" -d 'Retrieve and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "dane" -d 'Retrieve and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "fetch" -d 'Retrieve certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "publish" -d 'Publish certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "generate" -d 'Generate a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "fetch" -d 'Retrieve certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "direct-url" -d 'Print the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "url" -d 'Print the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "generate" -d 'Generate DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "fetch" -d 'Retrieve certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "keyring" -d 'Manage collections of keys or certs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "extract-cert" -d 'Convert a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "armor" -d 'Convert binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "dearmor" -d 'Convert ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "list" -d 'List keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "split" -d 'Split a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "merge" -d 'Merge keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter" -f -a "filter" -d 'Join keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "dump" -d 'List packets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "decrypt" -d 'Unwrap an encryption container'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "split" -d 'Split a message into packets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "join" -d 'Join packets split across files'
