"use strict";
/* eslint max-len: 0 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const dataType_1 = __importDefault(require("./dataType"));
const buffaloZclDataType_1 = __importDefault(require("./buffaloZclDataType"));
const status_1 = __importDefault(require("./status"));
const direction_1 = __importDefault(require("./direction"));
const Foundation = {
    /** Read Attributes */
    read: {
        ID: 0x00,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
        ],
        response: 0x01, // readRsp
    },
    /** Read Attributes Response */
    readRsp: {
        ID: 0x01,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'status', type: dataType_1.default.UINT8 },
            { name: 'dataType', type: dataType_1.default.UINT8, conditions: [{ type: 'statusEquals', value: status_1.default.SUCCESS }] },
            { name: 'attrData', type: buffaloZclDataType_1.default.USE_DATA_TYPE, conditions: [{ type: 'statusEquals', value: status_1.default.SUCCESS }] },
        ],
    },
    /** Write Attributes */
    write: {
        ID: 0x02,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'attrData', type: buffaloZclDataType_1.default.USE_DATA_TYPE },
        ],
        response: 0x04, // writeRsp
    },
    /** Write Attributes Undivided */
    writeUndiv: {
        ID: 0x03,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'attrData', type: buffaloZclDataType_1.default.USE_DATA_TYPE },
        ],
    },
    /** Write Attributes Response */
    writeRsp: {
        ID: 0x04,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'status', type: dataType_1.default.UINT8 },
            { name: 'attrId', type: dataType_1.default.UINT16, conditions: [{ type: 'statusNotEquals', value: status_1.default.SUCCESS }] },
        ],
    },
    /** Write Attributes No Response */
    writeNoRsp: {
        ID: 0x05,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'attrData', type: buffaloZclDataType_1.default.USE_DATA_TYPE },
        ],
    },
    /** Configure Reporting */
    configReport: {
        ID: 0x06,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'direction', type: dataType_1.default.UINT8 },
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'minRepIntval', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'maxRepIntval', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'repChange', type: buffaloZclDataType_1.default.USE_DATA_TYPE, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }, { type: 'dataTypeValueTypeEquals', value: 'ANALOG' }] },
            { name: 'timeout', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.SERVER_TO_CLIENT }] },
        ],
        response: 0x07, // configReportRsp
    },
    /** Configure Reporting Response */
    configReportRsp: {
        ID: 0x07,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'status', type: dataType_1.default.UINT8 },
            // minimumRemainingBufferBytes: if direction is present, attrId is also present
            // https://github.com/Koenkk/zigbee-herdsman/pull/115
            { name: 'direction', type: dataType_1.default.UINT8, conditions: [{ type: 'minimumRemainingBufferBytes', value: 3 }] },
            { name: 'attrId', type: dataType_1.default.UINT16, conditions: [{ type: 'minimumRemainingBufferBytes', value: 2 }] },
        ],
    },
    /** Read Reporting Configuration */
    readReportConfig: {
        ID: 0x08,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'direction', type: dataType_1.default.UINT8 },
            { name: 'attrId', type: dataType_1.default.UINT16 },
        ],
    },
    /** Read Reporting Configuration Response */
    readReportConfigRsp: {
        ID: 0x09,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'direction', type: dataType_1.default.UINT8 },
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'minRepIntval', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'maxRepIntval', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }] },
            { name: 'repChange', type: buffaloZclDataType_1.default.USE_DATA_TYPE, conditions: [{ type: 'directionEquals', value: direction_1.default.CLIENT_TO_SERVER }, { type: 'dataTypeValueTypeEquals', value: 'ANALOG' }] },
            { name: 'timeout', type: dataType_1.default.UINT16, conditions: [{ type: 'directionEquals', value: direction_1.default.SERVER_TO_CLIENT }] },
        ],
    },
    /** Report attributes */
    report: {
        ID: 0x0A,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'attrData', type: buffaloZclDataType_1.default.USE_DATA_TYPE },
        ],
    },
    /** Default Response */
    defaultRsp: {
        ID: 0x0B,
        parseStrategy: 'flat',
        parameters: [
            { name: 'cmdId', type: dataType_1.default.UINT8 },
            { name: 'statusCode', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Attributes */
    discover: {
        ID: 0x0C,
        parseStrategy: 'flat',
        parameters: [
            { name: 'startAttrId', type: dataType_1.default.UINT16 },
            { name: 'maxAttrIds', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Attributes Response */
    discoverRsp: {
        ID: 0x0D,
        parseStrategy: 'oneof',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
        ],
    },
    /** Read Attributes Structured */
    readStructured: {
        ID: 0x0E,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'selector', type: buffaloZclDataType_1.default.STRUCTURED_SELECTOR },
        ],
    },
    /** Write Attributes Structured */
    writeStructured: {
        ID: 0x0F,
        parseStrategy: 'repetitive',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'selector', type: buffaloZclDataType_1.default.STRUCTURED_SELECTOR },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'elementData', type: buffaloZclDataType_1.default.USE_DATA_TYPE },
        ],
        response: 0x10, // writeStructuredRsp
    },
    /** Write Attributes Structured response */
    writeStructuredRsp: {
        ID: 0x10,
        parseStrategy: 'repetitive',
        // contains only one SUCCESS record for all written attributes if all written successfully
        parameters: [
            { name: 'status', type: dataType_1.default.UINT8 },
            { name: 'attrId', type: dataType_1.default.UINT16, conditions: [{ type: 'statusNotEquals', value: status_1.default.SUCCESS }] },
            // always one zero-octet if failed attribute not of type array or structure, otherwise can also be zero if no info on which element caused failure
            { name: 'selector', type: buffaloZclDataType_1.default.STRUCTURED_SELECTOR, conditions: [{ type: 'statusNotEquals', value: status_1.default.SUCCESS }] },
        ],
    },
    /** Discover Commands Received */
    discoverCommands: {
        ID: 0x11,
        parseStrategy: 'flat',
        parameters: [
            { name: 'startCmdId', type: dataType_1.default.UINT8 },
            { name: 'maxCmdIds', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Commands Received Response */
    discoverCommandsRsp: {
        ID: 0x12,
        parseStrategy: 'oneof',
        parameters: [
            { name: 'cmdId', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Commands Generated */
    discoverCommandsGen: {
        ID: 0x13,
        parseStrategy: 'flat',
        parameters: [
            { name: 'startCmdId', type: dataType_1.default.UINT8 },
            { name: 'maxCmdIds', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Commands Generated Response */
    discoverCommandsGenRsp: {
        ID: 0x14,
        parseStrategy: 'oneof',
        parameters: [
            { name: 'cmdId', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Attributes Extended */
    discoverExt: {
        ID: 0x15,
        parseStrategy: 'flat',
        parameters: [
            { name: 'startAttrId', type: dataType_1.default.UINT16 },
            { name: 'maxAttrIds', type: dataType_1.default.UINT8 },
        ],
    },
    /** Discover Attributes Extended Response */
    discoverExtRsp: {
        ID: 0x16,
        parseStrategy: 'oneof',
        parameters: [
            { name: 'attrId', type: dataType_1.default.UINT16 },
            { name: 'dataType', type: dataType_1.default.UINT8 },
            { name: 'access', type: dataType_1.default.UINT8 },
        ],
    },
};
exports.default = Foundation;
//# sourceMappingURL=foundation.js.map