complete -c cargo-shuttle -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "init" -d 'Create a new Shuttle project'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "run" -d 'Run a Shuttle service locally'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "deploy" -d 'Deploy a Shuttle service'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "deployment" -d 'Manage deployments of a Shuttle service'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "status" -d 'View the status of a Shuttle service'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "stop" -d 'Stop this Shuttle service'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "logs" -d 'View the logs of a deployment in this Shuttle service'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "project" -d 'List or manage projects on Shuttle'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "resource" -d 'Manage resources of a Shuttle project'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "clean" -d 'Remove cargo build artifacts in the Shuttle environment'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "login" -d 'Login to the Shuttle platform'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "logout" -d 'Log out of the Shuttle platform'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "generate" -d 'Generate shell completions and man page'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "feedback" -d 'Open an issue on GitHub and provide feedback'
complete -c cargo-shuttle -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -s t -l template -d 'Clone a starter template from Shuttle\'s official examples' -r -f -a "{axum	'Axum - Modular web framework from the Tokio ecosystem',actix-web	'Actix Web - Powerful and fast web framework',rocket	'Rocket - Simple and easy-to-use web framework',loco	'Loco - Batteries included web framework based on Axum',salvo	'Salvo - Powerful and simple web framework',poem	'Poem - Full-featured and easy-to-use web framework',poise	'Poise - Discord Bot framework with good slash command support',serenity	'Serenity - Discord Bot framework',tower	'Tower - Modular service library',thruster	'Thruster - Web framework',tide	'Tide - Web framework',warp	'Warp - Web framework',none	'No template - Make a custom service'}"
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l from -d 'Clone a template from a git repository or local path using cargo-generate' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l subfolder -d 'Path to the template in the source (used with --from)' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l api-key -d 'API key for the Shuttle platform' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l force-name -d 'Don\'t check the project name\'s validity or availability and use it anyways'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l create-env -d 'Whether to start the container for this project on Shuttle, and claim the project name'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -l no-git -d 'Don\'t initialize a new git repository'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from init" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -s p -l port -d 'Port to start service on' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -l secrets -d 'Use this secrets file instead' -r -F
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -l external -d 'Use 0.0.0.0 instead of localhost (for usage with local external devices)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -s r -l release -d 'Use release mode for building the project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -l raw -d 'Don\'t display timestamps and log origin tags'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from run" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deploy" -l secrets -d 'Use this secrets file instead' -r -F
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deploy" -l allow-dirty -l ad -d 'Allow deployment with uncommitted files'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deploy" -l no-test -l nt -d 'Don\'t run pre-deploy tests'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deploy" -l raw -d 'Don\'t display timestamps and log origin tags'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deploy" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all the deployments for a service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "status" -d 'View status of a deployment'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from list" -l page -d 'Which page to display' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from list" -l limit -d 'How many projects per page to display' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from list" -l raw -d 'Output table without borders'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all the deployments for a service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "status" -d 'View status of a deployment'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from deployment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from stop" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -l head -d 'View the first N log lines' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -l tail -d 'View the last N log lines' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -s l -l latest -d 'View logs from the most recent deployment (which is not always the latest running one)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -s f -l follow -d 'Follow log output'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -l raw -d 'Don\'t display timestamps and log origin tags'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -l all -d 'View all log lines'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logs" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "start" -d 'Create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "status" -d 'Check the status of this project\'s environment on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "stop" -d 'Destroy this project\'s environment (container) on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "restart" -d 'Destroy and create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all projects you have access to'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a project and all linked data'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from start" -l idle-minutes -d 'How long to wait before putting the project in an idle state due to inactivity. 0 means the project will never idle' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from status" -s f -l follow -d 'Follow status of project command'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from restart" -l idle-minutes -d 'How long to wait before putting the project in an idle state due to inactivity. 0 means the project will never idle' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from restart" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from list" -l page -d '(deprecated) Which page to display' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from list" -l limit -d '(deprecated) How many projects per page to display' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from list" -l raw -d 'Output table without borders'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from delete" -s y -l yes -d 'Skip confirmations and proceed'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "start" -d 'Create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "status" -d 'Check the status of this project\'s environment on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "stop" -d 'Destroy this project\'s environment (container) on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "restart" -d 'Destroy and create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all projects you have access to'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a project and all linked data'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all the resources for a project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a resource'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from list" -l raw -d 'Output table without borders'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from list" -l show-secrets -d 'Show secrets from resources (e.g. a password in a connection string)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from delete" -s y -l yes -d 'Skip confirmations and proceed'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all the resources for a project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a resource'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from resource; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from login" -l api-key -d 'API key for the Shuttle platform' -r
complete -c cargo-shuttle -n "__fish_seen_subcommand_from login" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logout" -l reset-api-key -d 'Reset the API key before logging out'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from logout" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "shell" -d 'Generate shell completions'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "manpage" -d 'Generate man page to the standard output'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from shell" -s o -l output -d 'Output to a file (stdout by default)' -r -F
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from shell" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from manpage" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "shell" -d 'Generate shell completions'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "manpage" -d 'Generate man page to the standard output'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from generate; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from feedback" -s h -l help -d 'Print help'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Create a new Shuttle project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "run" -d 'Run a Shuttle service locally'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "deploy" -d 'Deploy a Shuttle service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "deployment" -d 'Manage deployments of a Shuttle service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "status" -d 'View the status of a Shuttle service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "stop" -d 'Stop this Shuttle service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "logs" -d 'View the logs of a deployment in this Shuttle service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "project" -d 'List or manage projects on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "resource" -d 'Manage resources of a Shuttle project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Remove cargo build artifacts in the Shuttle environment'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "login" -d 'Login to the Shuttle platform'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "logout" -d 'Log out of the Shuttle platform'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate shell completions and man page'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "feedback" -d 'Open an issue on GitHub and provide feedback'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from deploy; and not __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from logs; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from feedback; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status" -f -a "list" -d 'List all the deployments for a service'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from deployment; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from status" -f -a "status" -d 'View status of a deployment'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "start" -d 'Create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "status" -d 'Check the status of this project\'s environment on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "stop" -d 'Destroy this project\'s environment (container) on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "restart" -d 'Destroy and create an environment for this project on Shuttle'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "list" -d 'List all projects you have access to'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from start; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from stop; and not __fish_seen_subcommand_from restart; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "delete" -d 'Delete a project and all linked data'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "list" -d 'List all the resources for a project'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from resource; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from delete" -f -a "delete" -d 'Delete a resource'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage" -f -a "shell" -d 'Generate shell completions'
complete -c cargo-shuttle -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from manpage" -f -a "manpage" -d 'Generate man page to the standard output'
