/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ObjectXMLExporter;
import com.eteks.sweethome3d.io.XMLWriter;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.BoxBounds;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.HomeShelfUnit;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HomeXMLExporter
extends ObjectXMLExporter<Home> {
    private Map<Content, String> savedContentNames;
    private Map<Level, String> levelIds = new HashMap<Level, String>();
    private Map<Wall, String> wallIds = new HashMap<Wall, String>();

    void setSavedContentNames(Map<Content, String> map) {
        this.savedContentNames = map;
    }

    protected String getId(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Level) {
            return this.levelIds.get(object);
        }
        if (object instanceof Wall) {
            return this.wallIds.get(object);
        }
        throw new IllegalArgumentException("No Id provided for object of class " + object.getClass().getName());
    }

    @Override
    public void writeElement(XMLWriter xMLWriter, Home home) throws IOException {
        for (Level homeObject : home.getLevels()) {
            this.levelIds.put(homeObject, homeObject.getId());
        }
        for (Wall wall : home.getWalls()) {
            this.wallIds.put(wall, wall.getId());
        }
        super.writeElement(xMLWriter, home);
    }

    @Override
    protected void writeAttributes(XMLWriter xMLWriter, Home home) throws IOException {
        home.setVersion(7200L);
        xMLWriter.writeAttribute("version", String.valueOf(home.getVersion()));
        xMLWriter.writeAttribute("name", home.getName(), null);
        xMLWriter.writeAttribute("camera", home.getCamera() == home.getObserverCamera() ? "observerCamera" : "topCamera");
        xMLWriter.writeAttribute("selectedLevel", this.getId(home.getSelectedLevel()), null);
        xMLWriter.writeFloatAttribute("wallHeight", home.getWallHeight());
        xMLWriter.writeBooleanAttribute("basePlanLocked", home.isBasePlanLocked(), false);
        if (home.getFurnitureSortedPropertyName() != null) {
            xMLWriter.writeAttribute("furnitureSortedProperty", home.getFurnitureSortedPropertyName());
        }
        xMLWriter.writeBooleanAttribute("furnitureDescendingSorted", home.isFurnitureDescendingSorted(), false);
    }

    @Override
    protected void writeChildren(XMLWriter xMLWriter, Home home) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(home.getPropertyNames());
        Collections.sort(arrayList);
        for (String object : arrayList) {
            this.writeProperty(xMLWriter, home, object, home.getProperty(object), false);
        }
        for (String string : home.getFurnitureVisiblePropertyNames()) {
            xMLWriter.writeStartElement("furnitureVisibleProperty");
            xMLWriter.writeAttribute("name", string);
            xMLWriter.writeEndElement();
        }
        this.writeEnvironment(xMLWriter, home.getEnvironment());
        this.writeBackgroundImage(xMLWriter, home.getBackgroundImage());
        this.writePrint(xMLWriter, home.getPrint());
        this.writeCompass(xMLWriter, home.getCompass());
        this.writeCamera(xMLWriter, home.getObserverCamera(), "observerCamera");
        this.writeCamera(xMLWriter, home.getTopCamera(), "topCamera");
        for (Camera camera : home.getStoredCameras()) {
            this.writeCamera(xMLWriter, camera, "storedCamera");
        }
        for (Level level : home.getLevels()) {
            this.writeLevel(xMLWriter, level);
        }
        for (HomePieceOfFurniture homePieceOfFurniture : home.getFurniture()) {
            this.writePieceOfFurniture(xMLWriter, homePieceOfFurniture);
        }
        for (Wall wall : home.getWalls()) {
            this.writeWall(xMLWriter, wall);
        }
        for (Room room : home.getRooms()) {
            this.writeRoom(xMLWriter, room);
        }
        for (Polyline polyline : home.getPolylines()) {
            this.writePolyline(xMLWriter, polyline);
        }
        for (DimensionLine dimensionLine : home.getDimensionLines()) {
            this.writeDimensionLine(xMLWriter, dimensionLine);
        }
        for (Label label : home.getLabels()) {
            this.writeLabel(xMLWriter, label);
        }
    }

    protected void writeEnvironment(XMLWriter xMLWriter, HomeEnvironment homeEnvironment) throws IOException {
        new ObjectXMLExporter<HomeEnvironment>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, HomeEnvironment homeEnvironment) throws IOException {
                xMLWriter.writeColorAttribute("groundColor", homeEnvironment.getGroundColor());
                xMLWriter.writeBooleanAttribute("backgroundImageVisibleOnGround3D", homeEnvironment.isBackgroundImageVisibleOnGround3D(), false);
                xMLWriter.writeColorAttribute("skyColor", homeEnvironment.getSkyColor());
                xMLWriter.writeColorAttribute("lightColor", homeEnvironment.getLightColor());
                xMLWriter.writeFloatAttribute("wallsAlpha", homeEnvironment.getWallsAlpha(), 0.0f);
                xMLWriter.writeBooleanAttribute("allLevelsVisible", homeEnvironment.isAllLevelsVisible(), false);
                xMLWriter.writeBooleanAttribute("observerCameraElevationAdjusted", homeEnvironment.isObserverCameraElevationAdjusted(), true);
                xMLWriter.writeColorAttribute("ceillingLightColor", homeEnvironment.getCeillingLightColor());
                xMLWriter.writeAttribute("drawingMode", homeEnvironment.getDrawingMode().name(), HomeEnvironment.DrawingMode.FILL.name());
                xMLWriter.writeFloatAttribute("subpartSizeUnderLight", homeEnvironment.getSubpartSizeUnderLight(), 0.0f);
                xMLWriter.writeIntegerAttribute("photoWidth", homeEnvironment.getPhotoWidth());
                xMLWriter.writeIntegerAttribute("photoHeight", homeEnvironment.getPhotoHeight());
                xMLWriter.writeAttribute("photoAspectRatio", homeEnvironment.getPhotoAspectRatio().name());
                xMLWriter.writeIntegerAttribute("photoQuality", homeEnvironment.getPhotoQuality());
                xMLWriter.writeIntegerAttribute("videoWidth", homeEnvironment.getVideoWidth());
                xMLWriter.writeAttribute("videoAspectRatio", homeEnvironment.getVideoAspectRatio().name());
                xMLWriter.writeIntegerAttribute("videoQuality", homeEnvironment.getVideoQuality());
                xMLWriter.writeFloatAttribute("videoSpeed", homeEnvironment.getVideoSpeed(), 0.6666667f);
                xMLWriter.writeIntegerAttribute("videoFrameRate", homeEnvironment.getVideoFrameRate());
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, HomeEnvironment homeEnvironment) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, homeEnvironment);
                if (!homeEnvironment.getVideoCameraPath().isEmpty()) {
                    for (Camera camera : homeEnvironment.getVideoCameraPath()) {
                        HomeXMLExporter.this.writeCamera(xMLWriter, camera, "cameraPath");
                    }
                }
                HomeXMLExporter.this.writeTexture(xMLWriter, homeEnvironment.getGroundTexture(), "groundTexture");
                HomeXMLExporter.this.writeTexture(xMLWriter, homeEnvironment.getSkyTexture(), "skyTexture");
            }
        }.writeElement(xMLWriter, homeEnvironment);
    }

    protected void writeBackgroundImage(XMLWriter xMLWriter, BackgroundImage backgroundImage) throws IOException {
        if (backgroundImage != null) {
            new ObjectXMLExporter<BackgroundImage>(){

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, BackgroundImage backgroundImage) throws IOException {
                    xMLWriter.writeAttribute("image", HomeXMLExporter.this.getExportedContentName(backgroundImage, backgroundImage.getImage()), null);
                    xMLWriter.writeFloatAttribute("scaleDistance", backgroundImage.getScaleDistance());
                    xMLWriter.writeFloatAttribute("scaleDistanceXStart", backgroundImage.getScaleDistanceXStart());
                    xMLWriter.writeFloatAttribute("scaleDistanceYStart", backgroundImage.getScaleDistanceYStart());
                    xMLWriter.writeFloatAttribute("scaleDistanceXEnd", backgroundImage.getScaleDistanceXEnd());
                    xMLWriter.writeFloatAttribute("scaleDistanceYEnd", backgroundImage.getScaleDistanceYEnd());
                    xMLWriter.writeFloatAttribute("xOrigin", backgroundImage.getXOrigin(), 0.0f);
                    xMLWriter.writeFloatAttribute("yOrigin", backgroundImage.getYOrigin(), 0.0f);
                    xMLWriter.writeBooleanAttribute("visible", backgroundImage.isVisible(), true);
                }
            }.writeElement(xMLWriter, backgroundImage);
        }
    }

    protected void writePrint(XMLWriter xMLWriter, HomePrint homePrint) throws IOException {
        if (homePrint != null) {
            new ObjectXMLExporter<HomePrint>(){

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, HomePrint homePrint) throws IOException {
                    xMLWriter.writeAttribute("headerFormat", homePrint.getHeaderFormat(), null);
                    xMLWriter.writeAttribute("footerFormat", homePrint.getFooterFormat(), null);
                    xMLWriter.writeBooleanAttribute("furniturePrinted", homePrint.isFurniturePrinted(), true);
                    xMLWriter.writeBooleanAttribute("planPrinted", homePrint.isPlanPrinted(), true);
                    xMLWriter.writeBooleanAttribute("view3DPrinted", homePrint.isView3DPrinted(), true);
                    xMLWriter.writeFloatAttribute("planScale", homePrint.getPlanScale());
                    xMLWriter.writeFloatAttribute("paperWidth", homePrint.getPaperWidth());
                    xMLWriter.writeFloatAttribute("paperHeight", homePrint.getPaperHeight());
                    xMLWriter.writeFloatAttribute("paperTopMargin", homePrint.getPaperTopMargin());
                    xMLWriter.writeFloatAttribute("paperLeftMargin", homePrint.getPaperLeftMargin());
                    xMLWriter.writeFloatAttribute("paperBottomMargin", homePrint.getPaperBottomMargin());
                    xMLWriter.writeFloatAttribute("paperRightMargin", homePrint.getPaperRightMargin());
                    xMLWriter.writeAttribute("paperOrientation", homePrint.getPaperOrientation().name());
                }

                @Override
                protected void writeChildren(XMLWriter xMLWriter, HomePrint homePrint) throws IOException {
                    List<Level> list = homePrint.getPrintedLevels();
                    if (list != null) {
                        for (Level level : list) {
                            xMLWriter.writeStartElement("printedLevel");
                            xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(level));
                            xMLWriter.writeEndElement();
                        }
                    }
                }
            }.writeElement(xMLWriter, homePrint);
        }
    }

    protected void writeCompass(XMLWriter xMLWriter, Compass compass) throws IOException {
        new ObjectXMLExporter<Compass>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Compass compass) throws IOException {
                xMLWriter.writeFloatAttribute("x", compass.getX());
                xMLWriter.writeFloatAttribute("y", compass.getY());
                xMLWriter.writeFloatAttribute("diameter", compass.getDiameter());
                xMLWriter.writeFloatAttribute("northDirection", compass.getNorthDirection());
                xMLWriter.writeFloatAttribute("longitude", compass.getLongitude());
                xMLWriter.writeFloatAttribute("latitude", compass.getLatitude());
                xMLWriter.writeAttribute("timeZone", compass.getTimeZone());
                xMLWriter.writeBooleanAttribute("visible", compass.isVisible(), true);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Compass compass) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, compass);
            }
        }.writeElement(xMLWriter, compass);
    }

    protected void writeCamera(XMLWriter xMLWriter, Camera camera, final String string) throws IOException {
        if (camera != null) {
            new ObjectXMLExporter<Camera>(this){
                final /* synthetic */ HomeXMLExporter this$0;
                {
                    this.this$0 = homeXMLExporter;
                }

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, Camera camera) throws IOException {
                    xMLWriter.writeAttribute("attribute", string, null);
                    if (!"observerCamera".equals(string) && !"topCamera".equals(string)) {
                        xMLWriter.writeAttribute("id", camera.getId());
                    }
                    xMLWriter.writeAttribute("name", camera.getName(), null);
                    xMLWriter.writeAttribute("lens", camera.getLens().name());
                    xMLWriter.writeFloatAttribute("x", camera.getX());
                    xMLWriter.writeFloatAttribute("y", camera.getY());
                    xMLWriter.writeFloatAttribute("z", camera.getZ());
                    xMLWriter.writeFloatAttribute("yaw", camera.getYaw());
                    xMLWriter.writeFloatAttribute("pitch", camera.getPitch());
                    xMLWriter.writeFloatAttribute("fieldOfView", camera.getFieldOfView());
                    xMLWriter.writeLongAttribute("time", camera.getTime());
                    if (camera instanceof ObserverCamera) {
                        xMLWriter.writeBooleanAttribute("fixedSize", ((ObserverCamera)camera).isFixedSize(), false);
                    }
                    xMLWriter.writeAttribute("renderer", camera.getRenderer(), null);
                }

                @Override
                protected void writeChildren(XMLWriter xMLWriter, Camera camera) throws IOException {
                    this.this$0.writeProperties(xMLWriter, camera);
                }
            }.writeElement(xMLWriter, camera);
        }
    }

    protected void writeLevel(XMLWriter xMLWriter, Level level) throws IOException {
        new ObjectXMLExporter<Level>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Level level) throws IOException {
                xMLWriter.writeAttribute("id", level.getId());
                xMLWriter.writeAttribute("name", level.getName());
                xMLWriter.writeFloatAttribute("elevation", level.getElevation());
                xMLWriter.writeFloatAttribute("floorThickness", level.getFloorThickness());
                xMLWriter.writeFloatAttribute("height", level.getHeight());
                xMLWriter.writeIntegerAttribute("elevationIndex", level.getElevationIndex());
                xMLWriter.writeBooleanAttribute("visible", level.isVisible(), true);
                xMLWriter.writeBooleanAttribute("viewable", level.isViewable(), true);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Level level) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, level);
                HomeXMLExporter.this.writeBackgroundImage(xMLWriter, level.getBackgroundImage());
            }
        }.writeElement(xMLWriter, level);
    }

    protected void writePieceOfFurniture(XMLWriter xMLWriter, HomePieceOfFurniture homePieceOfFurniture) throws IOException {
        new PieceOfFurnitureExporter().writeElement(xMLWriter, homePieceOfFurniture);
    }

    protected void writeMaterial(XMLWriter xMLWriter, HomeMaterial homeMaterial, Content content) throws IOException {
        if (homeMaterial != null) {
            new ObjectXMLExporter<HomeMaterial>(){

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, HomeMaterial homeMaterial) throws IOException {
                    xMLWriter.writeAttribute("name", homeMaterial.getName());
                    xMLWriter.writeAttribute("key", homeMaterial.getKey(), null);
                    xMLWriter.writeColorAttribute("color", homeMaterial.getColor());
                    if (homeMaterial.getShininess() != null) {
                        xMLWriter.writeFloatAttribute("shininess", homeMaterial.getShininess());
                    }
                }

                @Override
                protected void writeChildren(XMLWriter xMLWriter, HomeMaterial homeMaterial) throws IOException {
                    HomeXMLExporter.this.writeTexture(xMLWriter, homeMaterial.getTexture(), null);
                }
            }.writeElement(xMLWriter, homeMaterial);
        }
    }

    protected void writeWall(XMLWriter xMLWriter, Wall wall) throws IOException {
        new ObjectXMLExporter<Wall>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Wall wall) throws IOException {
                String string;
                xMLWriter.writeAttribute("id", wall.getId());
                if (wall.getLevel() != null) {
                    xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(wall.getLevel()));
                }
                if (wall.getWallAtStart() != null && (string = HomeXMLExporter.this.getId(wall.getWallAtStart())) != null) {
                    xMLWriter.writeAttribute("wallAtStart", string);
                }
                if (wall.getWallAtEnd() != null && (string = HomeXMLExporter.this.getId(wall.getWallAtEnd())) != null) {
                    xMLWriter.writeAttribute("wallAtEnd", string);
                }
                xMLWriter.writeFloatAttribute("xStart", wall.getXStart());
                xMLWriter.writeFloatAttribute("yStart", wall.getYStart());
                xMLWriter.writeFloatAttribute("xEnd", wall.getXEnd());
                xMLWriter.writeFloatAttribute("yEnd", wall.getYEnd());
                xMLWriter.writeFloatAttribute("height", wall.getHeight());
                xMLWriter.writeFloatAttribute("heightAtEnd", wall.getHeightAtEnd());
                xMLWriter.writeFloatAttribute("thickness", wall.getThickness());
                xMLWriter.writeFloatAttribute("arcExtent", wall.getArcExtent());
                if (wall.getPattern() != null) {
                    xMLWriter.writeAttribute("pattern", wall.getPattern().getName());
                }
                xMLWriter.writeColorAttribute("topColor", wall.getTopColor());
                xMLWriter.writeColorAttribute("leftSideColor", wall.getLeftSideColor());
                xMLWriter.writeFloatAttribute("leftSideShininess", wall.getLeftSideShininess(), 0.0f);
                xMLWriter.writeColorAttribute("rightSideColor", wall.getRightSideColor());
                xMLWriter.writeFloatAttribute("rightSideShininess", wall.getRightSideShininess(), 0.0f);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Wall wall) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, wall);
                HomeXMLExporter.this.writeTexture(xMLWriter, wall.getLeftSideTexture(), "leftSideTexture");
                HomeXMLExporter.this.writeTexture(xMLWriter, wall.getRightSideTexture(), "rightSideTexture");
                HomeXMLExporter.this.writeBaseboard(xMLWriter, wall.getLeftSideBaseboard(), "leftSideBaseboard");
                HomeXMLExporter.this.writeBaseboard(xMLWriter, wall.getRightSideBaseboard(), "rightSideBaseboard");
            }
        }.writeElement(xMLWriter, wall);
    }

    protected void writeRoom(XMLWriter xMLWriter, Room room) throws IOException {
        new ObjectXMLExporter<Room>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Room room) throws IOException {
                xMLWriter.writeAttribute("id", room.getId());
                if (room.getLevel() != null) {
                    xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(room.getLevel()));
                }
                xMLWriter.writeAttribute("name", room.getName(), null);
                xMLWriter.writeFloatAttribute("nameAngle", room.getNameAngle(), 0.0f);
                xMLWriter.writeFloatAttribute("nameXOffset", room.getNameXOffset(), 0.0f);
                xMLWriter.writeFloatAttribute("nameYOffset", room.getNameYOffset(), -40.0f);
                xMLWriter.writeBooleanAttribute("areaVisible", room.isAreaVisible(), false);
                xMLWriter.writeFloatAttribute("areaAngle", room.getAreaAngle(), 0.0f);
                xMLWriter.writeFloatAttribute("areaXOffset", room.getAreaXOffset(), 0.0f);
                xMLWriter.writeFloatAttribute("areaYOffset", room.getAreaYOffset(), 0.0f);
                xMLWriter.writeBooleanAttribute("floorVisible", room.isFloorVisible(), true);
                xMLWriter.writeColorAttribute("floorColor", room.getFloorColor());
                xMLWriter.writeFloatAttribute("floorShininess", room.getFloorShininess(), 0.0f);
                xMLWriter.writeBooleanAttribute("ceilingVisible", room.isCeilingVisible(), true);
                xMLWriter.writeColorAttribute("ceilingColor", room.getCeilingColor());
                xMLWriter.writeFloatAttribute("ceilingShininess", room.getCeilingShininess(), 0.0f);
                xMLWriter.writeBooleanAttribute("ceilingFlat", room.isCeilingFlat(), false);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Room room) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, room);
                HomeXMLExporter.this.writeTextStyle(xMLWriter, room.getNameStyle(), "nameStyle");
                HomeXMLExporter.this.writeTextStyle(xMLWriter, room.getAreaStyle(), "areaStyle");
                HomeXMLExporter.this.writeTexture(xMLWriter, room.getFloorTexture(), "floorTexture");
                HomeXMLExporter.this.writeTexture(xMLWriter, room.getCeilingTexture(), "ceilingTexture");
                for (float[] fArray : room.getPoints()) {
                    xMLWriter.writeStartElement("point");
                    xMLWriter.writeFloatAttribute("x", fArray[0]);
                    xMLWriter.writeFloatAttribute("y", fArray[1]);
                    xMLWriter.writeEndElement();
                }
            }
        }.writeElement(xMLWriter, room);
    }

    protected void writePolyline(XMLWriter xMLWriter, Polyline polyline) throws IOException {
        new ObjectXMLExporter<Polyline>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Polyline polyline) throws IOException {
                xMLWriter.writeAttribute("id", polyline.getId());
                if (polyline.getLevel() != null) {
                    xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(polyline.getLevel()));
                }
                xMLWriter.writeFloatAttribute("thickness", polyline.getThickness(), 1.0f);
                xMLWriter.writeAttribute("capStyle", polyline.getCapStyle().name(), Polyline.CapStyle.BUTT.name());
                xMLWriter.writeAttribute("joinStyle", polyline.getJoinStyle().name(), Polyline.JoinStyle.MITER.name());
                xMLWriter.writeAttribute("dashStyle", polyline.getDashStyle().name(), Polyline.DashStyle.SOLID.name());
                if (polyline.getDashStyle() == Polyline.DashStyle.CUSTOMIZED) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (float f : polyline.getDashPattern()) {
                        stringBuilder.append(HomeXMLExporter.floatToString(f));
                        stringBuilder.append(" ");
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    xMLWriter.writeAttribute("dashPattern", stringBuilder.toString());
                }
                xMLWriter.writeFloatAttribute("dashOffset", polyline.getDashOffset(), 0.0f);
                xMLWriter.writeAttribute("startArrowStyle", polyline.getStartArrowStyle().name(), Polyline.ArrowStyle.NONE.name());
                xMLWriter.writeAttribute("endArrowStyle", polyline.getEndArrowStyle().name(), Polyline.ArrowStyle.NONE.name());
                if (polyline.isVisibleIn3D()) {
                    xMLWriter.writeFloatAttribute("elevation", polyline.getElevation());
                }
                xMLWriter.writeColorAttribute("color", polyline.getColor());
                xMLWriter.writeBooleanAttribute("closedPath", polyline.isClosedPath(), false);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Polyline polyline) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, polyline);
                for (float[] fArray : polyline.getPoints()) {
                    xMLWriter.writeStartElement("point");
                    xMLWriter.writeFloatAttribute("x", fArray[0]);
                    xMLWriter.writeFloatAttribute("y", fArray[1]);
                    xMLWriter.writeEndElement();
                }
            }
        }.writeElement(xMLWriter, polyline);
    }

    protected void writeDimensionLine(XMLWriter xMLWriter, DimensionLine dimensionLine) throws IOException {
        new ObjectXMLExporter<DimensionLine>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, DimensionLine dimensionLine) throws IOException {
                xMLWriter.writeAttribute("id", dimensionLine.getId());
                if (dimensionLine.getLevel() != null) {
                    xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(dimensionLine.getLevel()));
                }
                xMLWriter.writeFloatAttribute("xStart", dimensionLine.getXStart());
                xMLWriter.writeFloatAttribute("yStart", dimensionLine.getYStart());
                xMLWriter.writeFloatAttribute("elevationStart", dimensionLine.getElevationStart(), 0.0f);
                xMLWriter.writeFloatAttribute("xEnd", dimensionLine.getXEnd());
                xMLWriter.writeFloatAttribute("yEnd", dimensionLine.getYEnd());
                xMLWriter.writeFloatAttribute("elevationEnd", dimensionLine.getElevationEnd(), 0.0f);
                xMLWriter.writeFloatAttribute("offset", dimensionLine.getOffset());
                xMLWriter.writeFloatAttribute("endMarkSize", dimensionLine.getEndMarkSize(), 10.0f);
                xMLWriter.writeFloatAttribute("pitch", dimensionLine.getPitch(), 0.0f);
                xMLWriter.writeColorAttribute("color", dimensionLine.getColor());
                xMLWriter.writeBooleanAttribute("visibleIn3D", dimensionLine.isVisibleIn3D(), false);
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, DimensionLine dimensionLine) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, dimensionLine);
                HomeXMLExporter.this.writeTextStyle(xMLWriter, dimensionLine.getLengthStyle(), "lengthStyle");
            }
        }.writeElement(xMLWriter, dimensionLine);
    }

    protected void writeLabel(XMLWriter xMLWriter, Label label) throws IOException {
        new ObjectXMLExporter<Label>(){

            @Override
            protected void writeAttributes(XMLWriter xMLWriter, Label label) throws IOException {
                xMLWriter.writeAttribute("id", label.getId());
                if (label.getLevel() != null) {
                    xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(label.getLevel()));
                }
                xMLWriter.writeFloatAttribute("x", label.getX());
                xMLWriter.writeFloatAttribute("y", label.getY());
                xMLWriter.writeFloatAttribute("angle", label.getAngle(), 0.0f);
                xMLWriter.writeFloatAttribute("elevation", label.getElevation(), 0.0f);
                xMLWriter.writeFloatAttribute("pitch", label.getPitch());
                xMLWriter.writeColorAttribute("color", label.getColor());
                xMLWriter.writeColorAttribute("outlineColor", label.getOutlineColor());
            }

            @Override
            protected void writeChildren(XMLWriter xMLWriter, Label label) throws IOException {
                HomeXMLExporter.this.writeProperties(xMLWriter, label);
                HomeXMLExporter.this.writeTextStyle(xMLWriter, label.getStyle(), null);
                xMLWriter.writeStartElement("text");
                xMLWriter.writeText(label.getText());
                xMLWriter.writeEndElement();
            }
        }.writeElement(xMLWriter, label);
    }

    protected void writeTextStyle(XMLWriter xMLWriter, TextStyle textStyle, final String string) throws IOException {
        if (textStyle != null) {
            new ObjectXMLExporter<TextStyle>(this){
                final /* synthetic */ HomeXMLExporter this$0;
                {
                    this.this$0 = homeXMLExporter;
                }

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, TextStyle textStyle) throws IOException {
                    xMLWriter.writeAttribute("attribute", string, null);
                    xMLWriter.writeAttribute("fontName", textStyle.getFontName(), null);
                    xMLWriter.writeFloatAttribute("fontSize", textStyle.getFontSize());
                    xMLWriter.writeBooleanAttribute("bold", textStyle.isBold(), false);
                    xMLWriter.writeBooleanAttribute("italic", textStyle.isItalic(), false);
                    xMLWriter.writeAttribute("alignment", textStyle.getAlignment().name(), TextStyle.Alignment.CENTER.name());
                }
            }.writeElement(xMLWriter, textStyle);
        }
    }

    protected void writeBaseboard(XMLWriter xMLWriter, Baseboard baseboard, final String string) throws IOException {
        if (baseboard != null) {
            new ObjectXMLExporter<Baseboard>(this){
                final /* synthetic */ HomeXMLExporter this$0;
                {
                    this.this$0 = homeXMLExporter;
                }

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, Baseboard baseboard) throws IOException {
                    xMLWriter.writeAttribute("attribute", string, null);
                    xMLWriter.writeFloatAttribute("thickness", baseboard.getThickness());
                    xMLWriter.writeFloatAttribute("height", baseboard.getHeight());
                    xMLWriter.writeColorAttribute("color", baseboard.getColor());
                }

                @Override
                protected void writeChildren(XMLWriter xMLWriter, Baseboard baseboard) throws IOException {
                    this.this$0.writeTexture(xMLWriter, baseboard.getTexture(), null);
                }
            }.writeElement(xMLWriter, baseboard);
        }
    }

    protected void writeTexture(XMLWriter xMLWriter, HomeTexture homeTexture, final String string) throws IOException {
        if (homeTexture != null) {
            new ObjectXMLExporter<HomeTexture>(this){
                final /* synthetic */ HomeXMLExporter this$0;
                {
                    this.this$0 = homeXMLExporter;
                }

                @Override
                protected void writeAttributes(XMLWriter xMLWriter, HomeTexture homeTexture) throws IOException {
                    xMLWriter.writeAttribute("attribute", string, null);
                    xMLWriter.writeAttribute("name", homeTexture.getName(), null);
                    xMLWriter.writeAttribute("creator", homeTexture.getCreator(), null);
                    xMLWriter.writeAttribute("catalogId", homeTexture.getCatalogId(), null);
                    xMLWriter.writeFloatAttribute("width", homeTexture.getWidth());
                    xMLWriter.writeFloatAttribute("height", homeTexture.getHeight());
                    xMLWriter.writeFloatAttribute("xOffset", homeTexture.getXOffset(), 0.0f);
                    xMLWriter.writeFloatAttribute("yOffset", homeTexture.getYOffset(), 0.0f);
                    xMLWriter.writeFloatAttribute("angle", homeTexture.getAngle(), 0.0f);
                    xMLWriter.writeFloatAttribute("scale", homeTexture.getScale(), 1.0f);
                    xMLWriter.writeBooleanAttribute("fittingArea", homeTexture.isFittingArea(), false);
                    xMLWriter.writeBooleanAttribute("leftToRightOriented", homeTexture.isLeftToRightOriented(), true);
                    xMLWriter.writeAttribute("image", this.this$0.getExportedContentName(homeTexture, homeTexture.getImage()), null);
                }
            }.writeElement(xMLWriter, homeTexture);
        }
    }

    private void writeProperties(XMLWriter xMLWriter, HomeObject homeObject) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(homeObject.getPropertyNames());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            boolean bl = homeObject.isContentProperty(string = (String)iterator.next());
            this.writeProperty(xMLWriter, homeObject, string, bl ? homeObject.getContentProperty(string) : homeObject.getProperty(string), bl);
        }
    }

    private void writeProperty(XMLWriter xMLWriter, Object object, String string, Object object2, boolean bl) throws IOException {
        if (object2 != null) {
            xMLWriter.writeStartElement("property");
            xMLWriter.writeAttribute("name", string);
            xMLWriter.writeAttribute("value", bl ? this.getExportedContentName(object, (Content)object2) : object2.toString());
            if (bl) {
                xMLWriter.writeAttribute("type", ObjectProperty.Type.CONTENT.name());
            }
            xMLWriter.writeEndElement();
        }
    }

    private static String floatToString(float f) {
        if ((double)Math.abs(f) < 1.0E-6) {
            return "0";
        }
        if ((double)Math.abs(f - 1.0f) < 1.0E-6) {
            return "1";
        }
        if ((double)Math.abs(f + 1.0f) < 1.0E-6) {
            return "-1";
        }
        return String.valueOf(f);
    }

    protected String getExportedContentName(Object object, Content content) {
        if (content == null || this.savedContentNames == null) {
            return null;
        }
        String string = this.savedContentNames.get(content);
        if (string != null) {
            return string;
        }
        if (content instanceof URLContent) {
            URLContent uRLContent = (URLContent)content;
            if (uRLContent.isJAREntry()) {
                return uRLContent.getURL().getProtocol() + ":" + uRLContent.getURL().getFile();
            }
            return uRLContent.getURL().toString();
        }
        return content.toString();
    }

    protected class PieceOfFurnitureExporter
    extends ObjectXMLExporter<HomePieceOfFurniture> {
        @Override
        protected void writeAttributes(XMLWriter xMLWriter, HomePieceOfFurniture homePieceOfFurniture) throws IOException {
            Serializable serializable;
            xMLWriter.writeAttribute("id", homePieceOfFurniture.getId());
            if (homePieceOfFurniture.getLevel() != null) {
                xMLWriter.writeAttribute("level", HomeXMLExporter.this.getId(homePieceOfFurniture.getLevel()));
            }
            xMLWriter.writeAttribute("catalogId", homePieceOfFurniture.getCatalogId(), null);
            xMLWriter.writeAttribute("name", homePieceOfFurniture.getName());
            xMLWriter.writeAttribute("creator", homePieceOfFurniture.getCreator(), null);
            xMLWriter.writeAttribute("model", HomeXMLExporter.this.getExportedContentName(homePieceOfFurniture, homePieceOfFurniture.getModel()), null);
            xMLWriter.writeAttribute("icon", HomeXMLExporter.this.getExportedContentName(homePieceOfFurniture, homePieceOfFurniture.getIcon()), null);
            xMLWriter.writeAttribute("planIcon", HomeXMLExporter.this.getExportedContentName(homePieceOfFurniture, homePieceOfFurniture.getPlanIcon()), null);
            xMLWriter.writeFloatAttribute("x", homePieceOfFurniture.getX());
            xMLWriter.writeFloatAttribute("y", homePieceOfFurniture.getY());
            xMLWriter.writeFloatAttribute("elevation", homePieceOfFurniture.getElevation(), 0.0f);
            xMLWriter.writeFloatAttribute("angle", homePieceOfFurniture.getAngle(), 0.0f);
            xMLWriter.writeFloatAttribute("pitch", homePieceOfFurniture.getPitch(), 0.0f);
            xMLWriter.writeFloatAttribute("roll", homePieceOfFurniture.getRoll(), 0.0f);
            xMLWriter.writeFloatAttribute("width", homePieceOfFurniture.getWidth());
            xMLWriter.writeFloatAttribute("widthInPlan", homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getWidth());
            xMLWriter.writeFloatAttribute("depth", homePieceOfFurniture.getDepth());
            xMLWriter.writeFloatAttribute("depthInPlan", homePieceOfFurniture.getDepthInPlan(), homePieceOfFurniture.getDepth());
            xMLWriter.writeFloatAttribute("height", homePieceOfFurniture.getHeight());
            xMLWriter.writeFloatAttribute("heightInPlan", homePieceOfFurniture.getHeightInPlan(), homePieceOfFurniture.getHeight());
            xMLWriter.writeIntegerAttribute("modelFlags", homePieceOfFurniture.getModelFlags(), 0);
            xMLWriter.writeBooleanAttribute("modelMirrored", homePieceOfFurniture.isModelMirrored(), false);
            xMLWriter.writeBooleanAttribute("visible", homePieceOfFurniture.isVisible(), true);
            xMLWriter.writeColorAttribute("color", homePieceOfFurniture.getColor());
            if (homePieceOfFurniture.getShininess() != null) {
                xMLWriter.writeFloatAttribute("shininess", homePieceOfFurniture.getShininess());
            }
            float[][] fArray = homePieceOfFurniture.getModelRotation();
            String string = HomeXMLExporter.floatToString(fArray[0][0]) + " " + HomeXMLExporter.floatToString(fArray[0][1]) + " " + HomeXMLExporter.floatToString(fArray[0][2]) + " " + HomeXMLExporter.floatToString(fArray[1][0]) + " " + HomeXMLExporter.floatToString(fArray[1][1]) + " " + HomeXMLExporter.floatToString(fArray[1][2]) + " " + HomeXMLExporter.floatToString(fArray[2][0]) + " " + HomeXMLExporter.floatToString(fArray[2][1]) + " " + HomeXMLExporter.floatToString(fArray[2][2]);
            xMLWriter.writeAttribute("modelRotation", string, "1 0 0 0 1 0 0 0 1");
            xMLWriter.writeBooleanAttribute("modelCenteredAtOrigin", homePieceOfFurniture.isModelCenteredAtOrigin(), true);
            xMLWriter.writeLongAttribute("modelSize", homePieceOfFurniture.getModelSize());
            xMLWriter.writeAttribute("description", homePieceOfFurniture.getDescription(), null);
            xMLWriter.writeAttribute("information", homePieceOfFurniture.getInformation(), null);
            xMLWriter.writeAttribute("license", homePieceOfFurniture.getLicense(), null);
            xMLWriter.writeBooleanAttribute("movable", homePieceOfFurniture.isMovable(), true);
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
                if (!(homePieceOfFurniture instanceof HomeDoorOrWindow)) {
                    xMLWriter.writeBooleanAttribute("doorOrWindow", homePieceOfFurniture.isDoorOrWindow(), false);
                    xMLWriter.writeBooleanAttribute("horizontallyRotatable", homePieceOfFurniture.isHorizontallyRotatable(), true);
                }
                xMLWriter.writeBooleanAttribute("resizable", homePieceOfFurniture.isResizable(), true);
                xMLWriter.writeBooleanAttribute("deformable", homePieceOfFurniture.isDeformable(), true);
                xMLWriter.writeBooleanAttribute("texturable", homePieceOfFurniture.isTexturable(), true);
            }
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                serializable = homePieceOfFurniture.getPrice();
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    if (homePieceOfFurniture2.getPrice() == null) continue;
                    serializable = null;
                    break;
                }
                xMLWriter.writeBigDecimalAttribute("price", (BigDecimal)serializable);
            } else {
                xMLWriter.writeBigDecimalAttribute("price", homePieceOfFurniture.getPrice());
                xMLWriter.writeBigDecimalAttribute("valueAddedTaxPercentage", homePieceOfFurniture.getValueAddedTaxPercentage());
                xMLWriter.writeAttribute("currency", homePieceOfFurniture.getCurrency(), null);
            }
            xMLWriter.writeAttribute("staircaseCutOutShape", homePieceOfFurniture.getStaircaseCutOutShape(), null);
            xMLWriter.writeFloatAttribute("dropOnTopElevation", homePieceOfFurniture.getDropOnTopElevation(), 1.0f);
            xMLWriter.writeBooleanAttribute("nameVisible", homePieceOfFurniture.isNameVisible(), false);
            xMLWriter.writeFloatAttribute("nameAngle", homePieceOfFurniture.getNameAngle(), 0.0f);
            xMLWriter.writeFloatAttribute("nameXOffset", homePieceOfFurniture.getNameXOffset(), 0.0f);
            xMLWriter.writeFloatAttribute("nameYOffset", homePieceOfFurniture.getNameYOffset(), 0.0f);
            if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                serializable = (HomeDoorOrWindow)homePieceOfFurniture;
                xMLWriter.writeFloatAttribute("wallThickness", ((HomeDoorOrWindow)serializable).getWallThickness(), 1.0f);
                xMLWriter.writeFloatAttribute("wallDistance", ((HomeDoorOrWindow)serializable).getWallDistance(), 0.0f);
                xMLWriter.writeFloatAttribute("wallWidth", ((HomeDoorOrWindow)serializable).getWallWidth(), 1.0f);
                xMLWriter.writeFloatAttribute("wallLeft", ((HomeDoorOrWindow)serializable).getWallLeft(), 0.0f);
                xMLWriter.writeFloatAttribute("wallHeight", ((HomeDoorOrWindow)serializable).getWallHeight(), 1.0f);
                xMLWriter.writeFloatAttribute("wallTop", ((HomeDoorOrWindow)serializable).getWallTop(), 0.0f);
                xMLWriter.writeAttribute("cutOutShape", ((HomeDoorOrWindow)serializable).getCutOutShape(), null);
                xMLWriter.writeBooleanAttribute("wallCutOutOnBothSides", ((HomeDoorOrWindow)serializable).isWallCutOutOnBothSides(), false);
                xMLWriter.writeBooleanAttribute("widthDepthDeformable", ((HomeDoorOrWindow)serializable).isWidthDepthDeformable(), true);
                xMLWriter.writeBooleanAttribute("boundToWall", ((HomeDoorOrWindow)serializable).isBoundToWall(), true);
            } else if (homePieceOfFurniture instanceof HomeLight) {
                xMLWriter.writeFloatAttribute("power", ((HomeLight)homePieceOfFurniture).getPower());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void writeChildren(XMLWriter xMLWriter, HomePieceOfFurniture homePieceOfFurniture) throws IOException {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    HomeXMLExporter.this.writePieceOfFurniture(xMLWriter, homePieceOfFurniture2);
                }
            } else if (homePieceOfFurniture instanceof HomeLight) {
                for (LightSource object : ((HomeLight)homePieceOfFurniture).getLightSources()) {
                    xMLWriter.writeStartElement("lightSource");
                    xMLWriter.writeFloatAttribute("x", object.getX());
                    xMLWriter.writeFloatAttribute("y", object.getY());
                    xMLWriter.writeFloatAttribute("z", object.getZ());
                    xMLWriter.writeColorAttribute("color", object.getColor());
                    xMLWriter.writeFloatAttribute("diameter", object.getDiameter());
                    xMLWriter.writeEndElement();
                }
                for (String i : ((HomeLight)homePieceOfFurniture).getLightSourceMaterialNames()) {
                    xMLWriter.writeStartElement("lightSourceMaterial");
                    xMLWriter.writeAttribute("name", i);
                    xMLWriter.writeEndElement();
                }
            } else if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                for (Sash homeMaterial : ((HomeDoorOrWindow)homePieceOfFurniture).getSashes()) {
                    xMLWriter.writeStartElement("sash");
                    xMLWriter.writeFloatAttribute("xAxis", homeMaterial.getXAxis());
                    xMLWriter.writeFloatAttribute("yAxis", homeMaterial.getYAxis());
                    xMLWriter.writeFloatAttribute("width", homeMaterial.getWidth());
                    xMLWriter.writeFloatAttribute("startAngle", homeMaterial.getStartAngle());
                    xMLWriter.writeFloatAttribute("endAngle", homeMaterial.getEndAngle());
                    xMLWriter.writeEndElement();
                }
            } else if (homePieceOfFurniture instanceof HomeShelfUnit) {
                BoxBounds[] boxBoundsArray;
                HomeShelfUnit homeShelfUnit = (HomeShelfUnit)homePieceOfFurniture;
                float[] fArray = homeShelfUnit.getShelfElevations();
                if (fArray != null) {
                    for (int i = 0; i < fArray.length; ++i) {
                        xMLWriter.writeStartElement("shelf");
                        xMLWriter.writeFloatAttribute("elevation", fArray[i]);
                        xMLWriter.writeEndElement();
                    }
                }
                if ((boxBoundsArray = homeShelfUnit.getShelfBoxes()) != null) {
                    void var6_21;
                    boolean transformation = false;
                    while (var6_21 < boxBoundsArray.length) {
                        xMLWriter.writeStartElement("shelf");
                        xMLWriter.writeFloatAttribute("xLower", boxBoundsArray[var6_21].getXLower());
                        xMLWriter.writeFloatAttribute("yLower", boxBoundsArray[var6_21].getYLower());
                        xMLWriter.writeFloatAttribute("zLower", boxBoundsArray[var6_21].getZLower());
                        xMLWriter.writeFloatAttribute("xUpper", boxBoundsArray[var6_21].getXUpper());
                        xMLWriter.writeFloatAttribute("yUpper", boxBoundsArray[var6_21].getYUpper());
                        xMLWriter.writeFloatAttribute("zUpper", boxBoundsArray[var6_21].getZUpper());
                        xMLWriter.writeEndElement();
                        ++var6_21;
                    }
                }
            }
            HomeXMLExporter.this.writeProperties(xMLWriter, homePieceOfFurniture);
            HomeXMLExporter.this.writeTextStyle(xMLWriter, homePieceOfFurniture.getNameStyle(), "nameStyle");
            HomeXMLExporter.this.writeTexture(xMLWriter, homePieceOfFurniture.getTexture(), null);
            if (homePieceOfFurniture.getModelMaterials() != null) {
                for (HomeMaterial homeMaterial : homePieceOfFurniture.getModelMaterials()) {
                    HomeXMLExporter.this.writeMaterial(xMLWriter, homeMaterial, homePieceOfFurniture.getModel());
                }
            }
            if (homePieceOfFurniture.getModelTransformations() != null) {
                for (Transformation transformation : homePieceOfFurniture.getModelTransformations()) {
                    xMLWriter.writeStartElement("transformation");
                    xMLWriter.writeAttribute("name", transformation.getName(), null);
                    float[][] fArray = transformation.getMatrix();
                    String string = HomeXMLExporter.floatToString(fArray[0][0]) + " " + HomeXMLExporter.floatToString(fArray[0][1]) + " " + HomeXMLExporter.floatToString(fArray[0][2]) + " " + HomeXMLExporter.floatToString(fArray[0][3]) + " " + HomeXMLExporter.floatToString(fArray[1][0]) + " " + HomeXMLExporter.floatToString(fArray[1][1]) + " " + HomeXMLExporter.floatToString(fArray[1][2]) + " " + HomeXMLExporter.floatToString(fArray[1][3]) + " " + HomeXMLExporter.floatToString(fArray[2][0]) + " " + HomeXMLExporter.floatToString(fArray[2][1]) + " " + HomeXMLExporter.floatToString(fArray[2][2]) + " " + HomeXMLExporter.floatToString(fArray[2][3]);
                    xMLWriter.writeAttribute("matrix", string);
                    xMLWriter.writeEndElement();
                }
            }
        }
    }
}

