"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DEFAULT_HEADERS = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const AD_API_ROUTE_PREFIX = exports.AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
const ALERTING_API_ROUTE_PREFIX = exports.ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
const API = exports.API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
const SEC_IN_MILLI_SECS = exports.SEC_IN_MILLI_SECS = 1000;
const MIN_IN_MILLI_SECS = exports.MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = exports.HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = exports.DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = exports.WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let SORT_DIRECTION = exports.SORT_DIRECTION = /*#__PURE__*/function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
  return SORT_DIRECTION;
}({});
let AD_DOC_FIELDS = exports.AD_DOC_FIELDS = /*#__PURE__*/function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
  return AD_DOC_FIELDS;
}({});
const MAX_DETECTORS = exports.MAX_DETECTORS = 1000;
const MAX_MONITORS = exports.MAX_MONITORS = 1000;
const MAX_ALERTS = exports.MAX_ALERTS = 1000;

// TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place
let DETECTOR_STATE = exports.DETECTOR_STATE = /*#__PURE__*/function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
  return DETECTOR_STATE;
}({});
let SAMPLE_TYPE = exports.SAMPLE_TYPE = /*#__PURE__*/function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
  return SAMPLE_TYPE;
}({});
const ENTITY_FIELD = exports.ENTITY_FIELD = 'entity';
const ENTITY_VALUE_PATH_FIELD = exports.ENTITY_VALUE_PATH_FIELD = 'entity.value';
const ENTITY_NAME_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = 'entity.name';
const MODEL_ID_FIELD = exports.MODEL_ID_FIELD = 'model_id';
const DOC_COUNT_FIELD = exports.DOC_COUNT_FIELD = 'doc_count';
const KEY_FIELD = exports.KEY_FIELD = 'key';
const ENTITY_LIST_FIELD = exports.ENTITY_LIST_FIELD = 'entity_list';
const MAX_ANOMALY_GRADE_FIELD = exports.MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade';

// y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>
const ENTITY_LIST_DELIMITER = exports.ENTITY_LIST_DELIMITER = '<br>';

// when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>
const HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CELL_ENTITY_DELIMITER = ', ';
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
const STACK_TRACE_PATTERN = exports.STACK_TRACE_PATTERN = '.java:';
const OPENSEARCH_EXCEPTION_PREFIX = exports.OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
const REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
const HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
const REALTIME_TASK_TYPES = exports.REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
const HISTORICAL_TASK_TYPES = exports.HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
const CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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