"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFloorPlotTime = exports.formatAnomalyNumber = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = exports.NO_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.CANT_FIND_KEY_WORD = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toFixedNumberForAnomaly = exports.toFixedNumber = exports.toCamel = exports.prettifyErrorMessage = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const SHOW_DECIMAL_NUMBER_THRESHOLD = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = 0.01;
function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    //@ts-ignore
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const getFloorPlotTime = plotTime => {
  return Math.floor(plotTime / _constants.MIN_IN_MILLI_SECS) * _constants.MIN_IN_MILLI_SECS;
};
exports.getFloorPlotTime = getFloorPlotTime;
const toFixedNumber = (num, digits, base) => {
  var pow = Math.pow(base || 10, digits || 2);
  return Math.round(num * pow) / pow;
};

// 1.If num>0.01, will keep two digits;
// 2.If num<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3
exports.toFixedNumber = toFixedNumber;
const toFixedNumberForAnomaly = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};
exports.toFixedNumberForAnomaly = toFixedNumberForAnomaly;
const formatAnomalyNumber = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? num.toFixed(2) : num.toExponential(2);
};
exports.formatAnomalyNumber = formatAnomalyNumber;
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const NO_PERMISSIONS_KEY_WORD = exports.NO_PERMISSIONS_KEY_WORD = 'no permissions';
const DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = 'does not have permissions';
const CANT_FIND_KEY_WORD = exports.CANT_FIND_KEY_WORD = "Can't find";
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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