"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/anomaly_detectors';
const AD_NODE_API = exports.AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`
});
const ALERTING_NODE_API = exports.ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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