# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy.core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "12.1.0",
                "commands": r"cc",
                "args": r"-march=armv7-a, -mfloat-abi=hard, -mfpu=neon, -O2, -pipe, -fstack-protector-strong, -fno-plt, -fexceptions, -Wp,-D_FORTIFY_SOURCE=2, -Wformat, -Werror=format-security, -fstack-clash-protection, -ffat-lto-objects",
                "linker args": r"-Wl,-O1,--sort-common,--as-needed,-z,relro,-z,now, -march=armv7-a, -mfloat-abi=hard, -mfpu=neon, -O2, -pipe, -fstack-protector-strong, -fno-plt, -fexceptions, -Wp,-D_FORTIFY_SOURCE=2, -Wformat, -Werror=format-security, -fstack-clash-protection, -ffat-lto-objects",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.10",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "12.1.0",
                "commands": r"c++",
                "args": r"-march=armv7-a, -mfloat-abi=hard, -mfpu=neon, -O2, -pipe, -fstack-protector-strong, -fno-plt, -fexceptions, -Wp,-D_FORTIFY_SOURCE=2, -Wformat, -Werror=format-security, -fstack-clash-protection, -Wp,-D_GLIBCXX_ASSERTIONS, -ffat-lto-objects",
                "linker args": r"-Wl,-O1,--sort-common,--as-needed,-z,relro,-z,now, -march=armv7-a, -mfloat-abi=hard, -mfpu=neon, -O2, -pipe, -fstack-protector-strong, -fno-plt, -fexceptions, -Wp,-D_FORTIFY_SOURCE=2, -Wformat, -Werror=format-security, -fstack-clash-protection, -Wp,-D_GLIBCXX_ASSERTIONS, -ffat-lto-objects",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "armv7l",
                "family": "arm",
                "endian": "little",
                "system": "linux",
            },
            "build": {
                "cpu": "armv7l",
                "family": "arm",
                "endian": "little",
                "system": "linux",
            },
            "cross-compiled": bool("False".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "cblas",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/include",
                "lib directory": r"/usr/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/lib/pkgconfig",
            },
            "lapack": {
                "name": "dep3034648672",
                "found": bool("True".lower().replace("false", "")),
                "version": "1.26.4",
                "detection method": "internal",
                "include directory": r"unknown",
                "lib directory": r"unknown",
                "openblas configuration": r"unknown",
                "pc file directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/usr/bin/python",
            "version": "3.12",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
