// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!
#ifndef _GTKMM_STRINGSORTER_H
#define _GTKMM_STRINGSORTER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/sorter.h>
#include <gtkmm/expression.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API StringSorter_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var Collation NONE
 * Don't do any collation.
 * 
 *  @var Collation UNICODE
 * Use glib_utf8_collate_key().
 * 
 *  @var Collation FILENAME
 * Use glib_utf8_collate_key_for_filename().
 * 
 *  @enum Collation
 * 
 * Describes how a Gtk::StringSorter turns strings into sort keys to
 * compare them.
 * 
 * Note that the result of sorting will in general depend on the current locale
 * unless the mode is @a GTK_COLLATION_NONE.
 * 
 * @newin{4,10}
 *
 * @ingroup gtkmmEnums
 */
enum class Collation
{
  NONE,
  UNICODE,
  FILENAME
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::Collation> : public Glib::Value_Enum<Gtk::Collation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/** Sort by comparing strings.
 *
 * %Gtk::StringSorter is a Gtk::Sorter that compares strings. It does the
 * comparison in a linguistically correct way using the current locale by
 * normalizing Unicode strings and possibly case-folding them before
 * performing the comparison.
 *
 * To obtain the strings to compare, this sorter evaluates a Gtk::Expression.
 *
 * @see Gtk::Expression
 * @ingroup ListView
 * @newin{3,98}
 */

class GTKMM_API StringSorter : public Sorter
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StringSorter;
  using CppClassType = StringSorter_Class;
  using BaseObjectType = GtkStringSorter;
  using BaseClassType = GtkStringSorterClass;

  // noncopyable
  StringSorter(const StringSorter&) = delete;
  StringSorter& operator=(const StringSorter&) = delete;

private:  friend class StringSorter_Class;
  static CppClassType stringsorter_class_;

protected:
  explicit StringSorter(const Glib::ConstructParams& construct_params);
  explicit StringSorter(GtkStringSorter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StringSorter(StringSorter&& src) noexcept;
  StringSorter& operator=(StringSorter&& src) noexcept;

  ~StringSorter() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkStringSorter*       gobj()       { return reinterpret_cast<GtkStringSorter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkStringSorter* gobj() const { return reinterpret_cast<GtkStringSorter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkStringSorter* gobj_copy();

private:

        
protected:
    explicit StringSorter(const Glib::RefPtr<Expression<Glib::ustring>>& expression);


public:
  
  static Glib::RefPtr<StringSorter> create(const Glib::RefPtr<Expression<Glib::ustring>>& expression);


  /** Gets the expression that is evaluated to obtain strings from items.
   * 
   * @return A `Gtk::Expression`.
   */
  Glib::RefPtr<Expression<Glib::ustring>> get_expression();
  
  /** Gets the expression that is evaluated to obtain strings from items.
   * 
   * @return A `Gtk::Expression`.
   */
  Glib::RefPtr<const Expression<Glib::ustring>> get_expression() const;
  
  /** Sets the expression that is evaluated to obtain strings from items.
   * 
   * The expression must have the type G_TYPE_STRING.
   * 
   * @param expression A `Gtk::Expression`.
   */
  void set_expression(const Glib::RefPtr<Expression<Glib::ustring>>& expression);
  
  /** Gets whether the sorter ignores case differences.
   * 
   * @return <tt>true</tt> if @a self is ignoring case differences.
   */
  bool get_ignore_case() const;
  
  /** Sets whether the sorter will ignore case differences.
   * 
   * @param ignore_case <tt>true</tt> to ignore case differences.
   */
  void set_ignore_case(bool ignore_case =  true);
  
  /** Sets the collation method to use for sorting.
   * 
   * @newin{4,10}
   * 
   * @param collation The collation method.
   */
  void set_collation(Collation collation);
  
  /** Gets which collation method the sorter uses.
   * 
   * @newin{4,10}
   * 
   * @return The collation method.
   */
  Collation get_collation() const;

  /** The expression to evaluate on item to get a string to compare with.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Expression<Glib::ustring>> > property_expression() ;

/** The expression to evaluate on item to get a string to compare with.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Expression<Glib::ustring>> > property_expression() const;

  /** If sorting is case sensitive.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_ignore_case() ;

/** If sorting is case sensitive.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_ignore_case() const;

  /** The collation method to use for sorting.
   * 
   * The `Gtk::Collation::NONE` value is useful when the expression already
   * returns collation keys, or strings that need to be compared byte-by-byte.
   * 
   * The default value, `Gtk::Collation::UNICODE`, compares strings according
   * to the [Unicode collation algorithm](https://www.unicode.org/reports/tr10/).
   * 
   * @newin{4,10}
   *
   * Default value: Gtk::Collation::UNICODE
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Collation > property_collation() ;

/** The collation method to use for sorting.
   * 
   * The `Gtk::Collation::NONE` value is useful when the expression already
   * returns collation keys, or strings that need to be compared byte-by-byte.
   * 
   * The default value, `Gtk::Collation::UNICODE`, compares strings according
   * to the [Unicode collation algorithm](https://www.unicode.org/reports/tr10/).
   * 
   * @newin{4,10}
   *
   * Default value: Gtk::Collation::UNICODE
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Collation > property_collation() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::StringSorter
   */
  GTKMM_API
  Glib::RefPtr<Gtk::StringSorter> wrap(GtkStringSorter* object, bool take_copy = false);
}


#endif /* _GTKMM_STRINGSORTER_H */

