/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DWGReadFormatRemover {
    private static final String underlineStrikeThrough = "((?:\\\\\\\\)+|\\\\[LlOoKk])";
    private static final String endMarks = "((?:\\\\\\\\)+|\\\\(?:A|H|pi|pxt|pxi|pt|X|Q|f|F|W|C|T)[^;]{0,100};)";
    private static final String newLine = "((?:\\\\\\\\)+|\\\\P)";
    private static final String stackFrac = "(\\\\\\\\)+|\\\\S([^/^#]{1,20})[/^#]([^;]{1,20});";
    private static final String curlyBraces = "(\\\\)+[{}]|([{}])";
    private static final String escapeChars = "(?<!\\\\)(\\\\)(?!\\\\)";

    public String cleanupDwgString(String dwgString) {
        String cleanString = dwgString;
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(underlineStrikeThrough).matcher(cleanString);
        while (m.find()) {
            if (m.group(1).endsWith("\\")) continue;
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        cleanString = sb.toString();
        m = Pattern.compile(endMarks).matcher(cleanString);
        sb.setLength(0);
        while (m.find()) {
            if (m.group(1).endsWith("\\")) continue;
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        cleanString = sb.toString();
        m = Pattern.compile(newLine).matcher(cleanString);
        sb.setLength(0);
        while (m.find()) {
            if (!m.group(1).endsWith("P")) continue;
            m.appendReplacement(sb, "\n");
        }
        m.appendTail(sb);
        cleanString = sb.toString();
        m = Pattern.compile(stackFrac).matcher(cleanString);
        sb.setLength(0);
        while (m.find()) {
            if (m.group(1) != null) continue;
            m.appendReplacement(sb, m.group(2) + "/" + m.group(3));
        }
        m.appendTail(sb);
        cleanString = sb.toString();
        m = Pattern.compile(curlyBraces).matcher(cleanString);
        sb.setLength(0);
        while (m.find()) {
            if (m.group(1) != null) continue;
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        cleanString = sb.toString();
        cleanString = cleanString.replaceAll(escapeChars, "");
        cleanString = cleanString.replaceAll("(\\\\\\\\)", "\\\\");
        return cleanString;
    }
}

