/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class ChunkerParameterParser {
    private ChunkerParameterParser() {
    }

    public static String parseStringParameter(Map<String, Object> parameters, String fieldName, String defaultValue) {
        if (!parameters.containsKey(fieldName)) {
            return defaultValue;
        }
        Object fieldValue = parameters.get(fieldName);
        if (!(fieldValue instanceof String)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", fieldName, String.class.getName()));
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue.toString())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] should not be empty.", fieldName));
        }
        return fieldValue.toString();
    }

    public static int parseIntegerParameter(Map<String, Object> parameters, String fieldName, int defaultValue) {
        if (!parameters.containsKey(fieldName)) {
            return defaultValue;
        }
        String fieldValueString = parameters.get(fieldName).toString();
        try {
            return NumberUtils.createInteger((String)fieldValueString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", fieldName, Integer.class.getName()));
        }
    }

    public static int parsePositiveIntegerParameter(Map<String, Object> parameters, String fieldName, int defaultValue) {
        int fieldValueInt = ChunkerParameterParser.parseIntegerParameter(parameters, fieldName, defaultValue);
        if (fieldValueInt <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be positive.", fieldName));
        }
        return fieldValueInt;
    }

    public static double parseDoubleParameter(Map<String, Object> parameters, String fieldName, double defaultValue) {
        if (!parameters.containsKey(fieldName)) {
            return defaultValue;
        }
        String fieldValueString = parameters.get(fieldName).toString();
        try {
            return NumberUtils.createDouble((String)fieldValueString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", fieldName, Double.class.getName()));
        }
    }
}

