/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.indices.IndicesService;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.Processor;
import org.opensearch.neuralsearch.processor.TextChunkingProcessor;

public class TextChunkingProcessorFactory
implements Processor.Factory {
    private final Environment environment;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AnalysisRegistry analysisRegistry;

    public TextChunkingProcessorFactory(Environment environment, ClusterService clusterService, IndicesService indicesService, AnalysisRegistry analysisRegistry) {
        this.environment = environment;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.analysisRegistry = analysisRegistry;
    }

    public TextChunkingProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
        Map fieldMap = ConfigurationUtils.readMap((String)"text_chunking", (String)processorTag, config, (String)"field_map");
        Map algorithmMap = ConfigurationUtils.readMap((String)"text_chunking", (String)processorTag, config, (String)"algorithm");
        return new TextChunkingProcessor(processorTag, description, fieldMap, algorithmMap, this.environment, this.clusterService, this.indicesService, this.analysisRegistry);
    }
}

