/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.model.BranchableSyntheticPsiElement;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightRecordMethod
extends LightMethod
implements BranchableSyntheticPsiElement,
LightRecordMember {
    @NotNull
    private final PsiRecordComponent myRecordComponent;

    public LightRecordMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull PsiRecordComponent component) {
        if (manager == null) {
            LightRecordMethod.$$$reportNull$$$0(0);
        }
        if (method == null) {
            LightRecordMethod.$$$reportNull$$$0(1);
        }
        if (containingClass == null) {
            LightRecordMethod.$$$reportNull$$$0(2);
        }
        if (component == null) {
            LightRecordMethod.$$$reportNull$$$0(3);
        }
        super(manager, method, containingClass);
        this.myRecordComponent = component;
    }

    @Override
    @NotNull
    public PsiRecordComponent getRecordComponent() {
        PsiRecordComponent psiRecordComponent = this.myRecordComponent;
        if (psiRecordComponent == null) {
            LightRecordMethod.$$$reportNull$$$0(4);
        }
        return psiRecordComponent;
    }

    @Override
    public int getTextOffset() {
        return this.myRecordComponent.getTextOffset();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myRecordComponent.getNavigationElement();
        if (psiElement == null) {
            LightRecordMethod.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass.getContainingFile();
    }

    @Override
    public PsiType getReturnType() {
        if (DumbService.isDumb(this.myRecordComponent.getProject())) {
            return this.myRecordComponent.getType();
        }
        return (PsiType)CachedValuesManager.getCachedValue(this, () -> {
            PsiType type2 = this.myRecordComponent.getType().annotate(() -> (PsiAnnotation[])Arrays.stream(this.myRecordComponent.getAnnotations()).filter(LightRecordMethod::hasTargetApplicableForMethod).toArray(PsiAnnotation[]::new));
            return CachedValueProvider.Result.create(type2, this);
        });
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiType returnType2 = this.getReturnType();
        if (returnType2 == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                LightRecordMethod.$$$reportNull$$$0(6);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = returnType2.getAnnotations();
        if (psiAnnotationArray == null) {
            LightRecordMethod.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean hasAnnotation(@NotNull String fqn) {
        PsiType returnType2;
        if (fqn == null) {
            LightRecordMethod.$$$reportNull$$$0(8);
        }
        return (returnType2 = this.getReturnType()) != null && returnType2.hasAnnotation(fqn);
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        PsiType returnType2;
        if (fqn == null) {
            LightRecordMethod.$$$reportNull$$$0(9);
        }
        if ((returnType2 = this.getReturnType()) == null) {
            return null;
        }
        return returnType2.findAnnotation(fqn);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, PlatformIcons.METHOD_ICON, ElementPresentationUtil.getFlags(this, false));
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(4, baseIcon);
        }
        return baseIcon;
    }

    @NotNull
    public LightRecordMethod obtainBranchCopy(@NotNull ModelBranch branch) {
        if (branch == null) {
            LightRecordMethod.$$$reportNull$$$0(10);
        }
        PsiClass recordCopy = branch.obtainPsiCopy(this.myContainingClass);
        PsiMethod accessorCopy = recordCopy.findMethodBySignature(this, false);
        assert (accessorCopy instanceof LightRecordMethod);
        LightRecordMethod lightRecordMethod = (LightRecordMethod)accessorCopy;
        if (lightRecordMethod == null) {
            LightRecordMethod.$$$reportNull$$$0(11);
        }
        return lightRecordMethod;
    }

    @Override
    @Nullable
    public ModelBranch getModelBranch() {
        return ModelBranch.getPsiBranch(this.myRecordComponent);
    }

    private static boolean hasTargetApplicableForMethod(PsiAnnotation annotation2) {
        return AnnotationTargetUtil.findAnnotationTarget(annotation2, PsiAnnotation.TargetType.TYPE_USE, PsiAnnotation.TargetType.METHOD) != null;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            LightRecordMethod.$$$reportNull$$$0(12);
        }
        return this.myRecordComponent.setName(name2);
    }

    @Override
    public PsiElement copy() {
        return this.myMethod.copy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightRecordMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightRecordMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainBranchCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "obtainBranchCopy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

